/*
 * Decompiled with CFR 0.152.
 */
package mondrian.olap.type;

import java.util.ArrayList;
import java.util.Arrays;
import mondrian.olap.Dimension;
import mondrian.olap.Hierarchy;
import mondrian.olap.Level;
import mondrian.olap.type.MemberType;
import mondrian.olap.type.ScalarType;
import mondrian.olap.type.Type;
import mondrian.resource.MondrianResource;

public class TupleType
implements Type {
    public final Type[] elementTypes;
    private final String digest;

    public TupleType(Type[] elementTypes) {
        assert (elementTypes != null);
        this.elementTypes = (Type[])elementTypes.clone();
        StringBuilder buf = new StringBuilder();
        buf.append("TupleType<");
        int k = 0;
        for (Type elementType : elementTypes) {
            if (k++ > 0) {
                buf.append(", ");
            }
            buf.append(elementType);
        }
        buf.append(">");
        this.digest = buf.toString();
    }

    public String toString() {
        return this.digest;
    }

    public boolean equals(Object obj) {
        if (obj instanceof TupleType) {
            TupleType that = (TupleType)obj;
            return Arrays.equals(this.elementTypes, that.elementTypes);
        }
        return false;
    }

    public int hashCode() {
        return this.digest.hashCode();
    }

    public boolean usesDimension(Dimension dimension, boolean definitely) {
        for (Type elementType : this.elementTypes) {
            if (!elementType.usesDimension(dimension, definitely)) continue;
            return true;
        }
        return false;
    }

    public Dimension getDimension() {
        throw new UnsupportedOperationException();
    }

    public Hierarchy getHierarchy() {
        throw new UnsupportedOperationException();
    }

    public Level getLevel() {
        throw new UnsupportedOperationException();
    }

    public Type getValueType() {
        for (Type elementType : this.elementTypes) {
            MemberType memberType;
            Dimension dimension;
            if (!(elementType instanceof MemberType) || (dimension = (memberType = (MemberType)elementType).getDimension()) == null || !dimension.isMeasures()) continue;
            return memberType.getValueType();
        }
        return new ScalarType();
    }

    public Type computeCommonType(Type type, int[] conversionCount) {
        if (type instanceof ScalarType) {
            return this.getValueType().computeCommonType(type, conversionCount);
        }
        if (type instanceof MemberType) {
            return this.commonTupleType(new TupleType(new Type[]{type}), conversionCount);
        }
        if (!(type instanceof TupleType)) {
            return null;
        }
        return this.commonTupleType(type, conversionCount);
    }

    private Type commonTupleType(Type type, int[] conversionCount) {
        TupleType that = (TupleType)type;
        if (this.elementTypes.length < that.elementTypes.length) {
            return this.createCommonTupleType(that, conversionCount);
        }
        return that.createCommonTupleType(this, conversionCount);
    }

    private Type createCommonTupleType(TupleType that, int[] conversionCount) {
        int i;
        ArrayList<Type> elementTypes = new ArrayList<Type>();
        for (i = 0; i < this.elementTypes.length; ++i) {
            Type commonType = this.elementTypes[i].computeCommonType(that.elementTypes[i], conversionCount);
            elementTypes.add(commonType);
            if (commonType != null) continue;
            return null;
        }
        if (elementTypes.size() < that.elementTypes.length) {
            for (i = elementTypes.size(); i < that.elementTypes.length; ++i) {
                elementTypes.add(new ScalarType());
            }
        }
        return new TupleType(elementTypes.toArray(new Type[elementTypes.size()]));
    }

    public static void checkDimensions(MemberType[] memberTypes) {
        for (int i = 0; i < memberTypes.length; ++i) {
            MemberType memberType = memberTypes[i];
            for (int j = 0; j < i; ++j) {
                MemberType member1 = memberTypes[j];
                Dimension dimension = memberType.getDimension();
                Dimension dimension1 = member1.getDimension();
                if (dimension == null || dimension != dimension1) continue;
                throw MondrianResource.instance().DupDimensionsInTuple.ex(dimension.getUniqueName());
            }
        }
    }
}

