/*
 * Decompiled with CFR 0.152.
 */
package mondrian.rolap;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import javax.sql.DataSource;
import mondrian.olap.Evaluator;
import mondrian.olap.Member;
import mondrian.olap.Query;
import mondrian.olap.Util;
import mondrian.olap.fun.FunUtil;
import mondrian.rolap.BitKey;
import mondrian.rolap.ResultLoader;
import mondrian.rolap.RolapAggregationManager;
import mondrian.rolap.RolapBaseCubeMeasure;
import mondrian.rolap.RolapCube;
import mondrian.rolap.RolapCubeLevel;
import mondrian.rolap.RolapLevel;
import mondrian.rolap.RolapMember;
import mondrian.rolap.RolapStar;
import mondrian.rolap.RolapUtil;
import mondrian.rolap.SqlContextConstraint;
import mondrian.rolap.SqlStatement;
import mondrian.rolap.SqlTupleReader;
import mondrian.rolap.Target;
import mondrian.rolap.TupleReader;
import mondrian.rolap.agg.AggregationManager;
import mondrian.rolap.agg.CellRequest;
import mondrian.rolap.aggmatcher.AggStar;
import mondrian.rolap.sql.SqlQuery;
import mondrian.rolap.sql.TupleConstraint;
import mondrian.util.TraversalList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HighCardSqlTupleReader
extends SqlTupleReader {
    private ResultLoader resultLoader;
    private boolean moreRows;
    private final List<Target> targets = new ArrayList<Target>();
    int maxRows = 0;

    public HighCardSqlTupleReader(TupleConstraint constraint) {
        super(constraint);
    }

    @Override
    public void addLevelMembers(RolapLevel level, TupleReader.MemberBuilder memberBuilder, List<RolapMember> srcMembers) {
        this.targets.add(new Target(level, memberBuilder, srcMembers, this.constraint, this));
    }

    @Override
    public Object getCacheKey() {
        ArrayList<Object> key = new ArrayList<Object>();
        key.add(this.constraint.getCacheKey());
        key.add(SqlTupleReader.class);
        for (Target target : this.targets) {
            if (target.getSrcMembers() == null) continue;
            key.add(target.getLevel());
        }
        return key;
    }

    @Override
    public int getEnumTargetCount() {
        int enumTargetCount = 0;
        for (Target target : this.targets) {
            if (target.getSrcMembers() == null) continue;
            ++enumTargetCount;
        }
        return enumTargetCount;
    }

    @Override
    protected void prepareTuples(DataSource dataSource, List<List<RolapMember>> partialResult, List<List<RolapMember>> newPartialResult) {
        String message = "Populating member cache with members for " + this.targets;
        SqlStatement stmt = null;
        boolean execQuery = partialResult == null;
        try {
            ResultSet resultSet;
            if (execQuery) {
                ArrayList<Target> partialTargets = new ArrayList<Target>();
                for (Target target : this.targets) {
                    if (target.getSrcMembers() != null) continue;
                    partialTargets.add(target);
                }
                String sql = this.makeLevelMembersSql(dataSource);
                stmt = RolapUtil.executeQuery(dataSource, sql, this.maxRows, "HighCardSqlTupleReader.readTuples " + partialTargets, message, -1, -1);
                resultSet = stmt.getResultSet();
            } else {
                resultSet = null;
            }
            for (Target target : this.targets) {
                target.open();
            }
            int enumTargetCount = this.getEnumTargetCount();
            int[] srcMemberIdxes = null;
            if (enumTargetCount > 0) {
                srcMemberIdxes = new int[enumTargetCount];
            }
            int currPartialResultIdx = 0;
            if (execQuery) {
                this.moreRows = resultSet.next();
                if (this.moreRows) {
                    ++stmt.rowCount;
                }
            } else {
                this.moreRows = currPartialResultIdx < partialResult.size();
            }
            this.resultLoader = new ResultLoader(enumTargetCount, this.targets, stmt, resultSet, execQuery, partialResult, newPartialResult);
            this.readNextTuple();
            this.readNextTuple();
        }
        catch (SQLException sqle) {
            if (stmt != null) {
                throw stmt.handle(sqle);
            }
            throw Util.newError(sqle, message);
        }
    }

    @Override
    public List<RolapMember> readMembers(DataSource dataSource, List<List<RolapMember>> partialResult, List<List<RolapMember>> newPartialResult) {
        this.prepareTuples(dataSource, partialResult, newPartialResult);
        assert (this.targets.size() == 1);
        return this.targets.get(0).close();
    }

    @Override
    public List<RolapMember[]> readTuples(DataSource jdbcConnection, List<List<RolapMember>> partialResult, List<List<RolapMember>> newPartialResult) {
        this.prepareTuples(jdbcConnection, partialResult, newPartialResult);
        int n = this.targets.size();
        List[] lists = new List[n];
        for (int i = 0; i < n; ++i) {
            lists[i] = this.targets.get(i).close();
        }
        TraversalList<RolapMember> tupleList = new TraversalList<RolapMember>(lists, RolapMember.class);
        int enumTargetCount = this.getEnumTargetCount();
        if (enumTargetCount > 0) {
            FunUtil.hierarchizeTupleList(Util.cast(tupleList), false, n);
        }
        return tupleList;
    }

    public void noMoreRows() {
        this.moreRows = false;
    }

    public boolean readNextTuple() {
        if (!this.moreRows) {
            return false;
        }
        try {
            this.moreRows = this.resultLoader.loadResult();
        }
        catch (SQLException sqle) {
            this.moreRows = false;
            throw this.resultLoader.handle(sqle);
        }
        if (!this.moreRows) {
            this.resultLoader.close();
        }
        return this.moreRows;
    }

    @Override
    public void setMaxRows(int maxRows) {
        this.maxRows = maxRows;
    }

    @Override
    public int getMaxRows() {
        return this.maxRows;
    }

    private String makeLevelMembersSql(DataSource dataSource) {
        Query query;
        SqlContextConstraint sqlConstraint;
        RolapCube cube = null;
        boolean virtualCube = false;
        if (this.constraint instanceof SqlContextConstraint && (sqlConstraint = (SqlContextConstraint)this.constraint).isJoinRequired()) {
            query = this.constraint.getEvaluator().getQuery();
            cube = (RolapCube)query.getCube();
            virtualCube = cube.isVirtual();
        }
        if (virtualCube) {
            StringBuffer selectString = new StringBuffer();
            query = this.constraint.getEvaluator().getQuery();
            List<RolapCube> baseCubes = query.getBaseCubes();
            int k = -1;
            for (RolapCube baseCube : baseCubes) {
                boolean finalSelect = ++k == baseCubes.size() - 1;
                SqlTupleReader.WhichSelect whichSelect = finalSelect ? SqlTupleReader.WhichSelect.LAST : SqlTupleReader.WhichSelect.NOT_LAST;
                selectString.append(this.generateSelectForLevels(dataSource, baseCube, whichSelect));
                if (finalSelect) continue;
                selectString.append(" union ");
            }
            return selectString.toString();
        }
        return this.generateSelectForLevels(dataSource, cube, SqlTupleReader.WhichSelect.ONLY);
    }

    private String generateSelectForLevels(DataSource dataSource, RolapCube baseCube, SqlTupleReader.WhichSelect whichSelect) {
        String s = "while generating query to retrieve members of level(s) " + this.targets;
        SqlQuery sqlQuery = SqlQuery.newQuery(dataSource, s);
        Evaluator evaluator = this.getEvaluator(this.constraint);
        AggStar aggStar = this.chooseAggStar(evaluator);
        for (Target target : this.targets) {
            if (target.getSrcMembers() != null) continue;
            this.addLevelMemberSql(sqlQuery, target.getLevel(), baseCube, whichSelect, aggStar);
        }
        this.constraint.addConstraint(sqlQuery, baseCube, aggStar);
        return sqlQuery.toString();
    }

    private AggStar chooseAggStar(Evaluator evaluator) {
        RolapStar.Column[] columns;
        if (evaluator == null) {
            return null;
        }
        RolapCube cube = (RolapCube)evaluator.getCube();
        if (cube.isVirtual()) {
            return null;
        }
        RolapStar star = cube.getStar();
        int starColumnCount = star.getColumnCount();
        BitKey measureBitKey = BitKey.Factory.makeBitKey(starColumnCount);
        BitKey levelBitKey = BitKey.Factory.makeBitKey(starColumnCount);
        Member[] members = evaluator.getMembers();
        if (!(members[0] instanceof RolapBaseCubeMeasure)) {
            return null;
        }
        RolapBaseCubeMeasure measure = (RolapBaseCubeMeasure)members[0];
        int bitPosition = ((RolapStar.Measure)measure.getStarMeasure()).getBitPosition();
        CellRequest request = RolapAggregationManager.makeRequest(members);
        if (request == null) {
            return null;
        }
        for (RolapStar.Column column1 : columns = request.getConstrainedColumns()) {
            levelBitKey.set(column1.getBitPosition());
        }
        for (Target target : this.targets) {
            RolapLevel level = target.getLevel();
            if (level.isAll()) continue;
            RolapStar.Column column = ((RolapCubeLevel)level).getStarKeyColumn();
            levelBitKey.set(column.getBitPosition());
        }
        measureBitKey.set(bitPosition);
        AggStar aggStar = AggregationManager.instance().findAgg(star, levelBitKey, measureBitKey, new boolean[]{false});
        if (aggStar == null) {
            return null;
        }
        for (Target target : this.targets) {
            RolapLevel level = target.getLevel();
            if (level.isAll() || !this.isLevelCollapsed(aggStar, (RolapCubeLevel)level) || !this.levelContainsMultipleColumns(level)) continue;
            return null;
        }
        return aggStar;
    }
}

