/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.data;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.Date;
import java.util.LinkedHashMap;
import jxl.Cell;
import jxl.Sheet;
import jxl.Workbook;
import jxl.read.biff.BiffException;
import net.sf.jasperreports.engine.DefaultJasperReportsContext;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRField;
import net.sf.jasperreports.engine.JRRuntimeException;
import net.sf.jasperreports.engine.JasperReportsContext;
import net.sf.jasperreports.engine.data.AbstractXlsDataSource;
import net.sf.jasperreports.engine.util.FormatUtils;
import net.sf.jasperreports.repo.RepositoryUtil;

public class JRXlsDataSource
extends AbstractXlsDataSource {
    private Workbook workbook;
    private int sheetIndex = -1;
    private int recordIndex = -1;
    private InputStream inputStream;
    private boolean closeWorkbook;
    private boolean closeInputStream;

    public JRXlsDataSource(Workbook workbook) {
        this.workbook = workbook;
        this.closeWorkbook = false;
    }

    public JRXlsDataSource(InputStream is) throws JRException, IOException {
        try {
            this.inputStream = is;
            this.workbook = Workbook.getWorkbook((InputStream)is);
            this.closeWorkbook = true;
            this.closeInputStream = false;
        }
        catch (BiffException e) {
            throw new JRException(e);
        }
    }

    public JRXlsDataSource(File file) throws JRException, FileNotFoundException, IOException {
        this(new FileInputStream(file));
        this.closeInputStream = true;
    }

    public JRXlsDataSource(JasperReportsContext jasperReportsContext, String location) throws JRException, IOException {
        this(RepositoryUtil.getInstance(jasperReportsContext).getInputStreamFromLocation(location));
        this.closeInputStream = true;
    }

    public JRXlsDataSource(String location) throws JRException, IOException {
        this(DefaultJasperReportsContext.getInstance(), location);
    }

    @Override
    public boolean next() throws JRException {
        if (this.workbook != null) {
            if (this.sheetIndex < 0) {
                if (this.sheetSelection == null) {
                    this.sheetIndex = 0;
                } else {
                    try {
                        this.sheetIndex = Integer.parseInt(this.sheetSelection);
                        if (this.sheetIndex < 0 || this.sheetIndex > this.workbook.getNumberOfSheets() - 1) {
                            throw new JRRuntimeException("Sheet index " + this.sheetIndex + " is out of range: [0.." + (this.workbook.getNumberOfSheets() - 1) + "]");
                        }
                    }
                    catch (NumberFormatException e) {
                        // empty catch block
                    }
                    if (this.sheetIndex < 0) {
                        for (int i = 0; i < this.workbook.getSheets().length; ++i) {
                            if (!this.sheetSelection.equals(this.workbook.getSheet(i).getName())) continue;
                            this.sheetIndex = i;
                            break;
                        }
                        if (this.sheetIndex < 0) {
                            throw new JRRuntimeException("Sheet '" + this.sheetSelection + "' not found in workbook.");
                        }
                    }
                }
            }
            ++this.recordIndex;
            if (this.sheetSelection == null && this.recordIndex > this.workbook.getSheet(this.sheetIndex).getRows() - 1 && this.sheetIndex + 1 < this.workbook.getNumberOfSheets() && this.workbook.getSheet(this.sheetIndex + 1).getRows() > 0) {
                ++this.sheetIndex;
                this.recordIndex = -1;
                return this.next();
            }
            if ((this.sheetSelection != null || this.sheetIndex == 0) && this.useFirstRowAsHeader && this.recordIndex == 0) {
                this.readHeader();
                ++this.recordIndex;
            }
            if (this.recordIndex <= this.workbook.getSheet(this.sheetIndex).getRows() - 1) {
                return true;
            }
            if (this.closeWorkbook) {
                this.workbook.close();
            }
        }
        return false;
    }

    @Override
    public void moveFirst() {
        this.recordIndex = -1;
        this.sheetIndex = -1;
    }

    @Override
    public Object getFieldValue(JRField jrField) throws JRException {
        String fieldName = jrField.getName();
        Integer columnIndex = (Integer)this.columnNames.get(fieldName);
        if (columnIndex == null && fieldName.startsWith("COLUMN_")) {
            columnIndex = Integer.valueOf(fieldName.substring(7));
        }
        if (columnIndex == null) {
            throw new JRException("Unknown column name : " + fieldName);
        }
        Sheet sheet = this.workbook.getSheet(this.sheetIndex);
        Cell cell = sheet.getCell(columnIndex.intValue(), this.recordIndex);
        String fieldValue = cell.getContents();
        Class<?> valueClass = jrField.getValueClass();
        if (valueClass.equals(String.class)) {
            return fieldValue;
        }
        if ((fieldValue = fieldValue.trim()).length() == 0) {
            return null;
        }
        try {
            if (valueClass.equals(Boolean.class)) {
                return this.convertStringValue(fieldValue, valueClass);
            }
            if (Number.class.isAssignableFrom(valueClass)) {
                if (this.numberFormat != null) {
                    return FormatUtils.getFormattedNumber(this.numberFormat, fieldValue, valueClass);
                }
                return this.convertStringValue(fieldValue, valueClass);
            }
            if (Date.class.isAssignableFrom(valueClass)) {
                if (this.dateFormat != null) {
                    return FormatUtils.getFormattedDate(this.dateFormat, fieldValue, valueClass);
                }
                return this.convertStringValue(fieldValue, valueClass);
            }
            throw new JRException("Field '" + jrField.getName() + "' is of class '" + valueClass.getName() + "' and can not be converted");
        }
        catch (Exception e) {
            throw new JRException("Unable to get value for field '" + jrField.getName() + "' of class '" + valueClass.getName() + "'", e);
        }
    }

    private void readHeader() {
        Sheet sheet = this.workbook.getSheet(this.sheetSelection != null ? this.sheetIndex : 0);
        if (this.columnNames.size() == 0) {
            for (int columnIndex = 0; columnIndex < sheet.getColumns(); ++columnIndex) {
                Cell cell = sheet.getCell(columnIndex, this.recordIndex);
                String columnName = cell.getContents();
                if (columnName != null && columnName.trim().length() > 0) {
                    this.columnNames.put(columnName, columnIndex);
                    continue;
                }
                this.columnNames.put("COLUMN_" + columnIndex, columnIndex);
            }
        } else {
            LinkedHashMap<String, Integer> newColumnNames = new LinkedHashMap<String, Integer>();
            for (Integer columnIndex : this.columnNames.values()) {
                Cell cell = sheet.getCell(columnIndex.intValue(), this.recordIndex);
                String columnName = cell.getContents();
                newColumnNames.put(columnName, columnIndex);
            }
            this.columnNames = newColumnNames;
        }
    }

    @Override
    public void close() {
        try {
            if (this.closeInputStream) {
                this.inputStream.close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    @Override
    protected void checkReadStarted() {
        if (this.sheetIndex >= 0) {
            throw new JRRuntimeException("Cannot modify data source properties after data reading has started.");
        }
    }
}

