/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.export;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.sf.jasperreports.engine.DefaultJasperReportsContext;
import net.sf.jasperreports.engine.JRAbstractExporter;
import net.sf.jasperreports.engine.JRPrintElement;
import net.sf.jasperreports.engine.JRPrintPage;
import net.sf.jasperreports.engine.JRPrintText;
import net.sf.jasperreports.engine.JasperReportsContext;
import net.sf.jasperreports.engine.export.JRAbstractCsvExporter;
import net.sf.jasperreports.engine.export.JRCsvExporterContext;
import net.sf.jasperreports.engine.export.JRExportProgressMonitor;
import net.sf.jasperreports.engine.util.JRStringUtil;
import net.sf.jasperreports.engine.util.JRStyledText;
import net.sf.jasperreports.export.CsvExporterConfiguration;
import net.sf.jasperreports.export.CsvMetadataExporterConfiguration;
import net.sf.jasperreports.export.CsvMetadataReportConfiguration;
import net.sf.jasperreports.export.parameters.ParametersWriterExporterOutput;

public class JRCsvMetadataExporter
extends JRAbstractCsvExporter<CsvMetadataReportConfiguration, CsvMetadataExporterConfiguration, JRCsvExporterContext> {
    public static final String PROPERTY_COLUMN_NAME = "net.sf.jasperreports.export.csv.column.name";
    public static final String PROPERTY_REPEAT_VALUE = "net.sf.jasperreports.export.csv.repeat.value";
    public static final String PROPERTY_DATA = "net.sf.jasperreports.export.csv.data";
    protected List<String> columnNames;
    boolean isFirstRow = true;

    public JRCsvMetadataExporter() {
        this(DefaultJasperReportsContext.getInstance());
    }

    public JRCsvMetadataExporter(JasperReportsContext jasperReportsContext) {
        super(jasperReportsContext);
        this.exporterContext = new ExporterContext();
    }

    @Override
    protected Class<CsvMetadataExporterConfiguration> getConfigurationInterface() {
        return CsvMetadataExporterConfiguration.class;
    }

    @Override
    protected Class<CsvMetadataReportConfiguration> getItemConfigurationInterface() {
        return CsvMetadataReportConfiguration.class;
    }

    @Override
    protected void ensureOutput() {
        if (this.exporterOutput == null) {
            this.exporterOutput = new ParametersWriterExporterOutput(this.getJasperReportsContext(), this.getParameters(), this.getCurrentJasperPrint());
        }
    }

    @Override
    protected void exportPage(JRPrintPage page) throws IOException {
        JRExportProgressMonitor progressMonitor;
        List<JRPrintElement> elements = page.getElements();
        HashMap<String, String> currentRow = new HashMap<String, String>();
        HashMap<String, String> repeatedValues = new HashMap<String, String>();
        CsvMetadataReportConfiguration configuration = (CsvMetadataReportConfiguration)this.getCurrentItemConfiguration();
        boolean hasDefinedColumns = this.columnNames != null;
        String currentTextValue = null;
        for (int i = 0; i < elements.size(); ++i) {
            JRStyledText styledText;
            JRPrintText textElement;
            JRPrintElement element = elements.get(i);
            if (!(element instanceof JRPrintText) || (textElement = (JRPrintText)element).getPropertiesMap().getPropertyNames().length <= 0) continue;
            String currentColumnName = textElement.getPropertiesMap().getProperty(PROPERTY_COLUMN_NAME);
            String currentColumnData = textElement.getPropertiesMap().getProperty(PROPERTY_DATA);
            boolean repeatValue = this.getPropertiesUtil().getBooleanProperty(textElement, PROPERTY_REPEAT_VALUE, false);
            currentTextValue = currentColumnData != null ? currentColumnData : ((styledText = this.getStyledText((JRPrintText)element)) != null ? styledText.getText() : "");
            if (!hasDefinedColumns) {
                if (this.columnNames == null) {
                    this.columnNames = new ArrayList<String>();
                }
                if (currentColumnName != null && currentColumnName.length() > 0 && !this.columnNames.contains(currentColumnName)) {
                    this.columnNames.add(currentColumnName);
                }
            }
            if (this.columnNames.size() <= 0) continue;
            if (this.columnNames.contains(currentColumnName) && !currentRow.containsKey(currentColumnName) && this.isColumnReadOnTime(currentRow, currentColumnName)) {
                currentRow.put(currentColumnName, currentTextValue);
            } else if (this.columnNames.contains(currentColumnName) && !currentRow.containsKey(currentColumnName) && !this.isColumnReadOnTime(currentRow, currentColumnName) || this.columnNames.contains(currentColumnName) && currentRow.containsKey(currentColumnName)) {
                if (this.isFirstRow && configuration.isWriteHeader().booleanValue()) {
                    this.writeReportHeader();
                }
                this.isFirstRow = false;
                this.writeCurrentRow(currentRow, repeatedValues);
                currentRow = new HashMap();
                currentRow.put(currentColumnName, currentTextValue);
            }
            if (!repeatValue || currentColumnName == null || currentColumnName.length() <= 0 || currentTextValue.length() <= 0) continue;
            repeatedValues.put(currentColumnName, currentTextValue);
        }
        if (this.columnNames != null && this.columnNames.size() > 0) {
            this.writeCurrentRow(currentRow, repeatedValues);
        }
        if ((progressMonitor = configuration.getProgressMonitor()) != null) {
            progressMonitor.afterPageExport();
        }
    }

    @Override
    protected void initExport() {
        super.initExport();
    }

    @Override
    protected void initReport() {
        super.initReport();
        CsvMetadataReportConfiguration configuration = (CsvMetadataReportConfiguration)this.getCurrentItemConfiguration();
        this.columnNames = JRStringUtil.split(configuration.getColumnNames(), ",");
        this.isFirstRow = true;
    }

    protected void writeReportHeader() throws IOException {
        CsvExporterConfiguration configuration = (CsvExporterConfiguration)this.getCurrentConfiguration();
        String fieldDelimiter = configuration.getFieldDelimiter();
        String recordDelimiter = configuration.getRecordDelimiter();
        StringBuffer rowBuffer = new StringBuffer();
        for (int i = 0; i < this.columnNames.size(); ++i) {
            rowBuffer.append(this.columnNames.get(i));
            if (i < this.columnNames.size() - 1) {
                rowBuffer.append(fieldDelimiter);
                continue;
            }
            rowBuffer.append(recordDelimiter);
        }
        if (rowBuffer.length() > 0) {
            this.writer.write(rowBuffer.toString());
        }
    }

    protected void writeCurrentRow(Map<String, String> currentRow, Map<String, String> repeatedValues) throws IOException {
        CsvExporterConfiguration configuration = (CsvExporterConfiguration)this.getCurrentConfiguration();
        String fieldDelimiter = configuration.getFieldDelimiter();
        String recordDelimiter = configuration.getRecordDelimiter();
        StringBuffer rowBuffer = new StringBuffer();
        boolean isEmptyRow = true;
        for (int i = 0; i < this.columnNames.size(); ++i) {
            String currentTextValue = currentRow.get(this.columnNames.get(i));
            if (currentTextValue != null && currentTextValue.length() > 0) {
                isEmptyRow = false;
                rowBuffer.append(this.prepareText(currentTextValue));
            } else {
                String repeatedValue = repeatedValues.get(this.columnNames.get(i));
                if (repeatedValue != null && repeatedValue.length() > 0) {
                    rowBuffer.append(this.prepareText(repeatedValue));
                }
            }
            if (i < this.columnNames.size() - 1) {
                rowBuffer.append(fieldDelimiter);
                continue;
            }
            rowBuffer.append(recordDelimiter);
        }
        if (!isEmptyRow) {
            this.writer.write(rowBuffer.toString());
        }
    }

    private boolean isColumnReadOnTime(Map<String, String> currentRow, String currentColumnName) {
        int indexOfLastFilledColumn = -1;
        Set<String> currentlyFilledColumns = currentRow.keySet();
        for (String column : currentlyFilledColumns) {
            indexOfLastFilledColumn = Math.max(indexOfLastFilledColumn, this.columnNames.indexOf(column));
        }
        return indexOfLastFilledColumn < this.columnNames.indexOf(currentColumnName);
    }

    protected class ExporterContext
    extends JRAbstractExporter.BaseExporterContext
    implements JRCsvExporterContext {
        protected ExporterContext() {
        }
    }
}

