/*
 * Decompiled with CFR 0.152.
 */
package oracle.toplink.essentials.internal.parsing;

import oracle.toplink.essentials.exceptions.EJBQLException;
import oracle.toplink.essentials.expressions.Expression;
import oracle.toplink.essentials.expressions.ExpressionBuilder;
import oracle.toplink.essentials.expressions.ExpressionMath;
import oracle.toplink.essentials.internal.parsing.ArithmeticFunctionNode;
import oracle.toplink.essentials.internal.parsing.GenerationContext;
import oracle.toplink.essentials.internal.parsing.IntegerLiteralNode;
import oracle.toplink.essentials.internal.parsing.LiteralNode;
import oracle.toplink.essentials.internal.parsing.Node;
import oracle.toplink.essentials.internal.parsing.ParseTreeContext;
import oracle.toplink.essentials.internal.parsing.TypeHelper;

public class ModNode
extends ArithmeticFunctionNode {
    private Node denominator = null;

    public void validate(ParseTreeContext context) {
        TypeHelper typeHelper = context.getTypeHelper();
        if (this.left != null) {
            this.left.validate(context);
            this.left.validateParameter(context, typeHelper.getIntType());
            Object type = this.left.getType();
            if (!typeHelper.isIntegralType(type)) {
                throw EJBQLException.invalidFunctionArgument("MOD", this.left.getAsString(), "integral type");
            }
        }
        if (this.denominator != null) {
            this.denominator.validate(context);
            this.denominator.validateParameter(context, typeHelper.getIntType());
            Object denominatorType = this.denominator.getType();
            if (!typeHelper.isIntegralType(denominatorType)) {
                throw EJBQLException.invalidFunctionArgument("MOD", this.denominator.getAsString(), "integral type");
            }
        }
        this.setType(typeHelper.getIntType());
    }

    public Expression generateExpression(GenerationContext context) {
        Expression whereClause;
        Integer i = new Integer(((LiteralNode)this.getDenominator()).getLiteral().toString());
        if (this.getLeft().isLiteralNode()) {
            ExpressionBuilder builder = new ExpressionBuilder();
            Integer leftInt = new Integer(((IntegerLiteralNode)this.getLeft()).getLiteral().toString());
            whereClause = ExpressionMath.mod(builder.value(leftInt), builder.value(i));
        } else {
            whereClause = ExpressionMath.mod(this.getLeft().generateExpression(context), i);
        }
        return whereClause;
    }

    public Node getDenominator() {
        return this.denominator;
    }

    public void setDenominator(Node denominator) {
        this.denominator = denominator;
    }
}

