/*
 * Decompiled with CFR 0.152.
 */
package oracle.toplink.essentials.internal.queryframework;

import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Map;
import java.util.Vector;
import oracle.toplink.essentials.exceptions.QueryException;
import oracle.toplink.essentials.exceptions.ValidationException;
import oracle.toplink.essentials.internal.ejb.cmp3.base.CMP3Policy;
import oracle.toplink.essentials.internal.helper.ClassConstants;
import oracle.toplink.essentials.internal.helper.Helper;
import oracle.toplink.essentials.internal.queryframework.InterfaceContainerPolicy;
import oracle.toplink.essentials.internal.security.PrivilegedAccessController;
import oracle.toplink.essentials.internal.sessions.AbstractSession;
import oracle.toplink.essentials.internal.sessions.UnitOfWorkImpl;
import oracle.toplink.essentials.queryframework.DatabaseQuery;

public class MapContainerPolicy
extends InterfaceContainerPolicy {
    protected String keyName;
    protected String elementClassName;
    protected Class elementClass;
    protected transient Field keyField;
    protected transient Method keyMethod;

    public MapContainerPolicy() {
    }

    public MapContainerPolicy(Class containerClass) {
        super(containerClass);
    }

    public MapContainerPolicy(String containerClassName) {
        super(containerClassName);
    }

    public void prepare(DatabaseQuery query, AbstractSession session) throws QueryException {
        if (this.getElementClass() == null && query.getDescriptor() != null) {
            this.setElementClass(query.getDescriptor().getJavaClass());
        }
        super.prepare(query, session);
    }

    public boolean addInto(Object key, Object element, Object container, AbstractSession session) {
        Object wrapped = element;
        if (this.hasElementDescriptor()) {
            wrapped = this.getElementDescriptor().getObjectBuilder().wrapObject(element, session);
        }
        try {
            if (key != null) {
                return ((Map)container).put(key, wrapped) != null;
            }
            return ((Map)container).put(this.keyFrom(element, session), wrapped) != null;
        }
        catch (ClassCastException ex1) {
            throw QueryException.mapKeyNotComparable(element, container);
        }
    }

    public void clear(Object container) {
        try {
            ((Map)container).clear();
        }
        catch (UnsupportedOperationException ex) {
            throw QueryException.methodNotValid(container, "clear()");
        }
    }

    public boolean compareKeys(Object sourceValue, AbstractSession session) {
        Object backUpVersion = null;
        backUpVersion = ((UnitOfWorkImpl)session).isClassReadOnly(sourceValue.getClass()) ? ((UnitOfWorkImpl)session).getOriginalVersionOfObject(sourceValue) : ((UnitOfWorkImpl)session).getBackupClone(sourceValue);
        return this.keyFrom(backUpVersion, session).equals(this.keyFrom(sourceValue, session));
    }

    protected boolean contains(Object element, Object container) {
        return ((Map)container).containsValue(element);
    }

    public void convertClassNamesToClasses(ClassLoader classLoader) {
        super.convertClassNamesToClasses(classLoader);
        if (this.elementClassName == null) {
            return;
        }
        try {
            this.setElementClass(PrivilegedAccessController.getClassForName(this.elementClassName, true, classLoader));
        }
        catch (ClassNotFoundException exc) {
            throw ValidationException.classNotFoundWhileConvertingClassNames(this.containerClassName, exc);
        }
    }

    public Class getElementClass() {
        return this.elementClass;
    }

    public String getElementClassName() {
        return this.elementClassName;
    }

    public Class getInterfaceType() {
        return ClassConstants.Map_Class;
    }

    public String getKeyName() {
        return this.keyName;
    }

    public boolean isMapPolicy() {
        return true;
    }

    public Object iteratorFor(Object container) {
        return ((Map)container).values().iterator();
    }

    public Object keyFrom(Object element, AbstractSession session) {
        if (this.keyName != null && this.keyMethod == null && this.keyField == null) {
            try {
                this.keyMethod = Helper.getDeclaredMethod(this.elementClass, this.keyName, null);
            }
            catch (NoSuchMethodException ex) {
                try {
                    this.keyField = Helper.getField(this.elementClass, this.keyName);
                }
                catch (NoSuchFieldException e) {
                    throw ValidationException.mapKeyNotDeclaredInItemClass(this.keyName, this.elementClass);
                }
            }
        }
        Object keyElement = element;
        if (this.hasElementDescriptor()) {
            keyElement = this.getElementDescriptor().getObjectBuilder().unwrapObject(element, session);
        }
        if (this.keyMethod != null) {
            try {
                return PrivilegedAccessController.invokeMethod(this.keyMethod, keyElement, null);
            }
            catch (IllegalAccessException e) {
                throw QueryException.cannotAccessMethodOnObject(this.keyMethod, keyElement);
            }
            catch (InvocationTargetException exception) {
                throw QueryException.calledMethodThrewException(this.keyMethod, keyElement, exception);
            }
        }
        if (this.keyField != null) {
            try {
                return PrivilegedAccessController.getValueFromField(this.keyField, keyElement);
            }
            catch (IllegalAccessException e) {
                throw QueryException.cannotAccessFieldOnObject(this.keyField, keyElement);
            }
        }
        return ((CMP3Policy)this.getElementDescriptor().getCMPPolicy()).createPrimaryKeyInstance(keyElement, session);
    }

    public boolean removeFrom(Object key, Object element, Object container, AbstractSession session) {
        try {
            Object returnValue = null;
            returnValue = key != null ? ((Map)container).remove(key) : ((Map)container).remove(this.keyFrom(element, session));
            return returnValue != null;
        }
        catch (UnsupportedOperationException ex) {
            throw QueryException.methodNotValid(container, "remove(Object element)");
        }
    }

    public boolean removeFromWithIdentity(Object element, Object container, AbstractSession session) {
        boolean found = false;
        Vector knownKeys = new Vector(1);
        try {
            for (Object key : ((Map)container).keySet()) {
                if (((Map)container).get(key) != element) continue;
                knownKeys.addElement(key);
                found = true;
            }
            if (found) {
                for (int index = 0; index < knownKeys.size(); ++index) {
                    ((Map)container).remove(knownKeys.elementAt(index));
                }
            }
            return found;
        }
        catch (UnsupportedOperationException ex) {
            throw QueryException.methodNotValid(container, "remove(Object element)");
        }
    }

    public void setElementClass(Class elementClass) {
        if (elementClass != null) {
            this.elementClassName = elementClass.getName();
        }
        this.elementClass = elementClass;
    }

    public boolean isValidContainer(Object container) {
        return container instanceof Map;
    }

    public void setKeyName(String keyName, String elementClassName) {
        this.keyName = keyName;
        this.elementClassName = elementClassName;
    }

    public void setKeyName(String keyName) {
        this.keyName = keyName;
    }

    public int sizeFor(Object container) {
        return ((Map)container).size();
    }

    public void validateElementAndRehashIfRequired(Object sourceValue, Object targetMap, AbstractSession session, Object targetVersionOfSource) {
        Object backupValue;
        if (session.isUnitOfWork() && !this.keyFrom(backupValue = ((UnitOfWorkImpl)session).getBackupClone(sourceValue), session).equals(this.keyFrom(sourceValue, session))) {
            this.removeFrom(backupValue, targetMap, session);
            this.addInto(targetVersionOfSource, targetMap, session);
        }
    }
}

