/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.jdbc;

import java.io.Serializable;
import java.sql.Connection;
import java.sql.SQLException;
import javax.transaction.Synchronization;
import javax.transaction.SystemException;
import javax.transaction.TransactionManager;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hibernate.ConnectionReleaseMode;
import org.hibernate.HibernateException;
import org.hibernate.SessionException;
import org.hibernate.Transaction;
import org.hibernate.TransactionException;
import org.hibernate.engine.SessionFactoryImplementor;
import org.hibernate.exception.JDBCExceptionHelper;
import org.hibernate.jdbc.ConnectionManager;
import org.hibernate.transaction.CacheSynchronization;
import org.hibernate.transaction.TransactionFactory;
import org.hibernate.util.JTAHelper;

public class JDBCContext
implements Serializable,
ConnectionManager.Callback {
    private static final Log log = LogFactory.getLog((Class)(class$org$hibernate$jdbc$JDBCContext == null ? (class$org$hibernate$jdbc$JDBCContext = JDBCContext.class$("org.hibernate.jdbc.JDBCContext")) : class$org$hibernate$jdbc$JDBCContext));
    private Context owner;
    private ConnectionManager connectionManager;
    private boolean isTransactionCallbackRegistered;
    private boolean isHibernateTransactionActive;
    static /* synthetic */ Class class$org$hibernate$jdbc$JDBCContext;

    public JDBCContext(Context owner, Connection connection) {
        boolean registerSynchronization;
        this.owner = owner;
        this.connectionManager = new ConnectionManager(owner.getFactory(), this, owner.getConnectionReleaseMode(), connection);
        boolean bl = registerSynchronization = owner.isAutoCloseSessionEnabled() || owner.isFlushBeforeCompletionEnabled() || owner.getConnectionReleaseMode() == ConnectionReleaseMode.AFTER_TRANSACTION;
        if (registerSynchronization) {
            this.registerSynchronizationIfPossible();
        }
    }

    public void connectionOpened() {
        if (!this.isTransactionCallbackRegistered) {
            this.registerSynchronizationIfPossible();
        }
        if (this.owner.getFactory().getStatistics().isStatisticsEnabled()) {
            this.owner.getFactory().getStatisticsImplementor().connect();
        }
    }

    public void connectionCleanedUp() {
        if (!this.isTransactionCallbackRegistered) {
            this.afterTransactionCompletion(false, null);
        }
    }

    public SessionFactoryImplementor getFactory() {
        return this.owner.getFactory();
    }

    public ConnectionManager getConnectionManager() {
        return this.connectionManager;
    }

    public Connection connection() throws HibernateException {
        if (!this.owner.isOpen()) {
            throw new SessionException("Session is closed");
        }
        if (!this.connectionManager.isLogicallyConnected()) {
            throw new SessionException("Session is currently disconnected");
        }
        return this.connectionManager.getConnection();
    }

    public boolean registerCallbackIfNecessary() {
        if (this.isTransactionCallbackRegistered) {
            return false;
        }
        this.isTransactionCallbackRegistered = true;
        return true;
    }

    public boolean registerSynchronizationIfPossible() {
        if (this.isTransactionCallbackRegistered) {
            return true;
        }
        TransactionManager tm = this.owner.getFactory().getTransactionManager();
        if (tm == null) {
            return false;
        }
        try {
            javax.transaction.Transaction tx = tm.getTransaction();
            if (this.isJTATransactionInProgress(tx)) {
                tx.registerSynchronization((Synchronization)new CacheSynchronization(this.owner, this, tx, null));
                this.isTransactionCallbackRegistered = true;
                log.debug((Object)"successfully registered Synchronization");
                return true;
            }
            log.debug((Object)"no active transaction, could not register Synchronization");
            return false;
        }
        catch (Exception e) {
            throw new TransactionException("could not register synchronization with JTA TransactionManager", e);
        }
    }

    private boolean isJTATransactionInProgress(javax.transaction.Transaction tx) throws SystemException {
        return tx != null && JTAHelper.isInProgress(tx.getStatus());
    }

    public boolean isTransactionInProgress() {
        TransactionManager tm = this.owner.getFactory().getTransactionManager();
        try {
            return this.isHibernateTransactionActive || tm != null && this.isJTATransactionInProgress(tm.getTransaction());
        }
        catch (SystemException se) {
            throw new TransactionException("could not obtain JTA Transaction", (Exception)((Object)se));
        }
    }

    public Transaction beginTransaction() throws HibernateException {
        Transaction tx = this.owner.getFactory().getSettings().getTransactionFactory().beginTransaction(this, this.owner);
        this.isHibernateTransactionActive = true;
        return tx;
    }

    public void beforeTransactionCompletion(Transaction tx) {
        log.trace((Object)"before transaction completion");
        this.owner.beforeTransactionCompletion(tx);
    }

    public void afterTransactionCompletion(boolean success, Transaction tx) {
        log.trace((Object)"after transaction completion");
        if (this.getFactory().getStatistics().isStatisticsEnabled()) {
            this.getFactory().getStatisticsImplementor().endTransaction(success);
        }
        this.connectionManager.afterTransaction();
        this.isTransactionCallbackRegistered = false;
        this.isHibernateTransactionActive = false;
        this.owner.afterTransactionCompletion(success, tx);
    }

    public void afterNontransactionalQuery(boolean success) {
        log.trace((Object)"after autocommit");
        try {
            boolean isAutocommit = this.connectionManager.isAutoCommit();
            this.connectionManager.afterTransaction();
            if (isAutocommit) {
                this.owner.afterTransactionCompletion(success, null);
            }
        }
        catch (SQLException sqle) {
            success = false;
            throw JDBCExceptionHelper.convert(this.owner.getFactory().getSQLExceptionConverter(), sqle, "could not inspect JDBC autocommit mode");
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    public static interface Context
    extends TransactionFactory.Context {
        public void beforeTransactionCompletion(Transaction var1);

        public void afterTransactionCompletion(boolean var1, Transaction var2);

        public ConnectionReleaseMode getConnectionReleaseMode();

        public boolean isAutoCloseSessionEnabled();
    }
}

