/*
 * Decompiled with CFR 0.152.
 */
package org.jCharts.axisChart;

import java.awt.Graphics2D;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import org.jCharts.axisChart.AxisChart;
import org.jCharts.chartData.interfaces.IAxisChartDataSet;
import org.jCharts.imageMap.CircleMapArea;
import org.jCharts.properties.PointChartProperties;

abstract class PointChart {
    PointChart() {
    }

    static void render(AxisChart axisChart, IAxisChartDataSet iAxisChartDataSet) {
        Graphics2D graphics2D = axisChart.getGraphics2D();
        PointChartProperties pointChartProperties = (PointChartProperties)iAxisChartDataSet.getChartTypeProperties();
        float f = axisChart.getXAxis().getTickStartX();
        double[] dArray = new double[iAxisChartDataSet.getNumberOfDataSets()];
        double[] dArray2 = new double[iAxisChartDataSet.getNumberOfDataSets()];
        AffineTransform affineTransform = graphics2D.getTransform();
        int n = 0;
        while (n < iAxisChartDataSet.getNumberOfDataSets()) {
            Rectangle2D rectangle2D = pointChartProperties.getShape(n).getBounds2D();
            dArray[n] = rectangle2D.getWidth() / 2.0;
            dArray2[n] = rectangle2D.getHeight() / 2.0;
            ++n;
        }
        graphics2D.setStroke(PointChartProperties.DEFAULT_POINT_BORDER_STROKE);
        int n2 = 0;
        while (n2 < iAxisChartDataSet.getNumberOfDataItems()) {
            int n3 = 0;
            while (n3 < iAxisChartDataSet.getNumberOfDataSets()) {
                if (!Double.isNaN(iAxisChartDataSet.getValue(n3, n2))) {
                    float f2 = axisChart.getYAxis().computeAxisCoordinate(iAxisChartDataSet.getValue(n3, n2));
                    if (axisChart.getGenerateImageMapFlag()) {
                        axisChart.getImageMap().addImageMapArea(new CircleMapArea(f, f2, iAxisChartDataSet.getValue(n3, n2), axisChart.getIDataSeries().getXAxisLabel(n2), iAxisChartDataSet.getLegendLabel(n3)));
                    }
                    graphics2D.translate((double)f - dArray[n3], (double)f2 - dArray2[n3]);
                    graphics2D.setPaint(iAxisChartDataSet.getPaint(n3));
                    if (pointChartProperties.getFillPointsFlag(n3)) {
                        graphics2D.fill(pointChartProperties.getShape(n3));
                        if (pointChartProperties.getPointOutlinePaints(n3) != null) {
                            graphics2D.setPaint(pointChartProperties.getPointOutlinePaints(n3));
                            graphics2D.draw(pointChartProperties.getShape(n3));
                        }
                    } else {
                        graphics2D.draw(pointChartProperties.getShape(n3));
                    }
                    graphics2D.setTransform(affineTransform);
                }
                ++n3;
            }
            f += axisChart.getXAxis().getScalePixelWidth();
            ++n2;
        }
    }
}

