<!-- Note: This file is automatically generated from source code comments. Changes made in this file will be overridden. -->

# Function isNegative

Test whether a value is negative: smaller than zero.
The function supports types `number`, `BigNumber`, `Fraction`, and `Unit`.

The function is evaluated element-wise in case of Array or Matrix input.


## Syntax

```js
math.isNegative(x)
```

### Parameters

Parameter | Type | Description
--------- | ---- | -----------
`x` | number &#124; BigNumber &#124; Fraction &#124; Unit &#124; Array &#124; Matrix | Value to be tested

### Returns

Type | Description
---- | -----------
boolean | Returns true when `x` is larger than zero. Throws an error in case of an unknown data type.


## Examples

```js
math.isNegative(3)                     // returns false
math.isNegative(-2)                    // returns true
math.isNegative(0)                     // returns false
math.isNegative(-0)                    // returns false
math.isNegative(math.bignumber(2))     // returns false
math.isNegative(math.fraction(-2, 5))  // returns true
math.isNegative('-2')                  // returns true
math.isNegative([2, 0, -3]')           // returns [false, false, true]
```


## See also

[isNumeric](isNumeric.md),
[isPositive](isPositive.md),
[isZero](isZero.md),
[isInteger](isInteger.md)
