const Joi = require('joi');

class AlertSchema {
    static getSaveSchema()
    { 
        const saveAreaSchema = Joi.object().keys({
            ProductId: Joi.string().max(255).required(),
            ProductName: Joi.string().max(500).required().not(['',null,'undefined']),
            ProductVersion: Joi.string().max(255).required(),
            Version: Joi.string().required().not(['',null,'undefined']),
            Batch: Joi.string().max(100).required().not(['', null, 'undefined']),
            Group: Joi.number().required().not(['', null, 'undefined']),
            Sys_Area: Joi.string().max(50).required().not(['', null, 'undefined']),
            Sys_CubicName: Joi.string().max(50).required().not(['', null, 'undefined']),
            CubicNo: Joi.number().required().not(['', null, 'undefined']),
            OldData: Joi.string().max(50).required().not(['', null, 'undefined']),
            NewData: Joi.string().max(50).required().not(['', null, 'undefined']),
            UserID:Joi.string().max(50).required().not(['',null,'undefined']),
            UserName:Joi.string().max(255).required().not(['',null,'undefined']),
            activity: Joi.string().max(50).required().not(['', null, 'undefined']),
            Remark:Joi.string().max(500).required().not(['', null, 'undefined']),
            Action:Joi.string().max(50).required().not(['', null, 'undefined']),
        });
        
        return saveAreaSchema;
    }
}



module.exports = AlertSchema;