const Joi = require('joi');

class EquipmentSchema {
    saveEquipmentSchema()
    { 
        const saveEquipmentSchema = Joi.object().keys({
            Eqp_ID: Joi.string().max(100).required().not(['',null,'undefined']),
            Eqp_Make: Joi.string().max(100).required().not(['',null,'undefined']),
            Eqp_Model: Joi.string().max(100).required().not(['',null,'undefined']),
            Eqp_SerialNo: Joi.string().max(100).required().not(['',null,'undefined']),
            Eqp_Type: Joi.string().max(100).required().not(['', null, 'undefined']),
            Eqp_Dept: Joi.allow(),

            storeFileName: Joi.string().max(200).required().not(['', null, 'undefined']),
            str_fileInput: Joi.string().max(200).required().not(['', null, 'undefined']),
            userid: Joi.string().max(50).required().not(['', null, 'undefined']),
            username: Joi.string().max(255).required().not(['', null, 'undefined']),
            Action: Joi.string().max(50).required().not(['', null, 'undefined']),
            Remark:Joi.string().max(500).required().not(['',null,'undefined']),
            NewData:Joi.string().max(800).required().not(['',null,'undefined']),
            activity:Joi.string().max(100).required().not(['',null,'undefined']),
            Eqp_Weight:Joi.allow(),
            Eqp_CalibDt:Joi.allow(),
            str_HT_Type:Joi.allow(),
            ip_Address:Joi.allow()
        });
        
        return saveEquipmentSchema;
    }

    getDetailEquipmentSchema()
    { 
        const getDetailEquipmentSchema = Joi.object().keys({
            Eqp_Type: Joi.string().max(100).required().not(['',null,'undefined']),
            id: Joi.string().max(100).required().not(['',null,'undefined'])
        });
        
        return getDetailEquipmentSchema;
    }

    getWeightSchema()
    {
        const getWeightSchema = Joi.object().keys({
            type: Joi.string().max(100).required().not(['',null,'undefined']),
            ID: Joi.string().max(100).required().not(['',null,'undefined'])
        });
        
        return getWeightSchema;
    }

    editEquipmentSchema()
    { 
        const editEquipmentSchema = Joi.object().keys({
            Eqp_ID: Joi.string().max(100).required().not(['',null,'undefined']),
            Eqp_Make: Joi.string().max(100).required().not(['',null,'undefined']),
            Eqp_Model: Joi.string().max(100).required().not(['',null,'undefined']),
            Eqp_SerialNo: Joi.string().max(100).required().not(['',null,'undefined']),
            Eqp_Type: Joi.string().max(100).required().not(['', null, 'undefined']),
            Eqp_Dept: Joi.allow(),
            storeFileName: Joi.string().max(200).required().not(['', null, 'undefined']),
            str_fileInput: Joi.string().max(200).required().not(['', null, 'undefined']),
            userid: Joi.string().max(50).required().not(['', null, 'undefined']),
            username: Joi.string().max(255).required().not(['', null, 'undefined']),
            Action: Joi.string().max(50).required().not(['', null, 'undefined']),
            Remark:Joi.string().max(500).required().not(['',null,'undefined']),
            NewData:Joi.string().max(800).required().not(['',null,'undefined']),
            OldData:Joi.string().max(800).required().not(['',null,'undefined']),
            activity:Joi.string().max(100).required().not(['',null,'undefined']),
            oldWeight:Joi.allow(),
            newWeight:Joi.allow(),
            Eqp_Weight:Joi.allow(),
            Eqp_CalibDt:Joi.allow(),
            str_HT_Type:Joi.allow()
        });
        
        return editEquipmentSchema;
    }
    
    activateDeactivateEquipmentSchema()
    {
        const activateDeactivateEquipmentSchema = Joi.object().keys({
            Eqp_ID: Joi.string().max(100).required().not(['',null,'undefined']),
            Eqp_Type: Joi.string().max(100).required().not(['', null, 'undefined']),
            Eqp_Active: Joi.allow(),
            userId: Joi.string().max(50).required().not(['', null, 'undefined']),
            userName: Joi.string().max(255).required().not(['', null, 'undefined']),
            action: Joi.string().max(50).required().not(['', null, 'undefined']),
            remark:Joi.string().max(500).required().not(['',null,'undefined']),
            activity:Joi.string().max(100).required().not(['',null,'undefined']),
        });
        
        return activateDeactivateEquipmentSchema;
    }
}




module.exports = EquipmentSchema;