const Joi = require('joi');

class MachineSchema {
    saveMachineSchema()
    { 
        const saveMachineSchema = Joi.object().keys({
            MachineID: Joi.string().max(100).required().not(['',null,'undefined']),
            Make: Joi.string().max(100).required().not(['',null,'undefined']),
            MinSpeed: Joi.allow(""),
            MaxSpeed: Joi.allow(""),
            NoOfPunches: Joi.allow(),
            NoOfSample: Joi.number().required(),
            Model: Joi.string().max(100).required().not(['',null,'undefined']),
            SrNo: Joi.string().max(100).required().not(['',null,'undefined']),
            RotaryType: Joi.string().max(50).required().not(['', null, 'undefined']),
            CubicleType: Joi.string().max(50).required().not(['', null, 'undefined']),
            loggedUserId: Joi.string().max(50).required().not(['', null, 'undefined']),
            loggedUserName: Joi.string().max(255).required().not(['', null, 'undefined']),
            action: Joi.string().max(50).required().not(['', null, 'undefined']),
            remark:Joi.string().max(500).required().not(['',null,'undefined']),
            newData:Joi.string().max(800).required().not(['',null,'undefined'])
        });
        
        return saveMachineSchema;
    }
    updateActiveDeactiveSchema() {
        const updateActiveDeactiveSchema = Joi.object().keys({
            action: Joi.string().required().not(['', null, 'undefined']),
            machineID: Joi.required().not(['', null, 'undefined']),
            remark: Joi.string().required().not(['', null, 'undefined']),
            userId: Joi.string().required().not(['', null, 'undefined']),
            userName: Joi.string().required().not(['', null, 'undefined']),
        })
        return updateActiveDeactiveSchema;
    }

    editMachineSchema()
    {
        const editMachineSchema = Joi.object().keys({
            MachineID: Joi.string().max(100).required().not(['',null,'undefined']),
            Make: Joi.string().max(100).required().not(['',null,'undefined']),
            Model: Joi.string().max(100).required().not(['',null,'undefined']),
            SrNo: Joi.string().max(100).required().not(['',null,'undefined']),
            MinSpeed: Joi.allow(""),
            MaxSpeed: Joi.allow(""),
            NoOfPunches: Joi.allow(),
            NoOfSample: Joi.number().required(),
            RotaryType: Joi.string().max(50).required().not(['', null, 'undefined']),
            CubicleType: Joi.string().max(50).required().not(['', null, 'undefined']),
            loggedUserId: Joi.string().max(50).required().not(['', null, 'undefined']),
            loggedUserName: Joi.string().max(255).required().not(['', null, 'undefined']),
            action: Joi.string().max(50).required().not(['', null, 'undefined']),
            remark:Joi.string().max(500).required().not(['',null,'undefined']),
            newData:Joi.string().max(800).required().not(['',null,'undefined']),
            oldData:Joi.string().max(800).required().not(['',null,'undefined'])
        });
        
        return editMachineSchema;  
    }

    getLockSchema()
    {
        const getLockSchema = Joi.object().keys({
            IsLock: Joi.boolean().required().not(['',null,'undefined']),
            MachineID: Joi.string().max(50).required().not(['',null,'undefined']),
        });
        
        return getLockSchema;
    }
}




module.exports = MachineSchema;