const Joi = require('joi');

class MultihalerSchema {
    saveMultihalerSchema()
    { 
        const saveMultihalerSchema = Joi.object().keys({
            str_BFGCode: Joi.string().max(100).required().not([null,'undefined']),
            str_Prd: Joi.string().max(500).required().not([null,'undefined']),
            str_PV: Joi.string().max(50).required().not([null,'undefined']),
            str_V: Joi.string().max(25).required().not([null,'undefined']),
            int_chkBFG: Joi.number(),
            int_chkPrdVersion: Joi.number(),
            int_chkVersion: Joi.number(),
            multiHalerType: Joi.string().max(100).required().not([null, 'undefined']),
            flt_NetStd: Joi.string().max(100).required().not(['undefined']).allow("",null).default('99999'),
            flt_NetT1Neg: Joi.string().max(100).required().not(['undefined']).allow("",null).default('99999'),
            flt_NetT1Pos: Joi.string().max(500).required().not(['undefined']).allow("",null).default('99999'),
            flt_NetT2Neg: Joi.string().max(50).required().not(['undefined']).allow("",null).default('99999'),
            flt_NetT2Pos: Joi.string().max(20).required().not(['undefined']).allow("",null).default('99999'),
            str_NetLimitOn: Joi.string().max(100).required().not(['undefined']).allow("",null).default('99999'),
            str_UCGraphOn: Joi.string().max(100).required().not(['undefined']).allow("",null).default('99999'),
            str_SCGraphOn: Joi.string().max(100).required().not(['undefined']).allow("",null).default('99999'),
            int_NetNMTCnt: Joi.string().max(100).required().not(['undefined']).allow("",null).default('99999'),
            flt_GrpStd: Joi.string().max(100).required().not(['undefined']).allow("",null).default('99999'),
            flt_GrpT1Neg: Joi.string().max(500).required().not(['undefined']).allow("",null).default('99999'),
            flt_GrpT1Pos: Joi.string().max(50).required().not(['undefined']).allow("",null).default('99999'),
            flt_GrpT2Neg: Joi.string().max(20).required().not(['undefined']).allow("",null).default('99999'),
            flt_GrpT2Pos: Joi.string().max(100).required().not(['undefined']).allow("",null).default('99999'),
            str_GrpLimitOn: Joi.string().max(100).required().not(['undefined']).allow("",null).default('99999'),
            int_GrpNMTCnt: Joi.string().max(100).required().not(['undefined']).allow("",null).default('99999'),
            str_userId: Joi.string().max(100).required().not(['undefined']).allow("",null).default('99999'),
            str_userName: Joi.string().max(100).required().not(['undefined']).allow("",null).default('99999'),
            action: Joi.string().max(100).required().not(['undefined']).allow("",null).default('99999'),
            remark: Joi.string().max(500).required().not(['undefined']).allow("",null).default('99999'),
            auditObject: Joi.object().keys({
                status: Joi.string().not([null, 'undefined']),
                result: Joi.object().keys({
                    Multihaler: Joi.object().keys({
                        //oldData: Joi.string().not([null, 'undefined']),
                        newData: Joi.string().not([null, 'undefined'])
                    }),
                }),
            })
        });
        
        return saveMultihalerSchema;
    }

    updateMultihalerSchema(){
        const updateMultihalerSchema = Joi.object().keys({
            str_BFGCode: Joi.string().max(100).required().not([null,'undefined']),
            str_Prd: Joi.string().max(500).required().not([null,'undefined']),
            str_PV: Joi.string().max(50).required().not([null,'undefined']),
            str_V: Joi.string().max(50).required().not([null,'undefined']),
            multiHalerType: Joi.number().max(100).required().not([null, 'undefined']),
            flt_NetStd: Joi.string().max(100).required().not(['undefined']).allow("",null).default('99999'),
            flt_NetT1Neg: Joi.string().max(100).required().not(['undefined']).allow("",null).default('99999'),
            flt_NetT1Pos: Joi.string().max(500).required().not(['undefined']).allow("",null).default('99999'),
            flt_NetT2Neg: Joi.string().max(50).required().not(['undefined']).allow("",null).default('99999'),
            flt_NetT2Pos: Joi.string().max(20).required().not(['undefined']).allow("",null).default('99999'),
            str_NetLimitOn: Joi.string().max(100).required().not(['undefined']).allow("",null).default('99999'),
            str_UCGraphOn: Joi.string().max(100).required().not(['undefined']).allow("",null).default('99999'),
            str_SCGraphOn: Joi.string().max(100).required().not(['undefined']).allow("",null).default('99999'),
            int_NetNMTCnt: Joi.string().max(100).required().not(['undefined']).allow("",null).default('99999'),
            flt_GrpStd: Joi.string().max(100).required().not(['undefined']).allow("",null).default('99999'),
            flt_GrpT1Neg: Joi.string().max(500).required().not(['undefined']).allow("",null).default('99999'),
            flt_GrpT1Pos: Joi.string().max(50).required().not(['undefined']).allow("",null).default('99999'),
            flt_GrpT2Neg: Joi.string().max(20).required().not(['undefined']).allow("",null).default('99999'),
            flt_GrpT2Pos: Joi.string().max(100).required().not(['undefined']).allow("",null).default('99999'),
            str_GrpLimitOn: Joi.string().max(100).required().not(['undefined']).allow("",null).default('99999'),
            int_GrpNMTCnt: Joi.string().max(100).required().not(['undefined']).allow("",null).default('99999'),
            loggedUserId: Joi.string().max(100).required().not(['undefined']).allow("",null).default('99999'),
            loggedUserName: Joi.string().max(100).required().not(['undefined']).allow("",null).default('99999'),
            int_netDp: Joi.number().max(10).required().not(['undefined']).allow("",null),
            int_grpDp: Joi.number().max(10).required().not(['undefined']).allow("",null),
            action: Joi.string().max(100).required().not(['undefined']).allow("",null).default('99999'),
            remark: Joi.string().max(500).required().not(['undefined']).allow("",null).default('99999'),
            strOldBFG: Joi.string().max(25).required().not(['', null, 'undefined']),
            strOldPrd: Joi.string().max(300).required().not(['', null, 'undefined']),
            strOldPV: Joi.string().max(50).required().not(['', null, 'undefined']),
            strOldV: Joi.string().max(50).required().not(['', null, 'undefined']),
            IsPrdDetailChange:Joi.boolean().required(),
            auditObject: Joi.object().keys({
                status: Joi.string().not([null, 'undefined']),
                result: Joi.object().keys({
                    Multihaler: Joi.object().keys({
                        oldData: Joi.string().not([null, 'undefined']),
                        newData: Joi.string().not([null, 'undefined']),
                        result: Joi.string().not([null, 'undefined'])
                    }),
                    ProductDetail: Joi.object().keys({
                        oldData: Joi.string().not([null, 'undefined']),
                        newData: Joi.string().not([null, 'undefined']),
                        result: Joi.string().not([null, 'undefined'])
                    }), 
                }),
            })
        });
        
        return updateMultihalerSchema;
    }


    getMultihalerSchema()
    {
        const getMultihalerSchema = Joi.object().keys({
            ProductId: Joi.string().max(100).required().not(['',null,'undefined']),
            ProductName: Joi.string().max(500).required().not(['',null,'undefined']),
            ProductVersion: Joi.string().max(100).required().not(['',null,'undefined']),
            Version: Joi.string().max(100).required().not(['',null,'undefined']) 
        });
            
        return getMultihalerSchema;
    }

    activateMultihalerSchema()
    {
        const activateMultihalerSchema = Joi.object().keys({
            userId: Joi.string().max(100).required().not(['',null,'undefined']),
            userName: Joi.string().max(100).required().not(['',null,'undefined']),
            remark: Joi.string().max(500).required().not(['',null,'undefined']),
            action: Joi.string().max(100).required().not(['',null,'undefined']), 
            productID: Joi.string().max(100).required().not(['',null,'undefined']),
            productName: Joi.string().max(500).required().not(['',null,'undefined']),
            productVersion: Joi.string().max(100).required().not(['',null,'undefined']),
            productType: Joi.string().max(100).required().not(['',null,'undefined']),
            Version: Joi.string().max(100).required().not(['',null,'undefined']),
            multihalerType: Joi.number().max(100).required().not(['undefined']).allow("",null)
        });
            
        return activateMultihalerSchema;
    }

    /** Report schema */
    getMultihalerProductSchema() { 
        const getMultihalerProductSchema = Joi.object().keys({
            fromDate: Joi.string().required().not(['', null, 'undefined']),
            toDate: Joi.string().required().not(['', null, 'undefined']),
            reportOption: Joi.string().max(30).required().not(['', null, 'undefined']),
            testType: Joi.string().required().not(['', null, 'undefined']),
            reportType: Joi.string().required().not(['', null, 'undefined']),
            recordFrom: Joi.string().required().not(['', null, 'undefined']),
        })
        return getMultihalerProductSchema;
    }

    viewMultihalerReportSchema(){
        const viewMultihalerReportSchema = Joi.object().keys({
            recordFrom:Joi.string().required().not(['', null, 'undefined']),
            reportOption: Joi.string().required().not(['', null, 'undefined']),
            reportType: Joi.string().required().not(['', null, 'undefined']),
            testType: Joi.string().required().not(['', null, 'undefined']),
            RepSerNo: Joi.number().required().not(['', null, 'undefined']),
            userId: Joi.string().required().not(['', null, 'undefined']),
            username: Joi.string().required().not(['', null, 'undefined']),
            idsNo: Joi.allow(),
            printNo:Joi.allow(),
            str_verifyByVal: Joi.number().required().not(['', null, 'undefined'])

        })
        return viewMultihalerReportSchema;
    }

    checkMultihalerReportIsVerifiedSchema(){
        const checkMultihalerReportIsVerifiedSchema = Joi.object().keys({
            reportOption:Joi.string().required().not(['', null, 'undefined']),
            reportType: Joi.string().required().not(['', null, 'undefined']),
            intReportSerNo: Joi.number().required().not(['', null, 'undefined']),
            reportFrom:Joi.string().required().not(['', null, 'undefined']),
        })
        return checkMultihalerReportIsVerifiedSchema;
    }

    verifyMultihalerReportSchema(){
        const verifyMultihalerReportSchema = Joi.object().keys({
            reportOption:Joi.string().required().not(['', null, 'undefined']),
            reportType: Joi.string().required().not(['', null, 'undefined']),
            recordFrom: Joi.string().required().not(['', null, 'undefined']),
            strUserId: Joi.string().required().not(['', null, 'undefined']),
            strUserName: Joi.string().required().not(['', null, 'undefined']),
            intReportSerNo:Joi.number().required().not(['', null, 'undefined']),
            strReason: Joi.string().allow([""])
        })
        return verifyMultihalerReportSchema;
    }

    increasePrintCountMultihalerSchema(){
        const increasePrintCountMultihalerSchema = Joi.object().keys({
            reportOption:Joi.string().required().not(['', null, 'undefined']),
            reportType: Joi.string().required().not(['', null, 'undefined']),
            recordFrom: Joi.string().required().not(['', null, 'undefined']),
            RepSrNo:Joi.number().required().not(['', null, 'undefined']),
            intPrintCount: Joi.number().required(),
            strUserId: Joi.string().required(),
            strUserName: Joi.string().required(),
            strReason: Joi.string().allow([""]),
        })
        return increasePrintCountMultihalerSchema;
    }

    printReasonMultihalerReportSchema(){
        const printReasonMultihalerReportSchema = Joi.object().keys({
            reportOption:Joi.string().required().not(['', null, 'undefined']),
            reportType: Joi.string().required().not(['', null, 'undefined']),
            recordFrom: Joi.string().required().not(['', null, 'undefined']),
            RepSrNo:Joi.number().required().not(['', null, 'undefined'])
        })
        return printReasonMultihalerReportSchema;
    }

}

module.exports = MultihalerSchema;