const Joi = require('joi');

class RoleSchema {
    saveRoleSchema()
    { 
        const saveRoleSchema = Joi.object().keys({
            roleName: Joi.string().required().not(['',null,'undefined']),
            roleRights: Joi.array().items(Joi.string()),
            userId: Joi.string().required().not(['',null,'undefined']),
            userName: Joi.string().required().not(['',null,'undefined']),
            remark: Joi.string().required().not(['', null, 'undefined']),
            action: Joi.string().required().not(['', null, 'undefined']),
        });
        
        return saveRoleSchema;
    }
    updateRoleSchema(){
        const updateRoleSchema = Joi.object().keys({
            roleName: Joi.string().required().not(['',null,'undefined']),
            roleRights: Joi.array().items(Joi.string()),
            userID: Joi.string().required().not(['',null,'undefined']),
            userName: Joi.string().required().not(['',null,'undefined']),
            remark: Joi.string().required().not(['', null, 'undefined']),
            action: Joi.string().required().not(['', null, 'undefined']),
        });
        
        return updateRoleSchema; 
    }

    updateLockSchema(){
        const updateLockSchema = Joi.object().keys({
            roleName: Joi.string().required().not(['',null,'undefined']),
            lock: Joi.string().required().not(['',null,'undefined']),
            type:Joi.string().required().not(['',null,'undefined'])
        });
        
        return updateLockSchema; 
    }

}
module.exports = RoleSchema;