const Joi = require('joi');
class User{
    saveUserSchema(){
        const saveUserSchema = Joi.object().keys({
            userID:Joi.string().max(12).required().not(['',null,'undefined']),
            userName:Joi.string().max(100).required().not(['',null,'undefined']),
            userPassword:Joi.string().max(100).required().not(['',null,'undefined']),
            userConfirmPassword:Joi.string().max(100).required().not(['',null,'undefined']),
            userRoles: Joi.string().max(250).required().not(['',null,'undefined']),
            userInitials: Joi.string().max(50).required().not(['',null,'undefined']),
            userDepartment: Joi.string().max(250).required().not(['', null, 'undefined']),
            loggeduserID: Joi.string().max(50).required().not(['', null, 'undefined']),
            loggeduserName: Joi.string().max(255).required().not(['', null, 'undefined']),
            action:Joi.string().max(50).required().not(['', null, 'undefined']),
            remark:Joi.string().max(500).required().not(['', null, 'undefined'])
        });
        
        return saveUserSchema;
    }

    saveLdapUserSchema(){
        const saveLdapUserSchema = Joi.object().keys({
            userID: Joi.string().max(27).required().not(['',null,'undefined']),
            userName: Joi.string().max(100).required().not(['',null,'undefined']),
            userRoles: Joi.string().max(250).required().not(['',null,'undefined']),
            userInitials: Joi.string().max(50).required().not(['',null,'undefined']),
            userDepartment: Joi.string().max(250).required().not(['', null, 'undefined']),
            loggeduserID: Joi.string().max(50).required().not(['', null, 'undefined']),
            loggeduserName: Joi.string().max(255).required().not(['', null, 'undefined']),
            action:Joi.string().max(50).required().not(['', null, 'undefined']),
            remark:Joi.string().max(500).required().not(['', null, 'undefined']),
            isLdap:Joi.number().required().not(['',null,'undefined'])
        });
        
        return saveLdapUserSchema;   
    }

    updateUserSchema(){
        const updateUserSchema = Joi.object().keys({
            // real project this will be out
            userID: Joi.allow(),
            // userID: Joi.string().max(12).required().not(['',null,'undefined']),
            userInitials: Joi.string().max(50).required().not(['',null,'undefined']),
            username: Joi.string().max(100).required().not(['',null,'undefined']),
            selectedRoleRights: Joi.array().required().not(['',null,'undefined']).allow(''),
            selectedSplRights: Joi.array().required().not([null,'undefined']).allow(''),
            role: Joi.string().max(250).required().not(['',null,'undefined']),
            department: Joi.string().max(250).required().not(['', null, 'undefined']),
            oldRights: Joi.array().required().not(['',null,'undefined']).allow(''),
            oldSpecialRights: Joi.array().required().not(['',null,'undefined']).allow(''),
            oldRemoveRights: Joi.array().required().not(['',null,'undefined']).allow(''),
            loggedUserid: Joi.string().max(50).required().not(['', null, 'undefined']),
            loggedUsername: Joi.string().max(255).required().not(['', null, 'undefined']),
            hdnAction:Joi.string().max(50).required().not(['', null, 'undefined']),
            remark:Joi.string().max(500).required().not(['', null, 'undefined']),
            status:Joi.string().required().not(['', null, 'undefined']).allow(''),
            oldUserID:Joi.string().required().not(['', null, 'undefined']).allow('')

        });
        
        return updateUserSchema;   
    }

    tempUserStatusSchema(){
        const tempUserStatus = Joi.object().keys({
            str_status: Joi.string().max(50).required().not(['',null,'undefined']),
            str_status1: Joi.string().max(50).required().not(['',null,'undefined']),
            waterMark: Joi.boolean().required().not([null, 'undefined']),
            isLdap: Joi.allow()
        });
        
        return tempUserStatus; 
    }

    updateUserStatusSchema(){
       
        const updateUserStatusSchema = Joi.object().keys({
            userid: Joi.string().max(12).required().not(['',null,'undefined']),
            userName: Joi.string().max(50).required().not(['',null,'undefined']),
            lock: Joi.string().max(100).required().not(['',null,'undefined']),
            role: Joi.string().max(250).required().not(['',null,'undefined']),
            department: Joi.string().max(250).required().not(['', null, 'undefined']),
            loggeduserid: Joi.string().max(50).required().not(['', null, 'undefined']),
            loggedusername: Joi.string().max(255).required().not(['', null, 'undefined']),
            action:Joi.string().max(50).required().not(['', null, 'undefined']),
            remark:Joi.string().max(500).required().not(['', null, 'undefined']),
            status:Joi.string().required().not(['', null, 'undefined']).allow(''),
        });
        
        return updateUserStatusSchema;   
    }
}
module.exports = User;