const express = require('express');
const router = express.Router();

const Joi = require('joi');

class yieldSchema {

    saveYieldSchema() {
        const saveYieldReconSchema = Joi.object().keys({

            BFGCode: Joi.string().max(25).required(),
            ProductName: Joi.string().max(250).required().not(['', null, 'undefined']),
            PVersion: Joi.string().empty(['', null]).allow('', null),
            Version: Joi.string().empty(['', null]).allow('', null),
            ProductType: Joi.string().empty(['', null]).allow('', null),
            CubicleType: Joi.string().empty(['', null]).allow('', null),
            Tab_TheoraticalYield: Joi.number().empty(['', null]).allow('', null),
            Comp_Batch_NLT: Joi.string().empty(['', null]).allow('', null),
            Comp_Batch_NMT: Joi.string().empty(['', null]).allow('', null),
            Comp_YC_NLT: Joi.string().empty(['', null]).allow('', null),
            Comp_YC_NMT: Joi.string().empty(['', null]).allow('', null),
            Coat_Batch_NLT: Joi.string().empty(['', null]).allow('', null),
            Coat_Batch_NMT: Joi.string().empty(['', null]).allow('', null),
            Coat_YC_NLT: Joi.string().empty(['', null]).allow('', null),
            Coat_YC_NMT: Joi.string().empty(['', null]).allow('', null),
            Cap_TheoraticalYield: Joi.number().empty(['', null]).allow('', null),
            Cap_Batch_NLT: Joi.string().empty(['', null]).allow('', null),
            Cap_Batch_NMT: Joi.string().empty(['', null]).allow('', null),
            Cap_YC_NLT: Joi.string().empty(['', null]).allow('', null),
            Cap_YC_NMT: Joi.string().empty(['', null]).allow('', null),
            UserID: Joi.string().max(50).required().not(['', null, 'undefined']),
            UserName: Joi.string().max(100).required().not(['', null, 'undefined']),
            Remark: Joi.string().max(500).required().not(['', null, 'undefined']),
            Action: Joi.string().max(100).required().not(['', null, 'undefined']),
            auditObject: Joi.object().keys({
                result: Joi.object().keys({
                    strNewValue: Joi.string().not([null, 'undefined'])
                })
            })

        });

        return saveYieldReconSchema;
    }

    updateSchemaYield() {
        const updateYieldReconSchema = Joi.object().keys({
            BFGCode: Joi.string().max(25).required(),
            ProductName: Joi.string().max(250).required().not(['', null, 'undefined']),
            PVersion: Joi.string().empty(['', null]).allow('', null),
            Version: Joi.string().empty(['', null]).allow('', null),
            ProductType: Joi.string().empty(['', null]).allow('', null),
            CubicleType: Joi.string().empty(['', null]).allow('', null),
            Tab_TheoraticalYield: Joi.number().empty(['', null]).allow('', null),
            Comp_Batch_NLT: Joi.string().empty(['', null]).allow('', null),
            Comp_Batch_NMT: Joi.string().empty(['', null]).allow('', null),
            Comp_YC_NLT: Joi.string().empty(['', null]).allow('', null),
            Comp_YC_NMT: Joi.string().empty(['', null]).allow('', null),
            Coat_Batch_NLT: Joi.string().empty(['', null]).allow('', null),
            Coat_Batch_NMT: Joi.string().empty(['', null]).allow('', null),
            Coat_YC_NLT: Joi.string().empty(['', null]).allow('', null),
            Coat_YC_NMT: Joi.string().empty(['', null]).allow('', null),
            Cap_TheoraticalYield: Joi.number().empty(['', null]).allow('', null),
            Cap_Batch_NLT: Joi.string().empty(['', null]).allow('', null),
            Cap_Batch_NMT: Joi.string().empty(['', null]).allow('', null),
            Cap_YC_NLT: Joi.string().empty(['', null]).allow('', null),
            Cap_YC_NMT: Joi.string().empty(['', null]).allow('', null),
            UserID: Joi.string().max(50).required().not(['', null, 'undefined']),
            UserName: Joi.string().max(100).required().not(['', null, 'undefined']),
            Remark: Joi.string().max(500).required().not(['', null, 'undefined']),
            Action: Joi.string().max(100).required().not(['', null, 'undefined']),
            auditObject: Joi.object().keys({
                status: Joi.string().required().not([null, 'undefined']),
                result: Joi.object().keys({
                    productYield: Joi.object().keys({
                        oldData: Joi.string().not([null, 'undefined']),
                        newData: Joi.string().not([null, 'undefined'])
                    })
                    
                })
            })


        });

        return updateYieldReconSchema;
    }

    getYieldProductSchema(){
        const getYieldProductSchema = Joi.object().keys({
            BFGCode: Joi.string().max(25).required().not(['', null, 'undefined']),
            ProductName: Joi.string().max(250).required().not(['', null, 'undefined']),
            ProductVersion: Joi.string().max(25).required().not(['', null, 'undefined']),
            Version: Joi.string().max(25).required().not(['', null, 'undefined']),
            CubicleType: Joi.string().max(25).required().not(['', null, 'undefined'])
        });

        return getYieldProductSchema; 
    }

}

module.exports = yieldSchema;