const BatchModel = require('../model/clsBatchModel');
const objBatchModel = new BatchModel();
const BatchSchema = require('../Validation/Batch/batch.schema');
const objBatchSchema = new BatchSchema()
const Joi = require('joi');
const MergePDFModel = require('../model/clsPDFMerge');
const obj_mergePDFModel = new MergePDFModel();

exports.getAreaFromCubicleType = (req, res) => {
    objBatchModel.getAreaFromCubicleType().then((result) => {
        res.statusCode = 200;
        res.send(result);
    }).catch(err => {
        console.log(err)
        res.statusCode = 500;
        let responseObj = {}
        Object.assign(responseObj, {
            status: 'fail'
        }, {
            result: 'Internal server error'
        })
        res.send(responseObj);
    })
}

exports.getCubiclenamebatchsummary = (req, res) => {
    objBatchModel.getCubiclenamebatchsummary(req.body).then((result) => {
        res.statusCode = 200;
        res.send(result);
    }).catch(err => {
        console.log(err)
        res.statusCode = 500;
        let responseObj = {}
        Object.assign(responseObj, {
            status: 'fail'
        }, {
            result: 'Internal server error'
        })
        res.send(responseObj);
    })
}

exports.getProductAll = (req, res) => {
    objBatchModel.getProductAll(req.body).then(result1 => {
        var result = {}
        Object.assign(result, {status:'success', data:result1})
        res.statusCode = 200;
        res.send(result);
    })
}

exports.getProduct = (req, res) => {
    objBatchModel.getProductDetail(req.body).then(result1 => {
        var result = {}
        Object.assign(result, {status:'success', data:result1})
        res.statusCode = 200;
        res.send(result);
    })
}

exports.getMPR = (req, res) => {
    objBatchModel.getMPRDetails(req.body).then(result1 => {
        var result = {}
        Object.assign(result, {status:'success', data:result1})
        res.statusCode = 200;
        res.send(result);
    })
}

exports.getBatches = (req, res) => {
    objBatchModel.getBatches(req.body).then(result1 => {
        var result = {}
        Object.assign(result, {status:'success', data:result1})
        res.statusCode = 200;
        res.send(result);
    })
}

exports.getBatchesAll = (req, res) => {
    Joi.validate(req.body, objBatchSchema.getbatchesAllSchema(), function (err, value) {
        if (err) {
            console.log(err);
            res.statusCode = 400;
            let responseObj = {}
            Object.assign(responseObj, {
                status: 'fail'
            }, {
                    result: err.message
                })
            res.send(responseObj);
        } else {
            objBatchModel.getBatchesAll(value).then(result1 => {
                var result = {}
                Object.assign(result, {status:'success', data:result1})
                res.statusCode = 200;
                res.send(result);
            })
        }
    })

}

exports.getPrintNo = (req, res) => {
    objBatchModel.getPrintNo(req).then(result1 => {
        res.statusCode = 200;
        res.send(result1);
    }).catch(err => {
        console.log(err)
        res.statusCode = 500;
        let responseObj = {}
        Object.assign(responseObj, { status: 'fail' }, { result: err })
        res.send(responseObj);
    })
}

exports.getPrintNoAll = (req,res) =>{
    Joi.validate(req.body, objBatchSchema.getprintnoAllSchema(), function (err, value) {
        if (err) {
            console.log(err);
            res.statusCode = 400;
            let responseObj = {}
            Object.assign(responseObj, {
                status: 'fail'
            }, {
                    result: err.message
                })
            res.send(responseObj);
        } else {
            objBatchModel.getPrintNoAll(req).then(result1 => {
                res.statusCode = 200;
                res.send(result1);
            }).catch(err => {
                console.log(err)
                res.statusCode = 500;
                let responseObj = {}
                Object.assign(responseObj, { status: 'fail' }, { result: 'Internal server error' })
                res.send(responseObj);
            })
        }
    })

}

exports.storeBatchTempData = (req, res) => {
    Joi.validate(req.body, objBatchSchema.storeBatchTempSchema(), function (err, value) {
        if (err) {
            console.log(err);
            res.statusCode = 400;
            let responseObj = {}
            Object.assign(responseObj, {
                status: 'fail'
            }, {
                    result: err.message
                })
            res.send(responseObj);
        } else {
            objBatchModel.processBatchSummeryData(value,req).then((result1) => {
                res.statusCode = 200;
                let responseObj = {}
                Object.assign(responseObj, { status: 'Success' }, { result: 'Data Inserted Successfully' }, {data : result1.HMIId}, {qty : result1.qty},{cntDiam: result1.cntDiam}, {cntDOLOB: result1.cntDOLOB},
                {RecSeqNo: result1.RecSeqNo}, {RecSeqNoR: result1.RecSeqNoR},{cntHard: result1.cntHard},{cntThick: result1.cntThick},{AllParamLod: result1.AllParamLod});
                res.send(responseObj);
            }).catch(err => {
                console.log(err)
                res.statusCode = 500;
                let responseObj = {}
                Object.assign(responseObj, { status: 'fail' }, { result: 'Internal server error' })
                res.send(responseObj);
            })
        }
    })
}

exports.storeBatchTempDataAll = (req, res) => {
    Joi.validate(req.body, objBatchSchema.storeBatchTempAllSchema(), function (err, value) {
        if (err) {
            console.log(err);
            res.statusCode = 400;
            let responseObj = {}
            Object.assign(responseObj, {
                status: 'fail'
            }, {
                    result: err.message
                })
            res.send(responseObj);
        } else {
            objBatchModel.processBatchSummeryDataAll(value,req).then(result1 => {
                res.statusCode = 200;
                let responseObj = {}
                Object.assign(responseObj, { status: 'Success' }, { result: 'Data Inserted Successfully' }, {data : result1});
                res.send(responseObj);
            }).catch(err => {
                console.log(err)
                res.statusCode = 500;
                let responseObj = {}
                Object.assign(responseObj, { status: 'fail' }, { result: 'Internal server error' })
                res.send(responseObj);
            })
        }
    })
}

exports.increasePrintCountSummaryAll = (req, res) => {
    Joi.validate(req.body, objBatchSchema.PrintReportCountSummaryAll(), (err, value) => {
      if (err) {
        res.statusCode = 400;
        let responseObj = {}
        Object.assign(responseObj, {
          status: 'fail'
        }, { result: err })
        res.send(responseObj);
      } else {
        objBatchModel.increasePrintNoSummaryAll(value).then(result => {
          res.statusCode = 200;
          let responseObj = {};
          Object.assign(
            responseObj, { status: "Success" }, { result: "Operation Successfull" }
          );
          res.send(responseObj);
        }).catch(err => {
          console.log(err);
          res.statusCode = 500;
          let responseObj = {};
          Object.assign(
            responseObj, { status: "fail" }, { result: "Internal server error" }
          );
          res.send(responseObj);
        })
      }
    })
  }

  exports.generateAllPdf = (req,res) =>{
    obj_mergePDFModel.mergePDF(req.body.arr_pdffiles,req.body.FileName).then(result1 => {
        res.statusCode = 200;
        let responseObj = {}
        Object.assign(responseObj, { status: 'Success' });
        res.send(responseObj);
    }).catch(err => {
        console.log(err)
        res.statusCode = 500;
        let responseObj = {}
        Object.assign(responseObj, { status: 'fail' }, { result: 'Internal server error' })
        res.send(responseObj);
    });
}

exports.ProductSummary_getProductParameterWise = (req, res) => {
    objBatchModel.ProductSummary_getProductParameterWise(req.body).then(result1 => {
        var result = {}
        Object.assign(result, {status:'success', data:result1})
        res.statusCode = 200;
        res.send(result);
    })
}

exports.ProductSummary_getPrintNo = (req,res) =>{
    Joi.validate(req.body, objBatchSchema.getprintnoAllSchema_ProductSummary(), function (err, value) {
        if (err) {
            console.log(err);
            res.statusCode = 400;
            let responseObj = {}
            Object.assign(responseObj, {
                status: 'fail'
            }, {
                    result: err.message
                })
            res.send(responseObj);
        } else {
            objBatchModel.ProductSummary_getPrintNo(value).then(result1 => {
                res.statusCode = 200;
                res.send(result1);
            }).catch(err => {
                console.log(err)
                res.statusCode = 500;
                let responseObj = {}
                Object.assign(responseObj, { status: 'fail' }, { result: 'Internal server error' })
                res.send(responseObj);
            })
        }
    })

}

exports.storeProductTempData = (req, res) => {
    Joi.validate(req.body, objBatchSchema.storeProductTempSchema(), function (err, value) {
        if (err) {
            console.log(err);
            res.statusCode = 400;
            let responseObj = {}
            Object.assign(responseObj, {
                status: 'fail'
            }, {
                    result: err.message
                })
            res.send(responseObj);
        } else {
            objBatchModel.processProductSummeryData(value,req).then(result => {
                res.statusCode = 200;
                res.send(result);
            }).catch(err => {
                console.log(err)
                res.statusCode = 500;
                let responseObj = {}
                Object.assign(responseObj, { status: 'fail' }, { result: 'Internal server error' })
                res.send(responseObj);
            })
        }
    })
}

exports.printcountupProductSummary = (req, res) => {
    Joi.validate(req.body, objBatchSchema.PrintReportCountProductSummary(), (err, value) => {
      if (err) {
        res.statusCode = 400;
        let responseObj = {}
        Object.assign(responseObj, {
          status: 'fail'
        }, { result: err })
        res.send(responseObj);
      } else {
        objBatchModel.printcountupProductSummary(value).then(result => {
          res.statusCode = 200;
          let responseObj = {};
          Object.assign(
            responseObj, { status: "Success" }, { result: "Operation Successfull" }
          );
          res.send(responseObj);
        }).catch(err => {
          console.log(err);
          res.statusCode = 500;
          let responseObj = {};
          Object.assign(
            responseObj, { status: "fail" }, { result: "Internal server error" }
          );
          res.send(responseObj);
        })
      }
    })
  }