const clsbinModel = require('../model/clsBin.model')
const objclsbinModel = new clsbinModel();
const BinSchema = require('../Validation/bin/bin.schema');
const objBinSchema = new BinSchema()
const Joi = require('joi');

exports.getCleaner = (req, res) => {
    objclsbinModel.getCleaner().then((result) => {
        res.statusCode = 200;
        res.send(result);
    }).catch(err => {
        console.log(err)
        res.statusCode = 500;
        let responseObj = {}
        Object.assign(responseObj, {
            status: 'fail'
        }, {
            result: 'Internal server error'
        })
        res.send(responseObj);
    })
}

exports.addCleaner = (req, res) => {
    Joi.validate(req.body, objBinSchema.getCleanerSchema(), function (err, value) {
        if (err) {
            res.statusCode = 400;
            let responseObj = {}
            Object.assign(responseObj, { status: 'fail' }, { result: 'Bad Request' })
            res.send(responseObj);
        } else {
            objclsbinModel.addCleaner(req).then(result => {
                res.statusCode = 200;
                res.send(result);
            }).catch(err => {
                console.log(err)
                res.statusCode = 500;
                let responseObj = {}
                Object.assign(responseObj, { status: 'fail' }, { result: 'Internal server error' })
                res.send(responseObj);
            })
        }
    })
}

exports.getAuditCleaner = (req, res) => {
    objclsbinModel.getAuditCleaner().then((result) => {
        let responseObj = {};
        res.statusCode = 200;
        Object.assign(responseObj, {
            status: 'success'
        }, {
            result: result
        })
        res.send(responseObj)
    }).catch(err => {
        console.log(err)
        res.statusCode = 500;
        let responseObj = {}
        Object.assign(responseObj, {
            status: 'fail'
        }, {
            result: 'Internal server error'
        })
        res.send(responseObj);
    })
}

exports.getStages = (req, res) => {
    objclsbinModel.getStages().then((result) => {
        res.statusCode = 200;
        res.send(result);
    }).catch(err => {
        console.log(err)
        res.statusCode = 500;
        let responseObj = {}
        Object.assign(responseObj, {
            status: 'fail'
        }, {
            result: 'Internal server error'
        })
        res.send(responseObj);
    })
}

exports.addStage = (req, res) => {
    Joi.validate(req.body, objBinSchema.getStageSchema(), function (err, value) {
        if (err) {
            res.statusCode = 400;
            let responseObj = {}
            Object.assign(responseObj, { status: 'fail' }, { result: 'Bad Request' })
            res.send(responseObj);
        } else {
            objclsbinModel.addStage(req).then(result => {
                res.statusCode = 200;
                res.send(result);
            }).catch(err => {
                console.log(err)
                res.statusCode = 500;
                let responseObj = {}
                Object.assign(responseObj, { status: 'fail' }, { result: 'Internal server error' })
                res.send(responseObj);
            })
        }
    })
}

exports.getAuditStage = (req, res) => {
    objclsbinModel.getAuditStage().then((result) => {
        let responseObj = {};
        res.statusCode = 200;
        Object.assign(responseObj, {
            status: 'success'
        }, {
            result: result
        })
        res.send(responseObj)
    }).catch(err => {
        console.log(err)
        res.statusCode = 500;
        let responseObj = {}
        Object.assign(responseObj, {
            status: 'fail'
        }, {
            result: 'Internal server error'
        })
        res.send(responseObj);
    })
}

exports.getContainer = (req, res) => {
    objclsbinModel.getContainer().then((result) => {
        res.statusCode = 200;
        res.send(result);
    }).catch(err => {
        console.log(err)
        res.statusCode = 500;
        let responseObj = {}
        Object.assign(responseObj, {
            status: 'fail'
        }, {
            result: 'Internal server error'
        })
        res.send(responseObj);
    })
}


exports.getAuditContainer = (req, res) => {
    objclsbinModel.getAuditContainer().then((result) => {
        let responseObj = {};
        res.statusCode = 200;
        Object.assign(responseObj, {
            status: 'success'
        }, {
            result: result
        })
        res.send(responseObj)
    }).catch(err => {
        console.log(err)
        res.statusCode = 500;
        let responseObj = {}
        Object.assign(responseObj, {
            status: 'fail'
        }, {
            result: 'Internal server error'
        })
        res.send(responseObj);
    })
}


exports.addContainer = (req, res) => {
    Joi.validate(req.body, objBinSchema.getContainerSchema(), function (err, value) {
        if (err) {
            res.statusCode = 400;
            let responseObj = {}
            Object.assign(responseObj, { status: 'fail' }, { result: 'Bad Request' })
            res.send(responseObj);
        } else {
            objclsbinModel.addContainer(req).then(result => {
                res.statusCode = 200;
                res.send(result);
            }).catch(err => {
                console.log(err)
                res.statusCode = 500;
                let responseObj = {}
                Object.assign(responseObj, { status: 'fail' }, { result: 'Internal server error' })
                res.send(responseObj);
            })
        }
    })
}

exports.discardContainer = (req, res) => {
    Joi.validate(req.body, objBinSchema.getContainerSchema(), function (err, value) {
        if (err) {
            res.statusCode = 400;
            let responseObj = {}
            Object.assign(responseObj, { status: 'fail' }, { result: 'Bad Request' })
            res.send(responseObj);
        } else {
            objclsbinModel.discardContainer(req).then(result => {
                res.statusCode = 200;
                res.send(result);
            }).catch(err => {
                console.log(err)
                res.statusCode = 500;
                let responseObj = {}
                Object.assign(responseObj, { status: 'fail' }, { result: 'Internal server error' })
                res.send(responseObj);
            })
        }
    })
}

exports.getProductCleanerDetail = (req, res) => {
    objclsbinModel.getProductCleanerDetail(req).then((result) => {
        let responseObj = {};
        res.statusCode = 200;
        Object.assign(responseObj, { status: 'success'}, {result: result})
        res.send(responseObj)
    }).catch(err => {
        console.log(err)
        res.statusCode = 500;
        let responseObj = {}
        Object.assign(responseObj, {
            status: 'fail'
        }, {
            result: err
        })
        res.send(responseObj);
    })
}

exports.getBinForRelease = (req, res) => {
    objclsbinModel.getBinForRelease(req).then((result) => {
        let responseObj = {};
        res.statusCode = 200;
        Object.assign(responseObj, { status: 'success'}, {result: result})
        res.send(responseObj)
    }).catch(err => {
        console.log(err)
        res.statusCode = 500;
        let responseObj = {}
        Object.assign(responseObj, {
            status: 'fail'
        }, {
            result: 'Internal server error'
        })
        res.send(responseObj);
    })
}

exports.getBinSettingInfo = (req, res) => {
    objclsbinModel.getBinSettingInfo().then((result) => {
        let responseObj = {};
        res.statusCode = 200;
        Object.assign(responseObj, {
            status: 'success'
        }, {
            result: result
        })
        res.send(responseObj)
    }).catch(err => {
        console.log(err)
        res.statusCode = 500;
        let responseObj = {}
        Object.assign(responseObj, {
            status: 'fail'
        }, {
            result: 'Internal server error'
        })
        res.send(responseObj);
    })
}

exports.getBinList = (req, res) => {
    objclsbinModel.getBinList().then((result) => {
        res.statusCode = 200;
        res.send(result);
    }).catch(err => {
        console.log(err)
        res.statusCode = 500;
        let responseObj = {}
        Object.assign(responseObj, {
            status: 'fail'
        }, {
            result: 'Internal server error'
        })
        res.send(responseObj);
    })
}

exports.getBinListAssignedToSameCubicle = (req, res) => {
    objclsbinModel.getBinListAssignedToSameCubicle(req).then((result) => {
        res.statusCode = 200;
        res.send(result);
    }).catch(err => {
        console.log(err)
        res.statusCode = 500;
        let responseObj = {}
        Object.assign(responseObj, {
            status: 'fail'
        }, {
            result: 'Internal server error'
        })
        res.send(responseObj);
    })
}

exports.getGrossWtStatus = (req, res) => {
    objclsbinModel.getGrossWtStatus(req).then((result) => {
        res.statusCode = 200;
        res.send(result);
    }).catch(err => {
        console.log(err)
        res.statusCode = 500;
        let responseObj = {}
        Object.assign(responseObj, {
            status: 'fail'
        }, {
            result: 'Internal server error'
        })
        res.send(responseObj);
    })
}

exports.getAreaForAudit = (req, res) => {
    objclsbinModel.getAreaForAudit().then((result) => {
        res.statusCode = 200;
        res.send(result);
    }).catch(err => {
        console.log(err)
        res.statusCode = 500;
        let responseObj = {}
        Object.assign(responseObj, {
            status: 'fail'
        }, {
            result: 'Internal server error'
        })
        res.send(responseObj);
    })
}

exports.getCountBin = (req, res) => {
    objclsbinModel.getCountBin(req).then((result) => {
        let responseObj = {};
        res.statusCode = 200;
        Object.assign(responseObj, {result: result})
        res.send(responseObj)
    }).catch(err => {
        console.log(err)
        res.statusCode = 500;
        let responseObj = {}
        Object.assign(responseObj, {
            status: 'fail'
        }, {
            result: 'Internal server error'
        })
        res.send(responseObj);
    })
}

exports.checkBinBalAssignToCubicle = (req, res) => {
    objclsbinModel.checkBinBalAssignToCubicle(req.body).then((result) => {
        let responseObj = {};
        res.statusCode = 200;
        Object.assign(responseObj, {
            status: 'success'
        }, {
            result: result
        })
        res.send(responseObj)
    }).catch(err => {
        console.log(err)
        res.statusCode = 500;
        let responseObj = {}
        Object.assign(responseObj, {
            status: 'fail'
        }, {
            result: 'Internal server error'
        })
        res.send(responseObj);
    })
}

exports.editTareWeight = (req, res) => {
    objclsbinModel.editTareWeight(req.body).then((result) => {
        let responseObj = {};
        res.statusCode = 200;
        Object.assign(responseObj, {
            status: 'success'
        }, {
            result: result
        })
        res.send(responseObj)
    }).catch(err => {
        console.log(err)
        res.statusCode = 500;
        let responseObj = {}
        Object.assign(responseObj, {
            status: 'fail'
        }, {
            result: 'Internal server error'
        })
        res.send(responseObj);
    })
}


exports.update = (req, res) => {
    Joi.validate(req.body, objBinSchema.updateBinSchema(), function (err, value) {
        if (err) {
            console.log(err);
            res.statusCode = 400;
            let responseObj = {}
            Object.assign(responseObj, {
                status: 'fail'
            }, {
                result: err.message
            })
            res.send(responseObj);
        } else {
            objclsbinModel.update(value).then((result) => {

                let responseObj = {};
                res.statusCode = 200;
                Object.assign(responseObj, {
                    status: 'Success'
                }, {
                    result: 'Bin Updated Successfully'
                })
                if(result.msg){
                    Object.assign(responseObj,result);
                }
                res.send(responseObj)


            }).catch(err => {
                console.log(err)
                res.statusCode = 500;
                let responseObj = {}
                Object.assign(responseObj, {
                    status: 'fail'
                }, {
                    result: 'Internal server error'
                })
                res.send(responseObj);
            })
        }
    });
}

exports.releaseContainer = (req, res) => {
    Joi.validate(req.body, objBinSchema.releaseContainerSchema(), function (err, value) {
        if (err) {
            res.statusCode = 400;
            let responseObj = {}
            Object.assign(responseObj, { status: 'fail' }, { result: 'Bad Request' })
            res.send(responseObj);
        } else {
            objclsbinModel.releaseContainer(req).then(result => {
                res.statusCode = 200;
                res.send(result);
            }).catch(err => {
                console.log(err)
                res.statusCode = 500;
                let responseObj = {}
                Object.assign(responseObj, { status: 'fail' }, { result: 'Internal server error' })
                res.send(responseObj);
            })
        }
    })
}

exports.storeBinDataInTemp = (req, res) => {
    Joi.validate(req.body, objBinSchema.storeBinDataInTempSchema(), function (err, value) {
        if (err) {
            console.log(err);
            res.statusCode = 400;
            let responseObj = {}
            Object.assign(responseObj, {
                status: 'fail'
            }, {
                    result: err.message
                })
            res.send(responseObj);
        } else {
            objclsbinModel.storeBinDataInTemp(value,req).then(result1 => {
                res.statusCode = 200;
                let responseObj = {}
                Object.assign(responseObj, { status: 'Success' }, { result: 'Data Inserted Successfully' }, {data : result1.data}, {calculation : result1.calValues})
                res.send(responseObj);
            }).catch(err => {
                console.log(err)
                res.statusCode = 500;
                let responseObj = {}
                Object.assign(responseObj, { status: 'fail' }, { result: 'Internal server error' })
                res.send(responseObj);
            })
        }
    })
}

exports.getBinDataGetPrd = (req, res) => {
    objclsbinModel.getBinDataGetPrd(req).then((result) => {
        let responseObj = {};
        res.statusCode = 200;
        Object.assign(responseObj, { status: 'success'}, {result: result})
        res.send(responseObj)
    }).catch(err => {
        console.log(err)
        res.statusCode = 500;
        let responseObj = {}
        Object.assign(responseObj, {
            status: 'fail'
        }, {
            result: 'Internal server error'
        })
        res.send(responseObj);
    })
}

exports.getBinDataGetBatch = (req, res) => {
    objclsbinModel.getBinDataGetBatch(req).then((result) => {
        let responseObj = {};
        res.statusCode = 200;
        Object.assign(responseObj, { status: 'success'}, {result: result})
        res.send(responseObj)
    }).catch(err => {
        console.log(err)
        res.statusCode = 500;
        let responseObj = {}
        Object.assign(responseObj, {
            status: 'fail'
        }, {
            result: 'Internal server error'
        })
        res.send(responseObj);
    })
}

exports.getPrinterNo = (req, res) => {
    objclsbinModel.getPrinterNo(req).then((result) => {
        let responseObj = {};
        res.statusCode = 200;
        Object.assign(responseObj, { status: 'success'}, {result: result})
        res.send(responseObj)
    }).catch(err => {
        console.log(err)
        res.statusCode = 500;
        let responseObj = {}
        Object.assign(responseObj, {
            status: 'fail'
        }, {
            result: 'Internal server error'
        })
        res.send(responseObj);
    })
}

exports.getBinMasterData = (req, res) => {
    objclsbinModel.getBinMasterData(req).then((result) => {
        let responseObj = {};
        res.statusCode = 200;
        Object.assign(responseObj, { status: 'success'}, {result: result})
        res.send(responseObj)
    }).catch(err => {
        console.log(err)
        res.statusCode = 500;
        let responseObj = {}
        Object.assign(responseObj, {
            status: 'fail'
        }, {
            result: 'Internal server error'
        })
        res.send(responseObj);
    })
}

exports.storeBinLabelDataInTemp = (req, res) => {
    Joi.validate(req.body, objBinSchema.storeBinLabelDataInTempSchema(), function (err, value) {
        if (err) {
            console.log(err);
            res.statusCode = 400;
            let responseObj = {}
            Object.assign(responseObj, {
                status: 'fail'
            }, {
                    result: err.message
                })
            res.send(responseObj);
        } else {
            objclsbinModel.storeBinLabelDataInTemp(value,req).then(result1 => {
                res.statusCode = 200;
                let responseObj = {}
                Object.assign(responseObj, { status: 'Success' }, { result: 'Data Inserted Successfully' }, {data : result1.data})
                res.send(responseObj);
            }).catch(err => {
                console.log(err)
                res.statusCode = 500;
                let responseObj = {}
                Object.assign(responseObj, { status: 'fail' }, { result: 'Internal server error' })
                res.send(responseObj);
            })
        }
    })
}
exports.getProductFromCubical = (req, res) => {
    Joi.validate(req.body, objBinSchema.getProductFromCubicalSchema(), function (err, value) {
        if (err) {
            console.log(err);
            res.statusCode = 400;
            let responseObj = {}
            Object.assign(responseObj, {
                status: 'fail'
            }, {
                    result: err.message
                })
            res.send(responseObj);
        } else {
            objclsbinModel.getProductFromCubical(value,req).then(result1 => {
                res.statusCode = 200;
                let responseObj = {}
                Object.assign(responseObj, { status: 'Success' }, { result: result1 })
                res.send(responseObj);
            }).catch(err => {
                console.log(err)
                res.statusCode = 500;
                let responseObj = {}
                Object.assign(responseObj, { status: 'fail' }, { result: 'Internal server error' })
                res.send(responseObj);
            })
        }
    })
}

exports.getProductFromProductMaster = (req, res) => {
    objclsbinModel.getProductFromProductMaster().then((result) => {
        res.statusCode = 200;
        res.send(result);
    }).catch(err => {
        console.log(err)
        res.statusCode = 500;
        let responseObj = {}
        Object.assign(responseObj, {
            status: 'fail'
        }, {
            result: 'Internal server error'
        })
        res.send(responseObj);
    })
}

exports.getBatchFromCubicleUsingProduct = (req, res) => {
    objclsbinModel.getBatchFromCubicleUsingProduct(req.body).then((result) => {
        res.statusCode = 200;
        res.send(result);
    }).catch(err => {
        console.log(err)
        res.statusCode = 500;
        let responseObj = {}
        Object.assign(responseObj, {
            status: 'fail'
        }, {
            result: 'Internal server error'
        })
        res.send(responseObj);
    })
}

exports.getProductNameFromProductMaster = (req, res) => {
    objclsbinModel.getProductNameFromProductMaster().then((result) => {
        res.statusCode = 200;
        res.send(result);
    }).catch(err => {
        console.log(err)
        res.statusCode = 500;
        let responseObj = {}
        Object.assign(responseObj, {
            status: 'fail'
        }, {
            result: 'Internal server error'
        })
        res.send(responseObj);
    })
}
exports.getBatches = (req, res) => {
    objclsbinModel.getBatches(req).then((result) => {
        let responseObj = {};
        res.statusCode = 200;
        Object.assign(responseObj, {
            status: 'success'
        }, {
            result: result
        })
        res.send(responseObj)
    }).catch(err => {
        console.log(err)
        res.statusCode = 500;
        let responseObj = {}
        Object.assign(responseObj, {
            status: 'fail'
        }, {
            result: 'Internal server error'
        })
        res.send(responseObj);
    })
}