const clsMultihalerModel = require('../model/multihalerModel');
const objMultihaler = new clsMultihalerModel();
var Joi = require('joi');
const clsMultihalerSchema = require('../Validation/Multihaler/Multihaler.schema');
const objMultihalerSchema = new clsMultihalerSchema();
const clsValidateMultihaler = require('../model/validateNewProductMultihalerClass');
const objValidateMultihaler = new clsValidateMultihaler();
exports.getMultihaler = (req, res) => {
    objMultihaler.getMultihaler().then((result) => {
        res.statusCode = 200;
        res.send(result);
    }).catch(err => {
        console.log(err)
        res.statusCode = 500;
        let responseObj = {}
        Object.assign(responseObj, {
            status: 'fail'
        }, {
            result: 'Internal server error'
        })
        res.send(responseObj);
    })
}

exports.getMultihalerProductDetails = (req,res) => {
    Joi.validate(req.body, objMultihalerSchema.getMultihalerSchema(), function (err, value) {
        if (err) {
            console.log(err);
            res.statusCode = 400;
            let responseObj = {}
            Object.assign(responseObj, {
                status: 'fail'
            }, {
                result: err.message
            })
            res.send(responseObj);
        } else {

            objMultihaler.getMultihalerProductDetails(value).then((result) => {
                res.statusCode = 200;
                res.send(result);
            }).catch(err => {
                console.log(err)
                res.statusCode = 500;
                let responseObj = {}
                Object.assign(responseObj, {
                    status: 'fail'
                }, {
                    result: 'Internal server error'
                })
                res.send(responseObj);
            });
        }
    });
}

exports.addMultihaler = (req,res) => {
    Joi.validate(req.body, objMultihalerSchema.saveMultihalerSchema(), function (err, value) { 
        if (err) {
            console.log(err);
            res.statusCode = 400;
            let responseObj = {}
            Object.assign(responseObj, {
                status: 'fail'
            }, {
                result: err.message
            })
            res.send(responseObj);
        } else {

            objMultihaler.storeMultihaler(value).then((result) => {
                res.statusCode = 200;
                res.send(result);
            }).catch(err => {
                console.log(err)
                res.statusCode = 500;
                let responseObj = {}
                Object.assign(responseObj, {
                    status: 'fail'
                }, {
                    result: 'Internal server error'
                })
                res.send(responseObj);
            });
        }
    });
}

exports.validateAddMultihaler = (req, res) => {
    var objProductNew = req.body.newData;
    if (objProductNew == "") {
        res.statusCode = 400;
        let responseObj = {}
        Object.assign(responseObj, {
            status: 'fail'
        }, {
            result: err
        })
        res.send(responseObj);
    } else {
        objValidateMultihaler.validateAddMultihaler(objProductNew).then((value) => {
                res.statusCode = 200;

                const result = {}
                Object.assign(result, {
                    status: 'Success'
                }, {
                    result: value
                })

                res.send(result);
            }).catch(err => {
                console.log(err)
                res.statusCode = 500;
                let responseObj = {}
                Object.assign(responseObj, {
                    status: 'fail'
                }, {
                    result: 'Internal server error'
                })
                res.send(responseObj);
            })

        
    }
}

exports.activateMultihaler = (req,res) => {
    Joi.validate(req.body, objMultihalerSchema.activateMultihalerSchema(), function (err, value) { 
        if (err) {
            console.log(err);
            res.statusCode = 400;
            let responseObj = {}
            Object.assign(responseObj, {
                status: 'fail'
            }, {
                result: err.message
            })
            res.send(responseObj);
        } else {

            objMultihaler.activateMultihaler(value).then((result) => {
                res.statusCode = 200;
                res.send(result);
            }).catch(err => {
                console.log(err)
                res.statusCode = 500;
                let responseObj = {}
                Object.assign(responseObj, {
                    status: 'fail'
                }, {
                    result: 'Internal server error'
                })
                res.send(responseObj);
            });
        }
    });   
}

exports.validateEditMultihaler = (req,res) => {
    var objProductOld = req.body.oldData;
    var objProductNew = req.body.newData;
    var objProductDetail = req.body.dataPrdDetail;

    if (objProductOld == "") {
        res.statusCode = 400;
        let responseObj = {}
        Object.assign(responseObj, {
            status: 'fail'
        }, {
            result: err
        })
        res.send(responseObj);
    } else {

        objValidateMultihaler.validateEditMultihaler(objProductOld, objProductNew, objProductDetail).then((value) => {
            res.statusCode = 200;

            const result = {}
            Object.assign(result, {
                status: 'Success'
            }, {
                result: value
            })

            res.send(result);
        }).catch(err => {
            console.log(err)
            res.statusCode = 500;
            let responseObj = {}
            Object.assign(responseObj, {
                status: 'fail'
            }, {
                result: 'Internal server error'
            })
            res.send(responseObj);
        })
    }
}

exports.updateMultihaler = (req,res) => {
    Joi.validate(req.body, objMultihalerSchema.updateMultihalerSchema(), function (err, value) { 
        if (err) {
            console.log(err);
            res.statusCode = 400;
            let responseObj = {}
            Object.assign(responseObj, {
                status: 'fail'
            }, {
                result: err.message
            })
            res.send(responseObj);
        } else {
            objMultihaler.updateMultihaler(value).then((result) => {
                res.statusCode = 200;
                res.send(result);
            }).catch(err => {
                console.log(err)
                res.statusCode = 500;
                let responseObj = {}
                Object.assign(responseObj, {
                    status: 'fail'
                }, {
                    result: 'Internal server error'
                })
                res.send(responseObj);
            });
        }
    });
}

exports.checkProductExistMultihaler = (req, res) => {
    objMultihaler.checkProductExistMultihaler(req.body).then((result) => {
        res.statusCode = 200;
        res.send(result);
    }).catch(err => {
        console.log(err)
        res.statusCode = 500;
        let responseObj = {}
        Object.assign(responseObj, {
            status: 'fail'
        }, {
                result: 'Internal server error'
            })
        res.send(responseObj);
    })
}
