const ParameterModel = require('../model/clsParametersModel');
const objParameterModel = new ParameterModel();
const Joi = require('joi');
const clsParameterSchema = require('../Validation/Parameter/Parameter.schema');
const objParameterSchema = new clsParameterSchema();

exports.getAllParameters = (req, res) => {
    objParameterModel.getAllParameterModel().then((result) => {
        res.statusCode = 200;
        res.json(result);
    }).catch(err => {
        console.log(err);
        res.statusCode = 500;
        let responseObj = {}
        Object.assign(responseObj, { status: 'fail' }, { result: 'Internal server error' })
        res.send(responseObj);
    })
}


exports.updateParameters = (req, res) => {
    Joi.validate(req.body, objParameterSchema.saveParameterSchema(), function (err, value) {
        if (err) {
            //console.log(err);
            res.statusCode = 400;
            let responseObj = {}
            Object.assign(responseObj, {
                status: 'fail'
            }, {
                result: err.message
            })
            res.send(responseObj);
        } else {
            objParameterModel.updateParametersModel(value).then(result => {
                if (result) {
                    res.statusCode = 200;
                    let responseObj = {}
                    Object.assign(responseObj, { status: 'success' }, { result: 'Parameters updated successfully' })
                    res.send(responseObj);
                }
    
            }).catch(err => {
                console.log(err)
                res.statusCode = 500;
                let responseObj = {}
                Object.assign(responseObj, { status: 'fail' }, { result: 'Internal server error' })
                res.send(responseObj);
            })
        }

    }); 
}