const implementjs = require('implement-js')
const implement = implementjs.default
const clsproductModel = require('../model/clsproductModel');
const clsProductTabletModel = require('../model/clsProductTabletModel');
const IProduct = require('../Interfaces/IProduct');
const Joi = require('joi');
const ProductBatchSumSchema = require('../Validation/Product/productBatchSummary.schema');
const clsProductSchema = require('../Validation/Product/Product.schema');
const ProductInterface = require('../Interfaces/Product.model');
const clsProductCapsuleModel = require('../model/clsCapsuleModel');
const clsValidateProduct = require('../model/validateProduct.class');
const clsValidateNewProdcut = require('../model/validateNewProduct.class');
/** Object Creation */
const objclsproductModel = new clsproductModel();
const objclsProductCapsuleModel = new clsProductCapsuleModel();
const objProductTabletModel = new clsProductTabletModel();
const objProductBatchSumSchema = new ProductBatchSumSchema()
const objValidateProduct = new clsValidateProduct();
const objProductSchema = new clsProductSchema();
const objValidateNewProdcut = new clsValidateNewProdcut();

exports.getProduct = (req, res) => {
    objclsproductModel.getProductMasterData().then((result) => {
        res.statusCode = 200;
        res.send(result);
    }).catch(err => {
        console.log(err)
        res.statusCode = 500;
        let responseObj = {}
        Object.assign(responseObj, {
            status: 'fail'
        }, {
            result: 'Internal server error'
        })
        res.send(responseObj);
    })
}

exports.saveProduct = (req, res) => {
    const obj = req.body;
    Joi.validate(obj,clsProductSchema.saveTabSchema() , function (err, value) {
        if (err) {
            console.log(err);
            res.statusCode = 400;
            let responseObj = {}
            Object.assign(responseObj, {
                status: 'fail'
            }, {
                result: err
            })
            res.send(responseObj);
        } else {
            //console.log(value);
            objclsproductModel.addProduct(value).then((result) => {
                res.statusCode = 200;
                res.send(result);
            }).catch(err => {
                console.log(err)
                res.statusCode = 500;
                let responseObj = {}
                Object.assign(responseObj, {
                    status: 'fail'
                }, {
                    result: 'Internal server error'
                })
                res.send(responseObj);
            })
        }
    })
}

exports.activateProduct = (req, res) => {
    Joi.validate(req.body, objProductSchema.activateProductSchema(), function (err, value) {
        if (err) {
            console.log(err);
            res.statusCode = 400;
            let responseObj = {}
            Object.assign(responseObj, {
                status: 'fail'
            }, {
                result: err.message
            })
            res.send(responseObj);
        } else {
            objclsproductModel.activateProduct(req).then((result) => {
                res.statusCode = 200;
                res.send(result);
            }).catch(err => {
                console.log(err)
                res.statusCode = 500;
                let responseObj = {}
                Object.assign(responseObj, { status: 'fail' }, { result: 'Internal server error' })
                res.send(responseObj);
            })
        }

    }); 
}

//same Joi schema as approve 
exports.verifyOrRejectProduct = (req, res) => {
    Joi.validate(req.body, objProductSchema.verifyOrRejectProductSchema(), function (err, body) {
        if (err) {
            console.log(err);
            res.statusCode = 400;
            let responseObj = {}
            Object.assign(responseObj, {
                status: 'fail'
            }, {
                result: err.message
            })
            res.send(responseObj);
        } else {
            objclsproductModel.verifyOrRejectProduct(body).then((result) => {
                res.statusCode = 200;
                res.send(result);
            }).catch(err => {
                console.log(err)
                res.statusCode = 500;
                let responseObj = {}
                Object.assign(responseObj, { status: 'fail' }, { result: 'Internal server error' })
                res.send(responseObj);
            })
        }

    }); 
}

exports.getTabletDetails = (req, res) => {
    if (req.body.ProductId == '' || req.body.ProductId == undefined) {
        res.statusCode = 400;
        let responseObj = {}
        Object.assign(responseObj, {
            status: 'fail'
        }, {
            result: 'Bad Request'
        })
        res.send(responseObj);
    } else {
        var Product;
        if(req.body.strProjectName == "OTHER")
        {
            Product = implement(IProduct)({
                ProductId: req.body.ProductId,
                ProductName: req.body.ProductName,
                ProductVersion: req.body.ProductVersion,
                Version: req.body.Version,
                str_GenericName: req.body.str_GenericName,
                SFOID:req.body.SFOID
            })
        }
        else
        {
            Product = implement(IProduct)({
                ProductId: req.body.ProductId,
                ProductName: req.body.ProductName,
                ProductVersion: req.body.ProductVersion,
                Version: req.body.Version,
            })
        }
       

        objProductTabletModel.getTabletDetails(Product,req.body.strProjectName).then((result) => {
            res.statusCode = 200;
            res.send(result);
        }).catch((err) => {
            console.log(err)
            res.statusCode = 500;
            let responseObj = {}
            Object.assign(responseObj, {
                status: 'fail'
            }, {
                result: 'Internal server error'
            })
            res.send(responseObj);
        })
    }
}
exports.getCapsuleDetails = (req, res) => {
    if (req.body.ProductId == '' || req.body.ProductId == undefined) {
        res.statusCode = 400;
        let responseObj = {}
        Object.assign(responseObj, {
            status: 'fail'
        }, {
            result: 'Bad Request'
        })
        res.send(responseObj);
    } else {
        var Product;
        if(req.body.intGenericName1 == 1)
        {
            Product = implement(IProduct)({
                ProductId: req.body.ProductId,
                ProductName: req.body.ProductName,
                ProductVersion: req.body.ProductVersion,
                Version: req.body.Version,
                str_GenericName: req.body.str_GenericName,
            })
        }
        else
        {
           Product = implement(IProduct)({
                ProductId: req.body.ProductId,
                ProductName: req.body.ProductName,
                ProductVersion: req.body.ProductVersion,
                Version: req.body.Version
            })
        }

       

        objclsProductCapsuleModel.getCapsuleDetails(Product,req.body.intGenericName1).then((result) => {
            res.statusCode = 200;
            res.send(result);
        }).catch((err) => {
            console.log(err)
            res.statusCode = 500;
            let responseObj = {}
            Object.assign(responseObj, {
                status: 'fail'
            }, {
                result: 'Internal server error'
            })
            res.send(responseObj);
        })
    }
}
// **********************************************************************************************************//
// Below function takes argument i-e body of request and passed to model also Validate the incoming data
//******************************************************************************************************** */
exports.getProductDetailBatchSummary = (req, res) => {
    // Joi validator
    Joi.validate(req.body, objProductBatchSumSchema.getProductDetSchema(), function (err, value) {
        if (err) {
            console.log(err);
            res.statusCode = 400;
            let responseObj = {}
            Object.assign(responseObj, {
                status: 'fail'
            }, {
                result: err.message
            })
            res.send(responseObj);
        } else {
            objProductTabletModel.getProductDetailBatchSummary(req.body).then((result) => {
                res.statusCode = 200;
                res.send(result);
            }).catch((err) => {
                // console.log(err)
                res.statusCode = 500;
                let responseObj = {}
                Object.assign(responseObj, {
                    status: 'fail'
                }, {
                    result: 'Internal server error'
                })
                res.send(responseObj);
            })
        }
    })
}

exports.getProductCombination = (req, res) => {
    objProductTabletModel.getUniqueCombination(req.params.strPrdType).then((result) => {
        res.statusCode = 200;
        res.send(result);
    }).catch((err) => {
        console.log(err)
        res.statusCode = 500;
        let responseObj = {}
        Object.assign(responseObj, {
            status: 'fail'
        }, {
            result: err
        })
        res.send(responseObj);
    })

}

exports.productDetailForGranulation = (req, res) => {
    Joi.validate(req.body, objProductBatchSumSchema.ProductDetailForGranul(), function (err, value) {
        if (err) {
            console.log(err);
            res.statusCode = 400;
            let responseObj = {}
            Object.assign(responseObj, {
                status: 'fail'
            }, {
                    result: err.message
                })
            res.send(responseObj);
        } else {
            objclsproductModel.getProductDetailForGranulation(req).then(result => {
                res.send(result);
            }).catch(err => {
                console.log(err)
                res.statusCode = 500;
                let responseObj = {}
                Object.assign(responseObj, {
                    status: 'fail'
                }, {
                        result: err
                    })
                res.send(responseObj);
            })
        }
    })
}

exports.productDetail = (req, res) => {
    Joi.validate(req.body, objProductBatchSumSchema.ProductDetail(), function (err, value) {
        if (err) {
            console.log(err);
            res.statusCode = 400;
            let responseObj = {}
            Object.assign(responseObj, {
                status: 'fail'
            }, {
                result: err.message
            })
            res.send(responseObj);
        } else {
            objclsproductModel.getProductDetail(value).then(result => {
                res.send(result);
            }).catch(err => {
                console.log(err)
                res.statusCode = 500;
                let responseObj = {}
                Object.assign(responseObj, {
                    status: 'fail'
                }, {
                    result: err
                })
                res.send(responseObj);
            })
        }
    })
}
exports.checkForCapMaster = (req, res) => {
    Joi.validate(req.body, objProductSchema.productCombinationSchema(), (err, value) => {
        if (err) {
            res.statusCode = 400;
            let responseObj = {}
            Object.assign(responseObj, {
                status: 'fail'
            }, {
                result: err.message
            })
            res.send(responseObj);
        } else {
            objclsproductModel.checkForCapMaster(value).then(result => {
                res.send(result);
            }).catch(err => {
                console.log(err)
                res.statusCode = 500;
                let responseObj = {}
                Object.assign(responseObj, {
                    status: 'fail'
                }, {
                    result: err
                })
                res.send(responseObj);
            })
        }
    })
}
/**
 * @description Function send back response if any parameters weighment is done or not
 * @returns Response object for the requested Api
 * @param req Incoming Request objet
 */
exports.checkForTabMaster = (req, res) => {
    Joi.validate(req.body, objProductSchema.productCombinationSchema(), (err, value) => {
        if (err) {
            res.statusCode = 400;
            let responseObj = {}
            Object.assign(responseObj, {
                status: 'fail'
            }, {
                result: err.message
            })
            res.send(responseObj);
        } else {
            objclsproductModel.checkForTabMaster(value).then(result => {
                res.send(result);
            }).catch(err => {
                console.log(err)
                res.statusCode = 500;
                let responseObj = {}
                Object.assign(responseObj, {
                    status: 'fail'
                }, {
                    result: err
                })
                res.send(responseObj);
            })
        }
    });
}
exports.getProductForEdit = (req, res) => {

    const objProductInterface = new ProductInterface();
    objProductInterface.ProductId = req.body.strProductId;
    objProductInterface.ProductName = req.body.strProductName;
    objProductInterface.ProductVersion = req.body.strProductVersion;
    objProductInterface.Version = req.body.strVersion;
    objProductInterface.ProductType = req.body.strPrdType;

    objclsproductModel.getProductInfo(objProductInterface).then((result) => {
        res.statusCode = 200;
        res.send(result);
    }).catch((err) => {
        console.log(err)
        res.statusCode = 500;
        let responseObj = {}
        Object.assign(responseObj, {
            status: 'fail'
        }, {
            result: err
        })
        res.send(responseObj);
    })

}

exports.updateProduct = (req, res) => {
    const masterData = req.body;
    Joi.validate(masterData, clsProductSchema.updateSchema(), function (err, value) {
        if (err) {
            console.log(err);
            res.statusCode = 400;
            let responseObj = {}
            Object.assign(responseObj, {
                status: 'fail'
            }, {
                result: err
            })
            res.send(responseObj);
        } else {
            Object.assign(value)
            objclsproductModel.updateProduct(value).then((value) => {
                res.statusCode = 200;
                res.send(value);
            }).catch(err => {
                console.log(err)
                res.statusCode = 500;
                let responseObj = {}
                Object.assign(responseObj, {
                    status: 'fail'
                }, {
                    result: 'Internal server error'
                })
                res.send(responseObj);
            })
        }
    })
}

exports.validateProduct = (req, res) => {
    var objProductOld = req.body.oldData;
    var objProductNew = req.body.newData;
    var objProductDetail = req.body.dataPrdDetail;
    var strProjectName = req.body.strProjectName;
    var intGenericName = req.body.intGenericName;

    if (objProductOld == "") {
        res.statusCode = 400;
        let responseObj = {}
        Object.assign(responseObj, {
            status: 'fail'
        }, {
            result: err
        })
        res.send(responseObj);
    } else {

        objValidateProduct.validateProduct(objProductOld, objProductNew,intProductType = 1,objProductDetail,strProjectName,intGenericName).then((value) => {
            res.statusCode = 200;

            const result = {}
            Object.assign(result, {
                status: 'Success'
            }, {
                result: value
            })

            res.send(result);
        }).catch(err => {
            console.log(err)
            res.statusCode = 500;
            let responseObj = {}
            Object.assign(responseObj, {
                status: 'fail'
            }, {
                result: 'Internal server error'
            })
            res.send(responseObj);
        })
    }

}

exports.validateProductMES = (req, res) => {

    var { str_prdId , str_prdName , str_sfoid, int_prdType } = req.body;

    //If any of the required parameter is not send then show bad request
    if ([str_prdId , str_prdName , str_sfoid, int_prdType].includes(undefined)) {
        res.statusCode = 400;
        let responseObj = {}
        Object.assign(responseObj, {
            status: 'fail'
        }, {
            result: 'Bad Request'
        })
        res.send(responseObj);
    } else {

        objValidateProduct.validateProductMes(str_prdId , str_prdName , str_sfoid, int_prdType).then((value) => {
            res.statusCode = 200;

            const result = {}
            Object.assign(result, {
                status: 'success'
            }, {
                result: value
            })

            res.send(result);
        }).catch(err => {
            console.log(err)
            res.statusCode = 500;
            let responseObj = {}
            Object.assign(responseObj, {
                status: 'fail'
            }, {
                result: 'Internal server error'
            })
            res.send(responseObj);
        })
    }

}

exports.validateCapsule = (req, res) => {
    var objProductOld = req.body.oldData;
    var objProductNew = req.body.newData;
    var objProductDetail = req.body.dataPrdDetail;
    var intGenericName = req.body.intGenericName;

    if (objProductOld == "") {
        res.statusCode = 400;
        let responseObj = {}
        Object.assign(responseObj, {
            status: 'fail'
        }, {
            result: err
        })
        res.send(responseObj);
    } else {

        objValidateProduct.validateProduct(objProductOld, objProductNew, intProductType = 2,objProductDetail,"NA",intGenericName).then((value) => {
            res.statusCode = 200;

            const result = {}
            Object.assign(result, {
                status: 'Success'
            }, {
                result: value
            })

            res.send(result);
        }).catch(err => {
            console.log(err)
            res.statusCode = 500;
            let responseObj = {}
            Object.assign(responseObj, {
                status: 'fail'
            }, {
                result: 'Internal server error'
            })
            res.send(responseObj);
        })
    }

}

exports.validateNewProduct = (req, res) => {
    var objProductNew = req.body.newData;
    //console.log(objProductNew);

    if (objProductNew == "") {
        res.statusCode = 400;
        let responseObj = {}
        Object.assign(responseObj, {
            status: 'fail'
        }, {
            result: err
        })
        res.send(responseObj);
    } else {
        if (req.params.strPrdType == 1) {
            objValidateNewProdcut.validateNewProduct(objProductNew).then((value) => {
                res.statusCode = 200;

                const result = {}
                Object.assign(result, {
                    status: 'Success'
                }, {
                    result: value
                })

                res.send(result);
            }).catch(err => {
                console.log(err)
                res.statusCode = 500;
                let responseObj = {}
                Object.assign(responseObj, {
                    status: 'fail'
                }, {
                    result: 'Internal server error'
                })
                res.send(responseObj);
            })
        }
        else {

            objValidateNewProdcut.validateNewProduct(objProductNew, newProductType = 2).then((value) => {
                res.statusCode = 200;

                const result = {}
                Object.assign(result, {
                    status: 'Success'
                }, {
                    result: value
                })

                res.send(result);
            }).catch(err => {
                console.log(err)
                res.statusCode = 500;
                let responseObj = {}
                Object.assign(responseObj, {
                    status: 'fail'
                }, {
                    result: 'Internal server error'
                })
                res.send(responseObj);
            })

        }
    }
}



exports.checkInCubicle = (req, res) => {
    Joi.validate(req.body, objProductSchema.checkInCubicleSchema(), function (err, value) {
        if (err) {
            console.log(err);
            res.statusCode = 400;
            let responseObj = {}
            Object.assign(responseObj, {
                status: 'fail'
            }, {
                result: err.message
            })
            res.send(responseObj);
        } else {
            objclsproductModel.checkInCubicle(req).then((result) => {
                res.statusCode = 200;
                res.send(result);
            }).catch(err => {
                console.log(err)
                res.statusCode = 500;
                let responseObj = {}
                Object.assign(responseObj, { status: 'fail' }, { result: 'Internal server error' })
                res.send(responseObj);
            })
        }

    }); 
}

exports.getStatusCount = (req, res) => {
    Joi.validate(req.body, objProductSchema.getStatusCountSchema(), function (err, value) {
        if (err) {
            console.log(err);
            res.statusCode = 400;
            let responseObj = {}
            Object.assign(responseObj, {
                status: 'fail'
            }, {
                result: err.message
            })
            res.send(responseObj);
        } else {
            objclsproductModel.getStatusCount(req).then((result) => {
                res.statusCode = 200;
                res.send(result);
            }).catch(err => {
                console.log(err)
                res.statusCode = 500;
                let responseObj = {}
                Object.assign(responseObj, { status: 'fail' }, { result: 'Internal server error' })
                res.send(responseObj);
            })
        }

    }); 
}

exports.checkProductExist = (req, res) => {
    objclsproductModel.checkProductExist(req.body).then((result) => {
        res.statusCode = 200;
        res.send(result);
    }).catch(err => {
        console.log(err)
        res.statusCode = 500;
        let responseObj = {}
        Object.assign(responseObj, {
            status: 'fail'
        }, {
                result: 'Internal server error'
            })
        res.send(responseObj);
    })
}

exports.addExcelData = (req, res) => {
    objclsproductModel.addExcelData(req.body).then((result) => {
        res.statusCode = 200;
        res.send(result);
    }).catch(err => {
        console.log(err)
        res.statusCode = 500;
        let responseObj = {}
        Object.assign(responseObj, {
            status: 'fail'
        }, {
                result: 'Internal server error'
            })
        res.send(responseObj);
    })
}

exports.checkWeighmentDone = (req, res) => {
    objclsproductModel.checkWeighmentDone(req.body).then((result) => {
        res.statusCode = 200;
        res.send(result);
    }).catch(err => {
        console.log(err)
        res.statusCode = 500;
        let responseObj = {}
        Object.assign(responseObj, {
            status: 'fail'
        }, {
                result: 'Internal server error'
            })
        res.send(responseObj);
    })
}