const TabletCapsuleModel = require('../model/clsTabletCapsuleModel');
const objTabletCapsuleMaster = new TabletCapsuleModel();
const ReportSchema = require('../validation/report/report.schema');
const objReportSchema = new ReportSchema();
const Joi = require('joi');
const requestIp = require('request-ip');

exports.printReasonReport = (req, res) =>{
  Joi.validate(req.body, objReportSchema.printReasonReporteSchema(), function (err, value) {
    if (err) {
      console.log(err);
      res.statusCode = 400;
      const responseObj = {};
      Object.assign(responseObj, { status: 'fail' }, { result: err.message });
      res.send(responseObj);

    } else {
      objTabletCapsuleMaster.printReasonReport(value,req).then(result => {
        res.statusCode = 200;
        res.send(result);

      }).catch(err => {
        console.log(err);
        res.statusCode = 500;
        const responseObj = {};
        Object.assign(responseObj, { status: "fail" }, { result: err });
        res.send(responseObj);
      });
    }
  });
};

exports.checkReportIsVerified = (req, res) => {
  Joi.validate(req.body, objReportSchema.checkReportIsVerified(), (err, value) => {
    if (err) {
      res.statusCode = 400;
      const responseObj = {};
      Object.assign(responseObj, { status: 'fail' }, { result: err });
      res.send(responseObj);

    } else {
      objTabletCapsuleMaster.checkReportIsVerified(value).then(result => {
        res.statusCode = 200;
        const responseObj = {};
        Object.assign(responseObj, { status: "Success" }, { result: result });
        res.send(responseObj);

      }).catch(err => {
        console.log(err);
        res.statusCode = 500;
        const responseObj = {};
        Object.assign(responseObj, { status: "fail" }, { result: err });
        res.send(responseObj);
      });
    }
  });
};

exports.verifyReport = (req, res) => {
  Joi.validate(req.body, objReportSchema.VerifyReport(), (err, value) => {
    if (err) {
      res.statusCode = 400;
      const responseObj = {};
      Object.assign(responseObj, { status: 'fail' }, { result: err });
      res.send(responseObj);

    } else {
      objTabletCapsuleMaster.verifyReport(value).then(result => {
        res.statusCode = 200;
        const responseObj = {};
        Object.assign(responseObj, { status: "Success" }, { result: "Report Verification Successfull" });
        res.send(responseObj);

      }).catch(err => {
        console.log(err);
        res.statusCode = 500;
        const responseObj = {};
        Object.assign(responseObj, { status: "fail" }, { result: err });
        res.send(responseObj);
      });
    }
  });
};

exports.verifyExceptionReport = (req, res) => {
  Joi.validate(req.body, objReportSchema.VerifyExceptionReport(), (err, value) => {
    if (err) {
      res.statusCode = 400;
      const responseObj = {};
      Object.assign(responseObj, { status: 'fail' }, { result: err });
      res.send(responseObj);

    } else {
      objTabletCapsuleMaster.verifyExceptionReport(value).then(result => {
        res.statusCode = 200;
        const responseObj = {};
        Object.assign(responseObj, { status: "Success" }, { result: result });
        res.send(responseObj);

      }).catch(err => {
        console.log(err);
        res.statusCode = 500;
        const responseObj = {};
        Object.assign(responseObj, { status: "fail" }, { result: err });
        res.send(responseObj);
      });
    }
  });
};

exports.increasePrintCount = (req, res) => {
  Joi.validate(req.body, objReportSchema.PrintReportCount(), (err, value) => {
    if (err) {
      res.statusCode = 400;
      const responseObj = {};
      Object.assign(responseObj, { status: 'fail' }, { result: err });
      res.send(responseObj);

    } else {
      objTabletCapsuleMaster.increasePrintNo(value).then(result => {
        res.statusCode = 200;
        const responseObj = {};
        Object.assign(responseObj, { status: "Success" }, { result: "Operation Successfull" });
        res.send(responseObj);

      }).catch(err => {
        console.log(err);
        res.statusCode = 500;
        const responseObj = {};
        Object.assign(responseObj, { status: "fail" }, { result: err });
        res.send(responseObj);
      });
    }
  });
};

exports.getWeighmentReportDetails = (req, res) => {
  Joi.validate(req.body, objReportSchema.getWeighmentReportSchema(), function (err, value) {
    if (err) {
      console.log(err);
      res.statusCode = 400;
      const responseObj = {};
      Object.assign(responseObj, { status: 'fail' }, { result: err.message });
      res.send(responseObj);

    } else {
      objTabletCapsuleMaster.getWeighmentReportDetails(req).then(result => {
          res.statusCode = 200;
          res.send(result);

      }).catch(err => {
        console.log(err);
        res.statusCode = 500;
        const responseObj = {};
        Object.assign(responseObj, { status: "fail" }, { result: err });
        res.send(responseObj);
      });
    }
  });
};

exports.getWeighmentReportDetails_StartUp = (req, res) => {
  Joi.validate(req.body, objReportSchema.getWeighmentReportSchema(), function (err, value) {
    if (err) {
      console.log(err);
      res.statusCode = 400;
      const responseObj = {};
      Object.assign(responseObj, { status: 'fail' }, { result: err.message });
      res.send(responseObj);

    } else {
      objTabletCapsuleMaster.getWeighmentReportDetails_StartUp(req).then(result => {
          res.statusCode = 200;
          res.send(result);

      }).catch(err => {
        console.log(err);
        res.statusCode = 500;
        const responseObj = {};
        Object.assign(responseObj, { status: "fail" }, { result: err });
        res.send(responseObj);
      });
    }
  });
};

exports.viewSeparateReport = (req,res) => {
  Joi.validate(req.body,objReportSchema.viewReportSchema(), function(err,value){
    if(err) {
      console.log(err);
      res.statusCode = 400;
      const responseObj = {};
      Object.assign(responseObj,{status:'fail'},{result : err.message});
      res.send(responseObj);

    }else{
      objTabletCapsuleMaster.viewSeparateReport(value,req).then(result =>{
        res.statusCode = 200;
        res.send(result);
        
      }).catch(err =>{
        console.log(err);
        res.statusCode = 500;
        const responseObj = {};
        Object.assign(responseObj,{status:'fail'},{result : err});
        res.send(responseObj);
      });
    }
  });
};

exports.viewSeparateReport_Startup = (req,res) => {
  Joi.validate(req.body,objReportSchema.viewReportSchema(), function(err,value){
    if(err) {
      console.log(err);
      res.statusCode = 400;
      const responseObj = {};
      Object.assign(responseObj,{status:'fail'},{result : err.message});
      res.send(responseObj);

    }else{
      objTabletCapsuleMaster.viewSeparateReport_Startup(value,req).then(result =>{
        res.statusCode = 200;
        res.send(result);
        
      }).catch(err =>{
        console.log(err);
        res.statusCode = 500;
        const responseObj = {};
        Object.assign(responseObj,{status:'fail'},{result : err});
        res.send(responseObj);
      });
    }
  });
};


exports.getWeighmentReportDetails_Consolidated = (req, res) => {
  Joi.validate(req.body, objReportSchema.getWeighmentReportConsolidatedSchema(), function (err, value) {
    if (err) {
      console.log(err);
      res.statusCode = 400;
      const responseObj = {};
      Object.assign(responseObj, { status: 'fail' }, { result: err.message });
      res.send(responseObj);

    } else {
      objTabletCapsuleMaster.getWeighmentReportDetails_Consolidated(req).then(result => {
        res.statusCode = 200;
        res.send(result);
        
      }).catch(err => {
        console.log(err);
        res.statusCode = 500;
        const responseObj = {};
        Object.assign(responseObj, { status: "fail" }, { result: err });
        res.send(responseObj);
      });
    }
  });
};

exports.viewConsolidateReport = (req,res) => {
  Joi.validate(req.body,objReportSchema.viewConsolidateReportSchema(), function(err,value){
    if(err) {
      console.log(err);
      res.statusCode = 400;
      const responseObj = {};
      Object.assign(responseObj,{status:'fail'},{result : err.message});
      res.send(responseObj);

    }else{
      objTabletCapsuleMaster.viewConsolidateReport(value,req).then(result =>{
        res.statusCode = 200;
        res.send(result);

      }).catch(err =>{
        console.log(err);
        res.statusCode = 500;
        const responseObj = {};
        Object.assign(responseObj,{status:'fail'},{result : err});
        res.send(responseObj);
      });
    }
  });
};
exports.viewExceptionRpt = (req,res) => {
  // Joi.validate(req.body,objReportSchema.viewExceptionRptSchema(), function(err,value){
  //   if(err) {
  //     console.log(err);
  //     res.statusCode = 400;
  //     const responseObj = {};
  //     Object.assign(responseObj,{status:'fail'},{result : err.message});
  //     res.send(responseObj);

  //   }else{
  const clientIp = requestIp.getClientIp(req);
      objTabletCapsuleMaster.viewExceptionRpt(req.body,clientIp).then(result =>{
        res.statusCode = 200;
        res.send(result);

      }).catch(err =>{
        console.log(err);
        res.statusCode = 500;
        const responseObj = {};
        Object.assign(responseObj,{status:'fail'},{result : err});
        res.send(responseObj);
      });
    // }
  // });
};
