const clsvernierModel = require('../model/clsvernierModel');
const objclsvernierModel = new clsvernierModel();
const clsVernierSchema = require('../Validation/Vernier/Vernier.schema');
const objclsVernierSchema = new clsVernierSchema();
const Joi = require('joi');

exports.getVernier = (req, res) => {
    objclsvernierModel.getVernier(req).then((result) => {
        res.statusCode = 200;
        res.send(result);
    }).catch(err => {
        console.log(err)
        res.statusCode = 500;
        let responseObj = {}
        Object.assign(responseObj, { status: 'fail' }, { result: 'Internal server error' })
        res.send(responseObj);
    })
}

exports.storeVernier = (req, res) => {
    if ((req.body.vernierCode == '') || (req.body.vernierCode === undefined) || 
    (req.body.cal_store_type == '') || (req.body.cal_store_type === undefined) || 
    (req.body.calibration_date == '') || (req.body.calibration_date === undefined) ||
    (req.body.vernierMake == '') || (req.body.vernierMake === undefined) || 
    (req.body.leastCount == '') || (req.body.leastCount === undefined) || 
    (req.body.minRange == '') || (req.body.minRange === undefined) || 
    (req.body.maxRange == '') || (req.body.maxRange === undefined) || 
    (req.body.vernierModelNo == '') || (req.body.vernierModelNo === undefined) || 
    (req.body.unit == '') || (req.body.unit === undefined) || 
    (req.body.vernierSerialNo == '') || (req.body.vernierSerialNo === undefined) || 
    (req.body.set_reminder == '') || (req.body.set_reminder === undefined) || 
    (req.body.weights == '') || (req.body.weights === undefined) ||
    (req.body.remark == '') || (req.body.remark === undefined) ||
    (req.body.hdnAction == '') || (req.body.hdnAction === undefined) ||
    (req.body.LoggeduserId == '') || (req.body.LoggeduserId === undefined) ||
    (req.body.Loggedusername == '') || (req.body.Loggedusername === undefined) ||
    (req.body.newParameter == '') || (req.body.newParameter === undefined) ||
    (req.body.int_dp == '') || (req.body.int_dp === undefined) ||
    (req.body.strPeriodicName == '') || (req.body.strPeriodicName === undefined)) {
        res.statusCode = 400;
        let responseObj = {}
        Object.assign(responseObj, { status: 'fail' }, { result: 'Bad Request' })
        res.send(responseObj);
    } else {
        objclsvernierModel.storeVernier(req).then((result) => {
            res.statusCode = 200;
            res.send(result);
        }).catch(err => {
            console.log(err)
            res.statusCode = 500;
            let responseObj = {}
            Object.assign(responseObj, { status: 'fail' }, { result: 'Internal server error' })
            res.send(responseObj);
        })
    }
}

exports.updateLockVernier = (req, res) => {
    if ((req.body.lock == '') || (req.body.lock === undefined) || 
        (req.body.type == '') || (req.body.type === undefined) || 
        (req.body.vernierID == '') || (req.body.vernierID === undefined)) {
        res.statusCode = 400;
        let responseObj = {}
        Object.assign(responseObj, { status: 'fail' }, { result: 'Bad Request' })
        res.send(responseObj);
    } else {
        objclsvernierModel.updateLockVernier(req).then((result) => {
            res.statusCode = 200;
            res.send(result);
        }).catch(err => {
            console.log(err)
            res.statusCode = 500;
            let responseObj = {}
            Object.assign(responseObj, { status: 'fail' }, { result: 'Internal server error' })
            res.send(responseObj);
        })
    }
}

exports.updateVernier = (req, res) => {
    if ((req.body.vernierCode == '') || (req.body.vernierCode === undefined) ||
     (req.body.cal_store_type == '') || (req.body.cal_store_type === undefined) || 
     (req.body.calibration_date == '') || (req.body.calibration_date === undefined) || 
     (req.body.vernierMake == '') || (req.body.vernierMake === undefined) || 
     (req.body.leastCount == '') || (req.body.leastCount === undefined) || 
     (req.body.maxRange == '') || (req.body.maxRange === undefined) || 
     (req.body.minRange == '') || (req.body.minRange === undefined) || 
     (req.body.modelNo == '') || (req.body.modelNo === undefined) || 
     (req.body.selectedUnit == '') || (req.body.selectedUnit === undefined) || 
     (req.body.serialNo == '') || (req.body.serialNo === undefined) || 
     (req.body.set_reminder == '') || (req.body.set_reminder === undefined) ||
     (req.body.weights == '') || (req.body.weights === undefined) ||
     (req.body.remark == '') || (req.body.remark === undefined) ||
     (req.body.hdnAction == '') || (req.body.hdnAction === undefined) ||
     (req.body.LoggeduserId == '') || (req.body.LoggeduserId === undefined) ||
     (req.body.Loggedusername == '') || (req.body.Loggedusername === undefined) ||
     (req.body.newParameter == '') || (req.body.newParameter === undefined) ||
     (req.body.oldParameter == '') || (req.body.oldParameter === undefined) ||
     (req.body.oldWeights == '') || (req.body.oldWeights === undefined) ||
     (req.body.newWeights == '') || (req.body.newWeights === undefined) ||
     (req.body.bal_dp == '') || (req.body.bal_dp === undefined)) {
        res.statusCode = 400;
        let responseObj = {}
        Object.assign(responseObj, { status: 'fail' }, { result: 'Bad Request' })
        res.send(responseObj);
    } else {
        objclsvernierModel.updateVernier(req).then((result) => {
            res.statusCode = 200;
            res.send(result);
        }).catch(err => {
            console.log(err)
            res.statusCode = 500;
            let responseObj = {}
            Object.assign(responseObj, { status: 'fail' }, { result: 'Internal server error' })
            res.send(responseObj);
        })
    }
}

exports.updateStatus = (req, res) => {
    Joi.validate(req.body, objclsVernierSchema.updateStatusSchema(), function (err, value) {
        if (err) {
            res.statusCode = 400;
            let responseObj = {}
            Object.assign(responseObj, {
                status: 'fail'
            }, {
                    result: err.message
                })
            res.send(responseObj);
        } else {
            objclsvernierModel.updateStatus(value).then(result => {
                res.statusCode = 200;
                res.send(result);
            }).catch(err => {
                console.log(err)
                res.statusCode = 500;
                let responseObj = {}
                Object.assign(responseObj, {
                    status: 'fail'
                }, {
                        result: 'Internal server error'
                    })
                res.send(responseObj);
            })
        }
    })
}

exports.releaseRejectVernier = (req, res) => {
    Joi.validate(req.body, objclsVernierSchema.updateStatusSchema(), function (err, value) {
        if (err) {
            res.statusCode = 400;
            let responseObj = {}
            Object.assign(responseObj, {
                status: 'fail'
            }, {
                    result: err.message
                })
            res.send(responseObj);
        } else {
            objclsvernierModel.releaseRejectVernier(value).then(result => {
                res.statusCode = 200;
                res.send(result);
            }).catch(err => {
                console.log(err)
                res.statusCode = 500;
                let responseObj = {}
                Object.assign(responseObj, {
                    status: 'fail'
                }, {
                        result: 'Internal server error'
                    })
                res.send(responseObj);
            })
        }
    })
}

exports.insertWithoutWeight = (req, res) => {
    Joi.validate(req.body, objclsVernierSchema.insertWithoutWeightSchema(), function (err, value) {
        if (err) {
            res.statusCode = 400;
            let responseObj = {}
            Object.assign(responseObj, {
                status: 'fail'
            }, {
                    result: err.message
                })
            res.send(responseObj);
        } else {
            objclsvernierModel.addVernier(value,req).then(result => {
                res.statusCode = 200;
                res.send(result);
            }).catch(err => {
                console.log(err)
                res.statusCode = 500;
                let responseObj = {}
                Object.assign(responseObj, {
                    status: 'fail'
                }, {
                        result: 'Internal server error'
                    })
                res.send(responseObj);
            })
        }
    })
}

exports.updateWithoutWeight = (req, res) => {
    Joi.validate(req.body, objclsVernierSchema.updateWithoutWeightSchema(), function (err, value) {
        if (err) {
            console.log(err);
            res.statusCode = 400;
            let responseObj = {}
            Object.assign(responseObj, {
                status: 'fail'
            }, {
                    result: err.message
                })
            res.send(responseObj);
        } else {
            objclsvernierModel.updateWithoutWeight(value).then((result) => {
                res.statusCode = 200;
                res.send(result);
            }).catch(err => {
                console.log(err)
                res.statusCode = 500;
                let responseObj = {}
                Object.assign(responseObj, { status: 'fail' }, { result: 'Internal server error' })
                res.send(responseObj);
            })

        }
    })
}

exports.getVernierWithoutWeight = (req, res) => {
    objclsvernierModel.getWithoutWeightStatus(req).then((result) => {
        res.statusCode = 200;
        res.send(result);
    }).catch(err => {
        console.log(err)
        res.statusCode = 500;
        let responseObj = {}
        Object.assign(responseObj, { status: 'fail' }, { result: 'Internal server error' })
        res.send(responseObj);
    })
}

exports.checkInCubicle = (req,res) => {
    if((req.body.vernierID == '') || (req.body.vernierID === undefined)){
        res.statusCode = 400;
        let responseObj = {}
        Object.assign(responseObj, { status: 'fail' }, { result: 'Bad Request' })
        res.send(responseObj);
    }
    else{
        objclsvernierModel.checkInCubicle(req).then((result) => {
            res.statusCode = 200;
            res.send(result);
        }).catch(err => {
            console.log(err)
            res.statusCode = 500;
            let responseObj = {}
            Object.assign(responseObj, { status: 'fail' }, { result: 'Internal server error' })
            res.send(responseObj);
        })
    }
}
