const moment = require('moment-timezone')

function convertDate(dateInUTCFormat) { 
    return new Promise((resolve, reject) => { 
        var dec = moment(dateInUTCFormat);
        var normalDate = dec.tz('Asia/Kolkata').format('YYYY-MM-DD');  // GMT +5:30 (India)
        resolve(normalDate);
    }) 
}


function convertTime(dateInUTCFormat) { 
    return new Promise((resolve, reject) => { 
        var dec = moment(dateInUTCFormat);
        var normalDate = dec.tz('Asia/Kolkata').format('HH:mm:ss');  // GMT +5:30 (India)
        resolve(normalDate);
    }) 
}

function getCurrentDateNTime() { 
    return new Promise((resolve, reject) => { 
        var dec = moment(dateInUTCFormat);
        var normalDate = dec.tz('Asia/Kolkata').format('YYYY-MM-DD');  // GMT +5:30 (India)
        var normalTime = dec.tz('Asia/Kolkata').format('HH:mm:ss');  // GMT +5:30 (India)
        objDateTime = {
            CurrentDate: normalDate,
            CurrentTime: normalTime
        }
        resolve(objDateTime);
    }) 
}


module.exports.convertDate = convertDate;
module.exports.convertTime = convertTime;
module.exports.getCurrentDateNTime = getCurrentDateNTime;
