
const date = require('date-and-time');
const models = require("../dbConnection").models;
const seqTransaction = require("../dbConnection");
const sequelize = require("../dbConnection").sequelize;

class AlertSetting {

    async UpdateAlertSetting(objAlertSetting) {

        try {
            let transaction = await seqTransaction.sequelize.transaction(async (t) => {
                var now = new Date();
                await models.tbl_alert_param_duration.update({
                    ProductId : objAlertSetting.ProductId,
                    ProductName : objAlertSetting.ProductName,
                    ProductVersion : objAlertSetting.ProductVersion,
                    Version : objAlertSetting.Version,
                    Batch : objAlertSetting.Batch,
                    Group: objAlertSetting.Group ,
                    Sys_Area : objAlertSetting.Sys_Area,
                    Sys_CubicName : objAlertSetting.Sys_CubicName
                },
                {
                    where:{ CubicNo : objAlertSetting.CubicNo },
                    transaction : t
                });

                await models.tbl_cubical.update({
                    Sys_flagAlert: 1
                },
                { 
                    where : { Sys_CubicNo:objAlertSetting.CubicNo },
                    transaction: t
                });

                await models.tbl_batches.update({
                    dt1:date.format(now, 'YYYY-MM-DD'),
                    tm1:date.format(now, 'HH:mm:ss')
                },{
                    where:{ 
                        Prod_ID : objAlertSetting.ProductId,
                        Prod_Name : objAlertSetting.ProductName,
                        Prod_Version : objAlertSetting.ProductVersion,
                        Version : objAlertSetting.Version,
                        Batch : objAlertSetting.Batch,
                        CubicNo:objAlertSetting.CubicNo 
                    },
                    transaction:t
                });

                await models.tbl_audit_alertsetting.create({
                    dt: date.format(now, 'YYYY-MM-DD'),
                    tm: date.format(now, 'HH:mm:ss'),
                    userid: objAlertSetting.UserID,
                    username: objAlertSetting.UserName,
                    ACT: objAlertSetting.Action,
                    Remark: objAlertSetting.Remark,
                    ProductId: objAlertSetting.ProductId,
                    ProductName: objAlertSetting.ProductName,
                    ProductVersion: objAlertSetting.ProductVersion,
                    Version: objAlertSetting.Version,
                    Batch: objAlertSetting.Batch,
                    OldValue: objAlertSetting.OldData,
                    NewValue: objAlertSetting.NewData,
                    Area: objAlertSetting.Sys_Area
                },
                {
                    transaction:t
                });

                await models.tbl_activity_log.create({
                    dt: date.format(now, 'YYYY-MM-DD'),
                    tm: date.format(now, 'HH:mm:ss'),
                    userid: objAlertSetting.UserID,
                    username: objAlertSetting.UserName,
                    activity: objAlertSetting.Action
                },{
                    transaction:t
                });
                return 'Success'
            });
            return transaction;
        } catch (error) {
            console.log(error);
            throw error;
        }
    }

    // auditAlertSetting(objAlertSetting) {
    //     return new Promise((resolve, reject) => {
    //         var now = new Date();
    //         const auditAlert = {
    //             str_tableName: "tbl_audit_alertsetting",
    //             data: [
    //                 { str_colName: 'dt', value: date.format(now, 'YYYY-MM-DD') },
    //                 { str_colName: 'tm', value: date.format(now, 'HH:mm:ss') },
    //                 { str_colName: 'userid', value: objAlertSetting.UserID },
    //                 { str_colName: 'username', value: objAlertSetting.UserName },
    //                 { str_colName: 'ACT', value: objAlertSetting.Action },
    //                 { str_colName: 'Remark', value: objAlertSetting.Remark },
    //                 { str_colName: 'ProductId', value: objAlertSetting.ProductId },
    //                 { str_colName: 'ProductName', value: objAlertSetting.ProductName },
    //                 { str_colName: 'ProductVersion', value: objAlertSetting.ProductVersion },
    //                 { str_colName: 'Version', value: objAlertSetting.Version },
    //                 { str_colName: 'Batch', value: objAlertSetting.Batch },
    //                 { str_colName: 'OldValue', value: objAlertSetting.OldData },
    //                 { str_colName: 'NewValue', value: objAlertSetting.NewData },
    //                 { str_colName: 'Area', value: objAlertSetting.Sys_Area }
    //             ],
    //             action: 'in'

    //         }

    //         resolve(auditAlert);
    //     })

    // }

    // auditActivityLog(objAlertSetting) {
    //     return new Promise((resolve, reject) => {
    //         var now = new Date();
    //         const auditAlert = {
    //             str_tableName: "tbl_activity_log",
    //             data: [
    //                 { str_colName: 'dt', value: date.format(now, 'YYYY-MM-DD') },
    //                 { str_colName: 'tm', value: date.format(now, 'HH:mm:ss') },
    //                 { str_colName: 'userid', value: objAlertSetting.UserID },
    //                 { str_colName: 'username', value: objAlertSetting.UserName },
    //                 { str_colName: 'activity', value: objAlertSetting.Action }
    //             ],
    //             action: 'in'

    //         }

    //         resolve(auditAlert);
    //     })

    // }


    // async saveAlertSetting(objAlertSetting) {
    //     var arrQueries = [];
    //     const objAlert = {
    //         str_tableName: "tbl_alert_param_duration",
    //         data: [
    //             { str_colName: 'CubicNo', value: objAlertSetting.CubicNo },
    //             { str_colName: 'ProductId', value: objAlertSetting.ProductId },
    //             { str_colName: 'ProductName', value: objAlertSetting.ProductName },
    //             { str_colName: 'ProductVersion', value: objAlertSetting.ProductVersion },
    //             { str_colName: 'Version', value: objAlertSetting.Version },
    //             { str_colName: 'Batch', value: objAlertSetting.Batch },
    //             { str_colName: 'Group', value: objAlertSetting.Group },
    //             { str_colName: 'Sys_Area', value: objAlertSetting.Sys_Area },
    //             { str_colName: 'Sys_CubicName', value: objAlertSetting.Sys_CubicName }

    //         ],
    //         action: 'in'
    //     }

    //     const objAudit = await this.auditAlertSetting(objAlertSetting);
    //     const objActivity = await this.auditActivityLog(objAlertSetting);

    //     arrQueries.push(objAlert, objAudit, objActivity);
    //     const result = await objTransDatabase.funMakeQueries(arrQueries);

    //     if (result != "") {
    //         return result;
    //     }



    // }

    async getAlertSettingByCubicNo(objAlert) {
        try {
            let res = await models.tbl_alert_param_duration.findAll({where:
                {CubicNo: objAlert.CubicNo}
            });
            return [...res];
        } catch (error) {
            console.log(error);
            throw error;
        }
    }

    async getAlertAuditData(objReqAlert) {
        try {
            let res = await models.tbl_audit_alertsetting.findAll({attributes:[[sequelize.literal('DISTINCT area'), 'area']]});
            return [...res];
        } catch (error) {
            console.log(error);
            throw error;
        }
    }
}

module.exports = AlertSetting;