const models = require("../dbConnection").models;
const date = require("date-and-time");
const seqTransaction = require("../dbConnection");
const sequelize = require("../dbConnection").sequelize;
const { QueryTypes } = require('sequelize');
const {Op} = require("sequelize");
var config = require('../global/serverConfig');
const requestIp = require('request-ip');
const e = require("express");

const  int_BatchSizeWithUnit = config.developerPanelData.IncrencyCommon.find(x => x.Name === 'BatchSizeWithUnit').Value;

class BinModel {

    /**
     * This function is used to get list of cleaner from tbl_bin_cleaner table
     */
    async getCleaner(){
        try {
            let result = await models.tbl_bin_cleaner.findAll({});
            return result;
        } catch (error) {
            console.log(error);
            throw error;
        }
    }

    /**
     * This function is used to add cleaner in cleaner table and audit trail and activity table
     * @param {*} req :- Object from angular
     */
    async addCleaner(req) {   
        try {
            var transaction = await seqTransaction.sequelize.transaction(async (t) =>{
                let responseObj = {};
                let now = new Date();
                var result = await models.tbl_bin_cleaner.findAll({
                    where: { bin_cleanerID: req.body.cleanerID},
                    transaction:t
                });

                if(result.length != 0){
                    Object.assign(responseObj, { status: 'success' }, { result: 'Cleaner already exist' })
                    return responseObj;
                }else{
                    await models.tbl_bin_cleaner.create({
                        bin_cleanerID:req.body.cleanerID,
                        bin_cleanerName:req.body.cleanerName
                    },{
                        transaction:t
                    });

                    await models.tbl_audit_bin_cleaner.create({
                        dt: date.format(now, 'YYYY-MM-DD'),
                        tm: date.format(now, 'HH:mm:ss'),
                        UserId: req.body.loggedUserId,
                        UserName: req.body.loggedUserName,
                        Act: req.body.Action,
                        CleanerId: req.body.cleanerID,
                        CleanerName: req.body.cleanerName,
                        Remark: req.body.Remark
                    },{
                        transaction:t
                    });

                    await models.tbl_activity_log.create({
                        dt: date.format(now, 'YYYY-MM-DD'),
                        tm: date.format(now, 'HH:mm:ss'),
                        userid: req.body.loggedUserId,
                        username: req.body.loggedUserName,
                        activity: req.body.Activity
                    },{
                        transaction:t
                    });
                    Object.assign(responseObj, { status: 'success' }, { result: 'Cleaner Added Successfully' });
                    return responseObj; 
                }
            }); 
            return transaction;
        } catch (error) {
            console.log(error);
            throw error
        } 
    }

    /**
     * This functioni is used to get cleaner id from audit trail table 
     * to display cleaner id on audit trail of cleaner form
     */
    async getAuditCleaner() {
            try {
                let res = await models.tbl_audit_bin_cleaner.findAll({ attributes: ['CleanerId']});
                return res;
            } catch (error) {
                console.log(error);
                throw error
            }
    }

     /**
     * This function is used to get list of stage from tbl_bin_stage table
     */
    async getStages(){
        try {
            let result = await models.tbl_bin_stages.findAll();
            return result;
        } catch (error) {
            console.log(error);
            throw error;
        }
    }

        /**
     * This function is used to add stage in stage table and audit trail and activity table
     * @param {*} req :- Object from angular
     */
    async addStage(req) {    
        try {
            var transactionRep = await seqTransaction.sequelize.transaction( async (t) => {
                let responseObj = {};
                let now = new Date();
                
                let result = await models.tbl_bin_stages.findAll({
                    where:{Stage: req.body.stage}
                });

                if(result.length != 0){
                    Object.assign(responseObj, { status: 'success' }, { result: 'Stage already exist' })
                    resolve(responseObj)
                }else{
                    
                    await models.tbl_bin_stages.create({Stage:req.body.stage},{
                        transaction:t
                    });

                    
                    await models.tbl_audit_bin_stages.create({
                        dt: date.format(now, 'YYYY-MM-DD'),
                        tm: date.format(now, 'HH:mm:ss'),
                        UserId: req.body.loggedUserId,
                        UserName: req.body.loggedUserName,
                        Act: req.body.Action,
                        Stage: req.body.stage,
                        Remark: req.body.Remark
                    },{
                        transaction:t
                    });

                    await models.tbl_activity_log.create({
                        dt: date.format(now, 'YYYY-MM-DD'),
                        tm: date.format(now, 'HH:mm:ss'),
                        userid: req.body.loggedUserId,
                        username: req.body.loggedUserName,
                        activity: req.body.Activity
                    },{
                        transaction:t
                    })
                    
                    Object.assign(responseObj, { status: 'success' }, { result: 'Stage Added Successfully' })
                    return responseObj;
                }
            });
            return transactionRep;
        } catch (error) {
            console.log(error);
            throw error;
        }
    }

        /**
     * This functioni is used to get stage from audit trail table 
     * to display stage on audit trail of stage form
     */
    async getAuditStage() {
        try {
            let result = await models.tbl_audit_bin_stages.findAll({attributes:['Stage']});
            return result;
        } catch (error) {
            console.log(error);
            throw error;
        }
    }

      /**
     * This function is used to get list of container from tbl_bin_list table
     */
    async getContainer(){
        try {
            let result = await models.tbl_bin_list.findAll({});
            return result
        } catch (error) {
            console.log(error);
            throw error;
        }
    }

     /**
     * This function is used to add container in container table and audit trail and activity table
     * @param {*} req :- Object from angular
     */
    async addContainer(req) {    
        // return new Promise((resolve, reject) => {
        try {
            var transaction = await seqTransaction.sequelize.transaction(async (t) =>{
                let responseObj = {};
                let now = new Date();
                let result = await models.tbl_bin_list.findAll({where:{binID:req.body.containerID,IsDiscarded:0}});

                if(result.length != 0){
                    Object.assign(responseObj, { status: 'success' }, { result: 'Container already exist' })
                    return responseObj;
                }else{
                    await models.tbl_bin_list.create({
                        binID: req.body.containerID,
                        binTareWeight: Number(req.body.tareWeight).toFixed(3),
                        // tareWtDP: req.body.tareWeightDP,
                        tareWtDP: 3,
                        PreviousProductName: req.body.Product,
                        ProductType: req.body.prdType,
                        binStatus: 0,
                        IsDiscarded: 0
                    },{
                        transaction:t
                    });
    
                    await models.tbl_audit_bin_adddiscard.create({
                        dt: date.format(now, 'YYYY-MM-DD'),
                        tm: date.format(now, 'HH:mm:ss'),
                        UserId: req.body.loggedUserId,
                        UserName: req.body.loggedUserName,
                        Act: req.body.Action,
                        ContainerID: req.body.containerID,
                        TareWeight: Number(req.body.tareWeight).toFixed(req.body.tareWeightDP),
                        PreviousProduct: req.body.Product,
                        ProductType: req.body.prdType,
                        Remark: req.body.Remark
                    },{
                        transaction:t
                    });
                    
                    await models.tbl_activity_log.create({
                        dt: date.format(now, 'YYYY-MM-DD'),
                        tm: date.format(now, 'HH:mm:ss'),
                        userid: req.body.loggedUserId,
                        username: req.body.loggedUserName,
                        activity: req.body.Activity
                    },{
                        transaction:t
                    })
                    
                    Object.assign(responseObj, { status: 'success' }, { result: 'Container Added Successfully' })
                    return responseObj;
                }
            }); 
            return transaction;
        } catch (error) {
            console.log(error);
            throw error;
        }
        
    }

     /**
     * This function is used to discard container in container table and audit trail and activity table
     * @param {*} req :- Object from angular
     */
    async discardContainer(req) {    
        try {
            var transaction = await seqTransaction.sequelize.transaction(async (t) =>{
                let responseObj = {};
                let now = new Date();

                await models.tbl_bin_list.update({
                    IsDiscarded:1,
                    Bin_CubicleNo:0
                },{
                    where:{ binID: req.body.containerID},
                    transaction:t
                });

                await models.tbl_audit_bin_adddiscard.create({
                    dt: date.format(now, 'YYYY-MM-DD'),
                    tm: date.format(now, 'HH:mm:ss'),
                    UserId: req.body.loggedUserId,
                    UserName: req.body.loggedUserName,
                    Act: req.body.Action,
                    ContainerID: req.body.containerID,
                    TareWeight: Number(req.bodyareWeight).toFixed(req.body.tareWeightDP),
                    PreviousProduct: req.body.Product,
                    ProductType: req.body.prdType,
                    Remark: req.body.Remark
                },{
                    transaction:t
                });
            
                Object.assign(responseObj, { status: 'success' }, { result: 'Container Discarded Successfully' })
                return responseObj;
            });
            return transaction;
        } catch (error) {
            console.log(error);
            throw error;
        }
        
    }


    /**
     * This function is used to get container id from audit trail table 
     * to display container id on audit trail of container form
     */
    async getAuditContainer() {
        try {
            let result = await models.tbl_audit_bin_adddiscard.findAll({attributes:['ContainerID']});
            return result
        } catch (error) {
            console.log(error);
            throw error;
        }
        
    }

     /**
     * This function is used to get list of area from tbl_audit_bin_setting table
     */
    async getAreaForAudit(){
        try {
            // return new Promise((resolve, reject) => {
                let result = await models.tbl_audit_bin_setting.findAll({
                    attributes:[sequelize.fn('DISTINCT',sequelize.col('AREA')),'AREA']});
                return result;
                // dbcon.execute('SELECT DISTINCT AREA FROM `tbl_audit_bin_setting`').then((result) => {
                //     resolve(result)
                // }).catch(err => {
                //     reject('error in get area function');
                // })
            // })
        } catch (error) {
            console.log(error);
            throw error
        }
    }


    async getProductCleanerDetail(req){
        try {
         var res = [],resArchived = [];
         if(req.body.strCubType == "IPC")
         {
            
             res = await sequelize.query(`SELECT Bin_PreviousUsedPrdName as PreviousProductName,Bin_ProductName,Bin_CleanerID FROM  tbl_bin_master_ipc
                 WHERE  Bin_BinID = '${req.body.binId}' order by RecNo desc LIMIT 1`);
 
             resArchived = await sequelize.query(`SELECT  Bin_PreviousUsedPrdName as PreviousProductName,Bin_ProductName,Bin_CleanerID FROM  tbl_bin_master_ipc_archived  
             WHERE  Bin_BinID = '${req.body.binId}' order by RecNo desc LIMIT 1`);
 
             if(res[0].length != 0)
             {
                 return res[0][0];
             }
             else
             {
                 return resArchived[0][0];
             }
         }
         else
         {
             var str_tableName = (req.body.strCubType == "Compression") ? "tbl_bin_master_comp" : (req.body.strCubType == "Coating") ? "tbl_bin_master_coat" :(req.body.strCubType == "Granulation") ? "tbl_bin_master_gran": "tbl_bin_master_cap";
             var str_tableNameArchived = (req.body.strCubType == "Compression") ? "tbl_bin_master_comp_archived" : (req.body.strCubType == "Coating") ? "tbl_bin_master_coat_archived" : (req.body.strCubType == "Granulation") ? "tbl_bin_master_gran_archived" : "tbl_bin_master_cap_archived";
                


                res = await sequelize.query(`SELECT TOP 1 Bin_PreviousUsedPrdName as PreviousProductName,Bin_ProductName,Bin_CleanerID FROM  ${str_tableName}  
                WHERE Bin_BatchComplete=1 and Bin_Released = 0 and Bin_BinID = '${req.body.binId}' order by RecNo desc;`);
    
                resArchived = await sequelize.query(`SELECT TOP 1  Bin_PreviousUsedPrdName as PreviousProductName,Bin_ProductName,Bin_CleanerID FROM  ${str_tableNameArchived}  
                WHERE Bin_BatchComplete=1 and Bin_Released = 0 and Bin_BinID = '${req.body.binId}' order by RecNo;`);

                if(res[0].length != 0)
                {
                    return res[0][0];
                }
                else
                {
                    return resArchived[0][0];
                }
         }
         
        } catch (error) {
         console.log("error",error);
         throw error;
        }
       };

     /** This function is used to get bins from tbl_bin_master_.Condition :- Batch Completed = 1 for bin setting
      * @param {*} req :- Object from angular :- table name
     */
    async getBinForRelease(req){
        try {
            let now = new Date();
            let res,resArchived,str_tableName = "",str_tableNameArchived = "";
            if(["IPC"].includes(req.body.strCubType))
            {
                res = await sequelize.query(`SELECT Bin_BinID as binID,Bin_PreviousUsedPrdName as PreviousProductName,Bin_ProductName,Bin_CleanerID 
                FROM ${req.body.strTableName} m JOIN tbl_bin_list b ON m.Bin_BinID=b.binID 
                WHERE m.Bin_Released=0 AND  m.Bin_Status=1 and b.cubicleType = '${req.body.strCubType}' AND b.CubicleNo<>0  AND b.IsDiscarded=0`);
                
                resArchived = await sequelize.query(`SELECT Bin_BinID as binID,Bin_PreviousUsedPrdName as PreviousProductName,Bin_ProductName,Bin_CleanerID 
                FROM ${req.body.strTableName} m JOIN tbl_bin_list b ON m.Bin_BinID=b.binID
                WHERE m.Bin_Released=0 AND  m.Bin_Status=1 and b.cubicleType = '${req.body.strCubType}' AND b.CubicleNo<>0  AND b.IsDiscarded=0`);
           
                if(res[0].length > 0 && resArchived[0].length > 0)
                {
                    return res[0].concat(resArchived[0]);
                }
                else if(res[0].length != 0)
                {
                    return res[0];
                }
                else
                {
                    return resArchived[0];
                }
              
            }
            else if(req.body.strCubType == "NA")
            {

                
                var resDuration = await models.tbl_bin_cleanduration.findAll({});

                res = await models.tbl_bin_list.findAll({
                    where:{
                        IsDiscarded:0,
                        binStatus:0
                    }
                });
                
                return res; 
                
            }
            else
            {
                str_tableName = req.body.strTableName;
                if(req.body.strCubType == "Compression")
                {
                    str_tableNameArchived = "tbl_bin_master_comp_archived"; 
                }
                else if(req.body.strCubType == "Coating")
                {
                    str_tableNameArchived = "tbl_bin_master_coat_archived"; 
                }
                else if(req.body.strCubType == "Granulation")
                {
                    str_tableNameArchived = "tbl_bin_master_gran_archived"; 
                }
                else
                {
                    str_tableNameArchived = "tbl_bin_master_cap_archived"; 
                }
    
                res = await sequelize.query("SELECT DISTINCT Bin_BinID as binID FROM "+ str_tableName +" m JOIN tbl_bin_list b ON m.Bin_BinID=b.binID" + 
                " WHERE m.Bin_BatchComplete=1 AND  b.binStatus=1 AND b.cubicleType = 'NULL' AND b.CubicleNo=0 AND b.BatchNo='NULL' AND b.IsDiscarded=0 AND m.Bin_Released = 0");


                resArchived = await sequelize.query(`SELECT DISTINCT Bin_BinID as binID FROM ${str_tableNameArchived} m JOIN tbl_bin_list b ON m.Bin_BinID=b.binID WHERE m.Bin_BatchComplete=1 AND  b.binStatus=1 AND b.cubicleType = 'NULL' AND 
                b.CubicleNo=0 AND b.BatchNo='NULL' AND b.IsDiscarded=0 AND  m.Bin_Released = 0` );
    
                if(res[0].length > 0 && resArchived[0].length > 0)
                {
                    return res[0].concat(resArchived[0]);
                }
                else if(res[0].length != 0)
                {
                    return res[0];
                }
                else
                {
                    return resArchived[0];
                }
            }
        } catch (error) {
            console.log(error);
            throw error;
        }
    }

    /** this function is used to get bin setting detail from  tbl_cubicle_bin_setting table*/
    async getBinSettingInfo() {
        try {
            let result = await models.tbl_cubicle_bin_setting.findAll({});
            return result;
        } catch (error) {
            console.log(error);
            throw error;
        }
    }

    /**
     * This function is used to get list of not allocated bins and not deleted from tbl_bin_list
     */
    async getBinList(){
        try {
            let result = await models.tbl_bin_list.findAll({
                where:{
                    binStatus:2, // 2 released,1 allocated and 0 new added
                    IsDiscarded:0
                }
            });
            return result;
        } catch (error) {
            console.log(error);
            throw error;
        }   
    }


    /** this function is used to get bins which are assigned to object sending cubicle no from bin list 
 * this is used for multidropdown selection bin
 */
    async getBinListAssignedToSameCubicle(req){
        try {
            if(["Coating"].includes(req.body.strCubType))
            {
                
                let resultCoat =  await models.tbl_bin_list.findAll({
                    where:{
                        binStatus: 1,
                        IsDiscarded: 0,
                        CubicleNo: req.body.intCubicleNo,
                        cubicleType: req.body.strCubType,
                        BatchNo: req.body.strBatch
                    }
                });

                if(resultCoat[0] == undefined)
                {
                    //Generally client use bin which were already use in compression
                    let resultCoatComp =  await models.tbl_bin_list.findAll({
                        where:{
                        binStatus: 1,
                        IsDiscarded: 0,
                        BatchNo: req.body.strBatch,
                        CubicleNo: 0,
                        cubicleType: 'Compression'
                        }
                    });
                    return resultCoatComp;
                }
                else
                {
                    return resultCoat;
                }
                
            }
            else // not for coating
            {
                
                let result =  await models.tbl_bin_list.findAll({
                    where:{
                        binStatus: 1,
                        IsDiscarded: 0,
                        CubicleNo: req.body.intCubicleNo 
                    }
                });
                return result;
            }
        } catch (error) {
            console.log(error);
            throw error;
        }
    }

     /**
     * This function is used to get count of bins whose gross weight is done 
     */
    async getGrossWtStatus(req){
        try {
            var objResponse = {};
            var arrBinIDs = [];
            var strTableName = "";
            (req.body.strCubicType == "Compression") ? strTableName = "tbl_bin_master_comp" : 
            (req.body.strCubicType == "Granulation") ? strTableName = "tbl_bin_master_gran" :
            (["Coating"].includes(req.body.strCubicType)) ? strTableName = "tbl_bin_master_coat" :  
            (req.body.strCubicType == "IPC") ? strTableName = "tbl_bin_master_ipc" : strTableName = "tbl_bin_master_cap";

            let result = await models[strTableName].count({
                where:{
                    Bin_CubicleNo: req.body.intCubicleNo,
                    Bin_BatchComplete: 0,
                    Bin_Status: 1
                }
            });

            let resultList = await models[strTableName].findAll({
                attributes:[sequelize.fn('DISTINCT',sequelize.col('Bin_BinID')),'Bin_BinID'],
                where:{
                    Bin_CubicleNo: req.body.intCubicleNo,
                    Bin_BatchComplete: 0,
                    Bin_Status: 1
                }
            });

            // let resultList = await database.select(objBinList);
            resultList.forEach(element => {
                arrBinIDs.push(element.Bin_BinID);
            });
            Object.assign(objResponse,{res1:result,res2:arrBinIDs});
            return objResponse;
        } catch (error) {
            console.log(error);
            throw error;
        }
            
    }

     /** This function is used to get count of total,pending,completed bin detail from tbl_bin_master.*/
     async getCountBin(req){
        try {
            let responseObj = {};
            var strTableName = "",intPending=0,intTotalBins=0;
            (req.body.strCubType == "Compression") ? strTableName = "tbl_bin_master_comp" : 
            (["Coating"].includes(req.body.strCubType)) ? strTableName = "tbl_bin_master_coat" : 
            (req.body.strCubType == "Capsule Filling") ? strTableName = "tbl_bin_master_cap" : req.body.strCubType === 'Granulation' ? strTableName = 'tbl_bin_master_gran':  strTableName = "tbl_bin_master_ipc";

            let intTotalBinCount = await models[strTableName].findAll({
                attributes:[['Bin_TotalBin','totalBins']],
                where:{
                    Bin_BatchComplete:0,
                    Bin_CubicleNo:req.body.intCubicleNo,
                    Bin_BatchNo: req.body.strBatch
                }
            });
            // let intTotalBinCount = await dbcon.execute("select Bin_TotalBinNo as 'totalBins' from " + strTableName 
            // + " where Bin_BatchComplete=0 and Bin_CubicleNo="+ req.body.intCubicleNo +" and Bin_BatchNo='"+ req.body.strBatch +"'");

            let intTotalCount = await models[strTableName].count({ 
                where: {
                    Bin_BatchComplete:0,
                    Bin_CubicleNo:req.body.intCubicleNo,
                    Bin_BatchNo: req.body.strBatch
                }
            });
            // let intTotalCount = await dbcon.execute("select count(*) as 'totalBin' from " + strTableName 
            // + " where Bin_BatchComplete=0 and Bin_CubicleNo="+ req.body.intCubicleNo +" and Bin_BatchNo='"+ req.body.strBatch +"'");

            let intCompletedCount = await models[strTableName].count({
                where:{
                    Bin_BatchComplete:0,
                    Bin_CubicleNo:req.body.intCubicleNo,
                    Bin_BatchNo: req.body.strBatch,
                    Bin_Status:1
                }
            })
            // let intCompletedCount = await dbcon.execute("select count(*) as 'CompletedBin' from " + strTableName
            // + " where Bin_BatchComplete=0 and Bin_CubicleNo="+ req.body.intCubicleNo + " and Bin_BatchNo='"+ req.body.strBatch +"' and Bin_Status = 1"); 

            if(intTotalCount != 0)
            {
                intPending = intTotalCount - intCompletedCount;
                (intPending < 0) ? intPending = 0 : intPending = intPending;
            }
            if(intTotalBinCount.length != 0)
            {
                intTotalBins = intTotalBinCount[0].totalBins;
            }
            Object.assign(responseObj, {"CubNo":req.body.intCubicleNo,"Total":intTotalCount,"Complete":intCompletedCount,"Pending":intPending,"TotalBins":intTotalBins });
            return responseObj;
        } catch (error) {
            console.log(error);
            throw error;
        }  
    }

    async checkBinBalAssignToCubicle(obj) {
        try {
            var cnt = 0;
            let query = {
                attributes:['Sys_BinBalID'],
                where:{ 
                    Sys_CubicNo:obj.intCubicNo,
                    Sys_CubType: (obj.int_binCorridor == 1 ? 'IPC' : obj.Sys_CubType)
                }
            };

            // if(obj.int_binCorridor == 1)
            // {
            //     Object.assign(query.where,{ Sys_CubType : 'IPC'});
            // }
            // else
            // {
            //     Object.assign(query.where,{ 
            //         Sys_CubType : obj.Sys_CubType
            //     });
            // }

            let res = await models.tbl_cubical.findAll(query);

            if(res.length == 0)
            {
                cnt = 0;
            }
            else if(res[0].Sys_BinBalID == "None") 
            {
                cnt = cnt + 1;
            }
            else
            {
                cnt = 0;
            }
            
            return cnt;
        } catch (error) {
            console.log(error);
            throw error;
        }
        
    }

    async editTareWeight(value)
    {
        try {
            var transaction = await seqTransaction.sequelize.transaction( async (t) => {
                var responseObj = {};
                var now = new Date();
                //update in bin list and audit trail tables
                for(var i = 0; i < value.str_IPCID.length; i++){
                    // const obj_updateTareWt = {
                    //     str_tableName: 'tbl_bin_list',
                    //     data: [
                    //         { str_colName: 'binTareWeight', value: Number(value.int_new_TareWt[i]) },
                    //         { str_colName: 'tareWtDP', value: Number(value.int_DP[i]) }
                    //     ],
                    //     condition:[
                    //         { str_colName: 'binID', value: value.str_IPCID[i] }
                    //     ]
                    // }
                    await models.tbl_bin_list.update({
                        binTareWeight: Number(value.int_new_TareWt[i]),
                        tareWtDP: Number(value.int_DP[i])
                    },{
                        where: { binID: value.str_IPCID[i]},
                        transaction:t
                    });

                    // let res = await database.update(obj_updateTareWt).catch(err => console.log(err));

                    if(value.int_changeIndex.includes(i) == true)
                    {
                        // var obj_insertTareWt = {
                        //     str_tableName: 'tbl_audit_bin_adddiscard',
                        //     data: [
                        //         { str_colName: 'dt', value: date.format(now, 'YYYY-MM-DD') },
                        //         { str_colName: 'tm', value: date.format(now, 'HH:mm:ss') },
                        //         { str_colName: 'UserId', value: value.loggedUserId },
                        //         { str_colName: 'UserName', value: value.loggedUserName },
                        //         { str_colName: 'Act', value: 'Edit' },
                        //         { str_colName: 'ContainerID', value: value.str_IPCID[i] },
                        //         { str_colName: 'TareWeight', value: Number(value.int_new_TareWt[i]).toFixed(value.int_DP[i]) },
                        //         { str_colName: 'PreviousProduct', value: "NA" },
                        //         { str_colName: 'ProductType', value: 0 },
                        //         { str_colName: 'Remark', value: value.Remark },
                        //         { str_colName: 'OldTareWt', value: Number(value.int_old_TareWt[i])}
                        //     ] 
                        // }
                        await models.tbl_audit_bin_adddiscard.create({
                            dt: date.format(now, 'YYYY-MM-DD'),
                            tm: date.format(now, 'HH:mm:ss'),
                            UserId: value.loggedUserId,
                            UserName: value.loggedUserName,
                            Act: 'Edit',
                            ContainerID: value.str_IPCID[i],
                            TareWeight: Number(value.int_new_TareWt[i]).toFixed(value.int_DP[i]),
                            PreviousProduct: "NA",
                            ProductType: 0,
                            Remark: value.Remark,
                            OldTareWt: Number(value.int_old_TareWt[i])
                        },{
                            transaction:t
                        })
                        // let resAudit = await database.save(obj_insertTareWt).catch(err => console.log(err));
                    }
                
                }
                

                // const obj_tareWtActivity = {
                //     str_tableName: 'tbl_activity_log',
                //     data: [
                //         { str_colName: 'dt', value: date.format(now, 'YYYY-MM-DD') },
                //         { str_colName: 'tm', value: date.format(now, 'HH:mm:ss') },
                //         { str_colName: 'userid', value: value.loggedUserId },
                //         { str_colName: 'username', value: value.loggedUserName },
                //         { str_colName: 'activity', value: value.activity }
                //     ]
                // }

                await models.tbl_activity_log.create({
                    dt: date.format(now, 'YYYY-MM-DD'),
                    tm: date.format(now, 'HH:mm:ss'),
                    userid: value.loggedUserId ,
                    username: value.loggedUserName ,
                    activity: value.activity 
                },{
                    transaction:t
                })
                // let res = await  database.save(obj_tareWtActivity).catch(err => console.log(err));
                Object.assign(responseObj, { status: 'success' }, { result: 'Tare Weight Updated Successfully' })
                return responseObj;
            });
            return transaction
        } catch (error) {
            console.log(error);
            throw error;
        }
    }

     /**
     * This function is used to delete data from master table in update condition 
     * @param {*} objBin  :- data getting from object -Angular
     */
    async deleteData(objBin,strTableName,t) {
        try {
            await models[strTableName].destroy({
                where: {
                    Bin_CubicleNo: objBin.Sys_CubicNo,
                    Bin_ProductID: objBin.Sys_BFGCode,
                    Bin_ProductName: objBin.Sys_ProductName,
                    Bin_ProductVersion: objBin.Sys_PVersion,
                    Bin_Version: objBin.Sys_Version,
                    Bin_BatchNo: objBin.Sys_Batch,
                    Bin_BatchComplete: 0,
                    Bin_Status: 0
                },
                transaction:t
            }); 
            return "Delete Bin";
        } catch (error) {
            console.log(error);
            throw error;
        }
        
        // const objDeleteBinData = {
        //     str_tableName: strTableName,
        //     condition: [
        //         { str_colName: "Bin_CubicleNo", value: objBin.Sys_CubicNo  },
        //         { str_colName: "Bin_ProductID", value: objBin.Sys_BFGCode  },
        //         { str_colName: "Bin_ProductName", value: objBin.Sys_ProductName  },
        //         { str_colName: "Bin_ProductVersion", value: objBin.Sys_PVersion  },
        //         { str_colName: "Bin_Version", value: objBin.Sys_Version  },
        //         { str_colName: "Bin_BatchNo", value: objBin.Sys_Batch  },
        //         { str_colName: "Bin_BatchComplete", value: 0  }
        //     ]
        // }

        // database.delete(objDeleteBinData).then(res => {
        // resolve("Delete Bin");
        // }).catch(err => {
        //     reject(err);
        // })
    }

    /**
     * This function is used to update bin status when untick bins 
     * @param {*} objBin  :- data getting from object -Angular
     */
    async updateData(binIDS,t) {
        try {
            let arr_strBinID = [];

            binIDS.forEach( e => arr_strBinID.push(e.itemName));

            await models.tbl_bin_list.update({
                Bin_CubicNo:0,
                binStatus : 2,
                cubicleType : 'NULL',
                BatchNo : 'NULL',
                CubicleNo : 0,
            },{
                where: {
                    binID:{ [Op.in]:arr_strBinID },
                    IsDiscarded:0 //Update value of not discarded bin
                },
                transaction:t
            });
            return "Update Bin List";
        } catch (error) {
            console.log(error);
            throw error;
        }
    }

      /**
     * This function is used to update bin status when untick bins and cubicle type is compression,cubicle no is 0
     * @param {*} objBin  :- data getting from object -Angular
     */
    async updateDataCoating(binIDS,t) {
        try {
            let arr_strBinID = [];

            binIDS.forEach( e => arr_strBinID.push(e.itemName));

            await models.tbl_bin_list.update({
                cubicleType : 'NULL',
                BatchNo : 'NULL',
            },{
                where: {
                    Bin_CubicNo:0,
                    cubicleType:'Compression',
                    CubicleNo:0,
                    binID:{ [Op.in]:arr_strBinID },
                    IsDiscarded:0 //Update value of not discarded bin
                },
                transaction:t
            });
            return "Update Bin List for Coat";
        } catch (error) {
            console.log(error);
            throw error;
        }   
    }

    async  update(objBin) {
        try {
            var transactionRes = await seqTransaction.sequelize.transaction( async (t) => {
                var strTableName = "",strBins = "";

                strTableName = (objBin.Sys_CubicType == "Compression") ? "tbl_bin_master_comp" :  (objBin.Sys_CubicType == "IPC") ? "tbl_bin_master_ipc" : 
                (["Coating"].includes(objBin.Sys_CubicType)) ? "tbl_bin_master_coat" :(objBin.Sys_CubicType == "Granulation")  ? "tbl_bin_master_gran" : "tbl_bin_master_cap";

                let arr_strBinID = [];

                objBin.Sys_Bin.forEach( e => arr_strBinID.push(e.itemName));
                //Check Data already exist in tbl_list
                let checkBinAlreadyExist = await models.tbl_bin_list.findAll({
                    where:{
                        Bin_CubicNo: {[Op.notIn]:[objBin.Sys_CubicNo,0]},
                        // Bin_CubicNo: {[Op.ne]:0},
                        IsDiscarded:0,
                        binID:{[Op.in]:arr_strBinID}
                    }
                });

                let result = await models.tbl_system_weighingstatus.findAll({ where: {CubicleNo: objBin.Sys_CubicNo ,status: 1}});


                //Check if weighment status and else return Test in process
                if(result.length > 0){
                    return { msg:'fail' , result : 'Test in Process'}
                }

                // Check data exist in main table
                let checkBinAlreadyExistInMaster = await models[strTableName].findAll({
                    where:{
                        Bin_CubicleNo: {[Op.ne]:objBin.Sys_CubicNo},
                        Bin_Status:0,
                        Bin_BatchComplete:0,
                        Bin_BinID:{[Op.in]:arr_strBinID}
                    }
                });

                let arr_binList = [];

                //return the request
                if(checkBinAlreadyExist.length > 0){
                     checkBinAlreadyExist.map( e => arr_binList.push(e.binID))
                    return { msg:'Exist' , result : arr_binList.join(',')}
                }

                if(checkBinAlreadyExistInMaster.length > 0){
                    checkBinAlreadyExistInMaster.map( e => arr_binList.push(e.Bin_BinID))
                    return { msg:'Exist' , result : arr_binList.join(',')}
                }

                if(objBin.Sys_ProductName != "None")
                {
                    for(var j = 0; j < objBin.Sys_Bin.length; j++){
                        if(strBins == "")
                        {
                            strBins =  objBin.Sys_Bin[j].itemName;
                        }
                        else{
                            strBins +=  "," + objBin.Sys_Bin[j].itemName;
                        }
                    }
                }


                 /**get IDS No */

                let resIDSNo = await models.tbl_cubical.findAll({
                    attributes:[['Sys_IDSNo','IDSNo']],
                    where:{ Sys_CubicNo: objBin.Sys_CubicNo}
                });

                await models.tbl_cubicle_bin_setting.update({
                    Sys_TotalBin: objBin.Sys_TotalBin,
                    Sys_TotalBinSelected: objBin.Sys_TotalBinSelected,
                    Sys_LabelHeader: objBin.Sys_LabelHeader,
                    Sys_Lot: objBin.Sys_Lot,
                    Sys_MfgDate: objBin.Sys_MfgDate,
                    Sys_ExpDate: objBin.Sys_ExpDate,
                    Sys_InitialStage: objBin.Sys_InitialStage,
                    Sys_NextStage: objBin.Sys_NextStage,
                    Sys_Printer: objBin.Sys_PrinterName,
                    Sys_BinID: strBins,
                    Sys_BatchNo: objBin.Sys_Batch,
                    Sys_PrdID: objBin.Sys_BFGCode,
                    Sys_PrdName: objBin.Sys_ProductName,
                    Sys_PrdVersion: objBin.Sys_PVersion,
                    Sys_Version: objBin.Sys_Version,
                    Sys_DateNA: objBin.NADate,
                    Sys_IDS:resIDSNo[0].IDSNo,
                    Layer:objBin.Layer
                },{
                    where:{ Sys_CubicNo: objBin.Sys_CubicNo},
                    transaction:t
                });


                if(objBin.Sys_CubicType == "IPC")
                {

                    await models.tbl_cubical.update({
                        Sys_Batch: objBin.Sys_Batch,
                        Sys_BFGCode: objBin.Sys_BFGCode,
                        Sys_ProductName: objBin.Sys_ProductName,
                        Sys_PVersion: objBin.Sys_PVersion,
                        Sys_Version: objBin.Sys_Version
                    },{
                        where:{Sys_CubicNo:objBin.Sys_CubicNo},
                        transaction:t
                    })
                    /**if batch is already exist then not insert else insert for same cubicle no. */
                    if(objBin.Sys_ProductName != "None")
                    {
                        let resBatchExists = await models.tbl_bin_batches.count({
                            where:{
                                Batch: objBin.Sys_Batch,
                                CubicNo: objBin.Sys_CubicNo,
                                Batch: "U"
                            }
                        });
        
                        if(resBatchExists == 0)
                        {
                            await models.tbl_bin_batches.create({
                                Batch: objBin.Sys_Batch,
                                CubicNo: objBin.Sys_CubicNo,
                                Status: "U"
                            },{
                                transaction:t
                            })
                        }
                    }
                }

                /** If record found in master table if no bin weighing done then delete from master else get max record no. and insert with +1 */
                if(objBin.Sys_ProductName != "None")
                {
                    //Sequelize put the lock on the fetching data from table if one performed some insert or update on that table
                    //so fetching count before for loop
                    let arr_binID = [];
                    objBin.Sys_Bin.forEach( e => arr_binID.push(e.itemName));
                    let arr_objBinList = await models.tbl_bin_list.findAll({
                        attributes:['binID','binTareWeight'],
                        where:{binID:{[Op.in]:arr_binID}}
                    })

                    let resRecordFromMaster = await models[strTableName].count({
                        where:{
                            Bin_CubicleNo: objBin.Sys_CubicNo,
                            Bin_ProductID: objBin.Sys_BFGCode,
                            Bin_ProductName: objBin.Sys_ProductName,
                            Bin_ProductVersion: objBin.Sys_PVersion,
                            Bin_Version: objBin.Sys_Version,
                            Bin_BatchNo: objBin.Sys_Batch,
                            Bin_BatchComplete: 0,
                            Bin_Status: 1
                        }
                    });
                
                    if(resRecordFromMaster == 0) 
                    {
                            var objdeleteMaster = await this.deleteData(objBin,strTableName,t); 
                            if(objBin.Sys_OldBin.length  != 0)
                            {
                                var objUpdateBinList = await this.updateData(objBin.Sys_OldBin,t); //untick old bins
                            }
                            
                    }else{
                            if(objBin.arr_removed.length != 0)
                            {
                                console.log("12",strTableName,"Bin",objBin);
                                objdeleteMaster = await this.deleteData(objBin,strTableName,t); 
            
                                var objUpdateBinList = await this.updateData(objBin.arr_removed,t); //untick bins
                            }
       
                                console.log("Bin Delete count 1",1)
                        }  
            
                    if(["Coating"].includes(objBin.Sys_CubicType))//compression bin assigned to coating and bins removed from coating 
                    {
                        if(objBin.Sys_OldBin.length > 0)
                        {
                            var objUpdateBinListCoat = await this.updateDataCoating(objBin.Sys_OldBin,t); 
                        }
                    }

                    
                    for(var i = 0; i < objBin.Sys_Bin.length; i++){
                        var intSrNo = objBin.Sys_Bin[i].id;
                        var strBinID = objBin.Sys_Bin[i].itemName;

                        let resTareWt = arr_objBinList.filter( e => e.binID === strBinID);

                        var dbltareWt = (resTareWt[0].binTareWeight != objBin.Sys_Bin[i].tareWt) ?  resTareWt[0].binTareWeight : objBin.Sys_Bin[i].tareWt;


                        await models.tbl_bin_list.update({
                            binStatus: 1,
                            Bin_CubicNo: objBin.Sys_CubicNo,
                            CubicleNo: objBin.Sys_CubicNo,
                            cubicleType: objBin.Sys_CubicType,
                            BatchNo: objBin.Sys_Batch,
                            bin_date: null,
                            bin_updatedDate: null
                        },{
                            where:{
                                binID: strBinID,
                                IsDiscarded:0 //Update value of not discarded bin
                            },
                            transaction:t
                        });

                        var strCleanerID ="",strCleanerName ="",strPrevPrdId ="",strPrevPrdName ="",
                        strPrevPV ="",strPrevVer ="",strPrevBatch ="",strCheckedByID ="",strCheckedByName ="";
                        
                        //get Previous data from tbl_bin_release table
                        let res = await sequelize.query("Select * from tbl_bin_release where bin_BinID='"+ strBinID 
                                +"' and RecNo = (select max(RecNo) from tbl_bin_release where bin_BinID='"+ strBinID +"')");
                        if(res[0].length == 0)
                        {
                            strCleanerID = "NULL"; 
                            strCleanerName = "NULL";
                            strCheckedByID = "NULL"; 
                            strCheckedByName = "NULL";
                            strPrevPrdId = "NULL";
                            strPrevPrdName = "NULL";
                            strPrevPV = "NA";
                            strPrevVer= "NA";
                            strPrevBatch = "NULL";
                        }
                        else
                        {
                            strCleanerID = res[0][0].bin_CleanerID; 
                            strCleanerName = res[0][0].bin_CleanerName; 
                            strCheckedByID = res[0][0].bin_CheckedByID; 
                            strCheckedByName = res[0][0].bin_CheckedByName; 
                            strPrevPrdId = "NA"; 
                            strPrevPrdName = res[0][0].bin_PreviousPrdName; 
                            strPrevPV = "NA"; 
                            strPrevVer= "NA"; 
                            strPrevBatch = "NA"; 
                        }

                        await models[strTableName].create({
                            Bin_Area: objBin.Sys_Area,
                            Bin_CubicName: objBin.Sys_CubicName,
                            Bin_CubicleNo: objBin.Sys_CubicNo,
                            Bin_ProductID: objBin.Sys_BFGCode,
                            Bin_IDSNo: resIDSNo[0].IDSNo,
                            Bin_ProductName: objBin.Sys_ProductName,
                            Bin_ProductVersion: objBin.Sys_PVersion,
                            Bin_Version: objBin.Sys_Version,
                            Bin_BatchNo: objBin.Sys_Batch,
                            Bin_TotalBin: objBin.Sys_TotalBin,
                            Bin_Lot: objBin.Sys_Lot,
                            Bin_MfgDt: objBin.Sys_MfgDate,
                            Bin_ExpDt: objBin.Sys_ExpDate,
                            Bin_Initial: objBin.Sys_InitialStage,
                            Bin_Next: objBin.Sys_NextStage,
                            Bin_Printer: objBin.Sys_PrinterName,
                            Bin_SrNoCubicle: intSrNo,
                            Bin_BinID: strBinID,
                            Bin_TareWt: dbltareWt,
                            Bin_CleanerID: strCleanerID,
                            Bin_CleanerName: strCleanerName,
                            Bin_CheckedByID: strCheckedByID,
                            Bin_CheckedByName: strCheckedByName,
                            Bin_PreviousUsedPrdID: strPrevPrdId,
                            Bin_PreviousUsedPrdName: strPrevPrdName,
                            Bin_PreviousUsedPrdVer: strPrevPV,
                            Bin_PreviousUsedVer: strPrevVer,
                            Bin_PreviousUsedBatch: strPrevBatch,
                            Bin_BatchSize: objBin.Sys_BatchSize,
                            Bin_TotalSelected: objBin.Sys_TotalBinSelected,
                            Bin_Header: objBin.Sys_LabelHeader,
                            Sys_DateNA: objBin.NADate,
                            Bin_Layer:objBin.Layer
                        },{
                            transaction:t
                        })
                    }
                }//prd none

                var now = new Date();            

                await models.tbl_audit_bin_setting.create({
                    dt: date.format(now, 'YYYY-MM-DD'),
                    tm: date.format(now, 'HH:mm:ss'),
                    userid: objBin.userid,
                    username: objBin.username,
                    ACT: objBin.Action,
                    Remark: objBin.Remark,
                    CubicleNo: objBin.Sys_CubicNo,
                    OldData: objBin.OldData,
                    NewData: objBin.NewData,
                    Area: objBin.Sys_Area,
                    CubName: objBin.Sys_CubicName,
                },{
                    transaction:t
                })

                await models.tbl_activity_log.create({
                    dt: date.format(now, 'YYYY-MM-DD'),
                    tm: date.format(now, 'HH:mm:ss'),
                    userid: objBin.userid,
                    username: objBin.username,
                    activity: objBin.activity,
                },{
                    transaction:t
                })
                return "done";
            });
            return transactionRes
        } catch (error) {
            console.log(error);
            throw error;
        }
    }

      /**
     * This function is used to release container in container table and audit trail and activity table
     * @param {*} req :- Object from angular
     */
   async releaseContainer(req) { 
       try{
        var transactionRes = await seqTransaction.sequelize.transaction(async (t) => {
            let responseObj = {};
            let now = new Date();

            await models.tbl_bin_release.create({
                bin_BinID: req.body.bin_BinID,
                bin_CubType: req.body.bin_CubType,
                bin_PreviousPrdName: req.body.bin_PrdName,
                bin_PrdName: 'NA',
                bin_CleanerID: req.body.bin_CleanerID,
                bin_CleanerName: req.body.bin_CleanerName,
                bin_CheckedByID: req.body.loggedUserId,
                bin_CheckedByName: req.body.loggedUserName
            },{
                transaction:t
            });

            // let dt_updatedDate = await sequelize.query(`SELECT DATE_FORMAT(DATE_ADD(NOW(), INTERVAL (SELECT Duration FROM tbl_bin_cleanduration) DAY),"%Y-%m-%d") as dt FROM tbl_bin_list where binID = '${req.body.bin_BinID}'`);

            if(req.body.bin_CubType == "IPC")
            {
                let resBinList = await models.tbl_bin_list.update({
                    binStatus: 0,
                    CubicleNo: 0,
                    cubicleType: 'NULL',
                    BatchNo: 'NULL',
                    bin_date: date.format(now, 'YYYY-MM-DD')
                },{
                    where:{
                        binID:req.body.bin_BinID ,
                        IsDiscarded:0
                    },
                    transaction:t
                });
            }
            else
            {
                await models.tbl_bin_list.update({
                    binStatus: 2,
                    bin_date: date.format(now, 'YYYY-MM-DD'),
                    PreviousProductName:req.body.bin_PrdName
                },{
                    where:{ 
                        binID: req.body.bin_BinID,
                        IsDiscarded:0
                     },
                    transaction:t
                });
            }

            if(req.body.bin_CubType == "IPC")
            {

                await models.tbl_bin_master_ipc.findAll({
                    attributes:[sequelize.fn('DISTINCT',sequelize.col('Bin_CubicleNo')),'cubicNo'],
                    where:{
                        Bin_Released:0,
                        Bin_BinID:req.body.bin_BinID
                    }
                });

                await models.tbl_bin_master_ipc_archived.findAll({
                    attributes:[sequelize.fn('DISTINCT',sequelize.col('Bin_CubicleNo')),'cubicNo'],
                    where:{
                        Bin_Released:0,
                        Bin_BinID:req.body.bin_BinID
                    }
                });

                var str_ipcID = "";
                if(res.length > 0)
                {
                    str_ipcID = res[0].cubicNo;

                    await models.tbl_bin_master_ipc.update({
                        Bin_Released:1
                    },{
                        where:{ Bin_BinID: req.body.bin_BinID},
                        transaction:t
                    });
                }
                if(resArchived.length > 0)
                {
                    str_ipcID = resArchived[0].cubicNo;

                    await models.tbl_bin_master_ipc_archived.update({
                        Bin_Released:1
                    },{
                        where:{ Bin_BinID: req.body.bin_BinID},
                        transaction:t
                    });
                }

        
                await models.tbl_cubical.update({
                    Sys_Batch: 'NULL',
                    Sys_BFGCode: 'NULL',
                    Sys_ProductName: 'NULL',
                    Sys_PVersion: 'NA',
                    Sys_Version: 'NA'
                },{
                    where:{Sys_CubicNo:str_ipcID},
                    transaction:t
                });


                await models.tbl_cubicle_bin_setting.update({
                    Sys_TotalBin: 0,
                    Sys_Lot: 'NULL',
                    Sys_MfgDate: null,
                    Sys_ExpDate: null,
                    Sys_InitialStage: 'NULL',
                    Sys_NextStage: 'NULL',
                    Sys_Printer: 'NULL',
                    Sys_BinID: 'NULL',
                    Sys_BatchNo: 'NULL',
                    Sys_PrdID: 'NULL',
                    Sys_PrdName: 'NULL',
                    Sys_PrdVersion: 'NA',
                    Sys_Version: 'NA'
                },{
                    where:{Sys_CubicNo:res[0].cubicNo},
                    transaction:t
                });
            }else if(req.body.bin_CubType != "NA") // release flag 1 for comp,coat,capsule
            {

               var str_tableName="",str_tableNameArchived="";
                    if(req.body.bin_CubType == "Compression")
                    {
                        str_tableName = "tbl_bin_master_comp";
                        str_tableNameArchived = "tbl_bin_master_comp_archived"; 
                    }
                    else if(req.body.bin_CubType == "Coating")
                    {
                        str_tableName = "tbl_bin_master_coat";
                        str_tableNameArchived = "tbl_bin_master_coat_archived"; 
                    }
                    else
                    {
                        str_tableName = "tbl_bin_master_cap";
                        str_tableNameArchived = "tbl_bin_master_cap_archived"; 
                    }


                    await models[str_tableName].update({
                        Bin_Released:1
                    },{
                        where:{
                            Bin_BinID : req.body.bin_BinID,
                            Bin_Released:{[Op.ne]:1}
                        },
                        transaction:t
                    });

                    await models[str_tableNameArchived].update({
                        Bin_Released:1
                    },{
                        where:{
                            Bin_BinID : req.body.bin_BinID,
                            Bin_Released:{[Op.ne]:1}
                        },
                        transaction:t
                    });

            }
    
            await models.tbl_audit_bin_release.create({
                dt: date.format(now, 'YYYY-MM-DD'),
                tm: date.format(now, 'HH:mm:ss'),
                UserId: req.body.loggedUserId,
                UserName: req.body.loggedUserName,
                Act: req.body.Action,
                ContainerID: req.body.bin_BinID,
                CleanerID: req.body.bin_CleanerID,
                CleanerName: req.body.bin_CleanerName,
                ProductName: req.body.bin_PrdName,
                PreviousProduct: req.body.bin_PrevPrdName,
                Remark: req.body.Remark,
                CubType: req.body.bin_CubType
            },{
                transaction:t
            });

            
            await models.tbl_activity_log.create({
                dt: date.format(now, 'YYYY-MM-DD'),
                tm: date.format(now, 'HH:mm:ss'),
                userid: req.body.loggedUserId,
                username: req.body.loggedUserName,
                activity: req.body.Activity 
            },{
                transaction:t
            });

            Object.assign(responseObj, { status: 'success' }, { result: 'Container Released Successfully' })
            return responseObj; 
        });
        return transactionRes;
       }  
       catch(error)
       {
            console.log(error);
            throw error;
       } 
        
    }

    async storeBinDataInTemp(objBinSummery, req) 
    {
        try {
            var transactionRes = await seqTransaction.sequelize.transaction(async (t) => {
                let Ip = requestIp.getClientIp(req);
                let ClIp = Ip.split(':')[3]
                var ClientIp;
                if (ClIp === undefined) {
                    ClientIp = '127.0.0.1';
                } else {
                    ClientIp = ClIp;
                }
                var ipAdd = ClientIp;
                var objdelete = await this.deleteDatas(ipAdd,"tbl_bin_summary_temp",t);
                var MasterData = await this.selectDataFromBinMaster(objBinSummery);
                var getTotalNetWt = await this.getData(objBinSummery,MasterData[0].Bin_DP);
                var TempInsert = await this.insertDataToTempTable(MasterData, ipAdd, objBinSummery,getTotalNetWt,t);
                
                if (TempInsert == "Successfull") {
                    return { result: "Success", data: objdelete, calValues: 0 };
                }else{
                    return ""
                }
            });
            return transactionRes;
        } catch (error) {
            console.log(error);
            throw error;
        }
    }

     /**
     * This function is used to delete data from temp table
     * @param {*} req :- get IP address
     */
    async deleteDatas(intIPAddress,tableName,t) {
        try {
           await models[tableName].destroy({
            where:{HMIID:intIPAddress},
            transaction:t
           });
           return intIPAddress;
        } catch (error) {
            console.log(error);
            throw error;
        }
    }

    async selectDataFromBinMaster(obj) {
        try {
            var strTableName = "";
            if(obj.str_cubicleType == "Compression") 
            {
                (obj.str_ICReport == "Current") ? strTableName = "tbl_bin_master_comp" : strTableName = "tbl_bin_master_comp_archived";
            }
            else if(["Coating"].includes(obj.str_cubicleType))
            {
                (obj.str_ICReport == "Current") ? strTableName = "tbl_bin_master_coat" : strTableName = "tbl_bin_master_coat_archived";  
            }
            else if(obj.str_cubicleType == "IPC")
            {
                (obj.str_ICReport == "Current") ? strTableName = "tbl_bin_master_ipc" : strTableName = "tbl_bin_master_ipc_archived";  
            }else if(obj.str_cubicleType === "Granulation")
            {
                strTableName =  (obj.str_ICReport === 'Current') ? 'tbl_bin_master_gran' : 'tbl_bin_master_gran_archived'
            }
            else 
            {
                (obj.str_ICReport == "Current") ? strTableName = "tbl_bin_master_cap" : strTableName = "tbl_bin_master_cap_archived"; 
            }
                // const objSelect = {
                //     str_tableName: strTableName,
                //     data: '*',
                //     condition: [

                //         { str_colName: "Bin_ProductID", value: obj.str_prdID },
                //         { str_colName: "Bin_ProductName", value: obj.str_prdName },
                //         { str_colName: "Bin_ProductVersion", value: obj.str_prdVersion },
                //         { str_colName: "Bin_Version", value: obj.str_version },
                //         { str_colName: "Bin_BatchNo", value: obj.str_batches },
                //         { str_colName: "Bin_BatchComplete", value: 1 },
                //         { str_colName: "Bin_Status", value: 1 }
                //     ]
                // }

            let result = await models[strTableName].findAll({
                where:{
                    Bin_ProductID: obj.str_prdID,
                    Bin_ProductName: obj.str_prdName,
                    Bin_ProductVersion: obj.str_prdVersion,
                    Bin_Version: obj.str_version,
                    Bin_BatchNo: obj.str_batches,
                    Bin_BatchComplete: 1,
                    Bin_Status: 1
                }
            });
            return result;
        } catch (error) {
            console.log(error);
            throw error;
        }
    }

    async insertDataToTempTable(objMaster, intIPAddress, objBatchSummery, TotalNetWt,t) {
        try {
            const arrQueries = [];
            var strPrdType = "";
            (objBatchSummery.str_cubicleType == "Capsule Filling") ? strPrdType = "Capsule" :  (objBatchSummery.str_cubicleType == "IPC") ? strPrdType = "IPC" : strPrdType = "Tablet";
            
            for (let element of objMaster) 
            {
                await models.tbl_bin_summary_temp.create({
                    RecNo: element.RecNo,
                    Bin_Area: element.Bin_Area,
                    Bin_CubicName: element.Bin_CubicName,
                    Bin_CubicleNo: element.Bin_CubicleNo,
                    Bin_IDSNo: element.Bin_IDSNo,
                    Bin_cubType: objBatchSummery.str_cubicleType,
                    Bin_prdType: strPrdType,
                    Bin_ProductID: element.Bin_ProductID,
                    Bin_ProductName: element.Bin_ProductName,
                    Bin_ProductVersion: element.Bin_ProductVersion,
                    Bin_Version: element.Bin_Version,
                    Bin_BatchNo: element.Bin_BatchNo,
                    Bin_BatchSize: element.Bin_BatchSize,
                    Bin_TotalBin: element.Bin_TotalBin,
                    Bin_Lot: element.Bin_Lot,
                    Bin_MfgDt: element.Bin_MfgDt,
                    Bin_ExpDt: element.Bin_ExpDt,
                    Bin_Initial: element.Bin_Initial,
                    Bin_Next: element.Bin_Next,
                    Bin_Printer: element.Bin_Printer,
                    Bin_SrNoCubicle: element.Bin_SrNoCubicle,
                    Bin_SrNoWeighment: element.Bin_SrNoWeighment,
                    Bin_BinID: element.Bin_BinID,
                    Bin_PrDate: element.Bin_PrDate,
                    Bin_PrTime: date.format(element.Bin_PrTime,'HH:mm:ss'),
                    Bin_WeighingBalID: element.Bin_InstrumentID,
                    Bin_TareWt: element.Bin_TareWt,
                    Bin_GrossWt: element.Bin_GrossWt,
                    bin_NetWeight: element.bin_NetWeight,
                    Bin_DP: element.Bin_DP,
                    Bin_Status: element.Bin_Status,
                    Bin_DoneUserID: element.Bin_UserID,
                    Bin_DoneUserName: element.Bin_UserName,
                    Bin_CleanerID: element.Bin_CleanerID,
                    Bin_CleanerName: element.Bin_CleanerName,
                    Bin_CheckedByID: element.Bin_CheckedByID,
                    Bin_CheckedByName: element.Bin_CheckedByName,
                    Bin_PreviousUsedPrdID: element.Bin_PreviousUsedPrdID,
                    Bin_PreviousUsedPrdName: element.Bin_PreviousUsedPrdName,
                    Bin_PreviousUsedPrdVer: element.Bin_PreviousUsedPrdVer,
                    Bin_PreviousUsedVer: element.Bin_PreviousUsedVer,
                    Bin_PreviousUsedBatch: element.Bin_PreviousUsedBatch,
                    Bin_PrintNo: element.Bin_PrintNo,
                    Bin_PrintNoSummary: element.Bin_PrintNoSummary,
                    Bin_IsArchived: element.Bin_IsArchived,
                    Bin_BatchComplete: element.Bin_BatchComplete,
                    Bin_TotalNetWt: TotalNetWt,
                    HMIID: intIPAddress,
                    Sys_DateNA: element.Sys_DateNA,
                    Bin_Layer: element.Bin_Layer
                },{
                    transaction:t
                });
            }
           return "Successfull";
            
        } catch (error) {
            console.log(error);   
            throw error;
        }
            
    }

     /**Call Stored Procedure
     * @param {*} intIPAddress :- IP address
     */
    async getData(obj,int_dp)
    {
        try {
            var strTableName = "";
            if(obj.str_cubicleType == "Compression") 
            {
                (obj.str_ICReport == "Current") ? strTableName = "tbl_bin_master_comp" : strTableName = "tbl_bin_master_comp_archived";
            }
            else if(["Coating","MIC"].includes(obj.str_cubicleType))
            {
                (obj.str_ICReport == "Current") ? strTableName = "tbl_bin_master_coat" : strTableName = "tbl_bin_master_coat_archived";  
            }
            else if(obj.str_cubicleType == "IPC")
            {
                (obj.str_ICReport == "Current") ? strTableName = "tbl_bin_master_ipc" : strTableName = "tbl_bin_master_ipc_archived";  
            }
            else if(obj.str_cubicleType == "Granulation")
            {
                (obj.str_ICReport == "Current") ? strTableName = "tbl_bin_master_gran" : strTableName = "tbl_bin_master_gran_archived";
            }
            else 
            {
                (obj.str_ICReport == "Current") ? strTableName = "tbl_bin_master_cap" : strTableName = "tbl_bin_master_cap_archived"; 
            }

            // const obj_getTotal = {
            //     str_tableName: strTableName,
            //     data: 'ROUND(CAST(SUM(`bin_NetWeight`) AS DECIMAL(20,15)),3) as total',
            //     condition: [

            //         { str_colName: "Bin_ProductID", value: obj.str_prdID },
            //         { str_colName: "Bin_ProductName", value: obj.str_prdName },
            //         { str_colName: "Bin_ProductVersion", value: obj.str_prdVersion },
            //         { str_colName: "Bin_Version", value: obj.str_version },
            //         { str_colName: "Bin_BatchNo", value: obj.str_batches },
            //         { str_colName: "Bin_BatchComplete", value: 1 },
            //         { str_colName: "Bin_Status", value: 1 }
            //     ]
            // }

            let resultTotal = await sequelize.query(`SELECT  ROUND(SUM(CAST(bin_NetWeight AS DECIMAL(20,${int_dp}))),${int_dp}) as total 
                            from ${strTableName} where Bin_ProductID = '${obj.str_prdID}' AND Bin_ProductName = '${obj.str_prdName}' AND Bin_ProductVersion = '${obj.str_prdVersion}'
                            AND Bin_Version= '${obj.str_version}' AND Bin_BatchNo = '${obj.str_batches}' AND Bin_BatchComplete = 1 AND Bin_Status = 1;`);

            // database.createTextFile('txtBinSummaryTotal.txt',resultTotal.total);
            return resultTotal[0][0]['total'];
        } catch (error) {
            console.log(error);
            throw error; 
        }
        // let responseObj = {};
        // connection.connect();
        // connection.query('call binSummaryReportCalculation('+ intIPAddress +',@total);');
        // connection.query("Select @total as total", function (err, rows, fields) {
        //     if (err) {
        //         console.log(err);
        //     }
        //     Object.assign(responseObj,{Values:rows[0]});
        //     resolve(responseObj);
        // })
    }

     /** This function is used to get data from tbl_bin_master_.Condition :- Batch Status 1 (ie. Gross wt completed)
      * @param {*} req :- Object from angular :- table name
     */
    async getBinDataGetPrd(req){
        try {
            var strTableName = "";
            if(req.body.strCubType == "Compression") 
            {
                (req.body.strICReport == "Current") ? strTableName = "tbl_bin_master_comp" : strTableName = "tbl_bin_master_comp_archived";
            }
            else if(["Coating"].includes(req.body.strCubType))
            {
                (req.body.strICReport == "Current") ? strTableName = "tbl_bin_master_coat" : strTableName = "tbl_bin_master_coat_archived";  
            }
            else if(req.body.strCubType == "IPC")
            {
                (req.body.strICReport == "Current") ? strTableName = "tbl_bin_master_ipc" : strTableName = "tbl_bin_master_ipc_archived";  
            }
            else if(req.body.strCubType == "Granulation")
            {
                (req.body.strICReport == "Current") ? strTableName = "tbl_bin_master_gran" : strTableName = "tbl_bin_master_gran_archived";  
            }
            else 
            {
                (req.body.strICReport == "Current") ? strTableName = "tbl_bin_master_cap" : strTableName = "tbl_bin_master_cap_archived"; 
            }

            var objGetProductFromMaster = { 
                where : {Bin_Status:1},
                order: [
                    ['RecNo','ASC']
                ]
            };

            if(req.body.strFormName != "LabelGeneration"){
                Object.assign(objGetProductFromMaster.where,{Bin_BatchComplete:1})
            }
            

            let result = await models[strTableName].findAll({
                attributes:[[sequelize.fn('DISTINCT',sequelize.col('Bin_ProductID')),'Bin_ProductID'],sequelize.col('Bin_ProductName'),sequelize.col('Bin_ProductVersion'),sequelize.col('Bin_Version')]
            },objGetProductFromMaster);
            return result;
        } catch (error) {
            return error;
        }
    }

         /** This function is used to get data from tbl_bin_master_.Condition :- Batch Status 1 (ie. Gross wt completed)
      * @param {*} req :- Object from angular :- table name
     */
    async getBinDataGetBatch(req){
        try {
            var strTableName = "";
            if(req.body.strCubType == "Compression") 
            {
                (req.body.strICReport == "Current") ? strTableName = "tbl_bin_master_comp" : strTableName = "tbl_bin_master_comp_archived";
            }
            else if(["Coating"].includes(req.body.strCubType))
            {
                (req.body.strICReport == "Current") ? strTableName = "tbl_bin_master_coat" : strTableName = "tbl_bin_master_coat_archived";  
            }
            else if(req.body.strCubType == "IPC")
            {
                (req.body.strICReport == "Current") ? strTableName = "tbl_bin_master_ipc" : strTableName = "tbl_bin_master_ipc_archived";  
            }
            else if(req.body.strCubType == "Granulation")
            {
                (req.body.strICReport == "Current") ? strTableName = "tbl_bin_master_gran" : strTableName = "tbl_bin_master_gran_archived";  
            }
            else 
            {
                (req.body.strICReport == "Current") ? strTableName = "tbl_bin_master_cap" : strTableName = "tbl_bin_master_cap_archived"; 
            }

            var objGetBatchFromMaster = { 
                where : {
                    Bin_ProductID:req.body.str_prdID,
                    Bin_ProductName: req.body.str_prdName,
                    Bin_ProductVersion:req.body.str_prdVersion,
                    Bin_Version:req.body.str_version,
                    Bin_Area: req.body.strCubType,
                    Bin_Status:1
                },
                order: [
                    ['RecNo','ASC']
                ]
            };

            if(req.body.strFormName != "LabelGeneration")
            {
                Object.assign(objGetBatchFromMaster.where,{Bin_BatchComplete:1})
            }

            let result = await models[strTableName].findAll(objGetBatchFromMaster)
            return result;
        } catch (error) {
            console.log(error);
            throw error;
        }
    }

      /** This function is used to get print no. from tbl_bin_master_.Condition :- Batch Status 1 (ie. Gross wt completed)
      * @param {*} req :- Object from angular :- table name
     */
    async getPrinterNo(req){
        try {
            var strTableName = "";
            if(req.body.strCubType == "Compression") 
            {
                (req.body.strICReport == "Current") ? strTableName = "tbl_bin_master_comp" : strTableName = "tbl_bin_master_comp_archived";
            }
            else if(["Coating"].includes(req.body.strCubType))
            {
                (req.body.strICReport == "Current") ? strTableName = "tbl_bin_master_coat" : strTableName = "tbl_bin_master_coat_archived";  
            }
            else if(req.body.strCubType == "Granulation")
            {
                (req.body.strICReport == "Current") ? strTableName = "tbl_bin_master_gran" : strTableName = "tbl_bin_master_gran_archived";  
            }
            else if(req.body.strCubType == "IPC")
            {
                (req.body.strICReport == "Current") ? strTableName = "tbl_bin_master_ipc" : strTableName = "tbl_bin_master_ipc_archived";  
            }
            else 
            {
                (req.body.strICReport == "Current") ? strTableName = "tbl_bin_master_cap" : strTableName = "tbl_bin_master_cap_archived"; 
            }

            // const objGetProductFromMaster = {
            //     str_tableName: strTableName,
            //     data: 'distinct Bin_PrintNoSummary',
            //     condition: [
            //         { str_colName: 'Bin_ProductID', value: req.body.str_prdID },
            //         { str_colName: 'Bin_ProductName', value: req.body.str_prdName },
            //         { str_colName: 'Bin_ProductVersion', value: req.body.str_prdVersion },
            //         { str_colName: 'Bin_Version', value: req.body.str_version },
            //         { str_colName: 'Bin_BatchNo', value: req.body.str_batchNo },
            //         { str_colName: 'Bin_BatchComplete', value: 1,comp: 'eq' }
            //     ],
            //     order:[
            //         { str_colName: 'RecNo' , value: 'ASC'}
            //     ] 
            // }

            let result = await models[strTableName].findAll({
                attributes:[[sequelize.fn('DISTINCT',sequelize.col('Bin_PrintNoSummary')),'Bin_PrintNoSummary'],sequelize.col('RecNo')],
                where:{
                    Bin_ProductID: req.body.str_prdID,
                    Bin_ProductName: req.body.str_prdName,
                    Bin_ProductVersion: req.body.str_prdVersion,
                    Bin_Version: req.body.str_version,
                    Bin_BatchNo: req.body.str_batchNo,
                    Bin_Area:req.body.strCubType,
                    Bin_BatchComplete: 1
                },
                order:[
                    ['RecNo','ASC']
                ]
            });

            return result;
        } catch (error) {
            console.log(error);
            throw error;
        }
    }


     /** This function is used to get data from tbl_bin_master_.Condition :-batch status =1
      * @param {*} req :- Object from angular :- table name
     */
    async getBinMasterData(req){
        try {
            var strTableName = "";
            if(req.body.strCubType == "Compression") 
            {
                (req.body.strICReport == "Current") ? strTableName = "tbl_bin_master_comp" : strTableName = "tbl_bin_master_comp_archived";
            }
            else if(["Coating"].includes(req.body.strCubType))
            {
                (req.body.strICReport == "Current") ? strTableName = "tbl_bin_master_coat" : strTableName = "tbl_bin_master_coat_archived";  
            }
            else if(req.body.strCubType == "IPC")
            {
                (req.body.strICReport == "Current") ? strTableName = "tbl_bin_master_ipc" : strTableName = "tbl_bin_master_ipc_archived";  
            }
            else if(req.body.strCubType == "Granulation")
            {
                (req.body.strICReport == "Current") ? strTableName = "tbl_bin_master_gran" : strTableName = "tbl_bin_master_gran_archived";  
            }
            else 
            {
                (req.body.strICReport == "Current") ? strTableName = "tbl_bin_master_cap" : strTableName = "tbl_bin_master_cap_archived"; 
            }
            
            // const objGetDataFromMaster = {
            //     str_tableName: strTableName,
            //     data: '*',
            //     condition: [
            //         { str_colName: 'Bin_Status', value: 1,comp: 'eq' },
            //         { str_colName: 'Bin_ProductID', value: req.body.str_prdID },
            //         { str_colName: 'Bin_ProductName', value: req.body.str_prdName },
            //         { str_colName: 'Bin_ProductVersion', value: req.body.str_prdVersion },
            //         { str_colName: 'Bin_Version', value: req.body.str_version },
            //         { str_colName: 'Bin_BatchNo', value: req.body.strBatch }
            //     ],
            //     order:[
            //         { str_colName: 'RecNo' , value: 'ASC'}
            //     ]  
            // }

            // let result = await database.select(objGetDataFromMaster);
            let result = await models[strTableName].findAll({
                where:{
                    Bin_ProductID: req.body.str_prdID,
                    Bin_ProductName: req.body.str_prdName,
                    Bin_ProductVersion: req.body.str_prdVersion,
                    Bin_Version: req.body.str_version,
                    Bin_BatchNo: req.body.strBatch,
                    Bin_Status: 1
                },
                order:[
                    ['RecNo','ASC']
                ]
            });
            return result;
        } catch (error) {
            return error;
        }

    }

    /** this function is used to store data in temp table for label generation */
    async storeBinLabelDataInTemp(obj, req) 
    {
        try {
            var transactionRes = await seqTransaction.sequelize.transaction( async (t) => {
                let Ip = requestIp.getClientIp(req);
                var ipAdd;
                if ((("idsNo" in obj) == true)) {
                    ipAdd = `${obj.idsNo}`;
                } else {
                    let ClIp = Ip.split(':')[3]
                    var ClientIp;
                    if (ClIp === undefined) {
                        ClientIp = '127.0.0.1';
                    } else {
                        ClientIp = ClIp;
                    }

                    ipAdd = ClientIp;
                }

                if (obj.str_source == "Auto") {
                    ipAdd = obj.str_hmi;
                    console.log("Autoip", ipAdd)
                }
                
                var objdelete = await this.deleteDatas(ipAdd,"tbl_bin_label_temp",t);
                var MasterData = await this.selectDataFromBinMasterForLabel(obj);
                var TempInsert = await this.insertDataToTempTableForLabel(MasterData[0], ipAdd,t);
            
                if (TempInsert == "Successfull") {
                    return { result: "Success", data: objdelete};
                }else{
                    return '';
                }
            });
            return transactionRes
        } catch (error) {
            console.log(error);
            throw error;
        }
    }

    async getProductFromCubical(obj, req) 
    {
        try {
           let res = await models.tbl_product_master.findAll({ where: {
                    ProductId:obj.str_prodId,
                    ProductName:obj.str_prodName,
                    ProductVersion:obj.str_prodVerNo,
                    Version:obj.str_verNo
                }
           });

           let resObj ;
           // this combination will have only 1 product only
           if(res[0].IsBilayer == 1)
           {
            resObj = res[0].IsTrilayer == 1 ? [res[0].IsBilayerLbl,res[0].IsTrilayerLbl] : [res[0].IsBilayerLbl];
           }else
           {
            resObj = ['NA'];
           }
           return resObj;
        } catch (error) {
            console.log(error);
            throw error;
        }
    }

    async selectDataFromBinMasterForLabel(obj) {
        try {
            var strTableName = "";
            if(obj.str_cubicleType == "Compression") 
            {
                (obj.str_ICReport == "Current") ? strTableName = "tbl_bin_master_comp" : strTableName = "tbl_bin_master_comp_archived";
            }
            else if(["Coating"].includes(obj.str_cubicleType))
            {
                (obj.str_ICReport == "Current") ? strTableName = "tbl_bin_master_coat" : strTableName = "tbl_bin_master_coat_archived";  
            }
            else if(obj.str_cubicleType == "Granulation")
            {
                (obj.str_ICReport == "Current") ? strTableName = "tbl_bin_master_gran" : strTableName = "tbl_bin_master_gran_archived";  
            }
            else if(obj.str_cubicleType == "IPC")
                {
                    (obj.str_ICReport == "Current") ? strTableName = "tbl_bin_master_ipc" : strTableName = "tbl_bin_master_ipc_archived";  
                }
            else 
            {
                (obj.str_ICReport == "Current") ? strTableName = "tbl_bin_master_cap" : strTableName = "tbl_bin_master_cap_archived"; 
            }
            // const objSelect = {
            //     str_tableName: strTableName,
            //     data: '*',
            //     condition: [
            //         { str_colName: "RecNo", value: obj.RecNo }
            //     ]
            // }

            let result = await models[strTableName].findAll({
                where:{RecNo: obj.RecNo}
            });
            return result;
        } catch (error) {
            console.log(error);
            throw error;
        }
    }

    /** @Modification :- 
     * 1. Discussion on 03/08/2021 with darsh - in Cipla 4 Indore 2 digit required.
     */
    async insertDataToTempTableForLabel(element, intIPAddress,t) {
        try {
            const arrQueries = [];

            var strBatchSize = 0;
            if(int_BatchSizeWithUnit == 0)
            {
                var arr = (element.Bin_BatchSize).split(" ");
                strBatchSize = (arr[1].includes("Lakh") == true) ? Number(arr[0]) * 100000 : (arr[1].includes("Thousand") == true) ? Number(arr[0]) * 1000 :
                (arr[1].includes("Million") == true) ? Number(arr[0]) * 1000000 : Number(arr[0]) * 1000;
            }
            else
            {
                strBatchSize = element.Bin_BatchSize;
            }
            
            await models.tbl_bin_label_temp.create({
                RecNo: element.RecNo,
                Bin_ProductID: element.Bin_ProductID,
                Bin_ProductName: element.Bin_ProductName,
                Bin_ProductVersion: element.Bin_ProductVersion,
                Bin_Version: element.Bin_Version,
                Bin_BatchNo: element.Bin_BatchNo,
                Bin_BatchSize: strBatchSize,
                Bin_TotalBin: element.Bin_TotalBin,
                Bin_TotalSelected: element.Bin_TotalSelected,
                Bin_Lot: element.Bin_Lot,
                Bin_MfgDt: element.Bin_MfgDt,
                Bin_ExpDt: element.Bin_ExpDt,
                Bin_InitialStage: element.Bin_Initial,
                Bin_NextStage: element.Bin_Next,
                Bin_Printer: element.Bin_Printer,
                // Bin_SrNoCubicle: element.Bin_SrNoCubicle,
                Bin_SrNoWeighment: element.Bin_SrNoWeighment,
                Bin_BinID: element.Bin_BinID,
                Bin_PrDate: element.Bin_PrDate,
                Bin_PrTime: date.format(element.Bin_PrTime, 'HH:mm:ss'),
                Bin_WeighingBalID: element.Bin_InstrumentID,
                Bin_TareWt: element.Bin_TareWt,
                Bin_GrossWt: element.Bin_GrossWt,
                bin_NetWeight: element.bin_NetWeight,
                Bin_DoneUserID: element.Bin_UserID,
                Bin_DoneUserName: element.Bin_UserName,
                Bin_PrintNo: element.Bin_PrintNo,
                Bin_LabelHeader: element.Bin_Header,
                HMIID: intIPAddress,
                // Sys_DateNA: element.Sys_DateNA 
            },{
                transaction:t
            })
            // arrQueries.push(objMasterQuery);

        //    let result = await  objTranDatabase.funMakeQueries(arrQueries);
           return "Successfull";
            
        } catch (error) {
            console.log(error);
            throw error
        }
            
    }

    /**
     * This function is used to get list of product from tbl_product_master table
     */
    async getProductFromProductMaster(){
        // return new Promise((resolve, reject) => {
            try {
                let result = await models.tbl_product_master.findAll({
                    attributes:[[sequelize.fn('DISTINCT',sequelize.col('ProductId')),'ProductId'],sequelize.col('ProductName'),
                    sequelize.col('ProductVersion'),sequelize.col('Version')]
                });
                return result;
            } catch (error) {
                console.log(error);
                throw error;
            }
    }

    /** If product is assigned to cubicle then fetch batch no. from cubicle */
    async getBatchFromCubicleUsingProduct(value)
    {
        try {
            let res_object = {};
            if(value.str_ProductName != "None")
            {
                
                let result = await models.tbl_cubical.findAll({
                    attributes:[sequelize.fn('DISTINCT',sequelize.col('Sys_Batch')),'Sys_Batch'],
                    where:{
                        Sys_BFGCode:value.str_ProductID,
                        Sys_ProductName: value.str_ProductName,
                        Sys_PVersion:value.str_ProductVersion,
                        Sys_Version:value.str_Version
                    }
                });
                let str = (result.length > 0) ? result[0].Sys_Batch : "NULL";
                Object.assign(res_object,{"Batch":str});
                return res_object;
            }
            else
            {
                Object.assign(res_object,{"Batch":"None"});
                return res_object;
            }

            

           
        } catch (error) {
            console.log("getBatchFromCubicleUsingProduct",error);
            return error;
        }
    }

    async getProductNameFromProductMaster(){
        try {
            let result = await models.tbl_product_master.findAll({
                attributes:[sequelize.fn('DISTINCT', sequelize.col('ProductName')),'ProductName'],
                where:{IsActive:1}
            });
            return result;
        } catch (error) {
            console.log(error);
            throw error;
        }
        // return new Promise((resolve, reject) => {
        //     const objProduct = {
        //         str_tableName: 'tbl_product_master',
        //         data: 'distinct ProductName',
        //         condition:[
        //             { str_colName: "IsActive", value: 1, comp: 'eq' } 
        //         ]
        //     }
        //     database.select(objProduct).then((result) => {
        //         resolve(result[0]);
        //     }).catch(err => {
        //         reject(err);
        //     })
        // })
    }

    /**
     * This function is used to get list of batches from tbl_bin_batches table
     */
    async getBatches(req){
        try {
            // const objBatches = {
            //     str_tableName: 'tbl_bin_batches',
            //     data: '*',
            //     condition:[
            //         {str_colName: 'Batch', value: req.body.strBatch}
            //     ]
            // }
            let result = await models.tbl_bin_batches.findAll({
                where:{ Batch: req.body.strBatch}
            });
            return result;
        } catch (error) {
            console.log(error);
            throw error;
        }
    }

}

module.exports = BinModel;