const serverConfig = require('../global/serverConfig');
const str_mgDPs = 0;

 /** MG Change :-
 *   This change is requested by client : SVP (CRF-40), Hosur(CRF-)
 * If unit is "mg" then int_DP = From Developer Panel else as per balance DP
 */ 
class FormulaModel {
    calculateT1Neg(val, avgVal) { 
        var isNomAvg = 0;
        var dp = 0;
        dp = (val.Unit == "mg") ? Number(str_mgDPs) : val.DecimalPoint;
        (val.GraphType == "1") ? isNomAvg = avgVal : isNomAvg = val.Nom;
        let limitOn = val.limitOn[0];
        if (limitOn == 0) { // 0 -> Actual
            return Number(isNomAvg) - Number(val.T1NegTol);
        } else { // 1 -> Percentage
            let T1;
            T1 = (((Number(isNomAvg) * Number(val.T1NegTol)) / 100) - Number(isNomAvg));
            T1 =  parseFloat(Math.round(T1 * Math.pow(10, dp)) / Math.pow(10, dp)).toFixed(dp);

            return Math.abs(T1);
         }
    }
    calculateT1Pos(val, avgVal) {
        var isNomAvg = 0;
        var dp = 0;
        dp = (val.Unit == "mg") ?  Number(str_mgDPs) : val.DecimalPoint;
        (val.GraphType == "1") ? isNomAvg = avgVal : isNomAvg = val.Nom;

        let limitOn = val.limitOn[0];
        if (limitOn == 0) { // 0 -> Actual
            return Number(isNomAvg) + Number(val.T1PosTol);
        } else { // 1 -> Percentage
            let T1;
            T1 = (((Number(isNomAvg) * Number(val.T1PosTol)) / 100) + Number(isNomAvg));
            //T1 =  parseFloat(Math.round(T1 * Math.pow(10, dp)) / Math.pow(10, dp)).toFixed(dp);

            return Math.abs(T1);
        }
    }
    calculateT2Neg(val, avgVal) {
        var isNomAvg = 0;
        var dp = 0;
        dp = (val.Unit == "mg") ?  Number(str_mgDPs) : val.DecimalPoint;
        (val.GraphType == "1") ? isNomAvg = avgVal : isNomAvg = val.Nom;
        let limitOn = val.limitOn[0];
        if (limitOn == 0) { // 0 -> Actual
            return Number(isNomAvg) - Number(val.T2NegTol);
        } else { // 1 -> Percentage
            let T2;
            T2 = (((Number(isNomAvg) * Number(val.T2NegTol)) / 100) - Number(isNomAvg));
            T2 =  parseFloat(Math.round(T2 * Math.pow(10, dp)) / Math.pow(10, dp)).toFixed(dp);

            return Math.abs(T2);
        }
    }
    calculateT2Pos(val, avgVal) {
        var isNomAvg = 0;
        var dp = 0;
        dp = (val.Unit == "mg") ?  Number(str_mgDPs) : val.DecimalPoint;
        (val.GraphType == "1") ? isNomAvg = avgVal : isNomAvg = val.Nom;
        let limitOn = val.limitOn[0];
        if (limitOn == 0) { // 0 -> Actual
            return Number(isNomAvg) + Number(val.T2PosTol);
        } else { // 1 -> Percentage
            let T2;
            T2 = (((Number(isNomAvg) * Number(val.T2PosTol)) / 100) + Number(isNomAvg))
            //T2 =  parseFloat(Math.round(T2 * Math.pow(10, dp)) / Math.pow(10, dp)).toFixed(dp);
            
            return Math.abs(T2);
        }
    }

    calculateT2NegGroup(val,spValues) {
        let limitOn = val.limitOn[0];
        if (limitOn == 0) { // 0 -> Actual
            return Number(spValues['@Nom']) - Number(spValues['@Low']);
        } else { // 1 -> Percentage
            let T2;
            T2 = (((Number(['@Nom']) * Number(spValues['@Low'])) / 100) - Number(['@Nom']))
            return Math.abs(T2);
        }
    }
    calculateT2PosGroup(val,spValues) {
        let limitOn = val.limitOn[0];
        if (limitOn == 0) { // 0 -> Actual
            return Number(['@Nom']) + Number(spValues['@Upp']);
        } else { // 1 -> Percentage
            let T2;
            T2 = (((Number(['@Nom']) * Number(spValues['@Upp'])) / 100) + Number(['@Nom']))
            return Math.abs(T2);
        }
    }

    convertToNumber(element)
    {
        return Number(element);
    }

    stdLnt1Calculate(nom,t1Neg,t1Pos,t2Neg,t2Pos,limitNo,average,standard,graphType,nmtTab,strUnit,calT1Neg,calT1Pos,calT2Neg,calT2Pos,int_DP){
        var intNo, floatT1NegVal, floatT1PosVal, floatT2NegVal, floatT2PosVal, strLimitText1 = "", strLimitText2 = "";
        var intLimits = 0;
        var responseObj = {};
        //here graphtype is check 0 represent standred value of datavalue else avg of datavalue
        if(graphType == 0 ){
            intNo = nom;
        }
        else{
            intNo = average;
        }
        int_DP = 2; // cipla 4 indore 21/04/2021 mail
        
        //here limit is check 0 represent actual else percantage
        if(limitNo == 1){
            if(t1Neg == 0)
            {
                floatT1NegVal = 0;
                floatT1PosVal = 0;
                floatT2NegVal = calT2Neg;//intNo - (intNo *(t2Neg/100));
                floatT2PosVal = calT2Pos;//Number(intNo) + Number(intNo *(t2Pos/100));


                (t2Neg == t2Pos) ? intLimits = "± " + Number(t2Neg).toFixed(int_DP) + " %" : intLimits = Number(t2Neg).toFixed(int_DP) + " % - " + Number(t2Pos).toFixed(int_DP) + " %";
                strLimitText1 = "NA";
                strLimitText2 = "None of tablets by " + intLimits;
            }
            else{
                floatT1NegVal = calT1Neg;//intNo - (intNo *(t1Neg/100));
                floatT1PosVal = calT1Pos;//Number(intNo) + Number(intNo *(t1Pos/100));
                floatT2NegVal = calT2Neg;//intNo - (intNo *(t2Neg/100));
                floatT2PosVal = calT2Pos;//Number(intNo) + Number(intNo *(t2Pos/100));

                (t1Neg == t1Pos) ? strLimitText1 = "NMT "+ nmtTab+" tablets by ±" + Number(t1Neg).toFixed(int_DP) +" %" : strLimitText1 = "NMT "+ nmtTab+" tablets by " + Number(t1Neg).toFixed(int_DP) + " % - " + Number(t1Pos).toFixed(int_DP) + " %";
                (t2Neg == t2Pos) ? strLimitText2 = "None of tablets by ±" + Number(t2Neg).toFixed(int_DP) + " %" : strLimitText2 = "None of tablets by " + Number(t2Neg).toFixed(int_DP) + " % - " + Number(t2Pos).toFixed(int_DP) + " %";
            }
        }
        else{
            if(t1Neg == 0) 
            {
                floatT1NegVal = 0;
                floatT1PosVal = 0;
                floatT2NegVal = calT2Neg;//(intNo - t2Neg);
                floatT2PosVal = calT2Pos;//Number(intNo) + Number(t2Pos);

                strLimitText1 = "NA";
                (t2Neg == t2Pos) ? intLimits = "± " + t2Neg + " " + strUnit : intLimits = t2Neg + " - " + t2Pos + strUnit;
                strLimitText2 = "None of tablets by " + intLimits;
            }
            else{
                floatT1NegVal = calT1Neg;//(intNo - t1Neg);
                floatT1PosVal = calT1Pos;//Number(intNo) + Number(t1Pos);
                floatT2NegVal = calT2Neg;//(intNo - t2Neg);
                floatT2PosVal = calT2Pos;//Number(intNo) + Number(t2Pos);

                (t1Neg == t1Pos) ?  strLimitText1 = "NMT "+ nmtTab+" tablets by ±"+ t1Neg + " " + strUnit : strLimitText1 = "NMT "+ nmtTab+" tablets by " + t1Neg + " " + strUnit + " - " + t1Pos + " " + strUnit;

                (t2Neg == t2Pos) ? strLimitText2 = "None of tablets by ± " + t2Neg + " " + strUnit : strLimitText2 = "None of tablets by " + t2Neg + " " + strUnit + " - " + t2Pos + " " + strUnit;
            }
        }

        return Object.assign(responseObj,{strTxt1:strLimitText1, strTxt2: strLimitText2, 
            calNeg1: floatT1NegVal,calPos1: floatT1PosVal,calNeg2: floatT2NegVal,calPos2: floatT2PosVal});
    }

    stdLimitCalculateGroup(nom,t1Neg,t1Pos,t2Neg,t2Pos,limitNo,average,graphType,str_projectName,int_DP){
        var intNo, dblLower, dblUpper,dblLower2, dblUpper2, strLimitText1 = "", strLimitText2 = "",floatT1NegVal, floatT1PosVal, floatT2NegVal, floatT2PosVal;
        var intLimits = 0;
        var responseObj = {};
        //here graphtype is check 0 represent standred value of datavalue else avg of datavalue
        (graphType == 0 ) ? intNo = nom : intNo = average;

        //here limit is check 0 represent actual else percantage
        if(limitNo == 1){
            if(str_projectName == "SVP")
            {
                if(t1Neg == 0)
                {
                    floatT1NegVal = 0;
                    floatT1PosVal = 0;
                    floatT2NegVal = intNo - (intNo *(t2Neg/100));
                    floatT2PosVal = Number(intNo) + Number(intNo *(t2Pos/100));
    
    
                    (t2Neg == t2Pos) ? intLimits = "± " + Number(t2Neg).toFixed(int_DP) + " %" : intLimits = Number(t2Neg).toFixed(int_DP) + " % - " + Number(t2Pos).toFixed(int_DP) + " %";
                    strLimitText1 = "NA";
                    strLimitText2 = intLimits;
                }
                else{
                    floatT1NegVal = intNo - (intNo *(t1Neg/100));
                    floatT1PosVal = Number(intNo) + Number(intNo *(t1Pos/100));
                    floatT2NegVal = intNo - (intNo *(t2Neg/100));
                    floatT2PosVal = Number(intNo) + Number(intNo *(t2Pos/100));
    
                    (t1Neg == t1Pos) ? strLimitText1 = "±" + Number(t1Neg).toFixed(int_DP) +" %" : strLimitText1 =  Number(t1Neg).toFixed(int_DP) + " % - " + Number(t1Pos).toFixed(int_DP) + " %";
                    (t2Neg == t2Pos) ? strLimitText2 = "±" + Number(t2Neg).toFixed(int_DP) + " %" : strLimitText2 =  Number(t2Neg).toFixed(int_DP) + " % - " + Number(t2Pos).toFixed(int_DP) + " %";
                }
            }
            else
            {
                dblLower = intNo - (intNo *(t1Neg/100));
                dblUpper = Number(intNo) + Number(intNo *(t1Pos/100));
    
                strLimitText1 = dblLower;
                strLimitText2 = dblUpper;
            }
        }
        else{
            if(str_projectName == "SVP")
            {
                if(t1Neg == 0) 
                {
                    strLimitText1 = "NA";
                    (t2Neg == t2Pos) ? intLimits = "± " + t2Neg + " gm" : intLimits = t2Neg + " - " + t2Pos + " gm";
                    strLimitText2 = intLimits;
                }
                else{
                   
                    (t1Neg == t1Pos) ?  strLimitText1 = "±"+ t1Neg + " gm" : strLimitText1 = t1Neg + " " + " gm" + " - " + t1Pos + " gm";
    
                    (t2Neg == t2Pos) ? strLimitText2 = "± " + t2Neg +  " gm" : strLimitText2 =  t2Neg + " " + " gm" + " - " + t2Pos + " gm";
                }
            }
            else
            {
                dblLower = intNo - t1Neg;
                dblUpper = Number(intNo) + Number(t1Pos);
    
                strLimitText1 = dblLower;
                strLimitText2 = dblUpper;
            }
        }

        return Object.assign(responseObj,{strTxt1:strLimitText1, strTxt2: strLimitText2});
    }
 }
module.exports = FormulaModel