const dbCon = require('../Utills/db');
const Database = require('../database/clsQueryProcess');
const database = new Database();
const serverConfig = require('../global/serverConfig');
const clsStoredProcedure = require('./clsStoredProcedure');
const objStoredProcedure = new clsStoredProcedure();
const requestIp = require('request-ip');
const date = require('date-and-time');

class MultihalerReportModel {

async getMultihalerDetails(value) {
        try{
            var reportOption = value.reportOption;
            var fromDate = value.fromDate;
            var toDate = value.toDate;
            var testType = value.testType;
            var reportType = value.reportType;
            var recordFrom = value.recordFrom;
            var responseObj = {};
            var masterTableName, detailTableName;
            if (testType == 'Regular') { //1:- Initial and 0:- Regular
                testType = 0;
            } else {
                testType = 1;
            }
            var reciveObj =this.commanFunctionForFindingOutTableName(reportOption, reportType, recordFrom);
            masterTableName = reciveObj.masterTableName;
            detailTableName = reciveObj.detailTableName
            const selectMaster = {
                str_tableName: masterTableName,
                data: '*',
                condition: [
                    { str_colName: 'ReportType', value: testType, comp: 'eq' },
                    { str_colName: 'PrDate', value: fromDate, value1: toDate, comp: 'btn' }
                ]
            }
            if(reportOption != 'Sealed Cartridge'){
                selectMaster.condition.push({ str_colName: 'TestType', value: reportOption, comp: 'eq' },);
            }
            
            const selectDetail = {
                str_tableName: detailTableName,
                data: '*',
            }
    
            let result=await database.select(selectMaster);
                let data = result[0];
                if (detailTableName != '') {
                   let detailResult=await database.select(selectDetail);
                        for (let i = 0; i < data.length; i++) {
                            let RepSerNo = data[i].RepSerNo;
                            let arrDetailArray = detailResult[0];
                            let details = arrDetailArray.find(k => k.RepSerNo == RepSerNo);
                            let detailsObj = { 'detail': details };
                            Object.assign(data[i], detailsObj);
                        }
                        Object.assign(responseObj, { status: 'success' }, { result: data });
                        return responseObj;
                  
                } else {
                    Object.assign(responseObj, { status: 'success' }, { result: data });
                    return responseObj;
                }
        } catch (error) {
            return error;
        } 
}

async ViewMultihalerReport(value, req) {
   try{
        
        let clientIp = requestIp.getClientIp(req);
        let ip = clientIp.split(':')[3];
        if ((("idsNo" in value) == true)) {
            ip = `${serverConfig.strIpSeries}${value.idsNo}`;
        } else {
            if (ip === undefined) {
                ip = '127.0.0.1'
            } else {
                ip = ip
            }
        }
        var reportOption = value.reportOption;
        var testType = value.testType;
        var reportType = value.reportType;
        var recordFrom = value.recordFrom;
        var RepSerNo = value.RepSerNo;
        var printNo = value.printNo;
        var masterTableName, detailTableName;
        if (testType == 'Regular') {
            testType = 0;
        } else {
            testType = 1;
        }
        var reciveObj = this.commanFunctionForFindingOutTableName(reportOption, reportType, recordFrom);
        masterTableName = reciveObj.masterTableName;
        detailTableName = reciveObj.detailTableName;
        var selectObj = {
            str_tableName: masterTableName,
            data: '*',
            condition: [
                { str_colName: 'RepSerNo', value: RepSerNo }
            ]
        }
        var masterRes = await database.select(selectObj);
        var insertVal = masterRes[0][0];
        var selectTempData = {
            str_tableName: 'tbl_temp_master',
            data: '*',
            condition: [
                { str_colName: 'HMI_ID', value: ip.split('.')[3] }
            ]
        }
        var tempRes = await database.select(selectTempData);
        // Checking if there is entry for respected HMI or not
        if (tempRes[0].length != 0) {
            // If entry is present then we have to delete and insert or directly insert
            var deleteTempMaster = {
                str_tableName: 'tbl_temp_master',
                condition: [
                    { str_colName: 'HMI_ID', value: ip.split('.')[3] }
                ]
            }
            if ((reportOption == 'Net Content') || (reportOption == 'Dry Cartridge') || (reportOption == 'Dry Powder')) {
                var deleteTempDetail = {
                    str_tableName: 'tbl_temp_detail7',
                    condition: [
                        { str_colName: 'HMI_ID', value: ip.split('.')[3] }
                    ]
                }
            } else if (reportOption == 'Sealed Cartridge') {
                var deleteTempDetail = {
                    str_tableName: 'tbl_temp_detail8',
                    condition: [
                        { str_colName: 'HMI_ID', value: ip.split('.')[3] }
                    ]
                }
            }
        var deleteMasterEntries = await database.delete(deleteTempMaster);
        var deleteMasterEntries = await database.delete(deleteTempDetail);
        var netRes,netCalRes,groupRes,groupCalRes;
        
        if ((reportOption == 'Net Content') || (reportOption == 'Dry Cartridge') || (reportOption == 'Dry Powder')) {
            netRes = await this.insertNetTempTables(insertVal, ip, detailTableName, RepSerNo);
            netCalRes = await this.calculationNet(insertVal, RepSerNo, ip, value,reportType, printNo);
            return(netCalRes);
        } else if (reportOption == 'Sealed Cartridge') {
            groupRes = await this.insertGroupTempTables(insertVal, ip, detailTableName, RepSerNo);
            groupCalRes = await this.calculationGroup(insertVal, RepSerNo, ip, value, printNo);
            return(groupCalRes);
        }  

        } 
        else 
        {
            if ((reportOption == 'Net Content') || (reportOption == 'Dry Cartridge') || (reportOption == 'Dry Powder')) {
                netRes = await this.insertNetTempTables(insertVal, ip, detailTableName, RepSerNo);
                netCalRes = await this.calculationNet(insertVal, RepSerNo, ip, value, reportType, printNo);
                return(netCalRes);
            } else if (reportOption == 'Sealed Cartridge') {
                groupRes = await this.insertGroupTempTables(insertVal, ip, detailTableName, RepSerNo);
                groupCalRes = await this.calculationGroup(insertVal, RepSerNo, ip, value, reportType, printNo);
                return(groupCalRes);
            }  
            
        }   
   } catch (error) 
   {
    return error
    } 
    
}

async insertNetTempTables(insertVal, ip, detailTableName, RepSerNo) {
    try {
        var insertTempObj = {
            str_tableName: 'tbl_temp_master',
            data: [
                { str_colName: 'RepSerNo', value: insertVal.RepSerNo }, { str_colName: 'MstSerNo', value: insertVal.MstSerNo },
                { str_colName: 'InstruId', value: insertVal.InstruId }, { str_colName: 'BFGCode', value: insertVal.BFGCode },
                { str_colName: 'ProductName', value: insertVal.ProductName }, { str_colName: 'ProductType', value: insertVal.ProductType },
                { str_colName: 'Qty', value: insertVal.Qty }, { str_colName: 'GrpQty', value: insertVal.GrpQty },
                { str_colName: 'GrpFreq', value: insertVal.GrpFreq }, { str_colName: 'Idsno', value: insertVal.Idsno },
                { str_colName: 'CubicalNo', value: insertVal.CubicalNo }, { str_colName: 'BalanceId', value: insertVal.BalanceId },
                { str_colName: 'BalanceNo', value: insertVal.BalanceNo }, { str_colName: 'VernierId', value: insertVal.VernierId },
                { str_colName: 'VernierNo', value: insertVal.VernierNo }, { str_colName: 'BatchNo', value: insertVal.BatchNo },
                { str_colName: 'UserId', value: insertVal.UserId }, { str_colName: 'UserName', value: insertVal.UserName },
                { str_colName: 'PrDate', value: insertVal.PrDate }, { str_colName: 'PrTime', value: insertVal.PrTime },
                { str_colName: 'PrEndDate', value: insertVal.PrEndDate }, { str_colName: 'PrEndTime', value: insertVal.PrEndTime },
                { str_colName: 'Side', value: insertVal.Side }, { str_colName: 'Unit', value: insertVal.Unit },
                { str_colName: 'DecimalPoint', value: insertVal.DecimalPoint }, { str_colName: 'WgmtModeNo', value: insertVal.WgmtModeNo },
                { str_colName: 'Nom', value: insertVal.Nom }, { str_colName: 'T1NegTol', value: insertVal.T1NegTol },
                { str_colName: 'T1PosTol', value: insertVal.T1PosTol }, { str_colName: 'T2NegTol', value: insertVal.T2NegTol },
                { str_colName: 'T2PosTol', value: insertVal.T2PosTol }, { str_colName: 'limitOn', value: insertVal.limitOn },
                { str_colName: 'NomEmpty', value: insertVal.NomEmpty }, { str_colName: 'T1NegEmpty', value: insertVal.T1NegEmpty },
                { str_colName: 'T1PosEmpty', value: insertVal.T1PosEmpty }, { str_colName: 'T2NegEmpty', value: insertVal.T2NegEmpty },
                { str_colName: 'T2PosEmpty', value: insertVal.T2PosEmpty }, { str_colName: 'NomNet', value: insertVal.NomNet },
                { str_colName: 'T1NegNet', value: insertVal.T1NegNet }, { str_colName: 'T1PosNet', value: insertVal.T1PosNet },
                { str_colName: 'T2NegNet', value: insertVal.T2NegNet }, { str_colName: 'T2PosNet', value: insertVal.T2PosNet },
                { str_colName: 'CubicleType', value: insertVal.CubicleType }, { str_colName: 'ReportType', value: insertVal.ReportType },
                { str_colName: 'MachineCode', value: insertVal.MachineCode }, { str_colName: 'MFGCode', value: insertVal.MFGCode },
                { str_colName: 'BatchSize', value: insertVal.BatchSize }, { str_colName: 'FriabilityID', value: insertVal.FriabilityID },
                { str_colName: 'HardnessID', value: insertVal.HardnessID }, { str_colName: 'CubicleName', value: insertVal.CubicleName },
                { str_colName: 'CubicleLocation', value: insertVal.CubicleLocation },
                { str_colName: 'RepoLabel10', value: insertVal.RepoLabel10 }, { str_colName: 'RepoLabel11', value: insertVal.RepoLabel11 },
                { str_colName: 'RepoLabel12', value: insertVal.RepoLabel12 }, { str_colName: 'RepoLabel13', value: insertVal.RepoLabel13 },
                { str_colName: 'PrintNo', value: insertVal.PrintNo }, { str_colName: 'IsArchived', value: insertVal.IsArchived },
                { str_colName: 'GraphType', value: insertVal.GraphType }, { str_colName: 'BatchComplete', value: insertVal.BatchComplete },
                { str_colName: 'PVersion', value: insertVal.PVersion }, { str_colName: 'Version', value: insertVal.Version },
                { str_colName: 'CheckedByID', value: insertVal.CheckedByID }, { str_colName: 'CheckedByName', value: insertVal.CheckedByName },
                { str_colName: 'CheckedByDate', value: insertVal.CheckedByDate }, { str_colName: 'BRepSerNo', value: insertVal.BRepSerNo },
                { str_colName: 'HMI_ID', value: ip.split('.')[3] },{ str_colName: 'TestType', value: insertVal.TestType }
            ]
        }
        var res = await database.save(insertTempObj);

        var selectDetailObj  = `SELECT RepSerNo, RecSeqNo, ROUND(DataValue,3) AS DataValue, ROUND(DataValue1,3) AS DataValue1,
        ROUND(NetWeight,3) AS NetWeight, DecimalPoint, Remark FROM ${detailTableName} WHERE RepSerNo = ${RepSerNo}`;
        var detailData = await dbCon.execute(selectDetailObj);
        for (const v of detailData[0]) {
            var insertDetail = {
                str_tableName: 'tbl_temp_detail7',
                data: [
                    { str_colName: 'RepSerNo', value: v.RepSerNo },
                    { str_colName: 'MstSerNo', value: 0 },
                    { str_colName: 'RecSeqNo', value: v.RecSeqNo },
                    { str_colName: 'DataValue', value: v.DataValue },
                    { str_colName: 'DataValue1', value: v.DataValue1 },
                    { str_colName: 'NetValue', value: v.NetWeight },
                    { str_colName: 'Remark', value: v.Remark },
                    { str_colName: 'DecimalPoint', value: v.DecimalPoint },
                    { str_colName: 'HMI_ID', value: ip.split('.')[3] }
                ]
            }
            
            var result = await database.save(insertDetail);
            
        }

        return true;
    } catch (error) {
        return error
    }
}

async calculationNet(insertVal, RepSerNo, ip, value, reportType, printNo){
    try{
        const objData = {};
        var result = await objStoredProcedure.getCalculationForNetMultihaler(insertVal, RepSerNo, ip, value,reportType); 
        Object.assign(objData, { RepSerNo: RepSerNo },{ Average: result[1][0]['@average'] }, { UserId: value.userId }, { UserName: value.username }, { StandardDeviation: result[1][0]['@standardDeviation'] },
        { StdLowerActual : result[1][0]['@lowerLimitActual'] }, { StdUpperActual : result[1][0]['@upperLimitActual'] }, { StdLowerPercentage : result[1][0]['@lowerLimitPercentage'] }, { StdUpperPercentage : result[1][0]['@upperLimitPercentage'] }, { MinimumWeight : result[1][0]['@minWeight']}, { MaximumWeight : result[1][0]['@maxWeight']}, { StdWeight : result[1][0]['@nominal']}, { MinimumPercentage
            : result[1][0]['@minPercentage'] }, { MaximumPercentage : result[1][0]['@maxPercentage'] },{ HmiId: ip.split('.')[3] }, { AboveLimitCount: result[1][0]['@aboveLimitCount'] }, { BelowLimitCount: result[1][0]['@belowLimitCount'] }, { Remark: result[1][0]['@result']},
        { waterMark: true },{ ReportType:reportType },{str_verifyByVal:value.str_verifyByVal},{printNo:printNo});
        return objData;
    }catch(error){
        return error;
    }
    
}

async insertGroupTempTables(insertVal, ip, detailTableName, RepSerNo) {
    try {
        var insertTempObj = {
            str_tableName: 'tbl_temp_master',
            data: [
                { str_colName: 'RepSerNo', value: insertVal.RepSerNo }, { str_colName: 'MstSerNo', value: insertVal.MstSerNo },
                { str_colName: 'InstruId', value: insertVal.InstruId }, { str_colName: 'BFGCode', value: insertVal.BFGCode },
                { str_colName: 'ProductName', value: insertVal.ProductName }, { str_colName: 'ProductType', value: insertVal.ProductType },
                { str_colName: 'Qty', value: insertVal.Qty }, { str_colName: 'GrpQty', value: insertVal.GrpQty },
                { str_colName: 'GrpFreq', value: insertVal.GrpFreq }, { str_colName: 'Idsno', value: insertVal.Idsno },
                { str_colName: 'CubicalNo', value: insertVal.CubicalNo }, { str_colName: 'BalanceId', value: insertVal.BalanceId },
                { str_colName: 'BalanceNo', value: insertVal.BalanceNo }, { str_colName: 'VernierId', value: insertVal.VernierId },
                { str_colName: 'VernierNo', value: insertVal.VernierNo }, { str_colName: 'BatchNo', value: insertVal.BatchNo },
                { str_colName: 'UserId', value: insertVal.UserId }, { str_colName: 'UserName', value: insertVal.UserName },
                { str_colName: 'PrDate', value: insertVal.PrDate }, { str_colName: 'PrTime', value: insertVal.PrTime },
                { str_colName: 'PrEndDate', value: insertVal.PrEndDate }, { str_colName: 'PrEndTime', value: insertVal.PrEndTime },
                { str_colName: 'Side', value: insertVal.Side }, { str_colName: 'Unit', value: insertVal.Unit },
                { str_colName: 'DecimalPoint', value: insertVal.DecimalPoint }, { str_colName: 'WgmtModeNo', value: insertVal.WgmtModeNo },
                { str_colName: 'Nom', value: insertVal.Nom }, { str_colName: 'T1NegTol', value: insertVal.T1NegTol },
                { str_colName: 'T1PosTol', value: insertVal.T1PosTol }, { str_colName: 'T2NegTol', value: insertVal.T2NegTol },
                { str_colName: 'T2PosTol', value: insertVal.T2PosTol }, { str_colName: 'limitOn', value: insertVal.limitOn },
                { str_colName: 'NomEmpty', value: insertVal.NomEmpty }, { str_colName: 'T1NegEmpty', value: insertVal.T1NegEmpty },
                { str_colName: 'T1PosEmpty', value: insertVal.T1PosEmpty }, { str_colName: 'T2NegEmpty', value: insertVal.T2NegEmpty },
                { str_colName: 'T2PosEmpty', value: insertVal.T2PosEmpty }, { str_colName: 'NomNet', value: insertVal.NomNet },
                { str_colName: 'T1NegNet', value: insertVal.T1NegNet }, { str_colName: 'T1PosNet', value: insertVal.T1PosNet },
                { str_colName: 'T2NegNet', value: insertVal.T2NegNet }, { str_colName: 'T2PosNet', value: insertVal.T2PosNet },
                { str_colName: 'CubicleType', value: insertVal.CubicleType }, { str_colName: 'ReportType', value: insertVal.ReportType },
                { str_colName: 'MachineCode', value: insertVal.MachineCode }, { str_colName: 'MFGCode', value: insertVal.MFGCode },
                { str_colName: 'BatchSize', value: insertVal.BatchSize }, { str_colName: 'FriabilityID', value: insertVal.FriabilityID },
                { str_colName: 'HardnessID', value: insertVal.HardnessID }, { str_colName: 'CubicleName', value: insertVal.CubicleName },
                { str_colName: 'CubicleLocation', value: insertVal.CubicleLocation },
                { str_colName: 'RepoLabel10', value: insertVal.RepoLabel10 }, { str_colName: 'RepoLabel11', value: insertVal.RepoLabel11 },
                { str_colName: 'RepoLabel12', value: insertVal.RepoLabel12 }, { str_colName: 'RepoLabel13', value: insertVal.RepoLabel13 },
                { str_colName: 'PrintNo', value: insertVal.PrintNo }, { str_colName: 'IsArchived', value: insertVal.IsArchived },
                { str_colName: 'GraphType', value: insertVal.GraphType }, { str_colName: 'BatchComplete', value: insertVal.BatchComplete },
                { str_colName: 'PVersion', value: insertVal.PVersion }, { str_colName: 'Version', value: insertVal.Version },
                { str_colName: 'CheckedByID', value: insertVal.CheckedByID }, { str_colName: 'CheckedByName', value: insertVal.CheckedByName },
                { str_colName: 'CheckedByDate', value: insertVal.CheckedByDate }, { str_colName: 'BRepSerNo', value: insertVal.BRepSerNo },
                { str_colName: 'HMI_ID', value: ip.split('.')[3] },{ str_colName: 'TestType', value: 'Sealed Cartridge' }
            ]
        }
        var res = await database.save(insertTempObj);

        // var selectDetailObj = {
        //     str_tableName: detailTableName,
        //     data: '*',
        //     condition: [
        //         { str_colName: 'RepSerNo', value: RepSerNo }
        //     ]
        // }
        var selectDetailObj  = `SELECT RepSerNo, MstSerNo, RecSeqNo, ROUND(DataValue,3) AS DataValue, Remark, BatchNo, BFGCode, UserID, 
        UserName, PrDate, PrTime, Side, DecimalPoint, PVersion, Version, Gavg FROM ${detailTableName} WHERE RepSerNo = ${RepSerNo}`;
        var detailData = await dbCon.execute(selectDetailObj);
        for (const v of detailData[0]) {
            var insertDetail = {
                str_tableName: 'tbl_temp_detail8',
                data: [
                    { str_colName: 'RepSerNo', value: v.RepSerNo },
                    { str_colName: 'MstSerNo', value: v.MstSerNo },
                    { str_colName: 'RecSeqNo', value: v.RecSeqNo },
                    { str_colName: 'DataValue', value: v.DataValue },
                    { str_colName: 'BatchNo', value: v.BatchNo },
                    { str_colName: 'BFGCode', value: v.BFGCode },
                    { str_colName: 'UserID', value: v.UserID },
                    { str_colName: 'UserName', value: v.UserName },
                    { str_colName: 'PrDate', value: v.PrDate },
                    { str_colName: 'PrTime', value: v.PrTime },
                    { str_colName: 'Side', value: v.Side },
                    { str_colName: 'DecimalPoint', value: v.DecimalPoint },
                    { str_colName: 'PVersion', value: v.PVersion },
                    { str_colName: 'Version', value: v.Version },
                    { str_colName: 'HMI_ID', value: ip.split('.')[3] },
                    { str_colName: 'Gavg', value: v.Gavg },
                    { str_colName: 'TestResult', value: v.Remark }
                ]
            }
            
            var result = await database.save(insertDetail);
        }

        return true;
    } catch (error) {
        return error
    }
}

async calculationGroup(insertVal, RepSerNo, ip, value, reportType, printNo){
    try{
        const objData = {};
        var result = await objStoredProcedure.getCalculationForGrpMultihaler(insertVal, RepSerNo, ip, value,reportType); 
        Object.assign(objData, { RepSerNo: RepSerNo },{ Average: result[1][0]['@average'] }, { UserId: value.userId }, { UserName: value.username }, { StandardDeviation: result[1][0]['@standardDeviation'] },
        { StdLowerActual : result[1][0]['@lowerLimitActual'] }, { StdUpperActual : result[1][0]['@upperLimitActual'] }, { StdLowerPercentage : result[1][0]['@lowerLimitPercentage'] }, { StdUpperPercentage : result[1][0]['@upperLimitPercentage'] }, { MinimumWeight : result[1][0]['@minWeight']}, { MaximumWeight : result[1][0]['@maxWeight']}, { StdWeight : result[1][0]['@nominal']}, { MinimumPercentage
            : result[1][0]['@minPercentage'] }, { MaximumPercentage : result[1][0]['@maxPercentage'] },{ HmiId: ip.split('.')[3] }, 
            { AboveLimitCount: result[1][0]['@aboveLimitCount'] }, { BelowLimitCount: result[1][0]['@belowLimitCount'] }, { Remark: result[1][0]['@result']},
        { waterMark: true },{str_verifyByVal:value.str_verifyByVal},{printNo:printNo});
        return objData;
    }catch(error){
        return error;
    }
    
}

async increasePrintCountMultihaler(value){
try{
    var responseObj = {};
    var strMasterTableName,strPrintTableName;
    var reciveObj =this.commanFunctionForFindingOutTableName(value.reportOption, value.reportType, value.recordFrom);
    strMasterTableName = reciveObj.masterTableName;
    strPrintTableName = reciveObj.strPrintTableName;
    const objTableUpdate = {
        str_tableName: strMasterTableName,
        data: [
            { str_colName: 'PrintNo', value: value.intPrintCount }
        ],
        condition: [
            { str_colName: 'RepSerNo', value: value.RepSrNo }
        ]
    }
    var result = await database.update(objTableUpdate);
    var now = new Date();
    const objAuditEntry = {
        str_tableName: strPrintTableName,
        data: [
            { str_colName: 'RepSrNo', value: value.RepSrNo },
            { str_colName: 'PrintNo', value: value.intPrintCount },
            { str_colName: 'Reason', value: value.strReason },
            { str_colName: 'Title', value: value.reportOption },
            { str_colName: 'UserID', value: value.strUserId },
            { str_colName: 'UserName', value: value.strUserName },
            { str_colName: 'Print_Dt', value: date.format(now, 'YYYY-MM-DD') },
            { str_colName: 'Print_Tm', value: date.format(now, 'HH:mm:ss') },
            { str_colName: 'IsIncomplete', value: value.reportType == "Complete" ? 1 : 0 },

        ]
    }
    var result1 = await database.save(objAuditEntry);
    const objActivityLog = {
        str_tableName: "tbl_activity_log",
        data: [
            { str_colName: "dt", value: date.format(now, 'YYYY-MM-DD') },
            { str_colName: "tm", value: date.format(now, 'HH:mm:ss') },
            { str_colName: "userid", value: value.strUserId },
            { str_colName: "username", value: value.strUserName },
            { str_colName: "activity", value: value.reportOption + ' Report Printed' },
        ]
    }
    var result2 = await database.save(objActivityLog);
    Object.assign(responseObj, { status: 'success' });
    return responseObj;
} catch(error){
    return(error);
}
}

async checkMultihalerReportIsVerified(value){
    try{
        var responseObj = {};
        const TableName = this.commanFunctionForFindingOutTableName(value.reportOption,
            value.reportType, value.reportFrom);
           //console.log("Select CheckedByID from " + TableName.masterTableName + " where RepSerNo=" + value.intReportSerNo);
        var res = await dbCon.execute("Select CheckedByID from " + TableName.masterTableName + " where RepSerNo=" + value.intReportSerNo);
        if(res[0].length > 0){
            Object.assign(responseObj, { result: res[0][0].CheckedByID })
            return responseObj;
        }
        else{
            Object.assign(responseObj, { result: res[0][0].CheckedByID })
            return responseObj;
        }
            
        
    } catch(error){
        return error;
    }
    
}

async verifyMultihalerReport(value){
    try{
        const TableName = this.commanFunctionForFindingOutTableName(value.reportOption,
            value.reportType, value.recordFrom);
        var now = new Date();
        var objMultihalerUpdate = {};
        if (value.reportOption == 'Complete')
        {
            objMultihalerUpdate = {
                str_tableName: TableName.masterTableName,
                data: [
                    { str_colName: 'CheckedByID', value: value.strUserId },
                    { str_colName: 'CheckedByName', value: value.strUserName },
                    { str_colName: 'CheckedByDate', value: date.format(now, 'YYYY-MM-DD HH:mm:ss') }
                ],
                condition: [
                    { str_colName: 'RepSerNo', value: value.intReportSerNo }
                ]
            }
        }
        else
        {
            objMultihalerUpdate = {
                str_tableName: TableName.masterTableName,
                data: [
                    { str_colName: 'CheckedByID', value: value.strUserId },
                    { str_colName: 'CheckedByName', value: value.strUserName },
                    { str_colName: 'CheckedByDate', value: date.format(now, 'YYYY-MM-DD HH:mm:ss') },
                    { str_colName: 'RepoLabel13', value: value.strReason }
                ],
                condition: [
                    { str_colName: 'RepSerNo', value: value.intReportSerNo }
                ]
            }
        }
        
    var result = database.update(objMultihalerUpdate);
        
    const objActivityLog = {
        str_tableName: "tbl_activity_log",
        data: [
            { str_colName: "dt", value: date.format(now, 'YYYY-MM-DD') },
            { str_colName: "tm", value: date.format(now, 'HH:mm:ss') },
            { str_colName: "userid", value: value.strUserId },
            { str_colName: "username", value: value.strUserName },
            { str_colName: "activity", value: value.reportOption + ' Report Verified' },
        ]
    }
    var result2 = await database.save(objActivityLog);
    return true;
    } catch(error){
        return error;
    }
    
}
async printReasonMultihalerReport(value,req){
    try{
        
        var responseObj = {};
        var clientIp = requestIp.getClientIp(req);
        const TableName = this.commanFunctionForFindingOutTableName(value.reportOption,
            value.reportType, value.recordFrom);
        var printTableName = TableName.strPrintTableName;
        var selectObj = {
            str_tableName: printTableName,
            data: '*',
            condition: [
                { str_colName: 'RepSrNo', value: value.RepSrNo }
            ]
        }
       var printResult = await database.select(selectObj);
       if(printResult[0].length > 0){
            let checkObj = {
                str_tableName: 'tbl_printoutreason_weighingreport',
                data: '*',
                condition: [
                    { str_colName: 'HMIID', value: clientIp.split(':')[3].split('.')[3] }
                ]
            }
            var checkResul = await database.select(checkObj);
            if (checkResul[0].length > 0) {
                let deleteObj = {
                    str_tableName: 'tbl_printoutreason_weighingreport',
                    condition: [
                        { str_colName: 'HMIID', value: clientIp.split(':')[3].split('.')[3] }
                    ]
                }
                var delRes = await database.delete(deleteObj);
                    for (const obj of printResult[0]) {
                        let inserDataObj = {
                            str_tableName: 'tbl_printoutreason_weighingreport',
                            data: [
                                { str_colName: 'RepSrNo', value: obj.RepSrNo },
                                { str_colName: 'PrintNo', value: obj.PrintNo },
                                { str_colName: 'Reason', value: obj.Reason },
                                { str_colName: 'Title', value: obj.Title },
                                { str_colName: 'UserID', value: obj.UserID },
                                { str_colName: 'UserName', value: obj.UserName },
                                { str_colName: 'Print_Dt', value: obj.Print_Dt },
                                { str_colName: 'Print_Tm', value: obj.Print_Tm },
                                { str_colName: 'IsIncomplete', value: obj.IsIncomplete[0] },
                                { str_colName: 'HMIID', value: clientIp.split(':')[3].split('.')[3] },
                            ]
                        }
                        var result = await database.save(inserDataObj); 
                    }
                    
                    Object.assign(responseObj, { HmiId: clientIp.split(':')[3].split('.')[3] });
                    return responseObj;
            } else {
                for (const obj of printResult[0]) {
                    let inserDataObj = {
                        str_tableName: 'tbl_printoutreason_weighingreport',
                        data: [
                            { str_colName: 'RepSrNo', value: obj.RepSrNo },
                            { str_colName: 'PrintNo', value: obj.PrintNo },
                            { str_colName: 'Reason', value: obj.Reason },
                            { str_colName: 'Title', value: obj.Title },
                            { str_colName: 'UserID', value: obj.UserID },
                            { str_colName: 'UserName', value: obj.UserName },
                            { str_colName: 'Print_Dt', value: obj.Print_Dt },
                            { str_colName: 'Print_Tm', value: obj.Print_Tm },
                            { str_colName: 'IsIncomplete', value: obj.IsIncomplete[0] },
                            { str_colName: 'HMIID', value: clientIp.split(':')[3].split('.')[3] },
                        ]
                    }
                    var result = await database.save(inserDataObj); 
                }
                Object.assign(responseObj, { HmiId: clientIp.split(':')[3].split('.')[3] });
                return responseObj;
            }
       }else{
        return({ status: 'success', data: 'No record Found' });
       }
    } catch(error){
        return error;
    }
}

commanFunctionForFindingOutTableName(reportOption, reportType, recordFrom) {
    var masterTableName, detailTableName, intWeighmentSrNo, strPrintTableName;
    if((reportOption == 'Net Content') || (reportOption == 'Dry Cartridge') || (reportOption == 'Dry Powder')){
        
        intWeighmentSrNo = 7;
        strPrintTableName = "tbl_cap_print7";
        if (reportType == 'Complete') {
            if (recordFrom == 'Current') { //current Complete
                masterTableName = 'tbl_cap_master7';
                detailTableName = 'tbl_cap_detail7';
            } else {  //archive Complete
                masterTableName = 'tbl_cap_master7_archived';
                detailTableName = 'tbl_cap_detail7_archived'
            }
        } else {
            if (recordFrom == 'Current') { // current Incomplete
                masterTableName = 'tbl_cap_master7_incomplete';
                detailTableName = 'tbl_cap_detail7_incomplete'
            } else {
                // TO - DO for incomplete archive
            }
        }
    } else{
        intWeighmentSrNo = 8;
            strPrintTableName = "tbl_cap_print8";
            if (reportType == 'Complete') {
                if (recordFrom == 'Current') { //current Complete
                    masterTableName = 'tbl_cap_master8';
                    detailTableName = 'tbl_cap_detail8'
                } else {  //archive Complete
                    masterTableName = 'tbl_cap_master8_archived';
                    detailTableName = 'tbl_cap_detail8_archived'
                }
            }
    }
           
    return {
        masterTableName: masterTableName, detailTableName: detailTableName,
        intWeighmentSrNo: intWeighmentSrNo, strPrintTableName: strPrintTableName
    }
}
    

}
module.exports = MultihalerReportModel;