var IterateObject = require("iterate-object");
serverConfig = require('../global/serverConfig').developerPanelData;
const Bln_Is_HardnessNMTNLT = (serverConfig.ProductMasterConf.find(x => x.Name === 'HardnessNMTNLT').Value == 1) ? true : false;

class NewProductAuditComp {

    constructor() {

        const objResult = {};
        this.objResult = objResult;
    }

    validateIndividual(objProductNew) {
        return new Promise((resolve, reject) => {
            const objIndividual = {
                Individual: {
                    Nom: "",
                    // T1Neg: "",
                    'Lower Limit': "",
                    'Upper Limit': "",
                    // T1Pos: "",
                    T2Neg: "",
                    T2Pos: "",
                    NMT: "",
                    LimitOn: "",
                    ReportOn: "",
                    Nomenclature: "",
                    Unit: "",
                    "Quantity (Initial)":"",
                    "Quantity (Regular)":""
                }
            };

            var IsChanged = false;

            /**
             * For Individual Nom
             */

            // if (objProductNew.flt_IndStd != "" && objProductNew.flt_IndStd != null) {
            if (objProductNew.flt_IndT1Neg != "" && objProductNew.flt_IndT1Neg != null) {
                // if ((objProductNew.flt_IndStd != 99999) || (objProductNew.flt_IndStd != undefined)) {
                    // objIndividual.Individual.Nom = objProductNew.flt_IndStd != "" ? objProductNew.flt_IndStd : false;
                    objIndividual.Individual['Lower Limit'] = objProductNew.flt_IndT1Neg != "" ? objProductNew.flt_IndT1Neg : false;
                    objIndividual.Individual['Upper Limit'] = objProductNew.flt_IndT1Pos != "" ? objProductNew.flt_IndT1Pos : false;
                    objIndividual.Individual['Quantity (Initial)'] = objProductNew.int_IndQtyInitial != "" ? objProductNew.int_IndQtyInitial : false;
                    objIndividual.Individual['Quantity (Regular)'] = objProductNew.int_IndQtyRegular != "" ? objProductNew.int_IndQtyRegular : false;
                    // objIndividual.Individual.T2Neg = objProductNew.flt_IndT2Neg != "" ? objProductNew.flt_IndT2Neg : false;
                    // objIndividual.Individual.T2Pos = objProductNew.flt_IndT2Pos != "" ? objProductNew.flt_IndT2Pos : false;
                    // objIndividual.Individual.NMT = objProductNew.int_IndNMTTabCnt != "" ? objProductNew.int_IndNMTTabCnt : false;
                    // objIndividual.Individual.LimitOn = objProductNew.str_IndLimitOn != "" ? objProductNew.str_IndLimitOn : false;
                    // objIndividual.Individual.ReportOn = objProductNew.str_IndGraphOn != "" ? objProductNew.str_IndGraphOn : false;
                    // objIndividual.Individual.Nomenclature = objProductNew.str_ind_nomNomnclature != "" ? objProductNew.str_ind_nomNomnclature : false;
                    // objIndividual.Individual.Unit = objProductNew.str_indUnit != "" ? objProductNew.str_indUnit : false;

                    IsChanged = true;
                // }
            }
            else {
                IsChanged = false;
            }

            if (IsChanged == true) {
                Object.assign(this.objResult, objIndividual);
            }
            resolve(IsChanged);
        })
    }



    validateGroup(objProductNew) {
        return new Promise((resolve, reject) => {
            const objGroup = {
                Group: {
                    // Nom: "",
                    'Lower Limit': "",
                    'Upper Limit': "",
                    T2Neg: "",
                    T2Pos: "",
                    NMT: "",
                    LimitOn: "",
                    ReportOn: "",
                    "Quantity (Initial)":"",
                    "Quantity (Regular)":""
                    // Unit: ""
                }
            };

            var IsChanged = false;


            if (objProductNew.flt_GrpT1Neg != "" && objProductNew.flt_GrpT1Neg != null) {
                // if ((objProductNew.flt_GrpStd != 99999) || (objProductNew.flt_GrpStd != undefined)) {
                    // objGroup.Group.Nom = objProductNew.flt_GrpStd != "" ? objProductNew.flt_GrpStd : false;
                    objGroup.Group['Lower Limit'] = objProductNew.flt_GrpT1Neg != "" ? objProductNew.flt_GrpT1Neg : false;
                    objGroup.Group['Upper Limit'] = objProductNew.flt_GrpT1Pos != "" ? objProductNew.flt_GrpT1Pos : false;
                    objGroup.Group['Quantity (Initial)'] = objProductNew.int_GrpQtyInitial != "" ? objProductNew.int_GrpQtyInitial : false;
                    objGroup.Group['Quantity (Regular)'] = objProductNew.int_GrpQtyRegular != "" ? objProductNew.int_GrpQtyRegular : false;
                    // objGroup.Group.T2Neg = objProductNew.flt_GrpT2Neg != "" ? objProductNew.flt_GrpT2Neg : false;
                    // objGroup.Group.T2Pos = objProductNew.flt_GrpT2Pos != "" ? objProductNew.flt_GrpT2Pos : false;
                    // objGroup.Group.NMT = objProductNew.int_GrpNMTTabCnt != "" ? objProductNew.int_GrpNMTTabCnt : false;
                    // objGroup.Group.LimitOn = objProductNew.str_GrpLimitOn != "" ? objProductNew.str_GrpLimitOn : false;
                    // objGroup.Group.ReportOn = objProductNew.str_GrpGraphOn != "" ? objProductNew.str_GrpGraphOn : false;
                    // objGroup.Group.Unit = objProductNew.str_groupUnit != "" ? objProductNew.str_groupUnit : false;
                    IsChanged = true;
                // }
            }
            else {
                IsChanged = false;
            }


            if (IsChanged == true) {
                Object.assign(this.objResult, objGroup);
            }
            resolve(IsChanged);
        })
    }

    validateThickness(objProductNew) {
        return new Promise((resolve, reject) => {
            const objThickness = {
                Thickness: {
                    // Nom: "",
                    'Lower Limit': "",
                    'Upper Limit': "",
                    "Quantity (Initial)":"",
                    "Quantity (Regular)":"",
                    // T1Neg: "",
                    // T1Pos: "",
                    T2Neg: "",
                    T2Pos: "",
                    T3Neg: "",
                    T3Pos: "",
                    NMT: "",
                    // GraphOn: "",
                    // Unit: ""
                }
            };
            var IsChanged = false;

            if (objProductNew.flt_ThkT1Neg != "" && objProductNew.flt_ThkT1Neg != null) {
                // if ((objProductNew.flt_ThkStd != 99999) || (objProductNew.flt_ThkStd != undefined)) {
                    // objThickness.Thickness.Nom = objProductNew.flt_ThkStd != "" ? objProductNew.flt_ThkStd : false;
                    objThickness.Thickness['Lower Limit'] = objProductNew.flt_ThkT1Neg != "" ? objProductNew.flt_ThkT1Neg : false;
                    objThickness.Thickness['Upper Limit'] = objProductNew.flt_ThkT1Pos != "" ? objProductNew.flt_ThkT1Pos : false;
                    objThickness.Thickness['Quantity (Initial)'] = objProductNew.int_ThkQtyInitial != "" ? objProductNew.int_ThkQtyInitial : false;
                    objThickness.Thickness['Quantity (Regular)'] = objProductNew.int_ThkQtyRegular != "" ? objProductNew.int_ThkQtyRegular : false;
                    // objThickness.Thickness.T2Neg = objProductNew.flt_ThkT2Neg != "" ? objProductNew.flt_ThkT2Neg : false;
                    // objThickness.Thickness.T2Pos = objProductNew.flt_ThkT2Pos != "" ? objProductNew.flt_ThkT2Pos : false;
                    // objThickness.Thickness.T3Neg = objProductNew.flt_ThkT3Neg != "" ? objProductNew.flt_ThkT3Neg : false;
                    // objThickness.Thickness.T3Pos = objProductNew.flt_ThkT3Pos != "" ? objProductNew.flt_ThkT3Pos : false;
                    // objThickness.Thickness.NMT = objProductNew.int_ThkNMTTabCnt != "" ? objProductNew.int_ThkNMTTabCnt : false;
                    // objThickness.Thickness.Unit = objProductNew.str_verUnit != "" ? objProductNew.str_verUnit : false;
                    // objThickness.Thickness.GraphOn = objProductNew.str_ThkGraphOn;

                    IsChanged = true;
                // }
            }
            else {
                IsChanged = false;
            }

            if (IsChanged == true) {
                Object.assign(this.objResult, objThickness);
            }

            resolve(IsChanged);
        })
    }

    validateBreadth(objProductNew) {
        return new Promise((resolve, reject) => {
            const objBreadth = {
                Breadth: {
                    // Nom: "",
                    // T1Neg: "",
                    // T1Pos: "",
                    'Lower Limit': "",
                    'Upper Limit': "",
                    "Quantity (Initial)":"",
                    "Quantity (Regular)":"",
                    T2Neg: "",
                    T2Pos: "",
                    NMT: "",
                   // GraphOn: "",
                    Unit: ""
                }
            };
            var IsChanged = false;

            if (objProductNew.flt_BrdT1Neg != "" && objProductNew.flt_BrdT1Neg != null) {
                // objBreadth.Breadth.Nom = objProductNew.flt_BrdStd != "" ? objProductNew.flt_BrdStd : false;
                objBreadth.Breadth['Lower Limit'] = objProductNew.flt_BrdT1Neg != "" ? objProductNew.flt_BrdT1Neg : false;
                objBreadth.Breadth['Upper Limit'] = objProductNew.flt_BrdT1Pos != "" ? objProductNew.flt_BrdT1Pos : false;
                objBreadth.Breadth['Quantity (Initial)'] = objProductNew.int_BrdQtyInitial != "" ? objProductNew.int_BrdQtyInitial : false;
                objBreadth.Breadth['Quantity (Regular)'] = objProductNew.int_BrdQtyRegular != "" ? objProductNew.int_BrdQtyRegular : false;
                // objBreadth.Breadth.T2Neg = objProductNew.flt_BrdT2Neg != "" ? objProductNew.flt_BrdT2Neg : false;
                // objBreadth.Breadth.T2Pos = objProductNew.flt_BrdT2Pos != "" ? objProductNew.flt_BrdT2Pos : false;
                // objBreadth.Breadth.NMT = objProductNew.int_BrdNMTTabCnt != "" ? objProductNew.int_BrdNMTTabCnt : false;
                // objBreadth.Breadth.Unit = objProductNew.str_verUnit != "" ? objProductNew.str_verUnit : false;
                //objBreadth.Breadth.GraphOn = objProductNew.str_BrdGraphOn;

                IsChanged = true;
            }
            else {
                IsChanged = false;
            }

            if (IsChanged == true) {
                Object.assign(this.objResult, objBreadth);
            }

            resolve(IsChanged);
        })
    }

    validateLength(objProductNew) { 
        return new Promise((resolve, reject) => {
            const objLength = {
                Length: {
                    // Nom: "",
                    // T1Neg: "",
                    // T1Pos: "",
                    'Lower Limit': "",
                    'Upper Limit': "",
                    "Quantity (Initial)":"",
                    "Quantity (Regular)":"",
                    // T2Neg: "",
                    // T2Pos: "",
                    // T3Neg: "",
                    // T3Pos: "",
                    NMT: "",
                    // GraphOn: "",
                    // Unit: ""
                }
            };

            var IsChanged = false;

             if (objProductNew.flt_LenT1Neg != "" && objProductNew.flt_LenT1Neg != null) {
                    // objLength.Length.Nom = objProductNew.flt_LenStd != "" ? objProductNew.flt_LenStd : false;
                    objLength.Length['Lower Limit'] = objProductNew.flt_LenT1Neg != "" ? objProductNew.flt_LenT1Neg : false;
                    objLength.Length['Upper Limit'] = objProductNew.flt_LenT1Pos != "" ? objProductNew.flt_LenT1Pos : false;
                    objLength.Length['Quantity (Initial)'] = objProductNew.int_LenQtyInitial != "" ? objProductNew.int_LenQtyInitial : false;
                    objLength.Length['Quantity (Regular)'] = objProductNew.int_LenQtyRegular != "" ? objProductNew.int_LenQtyRegular : false;
                    // objLength.Length.T2Neg = objProductNew.flt_LenT2Neg != "" ? objProductNew.flt_LenT2Neg : false;
                    // objLength.Length.T2Pos = objProductNew.flt_LenT2Pos != "" ? objProductNew.flt_LenT2Pos : false;
                    // objLength.Length.T3Neg = objProductNew.flt_LenT3Neg != "" ? objProductNew.flt_LenT3Neg : false;
                    // objLength.Length.T3Pos = objProductNew.flt_LenT3Pos != "" ? objProductNew.flt_LenT3Pos : false;
                    // objLength.Length.NMT = objProductNew.int_LenNMTTabCnt != "" ? objProductNew.int_LenNMTTabCnt : false;
                    // objLength.Length.Unit = objProductNew.str_verUnit != "" ? objProductNew.str_verUnit : false;
                    //objLength.Length.GraphOn = objProductNew.str_LenGraphOn;

                    IsChanged = true;
             }
            else {
                IsChanged = false;
            }

            if (IsChanged == true) {
                Object.assign(this.objResult, objLength);
            }

            resolve(IsChanged);
        })
    }

    validateLengthCap(objProductNew) { 
        return new Promise((resolve, reject) => {
            const objLength = {
                Length: {
                    Nom: "",
                    T1Neg: "",
                    T1Pos: "",
                    T2Neg: "",
                    T2Pos: "",
                    NMT: "",
                  //  GraphOn: "",
                    Unit: ""
                }
            };

            var IsChanged = false;

             if (objProductNew.flt_LenT1Neg != "" && objProductNew.flt_LenT1Neg != null) {
                if ((objProductNew.flt_LenT1Neg != 99999) || (objProductNew.flt_LenT1Neg != undefined)) {
                    // objLength.Length.Nom = objProductNew.flt_LenStd != "" ? objProductNew.flt_LenStd : false;
                    objLength.Length.T1Neg = objProductNew.flt_LenT1Neg != "" ? objProductNew.flt_LenT1Neg : false;
                    objLength.Length.T1Pos = objProductNew.flt_LenT1Pos != "" ? objProductNew.flt_LenT1Pos : false;
                    // objLength.Length.T2Neg = objProductNew.flt_LenT2Neg != "" ? objProductNew.flt_LenT2Neg : false;
                    // objLength.Length.T2Pos = objProductNew.flt_LenT2Pos != "" ? objProductNew.flt_LenT2Pos : false;
                    // objLength.Length.NMT = objProductNew.int_LenNMTTabCnt != "" ? objProductNew.int_LenNMTTabCnt : false;
                    // objLength.Length.Unit = objProductNew.str_verUnit != "" ? objProductNew.str_verUnit : false;
                    //objLength.Length.GraphOn = objProductNew.str_LenGraphOn;

                    IsChanged = true;
                }
             }
            else {
                IsChanged = false;
            }

            if (IsChanged == true) {
                Object.assign(this.objResult, objLength);
            }

            resolve(IsChanged);
        })
    }

    validateDiameter(objProductNew) {
        return new Promise((resolve, reject) => {
            const objDiameter = {
                Diameter: {
                    // Nom: "",
                    'Lower Limit': "",
                    'Upper Limit': "",
                    "Quantity (Initial)":"",
                    "Quantity (Regular)":"",
                    // T1Neg: "",
                    // T1Pos: "",
                    // T2Neg: "",
                    // T2Pos: "",
                    // T3Neg: "",
                    // T3Pos: "",
                    // NMT: "",
                    // GraphOn: "",
                    // Unit: ""
                }
            };
            var IsChanged = false;

            if (objProductNew.flt_DiaT1Neg != "" && objProductNew.flt_DiaT1Neg != null) {
                // objDiameter.Diameter.Nom = objProductNew.flt_DiaStd != "" ? objProductNew.flt_DiaStd : false;
                objDiameter.Diameter['Lower Limit'] = objProductNew.flt_DiaT1Neg != "" ? objProductNew.flt_DiaT1Neg : false;
                objDiameter.Diameter['Upper Limit'] = objProductNew.flt_DiaT1Pos != "" ? objProductNew.flt_DiaT1Pos : false;
                objDiameter.Diameter['Quantity (Initial)'] = objProductNew.int_DiaQtyInitial != "" ? objProductNew.int_DiaQtyInitial : false;
                objDiameter.Diameter['Quantity (Regular)'] = objProductNew.int_DiaQtyRegular != "" ? objProductNew.int_DiaQtyRegular : false;
                // objDiameter.Diameter.T2Neg = objProductNew.flt_DiaT2Neg != "" ? objProductNew.flt_DiaT2Neg : false;
                // objDiameter.Diameter.T2Pos = objProductNew.flt_DiaT2Pos != "" ? objProductNew.flt_DiaT2Pos : false;
                // objDiameter.Diameter.T3Neg = objProductNew.flt_DiaT3Neg != "" ? objProductNew.flt_DiaT3Neg : false;
                // objDiameter.Diameter.T3Pos = objProductNew.flt_DiaT3Pos != "" ? objProductNew.flt_DiaT3Pos : false;
                // objDiameter.Diameter.NMT = objProductNew.int_DiaNMTTabCnt != "" ? objProductNew.int_DiaNMTTabCnt : false;
                // objDiameter.Diameter.Unit = objProductNew.str_verUnit != "" ? objProductNew.str_verUnit : false;
                //objDiameter.Diameter.GraphOn = objProductNew.str_DiaGraphOn;

                IsChanged = true;
            }
            else {
                IsChanged = false;
            }

            if (IsChanged == true) {
                Object.assign(this.objResult, objDiameter);
            }
            resolve(IsChanged);
        })
    }

    validateHardness(objProductNew) {
        return new Promise((resolve, reject) => {
            let str_Tol_1_Neg = (Bln_Is_HardnessNMTNLT == true) ? "NLT" : "T1Neg";
            let str_Tol_1_Pos = (Bln_Is_HardnessNMTNLT == true) ? "NMT" : "T1Pos";
            const objHardness = {
                Hardness: {
                    // Nom: "",
                    // [str_Tol_1_Neg]: "",
                    // [str_Tol_1_Pos]: "",
                    'Lower Limit': "",
                    'Upper Limit': "",
                    "Quantity (Initial)":"",
                    "Quantity (Regular)":"",
                    T2Neg: "",
                    T2Pos: "",
                    T3Neg: "",
                    T3Pos: "",
                    // HrdUnit: "",
                    ReportOn: ""
                }
            };
            var IsChanged = false;

            if ((objProductNew.flt_HrdStd != "" && objProductNew.flt_HrdStd != null) || 
                (objProductNew.flt_HrdT1 != "" && objProductNew.flt_HrdT1 != null) ||
                (objProductNew.flt_HrdT2 != "" && objProductNew.flt_HrdT2 != null)
            ) {
                if ((objProductNew.flt_HrdStd != 99999) || (objProductNew.flt_HrdStd != undefined) ||
                    (objProductNew.flt_HrdT1 != 99999) || (objProductNew.flt_HrdT1 != undefined) ||
                    (objProductNew.flt_HrdT2 != 99999) || (objProductNew.flt_HrdT2 != undefined)
                ) {
                    // objHardness.Hardness.Nom = objProductNew.flt_HrdStd != "" ? objProductNew.flt_HrdStd : false;
                    objHardness.Hardness['Lower Limit'] = objProductNew.flt_HrdT1 != "" ? objProductNew.flt_HrdT1 : false;
                    objHardness.Hardness['Upper Limit'] = objProductNew.flt_HrdT2 != "" ? objProductNew.flt_HrdT2 : false;
                    objHardness.Hardness['Quantity (Initial)'] = objProductNew.int_HrdQtyInitial != "" ? objProductNew.int_HrdQtyInitial : false;
                    objHardness.Hardness['Quantity (Regular)'] = objProductNew.int_HrdQtyRegular != "" ? objProductNew.int_HrdQtyRegular : false;
                    // objHardness.Hardness.T2Neg = objProductNew.flt_HrdT1_2 != "" ? objProductNew.flt_HrdT1_2 : false;
                    // objHardness.Hardness.T2Pos = objProductNew.flt_HrdT2_2 != "" ? objProductNew.flt_HrdT2_2 : false;
                    // objHardness.Hardness.T3Neg = objProductNew.flt_HrdT1_3 != "" ? objProductNew.flt_HrdT1_3 : false;
                    // objHardness.Hardness.T3Pos = objProductNew.flt_HrdT2_3 != "" ? objProductNew.flt_HrdT2_3 : false;
                    // objHardness.Hardness.HrdUnit = objProductNew.str_HrdUnit != "" ? objProductNew.str_HrdUnit : false;
                    // objHardness.Hardness.ReportOn = objProductNew.str_HrdGraphOn != "" ? objProductNew.str_HrdGraphOn : false;

                    IsChanged = true;
                }
            }
            else {
                IsChanged = false;
            }

            if (IsChanged == true) {
                Object.assign(this.objResult, objHardness);
            }
            resolve(IsChanged);
        })
    }

    validateFriability(objProductNew) {
        return new Promise((resolve, reject) => {
            const objFriability = {
                Friability: {
                    // FriNMT: "",
                    'Lower Limit': "",
                    'Upper Limit': "",
                    FriSetCnt: "",
                    FriSetRPM: "",
                }
            };
            var IsChanged = false;

            if (objProductNew.flt_FriT1Neg != "" && objProductNew.flt_FriT1Neg != null) {
                // if ((objProductNew.flt_FriNMT != 99999) || (objProductNew.flt_FriNMT != undefined)) {
                    // objFriability.Friability.FriNMT = objProductNew.flt_FriNMT != "" ? objProductNew.flt_FriNMT : false;
                    objFriability.Friability['Lower Limit'] = objProductNew.flt_FriT1Neg != "" ? objProductNew.flt_FriT1Neg : false;
                    objFriability.Friability['Upper Limit'] = objProductNew.flt_FriT1Pos != "" ? objProductNew.flt_FriT1Pos : false;
                    objFriability.Friability.FriSetCnt = objProductNew.int_FriSetCnt != "" ? objProductNew.int_FriSetCnt : false;
                    objFriability.Friability.FriSetRPM = objProductNew.int_FriSetRPM != "" ? objProductNew.int_FriSetRPM : false;

                    IsChanged = true;
                // }
            }
            else {
                IsChanged = false;
            }

            if (IsChanged == true) {
                Object.assign(this.objResult, objFriability);
            }
            resolve(IsChanged);
        })
    }

    validateIndLayer1(objProductNew) {
        return new Promise((resolve, reject) => {
            var objIndividualL1 = {
                IndividualL1: {
                    Nom: "",
                    T1Neg: "",
                    T1Pos: "",
                    T2Neg: "",
                    T2Pos: "",
                    NMT: "",
                    LimitOn: "",
                    GraphOn: "",
                    Nomenclature: "",
                    Unit: ""
                }
            };

            var IsChanged = false;

            if (objProductNew.flt_IndL1Std != "" && objProductNew.flt_IndL1Std != null) {
                if ((objProductNew.flt_IndL1Std != 99999) || (objProductNew.flt_IndL1Std != undefined)) {
                    objIndividualL1.IndividualL1.Nom = objProductNew.flt_IndL1Std != "" ? objProductNew.flt_IndL1Std : false;
                    objIndividualL1.IndividualL1.T1Neg = objProductNew.flt_IndL1T1Neg != "" ? objProductNew.flt_IndL1T1Neg : false;
                    objIndividualL1.IndividualL1.T1Pos = objProductNew.flt_IndL1T1Pos != "" ? objProductNew.flt_IndL1T1Pos : false;
                    objIndividualL1.IndividualL1.T2Neg = objProductNew.flt_IndL1T2Neg != "" ? objProductNew.flt_IndL1T2Neg : false;
                    objIndividualL1.IndividualL1.T2Pos = objProductNew.flt_IndL1T2Pos != "" ? objProductNew.flt_IndL1T2Pos : false;
                    objIndividualL1.IndividualL1.NMT = objProductNew.int_IndL1NMTTabCount != "" ? objProductNew.int_IndL1NMTTabCount : false;
                    objIndividualL1.IndividualL1.LimitOn = objProductNew.str_IndL1LimitOn != "" ? objProductNew.str_IndL1LimitOn : false;
                    objIndividualL1.IndividualL1.ReportOn = objProductNew.str_IndL1GraphOn != "" ? objProductNew.str_IndL1GraphOn : false;
                    objIndividualL1.IndividualL1.Nomenclature = objProductNew.str_indL1_nomNomnclature != "" ? objProductNew.str_indL1_nomNomnclature : false;
                    objIndividualL1.IndividualL1.Unit = objProductNew.str_indUnit != "" ? objProductNew.str_indUnit : false;
                    IsChanged = true;
                }
            }
            else {
                IsChanged = false;
            }
            
            if (IsChanged == true) {
                Object.assign(this.objResult, objIndividualL1);
            }
            resolve(IsChanged);
        })
    }

    validateGrpLayer1(objProductNew) {
        return new Promise((resolve, reject) => {
            const objGroupL1 = {
                GroupL1: {
                    Nom: "",
                    T1Neg: "",
                    T1Pos: "",
                    T2Neg: "",
                    T2Pos: "",
                    NMT: "",
                    LimitOn: "",
                    ReportOn: "",
                    Unit: ""
                }
            };
            var IsChanged = false;

            if (objProductNew.flt_GrpL1Std != "" && objProductNew.flt_GrpL1Std != null) {
                if ((objProductNew.flt_GrpL1Std != 99999) || (objProductNew.flt_GrpL1Std != undefined)) {
                    objGroupL1.GroupL1.Nom = objProductNew.flt_GrpL1Std != "" ? objProductNew.flt_GrpL1Std : false;
                    objGroupL1.GroupL1.T1Neg = objProductNew.flt_GrpL1T1Neg != "" ? objProductNew.flt_GrpL1T1Neg : false;
                    objGroupL1.GroupL1.T1Pos = objProductNew.flt_GrpL1T1Pos != "" ? objProductNew.flt_GrpL1T1Pos : false;
                    objGroupL1.GroupL1.T2Neg = objProductNew.flt_GrpL1T2Neg != "" ? objProductNew.flt_GrpL1T2Neg : false;
                    objGroupL1.GroupL1.T2Pos = objProductNew.flt_GrpL1T2Pos != "" ? objProductNew.flt_GrpL1T2Pos : false;
                    objGroupL1.GroupL1.NMT = objProductNew.int_GrpL1NMTTabCount != "" ? objProductNew.int_GrpL1NMTTabCount : false;
                    objGroupL1.GroupL1.LimitOn = objProductNew.str_IndL1LimitOn != "" ? objProductNew.str_IndL1LimitOn : false;
                    objGroupL1.GroupL1.ReportOn = objProductNew.str_GrpL1GraphOn != "" ? objProductNew.str_GrpL1GraphOn : false;
                    objGroupL1.GroupL1.Unit = objProductNew.str_groupUnit != "" ? objProductNew.str_groupUnit : false;

                    IsChanged = true;
                }
            }
            else {
                IsChanged = false;
            }
            if (IsChanged == true) {
                Object.assign(this.objResult, objGroupL1);
            }

            resolve(IsChanged);
        })
    }

    validateIndLayer2(objProductNew) {
        return new Promise((resolve, reject) => {
            const objIndividualL2 = {
                IndividualL2: {
                    Nom: "",
                    T1Neg: "",
                    T1Pos: "",
                    T2Neg: "",
                    T2Pos: "",
                    NMT: "",
                    LimitOn: "",
                    ReportOn: "",
                    Nomenclature: "",
                    Unit:""
                }
            };

            var IsChanged = false;

            if (objProductNew.flt_IndL2Std != "" && objProductNew.flt_IndL2Std != null) {
                if ((objProductNew.flt_IndL2Std != 99999) || (objProductNew.flt_IndL2Std != undefined)) {
                    objIndividualL2.IndividualL2.Nom = objProductNew.flt_IndL2Std != "" ? objProductNew.flt_IndL2Std : false;
                    objIndividualL2.IndividualL2.T1Neg = objProductNew.flt_IndL2T1Neg != "" ? objProductNew.flt_IndL2T1Neg : false;
                    objIndividualL2.IndividualL2.T1Pos = objProductNew.flt_IndL2T1Pos != "" ? objProductNew.flt_IndL2T1Pos : false;
                    objIndividualL2.IndividualL2.T2Neg = objProductNew.flt_IndL2T2Neg != "" ? objProductNew.flt_IndL2T2Neg : false;
                    objIndividualL2.IndividualL2.T2Pos = objProductNew.flt_IndL2T2Pos != "" ? objProductNew.flt_IndL2T2Pos : false;
                    objIndividualL2.IndividualL2.NMT = objProductNew.int_IndL2NMTTabCount != "" ? objProductNew.int_IndL2NMTTabCount : false;
                    objIndividualL2.IndividualL2.LimitOn = objProductNew.str_IndL2LimitOn != "" ? objProductNew.str_IndL2LimitOn : false;
                    objIndividualL2.IndividualL2.ReportOn = objProductNew.str_IndL2GraphOn != "" ? objProductNew.str_IndL2GraphOn : false;
                    objIndividualL2.IndividualL2.Nomenclature = objProductNew.str_indL2_nomNomnclature != "" ? objProductNew.str_indL2_nomNomnclature : false;
                    objIndividualL2.IndividualL2.Unit = objProductNew.str_indUnit != "" ? objProductNew.str_indUnit : false;
                    IsChanged = true;
                }
            }
            else {
                IsChanged = false;
            }
            if (IsChanged == true) {
                Object.assign(this.objResult, objIndividualL2);
            }
            resolve(IsChanged);
        })
    }

    validateGrpLayer2(objProductNew) {
        return new Promise((resolve, reject) => {
            const objGroupL2 = {
                GroupL2: {
                    Nom: "",
                    T1Neg: "",
                    T1Pos: "",
                    T2Neg: "",
                    T2Pos: "",
                    NMT: "",
                    LimitOn: "",
                    ReportOn: "",
                    Unit:""
                }
            };

            var IsChanged = false;

            if (objProductNew.flt_GrpL2Std != "" && objProductNew.flt_GrpL2Std != null) {
                if ((objProductNew.flt_GrpL2Std != 99999) || (objProductNew.flt_GrpL2Std != undefined)) {
                    objGroupL2.GroupL2.Nom = objProductNew.flt_GrpL2Std != "" ? objProductNew.flt_GrpL2Std : false;
                    objGroupL2.GroupL2.T1Neg = objProductNew.flt_GrpL2T1Neg != "" ? objProductNew.flt_GrpL2T1Neg : false;
                    objGroupL2.GroupL2.T1Pos = objProductNew.flt_GrpL2T1Pos != "" ? objProductNew.flt_GrpL2T1Pos : false;
                    objGroupL2.GroupL2.T2Neg = objProductNew.flt_GrpL2T2Neg != "" ? objProductNew.flt_GrpL2T2Neg : false;
                    objGroupL2.GroupL2.T2Pos = objProductNew.flt_GrpL2T2Pos != "" ? objProductNew.flt_GrpL2T2Pos : false;
                    objGroupL2.GroupL2.NMT = objProductNew.int_GrpL2NMTTabCount != "" ? objProductNew.int_GrpL2NMTTabCount : false;
                    objGroupL2.GroupL2.LimitOn = objProductNew.str_GrpL2LimitOn != "" ? objProductNew.str_GrpL2LimitOn : false;
                    objGroupL2.GroupL2.ReportOn = objProductNew.str_GrpL2GraphOn != "" ? objProductNew.str_GrpL2GraphOn : false;
                    objGroupL2.GroupL2.Unit = objProductNew.str_groupUnit != "" ? objProductNew.str_groupUnit : false;

                    IsChanged = true;
                }
            }
            else {
                IsChanged = false;
            }

            if (IsChanged == true) {
                Object.assign(this.objResult, objGroupL2);
            }
            resolve(IsChanged);
        })
    }

    validateDT(objProductNew) {
        return new Promise((resolve, reject) => {
            const objDT = {
                DT: {
                    DTTime: "",
                    // 'Lower Limit': "",
                    // 'Upper Limit': "",
                    DTMinTemp: "",
                    DTMaxTemp: ""
                }
            };
            var IsChanged = false;
            if (objProductNew.flt_DTMinTemp != "" && objProductNew.flt_DTMinTemp != null) {
                // if ((objProductNew.int_DTSSTime != 99999) || (objProductNew.int_DTSSTime != undefined)) {
                    // objDT.DT.DTTime = objProductNew.int_DTSSTime != "" ? objProductNew.int_DTSSTime : false;
                    objDT.DT.DTMinTemp = objProductNew.flt_DTMinTemp != "" ? objProductNew.flt_DTMinTemp : false;
                    objDT.DT.DTMaxTemp = objProductNew.flt_DTMaxTemp != "" ? objProductNew.flt_DTMaxTemp : false;
                    // objDT.DT['Lower Limit'] = objProductNew.flt_DTMinTemp != "" ? objProductNew.flt_DTMinTemp : false;
                    // objDT.DT['Upper Limit'] = objProductNew.flt_DTMaxTemp != "" ? objProductNew.flt_DTMaxTemp : false;

                    // objDT.DT.DTTime = objProductNew.int_DTHHTime + ":" + objProductNew.int_DTMMTime + ":" + objProductNew.int_DTSSTime;
                    IsChanged = true;
                // }
            }
            else {
                IsChanged = false;
            }
            if (IsChanged == true) {
                Object.assign(this.objResult, objDT);
            }
            resolve(IsChanged);
        })
    }

    validateDT_Lay_1(objProductNew) {
        return new Promise((resolve, reject) => {
            const objDT_Lay_1 = {
                DT_Lay_1: {
                    DTTime: "",
                    DTMinTemp: "",
                    DTMaxTemp: ""
                }
            };
            var IsChanged = false;
            if (objProductNew.int_DTSSTime_Lay_1 != "" && objProductNew.int_DTSSTime_Lay_1 != null) {
                if ((objProductNew.int_DTSSTime_Lay_1 != 99999) || (objProductNew.int_DTSSTime_Lay_1 != undefined)) {
                    objDT_Lay_1.DT_Lay_1.DTTime = objProductNew.int_DTSSTime_Lay_1 != "" ? objProductNew.int_DTSSTime_Lay_1 : false;
                    objDT_Lay_1.DT_Lay_1.DTMinTemp = objProductNew.flt_DTMinTemp_Lay_1 != "" ? objProductNew.flt_DTMinTemp_Lay_1 : false;
                    objDT_Lay_1.DT_Lay_1.DTMaxTemp = objProductNew.flt_DTMaxTemp_Lay_1 != "" ? objProductNew.flt_DTMaxTemp_Lay_1 : false;

                    objDT_Lay_1.DT_Lay_1.DTTime = objProductNew.int_DTHHTime_Lay_1 + ":" + objProductNew.int_DTMMTime_Lay_1 + ":" + objProductNew.int_DTSSTime_Lay_1;
                    IsChanged = true;
                }
            }
            else {
                IsChanged = false;
            }
            if (IsChanged == true) {
                Object.assign(this.objResult, objDT_Lay_1);
            }
            resolve(IsChanged);
        });
    }

    validateDT_Lay_2(objProductNew) {
        return new Promise((resolve, reject) => {
            const objDT_Lay_2 = {
                DT_Lay_2: {
                    DTTime: "",
                    DTMinTemp: "",
                    DTMaxTemp: ""
                }
            };
            var IsChanged = false;
            if (objProductNew.int_DTSSTime_Lay_2 != "" && objProductNew.int_DTSSTime_Lay_2 != null) {
                if ((objProductNew.int_DTSSTime_Lay_2 != 99999) || (objProductNew.int_DTSSTime_Lay_2 != undefined)) {
                    objDT_Lay_2.DT_Lay_2.DTTime = objProductNew.int_DTSSTime_Lay_2 != "" ? objProductNew.int_DTSSTime_Lay_2 : false;
                    objDT_Lay_2.DT_Lay_2.DTMinTemp = objProductNew.flt_DTMinTemp_Lay_2 != "" ? objProductNew.flt_DTMinTemp_Lay_2 : false;
                    objDT_Lay_2.DT_Lay_2.DTMaxTemp = objProductNew.flt_DTMaxTemp_Lay_2 != "" ? objProductNew.flt_DTMaxTemp_Lay_2 : false;

                    objDT_Lay_2.DT_Lay_2.DTTime = objProductNew.int_DTHHTime_Lay_2 + ":" + objProductNew.int_DTMMTime_Lay_2 + ":" + objProductNew.int_DTSSTime_Lay_2;
                    IsChanged = true;
                }
            }
            else {
                IsChanged = false;
            }
            if (IsChanged == true) {
                Object.assign(this.objResult, objDT_Lay_2);
            }
            resolve(IsChanged);
        });
    }

    validateTD(objProductNew) {
        return new Promise((resolve, reject) => {
            const objTD = {
                TD: {
                    TDMin: "",
                    TDMax: ""
                }
            };
            var IsChanged = false;

            if (objProductNew.flt_TDT1 != "" && objProductNew.flt_TDT1 != null) {
                if ((objProductNew.flt_TDT1 != 99999) || (objProductNew.flt_TDT1 != undefined)) {
                    objTD.TD.TDMin = objProductNew.flt_TDT1 != "" ? objProductNew.flt_TDT1 : false;
                    objTD.TD.TDMax = objProductNew.flt_TDT2 != "" ? objProductNew.flt_TDT2 : false;
                    IsChanged = true;
                }
            }
            else {
                IsChanged = false;
            }
            if (IsChanged == true) {
                Object.assign(this.objResult, objTD);
            }
            resolve(IsChanged);
        })
    }

    validateLOD(objProductNew) {
        return new Promise((resolve, reject) => {
            const objLOD = {
                LOD: {
                    'Lower Limit':'',
                    'Upper Limit':'',
                    // MIN: "",
                    // MAX: ""
                }
            };
            var IsChanged = false;

            if (objProductNew.flt_MAT1 != "" && objProductNew.flt_MAT1 != null) {
                if ((objProductNew.flt_MAT1 != 99999) || (objProductNew.flt_MAT1 != undefined)) {
                    objLOD.LOD['Lower Limit'] = objProductNew.flt_MAT1 != "" ? objProductNew.flt_MAT1 : false;
                    objLOD.LOD['Upper Limit'] = objProductNew.flt_MAT2 != "" ? objProductNew.flt_MAT2 : false;
                    IsChanged = true;
                }
            }
            else {
                IsChanged = false;
            }
            if (IsChanged == true) {
                Object.assign(this.objResult, objLOD);
            }

            resolve(IsChanged);
        })

    }

    validatePerFine(objProductNew) {
        return new Promise((resolve, reject) => {
            const objPerFine = {
                PerFine: {
                    T1: "",
                    T2: ""
                }
            };
            var IsChanged = false;

            if (objProductNew.flt_SST1 != "" && objProductNew.flt_SST1 != null) {
                if ((objProductNew.flt_SST1 != 99999) || (objProductNew.flt_SST1 != undefined)) {
                    objPerFine.PerFine.T1 = objProductNew.flt_SST1 != "" ? objProductNew.flt_SST1 : false;
                    objPerFine.PerFine.T2 = objProductNew.flt_SST2 != "" ? objProductNew.flt_SST2 : false;
                    IsChanged = true;
                }
            }
            else {
                IsChanged = false;
            }
            if (IsChanged == true) {
                Object.assign(this.objResult, objPerFine);
            }
            resolve(IsChanged);
        })
    }

    validateYield(objProductNew) {
        return new Promise((resolve, reject) => {
            const objYield = {
                Yield: {
                    TheroticalYield: "",
                    YieldNLT: "",
                    TotalLossNMT: "",
                }
            };

            var IsChanged = false;

            /**
             * For Individual Nom
             */

            if (objProductNew.TheroticalYield != "" && objProductNew.TheroticalYield != null) {
                if ((objProductNew.TheroticalYield != 99999) || (objProductNew.TheroticalYield != undefined)) {
                    objYield.Yield.TheroticalYield = objProductNew.TheroticalYield != "" ? objProductNew.TheroticalYield : false;
                    //objYield.Yield.YieldNLT = objProductNew.YieldNLT != "" ? objProductNew.YieldNLT : false;
                    //objYield.Yield.TotalLossNMT = objProductNew.TotalLossNMT != "" ? objProductNew.TotalLossNMT : false;
                    IsChanged = true;
                }
            }
            else {
                IsChanged = false;
            }

            if (IsChanged == true) {
                Object.assign(this.objResult, objYield);
            }
            resolve(IsChanged);
        })


    }



    async newCompressedParams(objProductNew) {
        var Ind = await this.validateIndividual(objProductNew);
        var Grp = await this.validateGroup(objProductNew);
        var Thick = await this.validateThickness(objProductNew);
        var Brd = await this.validateBreadth(objProductNew);
        var Len = await this.validateLength(objProductNew);
        var Dia = await this.validateDiameter(objProductNew);
        var Hard = await this.validateHardness(objProductNew);
        var Fri = await this.validateFriability(objProductNew);
        var DT = await this.validateDT(objProductNew);
        var TD = await this.validateTD(objProductNew);
        var PerFine = await this.validatePerFine(objProductNew);
        var LOD = await this.validateLOD(objProductNew);
        var Ind1 = await this.validateIndLayer1(objProductNew);
        var Grp1 = await this.validateGrpLayer1(objProductNew);
        var DT_Lay_1 = await this.validateDT_Lay_1(objProductNew);
        var Ind2 = await this.validateIndLayer2(objProductNew);
        var Grp2 = await this.validateGrpLayer2(objProductNew);
        var DT_Lay_2 = await this.validateDT_Lay_2(objProductNew);


        if (Ind != true && Grp != true && Thick != true && Brd != true &&
            Len != true && Dia != true && Hard != true && Fri != true &&
            Ind1 != true && Grp1 != true && Ind2 != true && Grp2 != true &&
            DT != true && TD != true && LOD != true && PerFine != true &&
            DT_Lay_1 != true && DT_Lay_2 != true) {
            return "No Change";
        }
        else {
            //var strChanged = "";
            var strNewValue = "";

            //"Individual : Nominal : value,Group : Nominal : value"
            IterateObject(this.objResult, function (value, key1) {

                var i = 1;
                var obj = value;
                IterateObject(obj, (value, key) => {
                    if (value != false) {
                        if (i == 1) {
                            strNewValue = strNewValue + " " + key1 + "-";
                            //strNewValue = strNewValue + key1 + "-";
                        }
                        strNewValue = strNewValue + key + ":";
                        strNewValue = strNewValue + value + ",";
                        // ", ";
                        i = i + 1;
                    }

                })
            });

            return { newData: strNewValue.slice(1) };
        }
    }

}

module.exports = NewProductAuditComp;