/**
 * Granulation
 */
var IterateObject = require('iterate-object');

class NewProductAuditGranu {
    constructor() {
        const objResult = {};
        this.objResult = objResult;
    }

    validateLodDry(objProductNew) {
        return new Promise((resolve, reject) => {
            const objLodDry = {
                LodDry: {
                    MIN: "",
                    MAX: ""
                }
            };

            var IsChanged = false;

            if (objProductNew.flt_CompDryMin != "" && objProductNew.flt_CompDryMin != null) {
                if ((objProductNew.flt_CompDryMin != 99999) || (objProductNew.flt_CompDryMin != undefined)) {
                    objLodDry.LodDry.MIN = objProductNew.flt_CompDryMin != "" ? objProductNew.flt_CompDryMin : false;
                    objLodDry.LodDry.MAX = objProductNew.flt_CompDryMax != "" ? objProductNew.flt_CompDryMax : false;
                    IsChanged = true;
                }
            }
            else {
                IsChanged = false;
            }

            if (IsChanged == true) {
                Object.assign(this.objResult, objLodDry);
            }
            resolve(IsChanged);
        })


    }

    validateLodLubricated(objProductNew) {
        return new Promise((resolve, reject) => {
            const objLodLubricated = {
                LodLubricated: {
                    MIN: "",
                    MAX: ""
                }
            };

            var IsChanged = false;

            if (objProductNew.flt_CompLubMin != "" && objProductNew.flt_CompLubMin != null) {
                if ((objProductNew.flt_CompLubMin != 99999) || (objProductNew.flt_CompLubMin != undefined)) {
                    objLodLubricated.LodLubricated.MIN = objProductNew.flt_CompLubMin != "" ? objProductNew.flt_CompLubMin : false;
                    objLodLubricated.LodLubricated.MAX = objProductNew.flt_CompLubMax != "" ? objProductNew.flt_CompLubMax : false;
                    IsChanged = true;
                }
            }
            else {
                IsChanged = false;
            }


            if (IsChanged == true) {
                Object.assign(this.objResult, objLodLubricated);
            }
            resolve(IsChanged);
        })
    }

    validateLodLayer1Dry(objProductNew) {
        return new Promise((resolve, reject) => {
            const objLodDry_Lay_1 = {
                LodDry_Lay_1: {
                    MIN: "",
                    MAX: ""
                }
            };

            var IsChanged = false;

            if (objProductNew.flt_Layer1DryMin != "" && objProductNew.flt_Layer1DryMin != null) {
                if ((objProductNew.flt_Layer1DryMin != 99999) || (objProductNew.flt_Layer1DryMin != undefined)) {
                    objLodDry_Lay_1.LodDry_Lay_1.MIN = objProductNew.flt_Layer1DryMin != "" ? objProductNew.flt_Layer1DryMin : false;
                    objLodDry_Lay_1.LodDry_Lay_1.MAX = objProductNew.flt_Layer1DryMax != "" ? objProductNew.flt_Layer1DryMax : false;
                    IsChanged = true;
                }
            }
            else {
                IsChanged = false;
            }

            if (IsChanged == true) {
                Object.assign(this.objResult, objLodDry_Lay_1);
            }
            resolve(IsChanged);
        })
    }

    validateLodLayer1Lubricated(objProductNew) {
        return new Promise((resolve, reject) => {
            const objLodLayer1Lubricated = {
                LodLayer1Lubricated: {
                    MIN: "",
                    MAX: ""
                }
            };

            var IsChanged = false;

            if (objProductNew.flt_Layer1LubMin != "" && objProductNew.flt_Layer1LubMin != null) {
                if ((objProductNew.flt_Layer1LubMin != 99999) || (objProductNew.flt_Layer1LubMin != undefined)) {
                    objLodLayer1Lubricated.LodLayer1Lubricated.MIN = objProductNew.flt_Layer1LubMin != "" ? objProductNew.flt_Layer1LubMin : false;
                    objLodLayer1Lubricated.LodLayer1Lubricated.MAX = objProductNew.flt_Layer1LubMax != "" ? objProductNew.flt_Layer1LubMax : false;
                    IsChanged = true;
                }
            }
            else {
                IsChanged = false;
            }

            if (IsChanged == true) {
                Object.assign(this.objResult, objLodLayer1Lubricated);
            }
            resolve(IsChanged);
        })
    }

    validateLodLayer2Dry(objProductNew) {
        return new Promise((resolve, reject) => {
            const objLodDry_Lay_2 = {
                LodDry_Lay_2: {
                    MIN: "",
                    MAX: ""
                }
            };

            var IsChanged = false;

            if (objProductNew.flt_Layer2DryMin != "" && objProductNew.flt_Layer2DryMin != null) {
                if ((objProductNew.flt_Layer2DryMin != 99999) || (objProductNew.flt_Layer2DryMin != undefined)) {
                    objLodDry_Lay_2.LodDry_Lay_2.MIN = objProductNew.flt_Layer2DryMin != "" ? objProductNew.flt_Layer2DryMin : false;
                    objLodDry_Lay_2.LodDry_Lay_2.MAX = objProductNew.flt_Layer2DryMax != "" ? objProductNew.flt_Layer2DryMax : false;
                    IsChanged = true;
                }
            }
            else {
                IsChanged = false;
            }


            if (IsChanged == true) {
                Object.assign(this.objResult, objLodDry_Lay_2);
            }
            resolve(IsChanged);
        })
    }

    validateLodLayer2Lubricated(objProductNew) {
        return new Promise((resolve, reject) => {
            const objLodLayer2Lubricated = {
                LodLayer2Lubricated: {
                    MIN: "",
                    MAX: ""
                }
            };

            var IsChanged = false;

            if (objProductNew.flt_Layer2LubMin != "" && objProductNew.flt_Layer2LubMin != null) {
                if ((objProductNew.flt_Layer2LubMin != 99999) || (objProductNew.flt_Layer2LubMin != undefined)) {
                    objLodLayer2Lubricated.LodLayer2Lubricated.MIN = objProductNew.flt_Layer2LubMin != "" ? objProductNew.flt_Layer2LubMin : false;
                    objLodLayer2Lubricated.LodLayer2Lubricated.MAX = objProductNew.flt_Layer2LubMax != "" ? objProductNew.flt_Layer2LubMax : false;
                    IsChanged = true;
                }
            }
            else {
                IsChanged = false;
            }

            if (IsChanged == true) {
                Object.assign(this.objResult, objLodLayer2Lubricated);
            }
            resolve(IsChanged);
        })
    }

    validateTabDensity(objProductNew) {
        return new Promise((resolve, reject) => {
            const objTabDensity = {
                TappedDensity: {
                    MIN: "",
                    MAX: ""
                }
            };

            var IsChanged = false;

            if (objProductNew.flt_TapDenMin != "" && objProductNew.flt_TapDenMin != null) {
                if ((objProductNew.flt_TapDenMin != 99999) || (objProductNew.flt_TapDenMin != undefined)) {
                    objTabDensity.TappedDensity.MIN = objProductNew.flt_TapDenMin != "" ? objProductNew.flt_TapDenMin : false;
                    objTabDensity.TappedDensity.MAX = objProductNew.flt_TapDenMax != "" ? objProductNew.flt_TapDenMax : false;
                    IsChanged = true;
                }
            }
            else {
                IsChanged = false;
            }

            if (IsChanged == true) {
                Object.assign(this.objResult, objTabDensity);
            }

            resolve(IsChanged);
        })
    }

    validateFine(objProductNew) {
        return new Promise((resolve, reject) => {
            const objFine = {
                Fine: {
                    MIN: "",
                    MAX: ""
                }
            };

            var IsChanged = false;
            if (objProductNew.flt_FineMin != "" && objProductNew.flt_FineMin != null) {
                if ((objProductNew.flt_FineMin != 99999) || (objProductNew.flt_FineMin != undefined)) {
                    objFine.Fine.MIN = objProductNew.flt_FineMin != "" ? objProductNew.flt_FineMin : false;
                    objFine.Fine.MAX = objProductNew.flt_FineMax != "" ? objProductNew.flt_FineMax : false;
                    IsChanged = true;
                }
            }
            else {
                IsChanged = false;
            }

            if (IsChanged == true) {
                Object.assign(this.objResult, objFine);
            }
            resolve(IsChanged);
        })
    }

    validateParticleSeizing(objProductNew) {
        return new Promise((resolve, reject) => {
            const objParticleSeizing = {
                ParticleSizing: {
                    MIN: "",
                    MAX: ""
                }
            };

            var IsChanged = false;

            if (objProductNew.flt_PartSizingMin != "" && objProductNew.flt_PartSizingMin != null) {
                if ((objProductNew.flt_PartSizingMin != 99999) || (objProductNew.flt_PartSizingMin != undefined)) {
                    objParticleSeizing.ParticleSizing.MIN = objProductNew.flt_PartSizingMin != "" ? objProductNew.flt_PartSizingMin : false;
                    objParticleSeizing.ParticleSizing.MAX = objProductNew.flt_PartSizingMax != "" ? objProductNew.flt_PartSizingMax : false;
                    IsChanged = true;
                }
            }
            else {
                IsChanged = false;
            }

            if (IsChanged == true) {
                Object.assign(this.objResult, objParticleSeizing);
            }
            resolve(IsChanged);
        })
    }

    validateBulkDensity(objProductNew) {
        return new Promise((resolve, reject) => {
            const obj_bulkDensity = {
                BulkDensity: {
                    MIN: "",
                    MAX: ""
                }
            };

            var IsChanged = false;

            if (objProductNew.flt_bulkMin != "" && objProductNew.flt_bulkMin != null) {
                if ((objProductNew.flt_bulkMin != 99999) || (objProductNew.flt_bulkMin != undefined)) {
                    obj_bulkDensity.BulkDensity.MIN = objProductNew.flt_bulkMin != "" ? objProductNew.flt_bulkMin : false;
                    obj_bulkDensity.BulkDensity.MAX = objProductNew.flt_bulkMax != "" ? objProductNew.flt_bulkMax : false;
                    IsChanged = true;
                }
            }
            else {
                IsChanged = false;
            }

            if (IsChanged == true) {
                Object.assign(this.objResult, obj_bulkDensity);
            }
            resolve(IsChanged);
        })
    }


    async newGranulationParams(objProductNew) {
        var LodDry = await this.validateLodDry(objProductNew);
        var LodLubri = await this.validateLodLubricated(objProductNew);
        var Fine = await this.validateFine(objProductNew);
        var TappedDensity = await this.validateTabDensity(objProductNew);
        var BulkDensity = await this.validateBulkDensity(objProductNew);
        var ParticleSizing = await this.validateParticleSeizing(objProductNew);
        var LodLayer1Dry = await this.validateLodLayer1Dry(objProductNew);
        var LodLayer1Lubri = await this.validateLodLayer1Lubricated(objProductNew);
        var Fine_Lay_1 = await this.validateFine_Lay_1(objProductNew);
        var TappedDensity_Lay_1 = await this.validateTabDensity_Lay_1(objProductNew);
        var BulkDensity_Lay_1 = await this.validateBulkDensity_Lay_1(objProductNew);
        var ParticleSizing_Lay_1 = await this.validateParticleSeizing_Lay_1(objProductNew);
        var LodLayer2Dry = await this.validateLodLayer2Dry(objProductNew);
        var LodLayer2Lubri = await this.validateLodLayer2Lubricated(objProductNew);
        var Fine_Lay_2 = await this.validateFine_Lay_2(objProductNew);
        var TappedDensity_Lay_2 = await this.validateTabDensity_Lay_2(objProductNew);
        var BulkDensity_Lay_2 = await this.validateBulkDensity_Lay_2(objProductNew);
        var ParticleSizing_Lay_2 = await this.validateParticleSeizing_Lay_2(objProductNew);

        var ParticleSizeDistribution = await this.validateParticleSizeDistribution(objProductNew);
        var ParticleSizeDistribution_abv_20 = await this.validateParticleSizeDistribution_abv_20(objProductNew);
        var ParticleSizeDistribution_abv_40 = await this.validateParticleSizeDistribution_abv_40(objProductNew);
        var ParticleSizeDistribution_abv_60 = await this.validateParticleSizeDistribution_abv_60(objProductNew);
        var ParticleSizeDistribution_abv_80 = await this.validateParticleSizeDistribution_abv_80(objProductNew);
        var ParticleSizeDistribution_abv_100 = await this.validateParticleSizeDistribution_abv_100(objProductNew);
        var ParticleSizeDistribution_blw_100 = await this.validateParticleSizeDistribution_blw_100(objProductNew);
        var ParticleSizeDistribution_Lay_1 = await this.validateParticleSizeDistribution_Lay_1(objProductNew);
        var ParticleSizeDistribution_abv_20_Lay_1 = await this.validateParticleSizeDistribution_abv_20_Lay_1(objProductNew);
        var ParticleSizeDistribution_abv_40_Lay_1 = await this.validateParticleSizeDistribution_abv_40_Lay_1(objProductNew);
        var ParticleSizeDistribution_abv_60_Lay_1 = await this.validateParticleSizeDistribution_abv_60_Lay_1(objProductNew);
        var ParticleSizeDistribution_abv_80_Lay_1 = await this.validateParticleSizeDistribution_abv_80_Lay_1(objProductNew);
        var ParticleSizeDistribution_abv_100_Lay_1 = await this.validateParticleSizeDistribution_abv_100_Lay_1(objProductNew);
        var ParticleSizeDistribution_blw_100_Lay_1 = await this.validateParticleSizeDistribution_blw_100_Lay_1(objProductNew);
        var Fine_blw_30 = await this.validateFine_blw_30(objProductNew);
        var Fine_abv_30 = await this.validateFine_abv_30(objProductNew);
        var Fine_blw_40 = await this.validateFine_blw_40(objProductNew);
        var Fine_abv_40 = await this.validateFine_abv_40(objProductNew);
        var Fine_blw_60 = await this.validateFine_blw_60(objProductNew);
        var Fine_abv_60 = await this.validateFine_abv_60(objProductNew);
        var Fine_blw_80 = await this.validateFine_blw_80(objProductNew);
        var Fine_abv_80 = await this.validateFine_abv_80(objProductNew);
        var Fine_blw_100 = await this.validateFine_blw_100(objProductNew);
        var Fine_abv_100 = await this.validateFine_abv_100(objProductNew);
        var Fine_Pan = await this.validateFine_Pan(objProductNew);
        var Fine_blw_30_Lay_1 = await this.validateFine_blw_30_Lay_1(objProductNew);
        var Fine_abv_30_Lay_1 = await this.validateFine_abv_30_Lay_1(objProductNew);
        var Fine_blw_40_Lay_1 = await this.validateFine_blw_40_Lay_1(objProductNew);
        var Fine_abv_40_Lay_1 = await this.validateFine_abv_40_Lay_1(objProductNew);
        var Fine_blw_60_Lay_1 = await this.validateFine_blw_60_Lay_1(objProductNew);
        var Fine_abv_60_Lay_1 = await this.validateFine_abv_60_Lay_1(objProductNew);
        var Fine_blw_80_Lay_1 = await this.validateFine_blw_80_Lay_1(objProductNew);
        var Fine_abv_80_Lay_1 = await this.validateFine_abv_80_Lay_1(objProductNew);
        var Fine_blw_100_Lay_1 = await this.validateFine_blw_100_Lay_1(objProductNew);
        var Fine_abv_100_Lay_1 = await this.validateFine_abv_100_Lay_1(objProductNew);
        var Fine_Pan_Lay_1 = await this.validateFine_Pan_Lay_1(objProductNew);
        var Fine_blw_30_Lay_2 = await this.validateFine_blw_30_Lay_2(objProductNew);
        var Fine_abv_30_Lay_2 = await this.validateFine_abv_30_Lay_2(objProductNew);
        var Fine_blw_40_Lay_2 = await this.validateFine_blw_40_Lay_2(objProductNew);
        var Fine_abv_40_Lay_2 = await this.validateFine_abv_40_Lay_2(objProductNew);
        var Fine_blw_60_Lay_2 = await this.validateFine_blw_60_Lay_2(objProductNew);
        var Fine_abv_60_Lay_2 = await this.validateFine_abv_60_Lay_2(objProductNew);
        var Fine_blw_80_Lay_2 = await this.validateFine_blw_80_Lay_2(objProductNew);
        var Fine_abv_80_Lay_2 = await this.validateFine_abv_80_Lay_2(objProductNew);
        var Fine_blw_100_Lay_2 = await this.validateFine_blw_100_Lay_2(objProductNew);
        var Fine_abv_100_Lay_2 = await this.validateFine_abv_100_Lay_2(objProductNew);
        var Fine_Pan_Lay_2 = await this.validateFine_Pan_Lay_2(objProductNew);


        if (LodDry != true && LodLubri != true && LodLayer1Dry != true && LodLayer1Lubri != true &&
            LodLayer2Dry != true && LodLayer2Lubri != true && TappedDensity != true && Fine!= true && 
            ParticleSizing != true && BulkDensity != true && 
            TappedDensity_Lay_1 != true && TappedDensity_Lay_2 != true &&
            BulkDensity_Lay_1 != true && BulkDensity_Lay_2 != true &&
            Fine_blw_30 != true && Fine_abv_30 != true && Fine_blw_40 != true && Fine_abv_40 != true &&
            Fine_blw_60 != true && Fine_abv_60 != true && Fine_blw_80 != true && Fine_abv_80 != true &&
            Fine_blw_100 != true && Fine_abv_100 != true && Fine_Pan != true && 
            Fine_blw_30_Lay_1 != true && Fine_abv_30_Lay_1 != true && Fine_blw_40_Lay_1 != true && Fine_abv_40_Lay_1 != true &&
            Fine_blw_60_Lay_1 != true && Fine_abv_60_Lay_1 != true && Fine_blw_80_Lay_1 != true && Fine_abv_80_Lay_1 != true &&
            Fine_blw_100_Lay_1 != true && Fine_abv_100_Lay_1 != true && Fine_Pan_Lay_1 != true &&
            Fine_blw_30_Lay_2 != true && Fine_abv_30_Lay_2 != true && Fine_blw_40_Lay_2 != true && Fine_abv_40_Lay_2 != true &&
            Fine_blw_60_Lay_2 != true && Fine_abv_60_Lay_2 != true && Fine_blw_80_Lay_2 != true && Fine_abv_80_Lay_2 != true &&
            Fine_blw_100_Lay_2 != true && Fine_abv_100_Lay_2 != true && Fine_Pan_Lay_2 != true &&
            Fine_Lay_1 != true && Fine_Lay_2 != true &&
            ParticleSizeDistribution != true && ParticleSizeDistribution_abv_20 != true && 
            ParticleSizeDistribution_abv_40 != true && ParticleSizeDistribution_abv_60 != true && 
            ParticleSizeDistribution_abv_80 != true && ParticleSizeDistribution_abv_100 != true && 
            ParticleSizeDistribution_blw_100 != true && 
            ParticleSizeDistribution_Lay_1 != true && ParticleSizeDistribution_abv_20_Lay_1 != true && 
            ParticleSizeDistribution_abv_40_Lay_1 != true && ParticleSizeDistribution_abv_60_Lay_1 != true && 
            ParticleSizeDistribution_abv_80_Lay_1 != true && ParticleSizeDistribution_abv_100_Lay_1 != true &&
            ParticleSizeDistribution_blw_100_Lay_1 != true &&
            ParticleSizing_Lay_1 != true && ParticleSizing_Lay_2 != true
        ) {
            return "No Change";
        }
        else {
            // var strChanged = "";
            var strNewValue = "";

            //"Individual : Nominal : value,Group : Nominal : value"
            IterateObject(this.objResult, function (value, key1) {
                //console.log(key1);
                var i = 1;
                var obj = value;
                IterateObject(obj, (value, key) => {
                    if (value !== false) {
                        if (i == 1) {
                            strNewValue = strNewValue + " " + key1 + "-";
                        }

                        strNewValue = strNewValue + key + ":";
                        strNewValue = strNewValue + value + ",";
                        //", ";
                        i = i + 1;
                    }

                })
            });

            return { newData: strNewValue };
        }
    }

    validateTabDensity_Lay_1(objProductNew) {
        return new Promise((resolve, reject) => {
            const objTabDensity_Lay_1 = {
                TappedDensity_Lay_1: {
                    MIN: "",
                    MAX: ""
                }
            };

            var IsChanged = false;

            if (objProductNew.flt_TapDenMin_Lay_1 != "" && objProductNew.flt_TapDenMin_Lay_1 != null) {
                if ((objProductNew.flt_TapDenMin_Lay_1 != 99999) || (objProductNew.flt_TapDenMin_Lay_1 != undefined)) {
                    objTabDensity_Lay_1.TappedDensity_Lay_1.MIN = objProductNew.flt_TapDenMin_Lay_1 != "" ? objProductNew.flt_TapDenMin_Lay_1 : false;
                    objTabDensity_Lay_1.TappedDensity_Lay_1.MAX = objProductNew.flt_TapDenMax_Lay_1 != "" ? objProductNew.flt_TapDenMax_Lay_1 : false;
                    IsChanged = true;
                }
            }
            else {
                IsChanged = false;
            }

            if (IsChanged == true) {
                Object.assign(this.objResult, objTabDensity_Lay_1);
            }

            resolve(IsChanged);
        });
    }

    validateTabDensity_Lay_2(objProductNew) {
        return new Promise((resolve, reject) => {
            const objTabDensity_Lay_2 = {
                TappedDensity_Lay_2: {
                    MIN: "",
                    MAX: ""
                }
            };

            var IsChanged = false;

            if (objProductNew.flt_TapDenMin_Lay_2 != "" && objProductNew.flt_TapDenMin_Lay_2 != null) {
                if ((objProductNew.flt_TapDenMin_Lay_2 != 99999) || (objProductNew.flt_TapDenMin_Lay_2 != undefined)) {
                    objTabDensity_Lay_2.TappedDensity_Lay_2.MIN = objProductNew.flt_TapDenMin_Lay_2 != "" ? objProductNew.flt_TapDenMin_Lay_2 : false;
                    objTabDensity_Lay_2.TappedDensity_Lay_2.MAX = objProductNew.flt_TapDenMax_Lay_2 != "" ? objProductNew.flt_TapDenMax_Lay_2 : false;
                    IsChanged = true;
                }
            }
            else {
                IsChanged = false;
            }

            if (IsChanged == true) {
                Object.assign(this.objResult, objTabDensity_Lay_2);
            }

            resolve(IsChanged);
        });
    }

    validateBulkDensity_Lay_1(objProductNew) {
        return new Promise((resolve, reject) => {
            const obj_bulkDensity_Lay_1 = {
                BulkDensity_Lay_1: {
                    MIN: "",
                    MAX: ""
                }
            };

            var IsChanged = false;

            if (objProductNew.flt_bulkMin_Lay_1 != "" && objProductNew.flt_bulkMin_Lay_1 != null) {
                if ((objProductNew.flt_bulkMin_Lay_1 != 99999) || (objProductNew.flt_bulkMin_Lay_1 != undefined)) {
                    obj_bulkDensity_Lay_1.BulkDensity_Lay_1.MIN = objProductNew.flt_bulkMin_Lay_1 != "" ? objProductNew.flt_bulkMin_Lay_1 : false;
                    obj_bulkDensity_Lay_1.BulkDensity_Lay_1.MAX = objProductNew.flt_bulkMax_Lay_1 != "" ? objProductNew.flt_bulkMax_Lay_1 : false;
                    IsChanged = true;
                }
            }
            else {
                IsChanged = false;
            }

            if (IsChanged == true) {
                Object.assign(this.objResult, obj_bulkDensity_Lay_1);
            }
            resolve(IsChanged);
        });
    }

    validateBulkDensity_Lay_2(objProductNew) {
        return new Promise((resolve, reject) => {
            const obj_bulkDensity_Lay_2 = {
                BulkDensity_Lay_2: {
                    MIN: "",
                    MAX: ""
                }
            };

            var IsChanged = false;

            if (objProductNew.flt_bulkMin_Lay_2 != "" && objProductNew.flt_bulkMin_Lay_2 != null) {
                if ((objProductNew.flt_bulkMin_Lay_2 != 99999) || (objProductNew.flt_bulkMin_Lay_2 != undefined)) {
                    obj_bulkDensity_Lay_2.BulkDensity_Lay_2.MIN = objProductNew.flt_bulkMin_Lay_2 != "" ? objProductNew.flt_bulkMin_Lay_2 : false;
                    obj_bulkDensity_Lay_2.BulkDensity_Lay_2.MAX = objProductNew.flt_bulkMax_Lay_2 != "" ? objProductNew.flt_bulkMax_Lay_2 : false;
                    IsChanged = true;
                }
            }
            else {
                IsChanged = false;
            }

            if (IsChanged == true) {
                Object.assign(this.objResult, obj_bulkDensity_Lay_2);
            }
            resolve(IsChanged);
        });
    }

    validateFine_blw_30(objProductNew) {
        return new Promise((resolve, reject) => {
            const objFine_blw_30 = {
                Fine_blw_30: {
                    MIN: "",
                    MAX: ""
                }
            };

            var IsChanged = false;
            if (objProductNew.flt_FineMin_blw_30 != "" && objProductNew.flt_FineMin_blw_30 != null) {
                if ((objProductNew.flt_FineMin_blw_30 != 99999) || (objProductNew.flt_FineMin_blw_30 != undefined)) {
                    objFine_blw_30.Fine_blw_30.MIN = objProductNew.flt_FineMin_blw_30 != "" ? objProductNew.flt_FineMin_blw_30 : false;
                    objFine_blw_30.Fine_blw_30.MAX = objProductNew.flt_FineMax_blw_30 != "" ? objProductNew.flt_FineMax_blw_30 : false;
                    IsChanged = true;
                }
            }
            else {
                IsChanged = false;
            }

            if (IsChanged == true) {
                Object.assign(this.objResult, objFine_blw_30);
            }
            resolve(IsChanged);
        });
    }

    validateFine_abv_30(objProductNew) {
        return new Promise((resolve, reject) => {
            const objFine_abv_30 = {
                Fine_abv_30: {
                    MIN: "",
                    MAX: ""
                }
            };

            var IsChanged = false;
            if (objProductNew.flt_FineMin_abv_30 != "" && objProductNew.flt_FineMin_abv_30 != null) {
                if ((objProductNew.flt_FineMin_abv_30 != 99999) || (objProductNew.flt_FineMin_abv_30 != undefined)) {
                    objFine_abv_30.Fine_abv_30.MIN = objProductNew.flt_FineMin_abv_30 != "" ? objProductNew.flt_FineMin_abv_30 : false;
                    objFine_abv_30.Fine_abv_30.MAX = objProductNew.flt_FineMax_abv_30 != "" ? objProductNew.flt_FineMax_abv_30 : false;
                    IsChanged = true;
                }
            }
            else {
                IsChanged = false;
            }

            if (IsChanged == true) {
                Object.assign(this.objResult, objFine_abv_30);
            }
            resolve(IsChanged);
        });
    }

    validateFine_blw_40(objProductNew) {
        return new Promise((resolve, reject) => {
            const objFine_blw_40 = {
                Fine_blw_40: {
                    MIN: "",
                    MAX: ""
                }
            };

            var IsChanged = false;
            if (objProductNew.flt_FineMin_blw_40 != "" && objProductNew.flt_FineMin_blw_40 != null) {
                if ((objProductNew.flt_FineMin_blw_40 != 99999) || (objProductNew.flt_FineMin_blw_40 != undefined)) {
                    objFine_blw_40.Fine_blw_40.MIN = objProductNew.flt_FineMin_blw_40 != "" ? objProductNew.flt_FineMin_blw_40 : false;
                    objFine_blw_40.Fine_blw_40.MAX = objProductNew.flt_FineMax_blw_40 != "" ? objProductNew.flt_FineMax_blw_40 : false;
                    IsChanged = true;
                }
            }
            else {
                IsChanged = false;
            }

            if (IsChanged == true) {
                Object.assign(this.objResult, objFine_blw_40);
            }
            resolve(IsChanged);
        });
    }

    validateFine_abv_40(objProductNew) {
        return new Promise((resolve, reject) => {
            const objFine_abv_40 = {
                Fine_abv_40: {
                    MIN: "",
                    MAX: ""
                }
            };

            var IsChanged = false;
            if (objProductNew.flt_FineMin_abv_40 != "" && objProductNew.flt_FineMin_abv_40 != null) {
                if ((objProductNew.flt_FineMin_abv_40 != 99999) || (objProductNew.flt_FineMin_abv_40 != undefined)) {
                    objFine_abv_40.Fine_abv_40.MIN = objProductNew.flt_FineMin_abv_40 != "" ? objProductNew.flt_FineMin_abv_40 : false;
                    objFine_abv_40.Fine_abv_40.MAX = objProductNew.flt_FineMax_abv_40 != "" ? objProductNew.flt_FineMax_abv_40 : false;
                    IsChanged = true;
                }
            }
            else {
                IsChanged = false;
            }

            if (IsChanged == true) {
                Object.assign(this.objResult, objFine_abv_40);
            }
            resolve(IsChanged);
        });
    }

    validateFine_blw_60(objProductNew) {
        return new Promise((resolve, reject) => {
            const objFine_blw_60 = {
                Fine_blw_60: {
                    MIN: "",
                    MAX: ""
                }
            };

            var IsChanged = false;
            if (objProductNew.flt_FineMin_blw_60 != "" && objProductNew.flt_FineMin_blw_60 != null) {
                if ((objProductNew.flt_FineMin_blw_60 != 99999) || (objProductNew.flt_FineMin_blw_60 != undefined)) {
                    objFine_blw_60.Fine_blw_60.MIN = objProductNew.flt_FineMin_blw_60 != "" ? objProductNew.flt_FineMin_blw_60 : false;
                    objFine_blw_60.Fine_blw_60.MAX = objProductNew.flt_FineMax_blw_60 != "" ? objProductNew.flt_FineMax_blw_60 : false;
                    IsChanged = true;
                }
            }
            else {
                IsChanged = false;
            }

            if (IsChanged == true) {
                Object.assign(this.objResult, objFine_blw_60);
            }
            resolve(IsChanged);
        });
    }

    validateFine_abv_60(objProductNew) {
        return new Promise((resolve, reject) => {
            const objFine_abv_60 = {
                Fine_abv_60: {
                    MIN: "",
                    MAX: ""
                }
            };

            var IsChanged = false;
            if (objProductNew.flt_FineMin_abv_60 != "" && objProductNew.flt_FineMin_abv_60 != null) {
                if ((objProductNew.flt_FineMin_abv_60 != 99999) || (objProductNew.flt_FineMin_abv_60 != undefined)) {
                    objFine_abv_60.Fine_abv_60.MIN = objProductNew.flt_FineMin_abv_60 != "" ? objProductNew.flt_FineMin_abv_60 : false;
                    objFine_abv_60.Fine_abv_60.MAX = objProductNew.flt_FineMax_abv_60 != "" ? objProductNew.flt_FineMax_abv_60 : false;
                    IsChanged = true;
                }
            }
            else {
                IsChanged = false;
            }

            if (IsChanged == true) {
                Object.assign(this.objResult, objFine_abv_60);
            }
            resolve(IsChanged);
        });
    }

    validateFine_blw_80(objProductNew) {
        return new Promise((resolve, reject) => {
            const objFine_blw_80 = {
                Fine_blw_80: {
                    MIN: "",
                    MAX: ""
                }
            };

            var IsChanged = false;
            if (objProductNew.flt_FineMin_blw_80 != "" && objProductNew.flt_FineMin_blw_80 != null) {
                if ((objProductNew.flt_FineMin_blw_80 != 99999) || (objProductNew.flt_FineMin_blw_80 != undefined)) {
                    objFine_blw_80.Fine_blw_80.MIN = objProductNew.flt_FineMin_blw_80 != "" ? objProductNew.flt_FineMin_blw_80 : false;
                    objFine_blw_80.Fine_blw_80.MAX = objProductNew.flt_FineMax_blw_80 != "" ? objProductNew.flt_FineMax_blw_80 : false;
                    IsChanged = true;
                }
            }
            else {
                IsChanged = false;
            }

            if (IsChanged == true) {
                Object.assign(this.objResult, objFine_blw_80);
            }
            resolve(IsChanged);
        });
    }

    validateFine_abv_80(objProductNew) {
        return new Promise((resolve, reject) => {
            const objFine_abv_80 = {
                Fine_abv_80: {
                    MIN: "",
                    MAX: ""
                }
            };

            var IsChanged = false;
            if (objProductNew.flt_FineMin_abv_80 != "" && objProductNew.flt_FineMin_abv_80 != null) {
                if ((objProductNew.flt_FineMin_abv_80 != 99999) || (objProductNew.flt_FineMin_abv_80 != undefined)) {
                    objFine_abv_80.Fine_abv_80.MIN = objProductNew.flt_FineMin_abv_80 != "" ? objProductNew.flt_FineMin_abv_80 : false;
                    objFine_abv_80.Fine_abv_80.MAX = objProductNew.flt_FineMax_abv_80 != "" ? objProductNew.flt_FineMax_abv_80 : false;
                    IsChanged = true;
                }
            }
            else {
                IsChanged = false;
            }

            if (IsChanged == true) {
                Object.assign(this.objResult, objFine_abv_80);
            }
            resolve(IsChanged);
        });
    }

    validateFine_blw_100(objProductNew) {
        return new Promise((resolve, reject) => {
            const objFine_blw_100 = {
                Fine_blw_100: {
                    MIN: "",
                    MAX: ""
                }
            };

            var IsChanged = false;
            if (objProductNew.flt_FineMin_blw_100 != "" && objProductNew.flt_FineMin_blw_100 != null) {
                if ((objProductNew.flt_FineMin_blw_100 != 99999) || (objProductNew.flt_FineMin_blw_100 != undefined)) {
                    objFine_blw_100.Fine_blw_100.MIN = objProductNew.flt_FineMin_blw_100 != "" ? objProductNew.flt_FineMin_blw_100 : false;
                    objFine_blw_100.Fine_blw_100.MAX = objProductNew.flt_FineMax_blw_100 != "" ? objProductNew.flt_FineMax_blw_100 : false;
                    IsChanged = true;
                }
            }
            else {
                IsChanged = false;
            }

            if (IsChanged == true) {
                Object.assign(this.objResult, objFine_blw_100);
            }
            resolve(IsChanged);
        });
    }

    validateFine_abv_100(objProductNew) {
        return new Promise((resolve, reject) => {
            const objFine_abv_100 = {
                Fine_abv_100: {
                    MIN: "",
                    MAX: ""
                }
            };

            var IsChanged = false;
            if (objProductNew.flt_FineMin_abv_100 != "" && objProductNew.flt_FineMin_abv_100 != null) {
                if ((objProductNew.flt_FineMin_abv_100 != 99999) || (objProductNew.flt_FineMin_abv_100 != undefined)) {
                    objFine_abv_100.Fine_abv_100.MIN = objProductNew.flt_FineMin_abv_100 != "" ? objProductNew.flt_FineMin_abv_100 : false;
                    objFine_abv_100.Fine_abv_100.MAX = objProductNew.flt_FineMax_abv_100 != "" ? objProductNew.flt_FineMax_abv_100 : false;
                    IsChanged = true;
                }
            }
            else {
                IsChanged = false;
            }

            if (IsChanged == true) {
                Object.assign(this.objResult, objFine_abv_100);
            }
            resolve(IsChanged);
        });
    }

    validateFine_Pan(objProductNew) {
        return new Promise((resolve, reject) => {
            const objFine_Pan = {
                Fine_Pan: {
                    MIN: "",
                    MAX: ""
                }
            };

            var IsChanged = false;
            if (objProductNew.flt_FineMin_Pan != "" && objProductNew.flt_FineMin_Pan != null) {
                if ((objProductNew.flt_FineMin_Pan != 99999) || (objProductNew.flt_FineMin_Pan != undefined)) {
                    objFine_Pan.Fine_Pan.MIN = objProductNew.flt_FineMin_Pan != "" ? objProductNew.flt_FineMin_Pan : false;
                    objFine_Pan.Fine_Pan.MAX = objProductNew.flt_FineMax_Pan != "" ? objProductNew.flt_FineMax_Pan : false;
                    IsChanged = true;
                }
            }
            else {
                IsChanged = false;
            }

            if (IsChanged == true) {
                Object.assign(this.objResult, objFine_Pan);
            }
            resolve(IsChanged);
        });
    }

    validateFine_blw_30_Lay_1(objProductNew) {
        return new Promise((resolve, reject) => {
            const objFine_blw_30_Lay_1 = {
                Fine_blw_30_Lay_1: {
                    MIN: "",
                    MAX: ""
                }
            };
    
            var IsChanged = false;
            if (objProductNew.flt_FineMin_blw_30_Lay_1 != "" && objProductNew.flt_FineMin_blw_30_Lay_1 != null) {
                if ((objProductNew.flt_FineMin_blw_30_Lay_1 != 99999) || (objProductNew.flt_FineMin_blw_30_Lay_1 != undefined)) {
                    objFine_blw_30_Lay_1.Fine_blw_30_Lay_1.MIN = objProductNew.flt_FineMin_blw_30_Lay_1 != "" ? objProductNew.flt_FineMin_blw_30_Lay_1 : false;
                    objFine_blw_30_Lay_1.Fine_blw_30_Lay_1.MAX = objProductNew.flt_FineMax_blw_30_Lay_1 != "" ? objProductNew.flt_FineMax_blw_30_Lay_1 : false;
                    IsChanged = true;
                }
            }
            else {
                IsChanged = false;
            }
    
            if (IsChanged == true) {
                Object.assign(this.objResult, objFine_blw_30_Lay_1);
            }
            resolve(IsChanged);
        });
    }

    validateFine_abv_30_Lay_1(objProductNew) {
        return new Promise((resolve, reject) => {
            const objFine_abv_30_Lay_1 = {
                Fine_abv_30_Lay_1: {
                    MIN: "",
                    MAX: ""
                }
            };
    
            var IsChanged = false;
            if (objProductNew.flt_FineMin_abv_30_Lay_1 != "" && objProductNew.flt_FineMin_abv_30_Lay_1 != null) {
                if ((objProductNew.flt_FineMin_abv_30_Lay_1 != 99999) || (objProductNew.flt_FineMin_abv_30_Lay_1 != undefined)) {
                    objFine_abv_30_Lay_1.Fine_abv_30_Lay_1.MIN = objProductNew.flt_FineMin_abv_30_Lay_1 != "" ? objProductNew.flt_FineMin_abv_30_Lay_1 : false;
                    objFine_abv_30_Lay_1.Fine_abv_30_Lay_1.MAX = objProductNew.flt_FineMax_abv_30_Lay_1 != "" ? objProductNew.flt_FineMax_abv_30_Lay_1 : false;
                    IsChanged = true;
                }
            }
            else {
                IsChanged = false;
            }
    
            if (IsChanged == true) {
                Object.assign(this.objResult, objFine_abv_30_Lay_1);
            }
            resolve(IsChanged);
        });
    }

    validateFine_blw_40_Lay_1(objProductNew) {
        return new Promise((resolve, reject) => {
            const objFine_blw_40_Lay_1 = {
                Fine_blw_40_Lay_1: {
                    MIN: "",
                    MAX: ""
                }
            };
    
            var IsChanged = false;
            if (objProductNew.flt_FineMin_blw_40_Lay_1 != "" && objProductNew.flt_FineMin_blw_40_Lay_1 != null) {
                if ((objProductNew.flt_FineMin_blw_40_Lay_1 != 99999) || (objProductNew.flt_FineMin_blw_40_Lay_1 != undefined)) {
                    objFine_blw_40_Lay_1.Fine_blw_40_Lay_1.MIN = objProductNew.flt_FineMin_blw_40_Lay_1 != "" ? objProductNew.flt_FineMin_blw_40_Lay_1 : false;
                    objFine_blw_40_Lay_1.Fine_blw_40_Lay_1.MAX = objProductNew.flt_FineMax_blw_40_Lay_1 != "" ? objProductNew.flt_FineMax_blw_40_Lay_1 : false;
                    IsChanged = true;
                }
            }
            else {
                IsChanged = false;
            }
    
            if (IsChanged == true) {
                Object.assign(this.objResult, objFine_blw_40_Lay_1);
            }
            resolve(IsChanged);
        });
    }
    
    validateFine_abv_40_Lay_1(objProductNew) {
        return new Promise((resolve, reject) => {
            const objFine_abv_40_Lay_1 = {
                Fine_abv_40_Lay_1: {
                    MIN: "",
                    MAX: ""
                }
            };
    
            var IsChanged = false;
            if (objProductNew.flt_FineMin_abv_40_Lay_1 != "" && objProductNew.flt_FineMin_abv_40_Lay_1 != null) {
                if ((objProductNew.flt_FineMin_abv_40_Lay_1 != 99999) || (objProductNew.flt_FineMin_abv_40_Lay_1 != undefined)) {
                    objFine_abv_40_Lay_1.Fine_abv_40_Lay_1.MIN = objProductNew.flt_FineMin_abv_40_Lay_1 != "" ? objProductNew.flt_FineMin_abv_40_Lay_1 : false;
                    objFine_abv_40_Lay_1.Fine_abv_40_Lay_1.MAX = objProductNew.flt_FineMax_abv_40_Lay_1 != "" ? objProductNew.flt_FineMax_abv_40_Lay_1 : false;
                    IsChanged = true;
                }
            }
            else {
                IsChanged = false;
            }
    
            if (IsChanged == true) {
                Object.assign(this.objResult, objFine_abv_40_Lay_1);
            }
            resolve(IsChanged);
        });
    }
    
    validateFine_blw_60_Lay_1(objProductNew) {
        return new Promise((resolve, reject) => {
            const objFine_blw_60_Lay_1 = {
                Fine_blw_60_Lay_1: {
                    MIN: "",
                    MAX: ""
                }
            };
    
            var IsChanged = false;
            if (objProductNew.flt_FineMin_blw_60_Lay_1 != "" && objProductNew.flt_FineMin_blw_60_Lay_1 != null) {
                if ((objProductNew.flt_FineMin_blw_60_Lay_1 != 99999) || (objProductNew.flt_FineMin_blw_60_Lay_1 != undefined)) {
                    objFine_blw_60_Lay_1.Fine_blw_60_Lay_1.MIN = objProductNew.flt_FineMin_blw_60_Lay_1 != "" ? objProductNew.flt_FineMin_blw_60_Lay_1 : false;
                    objFine_blw_60_Lay_1.Fine_blw_60_Lay_1.MAX = objProductNew.flt_FineMax_blw_60_Lay_1 != "" ? objProductNew.flt_FineMax_blw_60_Lay_1 : false;
                    IsChanged = true;
                }
            }
            else {
                IsChanged = false;
            }
    
            if (IsChanged == true) {
                Object.assign(this.objResult, objFine_blw_60_Lay_1);
            }
            resolve(IsChanged);
        });
    }
    
    validateFine_abv_60_Lay_1(objProductNew) {
        return new Promise((resolve, reject) => {
            const objFine_abv_60_Lay_1 = {
                Fine_abv_60_Lay_1: {
                    MIN: "",
                    MAX: ""
                }
            };
    
            var IsChanged = false;
            if (objProductNew.flt_FineMin_abv_60_Lay_1 != "" && objProductNew.flt_FineMin_abv_60_Lay_1 != null) {
                if ((objProductNew.flt_FineMin_abv_60_Lay_1 != 99999) || (objProductNew.flt_FineMin_abv_60_Lay_1 != undefined)) {
                    objFine_abv_60_Lay_1.Fine_abv_60_Lay_1.MIN = objProductNew.flt_FineMin_abv_60_Lay_1 != "" ? objProductNew.flt_FineMin_abv_60_Lay_1 : false;
                    objFine_abv_60_Lay_1.Fine_abv_60_Lay_1.MAX = objProductNew.flt_FineMax_abv_60_Lay_1 != "" ? objProductNew.flt_FineMax_abv_60_Lay_1 : false;
                    IsChanged = true;
                }
            }
            else {
                IsChanged = false;
            }
    
            if (IsChanged == true) {
                Object.assign(this.objResult, objFine_abv_60_Lay_1);
            }
            resolve(IsChanged);
        });
    }
    
    validateFine_blw_80_Lay_1(objProductNew) {
        return new Promise((resolve, reject) => {
            const objFine_blw_80_Lay_1 = {
                Fine_blw_80_Lay_1: {
                    MIN: "",
                    MAX: ""
                }
            };
    
            var IsChanged = false;
            if (objProductNew.flt_FineMin_blw_80_Lay_1 != "" && objProductNew.flt_FineMin_blw_80_Lay_1 != null) {
                if ((objProductNew.flt_FineMin_blw_80_Lay_1 != 99999) || (objProductNew.flt_FineMin_blw_80_Lay_1 != undefined)) {
                    objFine_blw_80_Lay_1.Fine_blw_80_Lay_1.MIN = objProductNew.flt_FineMin_blw_80_Lay_1 != "" ? objProductNew.flt_FineMin_blw_80_Lay_1 : false;
                    objFine_blw_80_Lay_1.Fine_blw_80_Lay_1.MAX = objProductNew.flt_FineMax_blw_80_Lay_1 != "" ? objProductNew.flt_FineMax_blw_80_Lay_1 : false;
                    IsChanged = true;
                }
            }
            else {
                IsChanged = false;
            }
    
            if (IsChanged == true) {
                Object.assign(this.objResult, objFine_blw_80_Lay_1);
            }
            resolve(IsChanged);
        });
    }
    
    validateFine_abv_80_Lay_1(objProductNew) {
        return new Promise((resolve, reject) => {
            const objFine_abv_80_Lay_1 = {
                Fine_abv_80_Lay_1: {
                    MIN: "",
                    MAX: ""
                }
            };
    
            var IsChanged = false;
            if (objProductNew.flt_FineMin_abv_80_Lay_1 != "" && objProductNew.flt_FineMin_abv_80_Lay_1 != null) {
                if ((objProductNew.flt_FineMin_abv_80_Lay_1 != 99999) || (objProductNew.flt_FineMin_abv_80_Lay_1 != undefined)) {
                    objFine_abv_80_Lay_1.Fine_abv_80_Lay_1.MIN = objProductNew.flt_FineMin_abv_80_Lay_1 != "" ? objProductNew.flt_FineMin_abv_80_Lay_1 : false;
                    objFine_abv_80_Lay_1.Fine_abv_80_Lay_1.MAX = objProductNew.flt_FineMax_abv_80_Lay_1 != "" ? objProductNew.flt_FineMax_abv_80_Lay_1 : false;
                    IsChanged = true;
                }
            }
            else {
                IsChanged = false;
            }
    
            if (IsChanged == true) {
                Object.assign(this.objResult, objFine_abv_80_Lay_1);
            }
            resolve(IsChanged);
        });
    }
    
    validateFine_blw_100_Lay_1(objProductNew) {
        return new Promise((resolve, reject) => {
            const objFine_blw_100_Lay_1 = {
                Fine_blw_100_Lay_1: {
                    MIN: "",
                    MAX: ""
                }
            };
    
            var IsChanged = false;
            if (objProductNew.flt_FineMin_blw_100_Lay_1 != "" && objProductNew.flt_FineMin_blw_100_Lay_1 != null) {
                if ((objProductNew.flt_FineMin_blw_100_Lay_1 != 99999) || (objProductNew.flt_FineMin_blw_100_Lay_1 != undefined)) {
                    objFine_blw_100_Lay_1.Fine_blw_100_Lay_1.MIN = objProductNew.flt_FineMin_blw_100_Lay_1 != "" ? objProductNew.flt_FineMin_blw_100_Lay_1 : false;
                    objFine_blw_100_Lay_1.Fine_blw_100_Lay_1.MAX = objProductNew.flt_FineMax_blw_100_Lay_1 != "" ? objProductNew.flt_FineMax_blw_100_Lay_1 : false;
                    IsChanged = true;
                }
            }
            else {
                IsChanged = false;
            }
    
            if (IsChanged == true) {
                Object.assign(this.objResult, objFine_blw_100_Lay_1);
            }
            resolve(IsChanged);
        });
    }
    
    validateFine_abv_100_Lay_1(objProductNew) {
        return new Promise((resolve, reject) => {
            const objFine_abv_100_Lay_1 = {
                Fine_abv_100_Lay_1: {
                    MIN: "",
                    MAX: ""
                }
            };
    
            var IsChanged = false;
            if (objProductNew.flt_FineMin_abv_100_Lay_1 != "" && objProductNew.flt_FineMin_abv_100_Lay_1 != null) {
                if ((objProductNew.flt_FineMin_abv_100_Lay_1 != 99999) || (objProductNew.flt_FineMin_abv_100_Lay_1 != undefined)) {
                    objFine_abv_100_Lay_1.Fine_abv_100_Lay_1.MIN = objProductNew.flt_FineMin_abv_100_Lay_1 != "" ? objProductNew.flt_FineMin_abv_100_Lay_1 : false;
                    objFine_abv_100_Lay_1.Fine_abv_100_Lay_1.MAX = objProductNew.flt_FineMax_abv_100_Lay_1 != "" ? objProductNew.flt_FineMax_abv_100_Lay_1 : false;
                    IsChanged = true;
                }
            }
            else {
                IsChanged = false;
            }
    
            if (IsChanged == true) {
                Object.assign(this.objResult, objFine_abv_100_Lay_1);
            }
            resolve(IsChanged);
        });
    }
    
    validateFine_Pan_Lay_1(objProductNew) {
        return new Promise((resolve, reject) => {
            const objFine_Pan_Lay_1 = {
                Fine_Pan_Lay_1: {
                    MIN: "",
                    MAX: ""
                }
            };
    
            var IsChanged = false;
            if (objProductNew.flt_FineMin_Pan_Lay_1 != "" && objProductNew.flt_FineMin_Pan_Lay_1 != null) {
                if ((objProductNew.flt_FineMin_Pan_Lay_1 != 99999) || (objProductNew.flt_FineMin_Pan_Lay_1 != undefined)) {
                    objFine_Pan_Lay_1.Fine_Pan_Lay_1.MIN = objProductNew.flt_FineMin_Pan_Lay_1 != "" ? objProductNew.flt_FineMin_Pan_Lay_1 : false;
                    objFine_Pan_Lay_1.Fine_Pan_Lay_1.MAX = objProductNew.flt_FineMax_Pan_Lay_1 != "" ? objProductNew.flt_FineMax_Pan_Lay_1 : false;
                    IsChanged = true;
                }
            }
            else {
                IsChanged = false;
            }
    
            if (IsChanged == true) {
                Object.assign(this.objResult, objFine_Pan_Lay_1);
            }
            resolve(IsChanged);
        });
    }

    validateFine_blw_30_Lay_2(objProductNew) {
        return new Promise((resolve, reject) => {
            const objFine_blw_30_Lay_2 = {
                Fine_blw_30_Lay_2: {
                    MIN: "",
                    MAX: ""
                }
            };
    
            var IsChanged = false;
            if (objProductNew.flt_FineMin_blw_30_Lay_2 != "" && objProductNew.flt_FineMin_blw_30_Lay_2 != null) {
                if ((objProductNew.flt_FineMin_blw_30_Lay_2 != 99999) || (objProductNew.flt_FineMin_blw_30_Lay_2 != undefined)) {
                    objFine_blw_30_Lay_2.Fine_blw_30_Lay_2.MIN = objProductNew.flt_FineMin_blw_30_Lay_2 != "" ? objProductNew.flt_FineMin_blw_30_Lay_2 : false;
                    objFine_blw_30_Lay_2.Fine_blw_30_Lay_2.MAX = objProductNew.flt_FineMax_blw_30_Lay_2 != "" ? objProductNew.flt_FineMax_blw_30_Lay_2 : false;
                    IsChanged = true;
                }
            }
            else {
                IsChanged = false;
            }
    
            if (IsChanged == true) {
                Object.assign(this.objResult, objFine_blw_30_Lay_2);
            }
            resolve(IsChanged);
        });
    }
    
    validateFine_abv_30_Lay_2(objProductNew) {
        return new Promise((resolve, reject) => {
            const objFine_abv_30_Lay_2 = {
                Fine_abv_30_Lay_2: {
                    MIN: "",
                    MAX: ""
                }
            };
    
            var IsChanged = false;
            if (objProductNew.flt_FineMin_abv_30_Lay_2 != "" && objProductNew.flt_FineMin_abv_30_Lay_2 != null) {
                if ((objProductNew.flt_FineMin_abv_30_Lay_2 != 99999) || (objProductNew.flt_FineMin_abv_30_Lay_2 != undefined)) {
                    objFine_abv_30_Lay_2.Fine_abv_30_Lay_2.MIN = objProductNew.flt_FineMin_abv_30_Lay_2 != "" ? objProductNew.flt_FineMin_abv_30_Lay_2 : false;
                    objFine_abv_30_Lay_2.Fine_abv_30_Lay_2.MAX = objProductNew.flt_FineMax_abv_30_Lay_2 != "" ? objProductNew.flt_FineMax_abv_30_Lay_2 : false;
                    IsChanged = true;
                }
            }
            else {
                IsChanged = false;
            }
    
            if (IsChanged == true) {
                Object.assign(this.objResult, objFine_abv_30_Lay_2);
            }
            resolve(IsChanged);
        });
    }
    
    validateFine_blw_40_Lay_2(objProductNew) {
        return new Promise((resolve, reject) => {
            const objFine_blw_40_Lay_2 = {
                Fine_blw_40_Lay_2: {
                    MIN: "",
                    MAX: ""
                }
            };
    
            var IsChanged = false;
            if (objProductNew.flt_FineMin_blw_40_Lay_2 != "" && objProductNew.flt_FineMin_blw_40_Lay_2 != null) {
                if ((objProductNew.flt_FineMin_blw_40_Lay_2 != 99999) || (objProductNew.flt_FineMin_blw_40_Lay_2 != undefined)) {
                    objFine_blw_40_Lay_2.Fine_blw_40_Lay_2.MIN = objProductNew.flt_FineMin_blw_40_Lay_2 != "" ? objProductNew.flt_FineMin_blw_40_Lay_2 : false;
                    objFine_blw_40_Lay_2.Fine_blw_40_Lay_2.MAX = objProductNew.flt_FineMax_blw_40_Lay_2 != "" ? objProductNew.flt_FineMax_blw_40_Lay_2 : false;
                    IsChanged = true;
                }
            }
            else {
                IsChanged = false;
            }
    
            if (IsChanged == true) {
                Object.assign(this.objResult, objFine_blw_40_Lay_2);
            }
            resolve(IsChanged);
        });
    }
    
    validateFine_abv_40_Lay_2(objProductNew) {
        return new Promise((resolve, reject) => {
            const objFine_abv_40_Lay_2 = {
                Fine_abv_40_Lay_2: {
                    MIN: "",
                    MAX: ""
                }
            };
    
            var IsChanged = false;
            if (objProductNew.flt_FineMin_abv_40_Lay_2 != "" && objProductNew.flt_FineMin_abv_40_Lay_2 != null) {
                if ((objProductNew.flt_FineMin_abv_40_Lay_2 != 99999) || (objProductNew.flt_FineMin_abv_40_Lay_2 != undefined)) {
                    objFine_abv_40_Lay_2.Fine_abv_40_Lay_2.MIN = objProductNew.flt_FineMin_abv_40_Lay_2 != "" ? objProductNew.flt_FineMin_abv_40_Lay_2 : false;
                    objFine_abv_40_Lay_2.Fine_abv_40_Lay_2.MAX = objProductNew.flt_FineMax_abv_40_Lay_2 != "" ? objProductNew.flt_FineMax_abv_40_Lay_2 : false;
                    IsChanged = true;
                }
            }
            else {
                IsChanged = false;
            }
    
            if (IsChanged == true) {
                Object.assign(this.objResult, objFine_abv_40_Lay_2);
            }
            resolve(IsChanged);
        });
    }
    
    validateFine_blw_60_Lay_2(objProductNew) {
        return new Promise((resolve, reject) => {
            const objFine_blw_60_Lay_2 = {
                Fine_blw_60_Lay_2: {
                    MIN: "",
                    MAX: ""
                }
            };
    
            var IsChanged = false;
            if (objProductNew.flt_FineMin_blw_60_Lay_2 != "" && objProductNew.flt_FineMin_blw_60_Lay_2 != null) {
                if ((objProductNew.flt_FineMin_blw_60_Lay_2 != 99999) || (objProductNew.flt_FineMin_blw_60_Lay_2 != undefined)) {
                    objFine_blw_60_Lay_2.Fine_blw_60_Lay_2.MIN = objProductNew.flt_FineMin_blw_60_Lay_2 != "" ? objProductNew.flt_FineMin_blw_60_Lay_2 : false;
                    objFine_blw_60_Lay_2.Fine_blw_60_Lay_2.MAX = objProductNew.flt_FineMax_blw_60_Lay_2 != "" ? objProductNew.flt_FineMax_blw_60_Lay_2 : false;
                    IsChanged = true;
                }
            }
            else {
                IsChanged = false;
            }
    
            if (IsChanged == true) {
                Object.assign(this.objResult, objFine_blw_60_Lay_2);
            }
            resolve(IsChanged);
        });
    }
    
    validateFine_abv_60_Lay_2(objProductNew) {
        return new Promise((resolve, reject) => {
            const objFine_abv_60_Lay_2 = {
                Fine_abv_60_Lay_2: {
                    MIN: "",
                    MAX: ""
                }
            };
    
            var IsChanged = false;
            if (objProductNew.flt_FineMin_abv_60_Lay_2 != "" && objProductNew.flt_FineMin_abv_60_Lay_2 != null) {
                if ((objProductNew.flt_FineMin_abv_60_Lay_2 != 99999) || (objProductNew.flt_FineMin_abv_60_Lay_2 != undefined)) {
                    objFine_abv_60_Lay_2.Fine_abv_60_Lay_2.MIN = objProductNew.flt_FineMin_abv_60_Lay_2 != "" ? objProductNew.flt_FineMin_abv_60_Lay_2 : false;
                    objFine_abv_60_Lay_2.Fine_abv_60_Lay_2.MAX = objProductNew.flt_FineMax_abv_60_Lay_2 != "" ? objProductNew.flt_FineMax_abv_60_Lay_2 : false;
                    IsChanged = true;
                }
            }
            else {
                IsChanged = false;
            }
    
            if (IsChanged == true) {
                Object.assign(this.objResult, objFine_abv_60_Lay_2);
            }
            resolve(IsChanged);
        });
    }
    
    validateFine_blw_80_Lay_2(objProductNew) {
        return new Promise((resolve, reject) => {
            const objFine_blw_80_Lay_2 = {
                Fine_blw_80_Lay_2: {
                    MIN: "",
                    MAX: ""
                }
            };
    
            var IsChanged = false;
            if (objProductNew.flt_FineMin_blw_80_Lay_2 != "" && objProductNew.flt_FineMin_blw_80_Lay_2 != null) {
                if ((objProductNew.flt_FineMin_blw_80_Lay_2 != 99999) || (objProductNew.flt_FineMin_blw_80_Lay_2 != undefined)) {
                    objFine_blw_80_Lay_2.Fine_blw_80_Lay_2.MIN = objProductNew.flt_FineMin_blw_80_Lay_2 != "" ? objProductNew.flt_FineMin_blw_80_Lay_2 : false;
                    objFine_blw_80_Lay_2.Fine_blw_80_Lay_2.MAX = objProductNew.flt_FineMax_blw_80_Lay_2 != "" ? objProductNew.flt_FineMax_blw_80_Lay_2 : false;
                    IsChanged = true;
                }
            }
            else {
                IsChanged = false;
            }
    
            if (IsChanged == true) {
                Object.assign(this.objResult, objFine_blw_80_Lay_2);
            }
            resolve(IsChanged);
        });
    }
    
    validateFine_abv_80_Lay_2(objProductNew) {
        return new Promise((resolve, reject) => {
            const objFine_abv_80_Lay_2 = {
                Fine_abv_80_Lay_2: {
                    MIN: "",
                    MAX: ""
                }
            };
    
            var IsChanged = false;
            if (objProductNew.flt_FineMin_abv_80_Lay_2 != "" && objProductNew.flt_FineMin_abv_80_Lay_2 != null) {
                if ((objProductNew.flt_FineMin_abv_80_Lay_2 != 99999) || (objProductNew.flt_FineMin_abv_80_Lay_2 != undefined)) {
                    objFine_abv_80_Lay_2.Fine_abv_80_Lay_2.MIN = objProductNew.flt_FineMin_abv_80_Lay_2 != "" ? objProductNew.flt_FineMin_abv_80_Lay_2 : false;
                    objFine_abv_80_Lay_2.Fine_abv_80_Lay_2.MAX = objProductNew.flt_FineMax_abv_80_Lay_2 != "" ? objProductNew.flt_FineMax_abv_80_Lay_2 : false;
                    IsChanged = true;
                }
            }
            else {
                IsChanged = false;
            }
    
            if (IsChanged == true) {
                Object.assign(this.objResult, objFine_abv_80_Lay_2);
            }
            resolve(IsChanged);
        });
    }
    
    validateFine_blw_100_Lay_2(objProductNew) {
        return new Promise((resolve, reject) => {
            const objFine_blw_100_Lay_2 = {
                Fine_blw_100_Lay_2: {
                    MIN: "",
                    MAX: ""
                }
            };
    
            var IsChanged = false;
            if (objProductNew.flt_FineMin_blw_100_Lay_2 != "" && objProductNew.flt_FineMin_blw_100_Lay_2 != null) {
                if ((objProductNew.flt_FineMin_blw_100_Lay_2 != 99999) || (objProductNew.flt_FineMin_blw_100_Lay_2 != undefined)) {
                    objFine_blw_100_Lay_2.Fine_blw_100_Lay_2.MIN = objProductNew.flt_FineMin_blw_100_Lay_2 != "" ? objProductNew.flt_FineMin_blw_100_Lay_2 : false;
                    objFine_blw_100_Lay_2.Fine_blw_100_Lay_2.MAX = objProductNew.flt_FineMax_blw_100_Lay_2 != "" ? objProductNew.flt_FineMax_blw_100_Lay_2 : false;
                    IsChanged = true;
                }
            }
            else {
                IsChanged = false;
            }
    
            if (IsChanged == true) {
                Object.assign(this.objResult, objFine_blw_100_Lay_2);
            }
            resolve(IsChanged);
        });
    }
    
    validateFine_abv_100_Lay_2(objProductNew) {
        return new Promise((resolve, reject) => {
            const objFine_abv_100_Lay_2 = {
                Fine_abv_100_Lay_2: {
                    MIN: "",
                    MAX: ""
                }
            };
    
            var IsChanged = false;
            if (objProductNew.flt_FineMin_abv_100_Lay_2 != "" && objProductNew.flt_FineMin_abv_100_Lay_2 != null) {
                if ((objProductNew.flt_FineMin_abv_100_Lay_2 != 99999) || (objProductNew.flt_FineMin_abv_100_Lay_2 != undefined)) {
                    objFine_abv_100_Lay_2.Fine_abv_100_Lay_2.MIN = objProductNew.flt_FineMin_abv_100_Lay_2 != "" ? objProductNew.flt_FineMin_abv_100_Lay_2 : false;
                    objFine_abv_100_Lay_2.Fine_abv_100_Lay_2.MAX = objProductNew.flt_FineMax_abv_100_Lay_2 != "" ? objProductNew.flt_FineMax_abv_100_Lay_2 : false;
                    IsChanged = true;
                }
            }
            else {
                IsChanged = false;
            }
    
            if (IsChanged == true) {
                Object.assign(this.objResult, objFine_abv_100_Lay_2);
            }
            resolve(IsChanged);
        });
    }
    
    validateFine_Pan_Lay_2(objProductNew) {
        return new Promise((resolve, reject) => {
            const objFine_Pan_Lay_2 = {
                Fine_Pan_Lay_2: {
                    MIN: "",
                    MAX: ""
                }
            };
    
            var IsChanged = false;
            if (objProductNew.flt_FineMin_Pan_Lay_2 != "" && objProductNew.flt_FineMin_Pan_Lay_2 != null) {
                if ((objProductNew.flt_FineMin_Pan_Lay_2 != 99999) || (objProductNew.flt_FineMin_Pan_Lay_2 != undefined)) {
                    objFine_Pan_Lay_2.Fine_Pan_Lay_2.MIN = objProductNew.flt_FineMin_Pan_Lay_2 != "" ? objProductNew.flt_FineMin_Pan_Lay_2 : false;
                    objFine_Pan_Lay_2.Fine_Pan_Lay_2.MAX = objProductNew.flt_FineMax_Pan_Lay_2 != "" ? objProductNew.flt_FineMax_Pan_Lay_2 : false;
                    IsChanged = true;
                }
            }
            else {
                IsChanged = false;
            }
    
            if (IsChanged == true) {
                Object.assign(this.objResult, objFine_Pan_Lay_2);
            }
            resolve(IsChanged);
        });
    }

    validateFine_Lay_1(objProductNew) {
        return new Promise((resolve, reject) => {
            const objFine_Lay_1 = {
                Fine_Lay_1: {
                    MIN: "",
                    MAX: ""
                }
            };

            var IsChanged = false;
            if (objProductNew.flt_FineMin_Lay_1 != "" && objProductNew.flt_FineMin_Lay_1 != null) {
                if ((objProductNew.flt_FineMin_Lay_1 != 99999) || (objProductNew.flt_FineMin_Lay_1 != undefined)) {
                    objFine_Lay_1.Fine_Lay_1.MIN = objProductNew.flt_FineMin_Lay_1 != "" ? objProductNew.flt_FineMin_Lay_1 : false;
                    objFine_Lay_1.Fine_Lay_1.MAX = objProductNew.flt_FineMax_Lay_1 != "" ? objProductNew.flt_FineMax_Lay_1 : false;
                    IsChanged = true;
                }
            }
            else {
                IsChanged = false;
            }

            if (IsChanged == true) {
                Object.assign(this.objResult, objFine_Lay_1);
            }
            resolve(IsChanged);
        });
    }

    validateFine_Lay_2(objProductNew) {
        return new Promise((resolve, reject) => {
            const objFine_Lay_2 = {
                Fine_Lay_2: {
                    MIN: "",
                    MAX: ""
                }
            };

            var IsChanged = false;
            if (objProductNew.flt_FineMin_Lay_2 != "" && objProductNew.flt_FineMin_Lay_2 != null) {
                if ((objProductNew.flt_FineMin_Lay_2 != 99999) || (objProductNew.flt_FineMin_Lay_2 != undefined)) {
                    objFine_Lay_2.Fine_Lay_2.MIN = objProductNew.flt_FineMin_Lay_2 != "" ? objProductNew.flt_FineMin_Lay_2 : false;
                    objFine_Lay_2.Fine_Lay_2.MAX = objProductNew.flt_FineMax_Lay_2 != "" ? objProductNew.flt_FineMax_Lay_2 : false;
                    IsChanged = true;
                }
            }
            else {
                IsChanged = false;
            }

            if (IsChanged == true) {
                Object.assign(this.objResult, objFine_Lay_2);
            }
            resolve(IsChanged);
        });
    }

    validateParticleSizeDistribution(objProductNew) {
        return new Promise((resolve, reject) => {
            const objPSD = {
                ParticleSizeDistribution: {
                    MIN: "",
                    MAX: ""
                }
            };

            var IsChanged = false;

            if (objProductNew.flt_PSDMin != "" && objProductNew.flt_PSDMin != null) {
                if ((objProductNew.flt_PSDMin != 99999) || (objProductNew.flt_PSDMin != undefined)) {
                    objPSD.ParticleSizeDistribution.MIN = objProductNew.flt_PSDMin != "" ? objProductNew.flt_PSDMin : false;
                    objPSD.ParticleSizeDistribution.MAX = objProductNew.flt_PSDMax != "" ? objProductNew.flt_PSDMax : false;
                    IsChanged = true;
                }
            }
            else {
                IsChanged = false;
            }

            if (IsChanged == true) {
                Object.assign(this.objResult, objPSD);
            }
            resolve(IsChanged);
        });
    }

    validateParticleSizeDistribution_abv_20(objProductNew) {
        return new Promise((resolve, reject) => {
            const objPSD_abv_20 = {
                ParticleSizeDistribution_abv_20: {
                    MIN: "",
                    MAX: ""
                }
            };

            var IsChanged = false;

            if (objProductNew.flt_PSDMin_abv_20 != "" && objProductNew.flt_PSDMin_abv_20 != null) {
                if ((objProductNew.flt_PSDMin_abv_20 != 99999) || (objProductNew.flt_PSDMin_abv_20 != undefined)) {
                    objPSD_abv_20.ParticleSizeDistribution_abv_20.MIN = objProductNew.flt_PSDMin_abv_20 != "" ? objProductNew.flt_PSDMin_abv_20 : false;
                    objPSD_abv_20.ParticleSizeDistribution_abv_20.MAX = objProductNew.flt_PSDMax_abv_20 != "" ? objProductNew.flt_PSDMax_abv_20 : false;
                    IsChanged = true;
                }
            }
            else {
                IsChanged = false;
            }

            if (IsChanged == true) {
                Object.assign(this.objResult, objPSD_abv_20);
            }
            resolve(IsChanged);
        });
    }

    validateParticleSizeDistribution_abv_40(objProductNew) {
        return new Promise((resolve, reject) => {
            const objPSD_abv_40 = {
                ParticleSizeDistribution_abv_40: {
                    MIN: "",
                    MAX: ""
                }
            };
    
            var IsChanged = false;
    
            if (objProductNew.flt_PSDMin_abv_40 != "" && objProductNew.flt_PSDMin_abv_40 != null) {
                if ((objProductNew.flt_PSDMin_abv_40 != 99999) || (objProductNew.flt_PSDMin_abv_40 != undefined)) {
                    objPSD_abv_40.ParticleSizeDistribution_abv_40.MIN = objProductNew.flt_PSDMin_abv_40 != "" ? objProductNew.flt_PSDMin_abv_40 : false;
                    objPSD_abv_40.ParticleSizeDistribution_abv_40.MAX = objProductNew.flt_PSDMax_abv_40 != "" ? objProductNew.flt_PSDMax_abv_40 : false;
                    IsChanged = true;
                }
            }
            else {
                IsChanged = false;
            }
    
            if (IsChanged == true) {
                Object.assign(this.objResult, objPSD_abv_40);
            }
            resolve(IsChanged);
        });
    }

    validateParticleSizeDistribution_abv_60(objProductNew) {
        return new Promise((resolve, reject) => {
            const objPSD_abv_60 = {
                ParticleSizeDistribution_abv_60: {
                    MIN: "",
                    MAX: ""
                }
            };
    
            var IsChanged = false;
    
            if (objProductNew.flt_PSDMin_abv_60 != "" && objProductNew.flt_PSDMin_abv_60 != null) {
                if ((objProductNew.flt_PSDMin_abv_60 != 99999) || (objProductNew.flt_PSDMin_abv_60 != undefined)) {
                    objPSD_abv_60.ParticleSizeDistribution_abv_60.MIN = objProductNew.flt_PSDMin_abv_60 != "" ? objProductNew.flt_PSDMin_abv_60 : false;
                    objPSD_abv_60.ParticleSizeDistribution_abv_60.MAX = objProductNew.flt_PSDMax_abv_60 != "" ? objProductNew.flt_PSDMax_abv_60 : false;
                    IsChanged = true;
                }
            }
            else {
                IsChanged = false;
            }
    
            if (IsChanged == true) {
                Object.assign(this.objResult, objPSD_abv_60);
            }
            resolve(IsChanged);
        });
    }

    validateParticleSizeDistribution_abv_80(objProductNew) {
        return new Promise((resolve, reject) => {
            const objPSD_abv_80 = {
                ParticleSizeDistribution_abv_80: {
                    MIN: "",
                    MAX: ""
                }
            };
    
            var IsChanged = false;
    
            if (objProductNew.flt_PSDMin_abv_80 != "" && objProductNew.flt_PSDMin_abv_80 != null) {
                if ((objProductNew.flt_PSDMin_abv_80 != 99999) || (objProductNew.flt_PSDMin_abv_80 != undefined)) {
                    objPSD_abv_80.ParticleSizeDistribution_abv_80.MIN = objProductNew.flt_PSDMin_abv_80 != "" ? objProductNew.flt_PSDMin_abv_80 : false;
                    objPSD_abv_80.ParticleSizeDistribution_abv_80.MAX = objProductNew.flt_PSDMax_abv_80 != "" ? objProductNew.flt_PSDMax_abv_80 : false;
                    IsChanged = true;
                }
            }
            else {
                IsChanged = false;
            }
    
            if (IsChanged == true) {
                Object.assign(this.objResult, objPSD_abv_80);
            }
            resolve(IsChanged);
        });
    }

    validateParticleSizeDistribution_abv_100(objProductNew) {
        return new Promise((resolve, reject) => {
            const objPSD_abv_100 = {
                ParticleSizeDistribution_abv_100: {
                    MIN: "",
                    MAX: ""
                }
            };
    
            var IsChanged = false;
    
            if (objProductNew.flt_PSDMin_abv_100 != "" && objProductNew.flt_PSDMin_abv_100 != null) {
                if ((objProductNew.flt_PSDMin_abv_100 != 99999) || (objProductNew.flt_PSDMin_abv_100 != undefined)) {
                    objPSD_abv_100.ParticleSizeDistribution_abv_100.MIN = objProductNew.flt_PSDMin_abv_100 != "" ? objProductNew.flt_PSDMin_abv_100 : false;
                    objPSD_abv_100.ParticleSizeDistribution_abv_100.MAX = objProductNew.flt_PSDMax_abv_100 != "" ? objProductNew.flt_PSDMax_abv_100 : false;
                    IsChanged = true;
                }
            }
            else {
                IsChanged = false;
            }
    
            if (IsChanged == true) {
                Object.assign(this.objResult, objPSD_abv_100);
            }
            resolve(IsChanged);
        });
    }

    validateParticleSizeDistribution_blw_100(objProductNew) {
        return new Promise((resolve, reject) => {
            const objPSD_blw_100 = {
                ParticleSizeDistribution_blw_100: {
                    MIN: "",
                    MAX: ""
                }
            };
    
            var IsChanged = false;
    
            if (objProductNew.flt_PSDMin_blw_100 != "" && objProductNew.flt_PSDMin_blw_100 != null) {
                if ((objProductNew.flt_PSDMin_blw_100 != 99999) || (objProductNew.flt_PSDMin_blw_100 != undefined)) {
                    objPSD_blw_100.ParticleSizeDistribution_blw_100.MIN = objProductNew.flt_PSDMin_blw_100 != "" ? objProductNew.flt_PSDMin_blw_100 : false;
                    objPSD_blw_100.ParticleSizeDistribution_blw_100.MAX = objProductNew.flt_PSDMax_blw_100 != "" ? objProductNew.flt_PSDMax_blw_100 : false;
                    IsChanged = true;
                }
            }
            else {
                IsChanged = false;
            }
    
            if (IsChanged == true) {
                Object.assign(this.objResult, objPSD_blw_100);
            }
            resolve(IsChanged);
        });
    }

    validateParticleSizeDistribution_Lay_1(objProductNew) {
        return new Promise((resolve, reject) => {
            const objPSD_Lay_1 = {
                ParticleSizeDistribution_Lay_1: {
                    MIN: "",
                    MAX: ""
                }
            };
    
            var IsChanged = false;
    
            if (objProductNew.flt_PSDMin_Lay_1 != "" && objProductNew.flt_PSDMin_Lay_1 != null) {
                if ((objProductNew.flt_PSDMin_Lay_1 != 99999) || (objProductNew.flt_PSDMin_Lay_1 != undefined)) {
                    objPSD_Lay_1.ParticleSizeDistribution_Lay_1.MIN = objProductNew.flt_PSDMin_Lay_1 != "" ? objProductNew.flt_PSDMin_Lay_1 : false;
                    objPSD_Lay_1.ParticleSizeDistribution_Lay_1.MAX = objProductNew.flt_PSDMax_Lay_1 != "" ? objProductNew.flt_PSDMax_Lay_1 : false;
                    IsChanged = true;
                }
            }
            else {
                IsChanged = false;
            }
    
            if (IsChanged == true) {
                Object.assign(this.objResult, objPSD_Lay_1);
            }
            resolve(IsChanged);
        });
    }

    validateParticleSizeDistribution_abv_20_Lay_1(objProductNew) {
        return new Promise((resolve, reject) => {
            const objPSD_abv_20_Lay_1 = {
                ParticleSizeDistribution_abv_20_Lay_1: {
                    MIN: "",
                    MAX: ""
                }
            };

            var IsChanged = false;

            if (objProductNew.flt_PSDMin_abv_20_Lay_1 != "" && objProductNew.flt_PSDMin_abv_20_Lay_1 != null) {
                if ((objProductNew.flt_PSDMin_abv_20_Lay_1 != 99999) || (objProductNew.flt_PSDMin_abv_20_Lay_1 != undefined)) {
                    objPSD_abv_20_Lay_1.ParticleSizeDistribution_abv_20_Lay_1.MIN = objProductNew.flt_PSDMin_abv_20_Lay_1 != "" ? objProductNew.flt_PSDMin_abv_20_Lay_1 : false;
                    objPSD_abv_20_Lay_1.ParticleSizeDistribution_abv_20_Lay_1.MAX = objProductNew.flt_PSDMax_abv_20_Lay_1 != "" ? objProductNew.flt_PSDMax_abv_20_Lay_1 : false;
                    IsChanged = true;
                }
            }
            else {
                IsChanged = false;
            }

            if (IsChanged == true) {
                Object.assign(this.objResult, objPSD_abv_20_Lay_1);
            }
            resolve(IsChanged);
        });
    }

    validateParticleSizeDistribution_abv_40_Lay_1(objProductNew) {
        return new Promise((resolve, reject) => {
            const objPSD_abv_40_Lay_1 = {
                ParticleSizeDistribution_abv_40_Lay_1: {
                    MIN: "",
                    MAX: ""
                }
            };

            var IsChanged = false;

            if (objProductNew.flt_PSDMin_abv_40_Lay_1 != "" && objProductNew.flt_PSDMin_abv_40_Lay_1 != null) {
                if ((objProductNew.flt_PSDMin_abv_40_Lay_1 != 99999) || (objProductNew.flt_PSDMin_abv_40_Lay_1 != undefined)) {
                    objPSD_abv_40_Lay_1.ParticleSizeDistribution_abv_40_Lay_1.MIN = objProductNew.flt_PSDMin_abv_40_Lay_1 != "" ? objProductNew.flt_PSDMin_abv_40_Lay_1 : false;
                    objPSD_abv_40_Lay_1.ParticleSizeDistribution_abv_40_Lay_1.MAX = objProductNew.flt_PSDMax_abv_40_Lay_1 != "" ? objProductNew.flt_PSDMax_abv_40_Lay_1 : false;
                    IsChanged = true;
                }
            }
            else {
                IsChanged = false;
            }

            if (IsChanged == true) {
                Object.assign(this.objResult, objPSD_abv_40_Lay_1);
            }
            resolve(IsChanged);
        });
    }

    validateParticleSizeDistribution_abv_60_Lay_1(objProductNew) {
        return new Promise((resolve, reject) => {
            const objPSD_abv_60_Lay_1 = {
                ParticleSizeDistribution_abv_60_Lay_1: {
                    MIN: "",
                    MAX: ""
                }
            };

            var IsChanged = false;

            if (objProductNew.flt_PSDMin_abv_60_Lay_1 != "" && objProductNew.flt_PSDMin_abv_60_Lay_1 != null) {
                if ((objProductNew.flt_PSDMin_abv_60_Lay_1 != 99999) || (objProductNew.flt_PSDMin_abv_60_Lay_1 != undefined)) {
                    objPSD_abv_60_Lay_1.ParticleSizeDistribution_abv_60_Lay_1.MIN = objProductNew.flt_PSDMin_abv_60_Lay_1 != "" ? objProductNew.flt_PSDMin_abv_60_Lay_1 : false;
                    objPSD_abv_60_Lay_1.ParticleSizeDistribution_abv_60_Lay_1.MAX = objProductNew.flt_PSDMax_abv_60_Lay_1 != "" ? objProductNew.flt_PSDMax_abv_60_Lay_1 : false;
                    IsChanged = true;
                }
            }
            else {
                IsChanged = false;
            }

            if (IsChanged == true) {
                Object.assign(this.objResult, objPSD_abv_60_Lay_1);
            }
            resolve(IsChanged);
        });
    }

    validateParticleSizeDistribution_abv_80_Lay_1(objProductNew) {
        return new Promise((resolve, reject) => {
            const objPSD_abv_80_Lay_1 = {
                ParticleSizeDistribution_abv_80_Lay_1: {
                    MIN: "",
                    MAX: ""
                }
            };

            var IsChanged = false;

            if (objProductNew.flt_PSDMin_abv_80_Lay_1 != "" && objProductNew.flt_PSDMin_abv_80_Lay_1 != null) {
                if ((objProductNew.flt_PSDMin_abv_80_Lay_1 != 99999) || (objProductNew.flt_PSDMin_abv_80_Lay_1 != undefined)) {
                    objPSD_abv_80_Lay_1.ParticleSizeDistribution_abv_80_Lay_1.MIN = objProductNew.flt_PSDMin_abv_80_Lay_1 != "" ? objProductNew.flt_PSDMin_abv_80_Lay_1 : false;
                    objPSD_abv_80_Lay_1.ParticleSizeDistribution_abv_80_Lay_1.MAX = objProductNew.flt_PSDMax_abv_80_Lay_1 != "" ? objProductNew.flt_PSDMax_abv_80_Lay_1 : false;
                    IsChanged = true;
                }
            }
            else {
                IsChanged = false;
            }

            if (IsChanged == true) {
                Object.assign(this.objResult, objPSD_abv_80_Lay_1);
            }
            resolve(IsChanged);
        });
    }

    validateParticleSizeDistribution_abv_100_Lay_1(objProductNew) {
        return new Promise((resolve, reject) => {
            const objPSD_abv_100_Lay_1 = {
                ParticleSizeDistribution_abv_100_Lay_1: {
                    MIN: "",
                    MAX: ""
                }
            };

            var IsChanged = false;

            if (objProductNew.flt_PSDMin_abv_100_Lay_1 != "" && objProductNew.flt_PSDMin_abv_100_Lay_1 != null) {
                if ((objProductNew.flt_PSDMin_abv_100_Lay_1 != 99999) || (objProductNew.flt_PSDMin_abv_100_Lay_1 != undefined)) {
                    objPSD_abv_100_Lay_1.ParticleSizeDistribution_abv_100_Lay_1.MIN = objProductNew.flt_PSDMin_abv_100_Lay_1 != "" ? objProductNew.flt_PSDMin_abv_100_Lay_1 : false;
                    objPSD_abv_100_Lay_1.ParticleSizeDistribution_abv_100_Lay_1.MAX = objProductNew.flt_PSDMax_abv_100_Lay_1 != "" ? objProductNew.flt_PSDMax_abv_100_Lay_1 : false;
                    IsChanged = true;
                }
            }
            else {
                IsChanged = false;
            }

            if (IsChanged == true) {
                Object.assign(this.objResult, objPSD_abv_100_Lay_1);
            }
            resolve(IsChanged);
        });
    }

    validateParticleSizeDistribution_blw_100_Lay_1(objProductNew) {
        return new Promise((resolve, reject) => {
            const objPSD_blw_100_Lay_1 = {
                ParticleSizeDistribution_blw_100_Lay_1: {
                    MIN: "",
                    MAX: ""
                }
            };

            var IsChanged = false;

            if (objProductNew.flt_PSDMin_blw_100_Lay_1 != "" && objProductNew.flt_PSDMin_blw_100_Lay_1 != null) {
                if ((objProductNew.flt_PSDMin_blw_100_Lay_1 != 99999) || (objProductNew.flt_PSDMin_blw_100_Lay_1 != undefined)) {
                    objPSD_blw_100_Lay_1.ParticleSizeDistribution_blw_100_Lay_1.MIN = objProductNew.flt_PSDMin_blw_100_Lay_1 != "" ? objProductNew.flt_PSDMin_blw_100_Lay_1 : false;
                    objPSD_blw_100_Lay_1.ParticleSizeDistribution_blw_100_Lay_1.MAX = objProductNew.flt_PSDMax_blw_100_Lay_1 != "" ? objProductNew.flt_PSDMax_blw_100_Lay_1 : false;
                    IsChanged = true;
                }
            }
            else {
                IsChanged = false;
            }

            if (IsChanged == true) {
                Object.assign(this.objResult, objPSD_blw_100_Lay_1);
            }
            resolve(IsChanged);
        });
    }

    validateParticleSeizing_Lay_1(objProductNew) {
        return new Promise((resolve, reject) => {
            const objParticleSeizing_Lay_1 = {
                ParticleSizing_Lay_1: {
                    MIN: "",
                    MAX: ""
                }
            };
    
            var IsChanged = false;
    
            if (objProductNew.flt_PartSizingMin_Lay_1 != "" && objProductNew.flt_PartSizingMin_Lay_1 != null) {
                if ((objProductNew.flt_PartSizingMin_Lay_1 != 99999) || (objProductNew.flt_PartSizingMin_Lay_1 != undefined)) {
                    objParticleSeizing_Lay_1.ParticleSizing_Lay_1.MIN = objProductNew.flt_PartSizingMin_Lay_1 != "" ? objProductNew.flt_PartSizingMin_Lay_1 : false;
                    objParticleSeizing_Lay_1.ParticleSizing_Lay_1.MAX = objProductNew.flt_PartSizingMax_Lay_1 != "" ? objProductNew.flt_PartSizingMax_Lay_1 : false;
                    IsChanged = true;
                }
            }
            else {
                IsChanged = false;
            }
    
            if (IsChanged == true) {
                Object.assign(this.objResult, objParticleSeizing_Lay_1);
            }
            resolve(IsChanged);
        })
    }

    validateParticleSeizing_Lay_2(objProductNew) {
        return new Promise((resolve, reject) => {
            const objParticleSeizing_Lay_2 = {
                ParticleSizing_Lay_2: {
                    MIN: "",
                    MAX: ""
                }
            };
    
            var IsChanged = false;
    
            if (objProductNew.flt_PartSizingMin_Lay_2 != "" && objProductNew.flt_PartSizingMin_Lay_2 != null) {
                if ((objProductNew.flt_PartSizingMin_Lay_2 != 99999) || (objProductNew.flt_PartSizingMin_Lay_2 != undefined)) {
                    objParticleSeizing_Lay_2.ParticleSizing_Lay_2.MIN = objProductNew.flt_PartSizingMin_Lay_2 != "" ? objProductNew.flt_PartSizingMin_Lay_2 : false;
                    objParticleSeizing_Lay_2.ParticleSizing_Lay_2.MAX = objProductNew.flt_PartSizingMax_Lay_2 != "" ? objProductNew.flt_PartSizingMax_Lay_2 : false;
                    IsChanged = true;
                }
            }
            else {
                IsChanged = false;
            }
    
            if (IsChanged == true) {
                Object.assign(this.objResult, objParticleSeizing_Lay_2);
            }
            resolve(IsChanged);
        })
    }

}
module.exports = NewProductAuditGranu;