class ProductTablet {
    /**
     * It will return a Object For Individual 
     * @param {*} req Request Object
     * @param {*} reqCoatedObject Individual Coated Data Object
     */
    getIndividualObject(req, reqCoatedObject = false) {
        var indGraphOn, blnIndLimitOn, indGraphCoatedOn, blnIndCoatedLimitOn;
        indGraphOn = req.str_IndGraphOn == "Standard" ? 0 : 1;
        blnIndLimitOn = req.str_IndLimitOn == "Actual" ? 0 : 1; //Actual = false(0) , Percentage = True (1)
        indGraphCoatedOn = req.str_IndGraphOnCoat == "Standard" ? 0 : 1;
        blnIndCoatedLimitOn = req.str_IndLimitOnCoat == "Actual" ? 0 : 1;

        const objIndividual = 
        {
            Param1_Nom: req.flt_IndStd,
            Param1_T1Neg: req.flt_IndT1Neg ,
            Param1_T1Pos: req.flt_IndT1Pos ,
            Param1_IniQty:req.int_IndQtyInitial,
            Param1_RegQty:req.int_IndQtyRegular,
            Param1_T2Neg: req.flt_IndT2Neg ,
            Param1_T2Pos: req.flt_IndT2Pos ,
            Param1_DP: req.int_IndDP ,
            Param1_IsOnStd: indGraphOn ,
            Param1_LimitOn: blnIndLimitOn ,
            Param1_NMTTab: req.int_IndNMTTabCnt ,
            Param1_Nomenclature: req.str_ind_nomNomnclature == undefined ? "NA" : req.str_ind_nomNomnclature ,
            Param1_Unit: req.str_unit_Balance 
        }

        const objIndividualCoated = 
        {
            Param1_Nom: req.flt_IndStdCoat,
            Param1_T1Neg: req.flt_IndT1NegCoat ,
            Param1_T1Pos: req.flt_IndT1PosCoat ,
            Param1_T2Neg: req.flt_IndT2NegCoat ,
            Param1_T2Pos: req.flt_IndT2PosCoat ,
            Param1_DP: req.int_IndCoatDp ,
            Param1_IsOnStd: indGraphCoatedOn ,
            Param1_LimitOn: blnIndCoatedLimitOn ,
            Param1_NMTTab: req.int_IndNMTTabCntCoat ,
            Param1_Nomenclature: req.str_indCoat_nomNomnclature == undefined ? "NA" : req.str_indCoat_nomNomnclature ,
            Param1_Unit: req.str_unit_Balance 
        }

        if (reqCoatedObject == true) {
            return objIndividualCoated;
        }
        else {
            return objIndividual;

        }
    }
    
    getGroupObject(req, reqCoatedObject = false) 
    {
        var grpGraphOn, blnGrpLimitOn, grpGraphCoatedOn, blnGrpCoatedLimitOn;
        grpGraphOn = req.str_GrpGraphOn == "Standard" ? 0 : 1;
        blnGrpLimitOn = req.str_GrpLimitOn == "Actual" ? 0 : 1; //Actual = false(0) , Percentage = True (1)
        grpGraphCoatedOn = req.str_GrpGraphOnCoat == "Standard" ? 0 : 1;
        blnGrpCoatedLimitOn = req.str_GrpLimitOnCoat == "Actual" ? 0 : 1;

        const objGroup = 
        {
            Param2_Nom: req.flt_GrpStd ,
            Param2_T1Neg: req.flt_GrpT1Neg ,
            Param2_T1Pos: req.flt_GrpT1Pos ,
            Param2_IniQty:req.int_GrpQtyInitial,
            Param2_RegQty:req.int_GrpQtyRegular,
            Param2_T2Neg: req.flt_GrpT2Neg ,
            Param2_T2Pos: req.flt_GrpT2Pos ,
            Param2_DP: req.int_Grpdp ,
            Param2_IsOnStd: grpGraphOn ,
            Param2_LimitOn: blnGrpLimitOn ,
            Param2_NMTTab: req.int_GrpNMTTabCnt ,
            Param2_Unit: req.str_unit_Group 
        }

        const objGroupCoated = 
        {
            Param2_Nom: req.flt_GrpStdCoat ,
            Param2_T1Neg: req.flt_GrpT1NegCoat ,
            Param2_T1Pos: req.flt_GrpT1PosCoat ,
            Param2_T2Neg: req.flt_GrpT2NegCoat ,
            Param2_T2Pos: req.flt_GrpT2PosCoat ,
            Param2_DP: req.int_GrpCoatDp ,
            Param2_IsOnStd: grpGraphCoatedOn ,
            Param2_LimitOn: blnGrpCoatedLimitOn ,
            Param2_NMTTab: req.int_GrpNMTTabCntCoat ,
            Param2_Unit: req.str_unit_Group 
        }
        if (reqCoatedObject == true) {
            return objGroupCoated;
        }
        else {
            return objGroup;

        }
    }

    getThicknessObject(req, reqCoatedObject = false) {
        var thkGraphOn;
        thkGraphOn = req.str_ThkGraphOn == "Standard" ? 0 : 1;

        const objThickness = 
        {
            Param3_Nom: req.flt_ThkStd ,
            Param3_T1Neg: req.flt_ThkT1Neg ,
            Param3_T1Pos: req.flt_ThkT1Pos ,
            Param3_IniQty:req.int_ThkQtyInitial,
            Param3_RegQty:req.int_ThkQtyRegular,
            Param3_T2Neg: req.flt_ThkT2Neg ,
            Param3_T2Pos: req.flt_ThkT2Pos ,
            Param3_T3Neg: req.flt_ThkT3Neg ,
            Param3_T3Pos: req.flt_ThkT3Pos ,
            Param3_DP: req.int_Thkdp ,
            Param3_IsOnStd: thkGraphOn ,
            Param3_NMTTab: req.int_ThkNMTTabCnt ,
            Param3_Unit: req.str_unit_Vernier 
        }

        const objThicknessCoated = 
        {
            Param3_Nom: req.flt_ThkStdCoat ,
            Param3_T1Neg: req.flt_ThkT1NegCoat ,
            Param3_T1Pos: req.flt_ThkT1PosCoat ,
            Param3_T2Neg: req.flt_ThkT2NegCoat ,
            Param3_T2Pos: req.flt_ThkT2PosCoat ,
            Param3_T3Neg: req.flt_ThkT3NegCoat ,
            Param3_T3Pos: req.flt_ThkT3PosCoat ,
            Param3_DP: req.int_ThkCoatDp ,
            // Param3_IsOnStd: thkGraphOn ,
            Param3_NMTTab: req.int_ThkNMTTabCntCoat ,
            Param3_Unit: req.str_unit_Vernier 
        }

        if (reqCoatedObject == true) {
            return objThicknessCoated;
        }
        else {
            return objThickness;

        }
    }

    getBreadthObject(req, reqCoatedObject = false) {
        var brdGraphOn;
        brdGraphOn = req.str_ThkGraphOn == "Standard" ? 0 : 1;

        const objBreadth = 
        {
            Param4_Nom: req.flt_BrdStd,
            Param4_T1Neg: req.flt_BrdT1Neg ,
            Param4_T1Pos: req.flt_BrdT1Pos ,
            Param4_T2Neg: req.flt_BrdT2Neg ,
            Param4_T2Pos: req.flt_BrdT2Pos ,
            Param4_IniQty:req.int_BrdQtyInitial,
            Param4_RegQty:req.int_BrdQtyRegular,
            Param4_DP: req.int_Brddp ,
            Param4_IsOnStd: brdGraphOn ,
            Param4_NMTTab: req.int_BrdNMTTabCnt ,
            Param4_Unit: req.str_unit_Vernier 
        }

        const objBreadthCoated = 
        {
            Param4_Nom: req.flt_BrdStdCoat,
            Param4_T1Neg: req.flt_BrdT1NegCoat ,
            Param4_T1Pos: req.flt_BrdT1PosCoat ,
            Param4_T2Neg: req.flt_BrdT2NegCoat ,
            Param4_T2Pos: req.flt_BrdT2PosCoat ,
            Param4_DP: req.int_BrdCoatDp ,
            // Param4_IsOnStd: brdGraphOn ,
            Param4_NMTTab: req.int_BrdNMTTabCntCoat ,
            Param4_Unit: req.str_unit_Vernier 
        }

        if (reqCoatedObject == true) {
            return objBreadthCoated;
        }
        else {
            return objBreadth;

        }
    }

    getLengthObject(req, reqCoatedObject = false) {
        var lenGraphOn;
        lenGraphOn = req.str_LenGraphOn == "Standard" ? 0 : 1;

        const objLength = 
        {
            Param5_Nom: req.flt_LenStd ,
            Param5_IniQty:req.int_LenQtyInitial,
            Param5_RegQty:req.int_LenQtyRegular,
            Param5_T1Neg: req.flt_LenT1Neg ,
            Param5_T1Pos: req.flt_LenT1Pos ,
            Param5_T2Neg: req.flt_LenT2Neg ,
            Param5_T2Pos: req.flt_LenT2Pos ,
            Param5_T3Neg: req.flt_LenT3Neg ,
            Param5_T3Pos: req.flt_LenT3Pos ,
            Param5_DP: req.int_LenDp ,
            Param5_IsOnStd: lenGraphOn ,
            Param5_NMTTab: req.int_LenNMTTabCnt ,
            Param5_Unit: req.str_unit_Vernier 
        }

        const objLengthCoated = 
        {
            Param5_Nom: req.flt_LenStdCoat ,
            Param5_T1Neg: req.flt_LenT1NegCoat ,
            Param5_T1Pos: req.flt_LenT1PosCoat ,
            Param5_T2Neg: req.flt_LenT2NegCoat ,
            Param5_T2Pos: req.flt_LenT2PosCoat ,
            Param5_T3Neg: req.flt_LenT3NegCoat ,
            Param5_T3Pos: req.flt_LenT3PosCoat ,
            Param5_DP: req.int_LenCoatDp ,
            // Param5_IsOnStd: lenGraphOn ,
            Param5_NMTTab: req.int_LenNMTTabCntCoat ,
            Param5_Unit: req.str_unit_Vernier 
        }

        if (reqCoatedObject == true) {
            return objLengthCoated;
        }
        else {
            return objLength;

        }
    }

    getDiameterObject(req, reqCoatedObject = false) 
    {
        var diaGraphOn;
        diaGraphOn = req.str_DiaGraphOn == "Standard" ? 0 : 1;

        const objDiameter = 
        {
            Param6_Nom: req.flt_DiaStd ,
            Param6_IniQty:req.int_DiaQtyInitial,
            Param6_RegQty:req.int_DiaQtyRegular,
            Param6_T1Neg: req.flt_DiaT1Neg ,
            Param6_T1Pos: req.flt_DiaT1Pos ,
            Param6_T2Neg: req.flt_DiaT2Neg ,
            Param6_T2Pos: req.flt_DiaT2Pos ,
            Param6_T3Neg: req.flt_DiaT3Neg ,
            Param6_T3Pos: req.flt_DiaT3Pos ,
            Param6_DP: req.int_DiaDp ,
            Param6_IsOnStd: diaGraphOn ,
            Param6_NMTTab: req.int_DiaNMTTabCnt ,
            Param6_Unit: req.str_unit_Vernier 
        }
        
        const objDiameterCoated = 
        {
            Param6_Nom: req.flt_DiaStdCoat ,
            Param6_T1Neg: req.flt_DiaT1NegCoat ,
            Param6_T1Pos: req.flt_DiaT1PosCoat ,
            Param6_T2Neg: req.flt_DiaT2NegCoat ,
            Param6_T2Pos: req.flt_DiaT2PosCoat ,
            Param6_T3Neg: req.flt_DiaT3NegCoat ,
            Param6_T3Pos: req.flt_DiaT3PosCoat ,
            Param6_DP: req.int_DiaCoatDp ,
            // Param6_IsOnStd: diaGraphOn ,
            Param6_NMTTab: req.int_DiaNMTTabCntCoat ,
            Param6_Unit: req.str_unit_Vernier 
        }

        if (reqCoatedObject == true) {
            return objDiameterCoated;
        }
        else {
            return objDiameter;

        }
    }

    getHardnessObject(req, reqCoatedObject = false) 
    {
        var hrdGraphOn, hrdGraphOnCoated;
        hrdGraphOn = req.str_HrdGraphOn == "Standard" ? 0 : 1;
        hrdGraphOnCoated = req.str_HrdGraphOnCoat == "Standard" ? 0 : 1;

        const objHardness = 
        {
            Param7_Nom: req.flt_HrdStd ,
            Param7_T1Neg: req.flt_HrdT1 ,
            Param7_T1Pos: req.flt_HrdT2 ,
            Param7_IniQty:req.int_HrdQtyInitial,
            Param7_RegQty:req.int_HrdQtyRegular,
            Param7_T2Neg: req.flt_HrdT1_2 ,
            Param7_T2Pos: req.flt_HrdT2_2 ,
            Param7_T3Neg: req.flt_HrdT1_3 ,
            Param7_T3Pos: req.flt_HrdT2_3 ,
            Param7_DP: req.int_HardDp ,
            Param7_Unit: req.str_HrdUnit ,
            //Param7_IsOnStd: hrdGraphOn ,
        }

        const objHardnessCoated = 
        {
            Param7_Nom: req.flt_HrdStdCoat ,
            Param7_T1Neg: req.flt_HrdT1Coat ,
            Param7_T1Pos: req.flt_HrdT2Coat ,
            Param7_T2Neg: req.flt_HrdT1_2Coat ,
            Param7_T2Pos: req.flt_HrdT2_2Coat ,
            Param7_T3Neg: req.flt_HrdT1_3Coat ,
            Param7_T3Pos: req.flt_HrdT2_3Coat ,
            Param7_DP: req.int_HardDpCoat ,
            Param7_Unit: req.str_HrdUnitCoat ,
            Param7_IsOnStd: hrdGraphOnCoated ,
        }

        if (reqCoatedObject) {
            return objHardnessCoated;
        }
        else {
            return objHardness;
        }
    }

    getFriabilityObject(req, reqCoatedObject = false) 
    {
        const objFriability = 
        {
            Param8_Nom: req.flt_FriNMT ,
            Param8_IniQty:req.int_FriSetCnt,
            Param8_RegQty:req.int_FriSetRPM,
            Param8_T1Neg: req.flt_FriT1Neg ,
            Param8_T1Pos: req.flt_FriT1Pos ,
            Param8_DP: req.int_FriDp ,
        }

        const objFriabilityCoated = 
        {
            Param8_Nom: req.flt_FriNMTCoat ,
            Param8_T1Neg: req.int_FriSetCntCoat ,
            Param8_T1Pos: req.int_FriSetRPMCoat ,
            Param8_DP: req.int_FriCoatDp ,
        }

        if (reqCoatedObject) {
            return objFriabilityCoated;
        }
        else {
            return objFriability;
        }
    }

    getIndividualLay1Object(req) 
    {
        var indL1GraphOn, blnIndLay1LimitOn;
        indL1GraphOn = req.str_IndL1GraphOn == "Standard" ? 0 : 1;
        blnIndLay1LimitOn = req.str_IndL1LimitOn == "Actual" ? 0 : 1 //Actual = false(0) , Percentage = True (1)

        const objIndLay1 = 
        {
            Param9_Nom: req.flt_IndL1Std ,
            Param9_T1Neg: req.flt_IndL1T1Neg ,
            Param9_T1Pos: req.flt_IndL1T1Pos ,
            Param9_T2Neg: req.flt_IndL1T2Neg ,
            Param9_T2Pos: req.flt_IndL1T2Pos ,
            Param9_DP: req.int_IndL1Dp ,
            Param9_IsOnStd: indL1GraphOn ,
            Param9_LimitOn: blnIndLay1LimitOn ,
            Param9_NMTTab: req.int_IndL1NMTTabCount ,
            Param9_Nomenclature: req.str_indL1_nomNomnclature ,
            Param9_Unit: req.str_unit_Balance 
        }
        return objIndLay1;
    }

    getGroupLay1Object(req) 
    {
        var grpL1GraphOn, blnGrpL1LimitOn;
        grpL1GraphOn = req.str_GrpL1GraphOn == "Standard" ? 0 : 1;
        blnGrpL1LimitOn = req.str_GrpL1LimitOn == "Actual" ? 0 : 1 //Actual = false(0) , Percentage = True (1)

        const objGroupLay1 = 
        {
            Param10_Nom: req.flt_GrpL1Std ,
            Param10_T1Neg: req.flt_GrpL1T1Neg ,
            Param10_T1Pos: req.flt_GrpL1T1Pos ,
            Param10_T2Neg: req.flt_GrpL1T2Neg ,
            Param10_T2Pos: req.flt_GrpL1T2Pos ,
            Param10_DP: req.int_GrpL1Dp ,
            Param10_IsOnStd: grpL1GraphOn ,
            Param10_LimitOn: blnGrpL1LimitOn ,
            Param10_NMTTab: req.int_GrpL1NMTTabCount ,
            Param10_Unit: req.str_unit_Group == undefined ? 'NA':req.str_unit_Group
        }

        return objGroupLay1;
    }

    getIndividualLay2Object(req) {
        var indL2GraphOn, blnIndLay2LimitOn;
        indL2GraphOn = req.str_IndL2GraphOn == "Standard" ? 0 : 1;
        blnIndLay2LimitOn = req.str_IndL2LimitOn == "Actual" ? 0 : 1 //Actual = false(0) , Percentage = True (1)

        const objIndividualLay2 = 
        {
            Param11_Nom: req.flt_IndL2Std ,
            Param11_T1Neg: req.flt_IndL2T1Neg ,
            Param11_T1Pos: req.flt_IndL2T1Pos ,
            Param11_T2Neg: req.flt_IndL2T2Neg ,
            Param11_T2Pos: req.flt_IndL2T2Pos ,
            Param11_DP: req.int_IndL2Dp ,
            Param11_IsOnStd: indL2GraphOn ,
            Param11_LimitOn: blnIndLay2LimitOn ,
            Param11_NMTTab: req.int_IndL2NMTTabCount ,
            Param11_Nomenclature: req.str_indL2_nomNomnclature ,
            Param11_Unit: req.str_unit_Balance 
        }

        return objIndividualLay2;
    }

    getGroupLay2Object(req) {
        var grpL2GraphOn, blnGrpL2LimitOn;
        grpL2GraphOn = req.str_GrpL2GraphOn == "Standard" ? 0 : 1;
        blnGrpL2LimitOn = req.str_GrpL2LimitOn == "Actual" ? 0 : 1 //Actual = false(0) , Percentage = True (1)

        const objGroupLay2 = 
        {
            Param12_Nom: req.flt_GrpL2Std ,
            Param12_T1Neg: req.flt_GrpL2T1Neg ,
            Param12_T1Pos: req.flt_GrpL2T1Pos ,
            Param12_T2Neg: req.flt_GrpL2T2Neg ,
            Param12_T2Pos: req.flt_GrpL2T2Pos ,
            Param12_DP: req.int_GrpL2Dp ,
            Param12_IsOnStd: grpL2GraphOn ,
            Param12_LimitOn: blnGrpL2LimitOn ,
            Param12_NMTTab: req.int_GrpL2NMTTabCount ,
            Param12_Unit: req.str_unit_Group 
        }
        return objGroupLay2;
    }

    getDTObject(req, reqCoatedObject = false) {
        var dtTime = req.int_DTHHTime + ':' + req.int_DTMMTime + ':' + req.int_DTSSTime;
        var dtTimeCoated = req.int_DTHHTimeCoat + ':' + req.int_DTMMTimeCoat + ':' + req.int_DTSSTimeCoat;

        const objDT = 
        {
            Param13_Nom: dtTime ,
            Param13_T1Neg: req.flt_DTMinTemp ,
            Param13_T1Pos: req.flt_DTMaxTemp ,
            Param13_DP: req.int_DTDp ,
        }

        const objDTCoated = 
        {
            Param13_Nom: dtTimeCoated ,
            Param13_T1Neg: req.flt_DTMinTempCoat ,
            Param13_T1Pos: req.flt_DTMaxTempCoat ,
            Param13_DP: req.int_DTDpCoat ,
        }

        if (reqCoatedObject) {
            return objDTCoated;
        }
        else {
            return objDT;
        }
    }


    getTabDenObject(req) {

        const objTabDensity = 
        {
            Param15_T1Neg: req.flt_TDT1 ,
            Param15_T1Pos: req.flt_TDT2 ,
            Param15_DP: req.int_TDDp ,
        }

        return objTabDensity;
    }

    getMouistueObject(req, reqCoatedObject = false) {

        const objMouisture = 
        {
            Param16_T1Neg: req.flt_MAT1 ,
            Param16_T1Pos: req.flt_MAT2 ,
            Param16_DP: req.int_MADp ,
        }

        const obj_mouistureCoated = 
        {
            Param16_T1Neg: req.flt_MAT1Coat ,
            Param16_T1Pos: req.flt_MAT2Coat ,
            Param16_DP: req.int_MADpCoat ,
        }

        if (reqCoatedObject) {
            return obj_mouistureCoated;
        } else {
            return objMouisture;
        }
    }

    getSivShakerObject(req) {

        const objSivShaker = 
        {
            Param17_T1Neg: req.flt_SST1 ,
            Param17_T1Pos: req.flt_SST2 ,
            Param17_DP: req.int_SSDp ,
        }

        return objSivShaker;
    }

    getYieldObject(req, reqCoatedObject = false) {

        const objYield = [
            { str_colName: 'TheroticalYield', value: req.TheroticalYield },
            { str_colName: 'YieldNLT', value: req.YieldNLT },
            { str_colName: 'TotalLossNMT', value: req.TotalLossNMT },
            { str_colName: 'Yield_DP', value: req.Yield_DP }
        ]

        const objYieldCoat = [
            { str_colName: 'TheroticalYield', value: req.TheroticalYield },
            { str_colName: 'YieldNLT', value: req.YieldNLT },
            { str_colName: 'TotalLossNMT', value: req.TotalLossNMT },
            { str_colName: 'Yield_DP', value: req.Yield_DP }
        ]

        if (reqCoatedObject) {
            return objYieldCoat;
        } else {
            return objYield;
        }
    }

    getDTObject_Lay_1(req) {

        const objDT_Lay_1 = 
        {
            Param19_Nom: req.int_DTHHTime_Lay_1 + ':' + req.int_DTMMTime_Lay_1 + ':' + req.int_DTSSTime_Lay_1 ,
            Param19_T1Neg: req.flt_DTMinTemp_Lay_1 ,
            Param19_T1Pos: req.flt_DTMaxTemp_Lay_1 ,
            Param19_DP: req.int_DTDp_Lay_1
        };

        return objDT_Lay_1;
    }

    getDTObject_Lay_2(req) {

        const objDT_Lay_2 = 
        {
            Param20_Nom: req.int_DTHHTime_Lay_2 + ':' + req.int_DTMMTime_Lay_2 + ':' + req.int_DTSSTime_Lay_2 ,
            Param20_T1Neg: req.flt_DTMinTemp_Lay_2 ,
            Param20_T1Pos: req.flt_DTMaxTemp_Lay_2 ,
            Param20_DP: req.int_DTDp_Lay_2
        };

        return objDT_Lay_2;
    }

}

module.exports = ProductTablet;