const Database = require('../database/clsQueryProcess');
const database = new Database()
const date = require('date-and-time')
let now = new Date();
const clsProduct = require('./clsProductTablet.class');
const objProduct = new clsProduct();

const clsCapsule = require('./clsCapsuleModel');
const objCapsule = new clsCapsule();

const seqTransaction = require("../dbConnection");
const sequelize = require('./../dbConnection').sequelize;
const { Op } = require("sequelize");

const models = require("../dbConnection").models;

//const strTableName = "tbl_product_master";
//const strDetailTableName = "tbl_product_tablet";
//const strDetailCoatedTableName = "tbl_product_tablet_coated";
const _strTableName = "tbl_product_master";
const _strDetailTableName = "tbl_product_tablet";
const _strDetailTableNameTemp = "tbl_product_tablet_temp";
const _strDetailCoatedTableName = "tbl_product_tablet_coated";
const _strGranulationTableName = "tbl_product_gran";
const _strDetailTableNameCapTemp = "tbl_product_capsule_temp";
class TabletProduct {

    static get strTableName() {
        return _strTableName;
    }


    static get strDetailTableName() {
        return _strDetailTableName;
    }
    
    static get strDetailTableNameTemp() {
        return _strDetailTableNameTemp;
    }

    static get strDetailTableNameCapTemp() {
        return _strDetailTableNameCapTemp;
    }

    static get strDetailCoatedTableName() {
        return _strDetailCoatedTableName;
    }

    static get strGranulationTableName() {
        return _strGranulationTableName;
    }



    // static get strTableName() { 
    //     return strTableName;
    // }

    // static get strDetailTableName() { 
    //     return strDetailTableName;
    // }

    // static get strDetailCoatedTableName() { 
    //     return strDetailCoatedTableName;
    // }


    async getCoatedDetails(IProduct,strProjectName) 
    { 
        var objCoatedTabletInfo = {};
        var productObj;

            productObj = await models[''+TabletProduct.strDetailCoatedTableName].findAll
            ({
                where: 
                {
                    ProductId:IProduct.ProductId,
                    ProductName:IProduct.ProductName,
                    ProductVersion:IProduct.ProductVersion,
                    Version:IProduct.Version
                }
            });

        var coated = { Coated: productObj[0] }
        return coated;
    }

    async getGranulationDetails(IProduct,strProjectName) 
    { 
        var objGranulationInfo = {};
            objGranulationInfo = await models[''+TabletProduct.strGranulationTableName].findAll
            ({
                where: 
                {
                    ProductId:IProduct.ProductId,
                    ProductName:IProduct.ProductName,
                    ProductVersion:IProduct.ProductVersion,
                    Version:IProduct.Version
                }
            });
        var granulation = { Granulation: objGranulationInfo[0] }
        return granulation;
    }

    async getCompressionDetails(IProduct,strProjectName) 
    { 
        var objTabletInfo = {};
            objTabletInfo = await models[''+TabletProduct.strDetailTableName].findAll
            ({
                where: 
                {
                    // ProductId:IProduct.ProductId,
                    // ProductName:IProduct.ProductName,
                    // ProductVersion:IProduct.ProductVersion,
                    // Version:IProduct.Version,
                    // SFOID: IProduct.SFOID
                    MPN_Code:IProduct.SFOID
                }
            });

        var compressed = { Compressed: objTabletInfo[0] };
        return compressed;
    }

    //Limits change from MES store in temp detail table
    async getDetailsTemp(IProduct,int_type) 
    { 
        var objTabletInfo = {};
        var str_int_type = (int_type == 1) ? TabletProduct.strDetailTableNameTemp : TabletProduct.strDetailTableNameCapTemp;
            objTabletInfo = await models[''+str_int_type].findAll
            ({
                where: 
                {
                    // ProductId:IProduct.ProductId,
                    // ProductName:IProduct.ProductName,
                    // ProductVersion:IProduct.ProductVersion,
                    // Version:IProduct.Version,
                    // SFOID: IProduct.SFOID
                    MPN_Code:IProduct.SFOID
                }
            });

        var compCap = { new_CompCap: objTabletInfo[0] };
        return compCap;
    }

    async getMasterData(IProduct,strProjectName)
    {
        var objMaster = {};
            objMaster = await models[''+TabletProduct.strTableName].findAll({
                where: 
                {
                    // ProductId:IProduct.ProductId,
                    // ProductName:IProduct.ProductName,
                    // ProductVersion:IProduct.ProductVersion,
                    // Version:IProduct.Version,
                    MPN_Code:IProduct.SFOID
                    // SFOID: IProduct.SFOID
                }
            });
            
        var Master = { Master: objMaster[0] };
        return Master;
    }

    async getTabletDetails(IProduct,strProjectName) 
    {
        try{
            var Product = {};
            var master = await this.getMasterData(IProduct,strProjectName);
            if(master['Master'].ProductType == 1)
            {
                var uncoated = await this.getCompressionDetails(IProduct,strProjectName);
                var uncoatedTemp = { new_CompCap: false};
                if(master['Master'].isLimitChanged == 1){
                    uncoatedTemp = await this.getDetailsTemp(IProduct,1)
                }
                var coated = await this.getCoatedDetails(IProduct,strProjectName);
                var granulation = await this.getGranulationDetails(IProduct,strProjectName);
                Object.assign(Product, master,uncoated, coated, granulation,uncoatedTemp);
            }
            else
            {
                var CapsuleParams = await objCapsule.getCapsuleParams(IProduct, strProjectName);
                var capsuleTemp = { new_CompCap: false};
                if(master['Master'].isLimitChanged == 1){
                    capsuleTemp = await this.getDetailsTemp(IProduct,2)
                }
                Object.assign(Product, master,uncoated, coated, granulation,uncoatedTemp,capsuleTemp,CapsuleParams);
            }
           
            return Product;
        }catch(error){
            console.log(error);
            throw error;
        }
    }

    async getUniqueCombination(strProductType) 
    {
        let result = await models[''+TabletProduct.strTableName].findAll({
            where: { ProductType: strProductType},
            offset : 0, // set the offset according your use case
            limit : 1,  // limit the output
        });
        if ((result !== null) && (result.length > 0)) {
            return result[0];
        } else {
            return [];
        }
    }

    // 
    //************************************************************************************************** */
    // below function takes argument as productType, reportOption, typeOfCubicle and return data from
    // respective master
    //*********************************************************************************************** */
    getProductDetailBatchSummary(detailObj) {
        return new Promise((resolve, reject) => {
            // Extracting values form Object
            var productType = detailObj.productType;
            var reportOption = detailObj.reportOption;
            var selectType = detailObj.selectType;
            var strTableName = '';
            // Tablet-> 1 // Capsule->2
            if (productType == 'Tablet') {
                productType = 1
            } else {
                productType = 2
            }
            switch (reportOption) {
                case 'Individual':
                    strTableName = 'tbl_batchsummary_master1';
                    break;
                case 'Group':
                    strTableName = 'tbl_batchsummary_master2';
                    break;
                case 'Thickness':
                    strTableName = 'tbl_batchsummary_master3';
                    break;
                case 'Breadth':
                    strTableName = 'tbl_batchsummary_master4';
                    break;
                case 'Length':
                    strTableName = 'tbl_batchsummary_master5';
                    break;
                case 'Diameter':
                    strTableName = 'tbl_batchsummary_master6';
                    break;
                case 'Hardness':
                    strTableName = 'tbl_batchsummary_master7';
                    break;
                case 'Disintegration Tester':
                    strTableName = 'tbl_batchsummary_master13';
                    break;
                case 'Friabilator':
                    strTableName = 'tbl_batchsummary_master8';
                    break;
                case 'Individual Layer1':
                    strTableName = 'tbl_batchsummary_master9';
                    break;
                case 'Group Layer1':
                    strTableName = 'tbl_batchsummary_master10';
                    break;
                case 'Individual Layer2':
                    strTableName = 'tbl_batchsummary_master11';
                    break;
                case 'Group Layer2':
                    strTableName = 'tbl_batchsummary_master12';
                    break;
                case 'Differential':
                    strTableName = 'tbl_batchsummary_masterdiff';
                    break;
            }
            var objSelectDetail = {
                str_tableName: strTableName,
                data: '*',
                condition: [
                    { str_colName: 'PrdType', value: productType, comp: 'eq' },
                    { str_colName: 'CubType', value: selectType, comp: 'eq' },
                ]
            }
            // console.log(objSelectDetail)
            // call to database select
            database.select(objSelectDetail).then(result => {
                var objResponse = {};
                Object.assign(objResponse, { status: 'success', data: result[0] })
                resolve(objResponse)
            }).catch(err => {
                reject(err)
            })
        })
    }

    pushParamDetailsTablet(str_query, req) {

        Object.assign(str_query, { ...objProduct.getIndividualObject(req, false) });//1
        Object.assign(str_query, { ...objProduct.getGroupObject(req, false) });//2

        Object.assign(str_query, { ...objProduct.getThicknessObject(req, false) });//3
        Object.assign(str_query, { ...objProduct.getBreadthObject(req, false) });//4
        Object.assign(str_query, { ...objProduct.getLengthObject(req, false) });//5
        Object.assign(str_query, { ...objProduct.getDiameterObject(req, false) });//6

        Object.assign(str_query, { ...objProduct.getHardnessObject(req, false) });//7
        Object.assign(str_query, { ...objProduct.getFriabilityObject(req, false) });//8

        Object.assign(str_query, { ...objProduct.getIndividualLay1Object(req, false) });//9
        Object.assign(str_query, { ...objProduct.getGroupLay1Object(req, false) });//10
        Object.assign(str_query, { ...objProduct.getIndividualLay2Object(req, false) });//11
        Object.assign(str_query, { ...objProduct.getGroupLay2Object(req, false) });//12

        Object.assign(str_query, { ...objProduct.getDTObject(req, false) });//13
        Object.assign(str_query, { ...objProduct.getTabDenObject(req, false) });//15
        Object.assign(str_query, { ...objProduct.getMouistueObject(req, false) });//16
        Object.assign(str_query, { ...objProduct.getSivShakerObject(req, false) });//17

        Object.assign(str_query, { ...objProduct.getDTObject_Lay_1(req) });//19
        Object.assign(str_query, { ...objProduct.getDTObject_Lay_2(req) });//20

        return str_query;

    }

    
}

module.exports = TabletProduct

