const requestIp = require('request-ip');
const date = require('date-and-time');
const models = require("../dbConnection").models;
const seqTransaction = require("../dbConnection");
const moment = require('moment');
const sequelize = require("../dbConnection").sequelize;
const { QueryTypes } = require('sequelize');
const { Op } = require("sequelize");
serverConfig = require('../global/serverConfig').developerPanelData;
var serverConfiG = require('../global/serverConfig');
var sarrTabletStartup = [1,2,"htd",8,13]; //8,13 //[1,2,"htd"]
var sarrCapsuleStartup = [1,2,3,5,13,19]; //temporary code commented now check only tablet report.
// [1,2,3,5,13];

class TabletCapsuleModel {

    async viewSeparateReport(value, req) {
        try {
            const responseObj = {};
            const int_ReportFormat = value.int_ReportFormat;
            const clientIp = requestIp.getClientIp(req);
            let ip = clientIp.split(':')[3];
            if ((("idsNo" in value) == true)) {
                ip = `${serverConfig.strIpSeries}${value.idsNo}`;
            } else if (ip === undefined) {
                ip = '127.0.0.1';
            }

            if (value.str_source == "Auto") {
                ip = value.str_hmi;
                console.log("Autoip", ip);
            }

            const int_hmiID = ip;
            const reportOption = value.reportOption;
            const reportType = value.reportType;
            const recordFrom = value.recordFrom;
            const repSerNo = value.RepSerNo;
            const userId = value.userId;
            const userName = value.username;
            const productType = (value.str_url == 'Tablet') ? 1 : 2;
            let testType = value.testType;
            let masterTableName = "", detailTableName = "", WeighmentModeNo = 0;
            if (testType == 'Regular') {
                testType = 0;
            } else {
                testType = 1;
            }

            const ObjTables = await this.getWeighmentsTableName(productType, reportOption, reportType, recordFrom, int_ReportFormat);
            masterTableName = ObjTables.masterTableName;
            detailTableName = ObjTables.detailTableName;
            WeighmentModeNo = ObjTables.intWeighmentSrNo;
            const tbl_TempMaster = ObjTables.MstTempTbl;
            const tbl_TempDetail = ObjTables.DetTempTbl;

            const selectMasterData = await models[masterTableName].findAll({
                where: {
                    RepSerNo: repSerNo
                }
            });

            if (ObjTables.blnIsTempTable == true) {
                // Start Deleting previous Data from temporary Tables.
                await this.DeleteEntriesInTempTable(int_hmiID, tbl_TempMaster, tbl_TempDetail);
                // Completed Deleting previous Data from temporary Tables.

                // Start Inserting records of permanent table into temporary Tables.
                if (reportOption == 'Individual' || reportOption == 'Group' || 
                    reportOption == 'Thickness' || reportOption == 'Breadth' ||  
                    reportOption == 'Width' || reportOption == 'Length' || 
                    reportOption == 'Diameter' || reportOption == 'Hardness' || 
                    reportOption == 'Individual Layer 1' || reportOption == 'Individual Layer 2' ||
                    reportOption == 'Group Layer 1' || reportOption == 'Group Layer 2' || reportOption == 'Appearance' || reportOption == 'Locked Length' || reportOption == 'Differential') 
                {
                    const res_Obj = await this.insertIndividualTempTables(value, selectMasterData[0], int_hmiID, 
                        detailTableName, repSerNo, WeighmentModeNo, productType, tbl_TempMaster, tbl_TempDetail);
                    Object.assign(responseObj, res_Obj);
                
                } else if (reportOption == 'DT' || reportOption == 'DT Layer 1' || reportOption == 'DT Layer 2') 
                {
                    const res_Obj = await this.insertDisintegrationTestTempTables(value, selectMasterData[0], int_hmiID, 
                        detailTableName, repSerNo, WeighmentModeNo, productType, tbl_TempMaster, tbl_TempDetail);
                    Object.assign(responseObj, res_Obj);

                } else if (reportOption == 'Particle Size' || reportOption == 'Particle Size Layer 1' || 
                    reportOption == 'Particle Size Layer 2' || reportOption == 'Fine %' ||
                    reportOption == '% Fine' || reportOption == '% Fine Layer 1' || reportOption == '% Fine Layer 2') 
                {
                    const res_Obj = await this.insertParticleSizeTempTable(value, selectMasterData[0], int_hmiID, 
                        detailTableName, repSerNo, WeighmentModeNo, productType, tbl_TempMaster, tbl_TempDetail);
                    Object.assign(responseObj, res_Obj);

                }
                // Completed Inserting records of permanent table into temporary Tables.
            }

            if (reportOption == 'Friability' || reportOption == 'LOD' || reportOption == 'LOD Layer 1' || 
                reportOption == 'LOD Layer 2' || reportOption == 'Tapped Density' || 
                reportOption == 'Tapped Density Layer 1' || reportOption == 'Tapped Density Layer 2' || reportOption == 'Vacuum Leak Test') 
            {
                let RptRemark = 'NA';
                if (selectMasterData.length > 0) {
                    RptRemark = selectMasterData[0].Remark;
                }
                Object.assign(responseObj, {
                    waterMark: true,
                    printNo: value.printNo,
                    UserId: userId,
                    UserName: userName,
                    SelectedValue: repSerNo,
                    HmiId: int_hmiID,
                    WgmtModeNo: WeighmentModeNo,
                    ProductType: productType,
                    ICReport: reportType,
                    ReportRemark: RptRemark,
                    batchNo: value.batchNo,
                    cubicleType: value.cubicleType,
                    Side:value.Side,
                    Repetition:selectMasterData[0].Repetition,
                    PrDate:selectMasterData[0].PrDate,
                    PrTime:date.format(selectMasterData[0].PrTime,'HH:mm:ss')

                });
            }
            return responseObj;

        } catch (err) {
            console.log(err);
            throw err;
        }
    }

    // Deleting previous Data from temporary Tables.
    async DeleteEntriesInTempTable(int_hmiID, tbl_TempMaster, tbl_TempDetail) {
        try {
            const deleteTempMaster = await models[tbl_TempMaster].destroy({
                where: {
                    HMIID: int_hmiID
                }
            });
            console.log(`Deleted Rows from Temp Master(${tbl_TempMaster}) for ${int_hmiID} ==> ${deleteTempMaster} affectedRows`);

            const deleteTempDetail = await models[tbl_TempDetail].destroy({
                where: { HMIID: int_hmiID }
            });
            console.log(`Deleted Rows from Temp Detail(${tbl_TempDetail}) for ${int_hmiID} ==> ${deleteTempDetail} affectedRows`);

        } catch (err) {
            console.log(err);
            throw err;
        }
    }

    //  Inserting records of permanent table into temporary Tables. 
    async insertIndividualTempTables(value, selectMasterData, int_hmiID, detailTableName, repSerNo, WeighmentModeNo, 
        productType, tbl_TempMaster, tbl_TempDetail) 
    {
        try {
            const obj_res = {};
            let recSeqCount = 0;
            let recSeqCountR = 0;
            await this.DeleteEntriesInTempTable(int_hmiID, tbl_TempMaster, tbl_TempDetail); // Again Delete data from Temp Tables.

            const transaction = await seqTransaction.sequelize.transaction(async (t) => {

                const insertTempMater = {
                    RepSerNo: selectMasterData.RepSerNo,
                    MstSerNo: selectMasterData.MstSerNo,
                    Test_Seq: selectMasterData.MstSerNo,
                    WgmtModeNo: selectMasterData.WgmtModeNo,
                    ProductType: selectMasterData.ProductType,
                    Area: selectMasterData.Area,
                    CubicalNo: selectMasterData.CubicalNo,
                    CubicleName: selectMasterData.CubicleName,
                    CubicleType: selectMasterData.CubicleType,
                    IPQCType: selectMasterData.IPQCType,
                    CoatingType: selectMasterData.CoatingType,
                    MachineCode: selectMasterData.MachineCode,
                    Department: selectMasterData.Department,
                    BFGCode: selectMasterData.BFGCode,
                    ProductName: selectMasterData.ProductName,
                    SFOID: selectMasterData.SFOID,
                    PVersion: selectMasterData.PVersion,
                    Version: selectMasterData.Version,
                    BatchNo: selectMasterData.BatchNo,
                    BatchSize: selectMasterData.BatchSize,
                    BMRNo: selectMasterData.BMRNo,
                    GraphType: selectMasterData.GraphType,
                    Qty: selectMasterData.Qty,
                    GrpQty: selectMasterData.GrpQty,
                    GrpFreq: selectMasterData.GrpFreq,
                    Idsno: selectMasterData.Idsno,
                    BalanceId: selectMasterData.BalanceId,
                    VernierId: selectMasterData.VernierId,
                    FriabilityID: selectMasterData.FriabilityID,
                    HardnessID: selectMasterData.HardnessID,
                    UserId: selectMasterData.UserId,
                    UserName: selectMasterData.UserName,
                    PrDate: selectMasterData.PrDate,
                    PrTime: date.format(selectMasterData.PrTime, 'HH:mm:ss'),
                    PrEndDate: (selectMasterData.PrEndDate == null) ? 'NULL' : selectMasterData.PrEndDate,
                    PrEndTime: (selectMasterData.PrEndTime == null) ? 'NULL' : date.format(selectMasterData.PrEndTime, 'HH:mm:ss'),
                    SideNo: selectMasterData.SideNo,
                    Side: selectMasterData.Side,
                    Stage: selectMasterData.Stage,
                    Unit: selectMasterData.Unit,
                    DecimalPoint: selectMasterData.DecimalPoint,
                    LimitOn: selectMasterData.LimitOn,
                    NMT: selectMasterData.NMT,
                    Nom: selectMasterData.Nom,
                    T1NegTol: '0',
                    T1PosTol: '0',
                    T2NegTol: selectMasterData.T2NegTol,
                    T2PosTol: selectMasterData.T2PosTol,
                    
                    T1NegTolActual: selectMasterData.T1NegTolActual,
                    T1PosTolActual: selectMasterData.T1PosTolActual,
                    T2NegTolActual: selectMasterData.T2NegTolActual,
                    T2PosTolActual: selectMasterData.T2PosTolActual,
                    NomEmpty: selectMasterData.NomEmpty,
                    T1NegEmpty: selectMasterData.T1NegEmpty,
                    T1PosEmpty: selectMasterData.T1PosEmpty,
                    T2NegEmpty: selectMasterData.T2NegEmpty,
                    T2PosEmpty: selectMasterData.T2PosEmpty,
                    NomNet: selectMasterData.NomNet,
                    T1NegNet: selectMasterData.T1NegNet,
                    T1PosNet: selectMasterData.T1PosNet,
                    T2NegNet: selectMasterData.T2NegNet,
                    T2PosNet: selectMasterData.T2PosNet,
                    T1NegNetActual: selectMasterData.T1NegNetActual,
                    T1PosNetActual: selectMasterData.T1PosNetActual,
                    T2NegNetActual: selectMasterData.T2NegNetActual,
                    T2PosNetActual: selectMasterData.T2PosNetActual,
                    ReportType: selectMasterData.ReportType,
                    PrintNo: selectMasterData.PrintNo,
                    IsArchived: selectMasterData.IsArchived,
                    BatchComplete: selectMasterData.BatchComplete,
                    CheckedByID: selectMasterData.CheckedByID,
                    CheckedByName: selectMasterData.CheckedByName,
                    CheckedByDate: selectMasterData.CheckedByDate,
                    Lot: selectMasterData.Lot,
                    StdLimit1: selectMasterData.StdLimit1,
                    StdLimit2: selectMasterData.StdLimit2,
                    NoOfAbove1: selectMasterData.NoOfAbove1,
                    NoOfBelow1: selectMasterData.NoOfBelow1,
                    NoOfAbove2: selectMasterData.NoOfAbove2,
                    NoOfBelow2: selectMasterData.NoOfBelow2,
                    MinPer: selectMasterData.MinPer,
                    MaxPer: selectMasterData.MaxPer,
                    GroupWeight: selectMasterData.GroupWeight,
                    AvgWeight: selectMasterData.AvgWeight,
                    AvgEmpty: selectMasterData.AvgEmpty,
                    AvgNet: selectMasterData.AvgNet,
                    MinWeight: selectMasterData.MinWeight,
                    MaxWeight: selectMasterData.MaxWeight,
                    MinWeightEmpty: selectMasterData.MinWeightEmpty,
                    MaxWeightEmpty: selectMasterData.MaxWeightEmpty,
                    MinWeightNet: selectMasterData.MinWeightNet,
                    MaxWeightNet: selectMasterData.MaxWeightNet,
                    StdDev: selectMasterData.StdDev,
                    Remark: selectMasterData.Remark,
                    FailedRemark: selectMasterData.FailedRemark,
                    FailedRemarkTSH: selectMasterData.FailedRemarkTSH,
                    Inprocess: selectMasterData.Inprocess,
                    Deviation: selectMasterData.Deviation,
                    LayerName: selectMasterData.LayerName,
                    Layer: selectMasterData.Layer,
                    HMIID: int_hmiID,
                    Nom_stdtarget: selectMasterData.Nom_stdtarget,
                    SFOID: selectMasterData.SFOID,
                    MPN_Code: selectMasterData.MPN_Code,
                    Repetition: selectMasterData.Repetition,
                };

                if (value.reportOption == 'Group' || value.reportOption == 'Group Layer 1' || 
                    value.reportOption == 'Group Layer 2') 
                {
                    insertTempMater.MinGrpWeight = selectMasterData.MinGrpWeight;
                    insertTempMater.MaxGrpWeight = selectMasterData.MaxGrpWeight;
                    insertTempMater.AvgGrpWeight = selectMasterData.AvgGrpWeight;
                    insertTempMater.Weight_Gain = selectMasterData.Weight_Gain;
                    insertTempMater.Start_Weight = selectMasterData.Start_Weight;
                    insertTempMater.End_Weight = selectMasterData.End_Weight;
                    insertTempMater.Make = selectMasterData?.Make;
                    insertTempMater.Model = selectMasterData?.Model;
                    insertTempMater.SerialNo = selectMasterData?.SerialNo;
                    insertTempMater.AvgWeightPrewarmed = selectMasterData?.AvgWeight;
                    insertTempMater.TestType = selectMasterData?.MesTestType;
                }
                if(value.reportOption == 'Appearance') {
                    insertTempMater.Upper_Surface = selectMasterData.Upper_Surface;
                    insertTempMater.Lower_Surface = selectMasterData.Lower_Surface;
                    insertTempMater.Appearance_Desc = selectMasterData.Appearance_Desc;
                    insertTempMater.Comp_MC_Speed = selectMasterData.Comp_MC_Speed;
                }

                await models[tbl_TempMaster].create(insertTempMater, {
                    transaction: t
                });

                const detailData = await models[detailTableName].findAll({
                    where: { RepSerNo: repSerNo }
                });

                for (const data of detailData) {
                    const insertTempDetail = {
                        RecNo: data.RecNo,
                        RepSerNo: data.RepSerNo,
                        MstSerNo: data.MstSerNo,
                        RecSeqNo: data.RecSeqNo,
                        DataValue: data.DataValue,
                        DataValue1: data.DataValue1,
                        NetValue: data.NetValue,
                        AvgWeight: data.AvgWeight,
                        Deviation: data.Deviation,
                        DP: data.DP,
                        UserId: data.UserId,
                        UserName: data.UserName,
                        PrDate: data.PrDate,
                        PrTime: date.format(data.PrTime, 'HH:mm:ss'),
                        PrEndDate: data.PrEndDate,
                        PrEndTime: date.format(data.PrEndTime, 'HH:mm:ss'),
                        BFGCode: data.BFGCode,
                        ProductName: data.ProductName,
                        Version: data.Version,
                        PVersion: data.PVersion,
                        Side: data.Side,
                        BatchNo: data.BatchNo,
                        InstrumentID: data.InstrumentID,
                        Remark: data.Remark,
                        WeighmentMode: WeighmentModeNo,
                        ProductType: productType,
                        HMIID: int_hmiID,
                        IPC_Code: data.IPC_Code
                    };

                    if (value.reportOption == 'Group' || value.reportOption == 'Group Layer 1' || 
                        value.reportOption == 'Group Layer 2') 
                    {
                        insertTempDetail.NoOfSample = data.NoOfSample;
                        insertTempDetail.Sprayperiod = data.SprayPeriod;
                        insertTempDetail.DataValue2 = data.DataValue2;
                    }
                    if(value.reportOption == 'Appearance') {
                        insertTempDetail.Actual_Speed = data.Actual_Speed;
                        insertTempDetail.TestResult = data.TestResult;
                    }

                    await models[tbl_TempDetail].create(insertTempDetail, { transaction: t });
                }
                return "Success";
            });

            recSeqCount = await models[detailTableName].count({
                where: { RepSerNo: repSerNo }
            });

            if ((value.reportOption.includes("Group") == true) && selectMasterData.Side == 'LHS') {
                recSeqCount = await models[detailTableName].count({
                    where: {
                        RepSerNo: repSerNo,
                        Side: {
                            [Op.or]: ['LHS']
                        }
                    }
                });
            }

            if ((value.reportOption.includes("Group") == true) && selectMasterData.Side == 'RHS') {
                recSeqCountR = await models[detailTableName].count({
                    where: {
                        RepSerNo: repSerNo,
                        Side: {
                            [Op.or]: ['RHS']
                        }
                    }
                });
            }
            
            Object.assign(obj_res, {
                waterMark: true,
                printNo: Number(selectMasterData.PrintNo),
                UserId: value.userId,
                UserName: value.username,
                SelectedValue: repSerNo,
                HmiId: int_hmiID,
                WgmtModeNo: WeighmentModeNo,
                ProductType: productType,
                ICReport: value.reportType,
                RecSeqNo: recSeqCount,
                RecSeqNoR: recSeqCountR,
                ReportRemark: selectMasterData.Remark,
                BatchNo: value.batchNo,
                PrDate:selectMasterData.PrDate,
                PrTime:date.format(selectMasterData.PrTime, 'HH:mm:ss'),
                Repetition:selectMasterData.Repetition
            });
            return obj_res;

        } catch (err) {
            console.log(err);
            throw err;
        }
    }

    // Inserting DT records of permanent table into temporary tables.
    async insertDisintegrationTestTempTables(value, selectMasterData, int_hmiID, detailTableName, repSerNo, WeighmentModeNo, 
        productType, tbl_TempMaster, tbl_TempDetail) 
    {
        try {
            const response = {};
            await this.DeleteEntriesInTempTable(int_hmiID, tbl_TempMaster, tbl_TempDetail); // Again Delete data from Temp Tables.

            const transaction = await seqTransaction.sequelize.transaction(async (t) => {

                const insertDTTempMaster = await models[tbl_TempMaster].create({
                    RepSerNo: selectMasterData.RepSerNo,
                    MstSerNo: selectMasterData.MstSerNo,
                    WgmtModeNo: selectMasterData.WgmtModeNo,
                    ProductType: selectMasterData.ProductType,
                    Area: selectMasterData.Area,
                    CubicalNo: selectMasterData.CubicalNo,
                    CubicleName: selectMasterData.CubicleName,
                    CubicleType: selectMasterData.CubicleType,
                    IPQCType: selectMasterData.IPQCType,
                    CoatingType: selectMasterData.CoatingType,
                    MachineCode: selectMasterData.MachineCode,
                    Department: selectMasterData.Department,
                    BFGCode: selectMasterData.BFGCode,
                    ProductName: selectMasterData.ProductName,
                    PVersion: selectMasterData.PVersion,
                    Version: selectMasterData.Version,
                    BatchNo: selectMasterData.BatchNo,
                    BatchSize: selectMasterData.BatchSize,
                    BMRNo: selectMasterData.BMRNo,
                    GraphType: selectMasterData.GraphType,
                    Qty: selectMasterData.Qty,
                    GrpQty: selectMasterData.GrpQty,
                    GrpFreq: selectMasterData.GrpFreq,
                    Idsno: selectMasterData.Idsno,
                    InstrumentID: selectMasterData.InstrumentID,
                    UserId: selectMasterData.UserId,
                    UserName: selectMasterData.UserName,
                    PrDate: selectMasterData.PrDate,
                    PrTime: date.format(selectMasterData.PrTime, 'HH:mm:ss'),
                    PrEndDate: (selectMasterData.PrEndDate == null) ? 'NULL' : selectMasterData.PrEndDate,
                    PrEndTime: (selectMasterData.PrEndTime == null) ? 'NULL' : date.format(selectMasterData.PrEndTime, 'HH:mm:ss'),                   
                    SideNo: selectMasterData.SideNo,
                    Side: selectMasterData.Side,
                    Unit: selectMasterData.Unit,
                    DecimalPoint: selectMasterData.DecimalPoint,
                    LimitOn: selectMasterData.LimitOn,
                    T1NegTol: selectMasterData.T1NegTol,
                    T1PosTol: selectMasterData.T1PosTol,
                    Nom: selectMasterData.Nom,
                    ReportType: selectMasterData.ReportType,
                    PrintNo: selectMasterData.PrintNo,
                    IsArchived: selectMasterData.IsArchived,
                    BatchComplete: selectMasterData.BatchComplete,
                    CheckedByID: selectMasterData.CheckedByID,
                    CheckedByName: selectMasterData.CheckedByName,
                    CheckedByDate: selectMasterData.CheckedByDate,
                    Media: selectMasterData.Media,
                    Lot: selectMasterData.Lot,
                    MinTemp: selectMasterData.MinTemp,
                    MaxTemp: selectMasterData.MaxTemp,
                    MinTime: selectMasterData.MinTime,
                    Jar: selectMasterData.Jar,
                    Remark: selectMasterData.Remark,
                    FailedRemark: selectMasterData.FailedRemark,
                    FailedRemarkTSH: selectMasterData.FailedRemarkTSH,
                    Inprocess: selectMasterData.Inprocess,
                    HMIID: int_hmiID,
                    MaxTime: selectMasterData.MaxTime,
                    Bath_Temp: selectMasterData.Bath_Temp,
                    Apparatus_Type: selectMasterData.Apparatus_Type
                }, { transaction: t });

                const tempDetailData = await models[detailTableName].findAll({
                    where: { RepSerNo: repSerNo }
                });

                for (const element of tempDetailData) {
                    await models[tbl_TempDetail].create({
                        RecNo: element.RecNo,
                        RepSerNo: element.RepSerNo,
                        MstSerNo: element.MstSerNo,
                        RecSeqNo: element.RecSeqNo,
                        DT_Side: element.DT_Side,
                        DT_Jar: element.DT_Jar,
                        DT_Temp: element.DT_Temp,
                        DT_StartDate: element.DT_StartDate,
                        DT_StartTm: element.DT_StartTm,
                        DT_EndTm: element.DT_EndTm,
                        DT_RunTime: element.DT_RunTime,
                        DT_Remark: element.DT_Remark,
                        DT_DoneByID: element.DT_DoneByID,
                        DT_DoneByName: element.DT_DoneByName,
                        DT_HaltDur: element.DT_HaltDur,
                        Layer: element.Layer,
                        LayerName: element.LayerName,
                        HMIID: int_hmiID,
                        WgmtModeNo: WeighmentModeNo,
                        ProductType: productType,
                    }, { transaction: t });
                }
                return "Success";
            });

            const cnt_recSeqNo = await models[detailTableName].count({
                where: { RepSerNo: repSerNo }
            });
            
            Object.assign(response, {
                waterMark: true,
                printNo: Number(selectMasterData.PrintNo),
                UserId: value.userId,
                UserName: value.username,
                SelectedValue: repSerNo,
                HmiId: int_hmiID,
                WgmtModeNo: WeighmentModeNo,
                ProductType: productType,
                ICReport: value.reportType,
                RecSeqNo: cnt_recSeqNo,
                ReportRemark: selectMasterData.Remark
            });
            return response;

        } catch (err) {
            console.log(err);
            throw err;
        }
    }

    // Inserting Paricle Size records of permanent table into temporary tables.       
    async insertParticleSizeTempTable(value, selectMasterData, int_hmiID, detailTableName, repSerNo, WeighmentModeNo, 
        productType, tbl_TempMaster, tbl_TempDetail) 
    {
        try {
            const obj_res = {};
            await this.DeleteEntriesInTempTable(int_hmiID, tbl_TempMaster, tbl_TempDetail); // Again Delete data from Temp Tables.

            const transaction = await seqTransaction.sequelize.transaction(async (t) => {

                const insertTempData = await models[tbl_TempMaster].create({
                    RepSerNo: selectMasterData.RepSerNo,
                    MstSerNo: selectMasterData.MstSerNo,
                    WgmtModeNo: selectMasterData.WgmtModeNo,
                    ProductType: selectMasterData.ProductType,
                    Area: selectMasterData.Area,
                    CubicalNo: selectMasterData.CubicalNo,
                    CubicleName: selectMasterData.CubicleName,
                    CubicleType: selectMasterData.CubicleType,
                    IPQCType: selectMasterData.IPQCType,
                    CoatingType: selectMasterData.CoatingType,
                    MachineCode: selectMasterData.MachineCode,
                    Department: selectMasterData.Department,
                    BFGCode: selectMasterData.BFGCode,
                    ProductName: selectMasterData.ProductName,
                    PVersion: selectMasterData.PVersion,
                    Version: selectMasterData.Version,
                    BatchNo: selectMasterData.BatchNo,
                    BatchSize: selectMasterData.BatchSize,
                    BMRNo: selectMasterData.BMRNo,
                    GraphType: selectMasterData.GraphType,
                    Qty: selectMasterData.Qty,
                    GrpQty: selectMasterData.GrpQty,
                    GrpFreq: selectMasterData.GrpFreq,
                    Idsno: selectMasterData.Idsno,
                    BalanceId: selectMasterData.BalanceId,
                    VernierId: selectMasterData.VernierId,
                    FriabilityID: selectMasterData.FriabilityID,
                    HardnessID: selectMasterData.HardnessID,
                    UserId: selectMasterData.UserId,
                    UserName: selectMasterData.UserName,
                    PrDate: selectMasterData.PrDate,
                    PrTime: date.format(selectMasterData.PrTime, "HH:mm:ss"),
                    PrEndDate: selectMasterData.PrEndDate,
                    PrEndTime: date.format(selectMasterData.PrEndTime, "HH:mm:ss"),
                    SideNo: selectMasterData.SideNo,
                    Side: selectMasterData.Side,
                    Unit: selectMasterData.Unit,
                    DecimalPoint: selectMasterData.DecimalPoint,
                    LimitOn: selectMasterData.LimitOn,
                    NMT: selectMasterData.NMT,
                    Nom: selectMasterData.Nom,
                    T1NegTol: selectMasterData.T1NegTol,
                    T1PosTol: selectMasterData.T1PosTol,
                    T2NegTol: selectMasterData.T2NegTol,
                    T2PosTol: selectMasterData.T2PosTol,
                    T1NegTolActual: selectMasterData.T1NegTolActual,
                    T1PosTolActual: selectMasterData.T1PosTolActual,
                    T2NegTolActual: selectMasterData.T2NegTolActual,
                    T2PosTolActual: selectMasterData.T2PosTolActual,
                    NomEmpty: selectMasterData.NomEmpty,
                    T1NegEmpty: selectMasterData.T1NegEmpty,
                    T1PosEmpty: selectMasterData.T1PosEmpty,
                    T2NegEmpty: selectMasterData.T2NegEmpty,
                    T2PosEmpty: selectMasterData.T2PosEmpty,
                    NomNet: selectMasterData.NomNet,
                    T1NegNet: selectMasterData.T1NegNet,
                    T1PosNet: selectMasterData.T1PosNet,
                    T2NegNet: selectMasterData.T2NegNet,
                    T2PosNet: selectMasterData.T2PosNet,
                    T1NegNetActual: selectMasterData.T1NegNetActual,
                    T1PosNetActual: selectMasterData.T1PosNetActual,
                    T2NegNetActual: selectMasterData.T2NegNetActual,
                    T2PosNetActual: selectMasterData.T2PosNetActual,
                    ReportType: selectMasterData.ReportType,
                    PrintNo: selectMasterData.PrintNo,
                    IsArchived: selectMasterData.IsArchived,
                    BatchComplete: selectMasterData.BatchComplete,
                    CheckedByID: selectMasterData.CheckedByID,
                    CheckedByName: selectMasterData.CheckedByName,
                    CheckedByDate: selectMasterData.CheckedByDate,
                    Lot: selectMasterData.Lot,
                    NoOfAbove1: selectMasterData.NoOfAbove1,
                    NoOfBelow1: selectMasterData.NoOfBelow1,
                    NoOfAbove2: selectMasterData.NoOfAbove2,
                    NoOfBelow2: selectMasterData.NoOfBelow2,
                    MinPer: selectMasterData.MinPer,
                    MaxPer: selectMasterData.MaxPer,
                    GroupWeight: selectMasterData.GroupWeight,
                    AvgWeight: selectMasterData.AvgWeight,
                    AvgEmpty: selectMasterData.AvgEmpty,
                    AvgNet: selectMasterData.AvgNet,
                    MinWeight: selectMasterData.MinWeight,
                    MaxWeight: selectMasterData.MaxWeight,
                    MinWeightEmpty: selectMasterData.MinWeightEmpty,
                    MaxWeightEmpty: selectMasterData.MaxWeightEmpty,
                    MinWeightNet: selectMasterData.MinWeightNet,
                    MaxWeightNet: selectMasterData.MaxWeightNet,
                    StdDev: selectMasterData.StdDev,
                    Remark: selectMasterData.Remark,
                    FailedRemark: selectMasterData.FailedRemark,
                    FailedRemarkTSH: selectMasterData.FailedRemarkTSH,
                    Inprocess: selectMasterData.Inprocess,
                    Layer: selectMasterData.Layer,
                    Stage: selectMasterData.Stage,
                    LayerName: selectMasterData.LayerName,
                    HMIID: int_hmiID,
                    StdLimit1: selectMasterData.StdLimit1,
                    StdLimit2: selectMasterData.StdLimit2
                }, { transaction: t });

                const tempDetailData = await models[detailTableName].findAll({
                    where: {
                        RepSerNo: repSerNo
                    }
                });

                for (const datavalue of tempDetailData) {
                    const insertTempDetail = {
                        RecNo: datavalue.RecNo,
                        RepSerNo: datavalue.RepSerNo,
                        MstSerNo: datavalue.MstSerNo,
                        RecSeqNo: datavalue.RecSeqNo,
                        DataValue: datavalue.DataValue,
                        DP: datavalue.DP,
                        MeshValue: datavalue.MeshValue,
                        QuantityRetained: datavalue.QuantityRetained,
                        HMIID: int_hmiID,
                        ProductType: productType,
                        WgmtModeNo: WeighmentModeNo,
                        T2NegTol: datavalue.T2NegTol,
                        T2PosTol: datavalue.T2PosTol,
                        SampleQuantity: datavalue.SampleQuantity,
                        FinePer: datavalue.FinePer
                    };

                    if (value.reportOption == '% Fine' || value.reportOption == 'Fine %' || 
                        value.reportOption == '% Fine Layer 1' || value.reportOption == '% Fine Layer 2') 
                    {
                        insertTempDetail.T2NegTol = datavalue.T2NegTol;
                        insertTempDetail.T2PosTol = datavalue.T2PosTol;
                        insertTempDetail.SampleQuantity = datavalue.SampleQuantity;
                        insertTempDetail.FinePer = datavalue.FinePer;
                    }

                    if(value.reportOption == 'Particle Size' || value.reportOption == 'Particle Size Layer 1' || 
                        value.reportOption == 'Particle Size Layer 2'){
                            Object.assign(insertTempDetail,{ MeshPer:datavalue.MeshPer })
                    }
    
                    await models[tbl_TempDetail].create(insertTempDetail, {
                        transaction: t
                    });
                }
                return "Success";
            });

            const cnt_recSeq = await models[detailTableName].count({
                where: { RepSerNo: repSerNo }
            });

            Object.assign(obj_res, {
                waterMark: true,
                printNo: Number(selectMasterData.PrintNo),
                UserId: value.userId,
                UserName: value.username,
                SelectedValue: repSerNo,
                HmiId: int_hmiID,
                WgmtModeNo: WeighmentModeNo,
                ProductType: productType,
                ICReport: value.reportType,
                RecSeqNo: cnt_recSeq,
                ReportRemark: selectMasterData.Remark
            });
            return obj_res;

        } catch (err) {
            console.log(err);
            throw err;
        }
    }

    async increasePrintNo(objPrintCount) {
        try {
            const transaction = await seqTransaction.sequelize.transaction(async (t) => {

                const productType = (objPrintCount.str_url == "Tablet") ? 1 : 2;
                const reportOption = objPrintCount.reportOption;
                const reportType = objPrintCount.reportType;
                const recordFrom = objPrintCount.recordFrom;
                const int_ReportFormat = objPrintCount.int_ReportFormat;
                const now = new Date();

                const str_tableName = await this.getWeighmentsTableName(productType, reportOption, reportType, 
                    recordFrom, int_ReportFormat);
                
                const objTabletGet = await models[str_tableName.masterTableName].findAll({
                    attributes: ['PrintNo'],
                    where: objPrintCount.intReportSerNo
                });

                objPrintCount.intPrintCount = objTabletGet[0].PrintNo + 1;

                await models[str_tableName.masterTableName].update({
                    PrintNo: objPrintCount.intPrintCount
                }, {
                    where:
                        { RepSerNo: objPrintCount.intReportSerNo }, 
                    transaction: t
                });

                await models[str_tableName.strPrintTableName].create({
                    RepSrNo: objPrintCount.intReportSerNo,
                    MstSerNo: objPrintCount.intMasterSerNo,
                    PrintNo: objPrintCount.intPrintCount,
                    Reason: objPrintCount.strReason,
                    Title: str_tableName.intWeighmentSrNo,
                    UserID: objPrintCount.strUserId,
                    UserName: objPrintCount.strUserName,
                    Print_Dt: date.format(now, 'YYYY-MM-DD'),
                    Print_Tm: date.format(now, 'HH:mm:ss'),
                    IsIncomplete: objPrintCount.reportType == "Complete" ? 1 : 0
                }, {
                    transaction: t
                });

                await models.tbl_activity_log.create({
                    dt: date.format(now, 'YYYY-MM-DD'),
                    tm: date.format(now, 'HH:mm:ss'),
                    userid: objPrintCount.strUserId,
                    username: objPrintCount.strUserName,
                    activity: objPrintCount.str_url + " - " + objPrintCount.reportOption + ' Report Printed'
                }, {
                    transaction: t
                });
                return "Success";
            });
            return "Insert";

        } catch (error) {
            console.log("Print Count", error);
            throw error;
        }
    }

    async printReasonReport(value, req) {
        try {
            const clientIp = requestIp.getClientIp(req);
            const productType = value.str_url;
            const reportOption = value.reportOption;
            const reportType = value.reportType;
            const recordFrom = value.recordFrom;
            const int_ReportFormat = value.int_ReportFormat;

            const str_printTableName = await this.getWeighmentsTableName(productType, reportOption, reportType, 
                recordFrom, int_ReportFormat);

            const res = await models[str_printTableName.strPrintTableName].findAll({
                where:
                    { RepSrNo: value.RepSrNo }
            });

            if (res.length > 0) {
                const resPrintExist = await models.tbl_printoutreason_weighingreport.findAll({
                    where:
                        { HMIID: clientIp.split(':')[3] }
                });

                if (resPrintExist.length > 0) {
                    await models.tbl_printoutreason_weighingreport.destroy({
                        where:
                            { HMIID: clientIp.split(':')[3] }
                    });

                    return this.insertInPrintTable(res, clientIp);
                }
                else {
                    return this.insertInPrintTable(res, clientIp);
                }
            }
            else {
                return { status: 'success', data: 'No record Found' };
            }

        } catch (error) {
            console.log("Print Reason For Printout", error);
            throw error;
        }
    }

    async insertInPrintTable(res, clientIp) {
        try {
            const data = {};
            for (const obj of res) {
                await models.tbl_printoutreason_weighingreport.create({
                    RepSrNo: obj.RepSrNo,
                    PrintNo: obj.PrintNo,
                    Reason: obj.Reason,
                    Title: obj.Title,
                    UserID: obj.UserID,
                    UserName: obj.UserName,
                    Print_Dt: obj.Print_Dt,
                    Print_Tm: date.format(obj.Print_Tm, 'HH:mm:ss'),
                    IsIncomplete: obj.IsIncomplete,
                    HMIID: clientIp.split(':')[3]
                });
            }
            Object.assign(data, { HmiId: clientIp.split(':')[3] });
            return data;

        } catch (error) {
            console.log("insertInPrintTable() : ", error);
            throw error;
        }
    }

    async checkReportIsVerified(objReport) {
        try {
            const TableName = await this.getWeighmentsTableName(objReport.productType, objReport.reportOption, 
                objReport.reportType, objReport.recordFrom, objReport.int_ReportFormat);

            const res = await models[TableName.masterTableName].findAll({
                attributes: ['CheckedByID'],
                where: { RepSerNo: objReport.intReportSerNo }
            });
            return res.CheckedByID;

        } catch (error) {
            console.log("checkReportIsVerified() : ", error);
            throw error;
        }
    }

    async verifyReport(objReport) {
        try {
            const transaction = await seqTransaction.sequelize.transaction(async (t) => {

                const now = new Date();
                const str_tableName = await this.getWeighmentsTableName(objReport.productType, objReport.reportOption, 
                    objReport.reportType, objReport.recordFrom, objReport.int_ReportFormat);

                const update = {
                    CheckedByID: objReport.strUserId,
                    CheckedByName: objReport.strUserName,
                    CheckedByDate: date.format(now, 'YYYY-MM-DD'),
                    CheckedByTime: date.format(now, 'HH:mm:ss'),
                    FailedRemark: objReport.strReason
                };

                /* As for Uganda system, Within Limit and Out of Limit reports both will have checked by remark as per DS. */
                // if (objReport.outOfLimit == false)//if out of limit then store remark
                // {
                //     Object.assign(update, { FailedRemark: objReport.strReason });
                // }

                await models[str_tableName.masterTableName].update(update, {
                    where:
                        { RepSerNo: objReport.intReportSerNo },
                    transaction: t
                });

                await models.tbl_activity_log.create({
                    dt: date.format(now, 'YYYY-MM-DD'),
                    tm: date.format(now, 'HH:mm:ss'),
                    userid: objReport.strUserId,
                    username: objReport.strUserName,
                    activity: objReport.reportOption + ' Report Verified'
                }, {
                    transaction: t
                });
            });
            return "Success";

        } catch (error) {
            console.log("Verify", error);
            throw error;
        }
    }

    async verifyExceptionReport(objReport) {
        try {
            const transaction = await seqTransaction.sequelize.transaction(async (t) => {

                let data = await models.tbl_exception_sample.findAll({
                    where: { 
                        RepSerNo: objReport.intReportSerNo,
                        CheckById: { [Op.in]: [null,'NULL']},
                        MenuName: objReport.reportOption
                     }
                })

                //Report Already Verify condition
                if(data.length == 0){
                    return 'Report Already Verified';
                } 

                const now = new Date();

                const update = {
                    CheckById: objReport.strUserId,
                    CheckByName: objReport.strUserName,
                    CheckByDate: date.format(now, 'YYYY-MM-DD')
                };

                await models.tbl_exception_sample.update(update, {
                    where:
                        { 
                            RepSerNo: objReport.intReportSerNo ,
                            MenuName: objReport.reportOption
                        },
                    transaction: t
                });

                await models.tbl_activity_log.create({
                    dt: date.format(now, 'YYYY-MM-DD'),
                    tm: date.format(now, 'HH:mm:ss'),
                    userid: objReport.strUserId,
                    username: objReport.strUserName,
                    activity: objReport.reportOption + ' Report Verified'
                }, {
                    transaction: t
                });

                return "Report Verification Successfull";
            });
            return transaction;

        } catch (error) {
            console.log("Verify", error);
            throw error;
        }
    }

    async getWeighmentReportDetails(reqObj) {
        try {
            const obj_response = {};
            const int_ReportFormat = reqObj.body.int_ReportFormat;
            const reportOption = reqObj.body.reportOption;
            const fromDate = reqObj.body.fromDate;
            const toDate = reqObj.body.toDate;
            const productType = (reqObj.body.str_tabletCapsule == 'Tablet') ? 1 : 2;
            const reportType = reqObj.body.reportType;
            const recordFrom = reqObj.body.recordFrom;
            let testType = reqObj.body.testType;
            let masterTableName = "", detailTableName = "", query = "";
            if (testType == 'Inprocess') { //1:- Startup and 0:- Inprocess
                testType = 0;
            } else {
                testType = 1;
            }
            let isComplete = (reportType == 'Complete' ? 1 : 0)

            const ObjTables = await this.getWeighmentsTableName(productType, reportOption, reportType, recordFrom, int_ReportFormat);
            masterTableName = ObjTables.masterTableName;
            detailTableName = ObjTables.detailTableName;

            if (detailTableName != '') {

                if ((reportOption.includes("Layer 1") == true) && (!reportOption.includes("Individual") == true) && 
                    (!reportOption.includes("Group") == true)) 
                {
                    query = `SELECT DISTINCT m.* FROM  ${masterTableName} m JOIN  ${detailTableName} d ON m.RepSerNo = d.RepSerNo 
                        WHERE m.ReportType = ${testType} AND m.ProductType = ${productType} AND m.Inprocess = 0 
                        AND m.PrDate  BETWEEN '${fromDate}' AND '${toDate}' AND m.Layer = 'Layer 1'`;

                } else if ((reportOption.includes("Layer 2") == true) && (!reportOption.includes("Individual") == true) && 
                    (!reportOption.includes("Group") == true)) 
                {
                    query = `SELECT DISTINCT m.* FROM  ${masterTableName} m JOIN  ${detailTableName} d ON m.RepSerNo = d.RepSerNo 
                        WHERE m.ReportType = ${testType} AND m.ProductType = ${productType} AND m.Inprocess = 0 
                        AND m.PrDate  BETWEEN '${fromDate}' AND '${toDate}' AND m.Layer = 'Layer 2'`;

                } else {
                    query = `SELECT DISTINCT m.* FROM  ${masterTableName} m JOIN  ${detailTableName} d ON m.RepSerNo = d.RepSerNo 
                        WHERE m.ReportType = ${testType} AND m.ProductType = ${productType} AND m.Inprocess = 0 
                        AND m.PrDate  BETWEEN '${fromDate}' AND '${toDate}' AND (m.Layer is NULL OR m.Layer = 'NA')`;
                }

            } else {
                if (reportOption.includes("Friability") == true){ 
                    query = `SELECT * FROM ${masterTableName} WHERE RepSerNo IN (SELECT MIN(RepSerNo) FROM ${masterTableName} where ReportType = ${testType} AND Inprocess = 0 
                    AND ProductType = ${productType} AND PrDate BETWEEN '${fromDate}' AND '${toDate}' group by BFGCode,ProductName,PVersion,Version,BatchNo,Side)`;
                
                } else if (reportOption.includes("Layer 1") == true){
                    query = `SELECT * FROM ${masterTableName} WHERE ReportType = ${testType} AND Inprocess = 0 
                        AND ProductType = ${productType} AND PrDate BETWEEN '${fromDate}' AND '${toDate}' AND Layer = 'Layer 1'`;
                
                } else if (reportOption.includes("Layer 2") == true){
                    query = `SELECT * FROM ${masterTableName} WHERE ReportType = ${testType} AND Inprocess = 0 
                        AND ProductType = ${productType} AND PrDate BETWEEN '${fromDate}' AND '${toDate}' AND Layer = 'Layer 2'`;
                
                } else if(reportOption.includes("Vacuum Leak Test") == true){
                    query = `SELECT * FROM ${masterTableName} WHERE BatchStatus = '${reqObj.body.testType}' AND Inprocess = 0 
                    AND ProductType = ${productType} AND isTestCompleted = ${isComplete} AND PrDate BETWEEN '${fromDate}' AND '${toDate}' AND (Layer is NULL OR Layer = 'NA')`;
                }
                 else { 
                    query = `SELECT * FROM ${masterTableName} WHERE ReportType =' ${testType}' AND Inprocess = 0 
                        AND ProductType = ${productType} AND PrDate BETWEEN '${fromDate}' AND '${toDate}' AND (Layer is NULL OR Layer = 'NA')`;
                }
            }

            query = query + " ORDER BY RepSerNo ";
            
            const result = await sequelize.query(query, {
                type: QueryTypes.SELECT
            });

            if (result.length > 0) {
                Object.assign(obj_response, { status: 'success' }, { result: result });
            } else {
                Object.assign(obj_response, { status: 'success' }, { result: [] });
            }
            return obj_response;

        } catch (error) {
            console.log("getWeighmentReportDetail", error);
            throw error;
        }
    }

    async getWeighmentsTableName(productType, reportOption, reportType, recordFrom, int_ReportFormat) {
        try {
            let masterTableName = "", detailTableName = "", strPrintTableName = "", intWeighmentSrNo = 0;
            let MstTempTbl = "tbl_temp_master", DetTempTbl = "tbl_temp_detail";
            let strPrefix = "", blnIsIncomplete = true, blnIsDetailTable = true, blnIsTempTable = true;
            if (productType == 1) strPrefix = "tab";
            else if (productType == 2) strPrefix = "cap";

            switch (reportOption) {
                case 'Individual':
                    intWeighmentSrNo = 1;
                    break;
                case 'Group':
                    intWeighmentSrNo = 2;
                    MstTempTbl = "tbl_temp_mastergroup";
                    DetTempTbl = "tbl_temp_detailgroup";
                    blnIsIncomplete = false;
                    break;
                case 'Differential':
                case 'Filled Content Weight':
                    intWeighmentSrNo = 3;
                    MstTempTbl = "tbl_temp_masterdiff";
                    DetTempTbl = "tbl_temp_detaildiff";
                    break;
                case 'Thickness':
                    intWeighmentSrNo = 3;
                    break;
                case 'Breadth':
                case 'Width':
                    intWeighmentSrNo = 4;
                    break;
                case 'Length':
                case 'Locked Length':
                case 'Seal Length':
                    intWeighmentSrNo = 5;
                    break;
                case 'Diameter':
                    intWeighmentSrNo = 6;
                    break;
                case 'Hardness':
                    intWeighmentSrNo = 7;
                    masterTableName = "tbl_tab_masterhtd";
                    detailTableName = "tbl_tab_detailhtd";
                    MstTempTbl = "tbl_temp_masterhtd";
                    DetTempTbl = "tbl_temp_detailhtd";
                    strPrintTableName = "tbl_tab_print7";
                    if (reportType == 'Incomplete') {
                        masterTableName = masterTableName + "_incomplete";
                        detailTableName = detailTableName + "_incomplete";
                    } else if (recordFrom == 'Archive') {
                        masterTableName = masterTableName + "_archived";
                        detailTableName = detailTableName + "_archived";
                    }
                    break;
                    //
                    case 'Appearance':
                        intWeighmentSrNo = 14;
                        masterTableName = "tbl_tab_masterapp";
                        detailTableName = "tbl_tab_detailapp";
                        MstTempTbl = "tbl_temp_mastergroup";
                        DetTempTbl = "tbl_temp_detailgroup";
                        strPrintTableName = "tbl_tab_printapp";
                        if (reportType == 'Incomplete') {
                            masterTableName = masterTableName + "_incomplete";
                            detailTableName = detailTableName + "_incomplete";
                        } else if (recordFrom == 'Archive') {
                            masterTableName = masterTableName + "_archived";
                            detailTableName = detailTableName + "_archived";
                        }
                        break;
                case 'Friability':
                    intWeighmentSrNo = 8;
                    blnIsIncomplete = false;
                    if (int_ReportFormat == 1) { //Only for Separate Report Format.
                        strPrintTableName = "tbl_tab_print8";
                        masterTableName = 'tbl_tab_friability';
                        if (recordFrom == 'Archive') {
                            masterTableName = masterTableName + "_archived";
                        }
                        blnIsDetailTable = false;
                        blnIsTempTable = false;

                    } else if (int_ReportFormat == 2) { //Only for Consolidated Report Format.
                        MstTempTbl = "tbl_temp_masterfriability";
                        DetTempTbl = "tbl_temp_detailfriability";
                    }
                    break;
                case 'DT':
                    if (productType == 1) intWeighmentSrNo = 13;
                    else if (productType == 2) intWeighmentSrNo = 6;
                    MstTempTbl = "tbl_temp_masterdt";
                    DetTempTbl = "tbl_temp_detaildt";
                    blnIsIncomplete = false;
                    break;
                case 'DT Layer 1':
                    intWeighmentSrNo = 19;
                    MstTempTbl = "tbl_temp_masterdt";
                    DetTempTbl = "tbl_temp_detaildt";
                    blnIsIncomplete = false;
                    break;
                case 'DT Layer 2':
                    intWeighmentSrNo = 20;
                    MstTempTbl = "tbl_temp_masterdt";
                    DetTempTbl = "tbl_temp_detaildt";
                    blnIsIncomplete = false;
                    break;
                case 'Individual Layer 1':
                    intWeighmentSrNo = 9;
                    break;
                case 'Group Layer 1':
                    intWeighmentSrNo = 10;
                    MstTempTbl = "tbl_temp_mastergroup";
                    DetTempTbl = "tbl_temp_detailgroup";
                    blnIsIncomplete = false;
                    break;
                case 'Individual Layer 2':
                    intWeighmentSrNo = 11;
                    break;
                case 'Group Layer 2':
                    intWeighmentSrNo = 12;
                    MstTempTbl = "tbl_temp_mastergroup";
                    DetTempTbl = "tbl_temp_detailgroup";
                    blnIsIncomplete = false;
                    break;
                //Granulation
                case 'LOD':
                case 'LOD Layer 1':
                case 'LOD Layer 2':
                    intWeighmentSrNo = 16;
                    strPrintTableName = "tbl_tab_printlod";
                    masterTableName = 'tbl_lodmaster';
                    detailTableName = '';
                    if (recordFrom == 'Archive') {
                        masterTableName = masterTableName + "_archived";
                    }
                    blnIsIncomplete = false;
                    blnIsDetailTable = false;
                    blnIsTempTable = false;
                    break;
                case 'Tapped Density':
                case 'Tapped Density Layer 1':
                case 'Tapped Density Layer 2':
                    intWeighmentSrNo = 15;
                    strPrintTableName = "tbl_tab_printtd";
                    masterTableName = 'tbl_tapdensity';
                    detailTableName = '';
                    if (recordFrom == 'Archive') {
                        masterTableName = masterTableName + "_archived";
                    }
                    blnIsIncomplete = false;
                    blnIsDetailTable = false;
                    blnIsTempTable = false;
                    break;
                case 'Fine %':
                case '% Fine':
                case '% Fine Layer 1':
                case '% Fine Layer 2':
                    intWeighmentSrNo = 17;
                    MstTempTbl = "tbl_temp_masterfine";
                    DetTempTbl = "tbl_temp_detailfine";
                    strPrintTableName = "tbl_tab_printfine";
                    break;
                case 'Particle Size':
                case 'Particle Size Layer 1':
                case 'Particle Size Layer 2':
                    intWeighmentSrNo = 18;
                    MstTempTbl = "tbl_temp_masterpsd";
                    DetTempTbl = "tbl_temp_detailpsd";
                    strPrintTableName = "tbl_tab_printpsd";
                    break;
                case 'Vacuum Leak Test':
                    intWeighmentSrNo = 20;
                    masterTableName = 'tbl_leakedtest_master';
                    detailTableName = '';
                    if (recordFrom == 'Archive') {
                        masterTableName = masterTableName + "_archived";
                    }
                    blnIsIncomplete = false;
                    blnIsDetailTable = false;
                    blnIsTempTable = false;
                    strPrintTableName = "tbl_printleaktest";
                    break;
                case 'StartUp':
                    masterTableName = reportType == "Complete" ? ((recordFrom == 'Archive') ? "tbl_tab_initialmaster_archived" : "tbl_tab_initialmaster") : "tbl_tab_initialmaster_incomplete";
                    strPrintTableName = 'tbl_tab_initialmaster_print'; 
                    break;
            }

            if (masterTableName == "") {
                strPrintTableName = (strPrintTableName == "") ? `tbl_${strPrefix}_print${intWeighmentSrNo}` : strPrintTableName;
                masterTableName = `tbl_${strPrefix}_master${intWeighmentSrNo}`;
                detailTableName = `tbl_${strPrefix}_detail${intWeighmentSrNo}`;

                if ((reportType == 'Incomplete') && (blnIsIncomplete == true)) {
                    masterTableName = masterTableName + "_incomplete";
                    detailTableName = detailTableName + "_incomplete";

                } else if (recordFrom == 'Archive') {
                    masterTableName = masterTableName + "_archived";
                    detailTableName = detailTableName + "_archived";
                }
            }

            return {
                masterTableName: masterTableName,
                detailTableName: detailTableName,
                strPrintTableName: strPrintTableName,
                MstTempTbl: MstTempTbl,
                DetTempTbl: DetTempTbl,
                intWeighmentSrNo: intWeighmentSrNo,
                blnIsIncomplete: blnIsIncomplete,
                blnIsDetailTable: blnIsDetailTable,
                blnIsTempTable: blnIsTempTable
            };

        } catch (error) {
            console.log("getWeighmentsTableName() : ", error);
            throw error;
        }
    }

    async getWeighmentReportDetails_Consolidated(reqObj) {
        try {
            const obj_response = {};
            const int_ReportFormat = reqObj.body.int_ReportFormat;
            const reportOption = reqObj.body.reportOption;
            const fromDate = reqObj.body.fromDate;
            const toDate = reqObj.body.toDate;
            const productType = (reqObj.body.str_tabletCapsule == 'Tablet') ? 1 : 2;
            const reportType = reqObj.body.reportType;
            const recordFrom = reqObj.body.recordFrom;
            let testType = reqObj.body.testType;
            let masterTableName = "", detailTableName = "", query = "";
            let strMainQuery = "", strSubQuery = "", strSubCond = "", strGroupBy = "";
            if (testType == 'Inprocess') { //1:- Startup and 0:- Inprocess
                testType = 0;
            } else {
                testType = 1;
            }

            const ObjTables = await this.getWeighmentsTableName(productType, reportOption, reportType, recordFrom, int_ReportFormat);
            masterTableName = ObjTables.masterTableName;
            detailTableName = ObjTables.detailTableName;

            strMainQuery = `SELECT M.RepSerNo, M.MstSerNo, M.BatchNo, M.BFGCode, M.ProductName, M.PrDate,
                M.PVersion, M.Version, M.PrTime, M.Side, M.UserId, M.UserName, M.PrintNo, 
                M.CheckedByID, M.CheckedByName, M.CheckedByDate, M.BatchComplete, M.CubicleType,M.Repetition,M.MPN_Code
                FROM ${masterTableName} M WHERE M.ReportType = ${testType} AND M.Inprocess = 0 
                AND M.ProductType = ${productType} AND M.PrDate BETWEEN '${fromDate}' AND '${toDate}'`;

            if ((reportOption.includes("Layer 1") == true) && (ObjTables.intWeighmentSrNo != 9) && 
                (ObjTables.intWeighmentSrNo != 10)) 
            {
                strSubCond = "AND M.Layer = 'Layer 1'";

            } else if ((reportOption.includes("Layer 2") == true) && (ObjTables.intWeighmentSrNo != 11) && 
                (ObjTables.intWeighmentSrNo != 12)) 
            {
                strSubCond = "AND M.Layer = 'Layer 2'";

            } else {
                strSubCond = "AND (M.Layer IS NULL OR M.Layer = 'NA')";
            }

            if (ObjTables.blnIsDetailTable == true) {
                if ((reportOption !== 'Hardness') && (reportOption !== 'Particle Size') && (reportOption !== 'Particle Size Layer 1')
                    && (reportOption !== 'Particle Size Layer 2') && (reportOption !== '% Fine') && (reportOption !== 'Fine %')
                    && (reportOption !== '% Fine Layer 1') && (reportOption !== '% Fine Layer 2')) 
                {
                    strGroupBy = "GROUP BY M.BatchNo, M.BFGCode, M.ProductName, M.PVersion, M.Version, M.MstSerNo, M.CubicleType";
                } else { // Added for non-consolidated reports.
                    strGroupBy = "GROUP BY M.RepSerNo";
                }
                strSubQuery = `AND M.RepSerNo IN (SELECT DISTINCT MIN(M.RepSerNo) AS RepSerNo 
                    FROM ${masterTableName} M JOIN ${detailTableName} D ON M.RepSerNo = D.RepSerNo
                    WHERE M.ReportType = ${testType} AND M.ProductType = ${productType} AND M.Inprocess = 0 
                    AND M.PrDate BETWEEN '${fromDate}' AND '${toDate}' ${strSubCond} 
                    ${strGroupBy})`;

                query = `${strMainQuery} ${strSubQuery} ${strSubCond}`;

            } else {
                query = `${strMainQuery} ${strSubCond}`;
            }

            query = query + " ORDER BY M.RepSerNo ";
            const result = await sequelize.query(query, {
                type: QueryTypes.SELECT
            });

            if (result.length > 0) {
                Object.assign(obj_response, { status: 'success' }, { result: result });
            } else {
                Object.assign(obj_response, { status: 'success' }, { result: [] });
            }
            return obj_response;

        } catch (error) {
            console.log("getWeighmentReportDetails_Consolidated() : ", error);
            throw error;
        }
    }

    async viewConsolidateReport(value, req) {
        try {
            const responseObj = {};
            const int_ReportFormat = value.int_ReportFormat;
            const clientIp = requestIp.getClientIp(req);
            let ip = clientIp.split(':')[3];
            if ((("idsNo" in value) == true)) {
                ip = `${serverConfig.strIpSeries}${value.idsNo}`;
            } else if (ip === undefined) {
                ip = '127.0.0.1';
            }

            if (value.str_source == "Auto") {
                ip = value.str_hmi;
                console.log("Autoip", ip);
            }

            const int_hmiID = ip;
            const reportOption = value.reportOption;
            const reportType = value.reportType;
            const recordFrom = value.recordFrom;
            const repSerNo = value.RepSerNo;
            const userId = value.userId;
            const userName = value.username;
            const productType = (value.str_url == 'Tablet') ? 1 : 2;
            let masterTableName = "", detailTableName = "", WeighmentModeNo = 0;
            let testType = value.testType;
            if (testType == 'Inprocess') {
                testType = 0;
            } else {
                testType = 1;
            }

            const ObjTables = await this.getWeighmentsTableName(productType, reportOption, reportType, recordFrom, int_ReportFormat);
            masterTableName = ObjTables.masterTableName;
            detailTableName = ObjTables.detailTableName;
            WeighmentModeNo = ObjTables.intWeighmentSrNo;
            const tbl_TempMaster = ObjTables.MstTempTbl;
            const tbl_TempDetail = ObjTables.DetTempTbl;
            let query = "", strMainQuery = "", strSubCond = "";

            strMainQuery = `SELECT * FROM ${masterTableName} WHERE ReportType = ${testType} AND Inprocess = 0 
                AND ProductType = ${productType} AND BFGCode = '${value.ProdID}' AND ProductName = '${(value.ProdName).replace("'","''")}'
                AND PVersion = '${value.ProdVersion}' AND Version = '${value.Version}' AND BatchNo = '${value.BatchNo}'
                AND CubicleType = '${value.CubicleType}'`;

            if ((ObjTables.blnIsDetailTable == true) && ((reportOption !== 'Hardness') && (reportOption !== 'Particle Size') 
                && (reportOption !== 'Particle Size Layer 1') && (reportOption !== 'Particle Size Layer 2') 
                && (reportOption !== '% Fine') && (reportOption !== 'Fine %')
                && (reportOption !== '% Fine Layer 1') && (reportOption !== '% Fine Layer 2')))
            {
                strMainQuery = `${strMainQuery} AND MstSerNo = ${value.MstSerNo}`;
            } else {
                strMainQuery = `${strMainQuery} AND RepSerNo = ${repSerNo}`;
            }

            if ((reportOption.includes("Layer 1") == true) && (ObjTables.intWeighmentSrNo != 9) && 
                (ObjTables.intWeighmentSrNo != 10)) 
            {
                strSubCond = " AND Layer = 'Layer 1'";

            } else if ((reportOption.includes("Layer 2") == true) && (ObjTables.intWeighmentSrNo != 11) && 
                (ObjTables.intWeighmentSrNo != 12)) 
            {
                strSubCond = " AND Layer = 'Layer 2'";

            } else {
                strSubCond = " AND (Layer IS NULL OR Layer = 'NA')";
            }

            query = `${strMainQuery} ${strSubCond} ORDER BY RepSerNo`;
            const selectMasterData = await sequelize.query(query, {
                type: QueryTypes.SELECT
            });

            if (ObjTables.blnIsTempTable == true) {
                // Start Deleting previous Data from temporary Tables.
                await this.DeleteEntriesInTempTable(int_hmiID, tbl_TempMaster, tbl_TempDetail);
                // Completed Deleting previous Data from temporary Tables.

                // Start Inserting records of permanent table into temporary Tables.
                if (reportOption == 'Individual' || reportOption == 'Group' || reportOption == 'Thickness' || 
                    reportOption == 'Breadth' || reportOption == 'Width' || reportOption == 'Length' || reportOption == 'Diameter' ||
                    reportOption == 'Locked Length' || reportOption == 'Seal Length' ||
                    reportOption == 'Individual Layer 1' || reportOption == 'Individual Layer 2' ||
                    reportOption == 'Group Layer 1' || reportOption == 'Group Layer 2' ||
                    reportOption == 'Differential' || reportOption == 'Filled Content Weight') 
                {
                    const res_Obj = await this.insertIndividualTempTables_Consolidated(value, selectMasterData, int_hmiID, 
                        detailTableName, WeighmentModeNo, productType, tbl_TempMaster, tbl_TempDetail);
                    Object.assign(responseObj, res_Obj);

                } else if (reportOption == 'Hardness') 
                {
                    const res_Obj = await this.insertHardnessTempTables_Consolidated(value, selectMasterData, int_hmiID, 
                        detailTableName, WeighmentModeNo, productType, tbl_TempMaster, tbl_TempDetail);
                    Object.assign(responseObj, res_Obj);

                } else if (reportOption == 'Friability') 
                {
                    const res_Obj = await this.insertFriabilityTempTables_Consolidated(value, selectMasterData, int_hmiID, 
                        detailTableName, WeighmentModeNo, productType, tbl_TempMaster, tbl_TempDetail);
                    Object.assign(responseObj, res_Obj);

                } else if (reportOption == 'DT' || reportOption == 'DT Layer 1' || reportOption == 'DT Layer 2') 
                {
                    const res_Obj = await this.insertDisintegrationTestTempTables_Consolidated(value, selectMasterData, int_hmiID, 
                        detailTableName, WeighmentModeNo, productType, tbl_TempMaster, tbl_TempDetail);
                    Object.assign(responseObj, res_Obj);

                } else if (reportOption == 'Particle Size' || reportOption == 'Particle Size Layer 1' || 
                    reportOption == 'Particle Size Layer 2' || reportOption == 'Fine %' ||
                    reportOption == '% Fine' || reportOption == '% Fine Layer 1' || reportOption == '% Fine Layer 2') 
                {
                    const res_Obj = await this.insertParticleSizeTempTable_Consolidated(value, selectMasterData, int_hmiID, 
                        detailTableName, WeighmentModeNo, productType, tbl_TempMaster, tbl_TempDetail);
                    Object.assign(responseObj, res_Obj);

                }
                // Completed Inserting records of permanent table into temporary Tables.
            }

            if (reportOption == 'LOD' || reportOption == 'LOD Layer 1' || reportOption == 'LOD Layer 2' || 
                reportOption == 'Tapped Density' || reportOption == 'Tapped Density Layer 1' || reportOption == 'Tapped Density Layer 2') 
            {
                let RptRemark = 'NA';
                if (selectMasterData.length > 0) {
                    RptRemark = selectMasterData[0].Remark;
                }
                Object.assign(responseObj, {
                    waterMark: true,
                    printNo: value.printNo,
                    UserId: userId,
                    UserName: userName,
                    SelectedValue: repSerNo,
                    HmiId: int_hmiID,
                    WgmtModeNo: WeighmentModeNo,
                    ProductType: productType,
                    ICReport: reportType,
                    ReportRemark: RptRemark
                });
            }
            return responseObj;

        } catch (error) {
            console.log("viewConsolidateReport() : ", error);
            throw error;
        }
    }

    //  Inserting records of permanent table into temporary Tables for major Balance & Vernier parameters. 
    async insertIndividualTempTables_Consolidated(value, selectMasterData, int_hmiID, detailTableName, WeighmentModeNo, 
        productType, tbl_TempMaster, tbl_TempDetail) 
    {
        try {
            const obj_res = {};
            let recSeqCount = 0;
            let recSeqCountR = 0;
            await this.DeleteEntriesInTempTable(int_hmiID, tbl_TempMaster, tbl_TempDetail); // Again Delete data from Temp Tables.

            const transaction = await seqTransaction.sequelize.transaction(async (t) => {

                for (const MasterData of selectMasterData) {

                    /* Master Data Insert */
                    const insertTempMater = {
                        RepSerNo: MasterData.RepSerNo,
                        MstSerNo: MasterData.MstSerNo,
                        WgmtModeNo: MasterData.WgmtModeNo,
                        ProductType: MasterData.ProductType,
                        Area: MasterData.Area,
                        CubicalNo: MasterData.CubicalNo,
                        CubicleName: MasterData.CubicleName,
                        CubicleType: MasterData.CubicleType,
                        IPQCType: MasterData.IPQCType,
                        CoatingType: MasterData.CoatingType,
                        MachineCode: MasterData.MachineCode,
                        Department: MasterData.Department,
                        BFGCode: MasterData.BFGCode,
                        ProductName: MasterData.ProductName,
                        PVersion: MasterData.PVersion,
                        Version: MasterData.Version,
                        BatchNo: MasterData.BatchNo,
                        BatchSize: MasterData.BatchSize,
                        BMRNo: MasterData.BMRNo,
                        GraphType: MasterData.GraphType,
                        Qty: MasterData.Qty,
                        GrpQty: MasterData.GrpQty,
                        GrpFreq: MasterData.GrpFreq,
                        Idsno: MasterData.Idsno,
                        BalanceId: MasterData.BalanceId,
                        VernierId: MasterData.VernierId,
                        FriabilityID: MasterData.FriabilityID,
                        HardnessID: MasterData.HardnessID,
                        UserId: MasterData.UserId,
                        UserName: MasterData.UserName,
                        PrDate: MasterData.PrDate,
                        PrTime: date.format(MasterData.PrTime, 'HH:mm:ss'),
                        PrEndDate: (MasterData.PrEndDate == null) ? 'NULL' : MasterData.PrEndDate,
                        PrEndTime: (MasterData.PrEndTime == null) ? 'NULL' : date.format(MasterData.PrEndTime, 'HH:mm:ss'),
                        SideNo: MasterData.SideNo,
                        Side: MasterData.Side,
                        Stage: MasterData.Stage,
                        Unit: MasterData.Unit,
                        DecimalPoint: MasterData.DecimalPoint,
                        LimitOn: MasterData.LimitOn,
                        NMT: MasterData.NMT,
                        Nom: MasterData.Nom,
                        T1NegTol: MasterData.T1NegTol,
                        T1PosTol: MasterData.T1PosTol,
                        T2NegTol: MasterData.T2NegTol,
                        T2PosTol: MasterData.T2PosTol,
                        T1NegTolActual: MasterData.T1NegTolActual,
                        T1PosTolActual: MasterData.T1PosTolActual,
                        T2NegTolActual: MasterData.T2NegTolActual,
                        T2PosTolActual: MasterData.T2PosTolActual,
                        NomEmpty: MasterData.NomEmpty,
                        T1NegEmpty: MasterData.T1NegEmpty,
                        T1PosEmpty: MasterData.T1PosEmpty,
                        T2NegEmpty: MasterData.T2NegEmpty,
                        T2PosEmpty: MasterData.T2PosEmpty,
                        NomNet: MasterData.NomNet,
                        T1NegNet: MasterData.T1NegNet,
                        T1PosNet: MasterData.T1PosNet,
                        T2NegNet: MasterData.T2NegNet,
                        T2PosNet: MasterData.T2PosNet,
                        T1NegNetActual: MasterData.T1NegNetActual,
                        T1PosNetActual: MasterData.T1PosNetActual,
                        T2NegNetActual: MasterData.T2NegNetActual,
                        T2PosNetActual: MasterData.T2PosNetActual,
                        ReportType: MasterData.ReportType,
                        PrintNo: MasterData.PrintNo,
                        IsArchived: MasterData.IsArchived,
                        BatchComplete: MasterData.BatchComplete,
                        CheckedByID: MasterData.CheckedByID,
                        CheckedByName: MasterData.CheckedByName,
                        CheckedByDate: MasterData.CheckedByDate,
                        CheckedByTime: date.format(MasterData.CheckedByTime, 'HH:mm:ss'),
                        Lot: MasterData.Lot,
                        StdLimit1: MasterData.StdLimit1,
                        StdLimit2: MasterData.StdLimit2,
                        NoOfAbove1: MasterData.NoOfAbove1,
                        NoOfBelow1: MasterData.NoOfBelow1,
                        NoOfAbove2: MasterData.NoOfAbove2,
                        NoOfBelow2: MasterData.NoOfBelow2,
                        MinPer: MasterData.MinPer,
                        MaxPer: MasterData.MaxPer,
                        GroupWeight: MasterData.GroupWeight,
                        AvgWeight: MasterData.AvgWeight,
                        AvgEmpty: MasterData.AvgEmpty,
                        AvgNet: MasterData.AvgNet,
                        MinWeight: MasterData.MinWeight,
                        MaxWeight: MasterData.MaxWeight,
                        MinWeightEmpty: MasterData.MinWeightEmpty,
                        MaxWeightEmpty: MasterData.MaxWeightEmpty,
                        MinWeightNet: MasterData.MinWeightNet,
                        MaxWeightNet: MasterData.MaxWeightNet,
                        StdDev: MasterData.StdDev,
                        Remark: MasterData.Remark,
                        FailedRemark: MasterData.FailedRemark,
                        FailedRemarkTSH: MasterData.FailedRemarkTSH,
                        Inprocess: MasterData.Inprocess,
                        Deviation: MasterData.Deviation,
                        LayerName: MasterData.LayerName,
                        Layer: MasterData.Layer,
                        HMIID: int_hmiID,
                        Nom_stdtarget: MasterData.Nom_stdtarget,
                        TotalWeight: MasterData.TotalWeight
                    };
    
                    if (value.reportOption == 'Group' || value.reportOption == 'Group Layer 1' || 
                        value.reportOption == 'Group Layer 2') 
                    {
                        insertTempMater.MinGrpWeight = MasterData.MinGrpWeight;
                        insertTempMater.MaxGrpWeight = MasterData.MaxGrpWeight;
                        insertTempMater.AvgGrpWeight = MasterData.AvgGrpWeight;
                    }
    
                    await models[tbl_TempMaster].create(insertTempMater, {
                        transaction: t
                    });
                    /* Master Data Insert Done */

                    /* Detail Data Insert */
                    const detailData = await models[detailTableName].findAll({
                        where: { RepSerNo: MasterData.RepSerNo }
                    });

                    for (const data of detailData) {
                        const insertTempDetail = {
                            RecNo: data.RecNo,
                            RepSerNo: data.RepSerNo,
                            MstSerNo: data.MstSerNo,
                            RecSeqNo: data.RecSeqNo,
                            DataValue: data.DataValue,
                            DataValue1: data.DataValue1,
                            NetValue: data.NetValue,
                            AvgWeight: data.AvgWeight,
                            Deviation: data.Deviation,
                            DP: data.DP,
                            UserId: data.UserId,
                            UserName: data.UserName,
                            PrDate: data.PrDate,
                            PrTime: date.format(data.PrTime, 'HH:mm:ss'),
                            PrEndDate: data.PrEndDate,
                            PrEndTime: date.format(data.PrEndTime, 'HH:mm:ss'),
                            BFGCode: data.BFGCode,
                            ProductName: data.ProductName,
                            Version: data.Version,
                            PVersion: data.PVersion,
                            Side: data.Side,
                            BatchNo: data.BatchNo,
                            InstrumentID: data.InstrumentID,
                            Remark: data.Remark,
                            WeighmentMode: WeighmentModeNo,
                            ProductType: productType,
                            HMIID: int_hmiID
                        };

                        if (value.reportOption == 'Group' || value.reportOption == 'Group Layer 1' || 
                            value.reportOption == 'Group Layer 2') 
                        {
                            insertTempDetail.NoOfSample = data.NoOfSample;
                        }

                        await models[tbl_TempDetail].create(insertTempDetail, { transaction: t });
                    }
                    /* Detail Data Insert Done */
                }
                return "Success";
            });

            let intRepSerNo = 0, intRepSerNoR = 0, strIsRHSExist = 'NA', RptRemark = 'NA';
            const RptPrint = Number(selectMasterData[0].PrintNo);
            if (selectMasterData.length == 1) {
                intRepSerNo = selectMasterData[0].RepSerNo;
                RptRemark = selectMasterData[0].Remark;
            }
            if (selectMasterData.length == 2) {
                intRepSerNo = selectMasterData[0].RepSerNo;
                intRepSerNoR = selectMasterData[1].RepSerNo;
                strIsRHSExist = selectMasterData[1].Side;
                if ((selectMasterData[0].Remark == 'Complies') && (selectMasterData[1].Remark == 'Complies')) {
                    RptRemark = 'Complies';
                } else {
                    RptRemark = 'Not Complies';
                }
            }
            recSeqCount = await models[detailTableName].count({
                where: {
                    RepSerNo: intRepSerNo
                }
            });
            recSeqCountR = await models[detailTableName].count({
                where: {
                    RepSerNo: intRepSerNoR
                }
            });
            
            Object.assign(obj_res, {
                waterMark: true,
                printNo: RptPrint,
                UserId: value.userId,
                UserName: value.username,
                SelectedValue: intRepSerNo,
                SelectedValueR: intRepSerNoR,
                HmiId: int_hmiID,
                WgmtModeNo: WeighmentModeNo,
                ProductType: productType,
                ICReport: value.reportType,
                RecSeqNo: recSeqCount,
                RecSeqNoR: recSeqCountR,
                ReportRemark: RptRemark,
                Side: strIsRHSExist
            });
            return obj_res;

        } catch (error) {
            console.log("insertIndividualTempTables_Consolidated() : ", error);
            throw error;
        }
    }

    //  Inserting records of permanent table into temporary Tables for Hardness Consolidated Report. 
    async insertHardnessTempTables_Consolidated(value, selectMasterData, int_hmiID, detailTableName, WeighmentModeNo, 
        productType, tbl_TempMaster, tbl_TempDetail) 
    {
        try {
            const obj_res = {};
            let recSeqCount = 0;
            let recSeqCountR = 0;
            let cntHard = 0, cntThick = 0, cntDiam = 0, cntDOLOB = 0;
            await this.DeleteEntriesInTempTable(int_hmiID, tbl_TempMaster, tbl_TempDetail); // Again Delete data from Temp Tables.

            const transaction = await seqTransaction.sequelize.transaction(async (t) => {

                for (const MasterData of selectMasterData) {

                    /* Master Data Insert */
                    const insertTempMater = {
                        RepSerNo: MasterData.RepSerNo,
                        MstSerNo: MasterData.MstSerNo,
                        Test_Seq: MasterData.MstSerNo,
                        WgmtModeNo: MasterData.WgmtModeNo,
                        ProductType: MasterData.ProductType,
                        Area: MasterData.Area,
                        CubicalNo: MasterData.CubicalNo,
                        CubicleName: MasterData.CubicleName,
                        CubicleType: MasterData.CubicleType,
                        IPQCType: MasterData.IPQCType,
                        CoatingType: MasterData.CoatingType,
                        MachineCode: MasterData.MachineCode,
                        Department: MasterData.Department,
                        BFGCode: MasterData.BFGCode,
                        ProductName: MasterData.ProductName,
                        PVersion: MasterData.PVersion,
                        Version: MasterData.Version,
                        BatchNo: MasterData.BatchNo,
                        BatchSize: MasterData.BatchSize,
                        BMRNo: MasterData.BMRNo,
                        GraphType: MasterData.GraphType,
                        Qty: MasterData.Qty,
                        GrpQty: MasterData.GrpQty,
                        GrpFreq: MasterData.GrpFreq,
                        Idsno: MasterData.Idsno,
                        HardnessID: MasterData.HardnessID,
                        UserId: MasterData.UserId,
                        UserName: MasterData.UserName,
                        PrDate: MasterData.PrDate,
                        PrTime: date.format(MasterData.PrTime, 'HH:mm:ss'),
                        PrEndDate: (MasterData.PrEndDate == null) ? null : MasterData.PrEndDate,
                        PrEndTime: (MasterData.PrEndTime == null) ? '00:00:00' : date.format(MasterData.PrEndTime, 'HH:mm:ss'),
                        SideNo: MasterData.SideNo,
                        Side: MasterData.Side,
                        Unit: MasterData.Unit,
                        DecimalPoint: MasterData.DecimalPoint,
                        LimitOn: MasterData.LimitOn,
                        BLName: MasterData.BLName,
                        NomHard: '0',
                        NomThick: '0',
                        NomDiam: '0',
                        NomBL: '0',
                        T1NegTolHard: '0',
                        T1PosTolHard: '0',
                        T1NegTolThick: '0',
                        T1PosTolThick: '0',
                        T1NegTolDiam: '0',
                        T1PosTolDiam: '0',
                        T1NegTolBL: '0',
                        T1PosTolBL: '0',
                        // T1NegTolHard: MasterData.T1NegTolHard,
                        // T1PosTolHard: MasterData.T1PosTolHard,
                        // T1NegTolThick: MasterData.T1NegTolThick,
                        // T1PosTolThick: MasterData.T1PosTolThick,
                        // T1NegTolDiam: MasterData.T1NegTolDiam,
                        // T1PosTolDiam: MasterData.T1PosTolDiam,
                        // T1NegTolBL: MasterData.T1NegTolBL,
                        // T1PosTolBL: MasterData.T1PosTolBL,
                        T1NegTolActualHard: MasterData.T1NegTolActualHard,
                        T1PosTolActualHard: MasterData.T1PosTolActualHard,
                        T1NegTolActualThick: MasterData.T1NegTolActualThick,
                        T1PosTolActualThick: MasterData.T1PosTolActualThick,
                        T1NegTolActualDiam: MasterData.T1NegTolActualDiam,
                        T1PosTolActualDiam: MasterData.T1PosTolActualDiam,
                        T1NegTolActualBL: MasterData.T1NegTolActualBL,
                        T1PosTolActualBL: MasterData.T1PosTolActualBL,
                        ReportType: MasterData.ReportType,
                        PrintNo: MasterData.PrintNo,
                        IsArchived: MasterData.IsArchived,
                        BatchComplete: MasterData.BatchComplete,
                        CheckedByID: MasterData.CheckedByID,
                        CheckedByName: MasterData.CheckedByName,
                        CheckedByDate: MasterData.CheckedByDate,
                        CheckedByTime: (MasterData.PrEndTime == null) ? '00:00:00' : date.format(MasterData.CheckedByTime, 'HH:mm:ss'),
                        Lot: MasterData.Lot,
                        AvgHard: MasterData.AvgHard,
                        AvgThick: MasterData.AvgThick,
                        AvgDiam: MasterData.AvgDiam,
                        AvgBL: MasterData.AvgBL,
                        MinWeightHard: MasterData.MinWeightHard,
                        MaxWeightHard: MasterData.MaxWeightHard,
                        MinWeightThick: MasterData.MinWeightThick,
                        MaxWeightThick: MasterData.MaxWeightThick,
                        MinWeightDiam: MasterData.MinWeightDiam,
                        MaxWeightDiam: MasterData.MaxWeightDiam,
                        MinWeightBL: MasterData.MinWeightBL,
                        MaxWeightBL: MasterData.MaxWeightBL,
                        StdDevHard: MasterData.StdDevHard,
                        StdDevThick: MasterData.StdDevThick,
                        StdDevDiam: MasterData.StdDevDiam,
                        StdDevBL: MasterData.StdDevBL,
                        RemarkHard: MasterData.RemarkHard,
                        RemarkDiam: MasterData.RemarkDiam,
                        RemarkThick: MasterData.RemarkThick,
                        RemarkBL: MasterData.RemarkBL,
                        FailedRemark: MasterData.FailedRemark,
                        FailedRemarkTSH: MasterData.FailedRemarkTSH,
                        Inprocess: MasterData.Inprocess,
                        HMIID: int_hmiID,
                        Layer: MasterData.Layer,
                        LayerName: MasterData.LayerName,
                        Nom_stdtarget: MasterData.Nom_stdtarget,
                        T2NegTolHard: MasterData.T2NegTolHard,
                        T2PosTolHard: MasterData.T2PosTolHard,
                        T2NegTolThick: MasterData.T2NegTolThick,
                        T2PosTolThick: MasterData.T2PosTolThick,
                        T2NegTolDiam: MasterData.T2NegTolDiam,
                        T2PosTolDiam: MasterData.T2PosTolDiam,
                        T2NegTolBL: MasterData.T2NegTolBL,
                        T2PosTolBL: MasterData.T2PosTolBL,
                        T2NegTolActualHard: MasterData.T2NegTolActualHard,
                        T2PosTolActualHard: MasterData.T2PosTolActualHard,
                        T2NegTolActualThick: MasterData.T2NegTolActualThick,
                        T2PosTolActualThick: MasterData.T2PosTolActualThick,
                        T2NegTolActualDiam: MasterData.T2NegTolActualDiam,
                        T2PosTolActualDiam: MasterData.T2PosTolActualDiam,
                        T2NegTolActualBL: MasterData.T2NegTolActualBL,
                        T2PosTolActualBL: MasterData.T2PosTolActualBL,
                        T3NegTolHard: MasterData.T3NegTolHard,
                        T3PosTolHard: MasterData.T3PosTolHard,
                        T3NegTolThick: MasterData.T3NegTolThick,
                        T3PosTolThick: MasterData.T3PosTolThick,
                        T3NegTolDiam: MasterData.T3NegTolDiam,
                        T3PosTolDiam: MasterData.T3PosTolDiam,
                        T3NegTolBL: MasterData.T3NegTolBL,
                        T3PosTolBL: MasterData.T3PosTolBL,
                        T3NegTolActualHard: MasterData.T3NegTolActualHard,
                        T3PosTolActualHard: MasterData.T3PosTolActualHard,
                        T3NegTolActualThick: MasterData.T3NegTolActualThick,
                        T3PosTolActualThick: MasterData.T3PosTolActualThick,
                        T3NegTolActualDiam: MasterData.T3NegTolActualDiam,
                        T3PosTolActualDiam: MasterData.T3PosTolActualDiam,
                        T3NegTolActualBL: MasterData.T3NegTolActualBL,
                        T3PosTolActualBL: MasterData.T3PosTolActualBL,
                        SFOID: MasterData.SFOID,
                        Repetition: MasterData.Repetition,
                        MPN_Code: MasterData.MPN_Code,
                    };
    
                    await models[tbl_TempMaster].create(insertTempMater, {
                        transaction: t
                    });
                    /* Master Data Insert Done */

                    /* Detail Data Insert */
                    const detailData = await models[detailTableName].findAll({
                        where: { RepSerNo: MasterData.RepSerNo }
                    });

                    for (const data of detailData) {
                        const insertTempDetail = {
                            RecNo: data.RecNo,
                            RepSerNo: data.RepSerNo,
                            MstSerNo: data.MstSerNo,
                            RecSeqNo: data.RecSeqNo,
                            DataValueHard: data.DataValueHard,
                            DataValueThick: data.DataValueThick,
                            DataValueDiam: data.DataValueDiam,
                            DataValueBL: data.DataValueBL,
                            HMIID: int_hmiID,
                            WeighmentMode: WeighmentModeNo,
                            ProductType: productType
                        };

                        if (this.IsDataValueValid(data.DataValueHard) === true) {
                            cntHard = cntHard + 1;
                        }
                        if (this.IsDataValueValid(data.DataValueThick) === true) {
                            cntThick = cntThick + 1;
                        }
                        if (this.IsDataValueValid(data.DataValueDiam) === true) {
                            cntDiam = cntDiam + 1;
                        }
                        if (this.IsDataValueValid(data.DataValueBL) === true) {
                            cntDOLOB = cntDOLOB + 1;
                        }

                        await models[tbl_TempDetail].create(insertTempDetail, { transaction: t });
                    }
                    /* Detail Data Insert Done */
                }
                return "Success";
            });

            let intRepSerNo = 0, intRepSerNoR = 0, strIsRHSExist = 'NA', RptRemark = 'NA';
            const RptPrint = Number(selectMasterData[0].PrintNo);
            if (selectMasterData.length == 1) {
                intRepSerNo = selectMasterData[0].RepSerNo;
                RptRemark = selectMasterData[0].Remark;
            }
            if (selectMasterData.length == 2) {
                intRepSerNo = selectMasterData[0].RepSerNo;
                intRepSerNoR = selectMasterData[1].RepSerNo;
                strIsRHSExist = selectMasterData[1].Side;
                if ((selectMasterData[0].Remark == 'Complies') && (selectMasterData[1].Remark == 'Complies')) {
                    RptRemark = 'Complies';
                } else {
                    RptRemark = 'Not Complies';
                }
            }
            recSeqCount = await models[detailTableName].count({
                where: {
                    RepSerNo: intRepSerNo
                }
            });
            recSeqCountR = await models[detailTableName].count({
                where: {
                    RepSerNo: intRepSerNoR
                }
            });
            
            Object.assign(obj_res, {
                waterMark: true,
                printNo: RptPrint,
                UserId: value.userId,
                UserName: value.username,
                SelectedValue: intRepSerNo,
                SelectedValueR: intRepSerNoR,
                HmiId: int_hmiID,
                WgmtModeNo: WeighmentModeNo,
                ProductType: productType,
                ICReport: value.reportType,
                RecSeqNo: recSeqCount,
                RecSeqNoR: recSeqCountR,
                ReportRemark: RptRemark,
                Side: strIsRHSExist,
                cntHard: cntHard,
                cntThick: cntThick,
                cntDiam: cntDiam,
                cntDOLOB: cntDOLOB
            });
            return obj_res;

        } catch (error) {
            console.log("insertHardnessTempTables_Consolidated() : ", error);
            throw error;
        }
    }

    //  Inserting records of permanent table into temporary Tables for Friability Consolidated Report. 
    async insertFriabilityTempTables_Consolidated(value, selectMasterData, int_hmiID, detailTableName, WeighmentModeNo, 
        productType, tbl_TempMaster, tbl_TempDetail) 
    {
        try {
            const obj_res = {};
            let recSeqCount = 0;
            let recSeqCountR = 0;
            var detailData;
            await this.DeleteEntriesInTempTable(int_hmiID, tbl_TempMaster, tbl_TempDetail); // Again Delete data from Temp Tables.

            const transaction = await seqTransaction.sequelize.transaction(async (t) => {

                for (const MasterData of selectMasterData) {

                    /* Master Data Insert */
                    const insertTempMater = {
                        RepSerNo: MasterData.RepSerNo,
                        MstSerNo: MasterData.MstSerNo,
                        SrNo: MasterData.SrNo,
                        Area: MasterData.Area,
                        CubicleName: MasterData.CubicleName,
                        CubicalNo: MasterData.CubicalNo,
                        CubicleType: MasterData.CubicleType,
                        IPQCType: MasterData.IPQCType,
                        CoatingType: MasterData.CoatingType,
                        ProductType: MasterData.ProductType,
                        ReportType: MasterData.ReportType,
                        Department: MasterData.Department,
                        BFGCode: MasterData.BFGCode,
                        ProductName: MasterData.ProductName,
                        PVersion: MasterData.PVersion,
                        Version: MasterData.Version,
                        BatchNo: MasterData.BatchNo,
                        BMRNo: MasterData.BMRNo,
                        BatchSize: MasterData.BatchSize,
                        MachineCode: MasterData.MachineCode,
                        BalanceId: MasterData.BalanceId,
                        FriabilityID: MasterData.FriabilityID,
                        Idsno: MasterData.Idsno,
                        Qty: MasterData.Qty,
                        UserId: MasterData.UserId,
                        UserName: MasterData.UserName,
                        PrDate: MasterData.PrDate,
                        PrTime: date.format(MasterData.PrTime, 'HH:mm:ss'),
                        PrEndDate: (MasterData.PrEndDate == null) ? 'NULL' : MasterData.PrEndDate,
                        PrEndTime: (MasterData.PrEndTime == null) ? 'NULL' : date.format(MasterData.PrEndTime, 'HH:mm:ss'),
                        Side: MasterData.Side,
                        Stage: MasterData.Stage,
                        Unit: MasterData.Unit,
                        DecimalPoint: MasterData.DecimalPoint,
                        NMT: MasterData.NMT,
                        SetCount: MasterData.SetCount,
                        SetRPM: MasterData.SetRPM,
                        PrintNo: MasterData.PrintNo,
                        IsArchived: MasterData.IsArchived,
                        BatchComplete: MasterData.BatchComplete,
                        CheckedByID: MasterData.CheckedByID,
                        CheckedByName: MasterData.CheckedByName,
                        CheckedByDate: MasterData.CheckedByDate,
                        CheckedByTime: date.format(MasterData.CheckedByTime, 'HH:mm:ss'),
                        Lot: MasterData.Lot,
                        LayerName: MasterData.LayerName,
                        Layer: MasterData.Layer,
                        Inprocess: MasterData.Inprocess,
                        Remark: MasterData.Remark,
                        WeighmentMode: WeighmentModeNo,
                        HMIID: int_hmiID,
                        MPN_Code: MasterData.MPN_Code,
                        Repetition: MasterData.Repetition,
                        SFOID: MasterData.SFOID,

                    };
    
                    await models[tbl_TempMaster].create(insertTempMater, {
                        transaction: t
                    });
                    /* Master Data Insert Done */

                    /* Detail Data Insert */
                     detailData = await models[detailTableName].findAll({
                        where: { RepSerNo: MasterData.RepSerNo }
                    });

                    for (const data of detailData) {
                        const insertTempDetail = {
                            RecNo: data.RecNo,
                            RepSerNo: data.RepSerNo,
                            MstSerNo: data.MstSerNo,
                            RecSeqNo: data.RecSeqNo,
                            InitialWt: data.InitialWt,
                            FinalWt: data.FinalWt,
                            FriabVal: data.FriabVal,
                            DP: data.DP,
                            UserId: data.UserId,
                            UserName: data.UserName,
                            PrDate: data.PrDate,
                            PrTime: date.format(data.PrTime, 'HH:mm:ss'),
                            PrEndDate: data.PrEndDate,
                            PrEndTime: date.format(data.PrEndTime, 'HH:mm:ss'),
                            Side: data.Side,
                            BalanceID: data.BalanceID,
                            IdsNo: data.IdsNo,
                            Remark: data.Remark,
                            WeighmentMode: WeighmentModeNo,
                            ProductType: productType,
                            HMIID: int_hmiID
                        };

                        await models[tbl_TempDetail].create(insertTempDetail, { transaction: t });
                    }
                    /* Detail Data Insert Done */
                }
                return "Success";
            });

            let intRepSerNo = 0, intRepSerNoR = 0, strIsRHSExist = 'NA', RptRemark = 'NA';
            const RptPrint = Number(selectMasterData[0].PrintNo);
            if (selectMasterData.length == 1) {
                intRepSerNo = selectMasterData[0].RepSerNo;
                RptRemark = selectMasterData[0].Remark;
            }
            if (selectMasterData.length == 2) {
                intRepSerNo = selectMasterData[0].RepSerNo;
                intRepSerNoR = selectMasterData[1].RepSerNo;
                strIsRHSExist = selectMasterData[1].Side;
                if ((selectMasterData[0].Remark == 'Complies') && (selectMasterData[1].Remark == 'Complies')) {
                    RptRemark = 'Complies';
                } else {
                    RptRemark = 'Not Complies';
                }
            }
            recSeqCount = await models[detailTableName].count({
                where: {
                    RepSerNo: intRepSerNo
                }
            });
            recSeqCountR = await models[detailTableName].count({
                where: {
                    RepSerNo: intRepSerNoR
                }
            });
            
            Object.assign(obj_res, {
                waterMark: true,
                printNo: RptPrint,
                UserId: value.userId,
                UserName: value.username,
                SelectedValue: intRepSerNo,
                SelectedValueR: intRepSerNo, // As per discussed with Aditya for RHS pass same LHS RepSerNo.
                HmiId: int_hmiID,
                WgmtModeNo: WeighmentModeNo,
                ProductType: productType,
                ICReport: value.reportType,
                RecSeqNo: recSeqCount,
                RecSeqNoR: recSeqCountR,
                ReportRemark: RptRemark,
                Side: (detailData.length == 2 ? "RHS" : strIsRHSExist) // As per discussed with Aditya Send RHS for RHS graph.
            });
            return obj_res;

        } catch (error) {
            console.log("insertFriabilityTempTables_Consolidated() : ", error);
            throw error;
        }
    }

    // Inserting DT records of permanent table into temporary tables for Consolidated reports.
    async insertDisintegrationTestTempTables_Consolidated(value, selectMasterData, int_hmiID, detailTableName, WeighmentModeNo, 
        productType, tbl_TempMaster, tbl_TempDetail) 
    {
        try {
            const obj_res = {};
            let recSeqCount = 0;
            let recSeqCountR = 0;
            await this.DeleteEntriesInTempTable(int_hmiID, tbl_TempMaster, tbl_TempDetail); // Again Delete data from Temp Tables.

            const transaction = await seqTransaction.sequelize.transaction(async (t) => {

                for (const MasterData of selectMasterData) {

                    /* Master Data Insert */
                    const insertDTTempMaster = {
                        RepSerNo: MasterData.RepSerNo,
                        MstSerNo: MasterData.MstSerNo,
                        WgmtModeNo: MasterData.WgmtModeNo,
                        ProductType: MasterData.ProductType,
                        Area: MasterData.Area,
                        CubicalNo: MasterData.CubicalNo,
                        CubicleName: MasterData.CubicleName,
                        CubicleType: MasterData.CubicleType,
                        IPQCType: MasterData.IPQCType,
                        CoatingType: MasterData.CoatingType,
                        MachineCode: MasterData.MachineCode,
                        Department: MasterData.Department,
                        BFGCode: MasterData.BFGCode,
                        ProductName: MasterData.ProductName,
                        PVersion: MasterData.PVersion,
                        Version: MasterData.Version,
                        BatchNo: MasterData.BatchNo,
                        BatchSize: MasterData.BatchSize,
                        BMRNo: MasterData.BMRNo,
                        GraphType: MasterData.GraphType,
                        Qty: MasterData.Qty,
                        GrpQty: MasterData.GrpQty,
                        GrpFreq: MasterData.GrpFreq,
                        Idsno: MasterData.Idsno,
                        InstrumentID: MasterData.InstrumentID,
                        UserId: MasterData.UserId,
                        UserName: MasterData.UserName,
                        PrDate: MasterData.PrDate,
                        PrTime: date.format(MasterData.PrTime, 'HH:mm:ss'),
                        PrEndDate: (MasterData.PrEndDate == null) ? 'NULL' : MasterData.PrEndDate,
                        PrEndTime: (MasterData.PrEndTime == null) ? 'NULL' : date.format(MasterData.PrEndTime, 'HH:mm:ss'),
                        SideNo: MasterData.SideNo,
                        Side: MasterData.Side,
                        Unit: MasterData.Unit,
                        DecimalPoint: MasterData.DecimalPoint,
                        LimitOn: MasterData.LimitOn,
                        T1NegTol: MasterData.T1NegTol,
                        T1PosTol: MasterData.T1PosTol,
                        Nom: MasterData.Nom,
                        ReportType: MasterData.ReportType,
                        PrintNo: MasterData.PrintNo,
                        IsArchived: MasterData.IsArchived,
                        BatchComplete: MasterData.BatchComplete,
                        CheckedByID: MasterData.CheckedByID,
                        CheckedByName: MasterData.CheckedByName,
                        CheckedByDate: MasterData.CheckedByDate,
                        Media: MasterData.Media,
                        Lot: MasterData.Lot,
                        MinTemp: MasterData.MinTemp,
                        MaxTemp: MasterData.MaxTemp,
                        MinTime: MasterData.MinTime,
                        Jar: MasterData.Jar,
                        Remark: MasterData.Remark,
                        FailedRemark: MasterData.FailedRemark,
                        FailedRemarkTSH: MasterData.FailedRemarkTSH,
                        Inprocess: MasterData.Inprocess,
                        HMIID: int_hmiID,
                        MaxTime: MasterData.MaxTime,
                        StdTime: MasterData.StdTime,
                        TempRange: MasterData.TempRange,
                        LayerName: MasterData.LayerName,
                        Nom_stdtarget: MasterData.Nom_stdtarget,
                        Layer: MasterData.Layer,
                        MeshSize_Bolus: MasterData.MeshSize_Bolus,
                        Media_Temp: MasterData.Media_Temp,
                        Bath_Temp: MasterData.Bath_Temp,
                        Apparatus_Type: MasterData.Apparatus_Type,
                        Program_No: MasterData.Program_No,
                        CheckedByTime: date.format(MasterData.CheckedByTime, 'HH:mm:ss')
                    };

                    await models[tbl_TempMaster].create(insertDTTempMaster, { 
                        transaction: t 
                    });
                    /* Master Data Insert Done */

                    /* Detail Data Insert */
                    const detailData = await models[detailTableName].findAll({
                        where: { RepSerNo: MasterData.RepSerNo }
                    });

                    for (const data of detailData) {
                        const insertDTTempDetail = {
                            RecNo: data.RecNo,
                            RepSerNo: data.RepSerNo,
                            MstSerNo: data.MstSerNo,
                            RecSeqNo: data.RecSeqNo,
                            DT_Side: data.DT_Side,
                            DT_Jar: data.DT_Jar,
                            DT_Temp: data.DT_Temp,
                            DT_StartDate: data.DT_StartDate,
                            DT_StartTm: data.DT_StartTm,
                            DT_EndTm: data.DT_EndTm,
                            DT_RunTime: data.DT_RunTime,
                            DT_Remark: data.DT_Remark,
                            DT_DoneByID: data.DT_DoneByID,
                            DT_DoneByName: data.DT_DoneByName,
                            DT_HaltDur: data.DT_HaltDur,
                            Layer: data.Layer,
                            LayerName: data.LayerName,
                            HMIID: int_hmiID,
                            WgmtModeNo: WeighmentModeNo,
                            ProductType: productType,
                        };

                        await models[tbl_TempDetail].create(insertDTTempDetail, { transaction: t });
                    }
                    /* Detail Data Insert Done */
                }
                return "Success";
            });

            let intRepSerNo = 0, intRepSerNoR = 0, strIsRHSExist = 'NA', RptRemark = 'NA';
            const RptPrint = Number(selectMasterData[0].PrintNo);
            if (selectMasterData.length == 1) {
                intRepSerNo = selectMasterData[0].RepSerNo;
                RptRemark = selectMasterData[0].Remark;
            }
            if (selectMasterData.length == 2) {
                intRepSerNo = selectMasterData[0].RepSerNo;
                intRepSerNoR = selectMasterData[1].RepSerNo;
                strIsRHSExist = selectMasterData[1].Side;
                if ((selectMasterData[0].Remark == 'Complies') && (selectMasterData[1].Remark == 'Complies')) {
                    RptRemark = 'Complies';
                } else {
                    RptRemark = 'Not Complies';
                }
            }
            recSeqCount = await models[detailTableName].count({
                where: {
                    RepSerNo: intRepSerNo
                }
            });
            recSeqCountR = await models[detailTableName].count({
                where: {
                    RepSerNo: intRepSerNoR
                }
            });

            Object.assign(obj_res, {
                waterMark: true,
                printNo: RptPrint,
                UserId: value.userId,
                UserName: value.username,
                SelectedValue: intRepSerNo,
                SelectedValueR: intRepSerNoR,
                HmiId: int_hmiID,
                WgmtModeNo: WeighmentModeNo,
                ProductType: productType,
                ICReport: value.reportType,
                RecSeqNo: recSeqCount,
                RecSeqNoR: recSeqCountR,
                ReportRemark: RptRemark,
                Side: strIsRHSExist
            });
            return obj_res;

        } catch (error) {
            console.log("insertDisintegrationTestTempTables_Consolidated() : ", error);
            throw error;
        }
    }

    // Inserting Paricle Size records of permanent table into temporary tables for Consolidated reports.       
    async insertParticleSizeTempTable_Consolidated(value, selectMasterData, int_hmiID, detailTableName, WeighmentModeNo, 
        productType, tbl_TempMaster, tbl_TempDetail) 
    {
        try {
            const obj_res = {};
            let recSeqCount = 0;
            let recSeqCountR = 0;
            await this.DeleteEntriesInTempTable(int_hmiID, tbl_TempMaster, tbl_TempDetail); // Again Delete data from Temp Tables.

            const transaction = await seqTransaction.sequelize.transaction(async (t) => {

                for (const MasterData of selectMasterData) {

                    /* Master Data Insert */
                    const insertTempData = {
                        RepSerNo: MasterData.RepSerNo,
                        MstSerNo: MasterData.MstSerNo,
                        WgmtModeNo: MasterData.WgmtModeNo,
                        ProductType: MasterData.ProductType,
                        Area: MasterData.Area,
                        CubicalNo: MasterData.CubicalNo,
                        CubicleName: MasterData.CubicleName,
                        CubicleType: MasterData.CubicleType,
                        IPQCType: MasterData.IPQCType,
                        CoatingType: MasterData.CoatingType,
                        MachineCode: MasterData.MachineCode,
                        Department: MasterData.Department,
                        BFGCode: MasterData.BFGCode,
                        ProductName: MasterData.ProductName,
                        PVersion: MasterData.PVersion,
                        Version: MasterData.Version,
                        BatchNo: MasterData.BatchNo,
                        BatchSize: MasterData.BatchSize,
                        BMRNo: MasterData.BMRNo,
                        GraphType: MasterData.GraphType,
                        Qty: MasterData.Qty,
                        GrpQty: MasterData.GrpQty,
                        GrpFreq: MasterData.GrpFreq,
                        Idsno: MasterData.Idsno,
                        BalanceId: MasterData.BalanceId,
                        VernierId: MasterData.VernierId,
                        FriabilityID: MasterData.FriabilityID,
                        HardnessID: MasterData.HardnessID,
                        UserId: MasterData.UserId,
                        UserName: MasterData.UserName,
                        PrDate: MasterData.PrDate,
                        PrTime: date.format(MasterData.PrTime, "HH:mm:ss"),
                        PrEndDate: (MasterData.PrEndDate == null) ? 'NULL' : MasterData.PrEndDate,
                        PrEndTime: (MasterData.PrEndTime == null) ? 'NULL' : date.format(MasterData.PrEndTime, 'HH:mm:ss'),
                        SideNo: MasterData.SideNo,
                        Side: MasterData.Side,
                        Unit: MasterData.Unit,
                        DecimalPoint: MasterData.DecimalPoint,
                        LimitOn: MasterData.LimitOn,
                        NMT: MasterData.NMT,
                        Nom: MasterData.Nom,
                        T1NegTol: MasterData.T1NegTol,
                        T1PosTol: MasterData.T1PosTol,
                        T2NegTol: MasterData.T2NegTol,
                        T2PosTol: MasterData.T2PosTol,
                        T1NegTolActual: MasterData.T1NegTolActual,
                        T1PosTolActual: MasterData.T1PosTolActual,
                        T2NegTolActual: MasterData.T2NegTolActual,
                        T2PosTolActual: MasterData.T2PosTolActual,
                        NomEmpty: MasterData.NomEmpty,
                        T1NegEmpty: MasterData.T1NegEmpty,
                        T1PosEmpty: MasterData.T1PosEmpty,
                        T2NegEmpty: MasterData.T2NegEmpty,
                        T2PosEmpty: MasterData.T2PosEmpty,
                        NomNet: MasterData.NomNet,
                        T1NegNet: MasterData.T1NegNet,
                        T1PosNet: MasterData.T1PosNet,
                        T2NegNet: MasterData.T2NegNet,
                        T2PosNet: MasterData.T2PosNet,
                        T1NegNetActual: MasterData.T1NegNetActual,
                        T1PosNetActual: MasterData.T1PosNetActual,
                        T2NegNetActual: MasterData.T2NegNetActual,
                        T2PosNetActual: MasterData.T2PosNetActual,
                        ReportType: MasterData.ReportType,
                        PrintNo: MasterData.PrintNo,
                        IsArchived: MasterData.IsArchived,
                        BatchComplete: MasterData.BatchComplete,
                        CheckedByID: MasterData.CheckedByID,
                        CheckedByName: MasterData.CheckedByName,
                        CheckedByDate: MasterData.CheckedByDate,
                        Lot: MasterData.Lot,
                        NoOfAbove1: MasterData.NoOfAbove1,
                        NoOfBelow1: MasterData.NoOfBelow1,
                        NoOfAbove2: MasterData.NoOfAbove2,
                        NoOfBelow2: MasterData.NoOfBelow2,
                        MinPer: MasterData.MinPer,
                        MaxPer: MasterData.MaxPer,
                        GroupWeight: MasterData.GroupWeight,
                        AvgWeight: MasterData.AvgWeight,
                        AvgEmpty: MasterData.AvgEmpty,
                        AvgNet: MasterData.AvgNet,
                        MinWeight: MasterData.MinWeight,
                        MaxWeight: MasterData.MaxWeight,
                        MinWeightEmpty: MasterData.MinWeightEmpty,
                        MaxWeightEmpty: MasterData.MaxWeightEmpty,
                        MinWeightNet: MasterData.MinWeightNet,
                        MaxWeightNet: MasterData.MaxWeightNet,
                        StdDev: MasterData.StdDev,
                        Remark: MasterData.Remark,
                        FailedRemark: MasterData.FailedRemark,
                        FailedRemarkTSH: MasterData.FailedRemarkTSH,
                        Inprocess: MasterData.Inprocess,
                        Layer: MasterData.Layer,
                        LayerName: MasterData.LayerName,
                        HMIID: int_hmiID,
                        Nom_stdtarget: MasterData.Nom_stdtarget,
                        TotalWeight: MasterData.TotalWeight,
                        MinGrpWeight: MasterData.MinGrpWeight,
                        MaxGrpWeight: MasterData.MaxGrpWeight,
                        AvgGrpWeight: MasterData.AvgGrpWeight,
                        Stage: MasterData.Stage,
                        StdLimit1: MasterData.StdLimit1,
                        StdLimit2: MasterData.StdLimit2,
                        Deviation: MasterData.Deviation,
                        SieveID: MasterData.SieveID,
                        CheckedByTime: date.format(MasterData.CheckedByTime, "HH:mm:ss")
                    };

                    await models[tbl_TempMaster].create(insertTempData, { 
                        transaction: t 
                    });
                    /* Master Data Insert Done */

                    /* Detail Data Insert */
                    const detailData = await models[detailTableName].findAll({
                        where: { RepSerNo: MasterData.RepSerNo }
                    });
    
                    for (const data of detailData) {
                        const insertTempDetail = {
                            RecNo: data.RecNo,
                            RepSerNo: data.RepSerNo,
                            MstSerNo: data.MstSerNo,
                            RecSeqNo: data.RecSeqNo,
                            DataValue: data.DataValue,
                            DP: data.DP,
                            MeshValue: data.MeshValue,
                            QuantityRetained: data.QuantityRetained,
                            HMIID: int_hmiID,
                            ProductType: productType,
                            WgmtModeNo: WeighmentModeNo,
                            T2NegTol: data.T2NegTol,
                            T2PosTol: data.T2PosTol,
                            SampleQuantity:data.SampleQuantity,
                            FinePer:data.FinePer
                        };
    
                        if (value.reportOption == '% Fine' || value.reportOption == 'Fine %' || 
                            value.reportOption == '% Fine Layer 1' || value.reportOption == '% Fine Layer 2') 
                        {
                            insertTempDetail.T2NegTol = data.T2NegTol;
                            insertTempDetail.T2PosTol = data.T2PosTol;
                            insertTempDetail.SampleQuantity = data.SampleQuantity;
                            insertTempDetail.FinePer = data.FinePer;
                        }
        
                        await models[tbl_TempDetail].create(insertTempDetail, { transaction: t });
                    }
                    /* Detail Data Insert Done */
                }
                return "Success";
            });

            let intRepSerNo = 0, intRepSerNoR = 0, strIsRHSExist = 'NA', RptRemark = 'NA';
            const RptPrint = Number(selectMasterData[0].PrintNo);
            if (selectMasterData.length == 1) {
                intRepSerNo = selectMasterData[0].RepSerNo;
                RptRemark = selectMasterData[0].Remark;
            }
            if (selectMasterData.length == 2) {
                intRepSerNo = selectMasterData[0].RepSerNo;
                intRepSerNoR = selectMasterData[1].RepSerNo;
                strIsRHSExist = selectMasterData[1].Side;
                if ((selectMasterData[0].Remark == 'Complies') && (selectMasterData[1].Remark == 'Complies')) {
                    RptRemark = 'Complies';
                } else {
                    RptRemark = 'Not Complies';
                }
            }
            recSeqCount = await models[detailTableName].count({
                where: {
                    RepSerNo: intRepSerNo
                }
            });
            recSeqCountR = await models[detailTableName].count({
                where: {
                    RepSerNo: intRepSerNoR
                }
            });

            Object.assign(obj_res, {
                waterMark: true,
                printNo: RptPrint,
                UserId: value.userId,
                UserName: value.username,
                SelectedValue: intRepSerNo,
                SelectedValueR: intRepSerNoR,
                HmiId: int_hmiID,
                WgmtModeNo: WeighmentModeNo,
                ProductType: productType,
                ICReport: value.reportType,
                RecSeqNo: recSeqCount,
                RecSeqNoR: recSeqCountR,
                ReportRemark: RptRemark,
                Side: strIsRHSExist
            });
            return obj_res;

        } catch (error) {
            console.log("insertParticleSizeTempTable_Consolidated() : ", error);
            throw error;
        }
    }

    IsDataValueValid(DataValue) {
        try {
            let int_cnt = 0;
            let strArr_InvalidChars = ["NA", "FL", "--", "99999.00", "99999", 
                "99998.00", "99998", "0", "9999", "9999.00"];
            
            if (strArr_InvalidChars.includes(DataValue)) {
                int_cnt = int_cnt + 1;
            }
            if (int_cnt > 0) {
                return true;
            } else {
                return false;
            }

        } catch (error) {
            console.log("IsDataValueValid() : ", error);
            throw error;
        }
    }

    async getWeighmentReportDetails_StartUp(reqObj) 
    {
        try {
            const obj_response = {};
            const dt_fromDate = reqObj.body.fromDate;
            const dt_toDate = reqObj.body.toDate;
            const str_productType = (reqObj.body.str_tabletCapsule == 'Tablet') ? 1 : 2;
            var cntRecordFound = 0,str_master = "",sarr_data = [];
            var int_testType =  (reqObj.body.testType == "Startup" || reqObj.body.testType == "Pre-Startup") ? 1 : 0; // Startup -> Initial and Inprocess - Regular

            if(str_productType == 1)
            {
                if(reqObj.body.reportType == "Complete")
                {
                    str_master = (reqObj.body.recordFrom == 'Archive') ? "tbl_tab_initialmaster_archived" : "tbl_tab_initialmaster";
                }
                else
                {
                    // str_master = "tbl_tab_initialmaster_incomplete";
                    //  below table name change for qc bug of incomplete report sample merge should not happen and create different report
                    // to solve that manish has created different tables for incomplete and now only for incomplete values will fetched from this table
                    // this is done only for INCOMPLETE report not complete
                     str_master = "tbl_tab_initialmaster_failed";
                }
            }
            else if(str_productType == 2)
            {
                if(reqObj.body.reportType == "Complete")
                {
                    str_master = (reqObj.body.recordFrom == 'Archive') ? "tbl_cap_initialmaster_archived" : "tbl_cap_initialmaster";
                }
                else
                {
                    str_master = "tbl_cap_initialmaster_incomplete";
                }
            }

            var str_arr = (str_productType == 1) ? sarrTabletStartup : sarrCapsuleStartup;
            var strQuery = ''
            if(str_productType == 1)
            {
                if(reqObj.body.reportType == 'Complete' && serverConfiG.plant == 'PUI' && reqObj.body.reportOption == 'StartUp' && reqObj.body.testType == 'Startup'){
                for (var [i,param] of str_arr.entries())  
                {
                   strQuery = strQuery + `select DISTINCT m.* from ${str_master} m JOIN  tbl_tab_initialdetail${param} d ON m.RepSerNo = d.RepSerNo
                    WHERE  m.Inprocess = 0 and m.ReportType = ${int_testType}   AND m.ProductType = ${str_productType} AND m.MesTestType not like '%pre%' AND m.PrDate BETWEEN '${dt_fromDate}' AND '${dt_toDate}' `;
                    if(i != (str_arr.length - 1)){
                        strQuery = `${strQuery} UNION `
                    }
                }
            }
            else if(reqObj.body.reportType == 'Complete' && serverConfiG.plant == 'PUI' && reqObj.body.reportOption == 'StartUp' && reqObj.body.testType == 'Pre-Startup'){
                for (var [i,param] of str_arr.entries())  
                {
                   strQuery = strQuery + `select DISTINCT m.* from ${str_master} m JOIN  tbl_tab_initialdetail${param} d ON m.RepSerNo = d.RepSerNo
                    WHERE  m.Inprocess = 0 and m.ReportType = ${int_testType}   AND m.ProductType = ${str_productType} AND m.MesTestType like '%pre%' AND m.PrDate BETWEEN '${dt_fromDate}' AND '${dt_toDate}' `;
                    if(i != (str_arr.length - 1)){
                        strQuery = `${strQuery} UNION `
                    }
                }
            }
            else if(reqObj.body.reportType == 'Complete' && serverConfiG.plant == 'PUI' && reqObj.body.reportOption == 'StartUp' && (reqObj.body.testType == 'PD in process')){
                for (var [i,param] of str_arr.entries())  
                {
                   strQuery = strQuery + `select DISTINCT m.* from ${str_master} m JOIN  tbl_tab_initialdetail${param} d ON m.RepSerNo = d.RepSerNo
                    WHERE  m.Inprocess = 0 and m.ReportType = ${int_testType}   AND m.ProductType = ${str_productType} AND (LOWER(REPLACE(m.MesTestType, ' ', '')) LIKE '%2hr%' OR LOWER(REPLACE(m.MesTestType, ' ', '')) LIKE '%4hr%') AND m.PrDate BETWEEN '${dt_fromDate}' AND '${dt_toDate}' `;
                    if(i != (str_arr.length - 1)){
                        strQuery = `${strQuery} UNION `
                    }
                }
            }
            else if(reqObj.body.reportType == 'Complete' && serverConfiG.plant == 'PUI' && reqObj.body.reportOption == 'StartUp' && (reqObj.body.testType == 'QA in process')){
                for (var [i,param] of str_arr.entries())  
                {
                   strQuery = strQuery + `select DISTINCT m.* from ${str_master} m JOIN  tbl_tab_initialdetail${param} d ON m.RepSerNo = d.RepSerNo
                    WHERE  m.Inprocess = 0 and m.ReportType = ${int_testType}   AND m.ProductType = ${str_productType} AND LOWER(REPLACE(m.MesTestType, ' ', '')) LIKE '%8hr%' AND m.PrDate BETWEEN '${dt_fromDate}' AND '${dt_toDate}' `;
                    if(i != (str_arr.length - 1)){
                        strQuery = `${strQuery} UNION `
                    }
                }
            }
            else if(reqObj.body.reportType == 'Complete'){
                for (var [i,param] of str_arr.entries())  // to do for fri and DT
                {
                   strQuery = strQuery + `select DISTINCT m.* from ${str_master} m JOIN  tbl_tab_initialdetail${param} d ON m.RepSerNo = d.RepSerNo
                    WHERE  m.Inprocess = 0 and m.ReportType = ${int_testType}   AND m.ProductType = ${str_productType} AND m.PrDate BETWEEN '${dt_fromDate}' AND '${dt_toDate}' `;
                    if(i != (str_arr.length - 1)){
                        strQuery = `${strQuery} UNION `
                    }
                }
            }else{
                strQuery = `select * from ${str_master} WHERE 
                Inprocess = 0 and ReportType = ${int_testType} AND ProductType = ${str_productType} AND 
                PrDate BETWEEN '${dt_fromDate}' AND '${dt_toDate}' `;
            }
            }
            else
            {
                if(reqObj.body.reportType == 'Complete'){
                for (var [i,param] of str_arr.entries())  // to do for fri and DT
                {
                   strQuery = strQuery + `select DISTINCT m.* from ${str_master} m JOIN  tbl_cap_initialdetail${param} d ON m.RepSerNo = d.RepSerNo
                    WHERE  m.Inprocess = 0 and m.ReportType = ${int_testType}   AND m.ProductType = ${str_productType} AND m.PrDate BETWEEN '${dt_fromDate}' AND '${dt_toDate}' `;
                    if(i != (str_arr.length - 1)){
                        strQuery = `${strQuery} UNION `
                    }
                }
                }else{
                    strQuery = `select * from ${str_master} WHERE 
                    Inprocess = 0 and ReportType = ${int_testType} AND ProductType = ${str_productType} AND 
                    PrDate BETWEEN '${dt_fromDate}' AND '${dt_toDate}' `;
                }
            }

            var result = await sequelize.query(strQuery, {
                type: QueryTypes.SELECT
            });


            if (result.length > 0) {
                Object.assign(obj_response, { status: 'success' }, { result: result});
            } else {
                Object.assign(obj_response, { status: 'success' }, { result: [] });
            }
            return obj_response;

        } catch (error) {
            console.log("getWeighmentReportDetails_StartUp", error);
            throw error;
        }
    }
    async viewSeparateReport_Startup(value, req)
    {
        try 
        {
            const obj_response = {};
            const clientIp = requestIp.getClientIp(req);
            let ip = clientIp.split(':')[3];
            if ((("idsNo" in value) == true)) {
                ip = `${serverConfig.strIpSeries}${value.idsNo}`;
            } else if (ip === undefined) {
                ip = '127.0.0.1';
            }

            const int_productType = (value.str_url == 'Tablet') ? 1 : 2;

            if(int_productType == 1)  //Tablet
            {
                if(value.reportType == "Complete")
                {
                    var str_master = (value.recordFrom == 'Archive') ? "tbl_tab_initialmaster_archived" : "tbl_tab_initialmaster";
                }
                else
                {
                    // var str_master = "tbl_tab_initialmaster_incomplete";
                    //  below table name change for qc bug of incomplete report sample merge should not happen and create different report
                    // to solve that manish has created different tables for incomplete and now only for incomplete values will fetched from this table
                    // this is done only for INCOMPLETE report not complete
                    var str_master = "tbl_tab_initialmaster_failed";

                }
            }
            else
            {
                if(value.reportType == "Complete")
                {
                    var str_master = (value.recordFrom == 'Archive') ? "tbl_cap_initialmaster_archived" : "tbl_cap_initialmaster";
                }
                else
                {
                    var str_master = "tbl_cap_initialmaster_incomplete";
                }
            }

            if(value.reportType == "Incomplete"){
                var str_arr = (int_productType == 1) ? sarrTabletStartup : sarrCapsuleStartup;
                var strQuery = ''
                if(int_productType == 1)
                {
                    for (var [i,param] of str_arr.entries())  // to do for fri and DT
                    {
                       strQuery = strQuery + `select DISTINCT m.* from ${str_master} m JOIN  tbl_tab_initialdetail${param}_failed d ON m.RepSerNo = d.RepSerNo where m.RepSerNo = ${value.RepSerNo}`;
                        if(i != (str_arr.length - 1)){
                            strQuery = `${strQuery} UNION `
                        }
                    }
                }
                else
                {
                    for (var [i,param] of str_arr.entries())  // to do for fri and DT
                    {
                       strQuery = strQuery + `select DISTINCT m.* from ${str_master} m JOIN  tbl_cap_initialdetail${param}_incomplete d ON m.RepSerNo = d.RepSerNo where m.RepSerNo = ${value.RepSerNo}`;
                        if(i != (str_arr.length - 1)){
                            strQuery = `${strQuery} UNION `
                        }
                    }
                }
                var result = await sequelize.query(strQuery, {
                    type: QueryTypes.SELECT
                });

                if(result.length == 0) {
                    Object.assign(obj_response,{result : 'Data Not Available'});
                    return obj_response;
                }
            }
            
            //insert imto table
            var obj = await this.insertStartupMasterTable(value,ip,int_productType,str_master);
            return obj;
           
        } catch (error) {
            console.log("viewSeparateReport_Startup : ", error);
            throw error;
        }
    }

    async insertStartupMasterTable(value,ip,int_productType,str_master)
    {
        try
        {
            var obj_res = {};
                //Delete Temp Table
                await models.tbl_temp_startup.destroy({
                    where: {
                        HMIID: ip
                    }
                });

                await models.tbl_temp_startup_detail.destroy({
                    where: {
                        HMIID: ip
                    }
                });

                //Get Data From main table
                var selectMasterData = await models[str_master].findAll({
                    where: {
                        RepSerNo: value.RepSerNo
                    }
                });

               var str_intervalStart = (selectMasterData[0].IntervalStartTm).split(" ");
               var str_intervalStop = (selectMasterData[0].IntervalStopTm).split(" ");
               var dt_start = str_intervalStart[0].split("-");
               var dt_startValue = dt_start[2] + "-" + dt_start[1] + "-" + dt_start[0] + " " + str_intervalStart[1];
               var dt_stop = str_intervalStop[0].split("-");
               var dt_stopValue = dt_stop[2] + "-" + dt_stop[1] + "-" + dt_stop[0] + " " + str_intervalStop[1];

                //insert into temp table
                await models.tbl_temp_startup.create({
                    RepSerNo: selectMasterData[0].RepSerNo,
                    ProductType: int_productType,
                    Area: selectMasterData[0].CubicleName,
                    StationsNo: (selectMasterData[0].NoOfStations == "NULL" || selectMasterData[0].NoOfStations == null) ? 0 : Number(selectMasterData[0].NoOfStations),
                    LContainer: selectMasterData[0].LHSContainerNo,
                    RContainer: selectMasterData[0].RHSContainerNo,
                    MachineCode: selectMasterData[0].MachineCode,
                    MPRNo:selectMasterData[0].MPN_Code,
                    BFGCode: selectMasterData[0].BFGCode,
                    ProductName: selectMasterData[0].ProductName,
                    BatchNo: selectMasterData[0].BatchNo,
                    BatchDate:selectMasterData[0].PrDate,
                    Side:selectMasterData[0].Side,
                    BalanceID: (selectMasterData[0].BalanceId == "NULL" || selectMasterData[0].BalanceId == null) ? "NA" : selectMasterData[0].BalanceId,
                    DTID: (selectMasterData[0].DTID == "NULL" || selectMasterData[0].DTID == null) ? "NA" : selectMasterData[0].DTID,
                    FriabilityID: (selectMasterData[0].FriabilityID == "NULL" || selectMasterData[0].FriabilityID == null) ? "NA" : selectMasterData[0].FriabilityID,
                    HardnessID: (selectMasterData[0].HardnessID == "NULL" || selectMasterData[0].HardnessID == null) ? "NA" : selectMasterData[0].HardnessID,
                    VernierId: (selectMasterData[0].VernierId == "NULL" || selectMasterData[0].VernierId == null) ? "NA" : selectMasterData[0].VernierId,
                    UserID: selectMasterData[0].UserId,
                    UserName: selectMasterData[0].UserName,
                    IntervalStartDt: dt_startValue,
                    IntervalStopDT: dt_stopValue,
                    GroupUnit: (selectMasterData[0].Param2_Unit == "NULL" || selectMasterData[0].Param2_Unit == null) ? "g" : selectMasterData[0].Param2_Unit,
                    EmptyGroupUnit: (selectMasterData[0].Param19_Unit == "NULL" || selectMasterData[0].Param19_Unit == null) ? "g" : selectMasterData[0].Param19_Unit,
                    IndividualUnit: (selectMasterData[0].Param1_Unit == "NULL" || selectMasterData[0].Param1_Unit == null) ? "g" : selectMasterData[0].Param1_Unit,
                    HardnessUnit: (selectMasterData[0].Param7_Unit == "NULL" || selectMasterData[0].Param7_Unit == null) ? "kp" : selectMasterData[0].Param7_Unit,
                    DifferentialUnit: (selectMasterData[0].Param3_Unit == "NULL" || selectMasterData[0].Param3_Unit == null) ? "g" : selectMasterData[0].Param3_Unit,
                    LockedLengthUnit: (selectMasterData[0].Param5_Unit == "NULL" || selectMasterData[0].Param5_Unit == null) ? "g" : selectMasterData[0].Param5_Unit,
                    PrintNo:selectMasterData[0].PrintNo,
                    GroupLSL: ['NULL',null].includes(selectMasterData[0].Param2_T2NegTol) ? 0 : selectMasterData[0].Param2_T2NegTol,
                    GroupTarget: ['NULL',null].includes(selectMasterData[0].Param2_Nom) ? 0 : selectMasterData[0].Param2_Nom,
                    GroupUSL: ['NULL',null].includes(selectMasterData[0].Param2_T2PosTol) ? 0 : selectMasterData[0].Param2_T2PosTol,
                    IndLSL: ['NULL',null].includes(selectMasterData[0].Param1_T2NegTol) ? 0 : selectMasterData[0].Param1_T2NegTol,
                    IndTarget: ['NULL',null].includes(selectMasterData[0].Param1_Nom) ? 0 : selectMasterData[0].Param1_Nom,
                    IndUSL: ['NULL',null].includes(selectMasterData[0].Param1_T2PosTol) ? 0 : selectMasterData[0].Param1_T2PosTol,
                    ThickLSL: ['NULL',null].includes(selectMasterData[0].Param3_T2NegTol) ? 0 : selectMasterData[0].Param3_T2NegTol,
                    ThickTarget: ['NULL',null].includes(selectMasterData[0].Param3_Nom) ? 0 : selectMasterData[0].Param3_Nom,
                    ThickUSL: ['NULL',null].includes(selectMasterData[0].Param3_T2PosTol) ? 0 : selectMasterData[0].Param3_T2PosTol,
                    HtdLSL: ['NULL',null].includes(selectMasterData[0].Param7_T2NegTol) ? 0 : selectMasterData[0].Param7_T2NegTol,
                    HtdTarget: ['NULL',null].includes(selectMasterData[0].Param7_Nom) ? 0 : selectMasterData[0].Param7_Nom,
                    HtdUSL: ['NULL',null].includes(selectMasterData[0].Param7_T2PosTol) ? 0 : selectMasterData[0].Param7_T2PosTol,
                    FriUSL: ['NULL',null].includes(selectMasterData[0].Param8_Nom) ? 0 : selectMasterData[0].Param8_Nom,
                    DTUSL: ['NULL',null].includes(selectMasterData[0].Param13_Nom) ? 0 : selectMasterData[0].Param13_Nom,
                    DiffLSL: ['NULL',null].includes(selectMasterData[0].Param3_T2NegTol) ? 0 : selectMasterData[0].Param3_T2NegTol,
                    DiffTarget: ['NULL',null].includes(selectMasterData[0].Param3_Nom) ? 0 : selectMasterData[0].Param3_Nom,
                    DiffUSL: ['NULL',null].includes(selectMasterData[0].Param3_T2PosTol) ? 0 : selectMasterData[0].Param3_T2PosTol,
                    LockedLengthLSL: ['NULL',null].includes(selectMasterData[0].Param5_T2NegTol) ? 0 : selectMasterData[0].Param5_T2NegTol,
                    LockedLengthTarget: ['NULL',null].includes(selectMasterData[0].Param5_Nom) ? 0 : selectMasterData[0].Param5_Nom,
                    LockedLengthUSL: ['NULL',null].includes(selectMasterData[0].Param5_T2PosTol) ? 0 : selectMasterData[0].Param5_T2PosTol,
                    EmptyGroupLSL: ['NULL',null].includes(selectMasterData[0].Param19_T2NegTol) ? 0 : selectMasterData[0].Param19_T2NegTol,
                    EmptyGroupTarget: ['NULL',null].includes(selectMasterData[0].Param19_Nom) ? 0 : selectMasterData[0].Param19_Nom,
                    EmptyGroupUSL: ['NULL',null].includes(selectMasterData[0].Param19_T2PosTol) ? 0 : selectMasterData[0].Param19_T2PosTol,
                    CheckedByID:selectMasterData[0].CheckedByID,
                    CheckedByName:selectMasterData[0].CheckedByName,
                    CheckedByDate:selectMasterData[0].CheckedByDate,
                    CheckedByTime:date.format(selectMasterData[0].CheckedByTime,"HH:mm:ss"),
                    StartDateGroup:selectMasterData[0].Param2_PrDate,
                    StartTimeGroup:date.format(selectMasterData[0].Param2_PrTime,"HH:mm:ss"),
                    StopDateGroup:selectMasterData[0].Param2_PrEndDate,
                    StopTimeGroup:date.format(selectMasterData[0].Param2_PrEndTime,"HH:mm:ss"),
                    StartDateTH:selectMasterData[0].Param7_PrDate,
                    StartTimeTH:date.format(selectMasterData[0].Param7_PrTime,"HH:mm:ss"),
                    StopDateTH:selectMasterData[0].Param7_PrEndDate,
                    StopTimeTH:date.format(selectMasterData[0].Param7_PrEndTime,"HH:mm:ss"),
                    StartDateFri:selectMasterData[0].Param8_PrDate,
                    StartTimeFri:date.format(selectMasterData[0].Param8_PrTime,"HH:mm:ss"),
                    StopDateFri:selectMasterData[0].Param8_PrEndDate,
                    StopTimeFri:date.format(selectMasterData[0].Param8_PrEndTime,"HH:mm:ss"),
                    StartDateLockedLength: selectMasterData[0].Param5_PrDate ? selectMasterData[0].Param5_PrDate : '1992-12-08 00:00:00',
                    StartTimeLockedLength: selectMasterData[0].Param5_PrTime ? date.format(selectMasterData[0].Param5_PrTime, "HH:mm:ss") : '00:00:00',
                    StopDateLockedLength: selectMasterData[0].Param5_PrEndDate ? selectMasterData[0].Param5_PrEndDate : '1992-12-08 00:00:00',
                    StopTimeLockedLength: selectMasterData[0].Param5_PrEndTime ? date.format(selectMasterData[0].Param5_PrEndTime, "HH:mm:ss") : '00:00:00',
                    StartDateDifferential: selectMasterData[0].Param3_PrDate ? selectMasterData[0].Param3_PrDate : '1992-12-08 00:00:00',
                    StartTimeDifferential: selectMasterData[0].Param3_PrTime ? date.format(selectMasterData[0].Param3_PrTime, "HH:mm:ss") : '00:00:00',
                    StopDateDifferential: selectMasterData[0].Param3_PrEndDate ? selectMasterData[0].Param3_PrEndDate : '1992-12-08 00:00:00',
                    StopTimeDifferential: selectMasterData[0].Param3_PrEndTime ? date.format(selectMasterData[0].Param3_PrEndTime, "HH:mm:ss") : '00:00:00',
                    StartDateEmptyGroup:selectMasterData[0].Param19_PrDate ? selectMasterData[0].Param19_PrDate : '1992-12-08 00:00:00',
                    StartTimeEmptyGroup:selectMasterData[0].Param19_PrTime ? date.format(selectMasterData[0].Param19_PrTime,"HH:mm:ss") : '00:00:00',
                    StopDateEmptyGroup:selectMasterData[0].Param19_PrEndDate ? selectMasterData[0].Param19_PrEndDate : '1992-12-08 00:00:00',
                    StopTimeEmptyGroup:selectMasterData[0].Param19_PrEndTime ? date.format(selectMasterData[0].Param19_PrEndTime,"HH:mm:ss") : '00:00:00',
                    StartDateDT:selectMasterData[0].Param13_PrDate,
                    StartTimeDT:date.format(selectMasterData[0].Param13_PrTime,"HH:mm:ss"),
                    StopDateDT:selectMasterData[0].Param13_PrEndDate,
                    StopTimeDT:date.format(selectMasterData[0].Param13_PrEndTime,"HH:mm:ss"),
                    StartDateWeight:selectMasterData[0].Param1_PrDate,
                    StartTimeWeight:date.format(selectMasterData[0].Param1_PrTime,"HH:mm:ss"),
                    StopDateWeight:selectMasterData[0].Param1_PrEndDate,
                    StopTimeWeight:date.format(selectMasterData[0].Param1_PrEndTime,"HH:mm:ss"),
                    GroupAvg:(selectMasterData[0].Param2_AvgNet == "NULL") ? "0" : selectMasterData[0].Param2_AvgNet,
                    GroupMin:(selectMasterData[0].Param2_MinWeight == "NULL" ) ? "0" : selectMasterData[0].Param2_MinWeight,
                    GroupMax:(selectMasterData[0].Param2_MaxWeight == "NULL" ) ? "0" : selectMasterData[0].Param2_MaxWeight,
                    GroupDiff:(selectMasterData[0].Param2_Diff == "NULL" ) ? "0" : selectMasterData[0].Param2_Diff,
                    GroupSD:(selectMasterData[0].Param2_StdDev == "NULL" ) ? "0" : selectMasterData[0].Param2_StdDev,
                    GroupRSD:(selectMasterData[0].Param2_RStdDev == "NULL" ) ? "0" : selectMasterData[0].Param2_RStdDev,
                    GroupResult:(selectMasterData[0].Param2_Remark?.toLowerCase() == "within limit") ? "Pass" : (selectMasterData[0].Param2_Remark == "Out Of Limit") ? "Fail" : selectMasterData[0].Param2_Remark,
                    IndAvg:(selectMasterData[0].Param1_AvgNet == "NULL" ) ? "0" : selectMasterData[0].Param1_AvgNet,
                    IndMin:(selectMasterData[0].Param1_MinWeight == "NULL" ) ? "0" : selectMasterData[0].Param1_MinWeight,
                    IndMax:(selectMasterData[0].Param1_MaxWeight == "NULL" ) ? "0" : selectMasterData[0].Param1_MaxWeight,
                    IndDiff:(selectMasterData[0].Param1_Diff == "NULL" ) ? "0" : selectMasterData[0].Param1_Diff,
                    IndSD:(selectMasterData[0].Param1_StdDev == "NULL" ) ? "0" : selectMasterData[0].Param1_StdDev,
                    IndRSD:(selectMasterData[0].Param1_RStdDev == "NULL" ) ? "0" : selectMasterData[0].Param1_RStdDev,
                    IndResult:(selectMasterData[0].Param1_Remark?.toLowerCase() == "within limit") ? "Pass" : (selectMasterData[0].Param1_Remark == "Out Of Limit") ? "Fail" : selectMasterData[0].Param1_Remark,
                    ThickAvg:(selectMasterData[0].Param3_AvgNet == "NULL" ) ? "0" : selectMasterData[0].Param3_AvgNet,
                    ThickMin:(selectMasterData[0].Param3_MinWeight == "NULL" ) ? "0" : selectMasterData[0].Param3_MinWeight,
                    ThickMax:(selectMasterData[0].Param3_MaxWeight == "NULL" ) ? "0" : selectMasterData[0].Param3_MaxWeight,
                    ThickDiff:(selectMasterData[0].Param3_Diff == "NULL" ) ? "0" : selectMasterData[0].Param3_Diff,
                    ThickSD:(selectMasterData[0].Param3_StdDev == "NULL" ) ? "0" : selectMasterData[0].Param3_StdDev,
                    ThickRSD:(selectMasterData[0].Param3_RStdDev == "NULL" ) ? "0" : selectMasterData[0].Param3_RStdDev,
                    ThickResult: (selectMasterData[0].Param3_Remark?.toLowerCase() == "within limit") ? "Pass" : (selectMasterData[0].Param3_Remark == "Out Of Limit") ? "Fail" : selectMasterData[0].Param3_Remark,
                    HTDAvg: (selectMasterData[0].Param7_AvgNet == "NULL" ) ? "0" : selectMasterData[0].Param7_AvgNet,
                    HTDMin: (selectMasterData[0].Param7_MinWeight == "NULL" ) ? "0" : selectMasterData[0].Param7_MinWeight,
                    HTDMax: (selectMasterData[0].Param7_MaxWeight == "NULL" ) ? "0" : selectMasterData[0].Param7_MaxWeight,
                    HTDDiff: (selectMasterData[0].Param7_Diff == "NULL" ) ? "0" : selectMasterData[0].Param7_Diff,
                    HTDSD: (selectMasterData[0].Param7_StdDev == "NULL" ) ? "0" : selectMasterData[0].Param7_StdDev,
                    HTDRSD: (selectMasterData[0].Param7_RStdDev == "NULL" ) ? "0" : selectMasterData[0].Param7_RStdDev,
                    HTDResult:(selectMasterData[0].Param7_Remark?.toLowerCase() == "within limit") ? "Pass" : (selectMasterData[0].Param7_Remark == "Out Of Limit") ? "Fail" : selectMasterData[0].Param7_Remark,
                    FriAvg:(selectMasterData[0].Param8_AvgNet == "NULL" ) ? "0" : selectMasterData[0].Param8_AvgNet,
                    FriMin:(selectMasterData[0].Param8_MinWeight == "NULL" ) ? "0" : selectMasterData[0].Param8_MinWeight,
                    FriMax:(selectMasterData[0].Param8_MaxWeight == "NULL" ) ? "0" : selectMasterData[0].Param8_MaxWeight,
                    FriResult:(selectMasterData[0].Param8_Remark?.toLowerCase() == "within limit") ? "Pass" : (selectMasterData[0].Param8_Remark == "Out Of Limit") ? "Fail" : selectMasterData[0].Param8_Remark,
                    DTAvg:(selectMasterData[0].Param13_AvgNet == "NULL" ) ? "0" : selectMasterData[0].Param13_AvgNet,
                    DTMin:(selectMasterData[0].Param13_MinWeight == "NULL" ) ? "0" : selectMasterData[0].Param13_MinWeight,
                    DTMax:(selectMasterData[0].Param13_MaxWeight == "NULL" ) ? "0" : selectMasterData[0].Param13_MaxWeight,
                    DTResult: (selectMasterData[0].Param13_Remark?.toLowerCase() == "within limit") ? "Pass" : (selectMasterData[0].Param13_Remark == "Out Of Limit") ? "Fail" : selectMasterData[0].Param13_Remark,
                    LLAvg:(selectMasterData[0].Param5_AvgNet == "NULL" ) ? "0" : selectMasterData[0].Param5_AvgNet,
                    LLMin:(selectMasterData[0].Param5_MinWeight == "NULL" ) ? "0" : selectMasterData[0].Param5_MinWeight,
                    LLMax:(selectMasterData[0].Param5_MaxWeight == "NULL" ) ? "0" : selectMasterData[0].Param5_MaxWeight,
                    LLDiff:(selectMasterData[0].Param5_Diff == "NULL" ) ? "0" : selectMasterData[0].Param5_Diff,
                    LLSD:(selectMasterData[0].Param5_StdDev == "NULL" ) ? "0" : selectMasterData[0].Param5_StdDev,
                    LLRSD:(selectMasterData[0].Param5_RStdDev == "NULL" ) ? "0" : selectMasterData[0].Param5_RStdDev,
                    LLResult:(selectMasterData[0].Param5_Remark?.toLowerCase() == "within limit") ? "Pass" : (selectMasterData[0].Param5_Remark == "Out Of Limit") ? "Fail" : selectMasterData[0].Param5_Remark,
                    DifferentialAvg:(selectMasterData[0].Param3_AvgNet == "NULL" ) ? "0" : selectMasterData[0].Param3_AvgNet,
                    DifferentialMin:(selectMasterData[0].Param3_MinWeight == "NULL" ) ? "0" : selectMasterData[0].Param3_MinWeight,
                    DifferentialMax:(selectMasterData[0].Param3_MaxWeight == "NULL" ) ? "0" : selectMasterData[0].Param3_MaxWeight,
                    DifferentialDiff:(selectMasterData[0].Param3_Diff == "NULL" ) ? "0" : selectMasterData[0].Param3_Diff,
                    DifferentialSD:(selectMasterData[0].Param3_StdDev == "NULL" ) ? "0" : selectMasterData[0].Param3_StdDev,
                    DifferentialRSD:(selectMasterData[0].Param3_RStdDev == "NULL" ) ? "0" : selectMasterData[0].Param3_RStdDev,
                    DifferentialResult:(selectMasterData[0].Param3_Remark?.toLowerCase() == "within limit") ? "Pass" : (selectMasterData[0].Param3_Remark == "Out Of Limit") ? "Fail" : selectMasterData[0].Param3_Remark,
                    EmptyGroupAvg:(selectMasterData[0].Param19_AvgNet == "NULL" ) ? "0" : selectMasterData[0].Param19_AvgNet,
                    EmptyGroupMin:(selectMasterData[0].Param19_MinWeight == "NULL" ) ? "0" : selectMasterData[0].Param19_MinWeight,
                    EmptyGroupMax:(selectMasterData[0].Param19_MaxWeight == "NULL" ) ? "0" : selectMasterData[0].Param19_MaxWeight,
                    EmptyGroupDiff:(selectMasterData[0].Param19_Diff == "NULL" ) ? "0" : selectMasterData[0].Param19_Diff,
                    EmptyGroupSD:(selectMasterData[0].Param19_StdDev == "NULL" ) ? "0" : selectMasterData[0].Param19_StdDev,
                    EmptyGroupRSD:(selectMasterData[0].Param19_RStdDev == "NULL" ) ? "0" : selectMasterData[0].Param19_RStdDev,
                    EmptyGroupResult:(selectMasterData[0].Param19_Remark?.toLowerCase() == "within limit") ? "Pass" : (selectMasterData[0].Param19_Remark == "Out Of Limit") ? "Fail" : selectMasterData[0].Param19_Remark,
                    HMIID:ip
                });
                var str_userId = value.userId;
                var str_userName = value.username;
               var objDetail =  await this.insertDetailStartupTable(value,ip,int_productType);
               
               Object.assign(obj_res,{
                HmiId:ip,
                RecSeqNo:objDetail.RecSeqNoForInd,
                cntGraph_Thick:objDetail.cntGraph_Thick,
                cntGraph_LL:objDetail.cntGraph_LL,
                cntGraph_Diff:objDetail.cntGraph_Diff,
                cntGraph_Ind:objDetail.cntGraph_Ind,
                cntGraph_Group:objDetail.cntGraph_Group,
                cntGraph_EmptyGroup:objDetail.cntGraph_EmptyGroup,
                SelectedValue:value.RepSerNo,
                UserId:str_userId,
                Repetition:selectMasterData[0].Repetition,
                BatchNo: value.batchNo,
                PrintNo:value.printNo,
                PrDate:selectMasterData[0].PrDate,
                PrTime:date.format(selectMasterData[0].PrTime,'HH:mm:ss'),
                UserName:str_userName,
                waterMark:true,
                ICReport:value.reportType,
                testType:value.testType,
                ReportName: int_productType == 1 ? (objDetail.cnt_fd > 1) ? "Repo_StartUp_FD" : "Repo_StartUp" : value.testType == 'Startup' ? "Repo_StartUp_Capsule" : "Repo_StartUp_Capsule_Inprocess"
               });
                return obj_res;
           

        } catch (error) {
            console.log("insertStartupTable : ", error);
            throw error;
        }
    }

    async insertDetailStartupTable(value,ip,int_productType)
    {
        try {
                var sarr = (int_productType == 1) ? sarrTabletStartup : sarrCapsuleStartup;  
                var int_cntMaxQtyInd = 0,int_cntMaxQtyTH = 0,RecSeqNoForInd = 0,cntGraph_Group = 0,cntGraph_EmptyGroup = 0,
                cntGraph_Thick=0,cntGraph_Ind=0,cntGraph_LL=0,cntGraph_Diff=0,sarr_onlyFD=[],int_cntMaxQtyDifferential = 0,int_cntMaxQtyLL = 0;

                if(int_productType == 1)
                {
                    //Check max record from detail to update in temp table -> Individual and hardness
                    for (var l of [1,"htd"]) {
                    let tbl_name = value.reportType == 'Incomplete'? `tbl_tab_initialdetail${l}_failed` :( value.recordFrom != 'Current' ? `tbl_tab_initialdetail${l}_archived` : `tbl_tab_initialdetail${l}`);
                    var maxRecord = await models[tbl_name].max('RecSeqNo',
                        {
                            where:
                            {
                                RepSerNo: value.RepSerNo
                            }
                        });

                        if(l == 1)
                        {
                            int_cntMaxQtyInd = (maxRecord == NaN || maxRecord == undefined) ? 0 : maxRecord;
                        }
                        else
                        {
                            int_cntMaxQtyTH = (maxRecord == NaN || maxRecord == undefined) ? 0 : maxRecord;
                        }

                    }
                }
                else
                {
                    //Check max record from detail to update in temp table -> Individual (For Capsule)
                    for (var l of [1,3,5]) {
                    let tbl_name = value.reportType == 'Incomplete'? `tbl_cap_initialdetail${l}_incomplete` :( value.recordFrom != 'Current' ? `tbl_cap_initialdetail${l}_archived` : `tbl_cap_initialdetail${l}`);
                    var maxRecord = await models[tbl_name].max('RecSeqNo',
                        {
                            where:
                            {
                                RepSerNo: value.RepSerNo
                            }
                        });

                        if(l == 1)
                        {
                            int_cntMaxQtyInd = (maxRecord == NaN || maxRecord == undefined) ? 0 : maxRecord;
                        }
                        else if(l == 3)
                        {
                            int_cntMaxQtyDifferential = (maxRecord == NaN || maxRecord == undefined) ? 0 : maxRecord;
                        }
                        else if(l == 5)
                        {
                            int_cntMaxQtyLL = (maxRecord == NaN || maxRecord == undefined) ? 0 : maxRecord;
                        }
                        else
                        {
                            int_cntMaxQtyTH = (maxRecord == NaN || maxRecord == undefined) ? 0 : maxRecord;
                        }

                    }
                }
                
               
                var int_cntMax = (int_cntMaxQtyInd > int_cntMaxQtyTH) ? int_cntMaxQtyInd : int_cntMaxQtyTH;

                // if(int_cntMax == 0) // if no data found for individual and hardness then insert only 1 entry for other parameter
                // {
                //     var selectDetailData = await models.tbl_temp_startup_detail.create({
                //         RepSerNo: value.RepSerNo,
                //         RecSeqNo: 1,
                //         RecSeqNoInd: 120,
                //         ProductType:int_productType,
                //         HMIID: ip
                //     });
                // }
                // else
                // {
                    // for individual hardcoded 120 
                   for (var i = 1; i <= 120; i++) {
                       var selectDetailData = await models.tbl_temp_startup_detail.create({
                           RepSerNo: value.RepSerNo,
                           RecSeqNo: (i <= int_cntMaxQtyTH && int_cntMaxQtyTH != 0) ? i : (i == 1) ? 1 : 0,
                            // RecSeqNoInd: (i <= int_cntMaxQtyInd && int_cntMaxQtyInd != 0) ? i : 0,
                           RecSeqNoInd: i,
                           RecSeqNoForDifferential: (i <= int_cntMaxQtyDifferential && int_cntMaxQtyDifferential != 0) ? i : (i == 1) ? 1 : 0,
                           RecSeqNoForLL: (i <= int_cntMaxQtyLL && int_cntMaxQtyLL != 0) ? i : (i == 1) ? 1 : 0,
                           ProductType:int_productType,
                           HMIID: ip
                       });
                   }
                    
                // }

                for (var l of sarr)
                {
                    let tbl_name;
                    if(int_productType == 1)
                    {
                        tbl_name = value.reportType == 'Incomplete'? `tbl_tab_initialdetail${l}_failed` :( value.recordFrom != 'Current' ? `tbl_tab_initialdetail${l}_archived` : `tbl_tab_initialdetail${l}`);
                    }
                    else
                    {
                        tbl_name = value.reportType == 'Incomplete'? `tbl_cap_initialdetail${l}_incomplete` :( value.recordFrom != 'Current' ? `tbl_cap_initialdetail${l}_archived` : `tbl_cap_initialdetail${l}`);
                    }
                    var selectDetailData = await models[tbl_name].findAll({
                        where: {
                            RepSerNo: value.RepSerNo
                        },
                         order: [
                            ['RecNo', 'ASC']
                        ]
                    });

                    if(selectDetailData.length > 0)
                    {
                        sarr_onlyFD.push(l);
                        if (l == 2) { // RHS condition added because this data will be stored in detail section
                            cntGraph_Group = 1;
                            await models.tbl_temp_startup_detail.update({
                                GroupLHSValue: ((selectDetailData[0].Side == "LHS" || selectDetailData[0].Side == 'NA' || selectDetailData[0].Side == 'Single') ? selectDetailData[0].DataValue : 0),
                                GroupRHSValue: (selectDetailData.length == 1) ? ((selectDetailData[0].Side == "RHS") ? selectDetailData[0].DataValue : 0) :
                                (selectDetailData.length == 2) ? ((selectDetailData[1].Side == "RHS") ? selectDetailData[1].DataValue : 0) : 0
                            },{
                                where:{
                                    RepSerNo: value.RepSerNo,
                                    ProductType: int_productType,
                                    HMIID: ip,
                                    RecSeqNo: 1
                                }
                            });

                            await models.tbl_temp_startup.update({
                                GroupQty: (selectDetailData[0].NoOfSample == "NULL" || selectDetailData[0].NoOfSample == null) ? 0 : selectDetailData[0].NoOfSample
                            }, {
                                where: {
                                    RepSerNo: value.RepSerNo,
                                    ProductType: int_productType,
                                    HMIID: ip
                                }
                            });
                        }
                        else if (l == 8) { // Friability -> only insert in master // TODO
                            await models.tbl_temp_startup.update({
                                FriLHSValueA: ((selectDetailData[0].Side == 'LHS' || selectDetailData[0].Side == 'NA' || selectDetailData[0].Side == 'Single')? selectDetailData[0].AfterValue : 0),
                                FriLHSValueB: ((selectDetailData[0].Side == 'LHS' || selectDetailData[0].Side == 'NA' || selectDetailData[0].Side == 'Single')? selectDetailData[0].BeforeValue : 0),
                                FriLHSPer: ((selectDetailData[0].Side == 'LHS' || selectDetailData[0].Side == 'NA' || selectDetailData[0].Side == 'Single') ? selectDetailData[0].NetValue : 0),
                                FriRHSValueA: (selectDetailData.length == 1) ? ((selectDetailData[0].Side == "RHS") ? selectDetailData[0].AfterValue : 0):
                                (selectDetailData.length == 2) ? ((selectDetailData[1].Side == "RHS") ? selectDetailData[1].AfterValue : 0) : 0,
                                FriRHSValueB:  (selectDetailData.length == 1) ? ((selectDetailData[0].Side == "RHS") ? selectDetailData[0].BeforeValue : 0) : 
                                (selectDetailData.length == 2) ? ((selectDetailData[1].Side == "RHS") ? selectDetailData[1].BeforeValue : 0) : 0,
                                FriRHSPer:  (selectDetailData.length == 1) ? ((selectDetailData[0].Side == "RHS") ? selectDetailData[0].NetValue : 0) : 
                                (selectDetailData.length == 2) ? ((selectDetailData[1].Side == "RHS") ? selectDetailData[1].NetValue : 0) : 0,
                            }, {
                                where: {
                                    RepSerNo: value.RepSerNo,
                                    ProductType: int_productType,
                                    HMIID: ip
                                }
                            });
                        }
                        else if (l == 13) { // DT -> only insert in master // TODO
                            await models.tbl_temp_startup.update({
                                DTLHSValue: ((selectDetailData[0].Side == 'LHS' || selectDetailData[0].Side == 'NA' || selectDetailData[0].Side == 'Single') ? selectDetailData[0].DataValue : 0),
                                DTRHSValue: (selectDetailData.length == 1) ? ((selectDetailData[0].Side == "RHS") ? selectDetailData[0].DataValue : 0) :
                                (selectDetailData.length == 2) ? ((selectDetailData[1].Side == "RHS") ? selectDetailData[1].DataValue : 0) : 0
                            }, {
                                where: {
                                    RepSerNo: value.RepSerNo,
                                    ProductType: int_productType,
                                    HMIID: ip
                                }
                            });
                        }
                        else if (l == 3) { // Differential 
                            var k = 0;
                            for(var element of selectDetailData) {
                                // RecSeqNoForDifferential = RecSeqNoForDifferential + 1;
                                k = k + 1;
                                if(element.Side == "RHS")
                                {
                                    var obj = {
                                        DiffRHSValue: element.DataValue
                                    }
                                }
                                else
                                {
                                    var obj = {
                                        DiffLHSValue: element.DataValue
                                    }
                                }
                                cntGraph_Diff = 1;
                                await models.tbl_temp_startup_detail.update(obj, {
                                        where: {
                                            RepSerNo: value.RepSerNo,
                                            ProductType: int_productType,
                                            HMIID: ip,
                                            RecSeqNoForDifferential: k,
                                        }
                                    });
                            }
                        }
                        else if (l == 5) { // Locked Length
                            var k = 0;
                            for(var element of selectDetailData) {
                                // RecSeqNoForDifferential = RecSeqNoForDifferential + 1;
                                k = k + 1;
                                if(element.Side == "RHS")
                                {
                                    var obj = {
                                        LLLHSValue: element.DataValue
                                    }
                                }
                                else
                                {
                                    var obj = {
                                        LLLHSValue: element.DataValue
                                    }
                                }
                                cntGraph_LL = 1;
                                await models.tbl_temp_startup_detail.update(obj, {
                                        where: {
                                            RepSerNo: value.RepSerNo,
                                            ProductType: int_productType,
                                            HMIID: ip,
                                            RecSeqNoForLL: k,
                                        }
                                    });
                            }
                        }
                        else if (l == 19) { // Empty Group
                            cntGraph_EmptyGroup = 1;
                            await models.tbl_temp_startup_detail.update({
                                EmptyGroupLHSValue: ((selectDetailData[0].Side == "LHS" || selectDetailData[0].Side == 'NA' || selectDetailData[0].Side == 'Single') ? selectDetailData[0].DataValue : 0),
                                EmptyGroupRHSValue: (selectDetailData.length == 1) ? ((selectDetailData[0].Side == "RHS") ? selectDetailData[0].DataValue : 0) :
                                (selectDetailData.length == 2) ? ((selectDetailData[1].Side == "RHS") ? selectDetailData[1].DataValue : 0) : 0
                            },{
                                where:{
                                    RepSerNo: value.RepSerNo,
                                    ProductType: int_productType,
                                    HMIID: ip,
                                    RecSeqNo: 1
                                }
                            });

                            await models.tbl_temp_startup.update({
                                EmptyGroupQty: (selectDetailData[0].NoOfSample == "NULL" || selectDetailData[0].NoOfSample == null) ? 0 : selectDetailData[0].NoOfSample
                            }, {
                                where: {
                                    RepSerNo: value.RepSerNo,
                                    ProductType: int_productType,
                                    HMIID: ip
                                }
                            });
                        }
                        else 
                        {
                            var k = 0;
                            for (var element of selectDetailData) {
                                // if(element.RecSeqNo == 1)
                                // {
                                //      k = 0;
                                // } // In one case they were sending 20 samples(individual) ,first 19 values had RecSeqNo as 2 and only the last sample had RecSeqNo as 1 ,so one sample was getting updated twice,hence only 19 values were visible in report 
                                k = k + 1;
                                RecSeqNoForInd = RecSeqNoForInd + 1;
                                if(element.Side == "RHS")
                                {
                                    if(l==1)
                                    {
                                        var obj = {
                                            IndRHSValue:  element.DataValue,
                                        }
                                    }
                                    else
                                    {
                                        var obj = {
                                            ThickRHSValue: element.DataValueThick,
                                            HTDRHSValue: element.DataValueHard
                                        }
                                        
                                    }
                                }
                                else // LHS or NA
                                {
                                    if(l==1)
                                        {
                                            var obj = {
                                                IndLHSValue:  element.DataValue,
                                            }
                                        }
                                        else
                                        {
                                            var obj = {
                                                ThickLHSValue: element.DataValueThick,
                                                HTDLHSValue: element.DataValueHard
                                            }
                                            
                                        }
                                }
                                
                                if(l==1)
                                {
                                    cntGraph_Ind = 1;
                                    await models.tbl_temp_startup_detail.update(obj, {
                                        where: {
                                            RepSerNo: value.RepSerNo,
                                            ProductType: int_productType,
                                            HMIID: ip,
                                            RecSeqNoInd: k,
                                        }
                                    });
                                }
                                else
                                {
                                    cntGraph_Thick = 1;
                                    await models.tbl_temp_startup_detail.update(obj, {
                                        where: {
                                            RepSerNo: value.RepSerNo,
                                            ProductType: int_productType,
                                            HMIID: ip,
                                            RecSeqNo: k,
                                        }
                                    });
                                }
                               
                            }
                            
                            if(l != 1) // only for hardness & thickness
                            {
                                await models.tbl_temp_startup.update({
                                    THQty:int_cntMaxQtyTH
                                },{
                                    where:{
                                        RepSerNo:value.RepSerNo,
                                        ProductType:int_productType,
                                        HMIID:ip
                                    }
                                });
                            }

                        }
                    
                    }
                    
                }
                var resObject = {},cnt_fd = 0;

                if(sarr_onlyFD.length == 2)
                {
                    for (var j of sarr_onlyFD) {
                        cnt_fd = (j==8) ? (cnt_fd + 1) : (j==13) ? (cnt_fd + 1) : 0;
                    }
                    
                }
                Object.assign(resObject,{RecSeqNoForInd:int_cntMaxQtyInd},{cntGraph_Thick:cntGraph_Thick},{cntGraph_LL:cntGraph_LL},{cntGraph_Diff:cntGraph_Diff},{cntGraph_Ind:cntGraph_Ind},
                    {cntGraph_Group:cntGraph_Group},{cntGraph_EmptyGroup:cntGraph_EmptyGroup},{cnt_fd:cnt_fd});
                return resObject;

        } catch (error) {
            console.log("insertIntoDetailStartup : ", error);
            throw error;
        }
    }

    async viewExceptionRpt(req, clientIp) {
        try {
            let responseObj = {};
            let ip = clientIp.split(':')[3];
            // reportType : 1 = incomplete , 0 = complete
            let str_tbl_name = req.reportType == 1 ? 'tbl_exception_sample_failed' : 'tbl_exception_sample_initial';
            let str_tbl_name_htd = req.reportType == 1 ? 'tbl_exception_samplehtd_failed' : 'tbl_exception_samplehtd_initial';
            let master = await models[str_tbl_name].findAll({
                where: {
                    RepSerNo: req.SelectedValue,
                    isTerminated:req.reportType,
                    ProductType:req.ProductType,
                    BatchNo:req.BatchNo
                }
            });
            let masterhtd = await models[str_tbl_name_htd].findAll({
                where: {
                    RepSerNo: req.SelectedValue,
                    isTerminated:req.reportType,
                    ProductType:req.ProductType,
                    BatchNo:req.BatchNo
                }
            });

            // get time of 1st Exception for Report
            let master_time = await models[str_tbl_name].findOne({
                where: {
                    RepSerNo: req.SelectedValue,
                    isTerminated:req.reportType,
                    ProductType:req.ProductType,
                    BatchNo:req.BatchNo
                },
                order: [['prTime', 'ASC']] // earliest time first
            });
            let masterhtd_time = await models[str_tbl_name_htd].findOne({
                where: {
                    RepSerNo: req.SelectedValue,
                    isTerminated:req.reportType,
                    ProductType:req.ProductType,
                    BatchNo:req.BatchNo
                },
                order: [['prTime', 'ASC']] // earliest time first
            });
            
            if (master.length == 0 && masterhtd.length == 0) {
               return  Object.assign(responseObj, { status: "fail" }, { result: "No Exception Record Found." });
            }

            let data = master.map(k => {
                let testperformed = k.MenuName == 'Individual' && masterhtd.length != 0 && masterhtd[0].MenuName.match(/multitester/gi) != null ?  masterhtd[0].MenuName : (k.MenuName.match(/(individual|group|friab|Differential)/gi)) ? 'Balance': (k.MenuName.match(/(Locked)/gi)) ? 'Vernier' : k.MenuName 
                let menuName = (k.MenuName == 'Differential' && req.ProductType == 2) ? 'Net Content' : (k.MenuName == 'Group' && req.ProductType == 2) ? 'Filled Group' : (k.MenuName == 'Individual' && req.ProductType == 2) ? 'Filled Individual' : k.MenuName
                let obj = {
                    SampleNo: k.SampleNo,
                    RepSerNo: k.RepSerNo,
                    Nominal: k.Nominal,
                    InstrumentId: k.InstrumentId,
                    MenuName: menuName,
                    TestPerformed: testperformed,
                    DataValue: k.DataValue,
                    DataValueUnit: k.DataValueUnit,
                    Remark: k.Remark,
                    T1NegTol: k.T1NegTol,
                    T1PosTol: k.T1PosTol,
                    DTRange: k.DTRange,
                    FriabRange: k.FriabRange
                }
                return obj;
            });
            

            let datahtd = masterhtd.map(k => {
                let oarr_result= []
                let objHrd = {
                    SampleNo: k.SampleNo,
                    RepSerNo: k.RepSerNo,
                    Nominal: k.HardNom,
                    T1NegTolHard: k.T1NegTolHard,
                    T1PosTolHard: k.T1PosTolHard,
                    InstrumentId: k.InstrumentId,
                    MenuName: 'Hardness' ,
                    TestPerformed: k.MenuName ,
                    DataValue: k.DataValueHard,
                    DataValueUnit: k.HardUnit,
                    Remark: k.Remark
                }

                let objThck = {
                    SampleNo: k.SampleNo,
                    RepSerNo: k.RepSerNo,
                    Nominal: k.ThickNom,
                    T1NegTolThick: k.T1NegTolThick,
                    T1PosTolThick: k.T1PosTolThick,
                    InstrumentId: k.InstrumentId,
                    MenuName:'Thickness',
                    TestPerformed:k.MenuName ,
                    DataValue: k.DataValueThick,
                    DataValueUnit: k.ThickUnit,
                    Remark: k.Remark
                }

                if(k.DataValueHard != '99999'){
                    oarr_result.push(objHrd)
                }

                if(k.DataValueThick != '99999'){
                    oarr_result.push(objThck)
                }

                return oarr_result
            });

            await models.tbl_exception_sample_initial_temp.destroy({
                where: {
                    HMIID: ip
                }
            });
            let array = [...data, ...[...datahtd].flat()]
            for (let i = 0; i < array.length; i++) {
                const ele = array[i];
                await models.tbl_exception_sample_initial_temp.create({
                    ...ele,
                    HMIID: ip
                })
            }
            // console.log(array);
            let flags = {
                Individual: array.some(k=>k.MenuName=='Individual'),
                FilledIndividual: array.some(k=>k.MenuName=='Filled Individual'),
                Group: array.some(k=>k.MenuName=='Group'),
                FilledGroup: array.some(k=>k.MenuName=='Filled Group'),
                Friability: array.some(k=>k.MenuName=='Friability'),
                Disintegration: array.some(k=>k.MenuName=='Disintegration'),
                MultiTest: array.some(k=>k.MenuName=='Hardness' || k.MenuName=='Thickness'),
                Differential: array.some(k=>k.MenuName=='Net Content'),
                LockedLength: array.some(k=>k.MenuName=='Locked Length'),
                EmptyGroup: array.some(k=>k.MenuName=='Empty Group')
            }
            return  Object.assign(responseObj,{status: 'success',result: array,HmiId: ip,flags:flags,prTime: this.formatPrTime(master_time?.prTime), prTimehtd:this.formatPrTime(masterhtd_time?.prTime)},)
            // [...data, ...[...datahtd].flat()].forEach(ele => {
            //     console.log(ip,ele);

            // });
        } catch (error) {
            console.log(error);
        }
    }

    formatPrTime(time) {
        return time ? new Date(time).toTimeString().slice(0, 8): null;
    }


}

module.exports = TabletCapsuleModel;