const date = require('date-and-time')
let sha1 = require('sha1');
const serverConfig = require('../global/serverConfig');
const models = require("../dbConnection").models;
const seqTransaction  = require("../dbConnection");
const sequelize = require('./../dbConnection').sequelize;
/**
 * @class AdminModel
 */
class AdminModel {
    /**
     * @description Updates the status of user like `temporary, Permanent disable, Active`
     * @param {*} req Request object from the requsted resource
     * @memberof AdminModel
     */
   async updateUserStatus(req) {
        try{
            var obj_response = {};

            var status = req.body.status;
            var userStatus,pwdChange;
            if(status == 'Enable'){
                userStatus = 0;
                pwdChange = 1;
            }else if(status == 'Temporary Disable'){
                userStatus = 1;
                pwdChange = 0;
            }else if(status == 'Permanent Disable'){
                userStatus = 2;
                pwdChange = 0;
            }

           var UserResult = await models.tbl_users.findAll({where: 
                {UserID: req.body.userid}
            });
           
            var userData = UserResult[0];
            var lockedVal = userData.locked;
            if(lockedVal == 1){
                userStatus = 4;
                Object.assign(obj_response, { status: 'success' }, { result: userStatus });
                return obj_response;
            }else{

                let transaction = await seqTransaction.sequelize.transaction(async (t) =>{
                    var now = new Date();

                    await models.tbl_users.update({
                        Status: userStatus,
                        LastLoginDt: date.format(now, 'YYYY-MM-DD'),
                        lstActvtyTime: 0,
                        PwdChg: pwdChange,
                        loginatmpt: 0,
                        autoEnbl: 0
                    },{where:
                        {UserID:req.body.userid}
                    },
                    {
                        transaction: t
                    });

                    var str_action = (status == 'Enable') ? "User Enabled" : (status == 'Temporary Disable') ? "User Temporarily Disabled" :
                                        "User Permanently Disabled";
                   
                        await models.tbl_audit_users.create({
                            dt: date.format(now, 'YYYY-MM-DD'),
                            tm: date.format(now, 'HH:mm:ss'),
                            userid: req.body.loggeduserid,
                            username: req.body.loggedusername,
                            OldRole: req.body.role,
                            NewRole: req.body.role,
                            ACT: str_action,
                            KeyCode: req.body.userid,
                            KeyValue: req.body.userName,
                            Remark: req.body.remark,
                            OldDepartment: req.body.department,
                            NewDepartment: req.body.department
                        },{
                            transaction: t
                        });
                });
               
                Object.assign(obj_response, { status: 'success' }, { result: userStatus });
                return obj_response;
            }
        }catch(error){
            return error;
        }
    }
    /**
     * 
     * @param {*} req Request Object from requested resource
     * @memberof AdminModel
     * @description Function update the `User Password` as requested
     * @returns Promise holds the success status
     */
    async updateUserPassword(req){
        try{
            let obj_response = {};

            let transaction = await seqTransaction.sequelize.transaction(async (t) =>{
                let userid = req.body.userID;
                let password = req.body.userPassword;
                let DoneByUserID = req.body.loggedUserId;
                let DoneByUserName = req.body.loggedUserName;
                let AffectedUserID = req.body.userID;
                let AffectedUserName = req.body.userName;
                let OldValue = "NA";
                let NewValue = req.body.userPassword;
                let Action = "Change Others Password";
                let Remark = req.body.remark;
                let now = new Date();

                await models.tbl_users.update({
                    Pwd: sha1(password),
                    PwdChgDate: date.format(now, 'YYYY-MM-DD'),
                    Status: 0,
                    PwdChg: 1,
                    autoEnbl: 0,
                    editCounter:0,
                    locked: 0,
                    loginatmpt:0,
                    realPassword: password
                },{where:
                    {UserID:userid}
                },
                {
                    transaction: t
                });

                await models.tbl_audit_change_password.create({
                    dt: date.format(now, 'YYYY-MM-DD'),
                    tm: date.format(now, 'HH:mm:ss'),
                    DoneByUserID: DoneByUserID,
                    DoneByUserName: DoneByUserName,
                    AffectedUserID: AffectedUserID,
                    AffectedUserName: AffectedUserName,
                    OldValue: OldValue,
                    NewValue: NewValue,
                    ACTION: Action,
                    Remark: Remark
                },
                {
                    transaction: t
                });
            });
            
            Object.assign(obj_response, { status: 'success' }, { result: 'User Password Updated' });
            return obj_response;

        }catch(error){
            return error;
        }
    }
    /**
     * 
     * @param {*} req Holds the request object as requested by the resource
     * @description Function used to change the admin profile i-e Update the role, new password as set.
     * @memberof AdminModel
     */
    async changeAdminProfile(req){
        try{
            let obj_response = {};

            let transaction = await seqTransaction.sequelize.transaction(async (t) =>{
                let now = new Date();
           
            await models.tbl_users.findAll({where:
               { UserID: req.body.UserID}
            });

            /** Old User ID */
            let resOldUserDetail = await models.tbl_users.findAll({where:
                { UserID: req.body.UserID}
             });

             /** New User ID */
             let resNewUserDetail = await models.tbl_users.findAll({where:
                { UserID: req.body.UserID}
             });

             await models.tbl_users.update({
                Role: 'SuperAdmin',
                userType: 1,
                active: 0
            },{where:
                { UserID: req.body.selectedUserID }
            },{
                transaction: t
            });

            await models.tbl_users.update({
                Role: req.body.selectedRoleToLoggedUser,
                userType: 2,
                active: 0,
                Status: 1 // temp disabled
            },{where:
                { UserID: req.body.UserID }
            },{
                transaction: t
            });

            //delete from special right and right removed
            await models.tbl_rights_removed.destroy({where:
                { userid: req.body.selectedUserID }
            },{
                transaction: t
            });

            await models.tbl_rights_special.destroy({where:
                { userid: req.body.selectedUserID }
            },{
                transaction: t
            });

            await models.tbl_audit_adminname.create({
                DT: date.format(now, 'YYYY-MM-DD'),
                TM: date.format(now, 'HH:mm:ss'),
                UserID: req.body.UserID,
                Username: req.body.Username,
                Remark: req.body.Remark,
                OldAdminDetails: req.body.OldAdminDetails,
                NewAdminDetails: req.body.NewAdminDetails
            },{
                transaction: t
            });

            await models.tbl_activity_log.create({
                dt: date.format(now, 'YYYY-MM-DD'),
                tm: date.format(now, 'HH:mm:ss'),
                userid: req.body.UserID,
                username: req.body.Username,
                activity: 'Change SuperAdmin Profile'
            },{
                transaction: t
            });
           

            /* Code added for Audit Trail of Old SuperAdmin -> Temporary Disabled*/
            await models.tbl_audit_users.create({
                dt: date.format(now, 'YYYY-MM-DD'),
                tm: date.format(now, 'HH:mm:ss'),
                userid: req.body.selectedUserID,
                username: (serverConfig.isLDAP == true)?resNewUserDetail[0].UserInitials:resNewUserDetail[0].UserNam,
                OldRole: 'SuperAdmin',
                NewRole: 'SuperAdmin',
                ACT: 'User Temporarily Disabled',
                KeyCode: req.body.UserID,
                KeyValue: req.body.Username,
                Remark: 'User Temporarily Disabled due to Change SuperAdmin Profile',
                OldDepartment: resOldUserDetail[0].Department,
                NewDepartment: resOldUserDetail[0].Department
            },{
                transaction: t
            });
        });
            Object.assign(obj_response, { status: 'success' }, { result: 'Admin profile changed' })
            return obj_response;

        }catch(error){
            return error;
        }
    }

    async authenticationChangeProfile(req)
    {
        try{
            let obj_response = {};

            let res = await models.tbl_users.findAll({
                attributes:['realPassword'],
                where: { UserID: req.body.selectedUserID }
            });
           
            if(res[0].realPassword == req.body.selectPwd.trim())
            {
                Object.assign(obj_response, { response: 'Authenticated' })
                return obj_response;
            }
            else
            {
                Object.assign(obj_response, { response: 'wrong' })
                return obj_response;
            }
        }catch(error){
            return error;
        }
       
    }
}
module.exports = AdminModel;