const date = require('date-and-time');
const socketHandler = require('../WebServer/controller/socketHandler')
const models = require("../dbConnection").models;
const seqTransaction = require("../dbConnection");
const moment = require('moment');
const { Op } = require("sequelize");

/**
 * @class BalanceModel
 * @description Class having methods related to balance
 */
class BalanceModel {
    /**
     * @description Function gives the Balance Lists along with there informatio as stored
     * @returns Array holding balance list
     */
    async getBalance() {
        try {
            let result = await models.tbl_balance.findAll();
            return result;
        } catch (error) {
            return error;
        }
    }

    /**
     * @description Function gives the Balance details as per Balance ID
     * @returns Array holding balance details
     */
    async getBalanceByID(balanceID) {
        try {
            let result = await models.tbl_balance.findAll({
                where:
                    { Bal_ID: balanceID }
            });
            return result;
        } catch (error) {
            return error;
        }
    }
    /**
     * @description Function gives the `Balance along with there Calibration weights`
     * @memberof BalanceModel
     */
    async getBalanceDetails() {
        try {
            var balWeightDetails = [];
            let result = await models.tbl_balance.findAll();
            var data = result;
            if (result.length > 0) {
                let result1 = await models.tbl_balance_weights.findAll();
                balWeightDetails = result1;

                for (let i = 0; i < data.length; i++) {
                    let balId = data[i].Bal_ID;
                    let weightDetails = balWeightDetails.filter(k => k.Bal_ID === balId);
                    let weightDetailsObj = { 'WtDetail': weightDetails }
                    Object.assign(data[i], weightDetailsObj);
                }
            }

            return data;
        } catch (error) {
            return error;
        }
    }
    /**
     * @param {*} req holds the object contains the information about balance and resource information
     * @description Function stores the `balance detail` along with their `calibration weights`
     * @memberof BalanceModel
     */
    async storeBalance(value) {
        try {
            let obj_response = {};

            let resExist = await models.tbl_balance.findAll({
                where:
                    { Bal_ID: value.balID }
            });

            let userData = await models.tbl_users.findAll({ attributes:['Role'], where : { UserID : value.LoggeduserId }});

            if (resExist.length != 0) {
                Object.assign(obj_response, { status: 'success' }, { result: 'Balance Id already exist' });
                return obj_response;
            }
            else {
                let transaction = await seqTransaction.sequelize.transaction(async (t) => {
                    let now = new Date();
                    let calStoreType = value.cal_store_type;
                    let calDate = value.cal_dates;
                    var storeType, calibrationDate, calibrationDueDate, calibrationDueDateY, calibrationDuration;
                    var weights = value.weights;
                    var count = weights.length;
                    var binVal = (value.chkIsBinBalance == true) ? 1 : 0;

                    if (calStoreType == 'set_days') {
                        storeType = 1;
                        calibrationDueDate = value.calibration_date;
                        calibrationDate = 0;
                        calibrationDuration = value.duration;
                    } else {
                        storeType = 0;
                        calibrationDueDate = 0;
                        calibrationDueDateY = 0;
                        calibrationDate = calDate.toString();
                        calibrationDuration = 0;
                    }

                    await models.tbl_balance.create({
                        Bal_Model: value.modelNo,
                        Bal_Make: value.make,
                        Bal_SrNo: value.serialNo,
                        Bal_ID: value.balID,
                        Bal_Dept: value.department,
                        Bal_LeastCnt: value.leastCount,
                        Bal_MaxCap: value.maxCapacity,
                        Bal_MinCap: value.minCapacity,
                        Bal_Unit: value.selectedUnit,
                        Bal_CalbStoreType: storeType,
                        Bal_CalbDates: calibrationDate,
                        Bal_CalbDuration: calibrationDuration,
                        Bal_CalbDueDt: calibrationDueDate,
                        Bal_CalbDueDtL: date.format(now, 'YYYY-MM-DD'),
                        Bal_CalbDueDtU: date.format(now, 'YYYY-MM-DD'),
                        Bal_CalbDueDtR: date.format(now, 'YYYY-MM-DD'),
                        Bal_CalbDueDtE: date.format(now, 'YYYY-MM-DD'),
                        Bal_IsCalibFail: 0,
                        Bal_CalbReminder: value.set_reminder,
                        Bal_MaxoptRange: value.maxOperatingRange,
                        Bal_MinoptRange: value.minOperatingRange,
                        IsNewBalance: 1,
                        IsBinBalance: binVal,
                        Bal_DP: value.bal_dp,
                        userID: value.LoggeduserId,
                        Bal_DSNW: value.Bal_DSNW,
                        Bal_FormNo: value.formNo,
                        Bal_Status: value.selectedStatus,
                        Bal_VersionNo: value.versionNo,
                        Bal_Location: value.location,
                        Bal_Cert_No:value.Bal_Cert_No,
                        RejectGroup: userData[0].Role
                    }, {
                        transaction: t
                    });

                    for (var wtVal of weights) {
                        var stdwt = wtVal.std_wt;
                        var negTol = wtVal.neg_Tol;
                        var posTol = wtVal.pos_Tol;
                        var daily = wtVal.daily;
                        var linerity = wtVal.linerity;
                        var eccentricity = wtVal.eccentricity;
                        var repetability = wtVal.repetability;
                        var periodic = wtVal.periodic;
                        var uncertainty = wtVal.uncertinity;

                        let intEccentPoint = (eccentricity == true || eccentricity == 1) ? parseInt(value.intEccentricityCount) : 0;
                        let intUncertCount = (uncertainty == true || uncertainty == 1) ? parseInt(value.intUncertaintyCount) : 0;
                        let intReptCount = (repetability == true || repetability == 1) ? parseInt(value.intRepeatabilityCount) : 0;

                        var int_dailyValue = (daily == true) ? 1 : 0;
                        var int_periodicValue = (periodic == true) ? 1 : 0;
                        var int_linerityValue = (linerity == true) ? 1 : 0;
                        var int_eccentricityValue = (eccentricity == true) ? 1 : 0;
                        var int_uncertaintyValue = (uncertainty == true) ? 1 : 0;
                        var int_repetabilityValue = (repetability == true) ? 1 : 0;

                        await models.tbl_balance_weights.create({
                            Bal_ID: value.balID,
                            Bal_StdWt: stdwt,
                            Bal_NegTol: negTol,
                            Bal_PosTol: posTol,
                            Bal_Daily: int_dailyValue,
                            Bal_Periodic: int_periodicValue,
                            Bal_Linearity: int_linerityValue,
                            Bal_IsEccentricity: int_eccentricityValue,
                            Bal_EccentPoint: intEccentPoint,
                            Bal_IsUncertinity: int_uncertaintyValue,
                            Bal_UncertCount: intUncertCount,
                            Bal_IsRepetability: int_repetabilityValue,
                            Bal_ReptCount: intReptCount,
                            PercentofCapacity: 0
                        }, {
                            transaction: t
                        });
                    }//for loop

                    var res = await this.getBalanceAuditWeightData(value);
                    var strChangedWts = res;

                    await models.tbl_audit_bal_setting.create({
                        tm: date.format(now, 'HH:mm:ss'),
                        dt: date.format(now, 'YYYY-MM-DD'),
                        userid: value.LoggeduserId,
                        username: value.Loggedusername,
                        ACT: value.hdnAction,
                        Remark: value.remark,
                        Bal_Id: value.balID,
                        OldParameter: 'NA',
                        NewParameter: value.newParameter,
                        OldWeight: 'NA',
                        NewWeight: strChangedWts
                    }, {
                        transaction: t
                    });

                    await models.tbl_activity_log.create({
                        dt: date.format(now, 'YYYY-MM-DD'),
                        tm: date.format(now, 'HH:mm:ss'),
                        userid: value.LoggeduserId,
                        username: value.Loggedusername,
                        activity: 'Balance Added'
                    }, {
                        transaction: t
                    });
                    return "success";
                });

                Object.assign(obj_response, { status: 'success' }, { result: 'Balance Added Successfully' });
                return obj_response;
            }

        } catch (error) {
            return error;
        }
    }

    async getBalanceAuditWeightData(req) {
        try {
            var weights = req.weights;
            var strDaily = "";
            var strLin = "";
            var strEcc = "";
            var rep = "";
            var per = "";
            var uncer = "";
            var i = 0;

            weights.forEach(function (element) {
                if (element.daily == true) {
                    if (strDaily == "") {
                        (element.daily == true) ? strDaily = "Daily:" : "";
                    }
                    strDaily = strDaily + " Standard Weight:" + element.std_wt + ",";
                    strDaily = strDaily + "(-)Tolerance:" + element.neg_Tol + ",";
                    strDaily = strDaily + "(+)Tolerance:" + element.pos_Tol;
                }
                if (element.periodic == true) {
                    if (per == "") {
                        (element.periodic == true) ? per = " | Periodic:" : "";
                    }
                    per = per + " Standard Weight:" + element.std_wt + ",";
                    per = per + "(-)Tolerance:" + element.neg_Tol + ",";
                    per = per + "(+)Tolerance:" + element.pos_Tol;
                }
                if (element.repetability == true) {
                    if (rep == "") {
                        (element.repetability == true) ? rep = " | Repeatability:" : "";
                    }
                    rep = rep + " Standard Weight:" + element.std_wt + ",";
                    rep = rep + "(-)Tolerance:" + element.neg_Tol + ",";
                    rep = rep + "(+)Tolerance:" + element.pos_Tol;
                }
                if (element.eccentricity == true) {
                    if (strEcc == "") {
                        (element.eccentricity == true) ? strEcc = " | Eccentricity:" : "";
                    }
                    strEcc = strEcc + " Standard Weight:" + element.std_wt + ",";
                    strEcc = strEcc + "(-)Tolerance:" + element.neg_Tol + ",";
                    strEcc = strEcc + "(+)Tolerance:" + element.pos_Tol;
                }
                if (element.uncertinity == true) {
                    if (uncer == "") {
                        (element.uncertinity == true) ? uncer = " | Uncertinity:" : "";
                    }
                    uncer = uncer + " Standard Weight:" + element.std_wt + ",";
                    uncer = uncer + "(-)Tolerance:" + element.neg_Tol + ",";
                    uncer = uncer + "(+)Tolerance:" + element.pos_Tol;
                }
                if (element.linerity == true) {
                    if (strLin == "") {
                        (element.linerity == true) ? strLin = " | Linearity:" : "";
                    }
                    strLin = strLin + " Standard Weight:" + element.std_wt + ",";
                    strLin = strLin + "(-)Tolerance:" + element.neg_Tol + ",";
                    strLin = strLin + "(+)Tolerance:" + element.pos_Tol;
                }
                i++;

            });
            var final = strDaily + strLin + strEcc + rep + per + uncer;

            var newStr = final.substring(0, final.length);

            return newStr;

        } catch (error) {
            return error;
        }
    }

    /**
     * @param {*} req Holds the request object holding `balance Id` and `type=Edit`
     * @memberof BalanceModel
     */
    async updateBalanceLock(req) {
        try {
            var obj_response = {};
            var type = req.body.type;

            let transaction = await seqTransaction.sequelize.transaction(async (t) => {
                var lock = (type == 'Edit') ? 1 : 0;
                await models.tbl_balance.update({
                    locked: lock
                }, {
                    where:
                        { Bal_ID: req.body.BalID }
                }, {
                    transaction: t
                });
            });

            if (type == 'Edit') {
                Object.assign(obj_response, { status: 'success' }, { result: 'lock value update' });
                return obj_response;
            }
            else {
                Object.assign(obj_response, { status: 'success' }, { result: 'lock value delete' })
                return obj_response;
            }

        } catch (error) {
            return error;
        }
    }
    /**
     * @param {*} req Holds the request object containing balance object along with calibration weights
     * @description Function Updates the balance
     * @memberof BalanceModel 
     */
    async updateBalance(value) {
        try {
            let obj_response = {};

            let transaction = await seqTransaction.sequelize.transaction(async (t) => {
                let now = new Date();
                let calStoreType = value.cal_store_type;
                let calDate = value.cal_dates;
                var storeType, calibrationDate, calibrationDueDate, calibrationDuration, calibrationDueDateY;
                if (calStoreType == 'set_days') {
                    storeType = 1;
                    calibrationDueDate = value.calibration_date;
                    calibrationDueDateY = value.calibration_dateY;
                    calibrationDate = 0;
                    calibrationDuration = value.duration;
                } else {
                    storeType = 0;
                    calibrationDueDate = 0;
                    calibrationDueDateY = 0;
                    calibrationDate = calDate.toString();
                    calibrationDuration = 0;
                }

                var weights = value.weights;
                var count = weights.length;

                await models.tbl_balance.update({
                    Bal_Model: value.modelNo,
                    Bal_Make: value.make,
                    Bal_SrNo: value.serialNo,
                    Bal_Dept: value.department,
                    Bal_LeastCnt: value.leastCount,
                    Bal_MaxCap: value.maxCapacity,
                    Bal_MinCap: value.minCapacity,
                    Bal_Unit: value.selectedUnit,
                    Bal_CalbStoreType: storeType,
                    Bal_CalbDates: calibrationDate,
                    Bal_CalbDuration: calibrationDuration,
                    Bal_CalbDueDt: calibrationDueDate,
                    Bal_CalbDueDtL: date.format(now, 'YYYY-MM-DD'),
                    Bal_CalbDueDtU: date.format(now, 'YYYY-MM-DD'),
                    Bal_CalbDueDtR: date.format(now, 'YYYY-MM-DD'),
                    Bal_CalbDueDtE: date.format(now, 'YYYY-MM-DD'),
                    Bal_IsCalibFail: 0,
                    Bal_CalbReminder: value.set_reminder,
                    Bal_MaxoptRange: value.maxOperatingRange,
                    Bal_MinoptRange: value.minOperatingRange,
                    Bal_DP: value.bal_dp,
                    Bal_DSNW: value.Bal_DSNW,
                    Bal_FormNo: value.formNo,
                    Bal_Status: value.selectedStatus,
                    Bal_VersionNo: value.versionNo,
                    Bal_Location: value.location,
                    locked: 0,
                    Bal_Cert_No:value.Bal_Cert_No,
                    Bal_ChangeWt: 1,
                    Bal_isActivate:0,
                    Bal_isReject:0
                }, {
                    where:
                        { Bal_ID: value.balID },
                        transaction: t
                });

                await models.tbl_balance_weights.destroy({
                    where:
                        { Bal_ID: value.balID },
                        transaction: t
                });

                for (var wtVal of weights) {
                    var stdwt = wtVal.std_wt;
                    var negTol = wtVal.neg_Tol;
                    var posTol = wtVal.pos_Tol;
                    var daily = wtVal.daily;
                    var linerity = wtVal.linerity;
                    var eccentricity = wtVal.eccentricity;
                    var repetability = wtVal.repetability;
                    var periodic = wtVal.periodic;
                    var uncertainty = wtVal.uncertinity;

                    let intEccentPoint = (eccentricity == true || eccentricity == 1) ? parseInt(value.intEccentricityCount) : 0;
                    let intUncertCount = (uncertainty == true || uncertainty == 1) ? parseInt(value.intUncertaintyCount) : 0;
                    let intReptCount = (repetability == true || repetability == 1) ? parseInt(value.intRepeatabilityCount) : 0;

                    var int_dailyValue = (daily == true || daily == 1) ? 1 : 0;
                    var int_periodicValue = (periodic == true || periodic == 1) ? 1 : 0;
                    var int_linerityValue = (linerity == true || linerity == 1) ? 1 : 0;
                    var int_eccentricityValue = (eccentricity == true || eccentricity == 1) ? 1 : 0;
                    var int_uncertaintyValue = (uncertainty == true || uncertainty == 1) ? 1 : 0;
                    var int_repetabilityValue = (repetability == true || repetability == 1) ? 1 : 0;

                    await models.tbl_balance_weights.create({
                        Bal_ID: value.balID,
                        Bal_StdWt: stdwt,
                        Bal_NegTol: negTol,
                        Bal_PosTol: posTol,
                        Bal_Daily: int_dailyValue,
                        Bal_Periodic: int_periodicValue,
                        Bal_Linearity: int_linerityValue,
                        Bal_IsEccentricity: int_eccentricityValue,
                        Bal_EccentPoint: intEccentPoint,
                        Bal_IsUncertinity: int_uncertaintyValue,
                        Bal_UncertCount: intUncertCount,
                        Bal_IsRepetability: int_repetabilityValue,
                        Bal_ReptCount: intReptCount,
                        PercentofCapacity: 0
                    }, {
                        transaction: t
                    });

                } // for loop

                await models.tbl_audit_bal_setting.create({
                    tm: date.format(now, 'HH:mm:ss'),
                    dt: date.format(now, 'YYYY-MM-DD'),
                    userid: value.LoggeduserId,
                    username: value.Loggedusername,
                    ACT: value.hdnAction,
                    Remark: value.remark,
                    Bal_Id: value.balID,
                    OldParameter: value.oldParameter,
                    NewParameter: value.newParameter,
                    OldWeight: value.oldWeights,
                    NewWeight: value.newWeights
                }, {
                    transaction: t
                });

                await models.tbl_activity_log.create({
                    dt: date.format(now, 'YYYY-MM-DD'),
                    tm: date.format(now, 'HH:mm:ss'),
                    userid: value.LoggeduserId,
                    username: value.Loggedusername,
                    activity: 'Balance Updated'
                }, {
                    transaction: t
                });
                return "success";
            });

            Object.assign(obj_response, { status: 'success' }, { result: 'Balance Updated Successfully' })
            return obj_response;
        } catch (error) {
            console.log("Edit Balance", error)
            return error;
        }


    }
    //*********************************************************************************** */

    // getAuditOldWeightsForEdit(req) {
    //     return new Promise((resolve, reject) => {
    //         const weights = req.body.oldWeights;

    //         var strDaily = "";
    //         var strLin = "";
    //         var strEcc = "";
    //         var rep = "";
    //         var per = "";
    //         var uncer = "";
    //         var i = 0;
    //         weights.forEach(function (element) {
    //             //strDaily == "" ? "" : strDaily ;
    //             if (i == 0) {
    //                 strDaily = "Daily : ";
    //                 strLin = " | Linearaity : ";
    //                 strEcc = " | Eccentricity : ";
    //                 rep = " | Repetability : ";
    //                 per = " | Periodic : ";
    //                 uncer = " | Uncertainty : "
    //             }

    //             if (element.Bal_Daily == 1) {
    //                 strDaily = strDaily + " Std Wt:" + element.Bal_StdWt + ",";
    //                 strDaily = strDaily + " Neg Tol:" + element.Bal_NegTol + ",";
    //                 strDaily = strDaily + " Pos Tol:" + element.Bal_PosTol + ",";
    //             }
    //             if (element.Bal_Linearity == 1) {
    //                 strLin = strLin + " Std Wt:" + element.Bal_StdWt + ",";
    //                 strLin = strLin + "  Neg Tol:" + element.Bal_NegTol + ",";
    //                 strLin = strLin + "  Neg Tol:" + element.Bal_PosTol + ",";
    //             }
    //             if (element.Bal_IsEccentricity == 1) {
    //                 strEcc = strEcc + " Std Wt:" + element.Bal_StdWt + ",";
    //                 strEcc = strEcc + "  Neg Tol:" + element.Bal_NegTol + ",";
    //                 strEcc = strEcc + "  Neg Tol:" + element.Bal_PosTol + ",";
    //             }
    //             if (element.Bal_IsRepetability == 1) {
    //                 rep = rep + " Std Wt:" + element.Bal_StdWt + ",";
    //                 rep = rep + "  Neg Tol:" + element.Bal_NegTol + ",";
    //                 rep = rep + "  Neg Tol:" + element.Bal_PosTol + ",";
    //             }
    //             if (element.Bal_Periodic == 1) {
    //                 per = per + " Std Wt:" + element.Bal_StdWt + ",";
    //                 per = per + "  Neg Tol:" + element.Bal_NegTol + ",";
    //                 per = per + "  Neg Tol:" + element.Bal_PosTol + ",";
    //             }
    //             if (element.Bal_IsUncertinity == 1) {
    //                 uncer = uncer + " Std Wt:" + element.Bal_StdWt + ",";
    //                 uncer = uncer + "  Neg Tol:" + element.Bal_NegTol + ",";
    //                 uncer = uncer + "  Neg Tol:" + element.Bal_PosTol + ",";
    //             }

    //             i++;

    //         });
    //         var final = strDaily + strLin + strEcc + rep + per + uncer;

    //         var newStr = final.substring(0, final.length - 1);

    //         resolve(newStr);

    //     })
    // }

    // getAuditNewWeightsForEdit(req) {
    //     return new Promise((resolve, reject) => {
    //         const weights = req.body.weights;

    //         var strDaily = "";
    //         var strLin = "";
    //         var strEcc = "";
    //         var rep = "";
    //         var per = "";
    //         var uncer = "";
    //         var i = 0;
    //         weights.forEach(function (element) {
    //             //strDaily == "" ? "" : strDaily ;
    //             if (i == 0) {
    //                 strDaily = "Daily : ";
    //                 strLin = " | Linearaity : ";
    //                 strEcc = " | Eccentricity : ";
    //                 rep = " | Repetability : ";
    //                 per = " | Periodic : ";
    //                 uncer = " | Uncertainty : "
    //             }

    //             if (element.daily == 1) {
    //                 strDaily = strDaily + " Std Wt:" + element.std_wt + ",";
    //                 strDaily = strDaily + " Neg Tol:" + element.neg_Tol + ",";
    //                 strDaily = strDaily + " Pos Tol:" + element.pos_Tol + ",";
    //             }
    //             if (element.linerity == 1) {
    //                 strLin = strLin + " Std Wt:" + element.std_wt + ",";
    //                 strLin = strLin + "  Neg Tol:" + element.neg_Tol + ",";
    //                 strLin = strLin + "  Neg Tol:" + element.pos_Tol + ",";
    //             }
    //             if (element.eccentricity == 1) {
    //                 strEcc = strEcc + " Std Wt:" + element.std_wt + ",";
    //                 strEcc = strEcc + "  Neg Tol:" + element.neg_Tol + ",";
    //                 strEcc = strEcc + "  Neg Tol:" + element.pos_Tol + ",";
    //             }
    //             if (element.repetability == 1) {
    //                 rep = rep + " Std Wt:" + element.std_wt + ",";
    //                 rep = rep + "  Neg Tol:" + element.neg_Tol + ",";
    //                 rep = rep + "  Neg Tol:" + element.pos_Tol + ",";
    //             }
    //             if (element.periodic == 1) {
    //                 per = per + " Std Wt:" + element.std_wt + ",";
    //                 per = per + "  Neg Tol:" + element.neg_Tol + ",";
    //                 per = per + "  Neg Tol:" + element.pos_Tol + ",";
    //             }
    //             if (element.uncertinity == 1) {
    //                 uncer = uncer + " Std Wt:" + element.std_wt + ",";
    //                 uncer = uncer + "  Neg Tol:" + element.neg_Tol + ",";
    //                 uncer = uncer + "  Neg Tol:" + element.pos_Tol + ",";
    //             }

    //             i++;

    //         });
    //         var final = strDaily + strLin + strEcc + rep + per + uncer;

    //         var newStr = final.substring(0, final.length - 1);

    //         resolve(newStr);

    //     })
    // }

    async updateActiveDeactive(value) {
        try {
            var obj_response = {};
            var approval = 1;
            var status = (value.action == 'Activate') ? 1 : 0;
            var balID = value.balID;
            var balanceData = await this.getBalanceByID(balID);
            let transaction = await seqTransaction.sequelize.transaction(async (t) => {
                var now = new Date();
                if (balanceData[0].Bal_IsApproved == 0) {
                    await models.tbl_balance.update({
                        Bal_IsApproved: approval,
                        Bal_ApprovedBy: value.userId
                    }, {
                        where:
                            { Bal_ID: balID }
                    }, {
                        transaction: t
                    });
                }

                if( value.action == 'Deactivate'){
                    await models.tbl_balance.update({
                        Bal_RejectRemark : value.remark
                    },{
                        where : {Bal_ID : balID}
                    },{
                        transaction : t
                    });
                }

                await models.tbl_balance.update({
                    Bal_isActivate: status,
                    Bal_isReject: status == 1 ? 0 : 1
                }, {
                    where:
                        { Bal_ID: balID }
                }, {
                    transaction: t
                });

                await models.tbl_audit_bal_setting.create({
                    dt: date.format(now, 'YYYY-MM-DD'),
                    tm: date.format(now, 'HH:mm:ss'),
                    userid: value.userId,
                    username: value.userName,
                    ACT: value.action,
                    Remark: value.remark,
                    Bal_Id: value.balID,
                    OldParameter: 'NA',
                    NewParameter: 'NA',
                    OldWeight: 'NA',
                    NewWeight: 'NA'
                }, {
                    transaction: t
                });


            });

            var responseStatus;
            if (value.action == 'Activate') {
                responseStatus = 'Balance Activated Successfully';
            } else {
                responseStatus = 'Balance Deactivated Successfully';
            }
            Object.assign(obj_response, { status: 'success' }, { result: responseStatus })
            if(value.action == 'Deactivate'){
                // let userData = await models.tbl_users.findAll({ attributes:['Role'], where : { UserID : balanceData[0].userID }});
                socketHandler.sendMessageToClient(`${balanceData[0].RejectGroup}_notification`,{message: value.remark ,title:`Balance "${value.balID}" Rejected`,redirect : ['/','master','balance','edit-balance'],data:balanceData[0]})
            }
            return obj_response;
        }
        catch (error) {
            console.log("Activate/Deactivate Balance", error);
            return error;
        }
    }
    async releaseRejectBalance(value) {
        try {
            var obj_response = {};
            var approval = 1;
            var status = (value.action == 'Release') ? 1 : (value.action == 'Block') ? 2 : 0;
            var rejStatus = (value.action == 'Reject') ? 1 : 0;
            var balID = value.balID;

            var balanceData = await this.getBalanceByID(balID);
            
            if(value.action == "Release" && balanceData[0].Bal_isActivate == 1){
                Object.assign(obj_response, { status: 'success' }, { result: 'Balance Already Released' })
                return obj_response;
            }else if(value.action == "Block" && balanceData[0].Bal_isActivate == 2){
                Object.assign(obj_response, { status: 'success' }, { result: 'Balance Already Blocked' })
                return obj_response;
            }else if(value.action == "Reject" && balanceData[0].Bal_isReject == 1){
                Object.assign(obj_response, { status: 'success' }, { result: 'Balance Already Rejected' })
                return obj_response;
            }

            let transaction = await seqTransaction.sequelize.transaction(async (t) => {
                var now = new Date();
                if (balanceData[0].Bal_IsApproved == 0) {
                    await models.tbl_balance.update({
                        Bal_IsApproved: approval,
                        Bal_ApprovedBy: value.userId
                    }, {
                        where:
                            { Bal_ID: balID }
                    }, {
                        transaction: t
                    });
                }

                if( value.action == 'Reject'){
                    await models.tbl_balance.update({
                        Bal_RejectRemark : value.remark
                    },{
                        where : {Bal_ID : balID}
                    },{
                        transaction : t
                    });
                }

                await models.tbl_balance.update({
                    Bal_isActivate: status,
                    Bal_isReject: rejStatus
                }, {
                    where: { Bal_ID: balID },
                        transaction: t
                });

                await models.tbl_audit_bal_setting.create({
                    dt: date.format(now, 'YYYY-MM-DD'),
                    tm: date.format(now, 'HH:mm:ss'),
                    userid: value.userId,
                    username: value.userName,
                    ACT: value.action,
                    Remark: value.remark,
                    Bal_Id: value.balID,
                    OldParameter: 'NA',
                    NewParameter: 'NA',
                    OldWeight: 'NA',
                    NewWeight: 'NA'
                }, {
                    transaction: t
                });


            });

            var responseStatus;
            if (value.action == 'Release') {
                responseStatus = 'Balance Released Successfully';
            }else if (value.action == 'Block') {
                responseStatus = 'Balance Blocked Successfully';
            }  else {
                responseStatus = 'Balance Rejected Successfully';
            }
            Object.assign(obj_response, { status: 'success' }, { result: responseStatus })
            if(value.action == 'Reject'){
                // let userData = await models.tbl_users.findAll({ attributes:['Role'], where : { UserID : balanceData[0].userID }});
                socketHandler.sendMessageToClient(`${balanceData[0].RejectGroup}_notification`,{message: value.remark ,title:`Balance "${value.balID}" Rejected`,redirect : ['/','master','balance','edit-balance'],data:balanceData[0]})
            }
            return obj_response;
        }
        catch (error) {
            console.log("Release/Reject Balance", error);
            return error;
        }
    }

    async checkInCubicle(req) {
        try {
            let obj_res = {};
            var arr_cubicle = [];

            let result = await models.tbl_cubical.findAll({
                where:
                    { Sys_BalID: req.body.balID }
            });

            let resultBin = await models.tbl_cubical.findAll({
                where:
                    { Sys_BinBalID: req.body.balID }
            });


            if (result.length > 0) {
                let res_getCubicles = await models.tbl_cubicle_area.findAll({
                    attributes:  ['IDSFrom', 'IDSTo'],
                    where: { Area: result[0]['Sys_Area'] } 
                });


                for (let i = res_getCubicles[0]['IDSFrom']; i <= res_getCubicles[0]['IDSTo']; i++) {
                    arr_cubicle.push(i);
                }
                let int_no = arr_cubicle.indexOf(result[0]['Sys_CubicNo']) + 1;
                obj_res = { 'Sys_Area': result[0]['Sys_Area'], "Sys_CubicNo": int_no };
            }
            else if (resultBin.length > 0) {
                let res_getCubicles = await models.tbl_cubicle_area.findAll({
                    attributes:
                        ['IDSFrom', 'IDSTo']
                },
                    {
                        where:
                            { Area: resultBin[0]['Sys_Area'] }
                    });


                for (let i = res_getCubicles[0]['IDSFrom']; i <= res_getCubicles[0]['IDSTo']; i++) {
                    arr_cubicle.push(i);
                }
                let int_no = arr_cubicle.indexOf(resultBin[0]['Sys_CubicNo']) + 1;
                obj_res = { 'Sys_Area': resultBin[0]['Sys_Area'], "Sys_CubicNo": int_no };
            }
            else {
                obj_res = null;
            }

            return obj_res;

        } catch (error) {
            return error;
        }
    }


    async addBalanceNoCalib(req) {
        try {
            let obj_response = {};

            let resExist = await models.tbl_balance.findAll({where:
                { Bal_ID: req.body.balID }
            });
        
            if(resExist.length != 0){
                Object.assign(obj_response, { status: 'success' }, { result: 'Balance Id already exist' });
                return obj_response;
            }
            else
            {
                let transaction = await seqTransaction.sequelize.transaction(async (t) =>{
                    let now = new Date();
                    await models.tbl_balance.create({
                        Bal_Model: req.body.modelNo,
                        Bal_Make: req.body.make,
                        Bal_SrNo: req.body.serialNo,
                        Bal_ID: req.body.balID,
                        Bal_Dept: req.body.department,
                        Bal_LeastCnt: req.body.leastCount,
                        Bal_MaxCap: req.body.maxCapacity,
                        Bal_MinCap: req.body.minCapacity,
                        Bal_Unit: req.body.selectedUnit,
                        Bal_MaxoptRange: req.body.maxOperatingRange,
                        Bal_MinoptRange: req.body.minOperatingRange,
                        IsNewBalance: 1,
                        Bal_DP: req.body.bal_dp,
                        userID: req.body.LoggeduserId
                    },{
                        transaction: t
                    });

                    await models.tbl_audit_bal_setting.create({
                        tm: date.format(now, 'HH:mm:ss'),
                        dt: date.format(now, 'YYYY-MM-DD'),
                        userid: req.body.LoggeduserId,
                        username: req.body.Loggedusername,
                        ACT: req.body.hdnAction,
                        Remark: req.body.remark,
                        Bal_Id: req.body.balID,
                        OldParameter: 'NA',
                        NewParameter: req.body.newParameter,
                        OldWeight: 'NA',
                        NewWeight: "NA"
                    },{
                        transaction: t
                    });

                    await models.tbl_activity_log.create({
                        dt:date.format(now, 'YYYY-MM-DD'),
                        tm:date.format(now, 'HH:mm:ss'),
                        userid:req.body.LoggeduserId,
                        username:req.body.Loggedusername,
                        activity:'Balance Added' 
                    },{
                        transaction: t
                    });
                });

                Object.assign(obj_response, { status: 'success' }, { result: 'Balance Added Successfully' });
                return obj_response;
            }
        } catch (error) {
            console.log("error",error);
            return error;
        }
    }

    async updateBalanceNoCalib(req){
        try{
            var responseObj = {};
            let transaction = await seqTransaction.sequelize.transaction(async (t) => {
                var now = new Date();

                await models.tbl_balance.update({
                    Bal_Model: req.body.modelNo,
                    Bal_Make: req.body.make,
                    Bal_SrNo: req.body.serialNo,
                    Bal_Dept: req.body.department,
                    Bal_LeastCnt: req.body.leastCount,
                    Bal_MaxCap: req.body.maxCapacity,
                    Bal_MinCap: req.body.minCapacity,
                    Bal_Unit: req.body.selectedUnit,
                    Bal_MaxoptRange: req.body.maxOperatingRange,
                    Bal_MinoptRange: req.body.minOperatingRange,
                    Bal_DP: req.body.bal_dp,
                    userID: req.body.LoggeduserId
                }, {
                    where:
                        { Bal_ID: req.body.balID }
                }, {
                    transaction: t
                });

                await models.tbl_audit_bal_setting.create({
                    dt: date.format(now, 'YYYY-MM-DD'),
                    tm: date.format(now, 'HH:mm:ss'),
                    userid: req.body.LoggeduserId,
                    username: req.body.Loggedusername,
                    ACT: req.body.hdnAction,
                    Remark: req.body.remark,
                    Bal_Id: req.body.balID,
                    OldParameter: req.body.oldParameter,
                    NewParameter: req.body.newParameter,
                    OldWeight: 'NA',
                    NewWeight: 'NA'
                }, {
                    transaction: t
                });

                await models.tbl_activity_log.create({
                    dt: date.format(now, 'YYYY-MM-DD'),
                    tm: date.format(now, 'HH:mm:ss'),
                    userid: req.body.LoggeduserId,
                    username: req.body.Loggedusername,
                    activity: 'Balance Updated'
                }, {
                    transaction: t
                });
            });
        
            Object.assign(responseObj, { status: 'success' }, { result: 'Balance Updated Successfully' });
            return responseObj;
            
        }catch(error){
            console.log("error",error);
            return error;
        }
    }

     /**
     * @description Function gives the `Balances whose routine periodic calibration is pending.`
     * @memberof BalanceModel
     */
     async getBalList_DisallowToEditBalIfRoutineCalbPending() {
        try {
            const arr_Final = [];
            const currDate =  moment({h:0, m:0, s:0, ms:0});
            const arr_BalList = await models.tbl_balance.findAll({
                attributes:
                    ['Bal_ID','Bal_CalbStoreType','Bal_CalbDates','Bal_CalbDueDt'],
                where:
                    { 
                        Bal_isActivate: 0 ,
                        IsNewBalance: 0
                    }
                    
            });

            for (const elt of arr_BalList) {
                if (elt.Bal_CalbStoreType == 1) {
                    // Here, we check condition (Bal_CalbDueDt <= currDate) is true then Routine calibration is pending;
                    // So push respective BalanceID in 'arr_Final'; so that system will not displayed that BalanceID in Edit Balance Module.
                    if ((currDate.diff(moment(elt.Bal_CalbDueDt), 'days')) >= 0) {
                        arr_Final.push(elt.Bal_ID);
                    }

                } else { // Bal_CalbStoreType = 0
                    let arr_dates = elt.Bal_CalbDates.split(',');
                    let less_arr_dates = arr_dates.filter((item) => {
                        return item <= currDate.date();
                    });
                    let startDate ;
                    if(less_arr_dates.length > 0){
                        startDate = moment({ year :currDate.year(), month :currDate.month(), day :less_arr_dates[less_arr_dates.length-1], 
                            hour :0, minute :0, second :0, millisecond :0});
                    }else{
                        //checkin periodic done is earlier month or not
                        /**
                         *  on 1st  routine calibration of that month check last routine Periodic calibration status by fetch data  from last periodic date
                            to current
                         */
                        startDate = moment({ year :currDate.year(), month :currDate.month() - 1, day :arr_dates[arr_dates.length-1], 
                            hour :0, minute :0, second :0, millisecond :0});
                    }

                    const objPeriodic = await models.tbl_calibration_periodic_master.findAll({
                        where:
                        {
                            Periodic_CalbDate: { [Op.between]: [startDate, currDate] },
                            Periodic_BalID: { [Op.eq]: [elt.Bal_ID] }
                        }
                    });
                    if (objPeriodic.length == 0) {
                        arr_Final.push(elt.Bal_ID);
                    }
                }
            }

            return arr_Final;
        } catch (error) {
            console.error(error);
            throw error;
        }
    }
}

module.exports = BalanceModel;