const models = require("../dbConnection").models;
const requestIp = require('request-ip');
const sequelize = require('./../dbConnection').sequelize;

/**
 * @class EditStatusModel
 */
class EditStatusModel {

    /**
     * 
     * @param {*} req 
     * @memberof EditStatusModel
     * @description Function updates the locked status while editing some stuffs
     * While editing this stuff the entry stored in `tbl_edit_status`
     */
    async editstatus(req) {
        try {
            let obj_response = {};
            let clientIp = requestIp.getClientIp(req);
            let ip = clientIp.split(':')[3]
            if (ip === undefined) {// If Request comes from Local PC
                ip = '127.0.0.1'
            } else {
                ip = ip
            }
            let lock = parseInt(req.body.lockedValue);

            if (lock == 1) {

                let result = await models[req.body.Type].findAll({where:
                     { [`${req.body.dbColName}`]: req.body.commonValue }
                    }
                );

                let data = {};
                data = result;
                let eqplock = data[0][req.body.lockedColName];
                var eqplockValue = eqplock;

                    if (eqplockValue == 1) {
                        Object.assign(obj_response, { status: 'success' }, { result: 'Already in use by other user' })
                        return obj_response;
                    } else {

                        await models[req.body.Type].update({
                            [`${req.body.lockedColName}`]: lock
                        },{
                            where:
                            { [`${req.body.dbColName}`]: req.body.commonValue } 
                        });

                        await models.tbl_edit_status.create({
                            userID : req.body.userID,
                            Type : req.body.Type,
                            Item : req.body.commonValue,
                            fieldName : req.body.dbColName,
                            Ip : ip
                       });

                        Object.assign(obj_response, { status: 'success' }, { result: 'lock value update' })
                        return obj_response;
                    }
            }
            else
            {
                await models[req.body.Type].update({
                    [`${req.body.lockedColName}`]: lock
                },{
                    where:
                    { [`${req.body.dbColName}`]: req.body.commonValue } 
                });

                await models.tbl_edit_status.destroy({where:
                    {Item: req.body.commonValue} 
                });
            
                Object.assign(obj_response, { status: 'success' }, { result: 'lock value deleted' })
                return obj_response;
            }
        } catch (error) {
            return error;
        }
    }
    /**
     * @description Function set the lock in the requested table name when `lock` holds `1` Also 
     * respected parameter entry insert into `edit_status` table. Also unset lock when
     * `lock` holds `0` also respected parameter entry delets from `edit_status`
     * @param {*} req Request object holds the paramters
     * @memberof EditStatusModel
     */
   async multiCondiEditStatus(req) { 
       try {
            var responseObj = {};
            var clientIp = requestIp.getClientIp(req);
            var ip = clientIp.split(':')[3]
            if (ip === undefined) {
                ip = '127.0.0.1'
            } else {
                ip = ip
            }
            var arrCond = req.body.arr_Cond;
            var lock = parseInt(req.body.lockedValue); 
            if (lock == 1){
                var prdDetObj = await models[''+req.body.Type].findAll({
                    where:arrCond
                });
                var result = prdDetObj;
                let data = {};
                data = result[0];
                var str_lockColName = req.body.lockedColName;
                let eqplock = data[str_lockColName];
                var eqplockValue;
                if ((eqplock == 0) || (eqplock == 0)) {
                    eqplockValue = eqplock;
                } else {
                    eqplockValue = eqplock;
                }
                if (eqplockValue == 1) { //Already lock aquired by other host
                    Object.assign(responseObj, { status: 'success' }, { result: 'being edited' })
                    return responseObj;
                } else {
                    
                    const updateObj = await models[''+req.body.Type].update({[`${req.body.lockedColName}`]:lock},
                        {where: arrCond});
                    var fieldName,item;
                    var arr_fieldName = []; var arr_item = [];
                    var arr = req.body.arr_Cond1;
                    for(var i = 0; i < arr.length; i++){
                        fieldName = arr[i].str_colName;
                        item = arr[i].value;
                        arr_fieldName.push(fieldName);
                        arr_item.push(item);
                    }
                    
                    const insertEditStatusObj = await models.tbl_edit_status.create({
                        userID:req.body.userID,
                        Type:req.body.Type,
                        Item:arr_item.toString(),
                        fieldName:arr_fieldName.toString(),
                        Ip:ip
                    });
                        Object.assign(responseObj, { status: 'success' }, { result: 'lock value update' })
                        return responseObj;
                }
            }else{
                const updateObj1 = await models[req.body.Type].update({
                            locked: lock
                        },{
                            where:arrCond
                            
                        });
                const deleteEditStatus = await models.tbl_edit_status.destroy({where:
                            {Ip: ip}
                        });
                Object.assign(responseObj, { status: 'success' }, { result: 'lock value update' });
                return responseObj;
            }
       } catch (error) {
           console.log(error);
           return error;
       } 
    }
}
module.exports = EditStatusModel;