const dbCon = require('../Utills/db');
const date = require('date-and-time');
const Database = require('../database/clsQueryProcess');
const database = new Database();
class Interface { 
    getIds() { 
        return dbCon.execute('SELECT Sys_IDSNo FROM `tbl_cubical`');
    }
    // returning user detail based on userId only for biometric module
    getUserDetail(userId) { 
        return dbCon.execute('SELECT * FROM `tbl_users` WHERE userid = ?', [userId]);
    }
    getUser(userID, userPassword) { 
        return dbCon.execute('SELECT * FROM `tbl_users` WHERE userid = ? and realPassword = ?', [userID, userPassword]);
    }
    getIdsDeatails() { 
        return dbCon.execute('SELECT * FROM `tbl_cubical`');
    }
    checkDailyCalibration(strBalID) { 
        let now = new Date();
        return dbCon.execute('SELECT * FROM `tbl_calibration_daily_master` WHERE `Daily_BalID`=? and `Daily_CalbDate`=?', [strBalID, date.format(now, 'YYYY-MM-DD')]);
    }
    getBalanceCalibrationWeights(strBalID) { 
        return dbCon.execute('SELECT * FROM `tbl_balance_weights` WHERE Bal_ID=? AND Bal_Daily=?', [strBalID, 1]);
    }
    getAllParameters() { 
        return dbCon.execute('SELECT * FROM `tbl_setallparameter`');
    }
}
module.exports = Interface;