const ldap = require('ldap-authentication');
const models = require("../dbConnection").models;
const LDAP = require('../model/clsldapModel');
const objLDAP = new LDAP();
const ldapjs = require('ldapjs');
const { Sequelize } = require('../../../IncrencyV4_DRL_Model/models');
const { decoding } = require('../ldapGlobal/MulteServerConfig');
const sequelize = require("../dbConnection").sequelize;
const  ldapConfig = require('../ldapGlobal/severConfig');
const serverConfig = require('../global/serverConfig');
const seqTransaction =  require("../dbConnection");


class userFetchModel {
  listUsers() {
    return new Promise((resolve,reject) => {
      try {
          this.connectLdapClientFetchData().then(ldapRes => {
            this.syncUserData(ldapRes).then( syncDataRes => resolve(syncDataRes)).catch( err => reject(err))
          }).catch( err => reject(err))
      } catch (error) {
        reject(error)
      }
    })
  }

  async connectLdapClientFetchData(){
    return new Promise((resolve,reject) => {
      const data = []
      const client = ldapjs.createClient({ url: ldapConfig.ldapSetUp.ldapOpts.url})
      client.bind(ldapConfig.ldapSetUp.adminDn,decoding(process.env.adminPassword),(err) => {
        if(err){
          reject(err)
        }

        const searchOptions = {
          scope: 'sub',
          filter: `(memberOf=${ldapConfig.groupDn})`,  // Filter for users belonging to the group
          attributes: ['name', 'mail', 'givenName', 'employeeID'], // Attributes to retrieve
        };

        client.search(ldapConfig.baseDn, searchOptions, (err, res) => {
            if (err) {
                reject(err);
            }

            var usercount = 0;

            // Handle the entries returned
            res.on('searchEntry', (entry) => {
                console.log('User:' + usercount++, JSON.stringify(entry.pojo.attributes));
                data.push(entry.pojo.attributes)

            });

            res.on('error', (err) => {
                reject(err)
            });

            res.on('end', (result) => {
                console.log('Search complete with status:', result.status);
                client.unbind();  // Unbind after search is completed
                const newData = [];
                for (const value of data) {
                  // console.log(value)
                    newData.push({"name" : value[1].values[0], "EmpID" : value[2].values[0],"mail": value.length > 3 ? value[3].values[0] : ''})
                }
                console.log('Entire User List Start');
                console.log(newData)
                console.log('Entire User List End');
                resolve(newData)
            });
        });
      })
      // const newData = [
      //   {name: 'Jillella Nagaraju', EmpID: 'P00029647', mail: 'jillellanagaraju@drreddys.com'},
      //   {name: 'Venkateswarlu Dasi', EmpID: 'P00023309', mail: 'venkateswarlud@drreddys.com'},
      //   {name: 'Chaganti Chaitanya', EmpID: 'P00046482', mail: 'chaganti@drreddys.com'},
      //   {name: 'Jaisukh BK', EmpID: 'P00078316', mail: 'JaisukhBK@drreddys.com'},
      //   {name: 'P K Aishwarya', EmpID: 'P00080349', mail: 'pkaishwarya@drreddys.com'},
      //   {name: 'Pattambetty Pavankumar', EmpID: 'P90014051', mail: 'pattambettypavankumar@drreddys.com'},
      //   {name: 'PASXProduction FTO3Test', EmpID: 'PASXProduction', mail: ''},
      //   {name: 'PASXQAFTO3Test', EmpID: 'PASXQAFTO3', mail: ''},
      //   {name: 'PASXFTO3Test', EmpID: 'PASXFTO3Test', mail: ''},
      //   {name: 'Pranesh A', EmpID: 'P90018650', mail: 'pranesha@drreddys.com'},
      //   {name: 'Sandra C J', EmpID: 'P90018684', mail: 'sandracj@drreddys.com'}
      // ]
      // resolve(newData);
    })
  }
  async syncUserData(LDAPdata){
    // var transactionRes = await seqTransaction.sequelize.transaction( async (t) => {
      const newUsers = [];

      for(const user of LDAPdata){
        try{
          const result = await objLDAP.insertNewUser(user);
          // console.log("Userid "+ user.EmpID);
          newUsers.push(result);
        }
        catch(error) {
          console.error(`Error adding user : ${user}`,error);
        }
      }

      const totalUsersAdded = newUsers
        .filter(user => user.status === "success" && user.count)
        .reduce((sum, user) => {
        // Extract the number of users from the 'count' string
        const numberAdded = parseInt(user.count);
        return sum + (isNaN(numberAdded) ? 0 : numberAdded); // Check for NaN in case of invalid number conversion
      }, 0);

      let UsersData = await models.tbl_users.findAll({});
    
      const unmatchedUsers = UsersData.filter(user => {            //users not present in LDAP but present in Users Table we will get here in this variable
        const userID = user.UserID;
        return !LDAPdata.some(res => res.EmpID === userID);
      });   
      const userIds = unmatchedUsers.map(item => `'${item.UserID}'`);
      const userIdsString = userIds.join(",");  //Join into a single string 
      
      //disable users not present in LDAP but present in tbl_users
      const query = `
          UPDATE tbl_users SET PwdChg = 0,Status = 2 where userType != 1 and UserID in (${userIdsString});
      `;
      
      const [result, metadata] = await sequelize.query(query, {type: Sequelize.QueryTypes.UPDATE});
      const affectedRows = metadata;
      return {status : "Success",Insert: `${totalUsersAdded}`+ " New Users Added", Update : `${affectedRows}`+ " Users Disabled" };
    // })
      
    // return transactionRes
  }
  
  predefineUserList(data){
    return new Promise((resolve,reject) => {
      let splitData = data.username.split(' ');
      if(splitData.length < 2){
        resolve({status:'fail',message:'Invalid User name Format'})
      }else if(!Number(data.userid)){
        resolve({status:'fail',message:'Invalid User id Format'})
      }else{
        let userData =  {"name" : data.username, "EmpID" : data.userid,"mail": `${splitData[0].toLowerCase()}.${splitData[1][0].toLowerCase()}@drreddys.com`};
        resolve({status:'success',data:userData})
      }
    })
  }

  staticStore(queryParams){
    // query
    // http://192.168.1.179:3041/API/sync/addUser?userid=45&username=Aditya%20Yadav
    return new Promise((resolve,reject) => {
      if(serverConfig.isLDAP && serverConfig.byPassLDAP){
         this.predefineUserList(queryParams).then( data => {
           if(data.status == 'success'){
             this.saveUser(data.data).then( syncDatares => resolve(syncDatares)).catch( err => reject(err))
            }else{
              resolve(data)
            }
         }).catch( err => reject(err));
      }else{
        return resolve({status:'fail',message:'invalid config'})
      }
    })
  }

  async saveUser(userData){
    let res =  await objLDAP.insertNewUser(userData)
    return res;
  }
}

module.exports = userFetchModel;
