const clsNewCompressed = require('./clsNewProductAuditComp.class');
const clsNewCapsule = require('./clsNewCapsuleAuditComp.class');
const clsNewCoated = require('./clsNewProductAuditCoat.class');
const clsNewGrannuals = require('./clsNewProductAuditGranu.class');
class ValidateNewProduct {

    async validateNewProduct(objProductNew, newProductType = 1) {
        if (newProductType == 1) {
            var resCompressed, resCoated, resGrannual;

            if (objProductNew.bln_TypeCompressed == true || objProductNew.bln_TypeBiLayPrd == true || 
                objProductNew.bln_TypeTriLayPrd == true) {
                const objClsNewCompressed = new clsNewCompressed();
                resCompressed = await objClsNewCompressed.newCompressedParams(objProductNew);
            }
            if (objProductNew.bln_TypeCoatPrd == true) {
                const objClsNewCoated = new clsNewCoated();
                resCoated = await objClsNewCoated.newCoatedParams(objProductNew);
            }
            if (objProductNew.bln_TypeGrannualPrd == true) {
                const objClsNewGrannuals = new clsNewGrannuals();
                resGrannual = await objClsNewGrannuals.newGranulationParams(objProductNew);
            }

            resCompressed = resCompressed == undefined || "" ? "No Change" : resCompressed;
            resCoated = resCoated == undefined || "" ? "No Change" : resCoated;
            resGrannual = resGrannual == undefined || "" ? "No Change" : resGrannual;

            if (resCompressed == "No Change" && resCoated == "No Change" && resGrannual == "No Change") {
                return { result: "No Change" };
            }
            else {
                if (resCompressed == "No Change") {
                    resCompressed = { result: "No Change" };
                } else if ((objProductNew.bln_isIndEmptyChecked == true) && (objProductNew.strProjectName == "RB")) {
                    resCompressed = { newData: "NA" };
                }
                if (resCoated == "No Change") {
                    resCoated = { result: "No Change" };
                }
                if (resGrannual == "No Change") {
                    resGrannual = { result: "No Change" };
                }
                const objProduct = {};
                Object.assign(objProduct, { Compressed: resCompressed },
                    { Coated: resCoated }, { Grannual: resGrannual });
                return objProduct;
            }

        }
        else {
            //capsule code
            var resCapsule;

            const objClsNewCapsule = new clsNewCapsule();
            resCapsule = await objClsNewCapsule.newCapsuleParams(objProductNew);

            if (objProductNew.bln_TypeGrannualPrd == true) {
                const objClsNewGrannuals = new clsNewGrannuals();
                resGrannual = await objClsNewGrannuals.newGranulationParams(objProductNew);
            }

            resCapsule = resCapsule == undefined || "" ? "No Change" : resCapsule;
            resGrannual = resGrannual == undefined || "" ? "No Change" : resGrannual;


            if (resCapsule == "No Change") {
                //const objProduct1 = {};
                //return Object.assign(objProduct1, { Capsule: resCapsule });
                return { result: "No Change" };
            }
            else {
                if (resCapsule == "No Change") {
                    resCompressed = { result: "No Change" };
                    
                }
                if (resGrannual == "No Change") {
                    resGrannual = { result: "No Change" };
                }

                const objProduct = {};
                Object.assign(objProduct, { Capsule: resCapsule },
                    { Grannual: resGrannual });

                return objProduct;
            }

        }

    }


}

module.exports = ValidateNewProduct;