var IterateObject = require("iterate-object");
const e = require("express");
serverConfig = require('../global/serverConfig').developerPanelData;
const Bln_Is_HardnessNMTNLT = (serverConfig.ProductMasterConf.find(x => x.Name === 'HardnessNMTNLT').Value == 1) ? true : false;

class ValidateProductCompressed {

    constructor() {
        const objResult = {};
        this.objResult = objResult;
        this.strNullValue = "99999.00000";
        this.NMTValue = 99999;
    }

    //DRL MES Validation

    validatePrdDtlsMES(objProductOld, objProductNew) {
        return new Promise((resolve, reject) => {
            const objProduct = {
                Product: {
                    'Product Name': { oldValue: "", newValue: "" },
                    'Product Code': { oldValue: "", newValue: "" },
                }
            };

            var IsChanged = false;
            var OldEmpty = objProductOld == undefined ? true : false;

            if (OldEmpty) {
                if (objProductNew.ProductId != "" && objProductNew.ProductId!=undefined) {
                    objProduct.Product['Product Code'].oldValue = "NA";
                    objProduct.Product['Product Code'].newValue = objProductNew.ProductId;
                    IsChanged = true;
                }
                else {
                    objProduct.Product['Product Code'].oldValue = false;
                    objProduct.Product['Product Code'].newValue = false;
                    IsChanged = IsChanged != true ? false : true;
                }
            }
            else {
                if (objProductOld.ProductId === "" ||
                    objProductOld.ProductId == this.strNullValue ||
                    objProductOld.ProductId == undefined) {
                    objProductOld.ProductId = null;
                }

                if (objProductNew.ProductId === "" || objProductNew.ProductId == this.strNullValue || objProductNew.ProductId == undefined) {
                    objProductNew.ProductId = null;
                }

                if ((objProductOld.ProductId !== null) && (objProductNew.ProductId !== null)) {
                    if (objProductOld.ProductId == objProductNew.ProductId) {
                        objProduct.Product['Product Code'].oldValue = false;
                        objProduct.Product['Product Code'].newValue = false;
                        IsChanged != true ? IsChanged = false : IsChanged = true;
                    }
                    else {
                        objProduct.Product['Product Code'].oldValue = (objProductOld.ProductId);
                        objProduct.Product['Product Code'].newValue = objProductNew.ProductId;
                        IsChanged = true;
                    }

                } else {

                    if ((objProductOld.ProductId === null) && (objProductNew.ProductId !== null)) {
                        objProduct.Product['Product Code'].oldValue = "NA";
                        objProduct.Product['Product Code'].newValue = objProductNew.ProductId;
                        IsChanged = true;

                    } else if ((objProductOld.ProductId !== null) && (objProductNew.ProductId === null)) {
                        objProduct.Product['Product Code'].oldValue = (objProductOld.ProductId);
                        objProduct.Product['Product Code'].newValue = "NA";
                        IsChanged = true;
                    }
                }
            }
            

            if (OldEmpty) {
                if (objProductNew.ProductName != "" && objProductNew.ProductName!=undefined) {
                    objProduct.Product['Product Name'].oldValue = "NA";
                    objProduct.Product['Product Name'].newValue = objProductNew.ProductName;
                    IsChanged = true;
                }
                else {
                    objProduct.Product['Product Name'].oldValue = false;
                    objProduct.Product['Product Name'].newValue = false;
                    IsChanged = IsChanged != true ? false : true;
                }
            }
            else {
                if (objProductOld.ProductName === "" ||
                    objProductOld.ProductName == this.strNullValue ||
                    objProductOld.ProductName == undefined) {
                    objProductOld.ProductName = null;
                }

                if (objProductNew.ProductName === "" ||
                    objProductNew.ProductName == this.strNullValue ||
                    objProductNew.ProductName == undefined) {
                    objProductNew.ProductName = null;
                }

                if ((objProductOld.ProductName !== null) && (objProductNew.ProductName !== null)) {
                    if ((objProductOld.ProductName) == objProductNew.ProductName) {
                        objProduct.Product['Product Name'].oldValue = false;
                        objProduct.Product['Product Name'].newValue = false;
                        IsChanged != true ? IsChanged = false : IsChanged = true;
                    }
                    else {
                        objProduct.Product['Product Name'].oldValue = objProductOld.ProductName;
                        objProduct.Product['Product Name'].newValue = objProductNew.ProductName;
                        IsChanged = true;
                    }

                } else {

                    if ((objProductOld.ProductName === null) && (objProductNew.ProductName !== null)) {
                        objProduct.Product['Product Name'].oldValue = "NA";
                        objProduct.Product['Product Name'].newValue = objProductNew.ProductName;
                        IsChanged = true;

                    } else if ((objProductOld.ProductName !== null) && (objProductNew.ProductName === null)) {
                        objProduct.Product['Product Name'].oldValue = objProductOld.ProductName;
                        objProduct.Product['Product Name'].newValue = "NA";
                        IsChanged = true;
                    }
                }
            }
            if (IsChanged == true) {
                Object.assign(this.objResult, objProduct);
            }
            resolve(IsChanged);
        });
    }

    validateIndividualMES(objProductOld, objProductNew) {
        return new Promise((resolve, reject) => {
            const objIndividual = {
                Individual: {
                    'Target': { oldValue: "", newValue: "" },
                    'Lower Limit': { oldValue: "", newValue: "" },
                    'Upper Limit': { oldValue: "", newValue: "" },
                    // "Quantity (Initial)":{ oldValue: "", newValue: "" },
                    // "Quantity (Regular)":{ oldValue: "", newValue: "" },
                    Unit:{ oldValue: "", newValue: "" },
                }
            };

            var IsChanged = false;
            var OldEmpty = objProductOld == undefined ? true : false;
            /**
             * For Individual T2Neg
             */
            if (OldEmpty) {
                if (objProductNew.Param1_T2Neg != "" && objProductNew.Param1_T2Neg!=undefined && objProductNew.Param1_T2Neg != 99999) {
                    objIndividual.Individual['Lower Limit'].oldValue = "NA";
                    objIndividual.Individual['Lower Limit'].newValue = objProductNew.Param1_T2Neg;
                    IsChanged = true;
                }
                else {
                    objIndividual.Individual['Lower Limit'].oldValue = false;
                    objIndividual.Individual['Lower Limit'].newValue = false;
                    IsChanged = IsChanged != true ? false : true;
                }
            }
            else {
                if (objProductOld.Param1_T2Neg === "" ||
                    objProductOld.Param1_T2Neg == this.strNullValue ||
                    objProductOld.Param1_T2Neg == undefined) {
                    objProductOld.Param1_T2Neg = null;
                }

                if (objProductNew.Param1_T2Neg === "" || objProductNew.Param1_T2Neg == this.strNullValue || objProductNew.Param1_T2Neg == undefined) {
                    objProductNew.Param1_T2Neg = null;
                }

                if ((objProductOld.Param1_T2Neg !== null) && (objProductNew.Param1_T2Neg !== null)) {
                    if ((objProductOld.Param1_T2Neg) == (objProductNew.Param1_T2Neg)) {
                        objIndividual.Individual['Lower Limit'].oldValue = false;
                        objIndividual.Individual['Lower Limit'].newValue = false;
                        IsChanged != true ? IsChanged = false : IsChanged = true;
                    }
                    else {
                        objIndividual.Individual['Lower Limit'].oldValue = (objProductOld.Param1_T2Neg);
                        objIndividual.Individual['Lower Limit'].newValue = objProductNew.Param1_T2Neg;
                        IsChanged = true;
                    }

                } else {

                    if ((objProductOld.Param1_T2Neg === null) && (objProductNew.Param1_T2Neg !== null)) {
                        objIndividual.Individual['Lower Limit'].oldValue = "NA";
                        objIndividual.Individual['Lower Limit'].newValue = objProductNew.Param1_T2Neg;
                        IsChanged = true;

                    } else if ((objProductOld.Param1_T2Neg !== null) && (objProductNew.Param1_T2Neg === null)) {
                        objIndividual.Individual['Lower Limit'].oldValue = (objProductOld.Param1_T2Neg);
                        objIndividual.Individual['Lower Limit'].newValue = "NA";
                        IsChanged = true;
                    }
                }
            }

            /**
             * For Individual Nom
             */
            
            if (OldEmpty) {
                if (objProductNew.Param1_Nom != "" && objProductNew.Param1_Nom!=undefined && objProductNew.Param1_Nom != 99999) {
                    objIndividual.Individual['Target'].oldValue = "NA";
                    objIndividual.Individual['Target'].newValue = objProductNew.Param1_Nom;
                    IsChanged = true;
                }
                else {
                    objIndividual.Individual['Target'].oldValue = false;
                    objIndividual.Individual['Target'].newValue = false;
                    IsChanged = IsChanged != true ? false : true;
                }
            }
            else {
                if (objProductOld.Param1_Nom === "" ||
                    objProductOld.Param1_Nom == this.strNullValue ||
                    objProductOld.Param1_Nom == undefined) {
                    objProductOld.Param1_Nom = null;
                }

                if (objProductNew.Param1_Nom === "" ||
                    objProductNew.Param1_Nom == this.strNullValue ||
                    objProductNew.Param1_Nom == undefined) {
                    objProductNew.Param1_Nom = null;
                }

                if ((objProductOld.Param1_Nom !== null) && (objProductNew.Param1_Nom !== null)) {
                    if ((objProductOld.Param1_Nom) == (objProductNew.Param1_Nom)) {
                        objIndividual.Individual['Target'].oldValue = false;
                        objIndividual.Individual['Target'].newValue = false;
                        IsChanged != true ? IsChanged = false : IsChanged = true;
                    }
                    else {
                        objIndividual.Individual['Target'].oldValue = (objProductOld.Param1_Nom);
                        objIndividual.Individual['Target'].newValue = objProductNew.Param1_Nom;
                        IsChanged = true;
                    }

                } else {

                    if ((objProductOld.Param1_Nom === null) && (objProductNew.Param1_Nom !== null)) {
                        objIndividual.Individual['Target'].oldValue = "NA";
                        objIndividual.Individual['Target'].newValue = objProductNew.Param1_Nom;
                        IsChanged = true;

                    } else if ((objProductOld.Param1_Nom !== null) && (objProductNew.Param1_Nom === null)) {
                        objIndividual.Individual['Target'].oldValue = (objProductOld.Param1_Nom);
                        objIndividual.Individual['Target'].newValue = "NA";
                        IsChanged = true;
                    }
                }
            }

            /**
             * For Individual T2Pos
             */
            if (OldEmpty) {
                if (objProductNew.Param1_T2Pos != "" && objProductNew.Param1_T2Pos!=undefined && objProductNew.Param1_T2Pos != 99999) {
                    objIndividual.Individual['Upper Limit'].oldValue = "NA";
                    objIndividual.Individual['Upper Limit'].newValue = objProductNew.Param1_T2Pos;
                    IsChanged = true;
                }
                else {
                    objIndividual.Individual['Upper Limit'].oldValue = false;
                    objIndividual.Individual['Upper Limit'].newValue = false;
                    IsChanged = IsChanged != true ? false : true;
                }
            }
            else {
                if (objProductOld.Param1_T2Pos === "" ||
                    objProductOld.Param1_T2Pos == this.strNullValue ||
                    objProductOld.Param1_T2Pos == undefined) {
                    objProductOld.Param1_T2Pos = null;
                }

                if (objProductNew.Param1_T2Pos === "" ||
                    objProductNew.Param1_T2Pos == this.strNullValue ||
                    objProductNew.Param1_T2Pos == undefined) {
                    objProductNew.Param1_T2Pos = null;
                }

                if ((objProductOld.Param1_T2Pos !== null) && (objProductNew.Param1_T2Pos !== null)) {
                    if ((objProductOld.Param1_T2Pos) == (objProductNew.Param1_T2Pos)) {
                        objIndividual.Individual['Upper Limit'].oldValue = false;
                        objIndividual.Individual['Upper Limit'].newValue = false;
                        IsChanged != true ? IsChanged = false : IsChanged = true;
                    }
                    else {
                        objIndividual.Individual['Upper Limit'].oldValue = (objProductOld.Param1_T2Pos);
                        objIndividual.Individual['Upper Limit'].newValue = objProductNew.Param1_T2Pos;
                        IsChanged = true;
                    }

                } else {

                    if ((objProductOld.Param1_T2Pos === null) && (objProductNew.Param1_T2Pos !== null)) {
                        objIndividual.Individual['Upper Limit'].oldValue = "NA";
                        objIndividual.Individual['Upper Limit'].newValue = objProductNew.Param1_T2Pos;
                        IsChanged = true;

                    } else if ((objProductOld.Param1_T2Pos !== null) && (objProductNew.Param1_T2Pos === null)) {
                        objIndividual.Individual['Upper Limit'].oldValue = (objProductOld.Param1_T2Pos);
                        objIndividual.Individual['Upper Limit'].newValue = "NA";
                        IsChanged = true;
                    }
                }
            }

            /**
             * For Individual Unit
             */
            if (OldEmpty) {
                if (objProductNew.Param1_Unit != "" && objProductNew.Param1_T2Neg != "" && objProductNew.Param1_Unit!=undefined && objProductNew.Param1_T2Neg!=undefined) {
                    objIndividual.Individual.Unit.oldValue = "NA";
                    objIndividual.Individual.Unit.newValue = objProductNew.Param1_Unit;
                    IsChanged = true;
                }
                else {
                    objIndividual.Individual.Unit.oldValue = false;
                    objIndividual.Individual.Unit.newValue = false;
                    IsChanged = IsChanged != true ? false : true;
                }
            }
            else {
                objProductOld.Param1_Unit == "NA" ? objProductOld.Param1_Unit = "gm" : objProductOld.Param1_Unit;
                if (objProductOld.Param1_T2Neg == null && objProductNew.Param1_T2Neg != null) { // new parameter added
                    objIndividual.Individual.Unit.oldValue = "gm";
                    objIndividual.Individual.Unit.newValue = objProductNew.Param1_Unit;
                    IsChanged = true;
                }
                else if (['NULL',null].includes(objProductOld.Param1_Unit) && objProductNew.Param1_Unit == null) // no parameter added
                {
                    objIndividual.Individual.Unit.oldValue = false;
                    objIndividual.Individual.Unit.newValue = false;
                    IsChanged = false;
                }
                else {
                    if (objProductOld.Param1_Unit == objProductNew.Param1_Unit) {
                        objIndividual.Individual.Unit.oldValue = false;
                        objIndividual.Individual.Unit.newValue = false;
                        IsChanged != true ? IsChanged = false : IsChanged = true;
                    }
                    else {
                        objIndividual.Individual.Unit.oldValue = objProductOld.Param1_Unit;
                        objIndividual.Individual.Unit.newValue = objProductNew.Param1_Unit;
                        IsChanged = true;
                    }
                }
            }


            if (IsChanged == true) {
                Object.assign(this.objResult, objIndividual);
            }
            resolve(IsChanged);
        });
    }

    validateGroupMES(objProductOld, objProductNew) {
        return new Promise((resolve, reject) => {
            const objGroup = {
                Group: {
                    'Target': { oldValue: "", newValue: "" },
                    'Lower Limit': { oldValue: "", newValue: "" },
                    'Upper Limit': { oldValue: "", newValue: "" },
                    Unit: { oldValue: "", newValue: "" },
                    // "Quantity (Initial)":{ oldValue: "", newValue: "" },
                    // "Quantity (Regular)":{ oldValue: "", newValue: "" }
                }
            };

            var IsChanged = false;
            var OldEmpty = objProductOld == undefined ? true : false;

            /**
             * For Group NegT2
             */
            if (OldEmpty) {
                if (objProductNew.Param2_T2Neg != "" && objProductNew.Param2_T2Neg!=undefined && objProductNew.Param1_T2Neg != 99999) {
                    objGroup.Group['Lower Limit'].oldValue = "NA";
                    objGroup.Group['Lower Limit'].newValue = objProductNew.Param2_T2Neg;
                    IsChanged = true;
                }
                else {
                    objGroup.Group['Lower Limit'].oldValue = false;
                    objGroup.Group['Lower Limit'].newValue = false;
                    IsChanged = IsChanged != true ? false : true;
                }
            }
            else {
                if (objProductOld.Param2_T2Neg === "" ||
                    objProductOld.Param2_T2Neg == this.strNullValue ||
                    objProductOld.Param2_T2Neg == undefined) {
                    objProductOld.Param2_T2Neg = null;
                }

                objProductNew.Param2_T2Neg = objProductNew.Param2_T2Neg === "" ? this.strNullValue : objProductNew.Param2_T2Neg;
                
                if (objProductNew.Param2_T2Neg === "" ||
                    objProductNew.Param2_T2Neg == this.strNullValue ||
                    objProductNew.Param2_T2Neg == undefined) {
                    objProductNew.Param2_T2Neg = null;
                }

                if ((objProductOld.Param2_T2Neg !== null) && (objProductNew.Param2_T2Neg !== null)) {
                    if (objProductOld.Param2_T2Neg == objProductNew.Param2_T2Neg) {
                        objGroup.Group['Lower Limit'].oldValue = false;
                        objGroup.Group['Lower Limit'].newValue = false;
                        IsChanged != true ? IsChanged = false : IsChanged = true;
                    }
                    else {
                        objGroup.Group['Lower Limit'].oldValue = objProductOld.Param2_T2Neg;
                        objGroup.Group['Lower Limit'].newValue = objProductNew.Param2_T2Neg;
                        IsChanged = true;
                    }

                } else {

                    if ((objProductOld.Param2_T2Neg === null) && (objProductNew.Param2_T2Neg !== null)) {
                        objGroup.Group['Lower Limit'].oldValue = "NA";
                        objGroup.Group['Lower Limit'].newValue = objProductNew.Param2_T2Neg;
                        IsChanged = true;

                    } else if ((objProductOld.Param2_T2Neg !== null) && (objProductNew.Param2_T2Neg === null)) {
                        objGroup.Group['Lower Limit'].oldValue = objProductOld.Param2_T2Neg;
                        objGroup.Group['Lower Limit'].newValue = "NA";
                        IsChanged = true;
                    }
                }
            }

            /**
             * For Group PosT2
             */
            if (OldEmpty) {
                if (objProductNew.Param2_T2Pos != "" && objProductNew.Param2_T2Pos!=undefined) {
                    objGroup.Group['Upper Limit'].oldValue = "NA";
                    objGroup.Group['Upper Limit'].newValue = objProductNew.Param2_T2Pos;
                    IsChanged = true;
                }
                else {
                    objGroup.Group['Upper Limit'].oldValue = false;
                    objGroup.Group['Upper Limit'].newValue = false;
                    IsChanged = IsChanged != true ? false : true;
                }
            }
            else {
                if (objProductOld.Param2_T2Pos === "" ||
                    objProductOld.Param2_T2Pos == this.strNullValue ||
                    objProductOld.Param2_T2Pos == undefined) {
                    objProductOld.Param2_T2Pos = null;
                }

                objProductNew.Param2_T2Pos = objProductNew.Param2_T2Pos === "" ? this.strNullValue : objProductNew.Param2_T2Pos;
                
                if (objProductNew.Param2_T2Pos === "" ||
                    objProductNew.Param2_T2Pos == this.strNullValue ||
                    objProductNew.Param2_T2Pos == undefined) {
                    objProductNew.Param2_T2Pos = null;
                }

                if ((objProductOld.Param2_T2Pos !== null) && (objProductNew.Param2_T2Pos !== null)) {
                    if (objProductOld.Param2_T2Pos == objProductNew.Param2_T2Pos) {
                        objGroup.Group['Upper Limit'].oldValue = false;
                        objGroup.Group['Upper Limit'].newValue = false;
                        IsChanged != true ? IsChanged = false : IsChanged = true;
                    }
                    else {
                        objGroup.Group['Upper Limit'].oldValue = objProductOld.Param2_T2Pos;
                        objGroup.Group['Upper Limit'].newValue = objProductNew.Param2_T2Pos;
                        IsChanged = true;
                    }

                } else {

                    if ((objProductOld.Param2_T2Pos === null) && (objProductNew.Param2_T2Pos !== null)) {
                        objGroup.Group['Upper Limit'].oldValue = "NA";
                        objGroup.Group['Upper Limit'].newValue = objProductNew.Param2_T2Pos;
                        IsChanged = true;

                    } else if ((objProductOld.Param2_T2Pos !== null) && (objProductNew.Param2_T2Pos === null)) {
                        objGroup.Group['Upper Limit'].oldValue = objProductOld.Param2_T2Pos;
                        objGroup.Group['Upper Limit'].newValue = "NA";
                        IsChanged = true;
                    }
                }
            }

            /* For Group Nom*/
            if (OldEmpty) {
                if (objProductNew.Param2_Nom != "" && objProductNew.Param2_Nom != undefined) {
                    objGroup.Group['Target'].oldValue = "NA";
                    objGroup.Group['Target'].newValue = objProductNew.Param2_Nom;
                    IsChanged = true;
                }
                else {
                    objGroup.Group['Target'].oldValue = false;
                    objGroup.Group['Target'].newValue = false;
                    IsChanged = IsChanged != true ? false : true;
                }
            }
            else {
                if (objProductOld.Param2_Nom === "" ||
                    objProductOld.Param2_Nom == this.strNullValue ||
                    objProductOld.Param2_Nom == undefined) {
                    objProductOld.Param2_Nom = null;
                }

                objProductNew.Param2_Nom = objProductNew.Param2_Nom === "" ? this.strNullValue : objProductNew.Param2_Nom;

                if (objProductNew.Param2_Nom === "" ||
                    objProductNew.Param2_Nom == this.strNullValue ||
                    objProductNew.Param2_Nom == undefined) {
                    objProductNew.Param2_Nom = null;
                }

                if ((objProductOld.Param2_Nom !== null) && (objProductNew.Param2_Nom !== null)) {
                    if (objProductOld.Param2_Nom == objProductNew.Param2_Nom) {
                        objGroup.Group['Target'].oldValue = false;
                        objGroup.Group['Target'].newValue = false;
                        IsChanged != true ? IsChanged = false : IsChanged = true;
                    }
                    else {
                        objGroup.Group['Target'].oldValue = objProductOld.Param2_Nom;
                        objGroup.Group['Target'].newValue = objProductNew.Param2_Nom;
                        IsChanged = true;
                    }

                } else {

                    if ((objProductOld.Param2_Nom === null) && (objProductNew.Param2_Nom !== null)) {
                        objGroup.Group['Target'].oldValue = "NA";
                        objGroup.Group['Target'].newValue = objProductNew.Param2_Nom;
                        IsChanged = true;

                    } else if ((objProductOld.Param2_Nom !== null) && (objProductNew.Param2_Nom === null)) {
                        objGroup.Group['Target'].oldValue = objProductOld.Param2_Nom;
                        objGroup.Group['Target'].newValue = "NA";
                        IsChanged = true;
                    }
                }
            }
            
            if (OldEmpty) {
                if (objProductNew.Param2_Unit != "" && objProductNew.Param2_T2Neg != "" && objProductNew.Param2_Unit!=undefined && objProductNew.Param2_T2Neg!=undefined) {
                    objGroup.Group.Unit.oldValue = "NA";
                    objGroup.Group.Unit.newValue = objProductNew.Param2_Unit;
                    IsChanged = true;
                }
                else {
                    objGroup.Group.Unit.oldValue = false;
                    objGroup.Group.Unit.newValue = false;
                    IsChanged = IsChanged != true ? false : true;
                }
            }
            else {
                const strGraphOn = objProductOld.Param2_Unit == 0 ? "gm" : objProductOld.Param2_Unit;
                if (objProductOld.Param2_Nom == null && objProductNew.Param2_T2Neg != null) { // new parameter added
                    objGroup.Group.Unit.oldValue = "NA";
                    objGroup.Group.Unit.newValue = objProductNew.Param2_Unit;
                    IsChanged = true;
                }
                else if (['NULL',null].includes(objProductOld.Param2_Unit) && objProductNew.Param2_Unit == null) // no parameter added
                {
                    objGroup.Group.Unit.oldValue = false;
                    objGroup.Group.Unit.newValue = false;
                    IsChanged = false;
                }
                else {
                    if (strGraphOn == objProductNew.Param2_Unit) {
                        objGroup.Group.Unit.oldValue = false;
                        objGroup.Group.Unit.newValue = false;
                        IsChanged != true ? IsChanged = false : IsChanged = true;
                    }
                    else {
                        objGroup.Group.Unit.oldValue = strGraphOn;
                        objGroup.Group.Unit.newValue = objProductNew.Param2_Unit;
                        IsChanged = true;
                    }
                }
            }

            if (IsChanged == true) {
                Object.assign(this.objResult, objGroup);
            }
            resolve(IsChanged);
        });
    }

    validateThicknessMES(objProductOld, objProductNew) {
        return new Promise((resolve, reject) => {
            const objThickness = {
                Thickness: {
                    'Target': { oldValue: "", newValue: "" },
                    'Lower Limit': { oldValue: "", newValue: "" },
                    'Upper Limit': { oldValue: "", newValue: "" },
                    Unit:{ oldValue: "", newValue: "" },
                    // "Quantity (Initial)":{ oldValue: "", newValue: "" },
                    // "Quantity (Regular)":{ oldValue: "", newValue: "" }
                }
            };

            var IsChanged = false;
            var OldEmpty = objProductOld == undefined ? true : false;

            /**
             * For Thickness Nom
             */
            if (OldEmpty == true) {
                if (objProductNew.Param3_Nom != "" && objProductNew.Param3_Nom != undefined) {
                    objThickness.Thickness['Target'].oldValue = "NA";
                    objThickness.Thickness['Target'].newValue = objProductNew.Param3_Nom;
                    IsChanged = true;
                }
                else {
                    objThickness.Thickness['Target'].oldValue = false;
                    objThickness.Thickness['Target'].newValue = false;
                    IsChanged = false;
                }
            }
            else {
                if (objProductOld.Param3_Nom === "" ||
                    objProductOld.Param3_Nom == this.strNullValue ||
                    objProductOld.Param3_Nom == undefined) {
                    objProductOld.Param3_Nom = null;
                }

                if (objProductNew.Param3_Nom === "" ||
                    objProductNew.Param3_Nom == this.strNullValue ||
                    objProductNew.Param3_Nom == undefined) {
                    objProductNew.Param3_Nom = null;
                }

                if ((objProductOld.Param3_Nom !== null) && (objProductNew.Param3_Nom !== null)) {
                    if (objProductOld.Param3_Nom == objProductNew.Param3_Nom) {
                        objThickness.Thickness['Target'].oldValue = false;
                        objThickness.Thickness['Target'].newValue = false;
                        IsChanged != true ? IsChanged = false : IsChanged = true;
                    }
                    else {
                        objThickness.Thickness['Target'].oldValue = objProductOld.Param3_Nom;
                        objThickness.Thickness['Target'].newValue = objProductNew.Param3_Nom;
                        IsChanged = true;
                    }

                } else {

                    if ((objProductOld.Param3_Nom === null) && (objProductNew.Param3_Nom !== null)) {
                        objThickness.Thickness['Target'].oldValue = "NA";
                        objThickness.Thickness['Target'].newValue = objProductNew.Param3_Nom;
                        IsChanged = true;

                    } else if ((objProductOld.Param3_Nom !== null) && (objProductNew.Param3_Nom === null)) {
                        objThickness.Thickness['Target'].oldValue = objProductOld.Param3_Nom;
                        objThickness.Thickness['Target'].newValue = "NA";
                        IsChanged = true;
                    }
                }
            }


                        /**
             * For Thickness PosT2
             */
            if (OldEmpty == true) {
                if (objProductNew.Param3_T2Pos != "" && objProductNew.Param3_T2Pos != undefined) {
                    objThickness.Thickness['Upper Limit'].oldValue = "NA";
                    objThickness.Thickness['Upper Limit'].newValue = objProductNew.Param3_T2Pos;
                    IsChanged = true;
                }
                else {
                    objThickness.Thickness['Upper Limit'].oldValue = false;
                    objThickness.Thickness['Upper Limit'].newValue = false;
                    IsChanged = false;
                }
            }
            else {
                if (objProductOld.Param3_T2Pos === "" ||
                    objProductOld.Param3_T2Pos == this.strNullValue ||
                    objProductOld.Param3_T2Pos == undefined) {
                    objProductOld.Param3_T2Pos = null;
                }

                if (objProductNew.Param3_T2Pos === "" ||
                    objProductNew.Param3_T2Pos == this.strNullValue ||
                    objProductNew.Param3_T2Pos == undefined) {
                    objProductNew.Param3_T2Pos = null;
                }

                if ((objProductOld.Param3_T2Pos !== null) && (objProductNew.Param3_T2Pos !== null)) {
                    if ((objProductOld.Param3_T2Pos) == (objProductNew.Param3_T2Pos)) {
                        objThickness.Thickness['Upper Limit'].oldValue = false;
                        objThickness.Thickness['Upper Limit'].newValue = false;
                        IsChanged != true ? IsChanged = false : IsChanged = true;
                    }
                    else {
                        objThickness.Thickness['Upper Limit'].oldValue = (objProductOld.Param3_T2Pos);
                        objThickness.Thickness['Upper Limit'].newValue = (objProductNew.Param3_T2Pos);
                        IsChanged = true;
                    }

                } else {

                    if ((objProductOld.Param3_T2Pos === null) && (objProductNew.Param3_T2Pos !== null)) {
                        objThickness.Thickness['Upper Limit'].oldValue = "NA";
                        objThickness.Thickness['Upper Limit'].newValue = (objProductNew.Param3_T2Pos);
                        IsChanged = true;

                    } else if ((objProductOld.Param3_T2Pos !== null) && (objProductNew.Param3_T2Pos === null)) {
                        objThickness.Thickness['Upper Limit'].oldValue = (objProductOld.Param3_T2Pos);
                        objThickness.Thickness['Upper Limit'].newValue = "NA";
                        IsChanged = true;
                    }
                }
            }

            /**
             * For Thickness NegT2
             */
            if (OldEmpty == true) {
                if (objProductNew.Param3_T2Neg != "" && objProductNew.Param3_T2Neg != undefined) {
                    objThickness.Thickness['Lower Limit'].oldValue = "NA";
                    objThickness.Thickness['Lower Limit'].newValue = objProductNew.Param3_T2Neg;
                    IsChanged = true;
                }
                else {
                    objThickness.Thickness['Lower Limit'].oldValue = false;
                    objThickness.Thickness['Lower Limit'].newValue = false;
                    IsChanged = false;
                }
            }
            else {
                if (objProductOld.Param3_T2Neg === "" ||
                    objProductOld.Param3_T2Neg == this.strNullValue ||
                    objProductOld.Param3_T2Neg == undefined) {
                    objProductOld.Param3_T2Neg = null;
                }

                if (objProductNew.Param3_T2Neg === "" ||
                    objProductNew.Param3_T2Neg == this.strNullValue ||
                    objProductNew.Param3_T2Neg == undefined) {
                    objProductNew.Param3_T2Neg = null;
                }

                if ((objProductOld.Param3_T2Neg !== null) && (objProductNew.Param3_T2Neg !== null)) {
                    if ((objProductOld.Param3_T2Neg) == (objProductNew.Param3_T2Neg)) {
                        objThickness.Thickness['Lower Limit'].oldValue = false;
                        objThickness.Thickness['Lower Limit'].newValue = false;
                        IsChanged != true ? IsChanged = false : IsChanged = true;
                    }
                    else {
                        objThickness.Thickness['Lower Limit'].oldValue = (objProductOld.Param3_T2Neg);
                        objThickness.Thickness['Lower Limit'].newValue = (objProductNew.Param3_T2Neg);
                        IsChanged = true;
                    }

                } else {

                    if ((objProductOld.Param3_T2Neg === null) && (objProductNew.Param3_T2Neg !== null)) {
                        objThickness.Thickness['Lower Limit'].oldValue = "NA";
                        objThickness.Thickness['Lower Limit'].newValue = (objProductNew.Param3_T2Neg);
                        IsChanged = true;

                    } else if ((objProductOld.Param3_T2Neg !== null) && (objProductNew.Param3_T2Neg === null)) {
                        objThickness.Thickness['Lower Limit'].oldValue = (objProductOld.Param3_T2Neg);
                        objThickness.Thickness['Lower Limit'].newValue = "NA";
                        IsChanged = true;
                    }
                }
            }
            
            /**
             * For Thickness PosT2
             */
            if (OldEmpty == true) {
                if (objProductNew.Param3_T2Pos != "" && objProductNew.Param3_T2Pos != undefined) {
                    objThickness.Thickness['Upper Limit'].oldValue = "NA";
                    objThickness.Thickness['Upper Limit'].newValue = objProductNew.Param3_T2Pos;
                    IsChanged = true;
                }
                else {
                    objThickness.Thickness['Upper Limit'].oldValue = false;
                    objThickness.Thickness['Upper Limit'].newValue = false;
                    IsChanged = false;
                }
            }
            else {
                if (objProductOld.Param3_T2Pos === "" ||
                    objProductOld.Param3_T2Pos == this.strNullValue ||
                    objProductOld.Param3_T2Pos == undefined) {
                    objProductOld.Param3_T2Pos = null;
                }

                if (objProductNew.Param3_T2Pos === "" ||
                    objProductNew.Param3_T2Pos == this.strNullValue ||
                    objProductNew.Param3_T2Pos == undefined) {
                    objProductNew.Param3_T2Pos = null;
                }

                if ((objProductOld.Param3_T2Pos !== null) && (objProductNew.Param3_T2Pos !== null)) {
                    if ((objProductOld.Param3_T2Pos) == (objProductNew.Param3_T2Pos)) {
                        objThickness.Thickness['Upper Limit'].oldValue = false;
                        objThickness.Thickness['Upper Limit'].newValue = false;
                        IsChanged != true ? IsChanged = false : IsChanged = true;
                    }
                    else {
                        objThickness.Thickness['Upper Limit'].oldValue = (objProductOld.Param3_T2Pos);
                        objThickness.Thickness['Upper Limit'].newValue = (objProductNew.Param3_T2Pos);
                        IsChanged = true;
                    }

                } else {

                    if ((objProductOld.Param3_T2Pos === null) && (objProductNew.Param3_T2Pos !== null)) {
                        objThickness.Thickness['Upper Limit'].oldValue = "NA";
                        objThickness.Thickness['Upper Limit'].newValue = (objProductNew.Param3_T2Pos);
                        IsChanged = true;

                    } else if ((objProductOld.Param3_T2Pos !== null) && (objProductNew.Param3_T2Pos === null)) {
                        objThickness.Thickness['Upper Limit'].oldValue = (objProductOld.Param3_T2Pos);
                        objThickness.Thickness['Upper Limit'].newValue = "NA";
                        IsChanged = true;
                    }
                }
            }

            
            if (OldEmpty) {
                if (objProductNew.Param3_Unit != "" && objProductNew.Param3_T2Neg != "" && objProductNew.Param3_Unit != undefined && objProductNew.Param3_T2Neg != undefined) {
                    objThickness.Thickness.Unit.oldValue = "NA";
                    objThickness.Thickness.Unit.newValue = objProductNew.Param3_Unit;
                    IsChanged = true;
                }
                else {
                    objThickness.Thickness.Unit.oldValue = false;
                    objThickness.Thickness.Unit.newValue = false;
                    IsChanged = IsChanged != true ? false : true;
                }
            }
            else {
                objProductOld.Param3_Unit == "NA" ? objProductOld.Param3_Unit = "mm" : objProductOld.Param3_Unit;
                if (objProductOld.Param3_T2Neg == null && objProductNew.Param3_T2Neg != null) { // new parameter added
                    objThickness.Thickness.Unit.oldValue = "mm";
                    objThickness.Thickness.Unit.newValue = objProductNew.Param3_Unit;
                    IsChanged = true;
                }
                else if (['NULL',null].includes(objProductOld.Param3_Unit) && objProductNew.Param3_Unit == null) // no parameter added
                {
                    objThickness.Thickness.Unit.oldValue = false;
                    objThickness.Thickness.Unit.newValue = false;
                    IsChanged = false;
                }
                else {
                    if (objProductOld.Param3_Unit == objProductNew.Param3_Unit) {
                        objThickness.Thickness.Unit.oldValue = false;
                        objThickness.Thickness.Unit.newValue = false;
                        IsChanged != true ? IsChanged = false : IsChanged = true;
                    }
                    else {
                        objThickness.Thickness.Unit.oldValue = objProductOld.Param3_Unit;
                        objThickness.Thickness.Unit.newValue = objProductNew.Param3_Unit;
                        IsChanged = true;
                    }
                }
            }


            if (IsChanged == true) {
                Object.assign(this.objResult, objThickness);
            }
            resolve(IsChanged);
        });
    }

    validateBreadthMES(objProductOld, objProductNew) {
        return new Promise((resolve, reject) => {
            const objBreadth = {
                Breadth: {
                    'Lower Limit': { oldValue: "", newValue: "" },
                    'Upper Limit': { oldValue: "", newValue: "" },
                    Unit:{ oldValue: "", newValue: "" },
                    "Quantity (Initial)":{ oldValue: "", newValue: "" },
                    "Quantity (Regular)":{ oldValue: "", newValue: "" }
                }
            };

            var IsChanged = false;
            var OldEmpty = objProductOld == undefined ? true : false;
            
            /**
             * For Breath NegT2
             */
            if (OldEmpty == true) {
                if (objProductNew.Param4_T2Neg != "" && objProductNew.Param4_T2Neg != undefined) {
                    objBreadth.Breadth['Lower Limit'].oldValue = "NA";
                    objBreadth.Breadth['Lower Limit'].newValue = objProductNew.Param4_T2Neg;
                    IsChanged = true;
                }
                else {
                    objBreadth.Breadth['Lower Limit'].oldValue = false;
                    objBreadth.Breadth['Lower Limit'].newValue = false;
                    IsChanged = false;
                }
            }
            else {
                if (objProductOld.Param4_T2Neg === "" ||
                    objProductOld.Param4_T2Neg == this.strNullValue ||
                    objProductOld.Param4_T2Neg == undefined) {
                    objProductOld.Param4_T2Neg = null;
                }

                if (objProductNew.Param4_T2Neg === "" ||
                    objProductNew.Param4_T2Neg == this.strNullValue ||
                    objProductNew.Param4_T2Neg == undefined) {
                    objProductNew.Param4_T2Neg = null;
                }

                if ((objProductOld.Param4_T2Neg !== null) && (objProductNew.Param4_T2Neg !== null)) {
                    if (parseFloat(objProductOld.Param4_T2Neg).toFixed(objProductOld.Param4_DP) == parseFloat(objProductNew.Param4_T2Neg).toFixed(objProductNew.Param4_DP)) {
                        objBreadth.Breadth['Lower Limit'].oldValue = false;
                        objBreadth.Breadth['Lower Limit'].newValue = false;
                        IsChanged != true ? IsChanged = false : IsChanged = true;
                    }
                    else {
                        objBreadth.Breadth['Lower Limit'].oldValue = parseFloat(objProductOld.Param4_T2Neg).toFixed(objProductOld.Param4_DP);
                        objBreadth.Breadth['Lower Limit'].newValue = parseFloat(objProductNew.Param4_T2Neg).toFixed(objProductNew.Param4_DP);
                        IsChanged = true;
                    }

                } else {

                    if ((objProductOld.Param4_T2Neg === null) && (objProductNew.Param4_T2Neg !== null)) {
                        objBreadth.Breadth['Lower Limit'].oldValue = "NA";
                        objBreadth.Breadth['Lower Limit'].newValue = parseFloat(objProductNew.Param4_T2Neg).toFixed(objProductNew.Param4_DP);
                        IsChanged = true;

                    } else if ((objProductOld.Param4_T1Neg !== null) && (objProductNew.Param4_T2Neg === null)) {
                        objBreadth.Breadth['Lower Limit'].oldValue = parseFloat(objProductOld.Param4_T2Neg).toFixed(objProductOld.Param4_DP);
                        objBreadth.Breadth['Lower Limit'].newValue = "NA";
                        IsChanged = true;
                    }
                }
            }

            /*
             * For Breath PosT2
             */
            if (OldEmpty == true) {
                if (objProductNew.Param4_T2Pos != "" && objProductNew.Param4_T2Pos != undefined) {
                    objBreadth.Breadth['Upper Limit'].oldValue = "NA";
                    objBreadth.Breadth['Upper Limit'].newValue = objProductNew.Param4_T2Pos;
                    IsChanged = true;
                }
                else {
                    objBreadth.Breadth['Upper Limit'].oldValue = false;
                    objBreadth.Breadth['Upper Limit'].newValue = false;
                    IsChanged = false;
                }
            }
            else {
                if (objProductOld.Param4_T2Pos === "" ||
                    objProductOld.Param4_T2Pos == this.strNullValue ||
                    objProductOld.Param4_T2Pos == undefined) {
                    objProductOld.Param4_T2Pos = null;
                }

                if (objProductNew.Param4_T2Pos === "" ||
                    objProductNew.Param4_T2Pos == this.strNullValue ||
                    objProductNew.Param4_T2Pos == undefined) {
                    objProductNew.Param4_T2Pos = null;
                }

                if ((objProductOld.Param4_T2Pos !== null) && (objProductNew.Param4_T2Pos !== null)) {
                    if (parseFloat(objProductOld.Param4_T2Pos).toFixed(objProductOld.Param4_DP) == parseFloat(objProductNew.Param4_T2Pos).toFixed(objProductNew.Param4_DP)) {
                        objBreadth.Breadth['Upper Limit'].oldValue = false;
                        objBreadth.Breadth['Upper Limit'].newValue = false;
                        IsChanged != true ? IsChanged = false : IsChanged = true;
                    }
                    else {
                        objBreadth.Breadth['Upper Limit'].oldValue = parseFloat(objProductOld.Param4_T2Pos).toFixed(objProductOld.Param4_DP);
                        objBreadth.Breadth['Upper Limit'].newValue = parseFloat(objProductNew.Param4_T2Pos).toFixed(objProductNew.Param4_DP);
                        IsChanged = true;
                    }

                } else {

                    if ((objProductOld.Param4_T2Pos === null) && (objProductNew.Param4_T2Pos !== null)) {
                        objBreadth.Breadth['Upper Limit'].oldValue = "NA";
                        objBreadth.Breadth['Upper Limit'].newValue = parseFloat(objProductNew.Param4_T2Pos).toFixed(objProductNew.Param4_DP);
                        IsChanged = true;

                    } else if ((objProductOld.Param4_T2Pos !== null) && (objProductNew.Param4_T2Pos === null)) {
                        objBreadth.Breadth['Upper Limit'].oldValue = parseFloat(objProductOld.Param4_T2Pos).toFixed(objProductOld.Param4_DP);
                        objBreadth.Breadth['Upper Limit'].newValue = "NA";
                        IsChanged = true;
                    }
                }
            }

            /**
             * For Breadth Initial Quantity
            if (OldEmpty) {
                if (objProductNew.int_BrdQtyInitial != "" && objProductNew.int_BrdQtyInitial!=undefined) {
                    objBreadth.Breadth['Quantity (Initial)'].oldValue = "NA";
                    objBreadth.Breadth['Quantity (Initial)'].newValue = Number(objProductNew.int_BrdQtyInitial);
                    IsChanged = true;
                }
                else {
                    objBreadth.Breadth['Quantity (Initial)'].oldValue = false;
                    objBreadth.Breadth['Quantity (Initial)'].newValue = false;
                    IsChanged = IsChanged != true ? false : true;
                }
            }
            else {
                if (objProductOld.Param4_IniQty === "" ||
                    objProductOld.Param4_IniQty == this.strNullValue ||
                    objProductOld.Param4_IniQty == undefined) {
                    objProductOld.Param4_IniQty = null;
                }

                if (objProductNew.int_BrdQtyInitial === "" || objProductNew.int_BrdQtyInitial == this.strNullValue || objProductNew.int_BrdQtyInitial == undefined) {
                    objProductNew.int_BrdQtyInitial = null;
                }

                if ((objProductOld.Param4_IniQty !== null) && (objProductNew.int_BrdQtyInitial !== null)) {
                    if (Number(objProductOld.Param4_IniQty) == Number(objProductNew.int_BrdQtyInitial)) {
                        objBreadth.Breadth['Quantity (Initial)'].oldValue = false;
                        objBreadth.Breadth['Quantity (Initial)'].newValue = false;
                        IsChanged != true ? IsChanged = false : IsChanged = true;
                    }
                    else {
                        objBreadth.Breadth['Quantity (Initial)'].oldValue = objProductOld.Param4_IniQty;
                        objBreadth.Breadth['Quantity (Initial)'].newValue = Number(objProductNew.int_BrdQtyInitial);
                        IsChanged = true;
                    }

                } else {

                    if ((objProductOld.Param4_IniQty === null) && (objProductNew.int_BrdQtyInitial !== null)) {
                        objBreadth.Breadth['Quantity (Initial)'].oldValue = "NA";
                        objBreadth.Breadth['Quantity (Initial)'].newValue = Number(objProductNew.int_BrdQtyInitial);
                        IsChanged = true;

                    } else if ((objProductOld.Param4_IniQty !== null) && (objProductNew.int_BrdQtyInitial === null)) {
                        objBreadth.Breadth['Quantity (Initial)'].oldValue = objProductOld.Param4_IniQty;
                        objBreadth.Breadth['Quantity (Initial)'].newValue = "NA";
                        IsChanged = true;
                    }
                }
            }
             */
            
            /**
             * For Breadth Quantity Regular
            if (OldEmpty) {
                if (objProductNew.int_BrdQtyRegular != "" && objProductNew.int_BrdQtyRegular!=undefined) {
                    objBreadth.Breadth['Quantity (Regular)'].oldValue = "NA";
                    objBreadth.Breadth['Quantity (Regular)'].newValue = Number(objProductNew.int_BrdQtyRegular);
                    IsChanged = true;
                }
                else {
                    objBreadth.Breadth['Quantity (Regular)'].oldValue = false;
                    objBreadth.Breadth['Quantity (Regular)'].newValue = false;
                    IsChanged = IsChanged != true ? false : true;
                }
            }
            else {
                if (objProductOld.Param4_RegQty === "" ||
                    objProductOld.Param4_RegQty == this.strNullValue ||
                    objProductOld.Param4_RegQty == undefined) {
                    objProductOld.Param4_RegQty = null;
                }

                if (objProductNew.int_BrdQtyRegular === "" || objProductNew.int_BrdQtyRegular == this.strNullValue || objProductNew.int_BrdQtyRegular == undefined) {
                    objProductNew.int_BrdQtyRegular = null;
                }

                if ((objProductOld.Param4_RegQty !== null) && (objProductNew.int_BrdQtyRegular !== null)) {
                    if (Number(objProductOld.Param4_RegQty)== Number(objProductNew.int_BrdQtyRegular)) {
                        objBreadth.Breadth['Quantity (Regular)'].oldValue = false;
                        objBreadth.Breadth['Quantity (Regular)'].newValue = false;
                        IsChanged != true ? IsChanged = false : IsChanged = true;
                    }
                    else {
                        objBreadth.Breadth['Quantity (Regular)'].oldValue = objProductOld.Param4_RegQty;
                        objBreadth.Breadth['Quantity (Regular)'].newValue = Number(objProductNew.int_BrdQtyRegular);
                        IsChanged = true;
                    }

                } else {

                    if ((objProductOld.Param4_RegQty === null) && (objProductNew.int_BrdQtyRegular !== null)) {
                        objBreadth.Breadth['Quantity (Regular)'].oldValue = "NA";
                        objBreadth.Breadth['Quantity (Regular)'].newValue = Number(objProductNew.int_BrdQtyRegular);
                        IsChanged = true;

                    } else if ((objProductOld.Param4_RegQty !== null) && (objProductNew.int_BrdQtyRegular === null)) {
                        objBreadth.Breadth['Quantity (Regular)'].oldValue = objProductOld.Param4_RegQty;
                        objBreadth.Breadth['Quantity (Regular)'].newValue = "NA";
                        IsChanged = true;
                    }
                }
            }
             */

            if (OldEmpty) {
                if (objProductNew.Param4_Unit != "" && objProductNew.Param4_T2Neg != "" && objProductNew.Param4_Unit != undefined && objProductNew.Param4_T2Neg != undefined) {
                    objBreadth.Breadth.Unit.oldValue = "NA";
                    objBreadth.Breadth.Unit.newValue = objProductNew.Param4_Unit;
                    IsChanged = true;
                }
                else {
                    objBreadth.Breadth.Unit.oldValue = false;
                    objBreadth.Breadth.Unit.newValue = false;
                    IsChanged = IsChanged != true ? false : true;
                }
            }
            else {
                objProductOld.Param4_Unit == "NA" ? objProductOld.Param4_Unit = "mm" : objProductOld.Param4_Unit;
                if (objProductOld.Param4_T2Neg == null && objProductNew.Param4_T2Neg != null) { // new parameter added
                    objBreadth.Breadth.Unit.oldValue = "mm";
                    objBreadth.Breadth.Unit.newValue = objProductNew.Param4_Unit;
                    IsChanged = true;
                }
                else if (['NULL',null].includes(objProductOld.Param4_Unit) && objProductNew.Param4_Unit == null) // no parameter added
                {
                    objBreadth.Breadth.Unit.oldValue = false;
                    objBreadth.Breadth.Unit.newValue = false;
                    IsChanged = false;
                }
                else {
                    if (objProductOld.Param4_Unit == objProductNew.Param4_Unit) {
                        objBreadth.Breadth.Unit.oldValue = false;
                        objBreadth.Breadth.Unit.newValue = false;
                        IsChanged != true ? IsChanged = false : IsChanged = true;
                    }
                    else {
                        objBreadth.Breadth.Unit.oldValue = objProductOld.Param4_Unit;
                        objBreadth.Breadth.Unit.newValue = objProductNew.Param4_Unit;
                        IsChanged = true;
                    }
                }
            }


            if (IsChanged == true) {
                Object.assign(this.objResult, objBreadth);
            }
            resolve(IsChanged);
        });
    }

    validateLengthMES(objProductOld, objProductNew,int_tabCap) {
        return new Promise((resolve, reject) => {
            const objLength = {
                Length: {
                    'Target': { oldValue: "", newValue: "" },
                    'Lower Limit': { oldValue: "", newValue: "" },
                    'Upper Limit': { oldValue: "", newValue: "" },
                    Unit:{ oldValue: "", newValue: "" },
                }
            };

            var IsChanged = false;
            var OldEmpty = objProductOld == undefined ? true : false;

            /**
             * For Individual PosT1
             */
            if (OldEmpty == true) {
                if (objProductNew.Param5_Nom != "" && objProductNew.Param5_Nom != undefined) {
                    objLength.Length['Target'].oldValue = "NA";
                    objLength.Length['Target'].newValue = objProductNew.Param5_Nom;
                    IsChanged = true;
                }
                else {
                    objLength.Length['Target'].oldValue = false;
                    objLength.Length['Target'].newValue = false;
                    IsChanged = false;
                }
            }
            else {
                if (objProductOld.Param5_Nom === "" ||
                    objProductOld.Param5_Nom == this.strNullValue ||
                    objProductOld.Param5_Nom == undefined) {
                    objProductOld.Param5_Nom = null;
                }

                if (objProductNew.Param5_Nom === "" ||
                    objProductNew.Param5_Nom == this.strNullValue ||
                    objProductNew.Param5_Nom == undefined) {
                    objProductNew.Param5_Nom = null;
                }

                if ((objProductOld.Param5_Nom !== null) && (objProductNew.Param5_Nom !== null)) {
                    if ((objProductOld.Param5_Nom) == (objProductNew.Param5_Nom)) {
                        objLength.Length['Target'].oldValue = false;
                        objLength.Length['Target'].newValue = false;
                        IsChanged != true ? IsChanged = false : IsChanged = true;
                    }
                    else {
                        objLength.Length['Target'].oldValue = (objProductOld.Param5_Nom);
                        objLength.Length['Target'].newValue = (objProductNew.Param5_Nom);
                        IsChanged = true;
                    }

                } else {

                    if ((objProductOld.Param5_Nom === null) && (objProductNew.Param5_Nom !== null)) {
                        objLength.Length['Target'].oldValue = "NA";
                        objLength.Length['Target'].newValue = (objProductNew.Param5_Nom);
                        IsChanged = true;

                    } else if ((objProductOld.Param5_Nom !== null) && (objProductNew.Param5_Nom === null)) {
                        objLength.Length['Target'].oldValue = (objProductOld.Param5_Nom);
                        objLength.Length['Target'].newValue = "NA";
                        IsChanged = true;
                    }
                }
            }




            /**
             * For Length NegT2
             */
            if (OldEmpty == true) {
                if (objProductNew.Param5_T2Neg != "" && objProductNew.Param5_T2Neg != undefined) {
                    objLength.Length['Lower Limit'].oldValue = "NA";
                    objLength.Length['Lower Limit'].newValue = objProductNew.Param5_T2Neg;
                    IsChanged = true;
                }
                else {
                    objLength.Length['Lower Limit'].oldValue = false;
                    objLength.Length['Lower Limit'].newValue = false;
                    IsChanged = false;
                }
            }
            else {
                if (objProductOld.Param5_T2Neg === "" ||
                    objProductOld.Param5_T2Neg == this.strNullValue ||
                    objProductOld.Param5_T2Neg == undefined) {
                    objProductOld.Param5_T2Neg = null;
                }

                if (objProductNew.Param5_T2Neg === "" ||
                    objProductNew.Param5_T2Neg == this.strNullValue ||
                    objProductNew.Param5_T2Neg == undefined) {
                    objProductNew.Param5_T2Neg = null;
                }

                if ((objProductOld.Param5_T2Neg !== null) && (objProductNew.Param5_T2Neg !== null)) {
                    if ((objProductOld.Param5_T2Neg) == (objProductNew.Param5_T2Neg)) {
                        objLength.Length['Lower Limit'].oldValue = false;
                        objLength.Length['Lower Limit'].newValue = false;
                        IsChanged != true ? IsChanged = false : IsChanged = true;
                    }
                    else {
                        objLength.Length['Lower Limit'].oldValue = (objProductOld.Param5_T2Neg);
                        objLength.Length['Lower Limit'].newValue = (objProductNew.Param5_T2Neg);
                        IsChanged = true;
                    }

                } else {

                    if ((objProductOld.Param5_T2Neg === null) && (objProductNew.Param5_T2Neg !== null)) {
                        objLength.Length['Lower Limit'].oldValue = "NA";
                        objLength.Length['Lower Limit'].newValue = (objProductNew.Param5_T2Neg);
                        IsChanged = true;

                    } else if ((objProductOld.Param5_T2Neg !== null) && (objProductNew.Param5_T2Neg === null)) {
                        objLength.Length['Lower Limit'].oldValue = (objProductOld.Param5_T2Neg);
                        objLength.Length['Lower Limit'].newValue = "NA";
                        IsChanged = true;
                    }
                }
            }

            /**
             * For Individual PosT1
             */
            if (OldEmpty == true) {
                if (objProductNew.Param5_T2Pos != "" && objProductNew.Param5_T2Pos != undefined) {
                    objLength.Length['Upper Limit'].oldValue = "NA";
                    objLength.Length['Upper Limit'].newValue = objProductNew.Param5_T2Pos;
                    IsChanged = true;
                }
                else {
                    objLength.Length['Upper Limit'].oldValue = false;
                    objLength.Length['Upper Limit'].newValue = false;
                    IsChanged = false;
                }
            }
            else {
                if (objProductOld.Param5_T2Pos === "" ||
                    objProductOld.Param5_T2Pos == this.strNullValue ||
                    objProductOld.Param5_T2Pos == undefined) {
                    objProductOld.Param5_T2Pos = null;
                }

                if (objProductNew.Param5_T2Pos === "" ||
                    objProductNew.Param5_T2Pos == this.strNullValue ||
                    objProductNew.Param5_T2Pos == undefined) {
                    objProductNew.Param5_T2Pos = null;
                }

                if ((objProductOld.Param5_T2Pos !== null) && (objProductNew.Param5_T2Pos !== null)) {
                    if ((objProductOld.Param5_T2Pos) == (objProductNew.Param5_T2Pos)) {
                        objLength.Length['Upper Limit'].oldValue = false;
                        objLength.Length['Upper Limit'].newValue = false;
                        IsChanged != true ? IsChanged = false : IsChanged = true;
                    }
                    else {
                        objLength.Length['Upper Limit'].oldValue = (objProductOld.Param5_T2Pos);
                        objLength.Length['Upper Limit'].newValue = (objProductNew.Param5_T2Pos);
                        IsChanged = true;
                    }

                } else {

                    if ((objProductOld.Param5_T2Pos === null) && (objProductNew.Param5_T2Pos !== null)) {
                        objLength.Length['Upper Limit'].oldValue = "NA";
                        objLength.Length['Upper Limit'].newValue = (objProductNew.Param5_T2Pos);
                        IsChanged = true;

                    } else if ((objProductOld.Param5_T2Pos !== null) && (objProductNew.Param5_T2Pos === null)) {
                        objLength.Length['Upper Limit'].oldValue = (objProductOld.Param5_T2Pos);
                        objLength.Length['Upper Limit'].newValue = "NA";
                        IsChanged = true;
                    }
                }
            }


            if (OldEmpty) {
                if (objProductNew.Param5_Unit != "" && objProductNew.Param5_T2Neg != "" && objProductNew.Param5_Unit != undefined && objProductNew.Param5_T2Neg != undefined) {
                    objLength.Length.Unit.oldValue = "NA";
                    objLength.Length.Unit.newValue = objProductNew.Param5_Unit;
                    IsChanged = true;
                }
                else {
                    objLength.Length.Unit.oldValue = false;
                    objLength.Length.Unit.newValue = false;
                    IsChanged = IsChanged != true ? false : true;
                }
            }
            else {
                objProductOld.Param5_Unit == "NA" ? objProductOld.Param5_Unit = "mm" : objProductOld.Param5_Unit;
                if (objProductOld.Param5_T2Neg == null && objProductNew.Param5_T2Neg != null) { // new parameter added
                    objLength.Length.Unit.oldValue = "mm";
                    objLength.Length.Unit.newValue = objProductNew.Param5_Unit;
                    IsChanged = true;
                }
                else if (['NULL',null].includes(objProductOld.Param5_Unit) && objProductNew.Param5_Unit == null) // no parameter added
                {
                    objLength.Length.Unit.oldValue = false;
                    objLength.Length.Unit.newValue = false;
                    IsChanged = false;
                }
                else {
                    if (objProductOld.Param5_Unit == objProductNew.Param5_Unit) {
                        objLength.Length.Unit.oldValue = false;
                        objLength.Length.Unit.newValue = false;
                        IsChanged != true ? IsChanged = false : IsChanged = true;
                    }
                    else {
                        objLength.Length.Unit.oldValue = objProductOld.Param5_Unit;
                        objLength.Length.Unit.newValue = objProductNew.Param5_Unit;
                        IsChanged = true;
                    }
                }
            }

            if (IsChanged == true) {
                Object.assign(this.objResult, objLength);
            }
            resolve(IsChanged);
        });
    }

    validateDiameterMES(objProductOld, objProductNew) {
        return new Promise((resolve, reject) => {
            const objDiameter = {
                Diameter: {
                    'Lower Limit': { oldValue: "", newValue: "" },
                    'Upper Limit': { oldValue: "", newValue: "" },
                    Unit:{ oldValue: "", newValue: "" },
                    "Quantity (Initial)":{ oldValue: "", newValue: "" },
                    "Quantity (Regular)":{ oldValue: "", newValue: "" }
                }
            };

            var IsChanged = false;
            var OldEmpty = objProductOld == undefined ? true : false;
           
            /**
             * For Diameter NegT2
             */
            if (OldEmpty == true) {
                if (objProductNew.Param6_T2Neg != "" && objProductNew.Param6_T2Neg != undefined) {
                    objDiameter.Diameter['Lower Limit'].oldValue = "NA";
                    objDiameter.Diameter['Lower Limit'].newValue = objProductNew.Param6_T2Neg;
                    IsChanged = true;
                }
                else {
                    objDiameter.Diameter['Lower Limit'].oldValue = false;
                    objDiameter.Diameter['Lower Limit'].newValue = false;
                    IsChanged = false;
                }
            }
            else {
                if (objProductOld.Param6_T2Neg === "" ||
                    objProductOld.Param6_T2Neg == this.strNullValue ||
                    objProductOld.Param6_T2Neg == undefined) {
                    objProductOld.Param6_T2Neg = null;
                }

                if (objProductNew.Param6_T2Neg === "" ||
                    objProductNew.Param6_T2Neg == this.strNullValue ||
                    objProductNew.Param6_T2Neg == undefined) {
                    objProductNew.Param6_T2Neg = null;
                }

                if ((objProductOld.Param6_T2Neg !== null) && (objProductNew.Param6_T2Neg !== null)) {
                    if (parseFloat(objProductOld.Param6_T2Neg).toFixed(objProductOld.Param6_DP) == parseFloat(objProductNew.Param6_T2Neg).toFixed(objProductNew.Param6_DP)) {
                        objDiameter.Diameter['Lower Limit'].oldValue = false;
                        objDiameter.Diameter['Lower Limit'].newValue = false;
                        IsChanged != true ? IsChanged = false : IsChanged = true;
                    }
                    else {
                        objDiameter.Diameter['Lower Limit'].oldValue = parseFloat(objProductOld.Param6_T2Neg).toFixed(objProductOld.Param6_DP);
                        objDiameter.Diameter['Lower Limit'].newValue = parseFloat(objProductNew.Param6_T2Neg).toFixed(objProductNew.Param6_DP);
                        IsChanged = true;
                    }

                } else {

                    if ((objProductOld.Param6_T2Neg === null) && (objProductNew.Param6_T2Neg !== null)) {
                        objDiameter.Diameter['Lower Limit'].oldValue = "NA";
                        objDiameter.Diameter['Lower Limit'].newValue = parseFloat(objProductNew.Param6_T2Neg).toFixed(objProductNew.Param6_DP);
                        IsChanged = true;

                    } else if ((objProductOld.Param6_T2Neg !== null) && (objProductNew.Param6_T2Neg === null)) {
                        objDiameter.Diameter['Lower Limit'].oldValue = parseFloat(objProductOld.Param6_T2Neg).toFixed(objProductOld.Param6_DP);
                        objDiameter.Diameter['Lower Limit'].newValue = "NA";
                        IsChanged = true;
                    }
                }
            }
            
            /**
             * For Diameter PosT2
             */
            if (OldEmpty == true) {
                if (objProductNew.Param6_T2Pos != "" && objProductNew.Param6_T2Pos != undefined) {
                    objDiameter.Diameter['Upper Limit'].oldValue = "NA";
                    objDiameter.Diameter['Upper Limit'].newValue = objProductNew.Param6_T2Pos;
                    IsChanged = true;
                }
                else {
                    objDiameter.Diameter['Upper Limit'].oldValue = false;
                    objDiameter.Diameter['Upper Limit'].newValue = false;
                    IsChanged = false;
                }
            }
            else {
                if (objProductOld.Param6_T2Pos === "" ||
                    objProductOld.Param6_T2Pos == this.strNullValue ||
                    objProductOld.Param6_T2Pos == undefined) {
                    objProductOld.Param6_T2Pos = null;
                }

                if (objProductNew.Param6_T2Pos === "" ||
                    objProductNew.Param6_T2Pos == this.strNullValue ||
                    objProductNew.Param6_T2Pos == undefined) {
                    objProductNew.Param6_T2Pos = null;
                }

                if ((objProductOld.Param6_T2Pos !== null) && (objProductNew.Param6_T2Pos !== null)) {
                    if (parseFloat(objProductOld.Param6_T2Pos).toFixed(objProductOld.Param6_DP) == parseFloat(objProductNew.Param6_T2Pos).toFixed(objProductNew.Param6_DP)) {
                        objDiameter.Diameter['Upper Limit'].oldValue = false;
                        objDiameter.Diameter['Upper Limit'].newValue = false;
                        IsChanged != true ? IsChanged = false : IsChanged = true;
                    }
                    else {
                        objDiameter.Diameter['Upper Limit'].oldValue = parseFloat(objProductOld.Param6_T2Pos).toFixed(objProductOld.Param6_DP);
                        objDiameter.Diameter['Upper Limit'].newValue = parseFloat(objProductNew.Param6_T2Pos).toFixed(objProductNew.Param6_DP);
                        IsChanged = true;
                    }

                } else {

                    if ((objProductOld.Param6_T2Pos === null) && (objProductNew.Param6_T2Pos !== null)) {
                        objDiameter.Diameter['Upper Limit'].oldValue = "NA";
                        objDiameter.Diameter['Upper Limit'].newValue = parseFloat(objProductNew.Param6_T2Pos).toFixed(objProductNew.Param6_DP);
                        IsChanged = true;

                    } else if ((objProductOld.Param6_T2Pos !== null) && (objProductNew.Param6_T2Pos === null)) {
                        objDiameter.Diameter['Upper Limit'].oldValue = parseFloat(objProductOld.Param6_T2Pos).toFixed(objProductOld.Param6_DP);
                        objDiameter.Diameter['Upper Limit'].newValue = "NA";
                        IsChanged = true;
                    }
                }
            }

            /**
             * For Diameter Initial Quantity
            if (OldEmpty) {
                if (objProductNew.int_DiaQtyInitial != "" && objProductNew.int_DiaQtyInitial!=undefined) {
                    objDiameter.Diameter['Quantity (Initial)'].oldValue = "NA";
                    objDiameter.Diameter['Quantity (Initial)'].newValue = Number(objProductNew.int_DiaQtyInitial);
                    IsChanged = true;
                }
                else {
                    objDiameter.Diameter['Quantity (Initial)'].oldValue = false;
                    objDiameter.Diameter['Quantity (Initial)'].newValue = false;
                    IsChanged = IsChanged != true ? false : true;
                }
            }
            else {
                if (objProductOld.Param6_IniQty === "" ||
                    objProductOld.Param6_IniQty == this.strNullValue ||
                    objProductOld.Param6_IniQty == undefined) {
                    objProductOld.Param6_IniQty = null;
                }

                if (objProductNew.int_DiaQtyInitial === "" || objProductNew.int_DiaQtyInitial == this.strNullValue || objProductNew.int_DiaQtyInitial == undefined) {
                    objProductNew.int_DiaQtyInitial = null;
                }

                if ((objProductOld.Param6_IniQty !== null) && (objProductNew.int_DiaQtyInitial !== null)) {
                    if (Number(objProductOld.Param6_IniQty) == Number(objProductNew.int_DiaQtyInitial)) {
                        objDiameter.Diameter['Quantity (Initial)'].oldValue = false;
                        objDiameter.Diameter['Quantity (Initial)'].newValue = false;
                        IsChanged != true ? IsChanged = false : IsChanged = true;
                    }
                    else {
                        objDiameter.Diameter['Quantity (Initial)'].oldValue = objProductOld.Param6_IniQty;
                        objDiameter.Diameter['Quantity (Initial)'].newValue = Number(objProductNew.int_DiaQtyInitial);
                        IsChanged = true;
                    }

                } else {

                    if ((objProductOld.Param6_IniQty === null) && (objProductNew.int_DiaQtyInitial !== null)) {
                        objDiameter.Diameter['Quantity (Initial)'].oldValue = "NA";
                        objDiameter.Diameter['Quantity (Initial)'].newValue = Number(objProductNew.int_DiaQtyInitial);
                        IsChanged = true;

                    } else if ((objProductOld.Param6_IniQty !== null) && (objProductNew.int_DiaQtyInitial === null)) {
                        objDiameter.Diameter['Quantity (Initial)'].oldValue = objProductOld.Param6_IniQty;
                        objDiameter.Diameter['Quantity (Initial)'].newValue = "NA";
                        IsChanged = true;
                    }
                }
            }
             */
            
            /**
             * For Diameter Quantity Regular
            if (OldEmpty) {
                if (objProductNew.int_DiaQtyRegular != "" && objProductNew.int_DiaQtyRegular!=undefined) {
                    objDiameter.Diameter['Quantity (Regular)'].oldValue = "NA";
                    objDiameter.Diameter['Quantity (Regular)'].newValue = Number(objProductNew.int_DiaQtyRegular);
                    IsChanged = true;
                }
                else {
                    objDiameter.Diameter['Quantity (Regular)'].oldValue = false;
                    objDiameter.Diameter['Quantity (Regular)'].newValue = false;
                    IsChanged = IsChanged != true ? false : true;
                }
            }
            else {
                if (objProductOld.Param6_RegQty === "" ||
                    objProductOld.Param6_RegQty == this.strNullValue ||
                    objProductOld.Param6_RegQty == undefined) {
                    objProductOld.Param6_RegQty = null;
                }

                if (objProductNew.int_DiaQtyRegular === "" || objProductNew.int_DiaQtyRegular == this.strNullValue || objProductNew.int_DiaQtyRegular == undefined) {
                    objProductNew.int_DiaQtyRegular = null;
                }

                if ((objProductOld.Param6_RegQty !== null) && (objProductNew.int_DiaQtyRegular !== null)) {
                    if (Number(objProductOld.Param6_RegQty)== Number(objProductNew.int_DiaQtyRegular)) {
                        objDiameter.Diameter['Quantity (Regular)'].oldValue = false;
                        objDiameter.Diameter['Quantity (Regular)'].newValue = false;
                        IsChanged != true ? IsChanged = false : IsChanged = true;
                    }
                    else {
                        objDiameter.Diameter['Quantity (Regular)'].oldValue = objProductOld.Param6_RegQty;
                        objDiameter.Diameter['Quantity (Regular)'].newValue = Number(objProductNew.int_DiaQtyRegular);
                        IsChanged = true;
                    }

                } else {

                    if ((objProductOld.Param6_RegQty === null) && (objProductNew.int_DiaQtyRegular !== null)) {
                        objDiameter.Diameter['Quantity (Regular)'].oldValue = "NA";
                        objDiameter.Diameter['Quantity (Regular)'].newValue = Number(objProductNew.int_DiaQtyRegular);
                        IsChanged = true;

                    } else if ((objProductOld.Param6_RegQty !== null) && (objProductNew.int_DiaQtyRegular === null)) {
                        objDiameter.Diameter['Quantity (Regular)'].oldValue = objProductOld.Param6_RegQty;
                        objDiameter.Diameter['Quantity (Regular)'].newValue = "NA";
                        IsChanged = true;
                    }
                }
            }
             */

            if (OldEmpty) {
                if (objProductNew.Param6_Unit != "" && objProductNew.Param6_T2Neg != "" && objProductNew.Param6_Unit != undefined && objProductNew.Param6_T2Neg != undefined) {
                    objDiameter.Diameter.Unit.oldValue = "NA";
                    objDiameter.Diameter.Unit.newValue = objProductNew.Param6_Unit;
                    IsChanged = true;
                }
                else {
                    objDiameter.Diameter.Unit.oldValue = false;
                    objDiameter.Diameter.Unit.newValue = false;
                    IsChanged = IsChanged != true ? false : true;
                }
            }
            else {
                objProductOld.Param6_Unit == "NA" ? objProductOld.Param6_Unit = "mm" : objProductOld.Param6_Unit;
                if (objProductOld.Param6_T2Neg == null && objProductNew.Param6_T2Neg != null) { // new parameter added
                    objDiameter.Diameter.Unit.oldValue = "mm";
                    objDiameter.Diameter.Unit.newValue = objProductNew.Param6_Unit;
                    IsChanged = true;
                }
                else if (['NULL',null].includes(objProductOld.Param6_Unit) && objProductNew.Param6_Unit == null) // no parameter added
                {
                    objDiameter.Diameter.Unit.oldValue = false;
                    objDiameter.Diameter.Unit.newValue = false;
                    IsChanged = false;
                }
                else {
                    if (objProductOld.Param6_Unit == objProductNew.Param6_Unit) {
                        objDiameter.Diameter.Unit.oldValue = false;
                        objDiameter.Diameter.Unit.newValue = false;
                        IsChanged != true ? IsChanged = false : IsChanged = true;
                    }
                    else {
                        objDiameter.Diameter.Unit.oldValue = objProductOld.Param6_Unit;
                        objDiameter.Diameter.Unit.newValue = objProductNew.Param6_Unit;
                        IsChanged = true;
                    }
                }
            }
            
            if (IsChanged == true) {
                Object.assign(this.objResult, objDiameter);
            }
            resolve(IsChanged);
        });
    }

    validateHardnessMES(objProductOld, objProductNew) {
        return new Promise((resolve, reject) => {
            let str_Tol_1_Neg = 'Lower Limit';
            let str_Tol_1_Pos = 'Upper Limit';
            const objHardness = {
                Hardness: {
                    'Target': { oldValue: "", newValue: "" },
                    'Lower Limit': { oldValue: "", newValue: "" },
                    'Upper Limit': { oldValue: "", newValue: "" },
                    HrdUnit: { oldValue: "", newValue: "" },
                }
            };

            var IsChanged = false;
            var OldEmpty = objProductOld == undefined ? true : false;

           
           //Hardness NegTol2
           if (OldEmpty == true) {
            if (objProductNew.Param7_Nom != "" && objProductNew.Param7_Nom != undefined) {
                objHardness.Hardness.Target.oldValue = "NA";
                objHardness.Hardness.Target.newValue = objProductNew.Param7_Nom;
                IsChanged = true;
            }
            else {
                objHardness.Hardness.Target.oldValue = false;
                objHardness.Hardness.Target.newValue = false;
                IsChanged = false;
            }
        }
        else {
            if (objProductOld.Param7_Nom === "" ||
                objProductOld.Param7_Nom == this.strNullValue ||
                objProductOld.Param7_Nom == undefined) {
                objProductOld.Param7_Nom = null;
            }

            if (objProductNew.Param7_Nom === "" ||
                objProductNew.Param7_Nom == this.strNullValue ||
                objProductNew.Param7_Nom == undefined) {
                objProductNew.Param7_Nom = null;
            }

            if ((objProductOld.Param7_Nom !== null) && (objProductNew.Param7_Nom !== null)) {
                if ((objProductOld.Param7_Nom) == objProductNew.Param7_Nom) {
                    objHardness.Hardness.Target.oldValue = false;
                    objHardness.Hardness.Target.newValue = false;
                    IsChanged != true ? IsChanged = false : IsChanged = true;
                }
                else {
                    objHardness.Hardness.Target.oldValue =objProductOld.Param7_Nom;
                    objHardness.Hardness.Target.newValue = objProductNew.Param7_Nom;
                    IsChanged = true;
                }

            } else {

                if ((objProductOld.Param7_Nom === null) && (objProductNew.Param7_Nom !== null)) {
                    objHardness.Hardness.Target.oldValue = "NA";
                    objHardness.Hardness.Target.newValue = objProductNew.Param7_Nom;
                    IsChanged = true;

                } else if ((objProductOld.Param7_Nom !== null) && (objProductNew.Param7_Nom === null)) {
                    objHardness.Hardness.Target.oldValue = objProductOld.Param7_Nom;
                    objHardness.Hardness.Target.newValue = "NA";
                    IsChanged = true;
                }
            }
        }
            

           //Hardness NegTol2
            if (OldEmpty == true) {
                if (objProductNew.Param7_T2Neg != "" && objProductNew.Param7_T2Neg != undefined) {
                    objHardness.Hardness[str_Tol_1_Neg].oldValue = "NA";
                    objHardness.Hardness[str_Tol_1_Neg].newValue = objProductNew.Param7_T2Neg;
                    IsChanged = true;
                }
                else {
                    objHardness.Hardness[str_Tol_1_Neg].oldValue = false;
                    objHardness.Hardness[str_Tol_1_Neg].newValue = false;
                    IsChanged = false;
                }
            }
            else {
                if (objProductOld.Param7_T2Neg === "" ||
                    objProductOld.Param7_T2Neg == this.strNullValue ||
                    objProductOld.Param7_T2Neg == undefined) {
                    objProductOld.Param7_T2Neg = null;
                }

                if (objProductNew.Param7_T2Neg === "" ||
                    objProductNew.Param7_T2Neg == this.strNullValue ||
                    objProductNew.Param7_T2Neg == undefined) {
                    objProductNew.Param7_T2Neg = null;
                }

                if ((objProductOld.Param7_T2Neg !== null) && (objProductNew.Param7_T2Neg !== null)) {
                    if ((objProductOld.Param7_T2Neg) == objProductNew.Param7_T2Neg) {
                        objHardness.Hardness[str_Tol_1_Neg].oldValue = false;
                        objHardness.Hardness[str_Tol_1_Neg].newValue = false;
                        IsChanged != true ? IsChanged = false : IsChanged = true;
                    }
                    else {
                        objHardness.Hardness[str_Tol_1_Neg].oldValue =objProductOld.Param7_T2Neg;
                        objHardness.Hardness[str_Tol_1_Neg].newValue = objProductNew.Param7_T2Neg;
                        IsChanged = true;
                    }

                } else {

                    if ((objProductOld.Param7_T2Neg === null) && (objProductNew.Param7_T2Neg !== null)) {
                        objHardness.Hardness[str_Tol_1_Neg].oldValue = "NA";
                        objHardness.Hardness[str_Tol_1_Neg].newValue = objProductNew.Param7_T2Neg;
                        IsChanged = true;

                    } else if ((objProductOld.Param7_T2Neg !== null) && (objProductNew.Param7_T2Neg === null)) {
                        objHardness.Hardness[str_Tol_1_Neg].oldValue = objProductOld.Param7_T2Neg;
                        objHardness.Hardness[str_Tol_1_Neg].newValue = "NA";
                        IsChanged = true;
                    }
                }
            }

           //Hardness PosTol2
            if (OldEmpty == true) {
                if (objProductNew.Param7_T2Pos != "" && objProductNew.Param7_T2Pos != undefined) {
                    objHardness.Hardness[str_Tol_1_Pos].oldValue = "NA";
                    objHardness.Hardness[str_Tol_1_Pos].newValue = objProductNew.Param7_T2Pos;
                    IsChanged = true;
                }
                else {
                    objHardness.Hardness[str_Tol_1_Pos].oldValue = false;
                    objHardness.Hardness[str_Tol_1_Pos].newValue = false;
                    IsChanged = false;
                }
            }
            else {
                if (objProductOld.Param7_T2Pos === "" ||
                    objProductOld.Param7_T2Pos == this.strNullValue ||
                    objProductOld.Param7_T2Pos == undefined) {
                    objProductOld.Param7_T2Pos = null;
                }

                if (objProductNew.Param7_T2Pos === "" ||
                    objProductNew.Param7_T2Pos == this.strNullValue ||
                    objProductNew.Param7_T2Pos == undefined) {
                    objProductNew.Param7_T2Pos = null;
                }

                if ((objProductOld.Param7_T2Pos !== null) && (objProductNew.Param7_T2Pos !== null)) {
                    if ((objProductOld.Param7_T2Pos) == (objProductNew.Param7_T2Pos)) {
                        objHardness.Hardness[str_Tol_1_Pos].oldValue = false;
                        objHardness.Hardness[str_Tol_1_Pos].newValue = false;
                        IsChanged != true ? IsChanged = false : IsChanged = true;
                    }
                    else {
                        objHardness.Hardness[str_Tol_1_Pos].oldValue = (objProductOld.Param7_T2Pos);
                        objHardness.Hardness[str_Tol_1_Pos].newValue = objProductNew.Param7_T2Pos;
                        IsChanged = true;
                    }

                } else {

                    if ((objProductOld.Param7_T2Pos === null) && (objProductNew.Param7_T2Pos !== null)) {
                        objHardness.Hardness[str_Tol_1_Pos].oldValue = "NA";
                        objHardness.Hardness[str_Tol_1_Pos].newValue = objProductNew.Param7_T2Pos;
                        IsChanged = true;

                    } else if ((objProductOld.Param7_T2Pos !== null) && (objProductNew.Param7_T2Pos === null)) {
                        objHardness.Hardness[str_Tol_1_Pos].oldValue = (objProductOld.Param7_T2Pos);
                        objHardness.Hardness[str_Tol_1_Pos].newValue = "NA";
                        IsChanged = true;
                    }
                }
            }

            // Unit
            if (OldEmpty == true) {
                if (objProductNew.Param7_Unit != "" && objProductNew.Param7_T2Neg != "" && objProductNew.Param7_Unit != undefined && objProductNew.Param7_T2Neg != undefined) {
                    objHardness.Hardness.HrdUnit.oldValue = "NA";
                    objHardness.Hardness.HrdUnit.newValue = objProductNew.Param7_Unit;
                    IsChanged = true;
                }
                else {
                    objHardness.Hardness.HrdUnit.oldValue = false;
                    objHardness.Hardness.HrdUnit.newValue = false;
                    IsChanged = false;
                }
            }
            else {
                if (objProductOld.Param7_T2Neg == null && objProductNew.Param7_T2Neg != null) { // new parameter added
                    objHardness.Hardness.HrdUnit.oldValue = "NA";
                    objHardness.Hardness.HrdUnit.newValue = objProductNew.Param7_Unit;
                    IsChanged = true;
                }
                else if (['NULL',null].includes(objProductOld.Param2_Unit) && objProductNew.Param2_Unit == null) // no parameter added
                {
                    objHardness.Hardness.HrdUnit.oldValue = false;
                    objHardness.Hardness.HrdUnit.newValue = false;
                    IsChanged = false;
                }
                else {
                    if (objProductOld.Param7_Unit == objProductNew.Param7_Unit) {
                        objHardness.Hardness.HrdUnit.oldValue = false;
                        objHardness.Hardness.HrdUnit.newValue = false;
                        IsChanged != true ? IsChanged = false : IsChanged = true;
                    }
                    else {
                        objHardness.Hardness.HrdUnit.oldValue = objProductOld.Param7_Unit;
                        objHardness.Hardness.HrdUnit.newValue = objProductNew.Param7_Unit;
                        IsChanged = true;
                    }
                }
            }

            if (IsChanged == true) {
                Object.assign(this.objResult, objHardness);
            }
            resolve(IsChanged);
        });
    }

    validateFriabilityMES(objProductOld, objProductNew) {
        return new Promise((resolve, reject) => {
            const objFriability = {
                Friability: {
                    // 'Target': { oldValue: "", newValue: "" },
                    // 'Lower Limit': { oldValue: "", newValue: "" },
                    'Upper Limit': { oldValue: "", newValue: "" },
                    // FriSetCnt: { oldValue: "", newValue: "" },
                    // FriSetRPM: { oldValue: "", newValue: "" },
                }
            };

            var IsChanged = false;
            var OldEmpty = objProductOld == undefined ? true : false;

            /**
             * For Target
             */
            if (OldEmpty == true) {
                if (objProductNew.Param8_Nom != "" && objProductNew.Param8_Nom != undefined) {
                    objFriability.Friability['Upper Limit'].oldValue = "NA";
                    objFriability.Friability['Upper Limit'].newValue = objProductNew.Param8_Nom;
                    IsChanged = true;
                }
                else {
                    objFriability.Friability['Upper Limit'].oldValue = false;
                    objFriability.Friability['Upper Limit'].newValue = false;
                    IsChanged = false;
                }
            }
            else {
                if (objProductOld.Param8_Nom === "" ||
                    objProductOld.Param8_Nom == this.strNullValue ||
                    objProductOld.Param8_Nom == undefined) {
                    objProductOld.Param8_Nom = null;
                }

                if (objProductNew.Param8_Nom === "" ||
                    objProductNew.Param8_Nom == this.strNullValue ||
                    objProductNew.Param8_Nom == undefined) {
                    objProductNew.Param8_Nom = null;
                }

                if ((objProductOld.Param8_Nom !== null) && (objProductNew.Param8_Nom !== null)) {
                    if ((objProductOld.Param8_Nom) == (objProductNew.Param8_Nom)) {
                        objFriability.Friability['Upper Limit'].oldValue = false;
                        objFriability.Friability['Upper Limit'].newValue = false;
                        IsChanged != true ? IsChanged = false : IsChanged = true;
                    }
                    else {
                        objFriability.Friability['Upper Limit'].oldValue = (objProductOld.Param8_Nom);
                        objFriability.Friability['Upper Limit'].newValue = objProductNew.Param8_Nom;
                        IsChanged = true;
                    }

                } else {

                    if ((objProductOld.Param8_Nom === null) && (objProductNew.Param8_Nom !== null)) {
                        objFriability.Friability['Upper Limit'].oldValue = "NA";
                        objFriability.Friability['Upper Limit'].newValue = objProductNew.Param8_Nom;
                        IsChanged = true;

                    } else if ((objProductOld.Param8_Nom !== null) && (objProductNew.Param8_Nom === null)) {
                        objFriability.Friability['Upper Limit'].oldValue = (objProductOld.Param8_Nom);
                        objFriability.Friability['Upper Limit'].newValue = "NA";
                        IsChanged = true;
                    }
                }
            }



            // /**
            //  * For Lower Limit
            //  */
            // if (OldEmpty == true) {
            //     if (objProductNew.Param8_T2Neg != "" && objProductNew.Param8_T2Neg != undefined) {
            //         objFriability.Friability['Lower Limit'].oldValue = "NA";
            //         objFriability.Friability['Lower Limit'].newValue = objProductNew.Param8_T2Neg;
            //         IsChanged = true;
            //     }
            //     else {
            //         objFriability.Friability['Lower Limit'].oldValue = false;
            //         objFriability.Friability['Lower Limit'].newValue = false;
            //         IsChanged = false;
            //     }
            // }
            // else {
            //     if (objProductOld.Param8_T2Neg === "" ||
            //         objProductOld.Param8_T2Neg == this.strNullValue ||
            //         objProductOld.Param8_T2Neg == undefined) {
            //         objProductOld.Param8_T2Neg = null;
            //     }

            //     if (objProductNew.Param8_T2Neg === "" ||
            //         objProductNew.Param8_T2Neg == this.strNullValue ||
            //         objProductNew.Param8_T2Neg == undefined) {
            //         objProductNew.Param8_T2Neg = null;
            //     }

            //     if ((objProductOld.Param8_T2Neg !== null) && (objProductNew.Param8_T2Neg !== null)) {
            //         if ((objProductOld.Param8_T2Neg)== (objProductNew.Param8_T2Neg)) {
            //             objFriability.Friability['Lower Limit'].oldValue = false;
            //             objFriability.Friability['Lower Limit'].newValue = false;
            //             IsChanged != true ? IsChanged = false : IsChanged = true;
            //         }
            //         else {
            //             objFriability.Friability['Lower Limit'].oldValue = (objProductOld.Param8_T2Neg);
            //             objFriability.Friability['Lower Limit'].newValue = objProductNew.Param8_T2Neg;
            //             IsChanged = true;
            //         }

            //     } else {

            //         if ((objProductOld.Param8_T2Neg === null) && (objProductNew.Param8_T2Neg !== null)) {
            //             objFriability.Friability['Lower Limit'].oldValue = "NA";
            //             objFriability.Friability['Lower Limit'].newValue = objProductNew.Param8_T2Neg;
            //             IsChanged = true;

            //         } else if ((objProductOld.Param8_T2Neg !== null) && (objProductNew.Param8_T2Neg === null)) {
            //             objFriability.Friability['Lower Limit'].oldValue = (objProductOld.Param8_T2Neg);
            //             objFriability.Friability['Lower Limit'].newValue = "NA";
            //             IsChanged = true;
            //         }
            //     }
            // }
            
            // /**
            //  * For UpperLimit
            //  */
            // if (OldEmpty == true) {
            //     if (objProductNew.Param8_T2Pos != "" && objProductNew.Param8_T2Pos != undefined) {
            //         objFriability.Friability['Upper Limit'].oldValue = "NA";
            //         objFriability.Friability['Upper Limit'].newValue = objProductNew.Param8_T2Pos;
            //         IsChanged = true;
            //     }
            //     else {
            //         objFriability.Friability['Upper Limit'].oldValue = false;
            //         objFriability.Friability['Upper Limit'].newValue = false;
            //         IsChanged = false;
            //     }
            // }
            // else {
            //     if (objProductOld.Param8_T2Pos === "" ||
            //         objProductOld.Param8_T2Pos == this.strNullValue ||
            //         objProductOld.Param8_T2Pos == undefined) {
            //         objProductOld.Param8_T2Pos = null;
            //     }

            //     if (objProductNew.Param8_T2Pos === "" ||
            //         objProductNew.Param8_T2Pos == this.strNullValue ||
            //         objProductNew.Param8_T2Pos == undefined) {
            //         objProductNew.Param8_T2Pos = null;
            //     }

            //     if ((objProductOld.Param8_T2Pos !== null) && (objProductNew.Param8_T2Pos !== null)) {
            //         if ((objProductOld.Param8_T2Pos) == (objProductNew.Param8_T2Pos)) {
            //             objFriability.Friability['Upper Limit'].oldValue = false;
            //             objFriability.Friability['Upper Limit'].newValue = false;
            //             IsChanged != true ? IsChanged = false : IsChanged = true;
            //         }
            //         else {
            //             objFriability.Friability['Upper Limit'].oldValue = (objProductOld.Param8_T2Pos);
            //             objFriability.Friability['Upper Limit'].newValue = objProductNew.Param8_T2Pos;
            //             IsChanged = true;
            //         }

            //     } else {

            //         if ((objProductOld.Param8_T2Pos === null) && (objProductNew.Param8_T2Pos !== null)) {
            //             objFriability.Friability['Upper Limit'].oldValue = "NA";
            //             objFriability.Friability['Upper Limit'].newValue = objProductNew.Param8_T2Pos;
            //             IsChanged = true;

            //         } else if ((objProductOld.Param8_T2Pos !== null) && (objProductNew.Param8_T2Pos === null)) {
            //             objFriability.Friability['Upper Limit'].oldValue = (objProductOld.Param8_T2Pos);
            //             objFriability.Friability['Upper Limit'].newValue = "NA";
            //             IsChanged = true;
            //         }
            //     }
            // }

            if (IsChanged == true) {
                Object.assign(this.objResult, objFriability);
            }
            resolve(IsChanged);
        });
    }

    // validateMPNCode(objProductOld, objProductNew) {
    //     return new Promise((resolve, reject) => {
    //         const objMPNCode = {
    //             MPN_CODE: {
    //                 'MPN_Code': { oldValue: "", newValue: "" },
    //             }
    //         };

    //         var IsChanged = false;

    //         if(objProductOld.MPN_Code != objProductNew.MPN_Code) {
    //             objMPNCode.MPN_CODE['MPN_Code'].oldValue = objProductOld.MPN_Code;
    //             objMPNCode.MPN_CODE['MPN_Code'].newValue = objProductNew.MPN_Code;
    //             IsChanged = true;
    //         }
    //         else {
    //             IsChanged = false;
    //         }

    //         if (IsChanged == true) {
    //             Object.assign(this.objResult, objMPNCode);
    //         }
    //         resolve(IsChanged);
    //     });   
    // }

    validateIndLayer1MES(objProductOld, objProductNew) {
        return new Promise((resolve, reject) => {
            const objIndividualL1 = {
                IndividualL1: {
                    'Lower Limit': { oldValue: "", newValue: "" },
                    'Upper Limit': { oldValue: "", newValue: "" },
                }
            };

            var IsChanged = false;
            var OldEmpty = objProductOld == undefined ? true : false;
            
            /**
            * For Individual NegT2
            */
            if (OldEmpty == true) {
                if (objProductNew.Param9_T2Neg != "" && objProductNew.Param9_T2Neg != undefined) {
                    objIndividualL1.IndividualL1['Lower Limit'].oldValue = "NA";
                    objIndividualL1.IndividualL1['Lower Limit'].newValue = objProductNew.Param9_T2Neg;
                    IsChanged = true;
                }
                else {
                    objIndividualL1.IndividualL1['Lower Limit'].oldValue = false;
                    objIndividualL1.IndividualL1['Lower Limit'].newValue = false;
                    IsChanged = false;
                }
            }
            else {
                if (objProductOld.Param9_T2Neg === "" ||
                    objProductOld.Param9_T2Neg == this.strNullValue ||
                    objProductOld.Param9_T2Neg == undefined) {
                    objProductOld.Param9_T2Neg = null;
                }

                if (objProductNew.Param9_T2Neg === "" ||
                    objProductNew.Param9_T2Neg == this.strNullValue ||
                    objProductNew.Param9_T2Neg == undefined) {
                    objProductNew.Param9_T2Neg = null;
                }

                if ((objProductOld.Param9_T2Neg !== null) && (objProductNew.Param9_T2Neg !== null)) {
                    if (parseFloat(objProductOld.Param9_T2Neg).toFixed(objProductOld.Param9_DP) == parseFloat(objProductNew.Param9_T2Neg).toFixed(objProductNew.Param9_DP)) {
                        objIndividualL1.IndividualL1['Lower Limit'].oldValue = false;
                        objIndividualL1.IndividualL1['Lower Limit'].newValue = false;
                        IsChanged != true ? IsChanged = false : IsChanged = true;
                    }
                    else {
                        objIndividualL1.IndividualL1['Lower Limit'].oldValue = parseFloat(objProductOld.Param9_T2Neg).toFixed(objProductOld.Param9_DP);
                        objIndividualL1.IndividualL1['Lower Limit'].newValue = objProductNew.Param9_T2Neg;
                        IsChanged = true;
                    }

                } else {

                    if ((objProductOld.Param9_T2Neg === null) && (objProductNew.Param9_T2Neg !== null)) {
                        objIndividualL1.IndividualL1['Lower Limit'].oldValue = "NA";
                        objIndividualL1.IndividualL1['Lower Limit'].newValue = objProductNew.Param9_T2Neg;
                        IsChanged = true;

                    } else if ((objProductOld.Param9_T2Neg !== null) && (objProductNew.Param9_T2Neg === null)) {
                        objIndividualL1.IndividualL1['Lower Limit'].oldValue = parseFloat(objProductOld.Param9_T2Neg).toFixed(objProductOld.Param9_DP);
                        objIndividualL1.IndividualL1['Lower Limit'].newValue = "NA";
                        IsChanged = true;
                    }
                }
            }
        
            /**
            * For Individual PosT2
            */
            if (OldEmpty == true) {
                if (objProductNew.Param9_T2Pos != "" && objProductNew.Param9_T2Pos != undefined) {
                    objIndividualL1.IndividualL1['Upper Limit'].oldValue = "NA";
                    objIndividualL1.IndividualL1['Upper Limit'].newValue = objProductNew.Param9_T2Pos;
                    IsChanged = true;
                }
                else {
                    objIndividualL1.IndividualL1['Upper Limit'].oldValue = false;
                    objIndividualL1.IndividualL1['Upper Limit'].newValue = false;
                    IsChanged = false;
                }
            }
            else {
                if (objProductOld.Param9_T2Pos === "" ||
                    objProductOld.Param9_T2Pos == this.strNullValue ||
                    objProductOld.Param9_T2Pos == undefined) {
                    objProductOld.Param9_T2Pos = null;
                }

                if (objProductNew.Param9_T2Pos === "" ||
                    objProductNew.Param9_T2Pos == this.strNullValue ||
                    objProductNew.Param9_T2Pos == undefined) {
                    objProductNew.Param9_T2Pos = null;
                }

                if ((objProductOld.Param9_T2Pos !== null) && (objProductNew.Param9_T2Pos !== null)) {
                    if (parseFloat(objProductOld.Param9_T2Pos).toFixed(objProductOld.Param9_DP) == parseFloat(objProductNew.Param9_T2Pos).toFixed(objProductNew.Param9_DP)) {
                        objIndividualL1.IndividualL1['Upper Limit'].oldValue = false;
                        objIndividualL1.IndividualL1['Upper Limit'].newValue = false;
                        IsChanged != true ? IsChanged = false : IsChanged = true;
                    }
                    else {
                        objIndividualL1.IndividualL1['Upper Limit'].oldValue = parseFloat(objProductOld.Param9_T2Pos).toFixed(objProductOld.Param9_DP);
                        objIndividualL1.IndividualL1['Upper Limit'].newValue = objProductNew.Param9_T2Pos;
                        IsChanged = true;
                    }

                } else {

                    if ((objProductOld.Param9_T2Pos === null) && (objProductNew.Param9_T2Pos !== null)) {
                        objIndividualL1.IndividualL1['Upper Limit'].oldValue = "NA";
                        objIndividualL1.IndividualL1['Upper Limit'].newValue = objProductNew.Param9_T2Pos;
                        IsChanged = true;

                    } else if ((objProductOld.Param9_T2Pos !== null) && (objProductNew.Param9_T2Pos === null)) {
                        objIndividualL1.IndividualL1['Upper Limit'].oldValue = parseFloat(objProductOld.Param9_T2Pos).toFixed(objProductOld.Param9_DP);
                        objIndividualL1.IndividualL1['Upper Limit'].newValue = "NA";
                        IsChanged = true;
                    }
                }
            }

            if (IsChanged == true) {
                Object.assign(this.objResult, objIndividualL1);
            }
            resolve(IsChanged);
        });
    }

    validateGrpLayer1MES(objProductOld, objProductNew) {
        return new Promise((resolve, reject) => {
            const objGroupL1 = {
                GroupL1: {
                    'Lower Limit': { oldValue: "", newValue: "" },
                    'Upper Limit': { oldValue: "", newValue: "" },
                }
            };

            var IsChanged = false;
            var OldEmpty = objProductOld == undefined ? true : false;
           
            /**
            * For Individual NegT2
            */
            if (OldEmpty == true) {
                if (objProductNew.Param10_T2Neg != "" && objProductNew.Param10_T2Neg != undefined) {
                    objGroupL1.GroupL1['Lower Limit'].oldValue = "NA";
                    objGroupL1.GroupL1['Lower Limit'].newValue = objProductNew.Param10_T2Neg;
                    IsChanged = true;
                }
                else {
                    objGroupL1.GroupL1['Lower Limit'].oldValue = false;
                    objGroupL1.GroupL1['Lower Limit'].newValue = false;
                    IsChanged = false;
                }
            }
            else {
                if (objProductOld.Param10_T2Neg === "" ||
                    objProductOld.Param10_T2Neg == this.strNullValue ||
                    objProductOld.Param10_T2Neg == undefined) {
                    objProductOld.Param10_T2Neg = null;
                }

                if (objProductNew.flt_GrpL1T2Neg === "" ||
                    objProductNew.flt_GrpL1T2Neg == this.strNullValue ||
                    objProductNew.flt_GrpL1T2Neg == undefined) {
                    objProductNew.flt_GrpL1T2Neg = null;
                }

                if ((objProductOld.Param10_T2Neg !== null) && (objProductNew.Param10_T2Neg !== null)) {
                    if (parseFloat(objProductOld.Param10_T2Neg).toFixed(objProductOld.Param10_DP) == parseFloat(objProductNew.Param10_T2Neg).toFixed(objProductNew.Param10_DP)) {
                        objGroupL1.GroupL1['Lower Limit'].oldValue = false;
                        objGroupL1.GroupL1['Lower Limit'].newValue = false;
                        IsChanged != true ? IsChanged = false : IsChanged = true;
                    }
                    else {
                        objGroupL1.GroupL1['Lower Limit'].oldValue = parseFloat(objProductOld.Param10_T2Neg).toFixed(objProductOld.Param10_DP);
                        objGroupL1.GroupL1['Lower Limit'].newValue = objProductNew.Param10_T2Neg;
                        IsChanged = true;
                    }

                } else {

                    if ((objProductOld.Param10_T2Neg === null) && (objProductNew.Param10_T2Neg !== null)) {
                        objGroupL1.GroupL1['Lower Limit'].oldValue = "NA";
                        objGroupL1.GroupL1['Lower Limit'].newValue = objProductNew.Param10_T2Neg;
                        IsChanged = true;

                    } else if ((objProductOld.Param10_T2Neg !== null) && (objProductNew.Param10_T2Neg === null)) {
                        objGroupL1.GroupL1['Lower Limit'].oldValue = parseFloat(objProductOld.Param10_T2Neg).toFixed(objProductOld.Param10_DP);
                        objGroupL1.GroupL1['Lower Limit'].newValue = "NA";
                        IsChanged = true;
                    }
                }
            }

            /**
            * For Individual PosT2
            */
            if (OldEmpty == true) {
                if (objProductNew.Param10_T2Pos != "" && objProductNew.Param10_T2Pos != undefined) {
                    objGroupL1.GroupL1['Upper Limit'].oldValue = "NA";
                    objGroupL1.GroupL1['Upper Limit'].newValue = objProductNew.Param10_T2Pos;
                    IsChanged = true;
                }
                else {
                    objGroupL1.GroupL1['Upper Limit'].oldValue = false;
                    objGroupL1.GroupL1['Upper Limit'].newValue = false;
                    IsChanged = false;
                }
            }
            else {
                if (objProductOld.Param10_T2Pos === "" ||
                    objProductOld.Param10_T2Pos == this.strNullValue ||
                    objProductOld.Param10_T2Pos == undefined) {
                    objProductOld.Param10_T2Pos = null;
                }

                if (objProductNew.Param10_T2Pos === "" ||
                    objProductNew.Param10_T2Pos == this.strNullValue ||
                    objProductNew.Param10_T2Pos == undefined) {
                    objProductNew.Param10_T2Pos = null;
                }

                if ((objProductOld.Param10_T2Pos !== null) && (objProductNew.Param10_T2Pos !== null)) {
                    if (parseFloat(objProductOld.Param10_T2Pos).toFixed(objProductOld.Param10_DP) == parseFloat(objProductNew.Param10_T2Pos).toFixed(objProductNew.Param10_DP)) {
                        objGroupL1.GroupL1['Upper Limit'].oldValue = false;
                        objGroupL1.GroupL1['Upper Limit'].newValue = false;
                        IsChanged != true ? IsChanged = false : IsChanged = true;
                    }
                    else {
                        objGroupL1.GroupL1['Upper Limit'].oldValue = parseFloat(objProductOld.Param10_T2Pos).toFixed(objProductOld.Param10_DP);
                        objGroupL1.GroupL1['Upper Limit'].newValue = objProductNew.Param10_T2Pos;
                        IsChanged = true;
                    }

                } else {

                    if ((objProductOld.Param10_T2Pos === null) && (objProductNew.Param10_T2Pos !== null)) {
                        objGroupL1.GroupL1['Upper Limit'].oldValue = "NA";
                        objGroupL1.GroupL1['Upper Limit'].newValue = objProductNew.Param10_T2Pos;
                        IsChanged = true;

                    } else if ((objProductOld.Param10_T2Pos !== null) && (objProductNew.Param10_T2Pos === null)) {
                        objGroupL1.GroupL1['Upper Limit'].oldValue = parseFloat(objProductOld.Param10_T2Pos).toFixed(objProductOld.Param10_DP);
                        objGroupL1.GroupL1['Upper Limit'].newValue = "NA";
                        IsChanged = true;
                    }
                }
            }

            if (IsChanged == true) {
                Object.assign(this.objResult, objGroupL1);
            }
            resolve(IsChanged);
        });
    }

    validateDTMES(objProductOld, objProductNew) {
        return new Promise((resolve, reject) => {
            const objDT = {
                DT: {
                    Time: { oldValue: "", newValue: "" },
                //     DTMinTemp: { oldValue: "", newValue: "" },
                //     DTMaxTemp: { oldValue: "", newValue: "" }
                }
            };

            var IsChanged = false;
            var OldEmpty = objProductOld == undefined ? true : false;


            /**
             * For DT Time 
             */
            if (OldEmpty == true) {
                if (objProductNew.Param13_Nom != "" && objProductNew.Param13_Nom != undefined) {
                    objDT.DT.Time.oldValue = "NA";
                    objDT.DT.Time.newValue = objProductNew.Param13_Nom;
                    IsChanged = true;
                }
                else {
                    objDT.DT.Time.oldValue = false;
                    objDT.DT.Time.newValue = false;
                    IsChanged = false;
                }
            }
            else {
                if (objProductOld.Param13_Nom === "" ||
                    objProductOld.Param13_Nom == this.strNullValue ||
                    objProductOld.Param13_Nom == undefined) {
                    objProductOld.Param13_Nom = null;
                }

                if (objProductNew.Param13_Nom === "" ||
                    objProductNew.Param13_Nom == this.strNullValue ||
                    objProductNew.Param13_Nom == undefined) {
                    objProductNew.Param13_Nom = null;
                }

                if ((objProductOld.Param13_Nom === null || objProductOld.Param13_Nom == 'NULL') && (objProductNew.Param13_Nom === null || objProductNew.Param13_Nom == 'NULL')) {
                        objDT.DT.Time.oldValue = false;
                        objDT.DT.Time.newValue = false;
                        IsChanged = false;
                }
                else if (objProductOld.Param13_Nom == objProductNew.Param13_Nom) {
                    objDT.DT.Time.oldValue = false;
                    objDT.DT.Time.newValue = false;
                    IsChanged = false;
                }
                else {
                    objDT.DT.Time.oldValue = objProductOld.Param13_Nom;
                    objDT.DT.Time.newValue = objProductNew.Param13_Nom;
                    IsChanged = true;
                }
            }


            // /**
            //  * For DT Time 
            //  */
            // if (OldEmpty == true) {
            //     if (objProductNew.int_DTMMTime != "" && objProductNew.int_DTMMTime != undefined) {
            //         objDT.DT.DTTime.oldValue = "NA";
            //         objDT.DT.DTTime.newValue = objProductNew.int_DTHHTime + ":" + objProductNew.int_DTMMTime + ":" + objProductNew.int_DTSSTime;
            //         IsChanged = true;
            //     }
            //     else {
            //         objDT.DT.DTTime.oldValue = false;
            //         objDT.DT.DTTime.newValue = false;
            //         IsChanged = false;
            //     }
            // }
            // else {
            //     if (objProductOld.Param13_Nom === "" ||
            //         objProductOld.Param13_Nom == this.strNullValue ||
            //         objProductOld.Param13_Nom == undefined) {
            //         objProductOld.Param13_Nom = null;
            //     }

            //     if (objProductNew.int_DTHHTime === "" ||
            //         objProductNew.int_DTHHTime == this.strNullValue ||
            //         objProductNew.int_DTHHTime == undefined) {
            //         objProductNew.int_DTHHTime = null;
            //     }

            //     if (objProductNew.int_DTMMTime === "" ||
            //         objProductNew.int_DTMMTime == this.strNullValue ||
            //         objProductNew.int_DTMMTime == undefined) {
            //         objProductNew.int_DTMMTime = null;
            //     }

            //     if (objProductNew.int_DTSSTime === "" ||
            //         objProductNew.int_DTSSTime == this.strNullValue ||
            //         objProductNew.int_DTSSTime == undefined) {
            //         objProductNew.int_DTSSTime = null;
            //     }

            //     if ((objProductOld.Param13_Nom === null) && (objProductNew.int_DTHHTime === null) && 
            //         (objProductNew.int_DTMMTime === null) && (objProductNew.int_DTSSTime === null)) {
            //             objDT.DT.DTTime.oldValue = false;
            //             objDT.DT.DTTime.newValue = false;
            //             IsChanged = false;
            //     }
            //     else if (objProductOld.Param13_Nom == (objProductNew.int_DTHHTime + ":" + objProductNew.int_DTMMTime + ":" + objProductNew.int_DTSSTime)) {
            //         objDT.DT.DTTime.oldValue = false;
            //         objDT.DT.DTTime.newValue = false;
            //         IsChanged = false;
            //     }
            //     else {
            //         objDT.DT.DTTime.oldValue = objProductOld.Param13_Nom;
            //         objDT.DT.DTTime.newValue = objProductNew.int_DTHHTime + ":" + objProductNew.int_DTMMTime + ":" + objProductNew.int_DTSSTime;
            //         IsChanged = true;
            //     }
            // }

            // /**
            //  * For DT Min Temp
            //  */
            // if (OldEmpty == true) {
            //     if ((objProductNew.flt_DTMinTemp != "") && (objProductNew.flt_DTMinTemp != 99999) && objProductNew.flt_DTMinTemp != undefined) {
            //         objDT.DT.DTMinTemp.oldValue = "NA";
            //         objDT.DT.DTMinTemp.newValue = objProductNew.flt_DTMinTemp;
            //         IsChanged = true;
            //     }
            //     else {
            //         objDT.DT.DTMinTemp.oldValue = false;
            //         objDT.DT.DTMinTemp.newValue = false;
            //         IsChanged = false;
            //     }
            // }
            // else {
            //     if (objProductOld.Param13_T1Neg === "" ||
            //         objProductOld.Param13_T1Neg == this.strNullValue ||
            //         objProductOld.Param13_T1Neg == undefined) {
            //         objProductOld.Param13_T1Neg = null;
            //     }

            //     if (objProductNew.flt_DTMinTemp === "" ||
            //         objProductNew.flt_DTMinTemp == this.strNullValue ||
            //         objProductNew.flt_DTMinTemp == undefined) {
            //         objProductNew.flt_DTMinTemp = null;
            //     }

            //     if ((objProductOld.Param13_T1Neg !== null) && (objProductNew.flt_DTMinTemp !== null)) {
            //         if (parseFloat(objProductOld.Param13_T1Neg).toFixed(objProductOld.Param13_DP) == parseFloat(objProductNew.flt_DTMinTemp).toFixed(objProductNew.int_DTDp)) {
            //             objDT.DT.DTMinTemp.oldValue = false;
            //             objDT.DT.DTMinTemp.newValue = false;
            //             IsChanged != true ? IsChanged = false : IsChanged = true;

            //         } else {
            //             objDT.DT.DTMinTemp.oldValue = parseFloat(objProductOld.Param13_T1Neg).toFixed(objProductOld.Param13_DP);
            //             objDT.DT.DTMinTemp.newValue = objProductNew.flt_DTMinTemp;
            //             IsChanged = true;
            //         }

            //     } else if((objProductOld.Param13_T1Neg == null) && (objProductNew.flt_DTMinTemp == '99999')) {
            //         objDT.DT.DTMinTemp.oldValue = false;
            //         objDT.DT.DTMinTemp.newValue = false;
            //         IsChanged != true ? IsChanged = false : IsChanged = true;

            //     } else {

            //         if ((objProductOld.Param13_T1Neg === null) && (objProductNew.flt_DTMinTemp !== null)) {
            //             objDT.DT.DTMinTemp.oldValue = "NA";
            //             objDT.DT.DTMinTemp.newValue = objProductNew.flt_DTMinTemp;
            //             IsChanged = true;

            //         } else if ((objProductOld.Param13_T1Neg !== null) && (objProductNew.flt_DTMinTemp === null)) {
            //             objDT.DT.DTMinTemp.oldValue = parseFloat(objProductOld.Param13_T1Neg).toFixed(objProductOld.Param13_DP);
            //             objDT.DT.DTMinTemp.newValue = "NA";
            //             IsChanged = true;
            //         }
            //     }
            // }

            // /**
            //  * For DT Max Temp
            //  */
            // if (OldEmpty == true) {
            //     if ((objProductNew.flt_DTMaxTemp != "") && (objProductNew.flt_DTMaxTemp != 99999) && objProductNew.flt_DTMaxTemp != undefined) {
            //         objDT.DT.DTMaxTemp.oldValue = "NA";
            //         objDT.DT.DTMaxTemp.newValue = objProductNew.flt_DTMaxTemp;
            //         IsChanged = true;
            //     }
            //     else {
            //         objDT.DT.DTMaxTemp.oldValue = false;
            //         objDT.DT.DTMaxTemp.newValue = false;
            //         IsChanged = false;
            //     }
            // }
            // else {
            //     if (objProductOld.Param13_T1Pos === "" ||
            //         objProductOld.Param13_T1Pos == this.strNullValue ||
            //         objProductOld.Param13_T1Pos == undefined) {
            //         objProductOld.Param13_T1Pos = null;
            //     }

            //     if (objProductNew.flt_DTMaxTemp === "" ||
            //         objProductNew.flt_DTMaxTemp == this.strNullValue ||
            //         objProductNew.flt_DTMaxTemp == undefined) {
            //         objProductNew.flt_DTMaxTemp = null;
            //     }

            //     if ((objProductOld.Param13_T1Pos !== null) && (objProductNew.flt_DTMaxTemp !== null)) {
            //         if (parseFloat(objProductOld.Param13_T1Pos).toFixed(objProductOld.Param13_DP) == parseFloat(objProductNew.flt_DTMaxTemp).toFixed(objProductNew.int_DTDp)) {
            //             objDT.DT.DTMaxTemp.oldValue = false;
            //             objDT.DT.DTMaxTemp.newValue = false;
            //             IsChanged != true ? IsChanged = false : IsChanged = true;

            //         } else {
            //             objDT.DT.DTMaxTemp.oldValue = parseFloat(objProductOld.Param13_T1Pos).toFixed(objProductOld.Param13_DP);
            //             objDT.DT.DTMaxTemp.newValue = objProductNew.flt_DTMaxTemp;
            //             IsChanged = true;
            //         }

            //     } else if((objProductOld.Param13_T1Pos == null) && (objProductNew.flt_DTMaxTemp == '99999')){
            //         objDT.DT.DTMaxTemp.oldValue = false;
            //         objDT.DT.DTMaxTemp.newValue = false;
            //         IsChanged != true ? IsChanged = false : IsChanged = true;

            //     } else {

            //         if ((objProductOld.Param13_T1Pos === null) && (objProductNew.flt_DTMaxTemp !== null)) {
            //             objDT.DT.DTMaxTemp.oldValue = "NA";
            //             objDT.DT.DTMaxTemp.newValue = objProductNew.flt_DTMaxTemp;
            //             IsChanged = true;

            //         } else if ((objProductOld.Param13_T1Pos !== null) && (objProductNew.flt_DTMaxTemp === null)) {
            //             objDT.DT.DTMaxTemp.oldValue = parseFloat(objProductOld.Param13_T1Pos).toFixed(objProductOld.Param13_DP);
            //             objDT.DT.DTMaxTemp.newValue = "NA";
            //             IsChanged = true;
            //         }
            //     }
            // }
            
            if (IsChanged == true) {
                Object.assign(this.objResult, objDT);
            }
            resolve(IsChanged);
        });
    }

    validateLODMES(objProductOld, objProductNew) {
        return new Promise((resolve, reject) => {
            const objLOD = {
                LOD: {
                    'Target': { oldValue: "", newValue: "" },
                    'Lower Limit': { oldValue: "", newValue: "" },
                    'Upper Limit': { oldValue: "", newValue: "" },
                    // MIN: { oldValue: "", newValue: "" },
                    // MAX: { oldValue: "", newValue: "" }
                }
            };

            var IsChanged = false;
            var OldEmpty = objProductOld == undefined ? true : false;
            /**
             * For Individual Nom
             */
            if (OldEmpty == true) {
                if (objProductNew.Param16_T1Neg != "" && objProductNew.Param16_T1Neg != undefined && objProductNew.Param16_T1Neg != 99999) {
                    objLOD.LOD['Lower Limit'].oldValue = "NA";
                    objLOD.LOD['Lower Limit'].newValue = objProductNew.Param16_T1Neg;
                    IsChanged = true;
                }
                else {
                    objLOD.LOD['Lower Limit'].oldValue = false;
                    objLOD.LOD['Lower Limit'].newValue = false;
                    IsChanged = false;
                }
            }
            else {
                if (objProductOld.Param16_T1Neg === "" ||
                    objProductOld.Param16_T1Neg == this.strNullValue ||
                    objProductOld.Param16_T1Neg == undefined) {
                    objProductOld.Param16_T1Neg = null;
                }

                if (objProductNew.Param16_T1Neg === "" ||
                    objProductNew.Param16_T1Neg == this.strNullValue ||
                    objProductNew.Param16_T1Neg == undefined) {
                    objProductNew.Param16_T1Neg = null;
                }

                if ((objProductOld.Param16_T1Neg !== null) && (objProductNew.Param16_T1Neg !== null)) {
                    if (objProductOld.Param16_T1Neg == (objProductNew.Param16_T1Neg)) {
                        objLOD.LOD['Lower Limit'].oldValue = false;
                        objLOD.LOD['Lower Limit'].newValue = false;
                        IsChanged = false;
                    }
                    else {
                        objLOD.LOD['Lower Limit'].oldValue = objProductOld.Param16_T1Neg;
                        objLOD.LOD['Lower Limit'].newValue = objProductNew.Param16_T1Neg;
                        IsChanged = true;
                    }

                } else {

                    if ((objProductOld.Param16_T1Neg === null) && (objProductNew.Param16_T1Neg !== null)) {
                        objLOD.LOD['Lower Limit'].oldValue = "NA";
                        objLOD.LOD['Lower Limit'].newValue = objProductNew.Param16_T1Neg;
                        IsChanged = true;

                    } else if ((objProductOld.Param16_T1Neg !== null) && (objProductNew.Param16_T1Neg === null)) {
                        objLOD.LOD['Lower Limit'].oldValue = (objProductOld.Param16_T1Neg);
                        objLOD.LOD['Lower Limit'].newValue = "NA";
                        IsChanged = true;
                    }
                }
            }

            if (OldEmpty == true) {
                if (objProductNew.Param16_T1Pos != "" && objProductNew.Param16_T1Pos != undefined && objProductNew.Param16_T1Pos != 99999) {
                    objLOD.LOD['Upper Limit'].oldValue = "NA";
                    objLOD.LOD['Upper Limit'].newValue = objProductNew.Param16_T1Pos;
                    IsChanged = true;
                }
                else {
                    objLOD.LOD['Upper Limit'].oldValue = false;
                    objLOD.LOD['Upper Limit'].newValue = false;
                    IsChanged = false;
                }
            }
            else {
                if (objProductOld.Param16_T1Pos === "" ||
                    objProductOld.Param16_T1Pos == this.strNullValue ||
                    objProductOld.Param16_T1Pos == undefined) {
                    objProductOld.Param16_T1Pos = null;
                }

                if (objProductNew.Param16_T1Pos === "" ||
                    objProductNew.Param16_T1Pos == this.strNullValue ||
                    objProductNew.Param16_T1Pos == undefined) {
                    objProductNew.Param16_T1Pos = null;
                }

                if ((objProductOld.Param16_T1Pos !== null) && (objProductNew.Param16_T1Pos !== null)) {
                    if ((objProductOld.Param16_T1Pos) == (objProductNew.Param16_T1Pos)) {
                        objLOD.LOD['Upper Limit'].oldValue = false;
                        objLOD.LOD['Upper Limit'].newValue = false;
                        IsChanged != true ? IsChanged = false : IsChanged = true;
                    }
                    else {
                        objLOD.LOD['Upper Limit'].oldValue = (objProductOld.Param16_T1Pos);
                        objLOD.LOD['Upper Limit'].newValue = objProductNew.Param16_T1Pos;
                        IsChanged = true;
                    }

                } else {

                    if ((objProductOld.Param16_T1Pos === null) && (objProductNew.Param16_T1Pos !== null)) {
                        objLOD.LOD['Upper Limit'].oldValue = "NA";
                        objLOD.LOD['Upper Limit'].newValue = objProductNew.Param16_T1Pos;
                        IsChanged = true;

                    } else if ((objProductOld.Param16_T1Pos !== null) && (objProductNew.Param16_T1Pos === null)) {
                        objLOD.LOD['Upper Limit'].oldValue = (objProductOld.Param16_T1Pos);
                        objLOD.LOD['Upper Limit'].newValue = "NA";
                        IsChanged = true;
                    }
                }
            }

            
            if (OldEmpty == true) {
                if (objProductNew.Param16_Nom != "" && objProductNew.Param16_Nom != undefined && objProductNew.Param16_Nom != 99999) {
                    objLOD.LOD['Target'].oldValue = "NA";
                    objLOD.LOD['Target'].newValue = objProductNew.Param16_Nom;
                    IsChanged = true;
                }
                else {
                    objLOD.LOD['Target'].oldValue = false;
                    objLOD.LOD['Target'].newValue = false;
                    IsChanged = false;
                }
            }
            else {
                if (objProductOld.Param16_Nom === "" ||
                    objProductOld.Param16_Nom == this.strNullValue ||
                    objProductOld.Param16_Nom == undefined) {
                    objProductOld.Param16_Nom = null;
                }

                if (objProductNew.Param16_Nom === "" ||
                    objProductNew.Param16_Nom == this.strNullValue ||
                    objProductNew.Param16_Nom == undefined) {
                    objProductNew.Param16_Nom = null;
                }

                if ((objProductOld.Param16_Nom !== null) && (objProductNew.Param16_Nom !== null)) {
                    if ((objProductOld.Param16_Nom) == (objProductNew.Param16_Nom)) {
                        objLOD.LOD['Target'].oldValue = false;
                        objLOD.LOD['Target'].newValue = false;
                        IsChanged != true ? IsChanged = false : IsChanged = true;
                    }
                    else {
                        objLOD.LOD['Target'].oldValue = (objProductOld.Param16_Nom);
                        objLOD.LOD['Target'].newValue = objProductNew.Param16_Nom;
                        IsChanged = true;
                    }

                } else {

                    if ((objProductOld.Param16_Nom === null) && (objProductNew.Param16_Nom !== null)) {
                        objLOD.LOD['Target'].oldValue = "NA";
                        objLOD.LOD['Target'].newValue = objProductNew.Param16_Nom;
                        IsChanged = true;

                    } else if ((objProductOld.Param16_Nom !== null) && (objProductNew.Param16_Nom === null)) {
                        objLOD.LOD['Target'].oldValue = (objProductOld.Param16_Nom);
                        objLOD.LOD['Target'].newValue = "NA";
                        IsChanged = true;
                    }
                }
            }
            if (IsChanged == true) {
                Object.assign(this.objResult, objLOD);
            }
            resolve(IsChanged);
        });
    }

    validateNetMES(objProductOld, objProductNew) {
        return new Promise((resolve, reject) => {
            const objNet = {
                Differential: {
                    'Target': { oldValue: "", newValue: "" },
                    'Lower Limit': { oldValue: "", newValue: "" },
                    'Upper Limit': { oldValue: "", newValue: "" },
                    Unit:{ oldValue: "", newValue: "" },
                }
            };

            var IsChanged = false;
            var OldEmpty = objProductOld == undefined ? true : false;

             /**
             * For Empty NegT2
             */
             if (OldEmpty) {
                if (objProductNew.Param3_Nom != "" && objProductNew.Param3_Nom!=undefined) {
                    objNet.Differential['Target'].oldValue = "NA";
                    objNet.Differential['Target'].newValue = objProductNew.Param3_Nom;
                    IsChanged = true;
                }
                else {
                    objNet.Differential['Target'].oldValue = false;
                    objNet.Differential['Target'].newValue = false;
                    IsChanged = IsChanged != true ? false : true;
                }
            }
            else {
                if (objProductOld.Param3_Nom === "" ||
                    objProductOld.Param3_Nom == this.strNullValue ||
                    objProductOld.Param3_Nom == undefined) {
                    objProductOld.Param3_Nom = null;
                }

                if (objProductNew.Param3_Nom === "" || objProductNew.Param3_Nom == this.strNullValue || objProductNew.Param3_Nom == undefined) {
                    objProductNew.Param3_Nom = null;
                }

                if ((objProductOld.Param3_Nom !== null) && (objProductNew.Param3_Nom !== null)) {
                    if ((objProductOld.Param3_Nom) == (objProductNew.Param3_Nom)) {
                        objNet.Differential['Target'].oldValue = false;
                        objNet.Differential['Target'].newValue = false;
                        IsChanged != true ? IsChanged = false : IsChanged = true;
                    }
                    else {
                        objNet.Differential['Target'].oldValue = (objProductOld.Param3_Nom);
                        objNet.Differential['Target'].newValue = objProductNew.Param3_Nom;
                        IsChanged = true;
                    }
                } else {
                    if ((objProductOld.Param3_Nom === null) && (objProductNew.Param3_Nom !== null)) {
                        objNet.Differential['Target'].oldValue = "NA";
                        objNet.Differential['Target'].newValue = objProductNew.Param3_Nom;
                        IsChanged = true;

                    } else if ((objProductOld.Param3_Nom !== null) && (objProductNew.Param3_Nom === null)) {
                        objNet.Differential['Target'].oldValue = (objProductOld.Param3_Nom);
                        objNet.Differential['Target'].newValue = "NA";
                        IsChanged = true;
                    }
                }
            }



             /**
             * For Empty NegT2
             */
            if (OldEmpty) {
                if (objProductNew.Param3_T2Neg != "" && objProductNew.Param3_T2Neg!=undefined) {
                    objNet.Differential['Lower Limit'].oldValue = "NA";
                    objNet.Differential['Lower Limit'].newValue = objProductNew.Param3_T2Neg;
                    IsChanged = true;
                }
                else {
                    objNet.Differential['Lower Limit'].oldValue = false;
                    objNet.Differential['Lower Limit'].newValue = false;
                    IsChanged = IsChanged != true ? false : true;
                }
            }
            else {
                if (objProductOld.Param3_T2Neg === "" ||
                    objProductOld.Param3_T2Neg == this.strNullValue ||
                    objProductOld.Param3_T2Neg == undefined) {
                    objProductOld.Param3_T2Neg = null;
                }

                if (objProductNew.Param3_T2Neg === "" || objProductNew.Param3_T2Neg == this.strNullValue || objProductNew.Param3_T2Neg == undefined) {
                    objProductNew.Param3_T2Neg = null;
                }

                if ((objProductOld.Param3_T2Neg !== null) && (objProductNew.Param3_T2Neg !== null)) {
                    if ((objProductOld.Param3_T2Neg) == (objProductNew.Param3_T2Neg)) {
                        objNet.Differential['Lower Limit'].oldValue = false;
                        objNet.Differential['Lower Limit'].newValue = false;
                        IsChanged != true ? IsChanged = false : IsChanged = true;
                    }
                    else {
                        objNet.Differential['Lower Limit'].oldValue = (objProductOld.Param3_T2Neg);
                        objNet.Differential['Lower Limit'].newValue = objProductNew.Param3_T2Neg;
                        IsChanged = true;
                    }
                } else {
                    if ((objProductOld.Param3_T2Neg === null) && (objProductNew.Param3_T2Neg !== null)) {
                        objNet.Differential['Lower Limit'].oldValue = "NA";
                        objNet.Differential['Lower Limit'].newValue = objProductNew.Param3_T2Neg;
                        IsChanged = true;

                    } else if ((objProductOld.Param3_T2Neg !== null) && (objProductNew.Param3_T2Neg === null)) {
                        objNet.Differential['Lower Limit'].oldValue = (objProductOld.Param3_T2Neg);
                        objNet.Differential['Lower Limit'].newValue = "NA";
                        IsChanged = true;
                    }
                }
            }

             /**
             * For Empty PosT2
             */
            if (OldEmpty) {
                if (objProductNew.Param3_T2Pos != "" && objProductNew.Param3_T2Pos!=undefined) {
                    objNet.Differential['Upper Limit'].oldValue = "NA";
                    objNet.Differential['Upper Limit'].newValue = objProductNew.Param3_T2Pos;
                    IsChanged = true;
                }
                else {
                    objNet.Differential['Upper Limit'].oldValue = false;
                    objNet.Differential['Upper Limit'].newValue = false;
                    IsChanged = IsChanged != true ? false : true;
                }
            }
            else {
                if (objProductOld.Param3_T2Pos === "" ||
                    objProductOld.Param3_T2Pos == this.strNullValue ||
                    objProductOld.Param3_T2Pos == undefined) {
                    objProductOld.Param3_T2Pos = null;
                }

                if (objProductNew.Param3_T2Pos === "" ||
                    objProductNew.Param3_T2Pos == this.strNullValue ||
                    objProductNew.Param3_T2Pos == undefined) {
                    objProductNew.Param3_T2Pos = null;
                }

                if ((objProductOld.Param3_T2Pos !== null) && (objProductNew.Param3_T2Pos !== null)) {
                    if ((objProductOld.Param3_T2Pos) == (objProductNew.Param3_T2Pos)) {
                        objNet.Differential['Upper Limit'].oldValue = false;
                        objNet.Differential['Upper Limit'].newValue = false;
                        IsChanged != true ? IsChanged = false : IsChanged = true;
                    }
                    else {
                        objNet.Differential['Upper Limit'].oldValue = (objProductOld.Param3_T2Pos);
                        objNet.Differential['Upper Limit'].newValue = objProductNew.Param3_T2Pos;
                        IsChanged = true;
                    }

                } else {

                    if ((objProductOld.Param3_T2Pos === null) && (objProductNew.Param3_T2Pos !== null)) {
                        objNet.Differential['Upper Limit'].oldValue = "NA";
                        objNet.Differential['Upper Limit'].newValue = objProductNew.Param3_T2Pos;
                        IsChanged = true;

                    } else if ((objProductOld.Param3_T2Pos !== null) && (objProductNew.Param3_T2Pos === null)) {
                        objNet.Differential['Upper Limit'].oldValue = (objProductOld.Param3_T2Pos);
                        objNet.Differential['Upper Limit'].newValue = "NA";
                        IsChanged = true;
                    }
                }
            }

            // Unit
            if (OldEmpty) {
                if (objProductNew.Param3_Unit != "" && objProductNew.Param3_T2Neg != "" && objProductNew.Param3_Unit!=undefined && objProductNew.Param3_T2Neg!=undefined) {
                    objNet.Differential.Unit.oldValue = "NA";
                    objNet.Differential.Unit.newValue = objProductNew.Param3_Unit;
                    IsChanged = true;
                }
                else {
                    objNet.Differential.Unit.oldValue = false;
                    objNet.Differential.Unit.newValue = false;
                    IsChanged = IsChanged != true ? false : true;
                }
            }
            else {
                objProductOld.Param3_Unit == "NA" ? objProductOld.Param3_Unit = "gm" : objProductOld.Param3_Unit;

                if (objProductOld.Param3_T2Neg == null && objProductNew.Param3_T2Neg != null) { // new parameter added
                    objNet.Differential.Unit.oldValue = "gm";
                    objNet.Differential.Unit.newValue = objProductNew.Param3_Unit;
                    IsChanged = true;
                }
                else if (['NULL',null].includes(objProductOld.Param3_Unit) && (objProductNew.Param3_Unit == null || objProductNew.Param3_Unit == undefined)) // no parameter added
                {
                    objNet.Differential.Unit.oldValue = false;
                    objNet.Differential.Unit.newValue = false;
                    IsChanged = false;
                }
                else {
                    if (objProductOld.Param3_Unit == objProductNew.Param3_Unit) {
                        objNet.Differential.Unit.oldValue = false;
                        objNet.Differential.Unit.newValue = false;
                        IsChanged != true ? IsChanged = false : IsChanged = true;
                    }
                    else {
                        objNet.Differential.Unit.oldValue = objProductOld.Param3_Unit;
                        objNet.Differential.Unit.newValue = objProductNew.Param3_Unit;
                        IsChanged = true;
                    }
                }
            }


            if (IsChanged == true) {
                Object.assign(this.objResult, objNet);
            }
            resolve(IsChanged);
        })


    }

    validateEmptyMES(objProductOld, objProductNew) {
        return new Promise((resolve, reject) => {
            const objEmpty = {
                Empty: {
                    'Lower Limit': { oldValue: "", newValue: "" },
                    'Upper Limit': { oldValue: "", newValue: "" },
                    "Quantity (Initial)":{ oldValue: "", newValue: "" },
                    "Quantity (Regular)":{ oldValue: "", newValue: "" },
                    Unit:{ oldValue: "", newValue: "" },
                }
            };

            var IsChanged = false;
            var OldEmpty = objProductOld == undefined ? true : false;
           
            if (OldEmpty) {
                if (objProductNew.Param0_T2Neg != "" && objProductNew.Param0_T2Neg!=undefined) {
                    objEmpty.Empty['Lower Limit'].oldValue = "NA";
                    objEmpty.Empty['Lower Limit'].newValue = objProductNew.Param0_T2Neg;
                    IsChanged = true;
                }
                else {
                    objEmpty.Empty['Lower Limit'].oldValue = false;
                    objEmpty.Empty['Lower Limit'].newValue = false;
                    IsChanged = IsChanged != true ? false : true;
                }
            }
            else {
                if (objProductOld.Param0_T2Neg === "" ||
                    objProductOld.Param0_T2Neg == this.strNullValue ||
                    objProductOld.Param0_T2Neg == undefined) {
                    objProductOld.Param0_T2Neg = null;
                }

                if (objProductNew.Param0_T2Neg === "" || objProductNew.Param0_T2Neg == this.strNullValue || objProductNew.Param0_T2Neg == undefined) {
                    objProductNew.Param0_T2Neg = null;
                }

                if ((objProductOld.Param0_T2Neg !== null) && (objProductNew.Param0_T2Neg !== null)) {
                    if (parseFloat(objProductOld.Param0_T2Neg).toFixed(objProductOld.Param0_DP) == parseFloat(objProductNew.Param0_T2Neg).toFixed(objProductNew.Param0_DP)) {
                        objEmpty.Empty['Lower Limit'].oldValue = false;
                        objEmpty.Empty['Lower Limit'].newValue = false;
                        IsChanged != true ? IsChanged = false : IsChanged = true;
                    }
                    else {
                        objEmpty.Empty['Lower Limit'].oldValue = parseFloat(objProductOld.Param0_T2Neg).toFixed(objProductOld.Param0_DP);
                        objEmpty.Empty['Lower Limit'].newValue = objProductNew.Param0_T2Neg;
                        IsChanged = true;
                    }

                } else {

                    if ((objProductOld.Param0_T2Neg === null) && (objProductNew.Param0_T2Neg !== null)) {
                        objEmpty.Empty['Lower Limit'].oldValue = "NA";
                        objEmpty.Empty['Lower Limit'].newValue = objProductNew.Param0_T2Neg;
                        IsChanged = true;

                    } else if ((objProductOld.Param0_T2Neg !== null) && (objProductNew.Param0_T2Neg === null)) {
                        objEmpty.Empty['Lower Limit'].oldValue = parseFloat(objProductOld.Param0_T2Neg).toFixed(objProductOld.Param0_DP);
                        objEmpty.Empty['Lower Limit'].newValue = "NA";
                        IsChanged = true;
                    }
                }
            }

             /**
             * For Empty PosT2
             */
            if (OldEmpty) {
                if (objProductNew.Param0_T2Pos != "" && objProductNew.Param0_T2Pos!=undefined) {
                    objEmpty.Empty['Upper Limit'].oldValue = "NA";
                    objEmpty.Empty['Upper Limit'].newValue = objProductNew.Param0_T2Pos;
                    IsChanged = true;
                }
                else {
                    objEmpty.Empty['Upper Limit'].oldValue = false;
                    objEmpty.Empty['Upper Limit'].newValue = false;
                    IsChanged = IsChanged != true ? false : true;
                }
            }
            else {
                if (objProductOld.Param0_T2Pos === "" ||
                    objProductOld.Param0_T2Pos == this.strNullValue ||
                    objProductOld.Param0_T2Pos == undefined) {
                    objProductOld.Param0_T2Pos = null;
                }

                if (objProductNew.Param0_T2Pos === "" ||
                    objProductNew.Param0_T2Pos == this.strNullValue ||
                    objProductNew.Param0_T2Pos == undefined) {
                    objProductNew.Param0_T2Pos = null;
                }

                if ((objProductOld.Param0_T2Pos !== null) && (objProductNew.Param0_T2Pos !== null)) {
                    if (parseFloat(objProductOld.Param0_T2Pos).toFixed(objProductOld.Param0_DP) == parseFloat(objProductNew.Param0_T2Pos).toFixed(objProductNew.Param0_DP)) {
                        objEmpty.Empty['Upper Limit'].oldValue = false;
                        objEmpty.Empty['Upper Limit'].newValue = false;
                        IsChanged != true ? IsChanged = false : IsChanged = true;
                    }
                    else {
                        objEmpty.Empty['Upper Limit'].oldValue = parseFloat(objProductOld.Param0_T2Pos).toFixed(objProductOld.Param0_DP);
                        objEmpty.Empty['Upper Limit'].newValue = objProductNew.Param0_T2Pos;
                        IsChanged = true;
                    }

                } else {

                    if ((objProductOld.Param0_T2Pos === null) && (objProductNew.Param0_T2Pos !== null)) {
                        objEmpty.Empty['Upper Limit'].oldValue = "NA";
                        objEmpty.Empty['Upper Limit'].newValue = objProductNew.Param0_T2Pos;
                        IsChanged = true;

                    } else if ((objProductOld.Param0_T2Pos !== null) && (objProductNew.Param0_T2Pos === null)) {
                        objEmpty.Empty['Upper Limit'].oldValue = parseFloat(objProductOld.Param0_T2Pos).toFixed(objProductOld.Param0_DP);
                        objEmpty.Empty['Upper Limit'].newValue = "NA";
                        IsChanged = true;
                    }
                }
            }

            if (OldEmpty) {
                if (objProductNew.Param0_Unit != "" && objProductNew.Param0_T2Neg != "" && objProductNew.Param0_Unit!=undefined && objProductNew.Param0_T2Neg!=undefined) {
                    objEmpty.Empty.Unit.oldValue = "NA";
                    objEmpty.Empty.Unit.newValue = objProductNew.Param0_Unit;
                    IsChanged = true;
                }
                else {
                    objEmpty.Empty.Unit.oldValue = false;
                    objEmpty.Empty.Unit.newValue = false;
                    IsChanged = IsChanged != true ? false : true;
                }
            }
            else {
                objProductOld.Param0_Unit == "NA" ? objProductOld.Param0_Unit = "gm" : objProductOld.Param0_Unit;
                if (objProductOld.Param0_T2Neg == null && objProductNew.Param0_T2Neg != null) { // new parameter added
                    objEmpty.Empty.Unit.oldValue = "gm";
                    objEmpty.Empty.Unit.newValue = objProductNew.Param0_Unit;
                    IsChanged = true;
                }
                else if (objProductOld.Param0_Unit == null && objProductNew.Param0_Unit == null) // no parameter added
                {
                    objEmpty.Empty.Unit.oldValue = false;
                    objEmpty.Empty.Unit.newValue = false;
                    IsChanged = false;
                }
                else {
                    if (objProductOld.Param0_Unit == objProductNew.Param0_Unit) {
                        objEmpty.Empty.Unit.oldValue = false;
                        objEmpty.Empty.Unit.newValue = false;
                        IsChanged != true ? IsChanged = false : IsChanged = true;
                    }
                    else {
                        objEmpty.Empty.Unit.oldValue = objProductOld.Param0_Unit;
                        objEmpty.Empty.Unit.newValue = objProductNew.Param0_Unit;
                        IsChanged = true;
                    }
                }
            }

            if (IsChanged == true) {
                Object.assign(this.objResult, objEmpty);
            }

            resolve(IsChanged);
        })


    }

    async validateCompressedParamsMES(objProductOld, objProductNew) {
        var PRD = await this.validatePrdDtlsMES(objProductOld, objProductNew);
        var Ind = await this.validateIndividualMES(objProductOld, objProductNew);
        var Grp = await this.validateGroupMES(objProductOld, objProductNew);
        var Thick = await this.validateThicknessMES(objProductOld, objProductNew);
        var Hard = await this.validateHardnessMES(objProductOld, objProductNew);
        var Fri = await this.validateFriabilityMES(objProductOld, objProductNew);
        var DT = await this.validateDTMES(objProductOld, objProductNew);
        // var Brd = await this.validateBreadthMES(objProductOld, objProductNew);
        // var Len = await this.validateLengthMES(objProductOld, objProductNew,1);
        // var Dia = await this.validateDiameterMES(objProductOld, objProductNew);
     
        var LOD = await this.validateLODMES(objProductOld, objProductNew);
        // var Ind1 = await this.validateIndLayer1MES(objProductOld, objProductNew);
        // var Grp1 = await this.validateGrpLayer1MES(objProductOld, objProductNew);

        // var MPN = await this.validateMPNCode(objProductOld, objProductNew);

        if (
            //  Brd != true &&  Len != true && Dia != true != true && Ind1 != true && Grp1 != true
            Ind != true && Grp != true && Thick != true && Hard != true && Fri !=true  && DT != true && LOD != true && PRD != true
           )
        {
            return "No Change";
        }
        else {
            var strChanged = "";
            var strNewValue = "";

            //"Individual : Nominal : value,Group : Nominal : value"
            IterateObject(this.objResult, function (value, key1) {
                //console.log(key1);
                strChanged = strChanged + "|";
                strNewValue = strNewValue + "|";

                var obj = value;
                IterateObject(obj, (value, key) => {
                    if ((value.oldValue !== false) && ((value.oldValue !== "") && (value.newValue !== ""))) {
                        strChanged = strChanged + key1 + "-";
                        strChanged = strChanged + key + ":";
                        // if Old Value is NaN then prev that product is not having that parameters hence make it NA
                        strChanged = strChanged + ((value.oldValue == null || value.oldValue == "NaN") ? "NA" : value.oldValue) + ", ";
                        if (strChanged.includes("null:null:null")) {
                            strChanged = strChanged.replace(/null/g, "NA");
                        }

                        strNewValue = strNewValue + key1 + "-";
                        strNewValue = strNewValue + key + ":";
                        strNewValue = strNewValue + ((value.newValue == null || value.newValue == "NaN" || value.newValue==999999) ? "NA" : value.newValue) + ", ";
                        if (strNewValue.includes("null:null:null")) {
                            strNewValue = strNewValue.replace(/null/g, "NA");
                        }
                    }

                });
            });

            return { oldData: strChanged.slice(1), newData: strNewValue.slice(1) };
        }
    }

    async validateCapsuleParamsMES(objProductOld, objProductNew) {
        var Ind = await this.validateIndividualMES(objProductOld, objProductNew);
        var Grp = await this.validateGroupMES(objProductOld, objProductNew);
        var Net = await this.validateNetMES(objProductOld, objProductNew);
       // let Empty = await this.validateEmptyMES(objProductOld, objProductNew);
        var Len = await this.validateLengthMES(objProductOld, objProductNew,2);
        var Dt = await this.validateCapsuleDTMES(objProductOld,objProductNew);
        var EmptyGrp = await this.validateEmptyGroupMES(objProductOld, objProductNew);

        if (Ind != true && Grp != true && Len != true && Net != true && Dt != true && EmptyGrp != true)
        {
            return "No Change";
        }
        else {
            var strChanged = "";
            var strNewValue = "";

            //"Individual : Nominal : value,Group : Nominal : value"
            IterateObject(this.objResult, function (value, key1) {
                //console.log(key1);
                strChanged = strChanged + "|";
                strNewValue = strNewValue + "|";

                var obj = value;
                IterateObject(obj, (value, key) => {
                    if ((value.oldValue !== false) && ((value.oldValue !== "") && (value.newValue !== ""))) {
                        strChanged = strChanged + key1 + "-";
                        strChanged = strChanged + key + ":";
                        // if Old Value is NaN then prev that product is not having that parameters hence make it NA
                        strChanged = strChanged + ((value.oldValue == null || value.oldValue == "NaN") ? "NA" : value.oldValue) + ", ";
                        if (strChanged.includes("null:null:null")) {
                            strChanged = strChanged.replace(/null/g, "NA");
                        }

                        strNewValue = strNewValue + key1 + "-";
                        strNewValue = strNewValue + key + ":";
                        strNewValue = strNewValue + ((value.newValue == null || value.newValue == "NaN") ? "NA" : value.newValue) + ", ";
                        if (strNewValue.includes("null:null:null")) {
                            strNewValue = strNewValue.replace(/null/g, "NA");
                        }
                    }

                });
            });

            return { oldData: strChanged.slice(1), newData: strNewValue.slice(1) };
        }
    }

    //DRL MES Validation
    validateIndividual(objProductOld, objProductNew) {
        return new Promise((resolve, reject) => {
            const objIndividual = {
                Individual: {
                    Nom: { oldValue: "", newValue: "" },
                    // T1Neg: { oldValue: "", newValue: "" },
                    // T1Pos: { oldValue: "", newValue: "" },
                    'Lower Limit': { oldValue: "", newValue: "" },
                    'Upper Limit': { oldValue: "", newValue: "" },
                    T2Neg: { oldValue: "", newValue: "" },
                    T2Pos: { oldValue: "", newValue: "" },
                    NMT: { oldValue: "", newValue: "" },
                    LimitOn: { oldValue: "", newValue: "" },
                    ReportOn: { oldValue: "", newValue: "" },
                    Nomenclature: { oldValue: "", newValue: "" },
                    Unit:{ oldValue: "", newValue: "" },
                    "Quantity (Initial)":{ oldValue: "", newValue: "" },
                    "Quantity (Regular)":{ oldValue: "", newValue: "" }
                }
            };

            var IsChanged = false;
            var OldEmpty = objProductOld == undefined ? true : false;
            /**
             * For Individual Nom
             */
            /*
            if (OldEmpty == true) {
                if (objProductNew.flt_IndStd != "" && objProductNew.flt_IndStd!=undefined) {
                    objIndividual.Individual.Nom.oldValue = "NA";
                    objIndividual.Individual.Nom.newValue = objProductNew.flt_IndStd;
                    IsChanged = true;
                }
                else {
                    objIndividual.Individual.Nom.oldValue = false;
                    objIndividual.Individual.Nom.newValue = false;
                    IsChanged = false;
                }
            }
            else {
                if (objProductOld.Param1_Nom === "" ||
                    objProductOld.Param1_Nom == this.strNullValue ||
                    objProductOld.Param1_Nom == undefined) {
                    objProductOld.Param1_Nom = null;
                }

                if (objProductNew.flt_IndStd === "" ||
                    objProductNew.flt_IndStd == this.strNullValue) {
                    objProductNew.flt_IndStd = null;
                }

                if ((objProductOld.Param1_Nom !== null) && (objProductNew.flt_IndStd !== null))
                {
                    if (parseFloat(objProductOld.Param1_Nom).toFixed(objProductOld.Param1_DP) == parseFloat(objProductNew.flt_IndStd).toFixed(objProductNew.int_IndDP)) {
                        objIndividual.Individual.Nom.oldValue = false;
                        objIndividual.Individual.Nom.newValue = false;
                        IsChanged = false;
                    }
                    else {
                        objIndividual.Individual.Nom.oldValue = parseFloat(objProductOld.Param1_Nom).toFixed(objProductOld.Param1_DP);
                        objIndividual.Individual.Nom.newValue = objProductNew.flt_IndStd;
                        IsChanged = true;
                    }

                } else {

                    if ((objProductOld.Param1_Nom === null) && (objProductNew.flt_IndStd !== null)) {
                        objIndividual.Individual.Nom.oldValue = "NA";
                        objIndividual.Individual.Nom.newValue = objProductNew.flt_IndStd;
                        IsChanged = true;

                    } else if ((objProductOld.Param1_Nom !== null) && (objProductNew.flt_IndStd === null)) {
                        objIndividual.Individual.Nom.oldValue = parseFloat(objProductOld.Param1_Nom).toFixed(objProductOld.Param1_DP);
                        objIndividual.Individual.Nom.newValue = "NA";
                        IsChanged = true;
                    }
                }
            }
            */

            /**
             * For Individual NegT1
             */
            if (OldEmpty) {
                if (objProductNew.flt_IndT1Neg != "" && objProductNew.flt_IndT1Neg!=undefined) {
                    objIndividual.Individual['Lower Limit'].oldValue = "NA";
                    objIndividual.Individual['Lower Limit'].newValue = objProductNew.flt_IndT1Neg;
                    IsChanged = true;
                }
                else {
                    objIndividual.Individual['Lower Limit'].oldValue = false;
                    objIndividual.Individual['Lower Limit'].newValue = false;
                    IsChanged = IsChanged != true ? false : true;
                }
            }
            else {
                if (objProductOld.Param1_T1Neg === "" ||
                    objProductOld.Param1_T1Neg == this.strNullValue ||
                    objProductOld.Param1_T1Neg == undefined) {
                    objProductOld.Param1_T1Neg = null;
                }

                if (objProductNew.flt_IndT1Neg === "" || objProductNew.flt_IndT1Neg == this.strNullValue || objProductNew.flt_IndT1Neg == undefined) {
                    objProductNew.flt_IndT1Neg = null;
                }

                if ((objProductOld.Param1_T1Neg !== null) && (objProductNew.flt_IndT1Neg !== null)) {
                    if (parseFloat(objProductOld.Param1_T1Neg).toFixed(objProductOld.Param1_DP) == parseFloat(objProductNew.flt_IndT1Neg).toFixed(objProductNew.int_IndDP)) {
                        objIndividual.Individual['Lower Limit'].oldValue = false;
                        objIndividual.Individual['Lower Limit'].newValue = false;
                        IsChanged != true ? IsChanged = false : IsChanged = true;
                    }
                    else {
                        objIndividual.Individual['Lower Limit'].oldValue = parseFloat(objProductOld.Param1_T1Neg).toFixed(objProductOld.Param1_DP);
                        objIndividual.Individual['Lower Limit'].newValue = objProductNew.flt_IndT1Neg;
                        IsChanged = true;
                    }

                } else {

                    if ((objProductOld.Param1_T1Neg === null) && (objProductNew.flt_IndT1Neg !== null)) {
                        objIndividual.Individual['Lower Limit'].oldValue = "NA";
                        objIndividual.Individual['Lower Limit'].newValue = objProductNew.flt_IndT1Neg;
                        IsChanged = true;

                    } else if ((objProductOld.Param1_T1Neg !== null) && (objProductNew.flt_IndT1Neg === null)) {
                        objIndividual.Individual['Lower Limit'].oldValue = parseFloat(objProductOld.Param1_T1Neg).toFixed(objProductOld.Param1_DP);
                        objIndividual.Individual['Lower Limit'].newValue = "NA";
                        IsChanged = true;
                    }
                }
            }
            
            /**
             * For Individual PosT1
             */
            if (OldEmpty) {
                if (objProductNew.flt_IndT1Pos != "" && objProductNew.flt_IndT1Pos!=undefined) {
                    objIndividual.Individual['Upper Limit'].oldValue = "NA";
                    objIndividual.Individual['Upper Limit'].newValue = objProductNew.flt_IndT1Pos;
                    IsChanged = true;
                }
                else {
                    objIndividual.Individual['Upper Limit'].oldValue = false;
                    objIndividual.Individual['Upper Limit'].newValue = false;
                    IsChanged = IsChanged != true ? false : true;
                }
            }
            else {
                if (objProductOld.Param1_T1Pos === "" ||
                    objProductOld.Param1_T1Pos == this.strNullValue ||
                    objProductOld.Param1_T1Pos == undefined) {
                    objProductOld.Param1_T1Pos = null;
                }

                if (objProductNew.flt_IndT1Pos === "" ||
                    objProductNew.flt_IndT1Pos == this.strNullValue ||
                    objProductNew.flt_IndT1Pos == undefined) {
                    objProductNew.flt_IndT1Pos = null;
                }

                if ((objProductOld.Param1_T1Pos !== null) && (objProductNew.flt_IndT1Pos !== null)) {
                    if (parseFloat(objProductOld.Param1_T1Pos).toFixed(objProductOld.Param1_DP) == parseFloat(objProductNew.flt_IndT1Pos).toFixed(objProductNew.int_IndDP)) {
                        objIndividual.Individual['Upper Limit'].oldValue = false;
                        objIndividual.Individual['Upper Limit'].newValue = false;
                        IsChanged != true ? IsChanged = false : IsChanged = true;
                    }
                    else {
                        objIndividual.Individual['Upper Limit'].oldValue = parseFloat(objProductOld.Param1_T1Pos).toFixed(objProductOld.Param1_DP);
                        objIndividual.Individual['Upper Limit'].newValue = objProductNew.flt_IndT1Pos;
                        IsChanged = true;
                    }

                } else {

                    if ((objProductOld.Param1_T1Pos === null) && (objProductNew.flt_IndT1Pos !== null)) {
                        objIndividual.Individual['Upper Limit'].oldValue = "NA";
                        objIndividual.Individual['Upper Limit'].newValue = objProductNew.flt_IndT1Pos;
                        IsChanged = true;

                    } else if ((objProductOld.Param1_T1Pos !== null) && (objProductNew.flt_IndT1Pos === null)) {
                        objIndividual.Individual['Upper Limit'].oldValue = parseFloat(objProductOld.Param1_T1Pos).toFixed(objProductOld.Param1_DP);
                        objIndividual.Individual['Upper Limit'].newValue = "NA";
                        IsChanged = true;
                    }
                }
            }


            /**
             * For Individual Initial Quantity
             */
            if (OldEmpty) {
                if (objProductNew.int_IndQtyInitial != "" && objProductNew.int_IndQtyInitial!=undefined) {
                    objIndividual.Individual['Quantity (Initial)'].oldValue = "NA";
                    objIndividual.Individual['Quantity (Initial)'].newValue = Number(objProductNew.int_IndQtyInitial);
                    IsChanged = true;
                }
                else {
                    objIndividual.Individual['Quantity (Initial)'].oldValue = false;
                    objIndividual.Individual['Quantity (Initial)'].newValue = false;
                    IsChanged = IsChanged != true ? false : true;
                }
            }
            else {
                if (objProductOld.Param1_IniQty === "" ||
                    objProductOld.Param1_IniQty == this.strNullValue ||
                    objProductOld.Param1_IniQty == undefined) {
                    objProductOld.Param1_IniQty = null;
                }

                if (objProductNew.int_IndQtyInitial === "" || objProductNew.int_IndQtyInitial == this.strNullValue || objProductNew.int_IndQtyInitial == undefined) {
                    objProductNew.int_IndQtyInitial = null;
                }

                if ((objProductOld.Param1_IniQty !== null) && (objProductNew.int_IndQtyInitial !== null)) {
                    if (Number(objProductOld.Param1_IniQty) == Number(objProductNew.int_IndQtyInitial)) {
                        objIndividual.Individual['Quantity (Initial)'].oldValue = false;
                        objIndividual.Individual['Quantity (Initial)'].newValue = false;
                        IsChanged != true ? IsChanged = false : IsChanged = true;
                    }
                    else {
                        objIndividual.Individual['Quantity (Initial)'].oldValue = objProductOld.Param1_IniQty;
                        objIndividual.Individual['Quantity (Initial)'].newValue = Number(objProductNew.int_IndQtyInitial);
                        IsChanged = true;
                    }

                } else {

                    if ((objProductOld.Param1_IniQty === null) && (objProductNew.int_IndQtyInitial !== null)) {
                        objIndividual.Individual['Quantity (Initial)'].oldValue = "NA";
                        objIndividual.Individual['Quantity (Initial)'].newValue = Number(objProductNew.int_IndQtyInitial);
                        IsChanged = true;

                    } else if ((objProductOld.Param1_IniQty !== null) && (objProductNew.int_IndQtyInitial === null)) {
                        objIndividual.Individual['Quantity (Initial)'].oldValue = objProductOld.Param1_IniQty;
                        objIndividual.Individual['Quantity (Initial)'].newValue = "NA";
                        IsChanged = true;
                    }
                }
            }
            
            /**
             * For Individual Quantity Regular
             */
            if (OldEmpty) {
                if (objProductNew.int_IndQtyRegular != "" && objProductNew.int_IndQtyRegular!=undefined) {
                    objIndividual.Individual['Quantity (Regular)'].oldValue = "NA";
                    objIndividual.Individual['Quantity (Regular)'].newValue = Number(objProductNew.int_IndQtyRegular);
                    IsChanged = true;
                }
                else {
                    objIndividual.Individual['Quantity (Regular)'].oldValue = false;
                    objIndividual.Individual['Quantity (Regular)'].newValue = false;
                    IsChanged = IsChanged != true ? false : true;
                }
            }
            else {
                if (objProductOld.Param1_RegQty === "" ||
                    objProductOld.Param1_RegQty == this.strNullValue ||
                    objProductOld.Param1_RegQty == undefined) {
                    objProductOld.Param1_RegQty = null;
                }

                if (objProductNew.int_IndQtyRegular === "" || objProductNew.int_IndQtyRegular == this.strNullValue || objProductNew.int_IndQtyRegular == undefined) {
                    objProductNew.int_IndQtyRegular = null;
                }

                if ((objProductOld.Param1_RegQty !== null) && (objProductNew.int_IndQtyRegular !== null)) {
                    if (Number(objProductOld.Param1_RegQty)== Number(objProductNew.int_IndQtyRegular)) {
                        objIndividual.Individual['Quantity (Regular)'].oldValue = false;
                        objIndividual.Individual['Quantity (Regular)'].newValue = false;
                        IsChanged != true ? IsChanged = false : IsChanged = true;
                    }
                    else {
                        objIndividual.Individual['Quantity (Regular)'].oldValue = objProductOld.Param1_RegQty;
                        objIndividual.Individual['Quantity (Regular)'].newValue = Number(objProductNew.int_IndQtyRegular);
                        IsChanged = true;
                    }

                } else {

                    if ((objProductOld.Param1_RegQty === null) && (objProductNew.int_IndQtyRegular !== null)) {
                        objIndividual.Individual['Quantity (Regular)'].oldValue = "NA";
                        objIndividual.Individual['Quantity (Regular)'].newValue = Number(objProductNew.int_IndQtyRegular);
                        IsChanged = true;

                    } else if ((objProductOld.Param1_RegQty !== null) && (objProductNew.int_IndQtyRegular === null)) {
                        objIndividual.Individual['Quantity (Regular)'].oldValue = objProductOld.Param1_RegQty;
                        objIndividual.Individual['Quantity (Regular)'].newValue = "NA";
                        IsChanged = true;
                    }
                }
            }
            
            /**
            * For Individual NegT2
            if (OldEmpty) {
                if (objProductNew.flt_IndT2Neg != "" && objProductNew.flt_IndT2Neg!=undefined) {
                    objIndividual.Individual.T2Neg.oldValue = "NA";
                    objIndividual.Individual.T2Neg.newValue = objProductNew.flt_IndT2Neg;
                    IsChanged = true;
                }
                else {
                    objIndividual.Individual.T2Neg.oldValue = false;
                    objIndividual.Individual.T2Neg.newValue = false;
                    IsChanged = IsChanged != true ? false : true;
                }
            }
            else {
                if (objProductOld.Param1_T2Neg === "" ||
                    objProductOld.Param1_T2Neg == this.strNullValue ||
                    objProductOld.Param1_T2Neg == undefined) {
                    objProductOld.Param1_T2Neg = null;
                }

                if (objProductNew.flt_IndT2Neg === "" ||
                    objProductNew.flt_IndT2Neg == this.strNullValue ||
                    objProductNew.flt_IndT2Neg == undefined) {
                    objProductNew.flt_IndT2Neg = null;
                }

                if ((objProductOld.Param1_T2Neg !== null) && (objProductNew.flt_IndT2Neg !== null)) {
                    if (parseFloat(objProductOld.Param1_T2Neg).toFixed(objProductOld.Param1_DP) == parseFloat(objProductNew.flt_IndT2Neg).toFixed(objProductNew.int_IndDP)) {
                        objIndividual.Individual.T2Neg.oldValue = false;
                        objIndividual.Individual.T2Neg.newValue = false;
                        IsChanged != true ? IsChanged = false : IsChanged = true;
                    }
                    else {
                        objIndividual.Individual.T2Neg.oldValue = parseFloat(objProductOld.Param1_T2Neg).toFixed(objProductOld.Param1_DP);
                        objIndividual.Individual.T2Neg.newValue = objProductNew.flt_IndT2Neg;
                        IsChanged = true;
                    }

                } else {

                    if ((objProductOld.Param1_T2Neg === null) && (objProductNew.flt_IndT2Neg !== null)) {
                        objIndividual.Individual.T2Neg.oldValue = "NA";
                        objIndividual.Individual.T2Neg.newValue = objProductNew.flt_IndT2Neg;
                        IsChanged = true;

                    } else if ((objProductOld.Param1_T2Neg !== null) && (objProductNew.flt_IndT2Neg === null)) {
                        objIndividual.Individual.T2Neg.oldValue = parseFloat(objProductOld.Param1_T2Neg).toFixed(objProductOld.Param1_DP);
                        objIndividual.Individual.T2Neg.newValue = "NA";
                        IsChanged = true;
                    }
                }
            }
            */
            
            /**
            * For Individual PosT2
            if (OldEmpty) {
                if (objProductNew.flt_IndT2Pos != "" && objProductNew.flt_IndT2Pos!=undefined) {
                    objIndividual.Individual.T2Pos.oldValue = "NA";
                    objIndividual.Individual.T2Pos.newValue = objProductNew.flt_IndT2Pos;
                    IsChanged = true;
                }
                else {
                    objIndividual.Individual.T2Pos.oldValue = false;
                    objIndividual.Individual.T2Pos.newValue = false;
                    IsChanged = IsChanged != true ? false : true;
                }
            }
            else {
                if (objProductOld.Param1_T2Pos === "" ||
                    objProductOld.Param1_T2Pos == this.strNullValue ||
                    objProductOld.Param1_T2Pos == undefined) {
                    objProductOld.Param1_T2Pos = null;
                }

                if (objProductNew.flt_IndT2Pos === "" ||
                    objProductNew.flt_IndT2Pos == this.strNullValue ||
                    objProductNew.flt_IndT2Pos == undefined) {
                    objProductNew.flt_IndT2Pos = null;
                }

                if ((objProductOld.Param1_T2Pos !== null) && (objProductNew.flt_IndT2Pos !== null)) {
                    if (parseFloat(objProductOld.Param1_T2Pos).toFixed(objProductOld.Param1_DP) == parseFloat(objProductNew.flt_IndT2Pos).toFixed(objProductNew.int_IndDP)) {
                        objIndividual.Individual.T2Pos.oldValue = false;
                        objIndividual.Individual.T2Pos.newValue = false;
                        IsChanged != true ? IsChanged = false : IsChanged = true;
                    }
                    else {
                        objIndividual.Individual.T2Pos.oldValue = parseFloat(objProductOld.Param1_T2Pos).toFixed(objProductOld.Param1_DP);
                        objIndividual.Individual.T2Pos.newValue = objProductNew.flt_IndT2Pos;
                        IsChanged = true;
                    }

                } else {

                    if ((objProductOld.Param1_T2Pos === null) && (objProductNew.flt_IndT2Pos !== null)) {
                        objIndividual.Individual.T2Pos.oldValue = "NA";
                        objIndividual.Individual.T2Pos.newValue = objProductNew.flt_IndT2Pos;
                        IsChanged = true;

                    } else if ((objProductOld.Param1_T2Pos !== null) && (objProductNew.flt_IndT2Pos === null)) {
                        objIndividual.Individual.T2Pos.oldValue = parseFloat(objProductOld.Param1_T2Pos).toFixed(objProductOld.Param1_DP);
                        objIndividual.Individual.T2Pos.newValue = "NA";
                        IsChanged = true;
                    }
                }
            }
            */

            /**
            * For Individual NMT
            if (OldEmpty) {
                if (objProductNew.int_IndNMTTabCnt != "" && objProductNew.int_IndNMTTabCnt!=undefined) {
                    objIndividual.Individual.NMT.oldValue = "NA";
                    objIndividual.Individual.NMT.newValue = objProductNew.int_IndNMTTabCnt;
                    IsChanged = true;
                }
                else {
                    objIndividual.Individual.NMT.oldValue = false;
                    objIndividual.Individual.NMT.newValue = false;
                    IsChanged = IsChanged != true ? false : true;
                }
            }
            else {
                if (objProductOld.Param1_NMTTab == 0 ||
                    objProductOld.Param1_NMTTab == this.NMTValue ||
                    objProductOld.Param1_NMTTab == undefined) {
                    objProductOld.Param1_NMTTab = 0;
                }

                objProductNew.int_IndNMTTabCnt = objProductNew.int_IndNMTTabCnt === "" ? this.strNullValue : objProductNew.int_IndNMTTabCnt;
                
                if (objProductNew.int_IndNMTTabCnt == "0" ||
                    objProductNew.int_IndNMTTabCnt == this.NMTValue ||
                    objProductNew.int_IndNMTTabCnt == undefined) {
                    objProductNew.int_IndNMTTabCnt = 0;
                }

                if (parseInt(objProductOld.Param1_NMTTab) == parseInt(objProductNew.int_IndNMTTabCnt)) {
                    objIndividual.Individual.NMT.oldValue = false;
                    objIndividual.Individual.NMT.newValue = false;
                    IsChanged != true ? IsChanged = false : IsChanged = true;
                }
                else {
                    objIndividual.Individual.NMT.oldValue = objProductOld.Param1_NMTTab;
                    objIndividual.Individual.NMT.newValue = objProductNew.int_IndNMTTabCnt;
                    IsChanged = true;
                }
            }
            */
            
            /**
             * For Individual Limits On Actual / Percent
            if (OldEmpty) {
                if (objProductNew.str_IndLimitOn != "" && objProductNew.flt_IndStd != "" && objProductNew.flt_IndStd!=undefined && objProductNew.str_IndLimitOn!=undefined) {
                    objIndividual.Individual.LimitOn.oldValue = "NA";
                    objIndividual.Individual.LimitOn.newValue = objProductNew.str_IndLimitOn;
                    IsChanged = true;
                }
                else {
                    objIndividual.Individual.LimitOn.oldValue = false;
                    objIndividual.Individual.LimitOn.newValue = false;
                    IsChanged = IsChanged != true ? false : true;
                }
            }
            else {
                if (objProductOld.Param1_Nom === "" ||
                    objProductOld.Param1_Nom == this.strNullValue ||
                    objProductOld.Param1_Nom == undefined) 
                {
                    const strLimitOn1 = objProductOld.Param1_LimitOn == 0 ? "Actual" : "Percentage";
                    if(strLimitOn1 == objProductNew.str_IndLimitOn){
                        objIndividual.Individual.LimitOn.oldValue = false;
                        objIndividual.Individual.LimitOn.newValue = false;
                        IsChanged = false;
                    }else{
                        objIndividual.Individual.LimitOn.oldValue = strLimitOn1;
                        objIndividual.Individual.LimitOn.newValue = objProductNew.str_IndLimitOn;
                        IsChanged = true;
                    }
                }
                else {
                    const strLimitOn = objProductOld.Param1_LimitOn == 0 ? "Actual" : "Percentage";
                    if (objProductOld.Param1_Nom == null && objProductNew.flt_IndStd != null) { // new parameter added
                        objIndividual.Individual.LimitOn.oldValue = "NA";
                        objIndividual.Individual.LimitOn.newValue = objProductNew.str_IndLimitOn;
                        IsChanged = true;
                    }
                    else if (objProductOld.Param1_Nom == null && objProductNew.flt_IndStd == null) // no parameter added
                    {
                        objIndividual.Individual.LimitOn.oldValue = false;
                        objIndividual.Individual.LimitOn.newValue = false;
                        IsChanged = false;
                    }
                    else {
                        if (strLimitOn == objProductNew.str_IndLimitOn) {
                            objIndividual.Individual.LimitOn.oldValue = false;
                            objIndividual.Individual.LimitOn.newValue = false;
                            IsChanged != true ? IsChanged = false : IsChanged = true;
                        }
                        else {
                            objIndividual.Individual.LimitOn.oldValue = strLimitOn;
                            objIndividual.Individual.LimitOn.newValue = objProductNew.str_IndLimitOn;
                            IsChanged = true;
                        }
                    }
                }
            }
             */

            /**
             * For Individual Limits On Standard / Avg
            if (OldEmpty) {
                if (objProductNew.str_IndGraphOn != "" && objProductNew.flt_IndStd != "" && objProductNew.str_IndGraphOn!=undefined && objProductNew.flt_IndStd!=undefined) {
                    objIndividual.Individual.ReportOn.oldValue = "NA";
                    objIndividual.Individual.ReportOn.newValue = objProductNew.str_IndGraphOn;
                    IsChanged = true;
                }
                else {
                    objIndividual.Individual.ReportOn.oldValue = false;
                    objIndividual.Individual.ReportOn.newValue = false;
                    IsChanged = IsChanged != true ? false : true;
                }
            }
            else {
                const strGraphOn = objProductOld.Param1_IsOnStd == 0 ? "Standard" : "Average";
                if (objProductOld.Param1_Nom == null && objProductNew.flt_IndStd != null) { // new parameter added
                    objIndividual.Individual.ReportOn.oldValue = "NA";
                    objIndividual.Individual.ReportOn.newValue = objProductNew.str_IndGraphOn;
                    IsChanged = true;
                }
                else if (objProductOld.Param1_Nom == null && objProductNew.flt_IndStd == null) // no parameter added
                {
                    objIndividual.Individual.ReportOn.oldValue = false;
                    objIndividual.Individual.ReportOn.newValue = false;
                    IsChanged = false;
                }
                else {
                    if (strGraphOn == objProductNew.str_IndGraphOn) {
                        objIndividual.Individual.ReportOn.oldValue = false;
                        objIndividual.Individual.ReportOn.newValue = false;
                        IsChanged != true ? IsChanged = false : IsChanged = true;
                    }
                    else {
                        objIndividual.Individual.ReportOn.oldValue = strGraphOn;
                        objIndividual.Individual.ReportOn.newValue = objProductNew.str_IndGraphOn;
                        IsChanged = true;
                    }
                }
            }
             */

            /** Nominal Nomenclature is static 
             * 
            if (OldEmpty) {
                if (objProductNew.str_ind_nomNomnclature != "" && objProductNew.flt_IndStd != "" && objProductNew.str_ind_nomNomnclature!=undefined && objProductNew.flt_IndStd!=undefined) {
                    objIndividual.Individual.Nomenclature.oldValue = "NA";
                    objIndividual.Individual.Nomenclature.newValue = objProductNew.str_ind_nomNomnclature;
                    IsChanged = true;
                }
                else {
                    objIndividual.Individual.Nomenclature.oldValue = false;
                    objIndividual.Individual.Nomenclature.newValue = false;
                    IsChanged = IsChanged != true ? false : true;
                }
            }
            else {

                if (objProductOld.Param1_Nom == null && objProductNew.flt_IndStd != null) { // new parameter added
                    objIndividual.Individual.Nomenclature.oldValue = "NA";
                    objIndividual.Individual.Nomenclature.newValue = objProductNew.str_ind_nomNomnclature;
                    IsChanged = true;
                }
                else if (objProductOld.Param1_Nom == null && objProductNew.flt_IndStd == null) // no parameter added
                {
                    objIndividual.Individual.Nomenclature.oldValue = false;
                    objIndividual.Individual.Nomenclature.newValue = false;
                    IsChanged = false;
                }
                else {
                    if (objProductOld.Param1_Nomenclature == objProductNew.str_ind_nomNomnclature) {
                        objIndividual.Individual.Nomenclature.oldValue = false;
                        objIndividual.Individual.Nomenclature.newValue = false;
                        IsChanged != true ? IsChanged = false : IsChanged = true;
                    }
                    else {
                        objIndividual.Individual.Nomenclature.oldValue = objProductOld.Param1_Nomenclature;
                        objIndividual.Individual.Nomenclature.newValue = objProductNew.str_ind_nomNomnclature;
                        IsChanged = true;
                    }
                }
            }
            if (OldEmpty) {
                if (objProductNew.str_indUnit != "" && objProductNew.flt_IndStd != "" && objProductNew.str_indUnit!=undefined && objProductNew.flt_IndStd!=undefined) {
                    objIndividual.Individual.Unit.oldValue = "NA";
                    objIndividual.Individual.Unit.newValue = objProductNew.str_indUnit;
                    IsChanged = true;
                }
                else {
                    objIndividual.Individual.Unit.oldValue = false;
                    objIndividual.Individual.Unit.newValue = false;
                    IsChanged = IsChanged != true ? false : true;
                }
            }
            else {
                objProductOld.Param1_Unit == "NA" ? objProductOld.Param1_Unit = "gm" : objProductOld.Param1_Unit;
                if (objProductOld.Param1_Nom == null && objProductNew.flt_IndStd != null) { // new parameter added
                    objIndividual.Individual.Unit.oldValue = "gm";
                    objIndividual.Individual.Unit.newValue = objProductNew.str_indUnit;
                    IsChanged = true;
                }
                else if (objProductOld.Param1_Unit == null && objProductNew.str_indUnit == null) // no parameter added
                {
                    objIndividual.Individual.Unit.oldValue = false;
                    objIndividual.Individual.Unit.newValue = false;
                    IsChanged = false;
                }
                else {
                    if (objProductOld.Param1_Unit == objProductNew.str_indUnit) {
                        objIndividual.Individual.Unit.oldValue = false;
                        objIndividual.Individual.Unit.newValue = false;
                        IsChanged != true ? IsChanged = false : IsChanged = true;
                    }
                    else {
                        objIndividual.Individual.Unit.oldValue = objProductOld.Param1_Unit;
                        objIndividual.Individual.Unit.newValue = objProductNew.str_indUnit;
                        IsChanged = true;
                    }
                }
            }
             */


            if (IsChanged == true) {
                Object.assign(this.objResult, objIndividual);
            }
            resolve(IsChanged);
        });
    }

    validateCapsuleDTMES(objProductOld, objProductNew) {
        return new Promise((resolve, reject) => {
            const objDT = {
                DT: {
                    Time: { oldValue: "", newValue: "" },
                //     DTMinTemp: { oldValue: "", newValue: "" },
                //     DTMaxTemp: { oldValue: "", newValue: "" }
                }
            };

            var IsChanged = false;
            var OldEmpty = objProductOld == undefined ? true : false;


            /**
             * For DT Time 
             */
            if (OldEmpty == true) {
                if (objProductNew.Param6_Nom != "" && objProductNew.Param6_Nom != undefined) {
                    objDT.DT.Time.oldValue = "NA";
                    objDT.DT.Time.newValue = objProductNew.Param6_Nom;
                    IsChanged = true;
                }
                else {
                    objDT.DT.Time.oldValue = false;
                    objDT.DT.Time.newValue = false;
                    IsChanged = false;
                }
            }
            else {
                if (objProductOld.Param6_Nom === "" ||
                    objProductOld.Param6_Nom == this.strNullValue ||
                    objProductOld.Param6_Nom == undefined) {
                    objProductOld.Param6_Nom = null;
                }

                if (objProductNew.Param6_Nom === "" ||
                    objProductNew.Param6_Nom == this.strNullValue ||
                    objProductNew.Param6_Nom == undefined) {
                    objProductNew.Param6_Nom = null;
                }

                if ((objProductOld.Param6_Nom === null || objProductOld.Param6_Nom == 'NULL') && (objProductNew.Param6_Nom === null || objProductNew.Param6_Nom == 'NULL')) {
                        objDT.DT.Time.oldValue = false;
                        objDT.DT.Time.newValue = false;
                        IsChanged = false;
                }
                else if (objProductOld.Param6_Nom == objProductNew.Param6_Nom) {
                    objDT.DT.Time.oldValue = false;
                    objDT.DT.Time.newValue = false;
                    IsChanged = false;
                }
                else {
                    objDT.DT.Time.oldValue = objProductOld.Param6_Nom;
                    objDT.DT.Time.newValue = objProductNew.Param6_Nom;
                    IsChanged = true;
                }
            }


            // /**
            //  * For DT Time 
            //  */
            // if (OldEmpty == true) {
            //     if (objProductNew.int_DTMMTime != "" && objProductNew.int_DTMMTime != undefined) {
            //         objDT.DT.DTTime.oldValue = "NA";
            //         objDT.DT.DTTime.newValue = objProductNew.int_DTHHTime + ":" + objProductNew.int_DTMMTime + ":" + objProductNew.int_DTSSTime;
            //         IsChanged = true;
            //     }
            //     else {
            //         objDT.DT.DTTime.oldValue = false;
            //         objDT.DT.DTTime.newValue = false;
            //         IsChanged = false;
            //     }
            // }
            // else {
            //     if (objProductOld.Param13_Nom === "" ||
            //         objProductOld.Param13_Nom == this.strNullValue ||
            //         objProductOld.Param13_Nom == undefined) {
            //         objProductOld.Param13_Nom = null;
            //     }

            //     if (objProductNew.int_DTHHTime === "" ||
            //         objProductNew.int_DTHHTime == this.strNullValue ||
            //         objProductNew.int_DTHHTime == undefined) {
            //         objProductNew.int_DTHHTime = null;
            //     }

            //     if (objProductNew.int_DTMMTime === "" ||
            //         objProductNew.int_DTMMTime == this.strNullValue ||
            //         objProductNew.int_DTMMTime == undefined) {
            //         objProductNew.int_DTMMTime = null;
            //     }

            //     if (objProductNew.int_DTSSTime === "" ||
            //         objProductNew.int_DTSSTime == this.strNullValue ||
            //         objProductNew.int_DTSSTime == undefined) {
            //         objProductNew.int_DTSSTime = null;
            //     }

            //     if ((objProductOld.Param13_Nom === null) && (objProductNew.int_DTHHTime === null) && 
            //         (objProductNew.int_DTMMTime === null) && (objProductNew.int_DTSSTime === null)) {
            //             objDT.DT.DTTime.oldValue = false;
            //             objDT.DT.DTTime.newValue = false;
            //             IsChanged = false;
            //     }
            //     else if (objProductOld.Param13_Nom == (objProductNew.int_DTHHTime + ":" + objProductNew.int_DTMMTime + ":" + objProductNew.int_DTSSTime)) {
            //         objDT.DT.DTTime.oldValue = false;
            //         objDT.DT.DTTime.newValue = false;
            //         IsChanged = false;
            //     }
            //     else {
            //         objDT.DT.DTTime.oldValue = objProductOld.Param13_Nom;
            //         objDT.DT.DTTime.newValue = objProductNew.int_DTHHTime + ":" + objProductNew.int_DTMMTime + ":" + objProductNew.int_DTSSTime;
            //         IsChanged = true;
            //     }
            // }

            // /**
            //  * For DT Min Temp
            //  */
            // if (OldEmpty == true) {
            //     if ((objProductNew.flt_DTMinTemp != "") && (objProductNew.flt_DTMinTemp != 99999) && objProductNew.flt_DTMinTemp != undefined) {
            //         objDT.DT.DTMinTemp.oldValue = "NA";
            //         objDT.DT.DTMinTemp.newValue = objProductNew.flt_DTMinTemp;
            //         IsChanged = true;
            //     }
            //     else {
            //         objDT.DT.DTMinTemp.oldValue = false;
            //         objDT.DT.DTMinTemp.newValue = false;
            //         IsChanged = false;
            //     }
            // }
            // else {
            //     if (objProductOld.Param13_T1Neg === "" ||
            //         objProductOld.Param13_T1Neg == this.strNullValue ||
            //         objProductOld.Param13_T1Neg == undefined) {
            //         objProductOld.Param13_T1Neg = null;
            //     }

            //     if (objProductNew.flt_DTMinTemp === "" ||
            //         objProductNew.flt_DTMinTemp == this.strNullValue ||
            //         objProductNew.flt_DTMinTemp == undefined) {
            //         objProductNew.flt_DTMinTemp = null;
            //     }

            //     if ((objProductOld.Param13_T1Neg !== null) && (objProductNew.flt_DTMinTemp !== null)) {
            //         if (parseFloat(objProductOld.Param13_T1Neg).toFixed(objProductOld.Param13_DP) == parseFloat(objProductNew.flt_DTMinTemp).toFixed(objProductNew.int_DTDp)) {
            //             objDT.DT.DTMinTemp.oldValue = false;
            //             objDT.DT.DTMinTemp.newValue = false;
            //             IsChanged != true ? IsChanged = false : IsChanged = true;

            //         } else {
            //             objDT.DT.DTMinTemp.oldValue = parseFloat(objProductOld.Param13_T1Neg).toFixed(objProductOld.Param13_DP);
            //             objDT.DT.DTMinTemp.newValue = objProductNew.flt_DTMinTemp;
            //             IsChanged = true;
            //         }

            //     } else if((objProductOld.Param13_T1Neg == null) && (objProductNew.flt_DTMinTemp == '99999')) {
            //         objDT.DT.DTMinTemp.oldValue = false;
            //         objDT.DT.DTMinTemp.newValue = false;
            //         IsChanged != true ? IsChanged = false : IsChanged = true;

            //     } else {

            //         if ((objProductOld.Param13_T1Neg === null) && (objProductNew.flt_DTMinTemp !== null)) {
            //             objDT.DT.DTMinTemp.oldValue = "NA";
            //             objDT.DT.DTMinTemp.newValue = objProductNew.flt_DTMinTemp;
            //             IsChanged = true;

            //         } else if ((objProductOld.Param13_T1Neg !== null) && (objProductNew.flt_DTMinTemp === null)) {
            //             objDT.DT.DTMinTemp.oldValue = parseFloat(objProductOld.Param13_T1Neg).toFixed(objProductOld.Param13_DP);
            //             objDT.DT.DTMinTemp.newValue = "NA";
            //             IsChanged = true;
            //         }
            //     }
            // }

            // /**
            //  * For DT Max Temp
            //  */
            // if (OldEmpty == true) {
            //     if ((objProductNew.flt_DTMaxTemp != "") && (objProductNew.flt_DTMaxTemp != 99999) && objProductNew.flt_DTMaxTemp != undefined) {
            //         objDT.DT.DTMaxTemp.oldValue = "NA";
            //         objDT.DT.DTMaxTemp.newValue = objProductNew.flt_DTMaxTemp;
            //         IsChanged = true;
            //     }
            //     else {
            //         objDT.DT.DTMaxTemp.oldValue = false;
            //         objDT.DT.DTMaxTemp.newValue = false;
            //         IsChanged = false;
            //     }
            // }
            // else {
            //     if (objProductOld.Param13_T1Pos === "" ||
            //         objProductOld.Param13_T1Pos == this.strNullValue ||
            //         objProductOld.Param13_T1Pos == undefined) {
            //         objProductOld.Param13_T1Pos = null;
            //     }

            //     if (objProductNew.flt_DTMaxTemp === "" ||
            //         objProductNew.flt_DTMaxTemp == this.strNullValue ||
            //         objProductNew.flt_DTMaxTemp == undefined) {
            //         objProductNew.flt_DTMaxTemp = null;
            //     }

            //     if ((objProductOld.Param13_T1Pos !== null) && (objProductNew.flt_DTMaxTemp !== null)) {
            //         if (parseFloat(objProductOld.Param13_T1Pos).toFixed(objProductOld.Param13_DP) == parseFloat(objProductNew.flt_DTMaxTemp).toFixed(objProductNew.int_DTDp)) {
            //             objDT.DT.DTMaxTemp.oldValue = false;
            //             objDT.DT.DTMaxTemp.newValue = false;
            //             IsChanged != true ? IsChanged = false : IsChanged = true;

            //         } else {
            //             objDT.DT.DTMaxTemp.oldValue = parseFloat(objProductOld.Param13_T1Pos).toFixed(objProductOld.Param13_DP);
            //             objDT.DT.DTMaxTemp.newValue = objProductNew.flt_DTMaxTemp;
            //             IsChanged = true;
            //         }

            //     } else if((objProductOld.Param13_T1Pos == null) && (objProductNew.flt_DTMaxTemp == '99999')){
            //         objDT.DT.DTMaxTemp.oldValue = false;
            //         objDT.DT.DTMaxTemp.newValue = false;
            //         IsChanged != true ? IsChanged = false : IsChanged = true;

            //     } else {

            //         if ((objProductOld.Param13_T1Pos === null) && (objProductNew.flt_DTMaxTemp !== null)) {
            //             objDT.DT.DTMaxTemp.oldValue = "NA";
            //             objDT.DT.DTMaxTemp.newValue = objProductNew.flt_DTMaxTemp;
            //             IsChanged = true;

            //         } else if ((objProductOld.Param13_T1Pos !== null) && (objProductNew.flt_DTMaxTemp === null)) {
            //             objDT.DT.DTMaxTemp.oldValue = parseFloat(objProductOld.Param13_T1Pos).toFixed(objProductOld.Param13_DP);
            //             objDT.DT.DTMaxTemp.newValue = "NA";
            //             IsChanged = true;
            //         }
            //     }
            // }
            
            if (IsChanged == true) {
                Object.assign(this.objResult, objDT);
            }
            resolve(IsChanged);
        });
    }

    validateEmptyGroupMES(objProductOld, objProductNew) {
        return new Promise((resolve, reject) => {
            const objGroup = {
                Group: {
                    'Target': { oldValue: "", newValue: "" },
                    'Lower Limit': { oldValue: "", newValue: "" },
                    'Upper Limit': { oldValue: "", newValue: "" },
                    Unit: { oldValue: "", newValue: "" },
                    // "Quantity (Initial)":{ oldValue: "", newValue: "" },
                    // "Quantity (Regular)":{ oldValue: "", newValue: "" }
                }
            };

            var IsChanged = false;
            var OldEmpty = objProductOld == undefined ? true : false;

            /**
             * For Group NegT2
             */
            if (OldEmpty) {
                if (objProductNew.Param19_T2Neg != "" && objProductNew.Param19_T2Neg!=undefined && objProductNew.Param19_T2Neg != 99999) {
                    objGroup.Group['Lower Limit'].oldValue = "NA";
                    objGroup.Group['Lower Limit'].newValue = objProductNew.Param19_T2Neg;
                    IsChanged = true;
                }
                else {
                    objGroup.Group['Lower Limit'].oldValue = false;
                    objGroup.Group['Lower Limit'].newValue = false;
                    IsChanged = IsChanged != true ? false : true;
                }
            }
            else {
                if (objProductOld.Param19_T2Neg === "" ||
                    objProductOld.Param19_T2Neg == this.strNullValue ||
                    objProductOld.Param19_T2Neg == undefined) {
                    objProductOld.Param19_T2Neg = null;
                }

                objProductNew.Param19_T2Neg = objProductNew.Param19_T2Neg === "" ? this.strNullValue : objProductNew.Param19_T2Neg;
                
                if (objProductNew.Param19_T2Neg === "" ||
                    objProductNew.Param19_T2Neg == this.strNullValue ||
                    objProductNew.Param19_T2Neg == undefined) {
                    objProductNew.Param19_T2Neg = null;
                }

                if ((objProductOld.Param19_T2Neg !== null) && (objProductNew.Param19_T2Neg !== null)) {
                    if (objProductOld.Param19_T2Neg == objProductNew.Param19_T2Neg) {
                        objGroup.Group['Lower Limit'].oldValue = false;
                        objGroup.Group['Lower Limit'].newValue = false;
                        IsChanged != true ? IsChanged = false : IsChanged = true;
                    }
                    else {
                        objGroup.Group['Lower Limit'].oldValue = objProductOld.Param19_T2Neg;
                        objGroup.Group['Lower Limit'].newValue = objProductNew.Param19_T2Neg;
                        IsChanged = true;
                    }

                } else {

                    if ((objProductOld.Param19_T2Neg === null) && (objProductNew.Param19_T2Neg !== null)) {
                        objGroup.Group['Lower Limit'].oldValue = "NA";
                        objGroup.Group['Lower Limit'].newValue = objProductNew.Param19_T2Neg;
                        IsChanged = true;

                    } else if ((objProductOld.Param19_T2Neg !== null) && (objProductNew.Param19_T2Neg === null)) {
                        objGroup.Group['Lower Limit'].oldValue = objProductOld.Param19_T2Neg;
                        objGroup.Group['Lower Limit'].newValue = "NA";
                        IsChanged = true;
                    }
                }
            }

            /**
             * For Group PosT2
             */
            if (OldEmpty) {
                if (objProductNew.Param19_T2Pos != "" && objProductNew.Param19_T2Pos!=undefined) {
                    objGroup.Group['Upper Limit'].oldValue = "NA";
                    objGroup.Group['Upper Limit'].newValue = objProductNew.Param19_T2Pos;
                    IsChanged = true;
                }
                else {
                    objGroup.Group['Upper Limit'].oldValue = false;
                    objGroup.Group['Upper Limit'].newValue = false;
                    IsChanged = IsChanged != true ? false : true;
                }
            }
            else {
                if (objProductOld.Param19_T2Pos === "" ||
                    objProductOld.Param19_T2Pos == this.strNullValue ||
                    objProductOld.Param19_T2Pos == undefined) {
                    objProductOld.Param19_T2Pos = null;
                }

                objProductNew.Param19_T2Pos = objProductNew.Param19_T2Pos === "" ? this.strNullValue : objProductNew.Param19_T2Pos;
                
                if (objProductNew.Param19_T2Pos === "" ||
                    objProductNew.Param19_T2Pos == this.strNullValue ||
                    objProductNew.Param19_T2Pos == undefined) {
                    objProductNew.Param19_T2Pos = null;
                }

                if ((objProductOld.Param19_T2Pos !== null) && (objProductNew.Param19_T2Pos !== null)) {
                    if (objProductOld.Param19_T2Pos == objProductNew.Param19_T2Pos) {
                        objGroup.Group['Upper Limit'].oldValue = false;
                        objGroup.Group['Upper Limit'].newValue = false;
                        IsChanged != true ? IsChanged = false : IsChanged = true;
                    }
                    else {
                        objGroup.Group['Upper Limit'].oldValue = objProductOld.Param19_T2Pos;
                        objGroup.Group['Upper Limit'].newValue = objProductNew.Param19_T2Pos;
                        IsChanged = true;
                    }

                } else {

                    if ((objProductOld.Param19_T2Pos === null) && (objProductNew.Param19_T2Pos !== null)) {
                        objGroup.Group['Upper Limit'].oldValue = "NA";
                        objGroup.Group['Upper Limit'].newValue = objProductNew.Param19_T2Pos;
                        IsChanged = true;

                    } else if ((objProductOld.Param19_T2Pos !== null) && (objProductNew.Param19_T2Pos === null)) {
                        objGroup.Group['Upper Limit'].oldValue = objProductOld.Param19_T2Pos;
                        objGroup.Group['Upper Limit'].newValue = "NA";
                        IsChanged = true;
                    }
                }
            }

            /* For Group Nom*/
            if (OldEmpty) {
                if (objProductNew.Param19_Nom != "" && objProductNew.Param19_Nom != undefined) {
                    objGroup.Group['Target'].oldValue = "NA";
                    objGroup.Group['Target'].newValue = objProductNew.Param19_Nom;
                    IsChanged = true;
                }
                else {
                    objGroup.Group['Target'].oldValue = false;
                    objGroup.Group['Target'].newValue = false;
                    IsChanged = IsChanged != true ? false : true;
                }
            }
            else {
                if (objProductOld.Param19_Nom === "" ||
                    objProductOld.Param19_Nom == this.strNullValue ||
                    objProductOld.Param19_Nom == undefined) {
                    objProductOld.Param19_Nom = null;
                }

                objProductNew.Param19_Nom = objProductNew.Param19_Nom === "" ? this.strNullValue : objProductNew.Param19_Nom;

                if (objProductNew.Param19_Nom === "" ||
                    objProductNew.Param19_Nom == this.strNullValue ||
                    objProductNew.Param19_Nom == undefined) {
                    objProductNew.Param19_Nom = null;
                }

                if ((objProductOld.Param19_Nom !== null) && (objProductNew.Param19_Nom !== null)) {
                    if (objProductOld.Param19_Nom == objProductNew.Param19_Nom) {
                        objGroup.Group['Target'].oldValue = false;
                        objGroup.Group['Target'].newValue = false;
                        IsChanged != true ? IsChanged = false : IsChanged = true;
                    }
                    else {
                        objGroup.Group['Target'].oldValue = objProductOld.Param19_Nom;
                        objGroup.Group['Target'].newValue = objProductNew.Param19_Nom;
                        IsChanged = true;
                    }

                } else {

                    if ((objProductOld.Param19_Nom === null) && (objProductNew.Param19_Nom !== null)) {
                        objGroup.Group['Target'].oldValue = "NA";
                        objGroup.Group['Target'].newValue = objProductNew.Param19_Nom;
                        IsChanged = true;

                    } else if ((objProductOld.Param19_Nom !== null) && (objProductNew.Param19_Nom === null)) {
                        objGroup.Group['Target'].oldValue = objProductOld.Param19_Nom;
                        objGroup.Group['Target'].newValue = "NA";
                        IsChanged = true;
                    }
                }
            }
            
            if (OldEmpty) {
                if (objProductNew.Param19_Unit != "" && objProductNew.Param19_T2Neg != "" && objProductNew.Param19_Unit!=undefined && objProductNew.Param19_T2Neg!=undefined) {
                    objGroup.Group.Unit.oldValue = "NA";
                    objGroup.Group.Unit.newValue = objProductNew.Param19_Unit;
                    IsChanged = true;
                }
                else {
                    objGroup.Group.Unit.oldValue = false;
                    objGroup.Group.Unit.newValue = false;
                    IsChanged = IsChanged != true ? false : true;
                }
            }
            else {
                const strGraphOn = objProductOld.Param19_Unit == 0 ? "gm" : objProductOld.Param19_Unit;
                if (objProductOld.Param19_Nom == null && objProductNew.Param19_T2Neg != null) { // new parameter added
                    objGroup.Group.Unit.oldValue = "NA";
                    objGroup.Group.Unit.newValue = objProductNew.Param19_Unit;
                    IsChanged = true;
                }
                else if (['NULL',null].includes(objProductOld.Param19_Unit) && objProductNew.Param19_Unit == null) // no parameter added
                {
                    objGroup.Group.Unit.oldValue = false;
                    objGroup.Group.Unit.newValue = false;
                    IsChanged = false;
                }
                else {
                    if (strGraphOn == objProductNew.Param19_Unit) {
                        objGroup.Group.Unit.oldValue = false;
                        objGroup.Group.Unit.newValue = false;
                        IsChanged != true ? IsChanged = false : IsChanged = true;
                    }
                    else {
                        objGroup.Group.Unit.oldValue = strGraphOn;
                        objGroup.Group.Unit.newValue = objProductNew.Param19_Unit;
                        IsChanged = true;
                    }
                }
            }

            if (IsChanged == true) {
                Object.assign(this.objResult, objGroup);
            }
            resolve(IsChanged);
        });
    }

    validateGroup(objProductOld, objProductNew) {
        return new Promise((resolve, reject) => {
            const objGroup = {
                Group: {
                    Nom: { oldValue: "", newValue: "" },
                    // T1Neg: { oldValue: "", newValue: "" },
                    // T1Pos: { oldValue: "", newValue: "" },
                    'Lower Limit': { oldValue: "", newValue: "" },
                    'Upper Limit': { oldValue: "", newValue: "" },
                    T2Neg: { oldValue: "", newValue: "" },
                    T2Pos: { oldValue: "", newValue: "" },
                    NMT: { oldValue: "", newValue: "" },
                    LimitOn: { oldValue: "", newValue: "" },
                    ReportOn: { oldValue: "", newValue: "" },
                    Unit: { oldValue: "", newValue: "" },
                    "Quantity (Initial)":{ oldValue: "", newValue: "" },
                    "Quantity (Regular)":{ oldValue: "", newValue: "" }
                }
            };

            var IsChanged = false;
            var OldEmpty = objProductOld == undefined ? true : false;
            /**
             * For Individual Nom
            if (OldEmpty) {
                if (objProductNew.flt_GrpStd != "" && objProductNew.flt_GrpStd!=undefined) {
                    objGroup.Group.Nom.oldValue = "NA";
                    objGroup.Group.Nom.newValue = objProductNew.flt_GrpStd;
                    IsChanged = true;
                }
                else {
                    objGroup.Group.Nom.oldValue = false;
                    objGroup.Group.Nom.newValue = false;
                    IsChanged = IsChanged != true ? false : true;
                }
            }
            else {
                if (objProductOld.Param2_Nom === "" ||
                    objProductOld.Param2_Nom == this.strNullValue ||
                    objProductOld.Param2_Nom == undefined) {
                    objProductOld.Param2_Nom = null;
                }

                objProductNew.flt_GrpStd = objProductNew.flt_GrpStd === "" ? this.strNullValue : objProductNew.flt_GrpStd;

                if (objProductNew.flt_GrpStd === "" ||
                    objProductNew.flt_GrpStd == this.strNullValue ||
                    objProductNew.flt_GrpStd == undefined) {
                    objProductNew.flt_GrpStd = null;
                }

                if ((objProductOld.Param2_Nom !== null) && (objProductNew.flt_GrpStd !== null)) {
                    if (parseFloat(objProductOld.Param2_Nom).toFixed(objProductOld.Param2_DP) == parseFloat(objProductNew.flt_GrpStd).toFixed(objProductNew.int_Grpdp)) {
                        objGroup.Group.Nom.oldValue = false;
                        objGroup.Group.Nom.newValue = false;
                        IsChanged = false;
                    }
                    else {
                        objGroup.Group.Nom.oldValue = parseFloat(objProductOld.Param2_Nom).toFixed(objProductOld.Param2_DP);
                        objGroup.Group.Nom.newValue = objProductNew.flt_GrpStd;
                        IsChanged = true;
                    }

                } else {

                    if ((objProductOld.Param2_Nom === null) && (objProductNew.flt_GrpStd !== null)) {
                        objGroup.Group.Nom.oldValue = "NA";
                        objGroup.Group.Nom.newValue = objProductNew.flt_GrpStd;
                        IsChanged = true;

                    } else if ((objProductOld.Param2_Nom !== null) && (objProductNew.flt_GrpStd === null)) {
                        objGroup.Group.Nom.oldValue = parseFloat(objProductOld.Param2_Nom).toFixed(objProductOld.Param2_DP);
                        objGroup.Group.Nom.newValue = "NA";
                        IsChanged = true;
                    }
                }
            }
             */

            /**
             * For Individual NegT1
             */
            if (OldEmpty) {
                if (objProductNew.flt_GrpT1Neg != "" && objProductNew.flt_GrpT1Neg!=undefined) {
                    objGroup.Group['Lower Limit'].oldValue = "NA";
                    objGroup.Group['Lower Limit'].newValue = objProductNew.flt_GrpT1Neg;
                    IsChanged = true;
                }
                else {
                    objGroup.Group['Lower Limit'].oldValue = false;
                    objGroup.Group['Lower Limit'].newValue = false;
                    IsChanged = IsChanged != true ? false : true;
                }
            }
            else {
                if (objProductOld.Param2_T1Neg === "" ||
                    objProductOld.Param2_T1Neg == this.strNullValue ||
                    objProductOld.Param2_T1Neg == undefined) {
                    objProductOld.Param2_T1Neg = null;
                }

                objProductNew.flt_GrpT1Neg = objProductNew.flt_GrpT1Neg === "" ? this.strNullValue : objProductNew.flt_GrpT1Neg;
                
                if (objProductNew.flt_GrpT1Neg === "" ||
                    objProductNew.flt_GrpT1Neg == this.strNullValue ||
                    objProductNew.flt_GrpT1Neg == undefined) {
                    objProductNew.flt_GrpT1Neg = null;
                }

                if ((objProductOld.Param2_T1Neg !== null) && (objProductNew.flt_GrpT1Neg !== null)) {
                    if (parseFloat(objProductOld.Param2_T1Neg).toFixed(objProductOld.Param2_DP) == parseFloat(objProductNew.flt_GrpT1Neg).toFixed(objProductNew.int_Grpdp)) {
                        objGroup.Group['Lower Limit'].oldValue = false;
                        objGroup.Group['Lower Limit'].newValue = false;
                        IsChanged != true ? IsChanged = false : IsChanged = true;
                    }
                    else {
                        objGroup.Group['Lower Limit'].oldValue = parseFloat(objProductOld.Param2_T1Neg).toFixed(objProductOld.Param2_DP);
                        objGroup.Group['Lower Limit'].newValue = objProductNew.flt_GrpT1Neg;
                        IsChanged = true;
                    }

                } else {

                    if ((objProductOld.Param2_T1Neg === null) && (objProductNew.flt_GrpT1Neg !== null)) {
                        objGroup.Group['Lower Limit'].oldValue = "NA";
                        objGroup.Group['Lower Limit'].newValue = objProductNew.flt_GrpT1Neg;
                        IsChanged = true;

                    } else if ((objProductOld.Param2_T1Neg !== null) && (objProductNew.flt_GrpT1Neg === null)) {
                        objGroup.Group['Lower Limit'].oldValue = parseFloat(objProductOld.Param2_T1Neg).toFixed(objProductOld.Param2_DP);
                        objGroup.Group['Lower Limit'].newValue = "NA";
                        IsChanged = true;
                    }
                }
            }

            /**
             * For Individual PosT1
             */
            if (OldEmpty) {
                if (objProductNew.flt_GrpT1Pos != "" && objProductNew.flt_GrpT1Pos!=undefined) {
                    objGroup.Group['Upper Limit'].oldValue = "NA";
                    objGroup.Group['Upper Limit'].newValue = objProductNew.flt_GrpT1Pos;
                    IsChanged = true;
                }
                else {
                    objGroup.Group['Upper Limit'].oldValue = false;
                    objGroup.Group['Upper Limit'].newValue = false;
                    IsChanged = IsChanged != true ? false : true;
                }
            }
            else {
                if (objProductOld.Param2_T1Pos === "" ||
                    objProductOld.Param2_T1Pos == this.strNullValue ||
                    objProductOld.Param2_T1Pos == undefined) {
                    objProductOld.Param2_T1Pos = null;
                }

                objProductNew.flt_GrpT1Pos = objProductNew.flt_GrpT1Pos === "" ? this.strNullValue : objProductNew.flt_GrpT1Pos;
                
                if (objProductNew.flt_GrpT1Pos === "" ||
                    objProductNew.flt_GrpT1Pos == this.strNullValue ||
                    objProductNew.flt_GrpT1Pos == undefined) {
                    objProductNew.flt_GrpT1Pos = null;
                }

                if ((objProductOld.Param2_T1Pos !== null) && (objProductNew.flt_GrpT1Pos !== null)) {
                    if (parseFloat(objProductOld.Param2_T1Pos).toFixed(objProductOld.Param2_DP) == parseFloat(objProductNew.flt_GrpT1Pos).toFixed(objProductNew.int_Grpdp)) {
                        objGroup.Group['Upper Limit'].oldValue = false;
                        objGroup.Group['Upper Limit'].newValue = false;
                        IsChanged != true ? IsChanged = false : IsChanged = true;
                    }
                    else {
                        objGroup.Group['Upper Limit'].oldValue = parseFloat(objProductOld.Param2_T1Pos).toFixed(objProductOld.Param2_DP);
                        objGroup.Group['Upper Limit'].newValue = objProductNew.flt_GrpT1Pos;
                        IsChanged = true;
                    }

                } else {

                    if ((objProductOld.Param2_T1Pos === null) && (objProductNew.flt_GrpT1Pos !== null)) {
                        objGroup.Group['Upper Limit'].oldValue = "NA";
                        objGroup.Group['Upper Limit'].newValue = objProductNew.flt_GrpT1Pos;
                        IsChanged = true;

                    } else if ((objProductOld.Param2_T1Pos !== null) && (objProductNew.flt_GrpT1Pos === null)) {
                        objGroup.Group['Upper Limit'].oldValue = parseFloat(objProductOld.Param2_T1Pos).toFixed(objProductOld.Param2_DP);
                        objGroup.Group['Upper Limit'].newValue = "NA";
                        IsChanged = true;
                    }
                }
            }

            /**
             * For Group Initial Quantity
             */
            if (OldEmpty) {
                if (objProductNew.int_GrpQtyInitial != "" && objProductNew.int_GrpQtyInitial!=undefined) {
                    objGroup.Group['Quantity (Initial)'].oldValue = "NA";
                    objGroup.Group['Quantity (Initial)'].newValue = Number(objProductNew.int_GrpQtyInitial);
                    IsChanged = true;
                }
                else {
                    objGroup.Group['Quantity (Initial)'].oldValue = false;
                    objGroup.Group['Quantity (Initial)'].newValue = false;
                    IsChanged = IsChanged != true ? false : true;
                }
            }
            else {
                if (objProductOld.Param2_IniQty === "" ||
                    objProductOld.Param2_IniQty == this.strNullValue ||
                    objProductOld.Param2_IniQty == undefined) {
                    objProductOld.Param2_IniQty = null;
                }

                if (objProductNew.int_GrpQtyInitial === "" || objProductNew.int_GrpQtyInitial == this.strNullValue || objProductNew.int_GrpQtyInitial == undefined) {
                    objProductNew.int_GrpQtyInitial = null;
                }

                if ((objProductOld.Param2_IniQty !== null) && (objProductNew.int_GrpQtyInitial !== null)) {
                    if (Number(objProductOld.Param2_IniQty) == Number(objProductNew.int_GrpQtyInitial)) {
                        objGroup.Group['Quantity (Initial)'].oldValue = false;
                        objGroup.Group['Quantity (Initial)'].newValue = false;
                        IsChanged != true ? IsChanged = false : IsChanged = true;
                    }
                    else {
                        objGroup.Group['Quantity (Initial)'].oldValue = objProductOld.Param2_IniQty;
                        objGroup.Group['Quantity (Initial)'].newValue = Number(objProductNew.int_GrpQtyInitial);
                        IsChanged = true;
                    }

                } else {

                    if ((objProductOld.Param2_IniQty === null) && (objProductNew.int_GrpQtyInitial !== null)) {
                        objGroup.Group['Quantity (Initial)'].oldValue = "NA";
                        objGroup.Group['Quantity (Initial)'].newValue = Number(objProductNew.int_GrpQtyInitial);
                        IsChanged = true;

                    } else if ((objProductOld.Param2_IniQty !== null) && (objProductNew.int_GrpQtyInitial === null)) {
                        objGroup.Group['Quantity (Initial)'].oldValue = objProductOld.Param2_IniQty;
                        objGroup.Group['Quantity (Initial)'].newValue = "NA";
                        IsChanged = true;
                    }
                }
            }
            
            /**
             * For Group Quantity Regular
             */
            if (OldEmpty) {
                if (objProductNew.int_GrpQtyRegular != "" && objProductNew.int_GrpQtyRegular!=undefined) {
                    objGroup.Group['Quantity (Regular)'].oldValue = "NA";
                    objGroup.Group['Quantity (Regular)'].newValue = Number(objProductNew.int_GrpQtyRegular);
                    IsChanged = true;
                }
                else {
                    objGroup.Group['Quantity (Regular)'].oldValue = false;
                    objGroup.Group['Quantity (Regular)'].newValue = false;
                    IsChanged = IsChanged != true ? false : true;
                }
            }
            else {
                if (objProductOld.Param2_RegQty === "" ||
                    objProductOld.Param2_RegQty == this.strNullValue ||
                    objProductOld.Param2_RegQty == undefined) {
                    objProductOld.Param2_RegQty = null;
                }

                if (objProductNew.int_GrpQtyRegular === "" || objProductNew.int_GrpQtyRegular == this.strNullValue || objProductNew.int_GrpQtyRegular == undefined) {
                    objProductNew.int_GrpQtyRegular = null;
                }

                if ((objProductOld.Param2_RegQty !== null) && (objProductNew.int_GrpQtyRegular !== null)) {
                    if (Number(objProductOld.Param2_RegQty)== Number(objProductNew.int_GrpQtyRegular)) {
                        objGroup.Group['Quantity (Regular)'].oldValue = false;
                        objGroup.Group['Quantity (Regular)'].newValue = false;
                        IsChanged != true ? IsChanged = false : IsChanged = true;
                    }
                    else {
                        objGroup.Group['Quantity (Regular)'].oldValue = objProductOld.Param2_RegQty;
                        objGroup.Group['Quantity (Regular)'].newValue = Number(objProductNew.int_GrpQtyRegular);
                        IsChanged = true;
                    }

                } else {

                    if ((objProductOld.Param2_RegQty === null) && (objProductNew.int_GrpQtyRegular !== null)) {
                        objGroup.Group['Quantity (Regular)'].oldValue = "NA";
                        objGroup.Group['Quantity (Regular)'].newValue = Number(objProductNew.int_GrpQtyRegular);
                        IsChanged = true;

                    } else if ((objProductOld.Param2_RegQty !== null) && (objProductNew.int_GrpQtyRegular === null)) {
                        objGroup.Group['Quantity (Regular)'].oldValue = objProductOld.Param2_RegQty;
                        objGroup.Group['Quantity (Regular)'].newValue = "NA";
                        IsChanged = true;
                    }
                }
            }
            
            /**
            * For Individual NegT2
            if (OldEmpty) {
                if (objProductNew.flt_GrpT2Neg != "" && objProductNew.flt_GrpT2Neg!=undefined) {
                    objGroup.Group.T2Neg.oldValue = "NA";
                    objGroup.Group.T2Neg.newValue = objProductNew.flt_GrpT2Neg;
                    IsChanged = true;
                }
                else {
                    objGroup.Group.T2Neg.oldValue = false;
                    objGroup.Group.T2Neg.newValue = false;
                    IsChanged = IsChanged != true ? false : true;
                }
            }
            else {
                if (objProductOld.Param2_T2Neg === "" ||
                    objProductOld.Param2_T2Neg == this.strNullValue ||
                    objProductOld.Param2_T2Neg == undefined) {
                    objProductOld.Param2_T2Neg = null;
                }

                objProductNew.flt_GrpT2Neg = objProductNew.flt_GrpT2Neg === "" ? this.strNullValue : objProductNew.flt_GrpT2Neg;

                if (objProductNew.flt_GrpT2Neg === "" ||
                    objProductNew.flt_GrpT2Neg == this.strNullValue ||
                    objProductNew.flt_GrpT2Neg == undefined) {
                    objProductNew.flt_GrpT2Neg = null;
                }

                if ((objProductOld.Param2_T2Neg !== null) && (objProductNew.flt_GrpT2Neg !== null)) {
                    if (parseFloat(objProductOld.Param2_T2Neg).toFixed(objProductOld.Param2_DP) == parseFloat(objProductNew.flt_GrpT2Neg).toFixed(objProductNew.int_Grpdp)) {
                        objGroup.Group.T2Neg.oldValue = false;
                        objGroup.Group.T2Neg.newValue = false;
                        IsChanged != true ? IsChanged = false : IsChanged = true;
                    }
                    else {
                        objGroup.Group.T2Neg.oldValue = parseFloat(objProductOld.Param2_T2Neg).toFixed(objProductOld.Param2_DP);
                        objGroup.Group.T2Neg.newValue = objProductNew.flt_GrpT2Neg;
                        IsChanged = true;
                    }

                } else {

                    if ((objProductOld.Param2_T2Neg === null) && (objProductNew.flt_GrpT2Neg !== null)) {
                        objGroup.Group.T2Neg.oldValue = "NA";
                        objGroup.Group.T2Neg.newValue = objProductNew.flt_GrpT2Neg;
                        IsChanged = true;

                    } else if ((objProductOld.Param2_T2Neg !== null) && (objProductNew.flt_GrpT2Neg === null)) {
                        objGroup.Group.T2Neg.oldValue = parseFloat(objProductOld.Param2_T2Neg).toFixed(objProductOld.Param2_DP);
                        objGroup.Group.T2Neg.newValue = "NA";
                        IsChanged = true;
                    }
                }
            }
            */

            /**
            * For Individual PosT2
            if (OldEmpty) {
                if (objProductNew.flt_GrpT2Pos != "" && objProductNew.flt_GrpT2Pos!=undefined) {
                    objGroup.Group.T2Pos.oldValue = "NA";
                    objGroup.Group.T2Pos.newValue = objProductNew.flt_GrpT2Pos;
                    IsChanged = true;
                }
                else {
                    objGroup.Group.T2Pos.oldValue = false;
                    objGroup.Group.T2Pos.newValue = false;
                    IsChanged = IsChanged != true ? false : true;
                }
            }
            else {
                if (objProductOld.Param2_T2Pos === "" ||
                    objProductOld.Param2_T2Pos == this.strNullValue ||
                    objProductOld.Param2_T2Pos == undefined) {
                    objProductOld.Param2_T2Pos = null;
                }

                objProductNew.flt_GrpT2Pos = objProductNew.flt_GrpT2Pos === "" ? this.strNullValue : objProductNew.flt_GrpT2Pos;
                
                if (objProductNew.flt_GrpT2Pos === "" ||
                    objProductNew.flt_GrpT2Pos == this.strNullValue ||
                    objProductNew.flt_GrpT2Pos == undefined) {
                    objProductNew.flt_GrpT2Pos = null;
                }

                if ((objProductOld.Param2_T2Pos !== null) && (objProductNew.flt_GrpT2Pos !== null)) {
                    if (parseFloat(objProductOld.Param2_T2Pos).toFixed(objProductOld.Param2_DP) == parseFloat(objProductNew.flt_GrpT2Pos).toFixed(objProductNew.int_Grpdp)) {
                        objGroup.Group.T2Pos.oldValue = false;
                        objGroup.Group.T2Pos.newValue = false;
                        IsChanged != true ? IsChanged = false : IsChanged = true;
                    }
                    else {
                        objGroup.Group.T2Pos.oldValue = parseFloat(objProductOld.Param2_T2Pos).toFixed(objProductOld.Param2_DP);
                        objGroup.Group.T2Pos.newValue = objProductNew.flt_GrpT2Pos;
                        IsChanged = true;
                    }

                } else {

                    if ((objProductOld.Param2_T2Pos === null) && (objProductNew.flt_GrpT2Pos !== null)) {
                        objGroup.Group.T2Pos.oldValue = "NA";
                        objGroup.Group.T2Pos.newValue = objProductNew.flt_GrpT2Pos;
                        IsChanged = true;

                    } else if ((objProductOld.Param2_T2Pos !== null) && (objProductNew.flt_GrpT2Pos === null)) {
                        objGroup.Group.T2Pos.oldValue = parseFloat(objProductOld.Param2_T2Pos).toFixed(objProductOld.Param2_DP);
                        objGroup.Group.T2Pos.newValue = "NA";
                        IsChanged = true;
                    }
                }
            }
            */

            /**
            * For Individual NMT
            if (OldEmpty) {
                if (objProductNew.int_GrpNMTTabCnt != "" && objProductNew.int_GrpNMTTabCnt!=undefined) {
                    objGroup.Group.NMT.oldValue = "NA";
                    objGroup.Group.NMT.newValue = objProductNew.int_GrpNMTTabCnt;
                    IsChanged = true;
                }
                else {
                    objGroup.Group.NMT.oldValue = false;
                    objGroup.Group.NMT.newValue = false;
                    IsChanged = IsChanged != true ? false : true;
                }
            }
            else {
                if (objProductOld.Param2_NMTTab == 0 ||
                    objProductOld.Param2_NMTTab == this.NMTValue ||
                    objProductOld.Param2_NMTTab == undefined) {
                    objProductOld.Param2_NMTTab = 0;
                }

                objProductNew.int_GrpNMTTabCnt = objProductNew.int_GrpNMTTabCnt === "" ? this.strNullValue : objProductNew.int_GrpNMTTabCnt;

                if (objProductNew.int_GrpNMTTabCnt == "0" ||
                    objProductNew.int_GrpNMTTabCnt == this.NMTValue ||
                    objProductNew.int_GrpNMTTabCnt == undefined) {
                    objProductNew.int_GrpNMTTabCnt = 0;
                }

                if (parseInt(objProductOld.Param2_NMTTab) == parseInt(objProductNew.int_GrpNMTTabCnt)) {
                    objGroup.Group.NMT.oldValue = false;
                    objGroup.Group.NMT.newValue = false;
                    IsChanged != true ? IsChanged = false : IsChanged = true;
                }
                else {
                    objGroup.Group.NMT.oldValue = objProductOld.Param2_NMTTab;
                    objGroup.Group.NMT.newValue = objProductNew.int_GrpNMTTabCnt;
                    IsChanged = true;
                }
            }
            */

            /**
             * For Individual Limits On Actual / Percent
            if (OldEmpty) {
                if (objProductNew.str_GrpLimitOn != "" && objProductNew.flt_GrpStd != "" && objProductNew.flt_GrpStd!=undefined && objProductNew.str_GrpLimitOn!=undefined) {
                    objGroup.Group.LimitOn.oldValue = "NA";
                    objGroup.Group.LimitOn.newValue = objProductNew.str_GrpLimitOn;
                    IsChanged = true;
                }
                else {
                    objGroup.Group.LimitOn.oldValue = false;
                    objGroup.Group.LimitOn.newValue = false;
                    IsChanged = IsChanged != true ? false : true;
                }
            }
            else {
                const strLimitOn = objProductOld.Param2_LimitOn == 0 ? "Actual" : "Percentage";
                if (objProductOld.Param2_Nom == null && objProductNew.flt_GrpStd != null) { // new parameter added
                    objGroup.Group.LimitOn.oldValue = "NA";
                    objGroup.Group.LimitOn.newValue = objProductNew.str_GrpLimitOn;
                    IsChanged = true;
                }
                else if (objProductOld.Param2_Nom == null && objProductNew.flt_GrpStd == null) // no parameter added
                {
                    objGroup.Group.LimitOn.oldValue = false;
                    objGroup.Group.LimitOn.newValue = false;
                    IsChanged = false;
                }
                else {
                    if (strLimitOn == objProductNew.str_GrpLimitOn) {
                        objGroup.Group.LimitOn.oldValue = false;
                        objGroup.Group.LimitOn.newValue = false;
                        IsChanged != true ? IsChanged = false : IsChanged = true;
                    }
                    else {
                        objGroup.Group.LimitOn.oldValue = strLimitOn;
                        objGroup.Group.LimitOn.newValue = objProductNew.str_GrpLimitOn;
                        IsChanged = true;
                    }
                }
            }
             */

            /**
             * For Individual Limits On Standard / Avg
            if (OldEmpty) {
                if (objProductNew.str_GrpGraphOn != "" && objProductNew.flt_GrpStd != "" && objProductNew.str_GrpGraphOn!=undefined && objProductNew.flt_GrpStd!=undefined) {
                    objGroup.Group.ReportOn.oldValue = "NA";
                    objGroup.Group.ReportOn.newValue = objProductNew.str_GrpGraphOn;
                    IsChanged = true;
                }
                else {
                    objGroup.Group.ReportOn.oldValue = false;
                    objGroup.Group.ReportOn.newValue = false;
                    IsChanged = IsChanged != true ? false : true;
                }
            }
            else {
                const strGraphOn = objProductOld.Param2_IsOnStd == 0 ? "Standard" : "Average";
                if (objProductOld.Param2_Nom == null && objProductNew.flt_GrpStd != null) { // new parameter added
                    objGroup.Group.ReportOn.oldValue = "NA";
                    objGroup.Group.ReportOn.newValue = objProductNew.str_GrpGraphOn;
                    IsChanged = true;
                }
                else if (objProductOld.Param2_Nom == null && objProductNew.flt_GrpStd == null) // no parameter added
                {
                    objGroup.Group.ReportOn.oldValue = false;
                    objGroup.Group.ReportOn.newValue = false;
                    IsChanged = false;
                }
                else {
                    if (strGraphOn == objProductNew.str_GrpGraphOn) {
                        objGroup.Group.ReportOn.oldValue = false;
                        objGroup.Group.ReportOn.newValue = false;
                        IsChanged != true ? IsChanged = false : IsChanged = true;
                    }
                    else {
                        objGroup.Group.ReportOn.oldValue = strGraphOn;
                        objGroup.Group.ReportOn.newValue = objProductNew.str_GrpGraphOn;
                        IsChanged = true;
                    }
                }
            }
             */

            /*
            if (OldEmpty) {
                if (objProductNew.str_groupUnit != "" && objProductNew.flt_GrpStd != "" && objProductNew.str_groupUnit!=undefined && objProductNew.flt_GrpStd!=undefined) {
                    objGroup.Group.Unit.oldValue = "NA";
                    objGroup.Group.Unit.newValue = objProductNew.str_groupUnit;
                    IsChanged = true;
                }
                else {
                    objGroup.Group.Unit.oldValue = false;
                    objGroup.Group.Unit.newValue = false;
                    IsChanged = IsChanged != true ? false : true;
                }
            }
            else {
                const strGraphOn = objProductOld.Param2_Unit == 0 ? "gm" : objProductOld.Param2_Unit;
                if (objProductOld.Param2_Nom == null && objProductNew.flt_GrpStd != null) { // new parameter added
                    objGroup.Group.Unit.oldValue = "NA";
                    objGroup.Group.Unit.newValue = objProductNew.str_groupUnit;
                    IsChanged = true;
                }
                else if (objProductOld.Param2_Unit == null && objProductNew.str_groupUnit == null) // no parameter added
                {
                    objGroup.Group.Unit.oldValue = false;
                    objGroup.Group.Unit.newValue = false;
                    IsChanged = false;
                }
                else {
                    if (strGraphOn == objProductNew.str_groupUnit) {
                        objGroup.Group.Unit.oldValue = false;
                        objGroup.Group.Unit.newValue = false;
                        IsChanged != true ? IsChanged = false : IsChanged = true;
                    }
                    else {
                        objGroup.Group.Unit.oldValue = strGraphOn;
                        objGroup.Group.Unit.newValue = objProductNew.str_groupUnit;
                        IsChanged = true;
                    }
                }
            }
            */


            if (IsChanged == true) {
                Object.assign(this.objResult, objGroup);
            }
            resolve(IsChanged);
        });
    }

    validateThickness(objProductOld, objProductNew) {
        return new Promise((resolve, reject) => {
            const objThickness = {
                Thickness: {
                    Nom: { oldValue: "", newValue: "" },
                    // T1Neg: { oldValue: "", newValue: "" },
                    // T1Pos: { oldValue: "", newValue: "" },
                    'Lower Limit': { oldValue: "", newValue: "" },
                    'Upper Limit': { oldValue: "", newValue: "" },
                    T2Neg: { oldValue: "", newValue: "" },
                    T2Pos: { oldValue: "", newValue: "" },
                    T3Neg: { oldValue: "", newValue: "" },
                    T3Pos: { oldValue: "", newValue: "" },
                    NMT: { oldValue: "", newValue: "" },
                    //GraphOn: { oldValue: "", newValue: "" },
                    Unit:{ oldValue: "", newValue: "" },
                    "Quantity (Initial)":{ oldValue: "", newValue: "" },
                    "Quantity (Regular)":{ oldValue: "", newValue: "" }
                }
            };

            var IsChanged = false;
            var OldEmpty = objProductOld == undefined ? true : false;
            /**
             * For Individual Nom
            if (OldEmpty == true) {
                if (objProductNew.flt_ThkStd != "" && objProductNew.flt_ThkStd != undefined) {
                    objThickness.Thickness.Nom.oldValue = "NA";
                    objThickness.Thickness.Nom.newValue = objProductNew.flt_ThkStd;
                    IsChanged = true;
                }
                else {
                    objThickness.Thickness.Nom.oldValue = false;
                    objThickness.Thickness.Nom.newValue = false;
                    IsChanged = false;
                }
            }
            else {
                if (objProductOld.Param3_Nom === "" ||
                    objProductOld.Param3_Nom == this.strNullValue ||
                    objProductOld.Param3_Nom == undefined) {
                    objProductOld.Param3_Nom = null;
                }

                if (objProductNew.flt_ThkStd === "" ||
                    objProductNew.flt_ThkStd == this.strNullValue ||
                    objProductNew.flt_ThkStd == undefined) {
                    objProductNew.flt_ThkStd = null;
                }

                if ((objProductOld.Param3_Nom !== null) && (objProductNew.flt_ThkStd !== null)) {
                    if (parseFloat(objProductOld.Param3_Nom).toFixed(objProductOld.Param3_DP) == parseFloat(objProductNew.flt_ThkStd).toFixed(objProductNew.int_Thkdp)) {
                        objThickness.Thickness.Nom.oldValue = false;
                        objThickness.Thickness.Nom.newValue = false;
                        IsChanged = false;
                    }
                    else {
                        objThickness.Thickness.Nom.oldValue = parseFloat(objProductOld.Param3_Nom).toFixed(objProductOld.Param3_DP);
                        objThickness.Thickness.Nom.newValue = parseFloat(objProductNew.flt_ThkStd).toFixed(objProductNew.int_Thkdp);
                        IsChanged = true;
                    }

                } else {

                    if ((objProductOld.Param3_Nom === null) && (objProductNew.flt_ThkStd !== null)) {
                        objThickness.Thickness.Nom.oldValue = "NA";
                        objThickness.Thickness.Nom.newValue = parseFloat(objProductNew.flt_ThkStd).toFixed(objProductNew.int_Thkdp);
                        IsChanged = true;

                    } else if ((objProductOld.Param3_Nom !== null) && (objProductNew.flt_ThkStd === null)) {
                        objThickness.Thickness.Nom.oldValue = parseFloat(objProductOld.Param3_Nom).toFixed(objProductOld.Param3_DP);
                        objThickness.Thickness.Nom.newValue = "NA";
                        IsChanged = true;
                    }
                }
            }
             */

            /**
             * For Individual NegT1
             */
            if (OldEmpty == true) {
                if (objProductNew.flt_ThkT1Neg != "" && objProductNew.flt_ThkT1Neg != undefined) {
                    objThickness.Thickness['Lower Limit'].oldValue = "NA";
                    objThickness.Thickness['Lower Limit'].newValue = objProductNew.flt_ThkT1Neg;
                    IsChanged = true;
                }
                else {
                    objThickness.Thickness['Lower Limit'].oldValue = false;
                    objThickness.Thickness['Lower Limit'].newValue = false;
                    IsChanged = false;
                }
            }
            else {
                if (objProductOld.Param3_T1Neg === "" ||
                    objProductOld.Param3_T1Neg == this.strNullValue ||
                    objProductOld.Param3_T1Neg == undefined) {
                    objProductOld.Param3_T1Neg = null;
                }

                if (objProductNew.flt_ThkT1Neg === "" ||
                    objProductNew.flt_ThkT1Neg == this.strNullValue ||
                    objProductNew.flt_ThkT1Neg == undefined) {
                    objProductNew.flt_ThkT1Neg = null;
                }

                if ((objProductOld.Param3_T1Neg !== null) && (objProductNew.flt_ThkT1Neg !== null)) {
                    if (parseFloat(objProductOld.Param3_T1Neg).toFixed(objProductOld.Param3_DP) == parseFloat(objProductNew.flt_ThkT1Neg).toFixed(objProductNew.int_Thkdp)) {
                        objThickness.Thickness['Lower Limit'].oldValue = false;
                        objThickness.Thickness['Lower Limit'].newValue = false;
                        IsChanged != true ? IsChanged = false : IsChanged = true;
                    }
                    else {
                        objThickness.Thickness['Lower Limit'].oldValue = parseFloat(objProductOld.Param3_T1Neg).toFixed(objProductOld.Param3_DP);
                        objThickness.Thickness['Lower Limit'].newValue = parseFloat(objProductNew.flt_ThkT1Neg).toFixed(objProductNew.int_Thkdp);
                        IsChanged = true;
                    }

                } else {

                    if ((objProductOld.Param3_T1Neg === null) && (objProductNew.flt_ThkT1Neg !== null)) {
                        objThickness.Thickness['Lower Limit'].oldValue = "NA";
                        objThickness.Thickness['Lower Limit'].newValue = parseFloat(objProductNew.flt_ThkT1Neg).toFixed(objProductNew.int_Thkdp);
                        IsChanged = true;

                    } else if ((objProductOld.Param3_T1Neg !== null) && (objProductNew.flt_ThkT1Neg === null)) {
                        objThickness.Thickness['Lower Limit'].oldValue = parseFloat(objProductOld.Param3_T1Neg).toFixed(objProductOld.Param3_DP);
                        objThickness.Thickness['Lower Limit'].newValue = "NA";
                        IsChanged = true;
                    }
                }
            }
            
            /**
             * For Individual PosT1
             */
            if (OldEmpty == true) {
                if (objProductNew.flt_ThkT1Pos != "" && objProductNew.flt_ThkT1Pos != undefined) {
                    objThickness.Thickness['Upper Limit'].oldValue = "NA";
                    objThickness.Thickness['Upper Limit'].newValue = objProductNew.flt_ThkT1Pos;
                    IsChanged = true;
                }
                else {
                    objThickness.Thickness['Upper Limit'].oldValue = false;
                    objThickness.Thickness['Upper Limit'].newValue = false;
                    IsChanged = false;
                }
            }
            else {
                if (objProductOld.Param3_T1Pos === "" ||
                    objProductOld.Param3_T1Pos == this.strNullValue ||
                    objProductOld.Param3_T1Pos == undefined) {
                    objProductOld.Param3_T1Pos = null;
                }

                if (objProductNew.flt_ThkT1Pos === "" ||
                    objProductNew.flt_ThkT1Pos == this.strNullValue ||
                    objProductNew.flt_ThkT1Pos == undefined) {
                    objProductNew.flt_ThkT1Pos = null;
                }

                if ((objProductOld.Param3_T1Pos !== null) && (objProductNew.flt_ThkT1Pos !== null)) {
                    if (parseFloat(objProductOld.Param3_T1Pos).toFixed(objProductOld.Param3_DP) == parseFloat(objProductNew.flt_ThkT1Pos).toFixed(objProductNew.int_Thkdp)) {
                        objThickness.Thickness['Upper Limit'].oldValue = false;
                        objThickness.Thickness['Upper Limit'].newValue = false;
                        IsChanged != true ? IsChanged = false : IsChanged = true;
                    }
                    else {
                        objThickness.Thickness['Upper Limit'].oldValue = parseFloat(objProductOld.Param3_T1Pos).toFixed(objProductOld.Param3_DP);
                        objThickness.Thickness['Upper Limit'].newValue = parseFloat(objProductNew.flt_ThkT1Pos).toFixed(objProductNew.int_Thkdp);
                        IsChanged = true;
                    }

                } else {

                    if ((objProductOld.Param3_T1Pos === null) && (objProductNew.flt_ThkT1Pos !== null)) {
                        objThickness.Thickness['Upper Limit'].oldValue = "NA";
                        objThickness.Thickness['Upper Limit'].newValue = parseFloat(objProductNew.flt_ThkT1Pos).toFixed(objProductNew.int_Thkdp);
                        IsChanged = true;

                    } else if ((objProductOld.Param3_T1Pos !== null) && (objProductNew.flt_ThkT1Pos === null)) {
                        objThickness.Thickness['Upper Limit'].oldValue = parseFloat(objProductOld.Param3_T1Pos).toFixed(objProductOld.Param3_DP);
                        objThickness.Thickness['Upper Limit'].newValue = "NA";
                        IsChanged = true;
                    }
                }
            }

             /**
             * For Thickness Initial Quantity
             */
             if (OldEmpty) {
                if (objProductNew.int_ThkQtyInitial != "" && objProductNew.int_ThkQtyInitial!=undefined) {
                    objThickness.Thickness['Quantity (Initial)'].oldValue = "NA";
                    objThickness.Thickness['Quantity (Initial)'].newValue = Number(objProductNew.int_ThkQtyInitial);
                    IsChanged = true;
                }
                else {
                    objThickness.Thickness['Quantity (Initial)'].oldValue = false;
                    objThickness.Thickness['Quantity (Initial)'].newValue = false;
                    IsChanged = IsChanged != true ? false : true;
                }
            }
            else {
                if (objProductOld.Param3_IniQty === "" ||
                    objProductOld.Param3_IniQty == this.strNullValue ||
                    objProductOld.Param3_IniQty == undefined) {
                    objProductOld.Param3_IniQty = null;
                }

                if (objProductNew.int_ThkQtyInitial === "" || objProductNew.int_ThkQtyInitial == this.strNullValue || objProductNew.int_ThkQtyInitial == undefined) {
                    objProductNew.int_ThkQtyInitial = null;
                }

                if ((objProductOld.Param3_IniQty !== null) && (objProductNew.int_ThkQtyInitial !== null)) {
                    if (Number(objProductOld.Param3_IniQty) == Number(objProductNew.int_ThkQtyInitial)) {
                        objThickness.Thickness['Quantity (Initial)'].oldValue = false;
                        objThickness.Thickness['Quantity (Initial)'].newValue = false;
                        IsChanged != true ? IsChanged = false : IsChanged = true;
                    }
                    else {
                        objThickness.Thickness['Quantity (Initial)'].oldValue = objProductOld.Param3_IniQty;
                        objThickness.Thickness['Quantity (Initial)'].newValue = Number(objProductNew.int_ThkQtyInitial);
                        IsChanged = true;
                    }

                } else {

                    if ((objProductOld.Param3_IniQty === null) && (objProductNew.int_ThkQtyInitial !== null)) {
                        objThickness.Thickness['Quantity (Initial)'].oldValue = "NA";
                        objThickness.Thickness['Quantity (Initial)'].newValue = Number(objProductNew.int_ThkQtyInitial);
                        IsChanged = true;

                    } else if ((objProductOld.Param3_IniQty !== null) && (objProductNew.int_ThkQtyInitial === null)) {
                        objThickness.Thickness['Quantity (Initial)'].oldValue = objProductOld.Param3_IniQty;
                        objThickness.Thickness['Quantity (Initial)'].newValue = "NA";
                        IsChanged = true;
                    }
                }
            }
            
            /**
             * For Thickness Quantity Regular
             */
            if (OldEmpty) {
                if (objProductNew.int_ThkQtyRegular != "" && objProductNew.int_ThkQtyRegular!=undefined) {
                    objThickness.Thickness['Quantity (Regular)'].oldValue = "NA";
                    objThickness.Thickness['Quantity (Regular)'].newValue = Number(objProductNew.int_ThkQtyRegular);
                    IsChanged = true;
                }
                else {
                    objThickness.Thickness['Quantity (Regular)'].oldValue = false;
                    objThickness.Thickness['Quantity (Regular)'].newValue = false;
                    IsChanged = IsChanged != true ? false : true;
                }
            }
            else {
                if (objProductOld.Param3_RegQty === "" ||
                    objProductOld.Param3_RegQty == this.strNullValue ||
                    objProductOld.Param3_RegQty == undefined) {
                    objProductOld.Param3_RegQty = null;
                }

                if (objProductNew.int_ThkQtyRegular === "" || objProductNew.int_ThkQtyRegular == this.strNullValue || objProductNew.int_ThkQtyRegular == undefined) {
                    objProductNew.int_ThkQtyRegular = null;
                }

                if ((objProductOld.Param3_RegQty !== null) && (objProductNew.int_ThkQtyRegular !== null)) {
                    if (Number(objProductOld.Param3_RegQty)== Number(objProductNew.int_ThkQtyRegular)) {
                        objThickness.Thickness['Quantity (Regular)'].oldValue = false;
                        objThickness.Thickness['Quantity (Regular)'].newValue = false;
                        IsChanged != true ? IsChanged = false : IsChanged = true;
                    }
                    else {
                        objThickness.Thickness['Quantity (Regular)'].oldValue = objProductOld.Param3_RegQty;
                        objThickness.Thickness['Quantity (Regular)'].newValue = Number(objProductNew.int_ThkQtyRegular);
                        IsChanged = true;
                    }

                } else {

                    if ((objProductOld.Param3_RegQty === null) && (objProductNew.int_ThkQtyRegular !== null)) {
                        objThickness.Thickness['Quantity (Regular)'].oldValue = "NA";
                        objThickness.Thickness['Quantity (Regular)'].newValue = Number(objProductNew.int_ThkQtyRegular);
                        IsChanged = true;

                    } else if ((objProductOld.Param3_RegQty !== null) && (objProductNew.int_ThkQtyRegular === null)) {
                        objThickness.Thickness['Quantity (Regular)'].oldValue = objProductOld.Param3_RegQty;
                        objThickness.Thickness['Quantity (Regular)'].newValue = "NA";
                        IsChanged = true;
                    }
                }
            }
            
            /**
            * For Individual NegT2
            if (OldEmpty == true) {
                if (objProductNew.flt_ThkT2Neg != "" && objProductNew.flt_ThkT2Neg != undefined) {
                    objThickness.Thickness.T2Neg.oldValue = "NA";
                    objThickness.Thickness.T2Neg.newValue = objProductNew.flt_ThkT2Neg;
                    IsChanged = true;
                }
                else {
                    objThickness.Thickness.T2Neg.oldValue = false;
                    objThickness.Thickness.T2Neg.newValue = false;
                    IsChanged = false;
                }
            }
            else {
                if (objProductOld.Param3_T2Neg === "" ||
                    objProductOld.Param3_T2Neg == this.strNullValue ||
                    objProductOld.Param3_T2Neg == undefined) {
                    objProductOld.Param3_T2Neg = null;
                }
 
                if (objProductNew.flt_ThkT2Neg === "" ||
                    objProductNew.flt_ThkT2Neg == this.strNullValue ||
                    objProductNew.flt_ThkT2Neg == undefined) {
                    objProductNew.flt_ThkT2Neg = null;
                }
 
                if ((objProductOld.Param3_T2Neg !== null) && (objProductNew.flt_ThkT2Neg !== null)) {
                    if (parseFloat(objProductOld.Param3_T2Neg).toFixed(objProductOld.Param3_DP) == parseFloat(objProductNew.flt_ThkT2Neg).toFixed(objProductNew.int_Thkdp)) {
                        objThickness.Thickness.T2Neg.oldValue = false;
                        objThickness.Thickness.T2Neg.newValue = false;
                        IsChanged != true ? IsChanged = false : IsChanged = true;
                    }
                    else {
                        objThickness.Thickness.T2Neg.oldValue = parseFloat(objProductOld.Param3_T2Neg).toFixed(objProductOld.Param3_DP);
                        objThickness.Thickness.T2Neg.newValue = parseFloat(objProductNew.flt_ThkT2Neg).toFixed(objProductNew.int_Thkdp);
                        IsChanged = true;
                    }
 
                } else {
 
                    if ((objProductOld.Param3_T2Neg === null) && (objProductNew.flt_ThkT2Neg !== null)) {
                        objThickness.Thickness.T2Neg.oldValue = "NA";
                        objThickness.Thickness.T2Neg.newValue = parseFloat(objProductNew.flt_ThkT2Neg).toFixed(objProductNew.int_Thkdp);
                        IsChanged = true;
 
                    } else if ((objProductOld.Param3_T2Neg !== null) && (objProductNew.flt_ThkT2Neg === null)) {
                        objThickness.Thickness.T2Neg.oldValue = parseFloat(objProductOld.Param3_T2Neg).toFixed(objProductOld.Param3_DP);
                        objThickness.Thickness.T2Neg.newValue = "NA";
                        IsChanged = true;
                    }
                }
            }
            */
            
            /**
            * For Individual PosT2
            if (OldEmpty == true) {
                if (objProductNew.flt_ThkT2Pos != "" && objProductNew.flt_ThkT2Pos != undefined) {
                    objThickness.Thickness.T2Pos.oldValue = "NA";
                    objThickness.Thickness.T2Pos.newValue = objProductNew.flt_ThkT2Pos;
                    IsChanged = true;
                }
                else {
                    objThickness.Thickness.T2Pos.oldValue = false;
                    objThickness.Thickness.T2Pos.newValue = false;
                    IsChanged = false;
                }
            }
            else {
                if (objProductOld.Param3_T2Pos === "" ||
                    objProductOld.Param3_T2Pos == this.strNullValue ||
                    objProductOld.Param3_T2Pos == undefined) {
                    objProductOld.Param3_T2Pos = null;
                }

                if (objProductNew.flt_ThkT2Pos === "" ||
                    objProductNew.flt_ThkT2Pos == this.strNullValue ||
                    objProductNew.flt_ThkT2Pos == undefined) {
                    objProductNew.flt_ThkT2Pos = null;
                }

                if ((objProductOld.Param3_T2Pos !== null) && (objProductNew.flt_ThkT2Pos !== null)) {
                    if (parseFloat(objProductOld.Param3_T2Pos).toFixed(objProductOld.Param3_DP) == parseFloat(objProductNew.flt_ThkT2Pos).toFixed(objProductNew.int_Thkdp)) {
                        objThickness.Thickness.T2Pos.oldValue = false;
                        objThickness.Thickness.T2Pos.newValue = false;
                        IsChanged != true ? IsChanged = false : IsChanged = true;
                    }
                    else {
                        objThickness.Thickness.T2Pos.oldValue = parseFloat(objProductOld.Param3_T2Pos).toFixed(objProductOld.Param3_DP);
                        objThickness.Thickness.T2Pos.newValue = parseFloat(objProductNew.flt_ThkT2Pos).toFixed(objProductNew.int_Thkdp);
                        IsChanged = true;
                    }

                } else {

                    if ((objProductOld.Param3_T2Pos === null) && (objProductNew.flt_ThkT2Pos !== null)) {
                        objThickness.Thickness.T2Pos.oldValue = "NA";
                        objThickness.Thickness.T2Pos.newValue = parseFloat(objProductNew.flt_ThkT2Pos).toFixed(objProductNew.int_Thkdp);
                        IsChanged = true;

                    } else if ((objProductOld.Param3_T2Pos !== null) && (objProductNew.flt_ThkT2Pos === null)) {
                        objThickness.Thickness.T2Pos.oldValue = parseFloat(objProductOld.Param3_T2Pos).toFixed(objProductOld.Param3_DP);
                        objThickness.Thickness.T2Pos.newValue = "NA";
                        IsChanged = true;
                    }
                }
            }
            */

            /**
            * For Individual NegT3
            if (OldEmpty == true) {
                if (objProductNew.flt_ThkT3Neg != "" && objProductNew.flt_ThkT3Neg != undefined) {
                    objThickness.Thickness.T3Neg.oldValue = "NA";
                    objThickness.Thickness.T3Neg.newValue = objProductNew.flt_ThkT3Neg;
                    IsChanged = true;
                }
                else {
                    objThickness.Thickness.T3Neg.oldValue = false;
                    objThickness.Thickness.T3Neg.newValue = false;
                    IsChanged = false;
                }
            }
            else {
                if (objProductOld.Param3_T3Neg === "" ||
                    objProductOld.Param3_T3Neg == this.strNullValue ||
                    objProductOld.Param3_T3Neg == undefined) {
                    objProductOld.Param3_T3Neg = null;
                }

                if (objProductNew.flt_ThkT3Neg === "" ||
                    objProductNew.flt_ThkT3Neg == this.strNullValue ||
                    objProductNew.flt_ThkT3Neg == undefined) {
                    objProductNew.flt_ThkT3Neg = null;
                }

                if ((objProductOld.Param3_T3Neg !== null) && (objProductNew.flt_ThkT3Neg !== null)) {
                    if (parseFloat(objProductOld.Param3_T3Neg).toFixed(objProductOld.Param3_DP) == parseFloat(objProductNew.flt_ThkT3Neg).toFixed(objProductNew.int_Thkdp)) {
                        objThickness.Thickness.T3Neg.oldValue = false;
                        objThickness.Thickness.T3Neg.newValue = false;
                        IsChanged != true ? IsChanged = false : IsChanged = true;
                    }
                    else {
                        objThickness.Thickness.T3Neg.oldValue = parseFloat(objProductOld.Param3_T3Neg).toFixed(objProductOld.Param3_DP);
                        objThickness.Thickness.T3Neg.newValue = parseFloat(objProductNew.flt_ThkT3Neg).toFixed(objProductNew.int_Thkdp);
                        IsChanged = true;
                    }

                } else {

                    if ((objProductOld.Param3_T3Neg === null) && (objProductNew.flt_ThkT3Neg !== null)) {
                        objThickness.Thickness.T3Neg.oldValue = "NA";
                        objThickness.Thickness.T3Neg.newValue = parseFloat(objProductNew.flt_ThkT3Neg).toFixed(objProductNew.int_Thkdp);
                        IsChanged = true;

                    } else if ((objProductOld.Param3_T3Neg !== null) && (objProductNew.flt_ThkT3Neg === null)) {
                        objThickness.Thickness.T3Neg.oldValue = parseFloat(objProductOld.Param3_T3Neg).toFixed(objProductOld.Param3_DP);
                        objThickness.Thickness.T3Neg.newValue = "NA";
                        IsChanged = true;
                    }
                }
            }
            */

            /**
            * For Individual PosT3
            if (OldEmpty == true) {
                if (objProductNew.flt_ThkT3Pos != "" && objProductNew.flt_ThkT3Pos != undefined) {
                    objThickness.Thickness.T3Pos.oldValue = "NA";
                    objThickness.Thickness.T3Pos.newValue = objProductNew.flt_ThkT3Pos;
                    IsChanged = true;
                }
                else {
                    objThickness.Thickness.T3Pos.oldValue = false;
                    objThickness.Thickness.T3Pos.newValue = false;
                    IsChanged = false;
                }
            }
            else {
                if (objProductOld.Param3_T3Pos === "" ||
                    objProductOld.Param3_T3Pos == this.strNullValue ||
                    objProductOld.Param3_T3Pos == undefined) {
                    objProductOld.Param3_T3Pos = null;
                }

                if (objProductNew.flt_ThkT3Pos === "" ||
                    objProductNew.flt_ThkT3Pos == this.strNullValue ||
                    objProductNew.flt_ThkT3Pos == undefined) {
                    objProductNew.flt_ThkT3Pos = null;
                }

                if ((objProductOld.Param3_T3Pos !== null) && (objProductNew.flt_ThkT3Pos !== null)) {
                    if (parseFloat(objProductOld.Param3_T3Pos).toFixed(objProductOld.Param3_DP) == parseFloat(objProductNew.flt_ThkT3Pos).toFixed(objProductNew.int_Thkdp)) {
                        objThickness.Thickness.T3Pos.oldValue = false;
                        objThickness.Thickness.T3Pos.newValue = false;
                        IsChanged != true ? IsChanged = false : IsChanged = true;
                    }
                    else {
                        objThickness.Thickness.T3Pos.oldValue = parseFloat(objProductOld.Param3_T3Pos).toFixed(objProductOld.Param3_DP);
                        objThickness.Thickness.T3Pos.newValue = parseFloat(objProductNew.flt_ThkT3Pos).toFixed(objProductNew.int_Thkdp);
                        IsChanged = true;
                    }

                } else {

                    if ((objProductOld.Param3_T3Pos === null) && (objProductNew.flt_ThkT3Pos !== null)) {
                        objThickness.Thickness.T3Pos.oldValue = "NA";
                        objThickness.Thickness.T3Pos.newValue = parseFloat(objProductNew.flt_ThkT3Pos).toFixed(objProductNew.int_Thkdp);
                        IsChanged = true;

                    } else if ((objProductOld.Param3_T3Pos !== null) && (objProductNew.flt_ThkT3Pos === null)) {
                        objThickness.Thickness.T3Pos.oldValue = parseFloat(objProductOld.Param3_T3Pos).toFixed(objProductOld.Param3_DP);
                        objThickness.Thickness.T3Pos.newValue = "NA";
                        IsChanged = true;
                    }
                }
            }
            */
            
            /**
            * For Individual NMT
            if (OldEmpty == true) {
                if (objProductNew.int_ThkNMTTabCnt != "") {
                    objThickness.Thickness.NMT.oldValue = "NA";
                    objThickness.Thickness.NMT.newValue = objProductNew.int_ThkNMTTabCnt;
                    IsChanged = true;
                }
                else {
                    objThickness.Thickness.NMT.oldValue = false;
                    objThickness.Thickness.NMT.newValue = false;
                    IsChanged = false;
                }
            }
            else {
                if (objProductOld.Param3_NMTTab == 0 ||
                    objProductOld.Param3_NMTTab == this.NMTValue ||
                    objProductOld.Param3_NMTTab == undefined) {
                    objProductOld.Param3_NMTTab = 0;
                }

                objProductNew.int_ThkNMTTabCnt = objProductNew.int_ThkNMTTabCnt === "" ? this.strNullValue : objProductNew.int_ThkNMTTabCnt;
                
                if (objProductNew.int_ThkNMTTabCnt == "0" ||
                    objProductNew.int_ThkNMTTabCnt == this.NMTValue ||
                    objProductNew.int_ThkNMTTabCnt == undefined) {
                    objProductNew.int_ThkNMTTabCnt = 0;
                }

                if (parseInt(objProductOld.Param3_NMTTab) == parseInt(objProductNew.int_ThkNMTTabCnt)) {
                    objThickness.Thickness.NMT.oldValue = false;
                    objThickness.Thickness.NMT.newValue = false;
                    IsChanged != true ? IsChanged = false : IsChanged = true;
                }
                else {
                    objThickness.Thickness.NMT.oldValue = objProductOld.Param3_NMTTab;
                    objThickness.Thickness.NMT.newValue = objProductNew.int_ThkNMTTabCnt;
                    IsChanged = true;
                }
            }
             */

            /**
             * For Individual Limits On Standard / Avg
             */
            // if (objProductOld.Param3_IsOnStd == objProductNew.str_ThkGraphOn) {
            //     objThickness.Thickness.GraphOn.oldValue = false;
            //     objThickness.Thickness.GraphOn.newValue = false;
            //     IsChanged != true ? IsChanged = false : IsChanged=true;
            // }
            // else {
            //     objThickness.Thickness.GraphOn.oldValue = Param3_IsOnStd;
            //     objThickness.Thickness.GraphOn.newValue = str_ThkGraphOn;
            //     IsChanged = true;
            // }

            /**
             * 
            if (OldEmpty) {
                if (objProductNew.str_verUnit != "" && objProductNew.flt_ThkStd != "" && objProductNew.str_verUnit != undefined && objProductNew.flt_ThkStd != undefined) {
                    objThickness.Thickness.Unit.oldValue = "NA";
                    objThickness.Thickness.Unit.newValue = objProductNew.str_verUnit;
                    IsChanged = true;
                }
                else {
                    objThickness.Thickness.Unit.oldValue = false;
                    objThickness.Thickness.Unit.newValue = false;
                    IsChanged = IsChanged != true ? false : true;
                }
            }
            else {
                objProductOld.Param3_Unit == "NA" ? objProductOld.Param3_Unit = "mm" : objProductOld.Param3_Unit;
                if (objProductOld.Param3_Nom == null && objProductNew.flt_ThkStd != null) { // new parameter added
                    objThickness.Thickness.Unit.oldValue = "mm";
                    objThickness.Thickness.Unit.newValue = objProductNew.str_verUnit;
                    IsChanged = true;
                }
                else if (objProductOld.Param3_Unit == null && objProductNew.str_verUnit == null) // no parameter added
                {
                    objThickness.Thickness.Unit.oldValue = false;
                    objThickness.Thickness.Unit.newValue = false;
                    IsChanged = false;
                }
                else {
                    if (objProductOld.Param3_Unit == objProductNew.str_verUnit) {
                        objThickness.Thickness.Unit.oldValue = false;
                        objThickness.Thickness.Unit.newValue = false;
                        IsChanged != true ? IsChanged = false : IsChanged = true;
                    }
                    else {
                        objThickness.Thickness.Unit.oldValue = objProductOld.Param3_Unit;
                        objThickness.Thickness.Unit.newValue = objProductNew.str_verUnit;
                        IsChanged = true;
                    }
                }
            }
             */


            if (IsChanged == true) {
                Object.assign(this.objResult, objThickness);
            }
            resolve(IsChanged);
        });
    }

    validateBreadth(objProductOld, objProductNew) {
        return new Promise((resolve, reject) => {
            const objBreadth = {
                Breadth: {
                    Nom: { oldValue: "", newValue: "" },
                    // T1Neg: { oldValue: "", newValue: "" },
                    // T1Pos: { oldValue: "", newValue: "" },
                    'Lower Limit': { oldValue: "", newValue: "" },
                    'Upper Limit': { oldValue: "", newValue: "" },
                    T2Neg: { oldValue: "", newValue: "" },
                    T2Pos: { oldValue: "", newValue: "" },
                    NMT: { oldValue: "", newValue: "" },
                    //GraphOn: { oldValue: "", newValue: "" }
                    Unit:{ oldValue: "", newValue: "" },
                    "Quantity (Initial)":{ oldValue: "", newValue: "" },
                    "Quantity (Regular)":{ oldValue: "", newValue: "" }
                }
            };

            var IsChanged = false;
            var OldEmpty = objProductOld == undefined ? true : false;
            /**
             * For Individual Nom
            if (OldEmpty == true) {
                if (objProductNew.flt_BrdStd != "" && objProductNew.flt_BrdStd != undefined) {
                    objBreadth.Breadth.Nom.oldValue = "NA";
                    objBreadth.Breadth.Nom.newValue = objProductNew.flt_BrdStd;
                    IsChanged = true;
                }
                else {
                    objBreadth.Breadth.Nom.oldValue = false;
                    objBreadth.Breadth.Nom.newValue = false;
                    IsChanged = false;
                }
            }
            else {
                if (objProductOld.Param4_Nom === "" ||
                    objProductOld.Param4_Nom == this.strNullValue ||
                    objProductOld.Param4_Nom == undefined) {
                    objProductOld.Param4_Nom = null;
                }

                if (objProductNew.flt_BrdStd === "" ||
                    objProductNew.flt_BrdStd == this.strNullValue ||
                    objProductNew.flt_BrdStd == undefined) {
                    objProductNew.flt_BrdStd = null;
                }

                if ((objProductOld.Param4_Nom !== null) && (objProductNew.flt_BrdStd !== null)) {
                    if (parseFloat(objProductOld.Param4_Nom).toFixed(objProductOld.Param4_DP) == parseFloat(objProductNew.flt_BrdStd).toFixed(objProductNew.int_Brddp)) {
                        objBreadth.Breadth.Nom.oldValue = false;
                        objBreadth.Breadth.Nom.newValue = false;
                        IsChanged = false;
                    }
                    else {
                        objBreadth.Breadth.Nom.oldValue = parseFloat(objProductOld.Param4_Nom).toFixed(objProductOld.Param4_DP);
                        objBreadth.Breadth.Nom.newValue = parseFloat(objProductNew.flt_BrdStd).toFixed(objProductNew.int_Brddp);
                        IsChanged = true;
                    }

                } else {

                    if ((objProductOld.Param4_Nom === null) && (objProductNew.flt_BrdStd !== null)) {
                        objBreadth.Breadth.Nom.oldValue = "NA";
                        objBreadth.Breadth.Nom.newValue = parseFloat(objProductNew.flt_BrdStd).toFixed(objProductNew.int_Brddp);
                        IsChanged = true;

                    } else if ((objProductOld.Param4_Nom !== null) && (objProductNew.flt_BrdStd === null)) {
                        objBreadth.Breadth.Nom.oldValue = parseFloat(objProductOld.Param4_Nom).toFixed(objProductOld.Param4_DP);
                        objBreadth.Breadth.Nom.newValue = "NA";
                        IsChanged = true;
                    }
                }
            }
             */

            /**
             * For Individual NegT1
             */
            if (OldEmpty == true) {
                if (objProductNew.flt_BrdT1Neg != "" && objProductNew.flt_BrdT1Neg != undefined) {
                    objBreadth.Breadth['Lower Limit'].oldValue = "NA";
                    objBreadth.Breadth['Lower Limit'].newValue = objProductNew.flt_BrdT1Neg;
                    IsChanged = true;
                }
                else {
                    objBreadth.Breadth['Lower Limit'].oldValue = false;
                    objBreadth.Breadth['Lower Limit'].newValue = false;
                    IsChanged = false;
                }
            }
            else {
                if (objProductOld.Param4_T1Neg === "" ||
                    objProductOld.Param4_T1Neg == this.strNullValue ||
                    objProductOld.Param4_T1Neg == undefined) {
                    objProductOld.Param4_T1Neg = null;
                }

                if (objProductNew.flt_BrdT1Neg === "" ||
                    objProductNew.flt_BrdT1Neg == this.strNullValue ||
                    objProductNew.flt_BrdT1Neg == undefined) {
                    objProductNew.flt_BrdT1Neg = null;
                }

                if ((objProductOld.Param4_T1Neg !== null) && (objProductNew.flt_BrdT1Neg !== null)) {
                    if (parseFloat(objProductOld.Param4_T1Neg).toFixed(objProductOld.Param4_DP) == parseFloat(objProductNew.flt_BrdT1Neg).toFixed(objProductNew.int_Brddp)) {
                        objBreadth.Breadth['Lower Limit'].oldValue = false;
                        objBreadth.Breadth['Lower Limit'].newValue = false;
                        IsChanged != true ? IsChanged = false : IsChanged = true;
                    }
                    else {
                        objBreadth.Breadth['Lower Limit'].oldValue = parseFloat(objProductOld.Param4_T1Neg).toFixed(objProductOld.Param4_DP);
                        objBreadth.Breadth['Lower Limit'].newValue = parseFloat(objProductNew.flt_BrdT1Neg).toFixed(objProductNew.int_Brddp);
                        IsChanged = true;
                    }

                } else {

                    if ((objProductOld.Param4_T1Neg === null) && (objProductNew.flt_BrdT1Neg !== null)) {
                        objBreadth.Breadth['Lower Limit'].oldValue = "NA";
                        objBreadth.Breadth['Lower Limit'].newValue = parseFloat(objProductNew.flt_BrdT1Neg).toFixed(objProductNew.int_Brddp);
                        IsChanged = true;

                    } else if ((objProductOld.Param4_T1Neg !== null) && (objProductNew.flt_BrdT1Neg === null)) {
                        objBreadth.Breadth['Lower Limit'].oldValue = parseFloat(objProductOld.Param4_T1Neg).toFixed(objProductOld.Param4_DP);
                        objBreadth.Breadth['Lower Limit'].newValue = "NA";
                        IsChanged = true;
                    }
                }
            }

            /**
             * For Individual PosT1
             */
            if (OldEmpty == true) {
                if (objProductNew.flt_BrdT1Pos != "" && objProductNew.flt_BrdT1Pos != undefined) {
                    objBreadth.Breadth['Upper Limit'].oldValue = "NA";
                    objBreadth.Breadth['Upper Limit'].newValue = objProductNew.flt_BrdT1Pos;
                    IsChanged = true;
                }
                else {
                    objBreadth.Breadth['Upper Limit'].oldValue = false;
                    objBreadth.Breadth['Upper Limit'].newValue = false;
                    IsChanged = false;
                }
            }
            else {
                if (objProductOld.Param4_T1Pos === "" ||
                    objProductOld.Param4_T1Pos == this.strNullValue ||
                    objProductOld.Param4_T1Pos == undefined) {
                    objProductOld.Param4_T1Pos = null;
                }

                if (objProductNew.flt_BrdT1Pos === "" ||
                    objProductNew.flt_BrdT1Pos == this.strNullValue ||
                    objProductNew.flt_BrdT1Pos == undefined) {
                    objProductNew.flt_BrdT1Pos = null;
                }

                if ((objProductOld.Param4_T1Pos !== null) && (objProductNew.flt_BrdT1Pos !== null)) {
                    if (parseFloat(objProductOld.Param4_T1Pos).toFixed(objProductOld.Param4_DP) == parseFloat(objProductNew.flt_BrdT1Pos).toFixed(objProductNew.int_Brddp)) {
                        objBreadth.Breadth['Upper Limit'].oldValue = false;
                        objBreadth.Breadth['Upper Limit'].newValue = false;
                        IsChanged != true ? IsChanged = false : IsChanged = true;
                    }
                    else {
                        objBreadth.Breadth['Upper Limit'].oldValue = parseFloat(objProductOld.Param4_T1Pos).toFixed(objProductOld.Param4_DP);
                        objBreadth.Breadth['Upper Limit'].newValue = parseFloat(objProductNew.flt_BrdT1Pos).toFixed(objProductNew.int_Brddp);
                        IsChanged = true;
                    }

                } else {

                    if ((objProductOld.Param4_T1Pos === null) && (objProductNew.flt_BrdT1Pos !== null)) {
                        objBreadth.Breadth['Upper Limit'].oldValue = "NA";
                        objBreadth.Breadth['Upper Limit'].newValue = parseFloat(objProductNew.flt_BrdT1Pos).toFixed(objProductNew.int_Brddp);
                        IsChanged = true;

                    } else if ((objProductOld.Param4_T1Pos !== null) && (objProductNew.flt_BrdT1Pos === null)) {
                        objBreadth.Breadth['Upper Limit'].oldValue = parseFloat(objProductOld.Param4_T1Pos).toFixed(objProductOld.Param4_DP);
                        objBreadth.Breadth['Upper Limit'].newValue = "NA";
                        IsChanged = true;
                    }
                }
            }

            /**
             * For Breadth Initial Quantity
             */
            if (OldEmpty) {
                if (objProductNew.int_BrdQtyInitial != "" && objProductNew.int_BrdQtyInitial!=undefined) {
                    objBreadth.Breadth['Quantity (Initial)'].oldValue = "NA";
                    objBreadth.Breadth['Quantity (Initial)'].newValue = Number(objProductNew.int_BrdQtyInitial);
                    IsChanged = true;
                }
                else {
                    objBreadth.Breadth['Quantity (Initial)'].oldValue = false;
                    objBreadth.Breadth['Quantity (Initial)'].newValue = false;
                    IsChanged = IsChanged != true ? false : true;
                }
            }
            else {
                if (objProductOld.Param4_IniQty === "" ||
                    objProductOld.Param4_IniQty == this.strNullValue ||
                    objProductOld.Param4_IniQty == undefined) {
                    objProductOld.Param4_IniQty = null;
                }

                if (objProductNew.int_BrdQtyInitial === "" || objProductNew.int_BrdQtyInitial == this.strNullValue || objProductNew.int_BrdQtyInitial == undefined) {
                    objProductNew.int_BrdQtyInitial = null;
                }

                if ((objProductOld.Param4_IniQty !== null) && (objProductNew.int_BrdQtyInitial !== null)) {
                    if (Number(objProductOld.Param4_IniQty) == Number(objProductNew.int_BrdQtyInitial)) {
                        objBreadth.Breadth['Quantity (Initial)'].oldValue = false;
                        objBreadth.Breadth['Quantity (Initial)'].newValue = false;
                        IsChanged != true ? IsChanged = false : IsChanged = true;
                    }
                    else {
                        objBreadth.Breadth['Quantity (Initial)'].oldValue = objProductOld.Param4_IniQty;
                        objBreadth.Breadth['Quantity (Initial)'].newValue = Number(objProductNew.int_BrdQtyInitial);
                        IsChanged = true;
                    }

                } else {

                    if ((objProductOld.Param4_IniQty === null) && (objProductNew.int_BrdQtyInitial !== null)) {
                        objBreadth.Breadth['Quantity (Initial)'].oldValue = "NA";
                        objBreadth.Breadth['Quantity (Initial)'].newValue = Number(objProductNew.int_BrdQtyInitial);
                        IsChanged = true;

                    } else if ((objProductOld.Param4_IniQty !== null) && (objProductNew.int_BrdQtyInitial === null)) {
                        objBreadth.Breadth['Quantity (Initial)'].oldValue = objProductOld.Param4_IniQty;
                        objBreadth.Breadth['Quantity (Initial)'].newValue = "NA";
                        IsChanged = true;
                    }
                }
            }
            
            /**
             * For Breadth Quantity Regular
             */
            if (OldEmpty) {
                if (objProductNew.int_BrdQtyRegular != "" && objProductNew.int_BrdQtyRegular!=undefined) {
                    objBreadth.Breadth['Quantity (Regular)'].oldValue = "NA";
                    objBreadth.Breadth['Quantity (Regular)'].newValue = Number(objProductNew.int_BrdQtyRegular);
                    IsChanged = true;
                }
                else {
                    objBreadth.Breadth['Quantity (Regular)'].oldValue = false;
                    objBreadth.Breadth['Quantity (Regular)'].newValue = false;
                    IsChanged = IsChanged != true ? false : true;
                }
            }
            else {
                if (objProductOld.Param4_RegQty === "" ||
                    objProductOld.Param4_RegQty == this.strNullValue ||
                    objProductOld.Param4_RegQty == undefined) {
                    objProductOld.Param4_RegQty = null;
                }

                if (objProductNew.int_BrdQtyRegular === "" || objProductNew.int_BrdQtyRegular == this.strNullValue || objProductNew.int_BrdQtyRegular == undefined) {
                    objProductNew.int_BrdQtyRegular = null;
                }

                if ((objProductOld.Param4_RegQty !== null) && (objProductNew.int_BrdQtyRegular !== null)) {
                    if (Number(objProductOld.Param4_RegQty)== Number(objProductNew.int_BrdQtyRegular)) {
                        objBreadth.Breadth['Quantity (Regular)'].oldValue = false;
                        objBreadth.Breadth['Quantity (Regular)'].newValue = false;
                        IsChanged != true ? IsChanged = false : IsChanged = true;
                    }
                    else {
                        objBreadth.Breadth['Quantity (Regular)'].oldValue = objProductOld.Param4_RegQty;
                        objBreadth.Breadth['Quantity (Regular)'].newValue = Number(objProductNew.int_BrdQtyRegular);
                        IsChanged = true;
                    }

                } else {

                    if ((objProductOld.Param4_RegQty === null) && (objProductNew.int_BrdQtyRegular !== null)) {
                        objBreadth.Breadth['Quantity (Regular)'].oldValue = "NA";
                        objBreadth.Breadth['Quantity (Regular)'].newValue = Number(objProductNew.int_BrdQtyRegular);
                        IsChanged = true;

                    } else if ((objProductOld.Param4_RegQty !== null) && (objProductNew.int_BrdQtyRegular === null)) {
                        objBreadth.Breadth['Quantity (Regular)'].oldValue = objProductOld.Param4_RegQty;
                        objBreadth.Breadth['Quantity (Regular)'].newValue = "NA";
                        IsChanged = true;
                    }
                }
            }

            /**
            * For Individual NegT2
            if (OldEmpty == true) {
                if (objProductNew.flt_BrdT2Neg != "" && objProductNew.flt_BrdT2Neg != undefined) {
                    objBreadth.Breadth.T2Neg.oldValue = "NA";
                    objBreadth.Breadth.T2Neg.newValue = objProductNew.flt_BrdT2Neg;
                    IsChanged = true;
                }
                else {
                    objBreadth.Breadth.T2Neg.oldValue = false;
                    objBreadth.Breadth.T2Neg.newValue = false;
                    IsChanged = false;
                }
            }
            else {
                if (objProductOld.Param4_T2Neg === "" ||
                    objProductOld.Param4_T2Neg == this.strNullValue ||
                    objProductOld.Param4_T2Neg == undefined) {
                    objProductOld.Param4_T2Neg = null;
                }

                if (objProductNew.flt_BrdT2Neg === "" ||
                    objProductNew.flt_BrdT2Neg == this.strNullValue ||
                    objProductNew.flt_BrdT2Neg == undefined) {
                    objProductNew.flt_BrdT2Neg = null;
                }

                if ((objProductOld.Param4_T2Neg !== null) && (objProductNew.flt_BrdT2Neg !== null)) {
                    if (parseFloat(objProductOld.Param4_T2Neg).toFixed(objProductOld.Param4_DP) == parseFloat(objProductNew.flt_BrdT2Neg).toFixed(objProductNew.int_Brddp)) {
                        objBreadth.Breadth.T2Neg.oldValue = false;
                        objBreadth.Breadth.T2Neg.newValue = false;
                        IsChanged != true ? IsChanged = false : IsChanged = true;
                    }
                    else {
                        objBreadth.Breadth.T2Neg.oldValue = parseFloat(objProductOld.Param4_T2Neg).toFixed(objProductOld.Param4_DP);
                        objBreadth.Breadth.T2Neg.newValue = parseFloat(objProductNew.flt_BrdT2Neg).toFixed(objProductNew.int_Brddp);
                        IsChanged = true;
                    }

                } else {

                    if ((objProductOld.Param4_T2Neg === null) && (objProductNew.flt_BrdT2Neg !== null)) {
                        objBreadth.Breadth.T2Neg.oldValue = "NA";
                        objBreadth.Breadth.T2Neg.newValue = parseFloat(objProductNew.flt_BrdT2Neg).toFixed(objProductNew.int_Brddp);
                        IsChanged = true;

                    } else if ((objProductOld.Param4_T2Neg !== null) && (objProductNew.flt_BrdT2Neg === null)) {
                        objBreadth.Breadth.T2Neg.oldValue = parseFloat(objProductOld.Param4_T2Neg).toFixed(objProductOld.Param4_DP);
                        objBreadth.Breadth.T2Neg.newValue = "NA";
                        IsChanged = true;
                    }
                }
            }
            */

            /**
            * For Individual PosT2
            if (OldEmpty == true) {
                if (objProductNew.flt_BrdT2Pos != "" && objProductNew.flt_BrdT2Pos != undefined) {
                    objBreadth.Breadth.T2Pos.oldValue = "NA";
                    objBreadth.Breadth.T2Pos.newValue = objProductNew.flt_BrdT2Pos;
                    IsChanged = true;
                }
                else {
                    objBreadth.Breadth.T2Pos.oldValue = false;
                    objBreadth.Breadth.T2Pos.newValue = false;
                    IsChanged = false;
                }
            }
            else {
                if (objProductOld.Param4_T2Pos === "" ||
                    objProductOld.Param4_T2Pos == this.strNullValue ||
                    objProductOld.Param4_T2Pos == undefined) {
                    objProductOld.Param4_T2Pos = null;
                }

                if (objProductNew.flt_BrdT2Pos === "" ||
                    objProductNew.flt_BrdT2Pos == this.strNullValue ||
                    objProductNew.flt_BrdT2Pos == undefined) {
                    objProductNew.flt_BrdT2Pos = null;
                }

                if ((objProductOld.Param4_T2Pos !== null) && (objProductNew.flt_BrdT2Pos !== null)) {
                    if (parseFloat(objProductOld.Param4_T2Pos).toFixed(objProductOld.Param4_DP) == parseFloat(objProductNew.flt_BrdT2Pos).toFixed(objProductNew.int_Brddp)) {
                        objBreadth.Breadth.T2Pos.oldValue = false;
                        objBreadth.Breadth.T2Pos.newValue = false;
                        IsChanged != true ? IsChanged = false : IsChanged = true;
                    }
                    else {
                        objBreadth.Breadth.T2Pos.oldValue = parseFloat(objProductOld.Param4_T2Pos).toFixed(objProductOld.Param4_DP);
                        objBreadth.Breadth.T2Pos.newValue = parseFloat(objProductNew.flt_BrdT2Pos).toFixed(objProductNew.int_Brddp);
                        IsChanged = true;
                    }

                } else {

                    if ((objProductOld.Param4_T2Pos === null) && (objProductNew.flt_BrdT2Pos !== null)) {
                        objBreadth.Breadth.T2Pos.oldValue = "NA";
                        objBreadth.Breadth.T2Pos.newValue = parseFloat(objProductNew.flt_BrdT2Pos).toFixed(objProductNew.int_Brddp);
                        IsChanged = true;

                    } else if ((objProductOld.Param4_T2Pos !== null) && (objProductNew.flt_BrdT2Pos === null)) {
                        objBreadth.Breadth.T2Pos.oldValue = parseFloat(objProductOld.Param4_T2Pos).toFixed(objProductOld.Param4_DP);
                        objBreadth.Breadth.T2Pos.newValue = "NA";
                        IsChanged = true;
                    }
                }
            }
            */

            /**
            * For Individual NMT
            if (OldEmpty == true) {
                if (objProductNew.int_BrdNMTTabCnt != "" && objProductNew.int_BrdNMTTabCnt != undefined) {
                    objBreadth.Breadth.NMT.oldValue = "NA";
                    objBreadth.Breadth.NMT.newValue = objProductNew.int_BrdNMTTabCnt;
                    IsChanged = true;
                }
                else {
                    objBreadth.Breadth.NMT.oldValue = false;
                    objBreadth.Breadth.NMT.newValue = false;
                    IsChanged = false;
                }
            }
            else {
                if (objProductOld.Param4_NMTTab == 0 ||
                    objProductOld.Param4_NMTTab == this.NMTValue ||
                    objProductOld.Param4_NMTTab == undefined) {
                    objProductOld.Param4_NMTTab = 0;
                }

                objProductNew.int_BrdNMTTabCnt = objProductNew.int_BrdNMTTabCnt === "" ? this.strNullValue : objProductNew.int_BrdNMTTabCnt;
                
                if (objProductNew.int_BrdNMTTabCnt == "0" ||
                    objProductNew.int_BrdNMTTabCnt == this.NMTValue ||
                    objProductNew.int_BrdNMTTabCnt == undefined) {
                    objProductNew.int_BrdNMTTabCnt = 0;
                }

                if (parseInt(objProductOld.Param4_NMTTab) == parseInt(objProductNew.int_BrdNMTTabCnt)) {
                    objBreadth.Breadth.NMT.oldValue = false;
                    objBreadth.Breadth.NMT.newValue = false;
                    IsChanged != true ? IsChanged = false : IsChanged = true;
                }
                else {
                    objBreadth.Breadth.NMT.oldValue = objProductOld.Param4_NMTTab;
                    objBreadth.Breadth.NMT.newValue = objProductNew.int_BrdNMTTabCnt;
                    IsChanged = true;
                }
            }
            */

            /**
             * For Individual Limits On Standard / Avg
             */
            // if (objProductOld.Param4_IsOnStd == objProductNew.str_BrdGraphOn) {
            //     objBreadth.Breadth.GraphOn.oldValue = false;
            //     objBreadth.Breadth.GraphOn.newValue = false;
            //     IsChanged != true ? IsChanged = false : IsChanged=true;
            // }
            // else {
            //     objBreadth.Breadth.GraphOn.oldValue = Param4_IsOnStd;
            //     objBreadth.Breadth.GraphOn.newValue = str_BrdGraphOn;
            //     IsChanged = true;
            // }

            /**
             * 
            if (OldEmpty) {
                if (objProductNew.str_verUnit != "" && objProductNew.flt_BrdStd != "" && objProductNew.str_verUnit != undefined && objProductNew.flt_BrdStd != undefined) {
                    objBreadth.Breadth.Unit.oldValue = "NA";
                    objBreadth.Breadth.Unit.newValue = objProductNew.str_verUnit;
                    IsChanged = true;
                }
                else {
                    objBreadth.Breadth.Unit.oldValue = false;
                    objBreadth.Breadth.Unit.newValue = false;
                    IsChanged = IsChanged != true ? false : true;
                }
            }
            else {
                objProductOld.Param4_Unit == "NA" ? objProductOld.Param4_Unit = "mm" : objProductOld.Param4_Unit;
                if (objProductOld.Param4_Nom == null && objProductNew.flt_BrdStd != null) { // new parameter added
                    objBreadth.Breadth.Unit.oldValue = "mm";
                    objBreadth.Breadth.Unit.newValue = objProductNew.str_verUnit;
                    IsChanged = true;
                }
                else if (objProductOld.Param4_Unit == null && objProductNew.str_verUnit == null) // no parameter added
                {
                    objBreadth.Breadth.Unit.oldValue = false;
                    objBreadth.Breadth.Unit.newValue = false;
                    IsChanged = false;
                }
                else {
                    if (objProductOld.Param4_Unit == objProductNew.str_verUnit) {
                        objBreadth.Breadth.Unit.oldValue = false;
                        objBreadth.Breadth.Unit.newValue = false;
                        IsChanged != true ? IsChanged = false : IsChanged = true;
                    }
                    else {
                        objBreadth.Breadth.Unit.oldValue = objProductOld.Param4_Unit;
                        objBreadth.Breadth.Unit.newValue = objProductNew.str_verUnit;
                        IsChanged = true;
                    }
                }
            }
             */


            if (IsChanged == true) {
                Object.assign(this.objResult, objBreadth);
            }
            resolve(IsChanged);
        });
    }

    validateLength(objProductOld, objProductNew,int_tabCap) {
        return new Promise((resolve, reject) => {
            const objLength = {
                Length: {
                    Nom: { oldValue: "", newValue: "" },
                    // T1Neg: { oldValue: "", newValue: "" },
                    // T1Pos: { oldValue: "", newValue: "" },
                    'Lower Limit': { oldValue: "", newValue: "" },
                    'Upper Limit': { oldValue: "", newValue: "" },
                    T2Neg: { oldValue: "", newValue: "" },
                    T2Pos: { oldValue: "", newValue: "" },
                    T3Neg: { oldValue: "", newValue: "" },
                    T3Pos: { oldValue: "", newValue: "" },
                    NMT: { oldValue: "", newValue: "" },
                    //GraphOn: { oldValue: "", newValue: "" }
                    Unit:{ oldValue: "", newValue: "" },
                    "Quantity (Initial)":{ oldValue: "", newValue: "" },
                    "Quantity (Regular)":{ oldValue: "", newValue: "" }
                }
            };

            var IsChanged = false;
            var OldEmpty = objProductOld == undefined ? true : false;

            /**
             * For Individual Nom
            if (OldEmpty == true) {
                if (objProductNew.flt_LenStd != "" && objProductNew.flt_LenStd != undefined) {
                    objLength.Length.Nom.oldValue = "NA";
                    objLength.Length.Nom.newValue = objProductNew.flt_LenStd;
                    IsChanged = true;
                }
                else {
                    objLength.Length.Nom.oldValue = false;
                    objLength.Length.Nom.newValue = false;
                    IsChanged = false;
                }
            }
            else {
                if (objProductOld.Param5_Nom === "" ||
                    objProductOld.Param5_Nom == this.strNullValue ||
                    objProductOld.Param5_Nom == undefined) {
                    objProductOld.Param5_Nom = null;
                }

                if (objProductNew.flt_LenStd === "" ||
                    objProductNew.flt_LenStd == this.strNullValue ||
                    objProductNew.flt_LenStd == undefined) {
                    objProductNew.flt_LenStd = null;
                }

                if ((objProductOld.Param5_Nom !== null) && (objProductNew.flt_LenStd !== null)) {
                    if (parseFloat(objProductOld.Param5_Nom).toFixed(objProductOld.Param5_DP) == parseFloat(objProductNew.flt_LenStd).toFixed(objProductNew.int_LenDp)) {
                        objLength.Length.Nom.oldValue = false;
                        objLength.Length.Nom.newValue = false;
                        IsChanged = false;
                    }
                    else {
                        objLength.Length.Nom.oldValue = parseFloat(objProductOld.Param5_Nom).toFixed(objProductOld.Param5_DP);
                        objLength.Length.Nom.newValue = parseFloat(objProductNew.flt_LenStd).toFixed(objProductNew.int_LenDp);
                        IsChanged = true;
                    }

                } else {

                    if ((objProductOld.Param5_Nom === null) && (objProductNew.flt_LenStd !== null)) {
                        objLength.Length.Nom.oldValue = "NA";
                        objLength.Length.Nom.newValue = parseFloat(objProductNew.flt_LenStd).toFixed(objProductNew.int_LenDp);
                        IsChanged = true;

                    } else if ((objProductOld.Param5_Nom !== null) && (objProductNew.flt_LenStd === null)) {
                        objLength.Length.Nom.oldValue = parseFloat(objProductOld.Param5_Nom).toFixed(objProductOld.Param5_DP);
                        objLength.Length.Nom.newValue = "NA";
                        IsChanged = true;
                    }
                }
            }
             */

            /**
             * For Individual NegT1
             */
            if (OldEmpty == true) {
                if (objProductNew.flt_LenT1Neg != "" && objProductNew.flt_LenT1Neg != undefined) {
                    objLength.Length['Lower Limit'].oldValue = "NA";
                    objLength.Length['Lower Limit'].newValue = objProductNew.flt_LenT1Neg;
                    IsChanged = true;
                }
                else {
                    objLength.Length['Lower Limit'].oldValue = false;
                    objLength.Length['Lower Limit'].newValue = false;
                    IsChanged = false;
                }
            }
            else {
                if (objProductOld.Param5_T1Neg === "" ||
                    objProductOld.Param5_T1Neg == this.strNullValue ||
                    objProductOld.Param5_T1Neg == undefined) {
                    objProductOld.Param5_T1Neg = null;
                }

                if (objProductNew.flt_LenT1Neg === "" ||
                    objProductNew.flt_LenT1Neg == this.strNullValue ||
                    objProductNew.flt_LenT1Neg == undefined) {
                    objProductNew.flt_LenT1Neg = null;
                }

                if ((objProductOld.Param5_T1Neg !== null) && (objProductNew.flt_LenT1Neg !== null)) {
                    if (parseFloat(objProductOld.Param5_T1Neg).toFixed(objProductOld.Param5_DP) == parseFloat(objProductNew.flt_LenT1Neg).toFixed(objProductNew.int_LenDp)) {
                        objLength.Length['Lower Limit'].oldValue = false;
                        objLength.Length['Lower Limit'].newValue = false;
                        IsChanged != true ? IsChanged = false : IsChanged = true;
                    }
                    else {
                        objLength.Length['Lower Limit'].oldValue = parseFloat(objProductOld.Param5_T1Neg).toFixed(objProductOld.Param5_DP);
                        objLength.Length['Lower Limit'].newValue = parseFloat(objProductNew.flt_LenT1Neg).toFixed(objProductNew.int_LenDp);
                        IsChanged = true;
                    }

                } else {

                    if ((objProductOld.Param5_T1Neg === null) && (objProductNew.flt_LenT1Neg !== null)) {
                        objLength.Length['Lower Limit'].oldValue = "NA";
                        objLength.Length['Lower Limit'].newValue = parseFloat(objProductNew.flt_LenT1Neg).toFixed(objProductNew.int_LenDp);
                        IsChanged = true;

                    } else if ((objProductOld.Param5_T1Neg !== null) && (objProductNew.flt_LenT1Neg === null)) {
                        objLength.Length['Lower Limit'].oldValue = parseFloat(objProductOld.Param5_T1Neg).toFixed(objProductOld.Param5_DP);
                        objLength.Length['Lower Limit'].newValue = "NA";
                        IsChanged = true;
                    }
                }
            }

            /**
             * For Individual PosT1
             */
            if (OldEmpty == true) {
                if (objProductNew.flt_LenT1Pos != "" && objProductNew.flt_LenT1Pos != undefined) {
                    objLength.Length['Upper Limit'].oldValue = "NA";
                    objLength.Length['Upper Limit'].newValue = objProductNew.flt_LenT1Pos;
                    IsChanged = true;
                }
                else {
                    objLength.Length['Upper Limit'].oldValue = false;
                    objLength.Length['Upper Limit'].newValue = false;
                    IsChanged = false;
                }
            }
            else {
                if (objProductOld.Param5_T1Pos === "" ||
                    objProductOld.Param5_T1Pos == this.strNullValue ||
                    objProductOld.Param5_T1Pos == undefined) {
                    objProductOld.Param5_T1Pos = null;
                }

                if (objProductNew.flt_LenT1Pos === "" ||
                    objProductNew.flt_LenT1Pos == this.strNullValue ||
                    objProductNew.flt_LenT1Pos == undefined) {
                    objProductNew.flt_LenT1Pos = null;
                }

                if ((objProductOld.Param5_T1Pos !== null) && (objProductNew.flt_LenT1Pos !== null)) {
                    if (parseFloat(objProductOld.Param5_T1Pos).toFixed(objProductOld.Param5_DP) == parseFloat(objProductNew.flt_LenT1Pos).toFixed(objProductNew.int_LenDp)) {
                        objLength.Length['Upper Limit'].oldValue = false;
                        objLength.Length['Upper Limit'].newValue = false;
                        IsChanged != true ? IsChanged = false : IsChanged = true;
                    }
                    else {
                        objLength.Length['Upper Limit'].oldValue = parseFloat(objProductOld.Param5_T1Pos).toFixed(objProductOld.Param5_DP);
                        objLength.Length['Upper Limit'].newValue = parseFloat(objProductNew.flt_LenT1Pos).toFixed(objProductNew.int_LenDp);
                        IsChanged = true;
                    }

                } else {

                    if ((objProductOld.Param5_T1Pos === null) && (objProductNew.flt_LenT1Pos !== null)) {
                        objLength.Length['Upper Limit'].oldValue = "NA";
                        objLength.Length['Upper Limit'].newValue = parseFloat(objProductNew.flt_LenT1Pos).toFixed(objProductNew.int_LenDp);
                        IsChanged = true;

                    } else if ((objProductOld.Param5_T1Pos !== null) && (objProductNew.flt_LenT1Pos === null)) {
                        objLength.Length['Upper Limit'].oldValue = parseFloat(objProductOld.Param5_T1Pos).toFixed(objProductOld.Param5_DP);
                        objLength.Length['Upper Limit'].newValue = "NA";
                        IsChanged = true;
                    }
                }
            }

            /**
             * For objLength Initial Quantity
             */
            if (OldEmpty) {
                if (objProductNew.int_LenQtyInitial != "" && objProductNew.int_LenQtyInitial!=undefined) {
                    objLength.Length['Quantity (Initial)'].oldValue = "NA";
                    objLength.Length['Quantity (Initial)'].newValue = Number(objProductNew.int_LenQtyInitial);
                    IsChanged = true;
                }
                else {
                    objLength.Length['Quantity (Initial)'].oldValue = false;
                    objLength.Length['Quantity (Initial)'].newValue = false;
                    IsChanged = IsChanged != true ? false : true;
                }
            }
            else {
                if (objProductOld.Param5_IniQty === "" ||
                    objProductOld.Param5_IniQty == this.strNullValue ||
                    objProductOld.Param5_IniQty == undefined) {
                    objProductOld.Param5_IniQty = null;
                }

                if (objProductNew.int_LenQtyInitial === "" || objProductNew.int_LenQtyInitial == this.strNullValue || objProductNew.int_LenQtyInitial == undefined) {
                    objProductNew.int_LenQtyInitial = null;
                }

                if ((objProductOld.Param5_IniQty !== null) && (objProductNew.int_LenQtyInitial !== null)) {
                    if (Number(objProductOld.Param5_IniQty) == Number(objProductNew.int_LenQtyInitial)) {
                        objLength.Length['Quantity (Initial)'].oldValue = false;
                        objLength.Length['Quantity (Initial)'].newValue = false;
                        IsChanged != true ? IsChanged = false : IsChanged = true;
                    }
                    else {
                        objLength.Length['Quantity (Initial)'].oldValue = objProductOld.Param5_IniQty;
                        objLength.Length['Quantity (Initial)'].newValue = Number(objProductNew.int_LenQtyInitial);
                        IsChanged = true;
                    }

                } else {

                    if ((objProductOld.Param5_IniQty === null) && (objProductNew.int_LenQtyInitial !== null)) {
                        objLength.Length['Quantity (Initial)'].oldValue = "NA";
                        objLength.Length['Quantity (Initial)'].newValue = Number(objProductNew.int_LenQtyInitial);
                        IsChanged = true;

                    } else if ((objProductOld.Param5_IniQty !== null) && (objProductNew.int_LenQtyInitial === null)) {
                        objLength.Length['Quantity (Initial)'].oldValue = objProductOld.Param5_IniQty;
                        objLength.Length['Quantity (Initial)'].newValue = "NA";
                        IsChanged = true;
                    }
                }
            }
            
            /**
             * For Breadth Quantity Regular
             */
            if (OldEmpty) {
                if (objProductNew.int_LenQtyRegular != "" && objProductNew.int_LenQtyRegular!=undefined) {
                    objLength.Length['Quantity (Regular)'].oldValue = "NA";
                    objLength.Length['Quantity (Regular)'].newValue = Number(objProductNew.int_LenQtyRegular);
                    IsChanged = true;
                }
                else {
                    objLength.Length['Quantity (Regular)'].oldValue = false;
                    objLength.Length['Quantity (Regular)'].newValue = false;
                    IsChanged = IsChanged != true ? false : true;
                }
            }
            else {
                if (objProductOld.Param5_RegQty === "" ||
                    objProductOld.Param5_RegQty == this.strNullValue ||
                    objProductOld.Param5_RegQty == undefined) {
                    objProductOld.Param5_RegQty = null;
                }

                if (objProductNew.int_LenQtyRegular === "" || objProductNew.int_LenQtyRegular == this.strNullValue || objProductNew.int_LenQtyRegular == undefined) {
                    objProductNew.int_LenQtyRegular = null;
                }

                if ((objProductOld.Param5_RegQty !== null) && (objProductNew.int_LenQtyRegular !== null)) {
                    if (Number(objProductOld.Param5_RegQty)== Number(objProductNew.int_LenQtyRegular)) {
                        objLength.Length['Quantity (Regular)'].oldValue = false;
                        objLength.Length['Quantity (Regular)'].newValue = false;
                        IsChanged != true ? IsChanged = false : IsChanged = true;
                    }
                    else {
                        objLength.Length['Quantity (Regular)'].oldValue = objProductOld.Param5_RegQty;
                        objLength.Length['Quantity (Regular)'].newValue = Number(objProductNew.int_LenQtyRegular);
                        IsChanged = true;
                    }

                } else {

                    if ((objProductOld.Param5_RegQty === null) && (objProductNew.int_LenQtyRegular !== null)) {
                        objLength.Length['Quantity (Regular)'].oldValue = "NA";
                        objLength.Length['Quantity (Regular)'].newValue = Number(objProductNew.int_LenQtyRegular);
                        IsChanged = true;

                    } else if ((objProductOld.Param5_RegQty !== null) && (objProductNew.int_LenQtyRegular === null)) {
                        objLength.Length['Quantity (Regular)'].oldValue = objProductOld.Param5_RegQty;
                        objLength.Length['Quantity (Regular)'].newValue = "NA";
                        IsChanged = true;
                    }
                }
            }

            /**
            * For Individual NegT2
            if (OldEmpty == true) {
                if (objProductNew.flt_LenT2Neg != "" && objProductNew.flt_LenT2Neg != undefined) {
                    objLength.Length.T2Neg.oldValue = "NA";
                    objLength.Length.T2Neg.newValue = objProductNew.flt_LenT2Neg;
                    IsChanged = true;
                }
                else {
                    objLength.Length.T2Neg.oldValue = false;
                    objLength.Length.T2Neg.newValue = false;
                    IsChanged = false;
                }
            }
            else {
                if (objProductOld.Param5_T2Neg === "" ||
                    objProductOld.Param5_T2Neg == this.strNullValue ||
                    objProductOld.Param5_T2Neg == undefined) {
                    objProductOld.Param5_T2Neg = null;
                }

                if (objProductNew.flt_LenT2Neg === "" ||
                    objProductNew.flt_LenT2Neg == this.strNullValue ||
                    objProductNew.flt_LenT2Neg == undefined) {
                    objProductNew.flt_LenT2Neg = null;
                }

                if ((objProductOld.Param5_T2Neg !== null) && (objProductNew.flt_LenT2Neg !== null)) {
                    if (parseFloat(objProductOld.Param5_T2Neg).toFixed(objProductOld.Param5_DP) == parseFloat(objProductNew.flt_LenT2Neg).toFixed(objProductNew.int_LenDp)) {
                        objLength.Length.T2Neg.oldValue = false;
                        objLength.Length.T2Neg.newValue = false;
                        IsChanged != true ? IsChanged = false : IsChanged = true;
                    }
                    else {
                        objLength.Length.T2Neg.oldValue = parseFloat(objProductOld.Param5_T2Neg).toFixed(objProductOld.Param5_DP);
                        objLength.Length.T2Neg.newValue = parseFloat(objProductNew.flt_LenT2Neg).toFixed(objProductNew.int_LenDp);
                        IsChanged = true;
                    }

                } else {

                    if ((objProductOld.Param5_T2Neg === null) && (objProductNew.flt_LenT2Neg !== null)) {
                        objLength.Length.T2Neg.oldValue = "NA";
                        objLength.Length.T2Neg.newValue = parseFloat(objProductNew.flt_LenT2Neg).toFixed(objProductNew.int_LenDp);
                        IsChanged = true;

                    } else if ((objProductOld.Param5_T2Neg !== null) && (objProductNew.flt_LenT2Neg === null)) {
                        objLength.Length.T2Neg.oldValue = parseFloat(objProductOld.Param5_T2Neg).toFixed(objProductOld.Param5_DP);
                        objLength.Length.T2Neg.newValue = "NA";
                        IsChanged = true;
                    }
                }
            }
            */

            /**
            * For Individual PosT2
            if (OldEmpty == true) {
                if (objProductNew.flt_LenT2Pos != "" && objProductNew.flt_LenT2Pos != undefined) {
                    objLength.Length.T2Pos.oldValue = "NA";
                    objLength.Length.T2Pos.newValue = objProductNew.flt_LenT2Pos;
                    IsChanged = true;
                }
                else {
                    objLength.Length.T2Pos.oldValue = false;
                    objLength.Length.T2Pos.newValue = false;
                    IsChanged = false;
                }
            }
            else {
                if (objProductOld.Param5_T2Pos === "" ||
                    objProductOld.Param5_T2Pos == this.strNullValue ||
                    objProductOld.Param5_T2Pos == undefined) {
                    objProductOld.Param5_T2Pos = null;
                }

                if (objProductNew.flt_LenT2Pos === "" ||
                    objProductNew.flt_LenT2Pos == this.strNullValue ||
                    objProductNew.flt_LenT2Pos == undefined) {
                    objProductNew.flt_LenT2Pos = null;
                }

                if ((objProductOld.Param5_T2Pos !== null) && (objProductNew.flt_LenT2Pos !== null)) {
                    if (parseFloat(objProductOld.Param5_T2Pos).toFixed(objProductOld.Param5_DP) == parseFloat(objProductNew.flt_LenT2Pos).toFixed(objProductNew.int_LenDp)) {
                        objLength.Length.T2Pos.oldValue = false;
                        objLength.Length.T2Pos.newValue = false;
                        IsChanged != true ? IsChanged = false : IsChanged = true;
                    }
                    else {
                        objLength.Length.T2Pos.oldValue = parseFloat(objProductOld.Param5_T2Pos).toFixed(objProductOld.Param5_DP);
                        objLength.Length.T2Pos.newValue = parseFloat(objProductNew.flt_LenT2Pos).toFixed(objProductNew.int_LenDp);
                        IsChanged = true;
                    }

                } else {

                    if ((objProductOld.Param5_T2Pos === null) && (objProductNew.flt_LenT2Pos !== null)) {
                        objLength.Length.T2Pos.oldValue = "NA";
                        objLength.Length.T2Pos.newValue = parseFloat(objProductNew.flt_LenT2Pos).toFixed(objProductNew.int_LenDp);
                        IsChanged = true;

                    } else if ((objProductOld.Param5_T2Pos !== null) && (objProductNew.flt_LenT2Pos === null)) {
                        objLength.Length.T2Pos.oldValue = parseFloat(objProductOld.Param5_T2Pos).toFixed(objProductOld.Param5_DP);
                        objLength.Length.T2Pos.newValue = "NA";
                        IsChanged = true;
                    }
                }
            }
            */

            /**
            * For Individual NegT3
            if (OldEmpty == true) {
                if (objProductNew.flt_LenT3Neg != "" && objProductNew.flt_LenT3Neg != undefined) {
                    objLength.Length.T3Neg.oldValue = "NA";
                    objLength.Length.T3Neg.newValue = objProductNew.flt_LenT3Neg;
                    IsChanged = true;
                }
                else {
                    objLength.Length.T3Neg.oldValue = false;
                    objLength.Length.T3Neg.newValue = false;
                    IsChanged = false;
                }
            }
            else {
                if (objProductOld.Param5_T3Neg === "" ||
                    objProductOld.Param5_T3Neg == this.strNullValue ||
                    objProductOld.Param5_T3Neg == undefined) {
                    objProductOld.Param5_T3Neg = null;
                }

                if (objProductNew.flt_LenT3Neg === "" ||
                    objProductNew.flt_LenT3Neg == this.strNullValue ||
                    objProductNew.flt_LenT3Neg == undefined) {
                    objProductNew.flt_LenT3Neg = null;
                }

                if ((objProductOld.Param5_T3Neg !== null) && (objProductNew.flt_LenT3Neg !== null)) {
                    if (parseFloat(objProductOld.Param5_T3Neg).toFixed(objProductOld.Param5_DP) == parseFloat(objProductNew.flt_LenT3Neg).toFixed(objProductNew.int_LenDp)) {
                        objLength.Length.T3Neg.oldValue = false;
                        objLength.Length.T3Neg.newValue = false;
                        IsChanged != true ? IsChanged = false : IsChanged = true;
                    }
                    else {
                        objLength.Length.T3Neg.oldValue = parseFloat(objProductOld.Param5_T3Neg).toFixed(objProductOld.Param5_DP);
                        objLength.Length.T3Neg.newValue = parseFloat(objProductNew.flt_LenT3Neg).toFixed(objProductNew.int_LenDp);
                        IsChanged = true;
                    }

                } else {

                    if ((objProductOld.Param5_T3Neg === null) && (objProductNew.flt_LenT3Neg !== null)) {
                        objLength.Length.T3Neg.oldValue = "NA";
                        objLength.Length.T3Neg.newValue = parseFloat(objProductNew.flt_LenT3Neg).toFixed(objProductNew.int_LenDp);
                        IsChanged = true;

                    } else if ((objProductOld.Param5_T3Neg !== null) && (objProductNew.flt_LenT3Neg === null)) {
                        objLength.Length.T3Neg.oldValue = parseFloat(objProductOld.Param5_T3Neg).toFixed(objProductOld.Param5_DP);
                        objLength.Length.T3Neg.newValue = "NA";
                        IsChanged = true;
                    }
                }
            }
            */

            /**
            * For Individual PosT3
            if (OldEmpty == true) {
                if (objProductNew.flt_LenT3Pos != "" && objProductNew.flt_LenT3Pos != undefined) {
                    objLength.Length.T3Pos.oldValue = "NA";
                    objLength.Length.T3Pos.newValue = objProductNew.flt_LenT3Pos;
                    IsChanged = true;
                }
                else {
                    objLength.Length.T3Pos.oldValue = false;
                    objLength.Length.T3Pos.newValue = false;
                    IsChanged = false;
                }
            }
            else {
                if (objProductOld.Param5_T3Pos === "" ||
                    objProductOld.Param5_T3Pos == this.strNullValue ||
                    objProductOld.Param5_T3Pos == undefined) {
                    objProductOld.Param5_T3Pos = null;
                }

                if (objProductNew.flt_LenT3Pos === "" ||
                    objProductNew.flt_LenT3Pos == this.strNullValue ||
                    objProductNew.flt_LenT3Pos == undefined) {
                    objProductNew.flt_LenT3Pos = null;
                }

                if ((objProductOld.Param5_T3Pos !== null) && (objProductNew.flt_LenT3Pos !== null)) {
                    if (parseFloat(objProductOld.Param5_T3Pos).toFixed(objProductOld.Param5_DP) == parseFloat(objProductNew.flt_LenT3Pos).toFixed(objProductNew.int_LenDp)) {
                        objLength.Length.T3Pos.oldValue = false;
                        objLength.Length.T3Pos.newValue = false;
                        IsChanged != true ? IsChanged = false : IsChanged = true;
                    }
                    else {
                        objLength.Length.T3Pos.oldValue = parseFloat(objProductOld.Param5_T3Pos).toFixed(objProductOld.Param5_DP);
                        objLength.Length.T3Pos.newValue = parseFloat(objProductNew.flt_LenT3Pos).toFixed(objProductNew.int_LenDp);
                        IsChanged = true;
                    }

                } else {

                    if ((objProductOld.Param5_T3Pos === null) && (objProductNew.flt_LenT3Pos !== null)) {
                        objLength.Length.T3Pos.oldValue = "NA";
                        objLength.Length.T3Pos.newValue = parseFloat(objProductNew.flt_LenT3Pos).toFixed(objProductNew.int_LenDp);
                        IsChanged = true;

                    } else if ((objProductOld.Param5_T3Pos !== null) && (objProductNew.flt_LenT3Pos === null)) {
                        objLength.Length.T3Pos.oldValue = parseFloat(objProductOld.Param5_T3Pos).toFixed(objProductOld.Param5_DP);
                        objLength.Length.T3Pos.newValue = "NA";
                        IsChanged = true;
                    }
                }
            }
            */

            /**
            * For Individual NMT
            if (OldEmpty == true) {
                if (objProductNew.int_LenNMTTabCnt != "") {
                    objLength.Length.NMT.oldValue = "NA";
                    objLength.Length.NMT.newValue = objProductNew.int_LenNMTTabCnt;
                    IsChanged = true;
                }
                else {
                    objLength.Length.NMT.oldValue = false;
                    objLength.Length.NMT.newValue = false;
                    IsChanged = false;
                }
            }
            else {
                if (objProductOld.Param5_NMTTab == 0 ||
                    objProductOld.Param5_NMTTab == this.NMTValue ||
                    objProductOld.Param5_NMTTab == undefined) {
                    objProductOld.Param5_NMTTab = 0;
                }

                objProductNew.int_LenNMTTabCnt = objProductNew.int_LenNMTTabCnt === "" ? this.strNullValue : objProductNew.int_LenNMTTabCnt;
                
                if (objProductNew.int_LenNMTTabCnt == "0" ||
                    objProductNew.int_LenNMTTabCnt == this.NMTValue ||
                    objProductNew.int_LenNMTTabCnt == undefined) {
                    objProductNew.int_LenNMTTabCnt = 0;
                }

                if (parseInt(objProductOld.Param5_NMTTab) == parseInt(objProductNew.int_LenNMTTabCnt)) {
                    objLength.Length.NMT.oldValue = false;
                    objLength.Length.NMT.newValue = false;
                    IsChanged != true ? IsChanged = false : IsChanged = true;
                }
                else {
                    objLength.Length.NMT.oldValue = objProductOld.Param5_NMTTab;
                    objLength.Length.NMT.newValue = objProductNew.int_LenNMTTabCnt;
                    IsChanged = true;
                }
            }
             */

            /**
             * For Individual Limits On Standard / Avg
             */
            // if (objProductOld.Param5_IsOnStd == objProductNew.str_LenGraphOn) {
            //     objLength.objLength.GraphOn.oldValue = false;
            //     objLength.objLength.GraphOn.newValue = false;
            //     IsChanged != true ? IsChanged = false : IsChanged=true;
            // }
            // else {
            //     objLength.objLength.GraphOn.oldValue = Param5_IsOnStd;
            //     objLength.objLength.GraphOn.newValue = str_LenGraphOn;
            //     IsChanged = true;
            // }

            /**
             * 
            if (OldEmpty) {
                if (objProductNew.str_verUnit != "" && objProductNew.flt_LenStd != "" && objProductNew.str_verUnit != undefined && objProductNew.flt_LenStd != undefined) {
                    objLength.Length.Unit.oldValue = "NA";
                    objLength.Length.Unit.newValue = objProductNew.str_verUnit;
                    IsChanged = true;
                }
                else {
                    objLength.Length.Unit.oldValue = false;
                    objLength.Length.Unit.newValue = false;
                    IsChanged = IsChanged != true ? false : true;
                }
            }
            else {
                objProductOld.Param5_Unit == "NA" ? objProductOld.Param5_Unit = "mm" : objProductOld.Param5_Unit;
                if (objProductOld.Param5_Nom == null && objProductNew.flt_LenStd != null) { // new parameter added
                    objLength.Length.Unit.oldValue = "mm";
                    objLength.Length.Unit.newValue = objProductNew.str_verUnit;
                    IsChanged = true;
                }
                else if (objProductOld.Param5_Unit == null && objProductNew.str_verUnit == null) // no parameter added
                {
                    objLength.Length.Unit.oldValue = false;
                    objLength.Length.Unit.newValue = false;
                    IsChanged = false;
                }
                else {
                    if (objProductOld.Param5_Unit == objProductNew.str_verUnit) {
                        objLength.Length.Unit.oldValue = false;
                        objLength.Length.Unit.newValue = false;
                        IsChanged != true ? IsChanged = false : IsChanged = true;
                    }
                    else {
                        objLength.Length.Unit.oldValue = objProductOld.Param5_Unit;
                        objLength.Length.Unit.newValue = objProductNew.str_verUnit;
                        IsChanged = true;
                    }
                }
            }
             */

            if (IsChanged == true) {
                Object.assign(this.objResult, objLength);
            }
            resolve(IsChanged);
        });
    }

    validateDiameter(objProductOld, objProductNew) {
        return new Promise((resolve, reject) => {
            const objDiameter = {
                Diameter: {
                    Nom: { oldValue: "", newValue: "" },
                    // T1Neg: { oldValue: "", newValue: "" },
                    // T1Pos: { oldValue: "", newValue: "" },
                    'Lower Limit': { oldValue: "", newValue: "" },
                    'Upper Limit': { oldValue: "", newValue: "" },
                    T2Neg: { oldValue: "", newValue: "" },
                    T2Pos: { oldValue: "", newValue: "" },
                    T3Neg: { oldValue: "", newValue: "" },
                    T3Pos: { oldValue: "", newValue: "" },
                    NMT: { oldValue: "", newValue: "" },
                    //GraphOn: { oldValue: "", newValue: "" }
                    Unit:{ oldValue: "", newValue: "" },
                    "Quantity (Initial)":{ oldValue: "", newValue: "" },
                    "Quantity (Regular)":{ oldValue: "", newValue: "" }
                }
            };

            var IsChanged = false;
            var OldEmpty = objProductOld == undefined ? true : false;
            /**
             * For Individual Nom
            if (OldEmpty == true) {
                if (objProductNew.flt_DiaStd != "" && objProductNew.flt_DiaStd != undefined) {
                    objDiameter.Diameter.Nom.oldValue = "NA";
                    objDiameter.Diameter.Nom.newValue = objProductNew.flt_DiaStd;
                    IsChanged = true;
                }
                else {
                    objDiameter.Diameter.Nom.oldValue = false;
                    objDiameter.Diameter.Nom.newValue = false;
                    IsChanged = false;
                }
            }
            else {
                if (objProductOld.Param6_Nom === "" ||
                    objProductOld.Param6_Nom == this.strNullValue ||
                    objProductOld.Param6_Nom == undefined) {
                    objProductOld.Param6_Nom = null;
                }

                if (objProductNew.flt_DiaStd === "" ||
                    objProductNew.flt_DiaStd == this.strNullValue ||
                    objProductNew.flt_DiaStd == undefined) {
                    objProductNew.flt_DiaStd = null;
                }

                if ((objProductOld.Param6_Nom !== null) && (objProductNew.flt_DiaStd !== null)) {
                    if (parseFloat(objProductOld.Param6_Nom).toFixed(objProductOld.Param6_DP) == parseFloat(objProductNew.flt_DiaStd).toFixed(objProductNew.int_DiaDp)) {
                        objDiameter.Diameter.Nom.oldValue = false;
                        objDiameter.Diameter.Nom.newValue = false;
                        IsChanged = false;
                    }
                    else {
                        objDiameter.Diameter.Nom.oldValue = parseFloat(objProductOld.Param6_Nom).toFixed(objProductOld.Param6_DP);
                        objDiameter.Diameter.Nom.newValue = parseFloat(objProductNew.flt_DiaStd).toFixed(objProductNew.int_DiaDp);
                        IsChanged = true;
                    }

                } else {

                    if ((objProductOld.Param6_Nom === null) && (objProductNew.flt_DiaStd !== null)) {
                        objDiameter.Diameter.Nom.oldValue = "NA";
                        objDiameter.Diameter.Nom.newValue = parseFloat(objProductNew.flt_DiaStd).toFixed(objProductNew.int_DiaDp);
                        IsChanged = true;

                    } else if ((objProductOld.Param6_Nom !== null) && (objProductNew.flt_DiaStd === null)) {
                        objDiameter.Diameter.Nom.oldValue = parseFloat(objProductOld.Param6_Nom).toFixed(objProductOld.Param6_DP);
                        objDiameter.Diameter.Nom.newValue = "NA";
                        IsChanged = true;
                    }
                }
            }
             */
           
            /**
             * For Individual NegT1
             */
            if (OldEmpty == true) {
                if (objProductNew.flt_DiaT1Neg != "" && objProductNew.flt_DiaT1Neg != undefined) {
                    objDiameter.Diameter['Lower Limit'].oldValue = "NA";
                    objDiameter.Diameter['Lower Limit'].newValue = objProductNew.flt_DiaT1Neg;
                    IsChanged = true;
                }
                else {
                    objDiameter.Diameter['Lower Limit'].oldValue = false;
                    objDiameter.Diameter['Lower Limit'].newValue = false;
                    IsChanged = false;
                }
            }
            else {
                if (objProductOld.Param6_T1Neg === "" ||
                    objProductOld.Param6_T1Neg == this.strNullValue ||
                    objProductOld.Param6_T1Neg == undefined) {
                    objProductOld.Param6_T1Neg = null;
                }

                if (objProductNew.flt_DiaT1Neg === "" ||
                    objProductNew.flt_DiaT1Neg == this.strNullValue ||
                    objProductNew.flt_DiaT1Neg == undefined) {
                    objProductNew.flt_DiaT1Neg = null;
                }

                if ((objProductOld.Param6_T1Neg !== null) && (objProductNew.flt_DiaT1Neg !== null)) {
                    if (parseFloat(objProductOld.Param6_T1Neg).toFixed(objProductOld.Param6_DP) == parseFloat(objProductNew.flt_DiaT1Neg).toFixed(objProductNew.int_DiaDp)) {
                        objDiameter.Diameter['Lower Limit'].oldValue = false;
                        objDiameter.Diameter['Lower Limit'].newValue = false;
                        IsChanged != true ? IsChanged = false : IsChanged = true;
                    }
                    else {
                        objDiameter.Diameter['Lower Limit'].oldValue = parseFloat(objProductOld.Param6_T1Neg).toFixed(objProductOld.Param6_DP);
                        objDiameter.Diameter['Lower Limit'].newValue = parseFloat(objProductNew.flt_DiaT1Neg).toFixed(objProductNew.int_DiaDp);
                        IsChanged = true;
                    }

                } else {

                    if ((objProductOld.Param6_T1Neg === null) && (objProductNew.flt_DiaT1Neg !== null)) {
                        objDiameter.Diameter['Lower Limit'].oldValue = "NA";
                        objDiameter.Diameter['Lower Limit'].newValue = parseFloat(objProductNew.flt_DiaT1Neg).toFixed(objProductNew.int_DiaDp);
                        IsChanged = true;

                    } else if ((objProductOld.Param6_T1Neg !== null) && (objProductNew.flt_DiaT1Neg === null)) {
                        objDiameter.Diameter['Lower Limit'].oldValue = parseFloat(objProductOld.Param6_T1Neg).toFixed(objProductOld.Param6_DP);
                        objDiameter.Diameter['Lower Limit'].newValue = "NA";
                        IsChanged = true;
                    }
                }
            }
            
            /**
             * For Individual PosT1
             */
            if (OldEmpty == true) {
                if (objProductNew.flt_DiaT1Pos != "" && objProductNew.flt_DiaT1Pos != undefined) {
                    objDiameter.Diameter['Upper Limit'].oldValue = "NA";
                    objDiameter.Diameter['Upper Limit'].newValue = objProductNew.flt_DiaT1Pos;
                    IsChanged = true;
                }
                else {
                    objDiameter.Diameter['Upper Limit'].oldValue = false;
                    objDiameter.Diameter['Upper Limit'].newValue = false;
                    IsChanged = false;
                }
            }
            else {
                if (objProductOld.Param6_T1Pos === "" ||
                    objProductOld.Param6_T1Pos == this.strNullValue ||
                    objProductOld.Param6_T1Pos == undefined) {
                    objProductOld.Param6_T1Pos = null;
                }

                if (objProductNew.flt_DiaT1Pos === "" ||
                    objProductNew.flt_DiaT1Pos == this.strNullValue ||
                    objProductNew.flt_DiaT1Pos == undefined) {
                    objProductNew.flt_DiaT1Pos = null;
                }

                if ((objProductOld.Param6_T1Pos !== null) && (objProductNew.flt_DiaT1Pos !== null)) {
                    if (parseFloat(objProductOld.Param6_T1Pos).toFixed(objProductOld.Param6_DP) == parseFloat(objProductNew.flt_DiaT1Pos).toFixed(objProductNew.int_DiaDp)) {
                        objDiameter.Diameter['Upper Limit'].oldValue = false;
                        objDiameter.Diameter['Upper Limit'].newValue = false;
                        IsChanged != true ? IsChanged = false : IsChanged = true;
                    }
                    else {
                        objDiameter.Diameter['Upper Limit'].oldValue = parseFloat(objProductOld.Param6_T1Pos).toFixed(objProductOld.Param6_DP);
                        objDiameter.Diameter['Upper Limit'].newValue = parseFloat(objProductNew.flt_DiaT1Pos).toFixed(objProductNew.int_DiaDp);
                        IsChanged = true;
                    }

                } else {

                    if ((objProductOld.Param6_T1Pos === null) && (objProductNew.flt_DiaT1Pos !== null)) {
                        objDiameter.Diameter['Upper Limit'].oldValue = "NA";
                        objDiameter.Diameter['Upper Limit'].newValue = parseFloat(objProductNew.flt_DiaT1Pos).toFixed(objProductNew.int_DiaDp);
                        IsChanged = true;

                    } else if ((objProductOld.Param6_T1Pos !== null) && (objProductNew.flt_DiaT1Pos === null)) {
                        objDiameter.Diameter['Upper Limit'].oldValue = parseFloat(objProductOld.Param6_T1Pos).toFixed(objProductOld.Param6_DP);
                        objDiameter.Diameter['Upper Limit'].newValue = "NA";
                        IsChanged = true;
                    }
                }
            }

            /**
             * For Diameter Initial Quantity
             */
            if (OldEmpty) {
                if (objProductNew.int_DiaQtyInitial != "" && objProductNew.int_DiaQtyInitial!=undefined) {
                    objDiameter.Diameter['Quantity (Initial)'].oldValue = "NA";
                    objDiameter.Diameter['Quantity (Initial)'].newValue = Number(objProductNew.int_DiaQtyInitial);
                    IsChanged = true;
                }
                else {
                    objDiameter.Diameter['Quantity (Initial)'].oldValue = false;
                    objDiameter.Diameter['Quantity (Initial)'].newValue = false;
                    IsChanged = IsChanged != true ? false : true;
                }
            }
            else {
                if (objProductOld.Param6_IniQty === "" ||
                    objProductOld.Param6_IniQty == this.strNullValue ||
                    objProductOld.Param6_IniQty == undefined) {
                    objProductOld.Param6_IniQty = null;
                }

                if (objProductNew.int_DiaQtyInitial === "" || objProductNew.int_DiaQtyInitial == this.strNullValue || objProductNew.int_DiaQtyInitial == undefined) {
                    objProductNew.int_DiaQtyInitial = null;
                }

                if ((objProductOld.Param6_IniQty !== null) && (objProductNew.int_DiaQtyInitial !== null)) {
                    if (Number(objProductOld.Param6_IniQty) == Number(objProductNew.int_DiaQtyInitial)) {
                        objDiameter.Diameter['Quantity (Initial)'].oldValue = false;
                        objDiameter.Diameter['Quantity (Initial)'].newValue = false;
                        IsChanged != true ? IsChanged = false : IsChanged = true;
                    }
                    else {
                        objDiameter.Diameter['Quantity (Initial)'].oldValue = objProductOld.Param6_IniQty;
                        objDiameter.Diameter['Quantity (Initial)'].newValue = Number(objProductNew.int_DiaQtyInitial);
                        IsChanged = true;
                    }

                } else {

                    if ((objProductOld.Param6_IniQty === null) && (objProductNew.int_DiaQtyInitial !== null)) {
                        objDiameter.Diameter['Quantity (Initial)'].oldValue = "NA";
                        objDiameter.Diameter['Quantity (Initial)'].newValue = Number(objProductNew.int_DiaQtyInitial);
                        IsChanged = true;

                    } else if ((objProductOld.Param6_IniQty !== null) && (objProductNew.int_DiaQtyInitial === null)) {
                        objDiameter.Diameter['Quantity (Initial)'].oldValue = objProductOld.Param6_IniQty;
                        objDiameter.Diameter['Quantity (Initial)'].newValue = "NA";
                        IsChanged = true;
                    }
                }
            }
            
            /**
             * For Diameter Quantity Regular
             */
            if (OldEmpty) {
                if (objProductNew.int_DiaQtyRegular != "" && objProductNew.int_DiaQtyRegular!=undefined) {
                    objDiameter.Diameter['Quantity (Regular)'].oldValue = "NA";
                    objDiameter.Diameter['Quantity (Regular)'].newValue = Number(objProductNew.int_DiaQtyRegular);
                    IsChanged = true;
                }
                else {
                    objDiameter.Diameter['Quantity (Regular)'].oldValue = false;
                    objDiameter.Diameter['Quantity (Regular)'].newValue = false;
                    IsChanged = IsChanged != true ? false : true;
                }
            }
            else {
                if (objProductOld.Param6_RegQty === "" ||
                    objProductOld.Param6_RegQty == this.strNullValue ||
                    objProductOld.Param6_RegQty == undefined) {
                    objProductOld.Param6_RegQty = null;
                }

                if (objProductNew.int_DiaQtyRegular === "" || objProductNew.int_DiaQtyRegular == this.strNullValue || objProductNew.int_DiaQtyRegular == undefined) {
                    objProductNew.int_DiaQtyRegular = null;
                }

                if ((objProductOld.Param6_RegQty !== null) && (objProductNew.int_DiaQtyRegular !== null)) {
                    if (Number(objProductOld.Param6_RegQty)== Number(objProductNew.int_DiaQtyRegular)) {
                        objDiameter.Diameter['Quantity (Regular)'].oldValue = false;
                        objDiameter.Diameter['Quantity (Regular)'].newValue = false;
                        IsChanged != true ? IsChanged = false : IsChanged = true;
                    }
                    else {
                        objDiameter.Diameter['Quantity (Regular)'].oldValue = objProductOld.Param6_RegQty;
                        objDiameter.Diameter['Quantity (Regular)'].newValue = Number(objProductNew.int_DiaQtyRegular);
                        IsChanged = true;
                    }

                } else {

                    if ((objProductOld.Param6_RegQty === null) && (objProductNew.int_DiaQtyRegular !== null)) {
                        objDiameter.Diameter['Quantity (Regular)'].oldValue = "NA";
                        objDiameter.Diameter['Quantity (Regular)'].newValue = Number(objProductNew.int_DiaQtyRegular);
                        IsChanged = true;

                    } else if ((objProductOld.Param6_RegQty !== null) && (objProductNew.int_DiaQtyRegular === null)) {
                        objDiameter.Diameter['Quantity (Regular)'].oldValue = objProductOld.Param6_RegQty;
                        objDiameter.Diameter['Quantity (Regular)'].newValue = "NA";
                        IsChanged = true;
                    }
                }
            }

            /**
            * For Individual NegT2
            if (OldEmpty == true) {
                if (objProductNew.flt_DiaT2Neg != "" && objProductNew.flt_DiaT2Neg != undefined) {
                    objDiameter.Diameter.T2Neg.oldValue = "NA";
                    objDiameter.Diameter.T2Neg.newValue = objProductNew.flt_DiaT2Neg;
                    IsChanged = true;
                }
                else {
                    objDiameter.Diameter.T2Neg.oldValue = false;
                    objDiameter.Diameter.T2Neg.newValue = false;
                    IsChanged = false;
                }
            }
            else {
                if (objProductOld.Param6_T2Neg === "" ||
                    objProductOld.Param6_T2Neg == this.strNullValue ||
                    objProductOld.Param6_T2Neg == undefined) {
                    objProductOld.Param6_T2Neg = null;
                }

                if (objProductNew.flt_DiaT2Neg === "" ||
                    objProductNew.flt_DiaT2Neg == this.strNullValue ||
                    objProductNew.flt_DiaT2Neg == undefined) {
                    objProductNew.flt_DiaT2Neg = null;
                }

                if ((objProductOld.Param6_T2Neg !== null) && (objProductNew.flt_DiaT2Neg !== null)) {
                    if (parseFloat(objProductOld.Param6_T2Neg).toFixed(objProductOld.Param6_DP) == parseFloat(objProductNew.flt_DiaT2Neg).toFixed(objProductNew.int_DiaDp)) {
                        objDiameter.Diameter.T2Neg.oldValue = false;
                        objDiameter.Diameter.T2Neg.newValue = false;
                        IsChanged != true ? IsChanged = false : IsChanged = true;
                    }
                    else {
                        objDiameter.Diameter.T2Neg.oldValue = parseFloat(objProductOld.Param6_T2Neg).toFixed(objProductOld.Param6_DP);
                        objDiameter.Diameter.T2Neg.newValue = parseFloat(objProductNew.flt_DiaT2Neg).toFixed(objProductNew.int_DiaDp);
                        IsChanged = true;
                    }

                } else {

                    if ((objProductOld.Param6_T2Neg === null) && (objProductNew.flt_DiaT2Neg !== null)) {
                        objDiameter.Diameter.T2Neg.oldValue = "NA";
                        objDiameter.Diameter.T2Neg.newValue = parseFloat(objProductNew.flt_DiaT2Neg).toFixed(objProductNew.int_DiaDp);
                        IsChanged = true;

                    } else if ((objProductOld.Param6_T2Neg !== null) && (objProductNew.flt_DiaT2Neg === null)) {
                        objDiameter.Diameter.T2Neg.oldValue = parseFloat(objProductOld.Param6_T2Neg).toFixed(objProductOld.Param6_DP);
                        objDiameter.Diameter.T2Neg.newValue = "NA";
                        IsChanged = true;
                    }
                }
            }
            */

            /**
            * For Individual PosT2
            if (OldEmpty == true) {
                if (objProductNew.flt_DiaT2Pos != "" && objProductNew.flt_DiaT2Pos != undefined) {
                    objDiameter.Diameter.T2Pos.oldValue = "NA";
                    objDiameter.Diameter.T2Pos.newValue = objProductNew.flt_DiaT2Pos;
                    IsChanged = true;
                }
                else {
                    objDiameter.Diameter.T2Pos.oldValue = false;
                    objDiameter.Diameter.T2Pos.newValue = false;
                    IsChanged = false;
                }
            }
            else {
                if (objProductOld.Param6_T2Pos === "" ||
                    objProductOld.Param6_T2Pos == this.strNullValue ||
                    objProductOld.Param6_T2Pos == undefined) {
                    objProductOld.Param6_T2Pos = null;
                }

                if (objProductNew.flt_DiaT2Pos === "" ||
                    objProductNew.flt_DiaT2Pos == this.strNullValue ||
                    objProductNew.flt_DiaT2Pos == undefined) {
                    objProductNew.flt_DiaT2Pos = null;
                }

                if ((objProductOld.Param6_T2Pos !== null) && (objProductNew.flt_DiaT2Pos !== null)) {
                    if (parseFloat(objProductOld.Param6_T2Pos).toFixed(objProductOld.Param6_DP) == parseFloat(objProductNew.flt_DiaT2Pos).toFixed(objProductNew.int_DiaDp)) {
                        objDiameter.Diameter.T2Pos.oldValue = false;
                        objDiameter.Diameter.T2Pos.newValue = false;
                        IsChanged != true ? IsChanged = false : IsChanged = true;
                    }
                    else {
                        objDiameter.Diameter.T2Pos.oldValue = parseFloat(objProductOld.Param6_T2Pos).toFixed(objProductOld.Param6_DP);
                        objDiameter.Diameter.T2Pos.newValue = parseFloat(objProductNew.flt_DiaT2Pos).toFixed(objProductNew.int_DiaDp);
                        IsChanged = true;
                    }

                } else {

                    if ((objProductOld.Param6_T2Pos === null) && (objProductNew.flt_DiaT2Pos !== null)) {
                        objDiameter.Diameter.T2Pos.oldValue = "NA";
                        objDiameter.Diameter.T2Pos.newValue = parseFloat(objProductNew.flt_DiaT2Pos).toFixed(objProductNew.int_DiaDp);
                        IsChanged = true;

                    } else if ((objProductOld.Param6_T2Pos !== null) && (objProductNew.flt_DiaT2Pos === null)) {
                        objDiameter.Diameter.T2Pos.oldValue = parseFloat(objProductOld.Param6_T2Pos).toFixed(objProductOld.Param6_DP);
                        objDiameter.Diameter.T2Pos.newValue = "NA";
                        IsChanged = true;
                    }
                }
            }
            */

            /**
            * For Individual NegT3
            if (OldEmpty == true) {
                if (objProductNew.flt_DiaT3Neg != "" && objProductNew.flt_DiaT3Neg != undefined) {
                    objDiameter.Diameter.T3Neg.oldValue = "NA";
                    objDiameter.Diameter.T3Neg.newValue = objProductNew.flt_DiaT3Neg;
                    IsChanged = true;
                }
                else {
                    objDiameter.Diameter.T3Neg.oldValue = false;
                    objDiameter.Diameter.T3Neg.newValue = false;
                    IsChanged = false;
                }
            }
            else {
                if (objProductOld.Param6_T3Neg === "" ||
                    objProductOld.Param6_T3Neg == this.strNullValue ||
                    objProductOld.Param6_T3Neg == undefined) {
                    objProductOld.Param6_T3Neg = null;
                }

                if (objProductNew.flt_DiaT3Neg === "" ||
                    objProductNew.flt_DiaT3Neg == this.strNullValue ||
                    objProductNew.flt_DiaT3Neg == undefined) {
                    objProductNew.flt_DiaT3Neg = null;
                }

                if ((objProductOld.Param6_T3Neg !== null) && (objProductNew.flt_DiaT3Neg !== null)) {
                    if (parseFloat(objProductOld.Param6_T3Neg).toFixed(objProductOld.Param6_DP) == parseFloat(objProductNew.flt_DiaT3Neg).toFixed(objProductNew.int_DiaDp)) {
                        objDiameter.Diameter.T3Neg.oldValue = false;
                        objDiameter.Diameter.T3Neg.newValue = false;
                        IsChanged != true ? IsChanged = false : IsChanged = true;
                    }
                    else {
                        objDiameter.Diameter.T3Neg.oldValue = parseFloat(objProductOld.Param6_T3Neg).toFixed(objProductOld.Param6_DP);
                        objDiameter.Diameter.T3Neg.newValue = parseFloat(objProductNew.flt_DiaT3Neg).toFixed(objProductNew.int_DiaDp);
                        IsChanged = true;
                    }

                } else {

                    if ((objProductOld.Param6_T3Neg === null) && (objProductNew.flt_DiaT3Neg !== null)) {
                        objDiameter.Diameter.T3Neg.oldValue = "NA";
                        objDiameter.Diameter.T3Neg.newValue = parseFloat(objProductNew.flt_DiaT3Neg).toFixed(objProductNew.int_DiaDp);
                        IsChanged = true;

                    } else if ((objProductOld.Param6_T3Neg !== null) && (objProductNew.flt_DiaT3Neg === null)) {
                        objDiameter.Diameter.T3Neg.oldValue = parseFloat(objProductOld.Param6_T3Neg).toFixed(objProductOld.Param6_DP);
                        objDiameter.Diameter.T3Neg.newValue = "NA";
                        IsChanged = true;
                    }
                }
            }
            */

            /**
            * For Individual PosT3
            if (OldEmpty == true) {
                if (objProductNew.flt_DiaT3Pos != "" && objProductNew.flt_DiaT3Pos != undefined) {
                    objDiameter.Diameter.T3Pos.oldValue = "NA";
                    objDiameter.Diameter.T3Pos.newValue = objProductNew.flt_DiaT3Pos;
                    IsChanged = true;
                }
                else {
                    objDiameter.Diameter.T3Pos.oldValue = false;
                    objDiameter.Diameter.T3Pos.newValue = false;
                    IsChanged = false;
                }
            }
            else {
                if (objProductOld.Param6_T3Pos === "" ||
                    objProductOld.Param6_T3Pos == this.strNullValue ||
                    objProductOld.Param6_T3Pos == undefined) {
                    objProductOld.Param6_T3Pos = null;
                }

                if (objProductNew.flt_DiaT3Pos === "" ||
                    objProductNew.flt_DiaT3Pos == this.strNullValue ||
                    objProductNew.flt_DiaT3Pos == undefined) {
                    objProductNew.flt_DiaT3Pos = null;
                }

                if ((objProductOld.Param6_T3Pos !== null) && (objProductNew.flt_DiaT3Pos !== null)) {
                    if (parseFloat(objProductOld.Param6_T3Pos).toFixed(objProductOld.Param6_DP) == parseFloat(objProductNew.flt_DiaT3Pos).toFixed(objProductNew.int_DiaDp)) {
                        objDiameter.Diameter.T3Pos.oldValue = false;
                        objDiameter.Diameter.T3Pos.newValue = false;
                        IsChanged != true ? IsChanged = false : IsChanged = true;
                    }
                    else {
                        objDiameter.Diameter.T3Pos.oldValue = parseFloat(objProductOld.Param6_T3Pos).toFixed(objProductOld.Param6_DP);
                        objDiameter.Diameter.T3Pos.newValue = parseFloat(objProductNew.flt_DiaT3Pos).toFixed(objProductNew.int_DiaDp);
                        IsChanged = true;
                    }

                } else {

                    if ((objProductOld.Param6_T3Pos === null) && (objProductNew.flt_DiaT3Pos !== null)) {
                        objDiameter.Diameter.T3Pos.oldValue = "NA";
                        objDiameter.Diameter.T3Pos.newValue = parseFloat(objProductNew.flt_DiaT3Pos).toFixed(objProductNew.int_DiaDp);
                        IsChanged = true;

                    } else if ((objProductOld.Param6_T3Pos !== null) && (objProductNew.flt_DiaT3Pos === null)) {
                        objDiameter.Diameter.T3Pos.oldValue = parseFloat(objProductOld.Param6_T3Pos).toFixed(objProductOld.Param6_DP);
                        objDiameter.Diameter.T3Pos.newValue = "NA";
                        IsChanged = true;
                    }
                }
            }
            */

            /**
            * For Individual NMT
            if (OldEmpty == true) {
                if (objProductNew.int_DiaNMTTabCnt != "") {
                    objDiameter.Diameter.NMT.oldValue = "NA";
                    objDiameter.Diameter.NMT.newValue = objProductNew.int_DiaNMTTabCnt;
                    IsChanged = true;
                }
                else {
                    objDiameter.Diameter.NMT.oldValue = false;
                    objDiameter.Diameter.NMT.newValue = false;
                    IsChanged = false;
                }
            }
            else {
                if (objProductOld.Param6_NMTTab == 0 ||
                    objProductOld.Param6_NMTTab == this.NMTValue ||
                    objProductOld.Param6_NMTTab == undefined) {
                    objProductOld.Param6_NMTTab = 0;
                }

                objProductNew.int_DiaNMTTabCnt = objProductNew.int_DiaNMTTabCnt === "" ? this.strNullValue : objProductNew.int_DiaNMTTabCnt;
                
                if (objProductNew.int_DiaNMTTabCnt == "0" ||
                    objProductNew.int_DiaNMTTabCnt == this.NMTValue ||
                    objProductNew.int_DiaNMTTabCnt == undefined) {
                    objProductNew.int_DiaNMTTabCnt = 0;
                }

                if (parseInt(objProductOld.Param6_NMTTab) == parseInt(objProductNew.int_DiaNMTTabCnt)) {
                    objDiameter.Diameter.NMT.oldValue = false;
                    objDiameter.Diameter.NMT.newValue = false;
                    IsChanged != true ? IsChanged = false : IsChanged = true;
                }
                else {
                    objDiameter.Diameter.NMT.oldValue = objProductOld.Param6_NMTTab;
                    objDiameter.Diameter.NMT.newValue = objProductNew.int_DiaNMTTabCnt;
                    IsChanged = true;
                }
            }
            */

            /**
             * For Individual Limits On Standard / Avg
             */
            // if (objProductOld.Param6_IsOnStd == objProductNew.str_DiaGraphOn) {
            //     objDiameter.Diameter.GraphOn.oldValue = false;
            //     objDiameter.Diameter.GraphOn.newValue = false;
            //     IsChanged != true ? IsChanged = false : IsChanged=true;
            // }
            // else {
            //     objDiameter.Diameter.GraphOn.oldValue = Param6_IsOnStd;
            //     objDiameter.Diameter.GraphOn.newValue = str_DiaGraphOn;
            //     IsChanged = true;
            // }

            /**
             * 
            if (OldEmpty) {
                if (objProductNew.str_verUnit != "" && objProductNew.flt_DiaStd != "" && objProductNew.str_verUnit != undefined && objProductNew.flt_DiaStd != undefined) {
                    objDiameter.Diameter.Unit.oldValue = "NA";
                    objDiameter.Diameter.Unit.newValue = objProductNew.str_verUnit;
                    IsChanged = true;
                }
                else {
                    objDiameter.Diameter.Unit.oldValue = false;
                    objDiameter.Diameter.Unit.newValue = false;
                    IsChanged = IsChanged != true ? false : true;
                }
            }
            else {
                objProductOld.Param6_Unit == "NA" ? objProductOld.Param6_Unit = "mm" : objProductOld.Param6_Unit;
                if (objProductOld.Param6_Nom == null && objProductNew.flt_DiaStd != null) { // new parameter added
                    objDiameter.Diameter.Unit.oldValue = "mm";
                    objDiameter.Diameter.Unit.newValue = objProductNew.str_verUnit;
                    IsChanged = true;
                }
                else if (objProductOld.Param6_Unit == null && objProductNew.str_verUnit == null) // no parameter added
                {
                    objDiameter.Diameter.Unit.oldValue = false;
                    objDiameter.Diameter.Unit.newValue = false;
                    IsChanged = false;
                }
                else {
                    if (objProductOld.Param6_Unit == objProductNew.str_verUnit) {
                        objDiameter.Diameter.Unit.oldValue = false;
                        objDiameter.Diameter.Unit.newValue = false;
                        IsChanged != true ? IsChanged = false : IsChanged = true;
                    }
                    else {
                        objDiameter.Diameter.Unit.oldValue = objProductOld.Param6_Unit;
                        objDiameter.Diameter.Unit.newValue = objProductNew.str_verUnit;
                        IsChanged = true;
                    }
                }
            }
             */
            
            if (IsChanged == true) {
                Object.assign(this.objResult, objDiameter);
            }
            resolve(IsChanged);
        });
    }

    validateHardness(objProductOld, objProductNew) {
        return new Promise((resolve, reject) => {
            // let str_Tol_1_Neg = (Bln_Is_HardnessNMTNLT == true) ? "NLT" : "T1Neg";
            // let str_Tol_1_Pos = (Bln_Is_HardnessNMTNLT == true) ? "NMT" : "T1Pos";
            let str_Tol_1_Neg = 'Lower Limit';
            let str_Tol_1_Pos = 'Upper Limit';
            const objHardness = {
                Hardness: {
                    Nom: { oldValue: "", newValue: "" },
                    [str_Tol_1_Neg]: { oldValue: "", newValue: "" },
                    [str_Tol_1_Pos]: { oldValue: "", newValue: "" },
                    T2Neg: { oldValue: "", newValue: "" },
                    T2Pos: { oldValue: "", newValue: "" },
                    T3Neg: { oldValue: "", newValue: "" },
                    T3Pos: { oldValue: "", newValue: "" },
                    HrdUnit: { oldValue: "", newValue: "" },
                    ReportOn: { oldValue: "", newValue: "" },
                    "Quantity (Initial)":{ oldValue: "", newValue: "" },
                    "Quantity (Regular)":{ oldValue: "", newValue: "" }
                }
            };

            var IsChanged = false;
            var OldEmpty = objProductOld == undefined ? true : false;
            /**
             * For Individual Nom
            if (OldEmpty == true) {
                if (objProductNew.flt_HrdStd != "" && objProductNew.flt_HrdStd != undefined) {
                    objHardness.Hardness.Nom.oldValue = "NA";
                    objHardness.Hardness.Nom.newValue = objProductNew.flt_HrdStd;
                    IsChanged = true;
                }
                else {
                    objHardness.Hardness.Nom.oldValue = false;
                    objHardness.Hardness.Nom.newValue = false;
                    IsChanged = false;
                }
            }
            else {
                if (objProductOld.Param7_Nom === "" ||
                    objProductOld.Param7_Nom == this.strNullValue ||
                    objProductOld.Param7_Nom == undefined) {
                    objProductOld.Param7_Nom = null;
                }

                if (objProductNew.flt_HrdStd === "" ||
                    objProductNew.flt_HrdStd == this.strNullValue ||
                    objProductNew.flt_HrdStd == undefined) {
                    objProductNew.flt_HrdStd = null;
                }

                if ((objProductOld.Param7_Nom !== null) && (objProductNew.flt_HrdStd !== null)) {
                    if (parseFloat(objProductOld.Param7_Nom).toFixed(objProductOld.Param7_DP) == parseFloat(objProductNew.flt_HrdStd).toFixed(objProductNew.int_HardDp)) {
                        objHardness.Hardness.Nom.oldValue = false;
                        objHardness.Hardness.Nom.newValue = false;
                        IsChanged = false;
                    }
                    else {
                        objHardness.Hardness.Nom.oldValue = parseFloat(objProductOld.Param7_Nom).toFixed(objProductOld.Param7_DP);
                        objHardness.Hardness.Nom.newValue = objProductNew.flt_HrdStd;
                        IsChanged = true;
                    }

                } else {

                    if ((objProductOld.Param7_Nom === null) && (objProductNew.flt_HrdStd !== null)) {
                        objHardness.Hardness.Nom.oldValue = "NA";
                        objHardness.Hardness.Nom.newValue = objProductNew.flt_HrdStd;
                        IsChanged = true;

                    } else if ((objProductOld.Param7_Nom !== null) && (objProductNew.flt_HrdStd === null)) {
                        objHardness.Hardness.Nom.oldValue = parseFloat(objProductOld.Param7_Nom).toFixed(objProductOld.Param7_DP);
                        objHardness.Hardness.Nom.newValue = "NA";
                        IsChanged = true;
                    }
                }
            }
             */
           
            if (OldEmpty == true) {
                if (objProductNew.flt_HrdT1 != "" && objProductNew.flt_HrdT1 != undefined) {
                    objHardness.Hardness[str_Tol_1_Neg].oldValue = "NA";
                    objHardness.Hardness[str_Tol_1_Neg].newValue = objProductNew.flt_HrdT1;
                    IsChanged = true;
                }
                else {
                    objHardness.Hardness[str_Tol_1_Neg].oldValue = false;
                    objHardness.Hardness[str_Tol_1_Neg].newValue = false;
                    IsChanged = false;
                }
            }
            else {
                if (objProductOld.Param7_T1Neg === "" ||
                    objProductOld.Param7_T1Neg == this.strNullValue ||
                    objProductOld.Param7_T1Neg == undefined) {
                    objProductOld.Param7_T1Neg = null;
                }

                if (objProductNew.flt_HrdT1 === "" ||
                    objProductNew.flt_HrdT1 == this.strNullValue ||
                    objProductNew.flt_HrdT1 == undefined) {
                    objProductNew.flt_HrdT1 = null;
                }

                if ((objProductOld.Param7_T1Neg !== null) && (objProductNew.flt_HrdT1 !== null)) {
                    if (parseFloat(objProductOld.Param7_T1Neg).toFixed(objProductOld.Param7_DP) == parseFloat(objProductNew.flt_HrdT1).toFixed(objProductNew.int_HardDp)) {
                        objHardness.Hardness[str_Tol_1_Neg].oldValue = false;
                        objHardness.Hardness[str_Tol_1_Neg].newValue = false;
                        IsChanged != true ? IsChanged = false : IsChanged = true;
                    }
                    else {
                        objHardness.Hardness[str_Tol_1_Neg].oldValue = parseFloat(objProductOld.Param7_T1Neg).toFixed(objProductOld.Param7_DP);
                        objHardness.Hardness[str_Tol_1_Neg].newValue = objProductNew.flt_HrdT1;
                        IsChanged = true;
                    }

                } else {

                    if ((objProductOld.Param7_T1Neg === null) && (objProductNew.flt_HrdT1 !== null)) {
                        objHardness.Hardness[str_Tol_1_Neg].oldValue = "NA";
                        objHardness.Hardness[str_Tol_1_Neg].newValue = objProductNew.flt_HrdT1;
                        IsChanged = true;

                    } else if ((objProductOld.Param7_T1Neg !== null) && (objProductNew.flt_HrdT1 === null)) {
                        objHardness.Hardness[str_Tol_1_Neg].oldValue = parseFloat(objProductOld.Param7_T1Neg).toFixed(objProductOld.Param7_DP);
                        objHardness.Hardness[str_Tol_1_Neg].newValue = "NA";
                        IsChanged = true;
                    }
                }
            }
           
            if (OldEmpty == true) {
                if (objProductNew.flt_HrdT2 != "" && objProductNew.flt_HrdT2 != undefined) {
                    objHardness.Hardness[str_Tol_1_Pos].oldValue = "NA";
                    objHardness.Hardness[str_Tol_1_Pos].newValue = objProductNew.flt_HrdT2;
                    IsChanged = true;
                }
                else {
                    objHardness.Hardness[str_Tol_1_Pos].oldValue = false;
                    objHardness.Hardness[str_Tol_1_Pos].newValue = false;
                    IsChanged = false;
                }
            }
            else {
                if (objProductOld.Param7_T1Pos === "" ||
                    objProductOld.Param7_T1Pos == this.strNullValue ||
                    objProductOld.Param7_T1Pos == undefined) {
                    objProductOld.Param7_T1Pos = null;
                }

                if (objProductNew.flt_HrdT2 === "" ||
                    objProductNew.flt_HrdT2 == this.strNullValue ||
                    objProductNew.flt_HrdT2 == undefined) {
                    objProductNew.flt_HrdT2 = null;
                }

                if ((objProductOld.Param7_T1Pos !== null) && (objProductNew.flt_HrdT2 !== null)) {
                    if (parseFloat(objProductOld.Param7_T1Pos).toFixed(objProductOld.Param7_DP) == parseFloat(objProductNew.flt_HrdT2).toFixed(objProductNew.int_HardDp)) {
                        objHardness.Hardness[str_Tol_1_Pos].oldValue = false;
                        objHardness.Hardness[str_Tol_1_Pos].newValue = false;
                        IsChanged != true ? IsChanged = false : IsChanged = true;
                    }
                    else {
                        objHardness.Hardness[str_Tol_1_Pos].oldValue = parseFloat(objProductOld.Param7_T1Pos).toFixed(objProductOld.Param7_DP);
                        objHardness.Hardness[str_Tol_1_Pos].newValue = objProductNew.flt_HrdT2;
                        IsChanged = true;
                    }

                } else {

                    if ((objProductOld.Param7_T1Pos === null) && (objProductNew.flt_HrdT2 !== null)) {
                        objHardness.Hardness[str_Tol_1_Pos].oldValue = "NA";
                        objHardness.Hardness[str_Tol_1_Pos].newValue = objProductNew.flt_HrdT2;
                        IsChanged = true;

                    } else if ((objProductOld.Param7_T1Pos !== null) && (objProductNew.flt_HrdT2 === null)) {
                        objHardness.Hardness[str_Tol_1_Pos].oldValue = parseFloat(objProductOld.Param7_T1Pos).toFixed(objProductOld.Param7_DP);
                        objHardness.Hardness[str_Tol_1_Pos].newValue = "NA";
                        IsChanged = true;
                    }
                }
            }

            /**
             * For Diameter Initial Quantity
             */
            if (OldEmpty) {
                if (objProductNew.int_HrdQtyInitial != "" && objProductNew.int_HrdQtyInitial!=undefined) {
                    objHardness.Hardness['Quantity (Initial)'].oldValue = "NA";
                    objHardness.Hardness['Quantity (Initial)'].newValue = Number(objProductNew.int_HrdQtyInitial);
                    IsChanged = true;
                }
                else {
                    objHardness.Hardness['Quantity (Initial)'].oldValue = false;
                    objHardness.Hardness['Quantity (Initial)'].newValue = false;
                    IsChanged = IsChanged != true ? false : true;
                }
            }
            else {
                if (objProductOld.Param7_IniQty === "" ||
                    objProductOld.Param7_IniQty == this.strNullValue ||
                    objProductOld.Param7_IniQty == undefined) {
                    objProductOld.Param7_IniQty = null;
                }

                if (objProductNew.int_HrdQtyInitial === "" || objProductNew.int_HrdQtyInitial == this.strNullValue || objProductNew.int_HrdQtyInitial == undefined) {
                    objProductNew.int_HrdQtyInitial = null;
                }

                if ((objProductOld.Param7_IniQty !== null) && (objProductNew.int_HrdQtyInitial !== null)) {
                    if (Number(objProductOld.Param7_IniQty) == Number(objProductNew.int_HrdQtyInitial)) {
                        objHardness.Hardness['Quantity (Initial)'].oldValue = false;
                        objHardness.Hardness['Quantity (Initial)'].newValue = false;
                        IsChanged != true ? IsChanged = false : IsChanged = true;
                    }
                    else {
                        objHardness.Hardness['Quantity (Initial)'].oldValue = objProductOld.Param7_IniQty;
                        objHardness.Hardness['Quantity (Initial)'].newValue = Number(objProductNew.int_HrdQtyInitial);
                        IsChanged = true;
                    }

                } else {

                    if ((objProductOld.Param7_IniQty === null) && (objProductNew.int_HrdQtyInitial !== null)) {
                        objHardness.Hardness['Quantity (Initial)'].oldValue = "NA";
                        objHardness.Hardness['Quantity (Initial)'].newValue = Number(objProductNew.int_HrdQtyInitial);
                        IsChanged = true;

                    } else if ((objProductOld.Param7_IniQty !== null) && (objProductNew.int_HrdQtyInitial === null)) {
                        objHardness.Hardness['Quantity (Initial)'].oldValue = objProductOld.Param7_IniQty;
                        objHardness.Hardness['Quantity (Initial)'].newValue = "NA";
                        IsChanged = true;
                    }
                }
            }
            
            /**
             * For Diameter Quantity Regular
             */
            if (OldEmpty) {
                if (objProductNew.int_HrdQtyRegular != "" && objProductNew.int_HrdQtyRegular!=undefined) {
                    objHardness.Hardness['Quantity (Regular)'].oldValue = "NA";
                    objHardness.Hardness['Quantity (Regular)'].newValue = Number(objProductNew.int_HrdQtyRegular);
                    IsChanged = true;
                }
                else {
                    objHardness.Hardness['Quantity (Regular)'].oldValue = false;
                    objHardness.Hardness['Quantity (Regular)'].newValue = false;
                    IsChanged = IsChanged != true ? false : true;
                }
            }
            else {
                if (objProductOld.Param7_RegQty === "" ||
                    objProductOld.Param7_RegQty == this.strNullValue ||
                    objProductOld.Param7_RegQty == undefined) {
                    objProductOld.Param7_RegQty = null;
                }

                if (objProductNew.int_HrdQtyRegular === "" || objProductNew.int_HrdQtyRegular == this.strNullValue || objProductNew.int_HrdQtyRegular == undefined) {
                    objProductNew.int_HrdQtyRegular = null;
                }

                if ((objProductOld.Param7_RegQty !== null) && (objProductNew.int_HrdQtyRegular !== null)) {
                    if (Number(objProductOld.Param7_RegQty)== Number(objProductNew.int_HrdQtyRegular)) {
                        objHardness.Hardness['Quantity (Regular)'].oldValue = false;
                        objHardness.Hardness['Quantity (Regular)'].newValue = false;
                        IsChanged != true ? IsChanged = false : IsChanged = true;
                    }
                    else {
                        objHardness.Hardness['Quantity (Regular)'].oldValue = objProductOld.Param7_RegQty;
                        objHardness.Hardness['Quantity (Regular)'].newValue = Number(objProductNew.int_HrdQtyRegular);
                        IsChanged = true;
                    }

                } else {

                    if ((objProductOld.Param7_RegQty === null) && (objProductNew.int_HrdQtyRegular !== null)) {
                        objHardness.Hardness['Quantity (Regular)'].oldValue = "NA";
                        objHardness.Hardness['Quantity (Regular)'].newValue = Number(objProductNew.int_HrdQtyRegular);
                        IsChanged = true;

                    } else if ((objProductOld.Param7_RegQty !== null) && (objProductNew.int_HrdQtyRegular === null)) {
                        objHardness.Hardness['Quantity (Regular)'].oldValue = objProductOld.Param7_RegQty;
                        objHardness.Hardness['Quantity (Regular)'].newValue = "NA";
                        IsChanged = true;
                    }
                }
            }

            /**
             * 
            if (OldEmpty == true) {
                if (objProductNew.flt_HrdT1_2 != "" && objProductNew.flt_HrdT1_2 != undefined) {
                    objHardness.Hardness.T2Neg.oldValue = "NA";
                    objHardness.Hardness.T2Neg.newValue = objProductNew.flt_HrdT1_2;
                    IsChanged = true;
                }
                else {
                    objHardness.Hardness.T2Neg.oldValue = false;
                    objHardness.Hardness.T2Neg.newValue = false;
                    IsChanged = false;
                }
            }
            else {
                if (objProductOld.Param7_T2Neg === "" ||
                    objProductOld.Param7_T2Neg == this.strNullValue ||
                    objProductOld.Param7_T2Neg == undefined) {
                    objProductOld.Param7_T2Neg = null;
                }

                if (objProductNew.flt_HrdT1_2 === "" ||
                    objProductNew.flt_HrdT1_2 == this.strNullValue ||
                    objProductNew.flt_HrdT1_2 == undefined) {
                    objProductNew.flt_HrdT1_2 = null;
                }

                if ((objProductOld.Param7_T2Neg !== null) && (objProductNew.flt_HrdT1_2 !== null)) {
                    if (parseFloat(objProductOld.Param7_T2Neg).toFixed(objProductOld.Param7_DP) == parseFloat(objProductNew.flt_HrdT1_2).toFixed(objProductNew.int_HardDp)) {
                        objHardness.Hardness.T2Neg.oldValue = false;
                        objHardness.Hardness.T2Neg.newValue = false;
                        IsChanged != true ? IsChanged = false : IsChanged = true;
                    }
                    else {
                        objHardness.Hardness.T2Neg.oldValue = parseFloat(objProductOld.Param7_T2Neg).toFixed(objProductOld.Param7_DP);
                        objHardness.Hardness.T2Neg.newValue = objProductNew.flt_HrdT1_2;
                        IsChanged = true;
                    }

                } else {

                    if ((objProductOld.Param7_T2Neg === null) && (objProductNew.flt_HrdT1_2 !== null)) {
                        objHardness.Hardness.T2Neg.oldValue = "NA";
                        objHardness.Hardness.T2Neg.newValue = objProductNew.flt_HrdT1_2;
                        IsChanged = true;

                    } else if ((objProductOld.Param7_T2Neg !== null) && (objProductNew.flt_HrdT1_2 === null)) {
                        objHardness.Hardness.T2Neg.oldValue = parseFloat(objProductOld.Param7_T2Neg).toFixed(objProductOld.Param7_DP);
                        objHardness.Hardness.T2Neg.newValue = "NA";
                        IsChanged = true;
                    }
                }
            }
             */

            /**
             * 
            if (OldEmpty == true) {
                if (objProductNew.flt_HrdT2_2 != "" && objProductNew.flt_HrdT2_2 != undefined) {
                    objHardness.Hardness.T2Pos.oldValue = "NA";
                    objHardness.Hardness.T2Pos.newValue = objProductNew.flt_HrdT2_2;
                    IsChanged = true;
                }
                else {
                    objHardness.Hardness.T2Pos.oldValue = false;
                    objHardness.Hardness.T2Pos.newValue = false;
                    IsChanged = false;
                }
            }
            else {
                if (objProductOld.Param7_T2Pos === "" ||
                    objProductOld.Param7_T2Pos == this.strNullValue ||
                    objProductOld.Param7_T2Pos == undefined) {
                    objProductOld.Param7_T2Pos = null;
                }

                if (objProductNew.flt_HrdT2_2 === "" ||
                    objProductNew.flt_HrdT2_2 == this.strNullValue ||
                    objProductNew.flt_HrdT2_2 == undefined) {
                    objProductNew.flt_HrdT2_2 = null;
                }

                if ((objProductOld.Param7_T2Pos !== null) && (objProductNew.flt_HrdT2_2 !== null)) {
                    if (parseFloat(objProductOld.Param7_T2Pos).toFixed(objProductOld.Param7_DP) == parseFloat(objProductNew.flt_HrdT2_2).toFixed(objProductNew.int_HardDp)) {
                        objHardness.Hardness.T2Pos.oldValue = false;
                        objHardness.Hardness.T2Pos.newValue = false;
                        IsChanged != true ? IsChanged = false : IsChanged = true;
                    }
                    else {
                        objHardness.Hardness.T2Pos.oldValue = parseFloat(objProductOld.Param7_T2Pos).toFixed(objProductOld.Param7_DP);
                        objHardness.Hardness.T2Pos.newValue = objProductNew.flt_HrdT2_2;
                        IsChanged = true;
                    }

                } else {

                    if ((objProductOld.Param7_T2Pos === null) && (objProductNew.flt_HrdT2_2 !== null)) {
                        objHardness.Hardness.T2Pos.oldValue = "NA";
                        objHardness.Hardness.T2Pos.newValue = objProductNew.flt_HrdT2_2;
                        IsChanged = true;

                    } else if ((objProductOld.Param7_T2Pos !== null) && (objProductNew.flt_HrdT2_2 === null)) {
                        objHardness.Hardness.T2Pos.oldValue = parseFloat(objProductOld.Param7_T2Pos).toFixed(objProductOld.Param7_DP);
                        objHardness.Hardness.T2Pos.newValue = "NA";
                        IsChanged = true;
                    }
                }
            }
             */

            /**
             if (OldEmpty == true) {
                 if (objProductNew.flt_HrdT1_3 != "" && objProductNew.flt_HrdT1_3 != undefined) {
                     objHardness.Hardness.T3Neg.oldValue = "NA";
                     objHardness.Hardness.T3Neg.newValue = objProductNew.flt_HrdT1_3;
                     IsChanged = true;
                 }
                 else {
                     objHardness.Hardness.T3Neg.oldValue = false;
                     objHardness.Hardness.T3Neg.newValue = false;
                     IsChanged = false;
                 }
             }
             else {
                 if (objProductOld.Param7_T3Neg === "" ||
                     objProductOld.Param7_T3Neg == this.strNullValue ||
                     objProductOld.Param7_T3Neg == undefined) {
                     objProductOld.Param7_T3Neg = null;
                 }
 
                 if (objProductNew.flt_HrdT1_3 === "" ||
                     objProductNew.flt_HrdT1_3 == this.strNullValue ||
                     objProductNew.flt_HrdT1_3 == undefined) {
                     objProductNew.flt_HrdT1_3 = null;
                 }
 
                 if ((objProductOld.Param7_T3Neg !== null) && (objProductNew.flt_HrdT1_3 !== null)) {
                     if (parseFloat(objProductOld.Param7_T3Neg).toFixed(objProductOld.Param7_DP) == parseFloat(objProductNew.flt_HrdT1_3).toFixed(objProductNew.int_HardDp)) {
                         objHardness.Hardness.T3Neg.oldValue = false;
                         objHardness.Hardness.T3Neg.newValue = false;
                         IsChanged != true ? IsChanged = false : IsChanged = true;
                     }
                     else {
                         objHardness.Hardness.T3Neg.oldValue = parseFloat(objProductOld.Param7_T3Neg).toFixed(objProductOld.Param7_DP);
                         objHardness.Hardness.T3Neg.newValue = objProductNew.flt_HrdT1_3;
                         IsChanged = true;
                     }
 
                 } else {
 
                     if ((objProductOld.Param7_T3Neg === null) && (objProductNew.flt_HrdT1_3 !== null)) {
                         objHardness.Hardness.T3Neg.oldValue = "NA";
                         objHardness.Hardness.T3Neg.newValue = objProductNew.flt_HrdT1_3;
                         IsChanged = true;
 
                     } else if ((objProductOld.Param7_T3Neg !== null) && (objProductNew.flt_HrdT1_3 === null)) {
                         objHardness.Hardness.T3Neg.oldValue = parseFloat(objProductOld.Param7_T3Neg).toFixed(objProductOld.Param7_DP);
                         objHardness.Hardness.T3Neg.newValue = "NA";
                         IsChanged = true;
                     }
                 }
             }
             */

             /**
              if (OldEmpty == true) {
                  if (objProductNew.flt_HrdT2_3 != "" && objProductNew.flt_HrdT2_3 != undefined) {
                      objHardness.Hardness.T3Pos.oldValue = "NA";
                      objHardness.Hardness.T3Pos.newValue = objProductNew.flt_HrdT2_3;
                      IsChanged = true;
                  }
                  else {
                      objHardness.Hardness.T3Pos.oldValue = false;
                      objHardness.Hardness.T3Pos.newValue = false;
                      IsChanged = false;
                  }
              }
              else {
                  if (objProductOld.Param7_T3Pos === "" ||
                      objProductOld.Param7_T3Pos == this.strNullValue ||
                      objProductOld.Param7_T3Pos == undefined) {
                      objProductOld.Param7_T3Pos = null;
                  }
  
                  if (objProductNew.flt_HrdT2_3 === "" ||
                      objProductNew.flt_HrdT2_3 == this.strNullValue ||
                      objProductNew.flt_HrdT2_3 == undefined) {
                      objProductNew.flt_HrdT2_3 = null;
                  }
  
                  if ((objProductOld.Param7_T3Pos !== null) && (objProductNew.flt_HrdT2_3 !== null)) {
                      if (parseFloat(objProductOld.Param7_T3Pos).toFixed(objProductOld.Param7_DP) == parseFloat(objProductNew.flt_HrdT2_3).toFixed(objProductNew.int_HardDp)) {
                          objHardness.Hardness.T3Pos.oldValue = false;
                          objHardness.Hardness.T3Pos.newValue = false;
                          IsChanged != true ? IsChanged = false : IsChanged = true;
                      }
                      else {
                          objHardness.Hardness.T3Pos.oldValue = parseFloat(objProductOld.Param7_T3Pos).toFixed(objProductOld.Param7_DP);
                          objHardness.Hardness.T3Pos.newValue = objProductNew.flt_HrdT2_3;
                          IsChanged = true;
                      }
  
                  } else {
  
                      if ((objProductOld.Param7_T3Pos === null) && (objProductNew.flt_HrdT2_3 !== null)) {
                          objHardness.Hardness.T3Pos.oldValue = "NA";
                          objHardness.Hardness.T3Pos.newValue = objProductNew.flt_HrdT2_3;
                          IsChanged = true;
  
                      } else if ((objProductOld.Param7_T3Pos !== null) && (objProductNew.flt_HrdT2_3 === null)) {
                          objHardness.Hardness.T3Pos.oldValue = parseFloat(objProductOld.Param7_T3Pos).toFixed(objProductOld.Param7_DP);
                          objHardness.Hardness.T3Pos.newValue = "NA";
                          IsChanged = true;
                      }
                  }
              }
             */
             /**
              if (OldEmpty == true) {
                  if (objProductNew.str_HrdUnit != "" && objProductNew.flt_HrdStd != "" && objProductNew.str_HrdUnit != undefined && objProductNew.flt_HrdStd != undefined) {
                      objHardness.Hardness.HrdUnit.oldValue = "NA";
                      objHardness.Hardness.HrdUnit.newValue = objProductNew.str_HrdUnit;
                      IsChanged = true;
                  }
                  else {
                      objHardness.Hardness.HrdUnit.oldValue = false;
                      objHardness.Hardness.HrdUnit.newValue = false;
                      IsChanged = false;
                  }
              }
              else {
                  if (objProductOld.Param7_Nom == null && objProductNew.flt_HrdStd != null) { // new parameter added
                      objHardness.Hardness.HrdUnit.oldValue = "NA";
                      objHardness.Hardness.HrdUnit.newValue = objProductNew.str_HrdUnit;
                      IsChanged = true;
                  }
                  else if (objProductOld.Param7_Nom == null && objProductNew.flt_HrdStd == null) // no parameter added
                  {
                      objHardness.Hardness.HrdUnit.oldValue = false;
                      objHardness.Hardness.HrdUnit.newValue = false;
                      IsChanged = false;
                  }
                  else {
                      if (objProductOld.Param7_Unit == objProductNew.str_HrdUnit) {
                          objHardness.Hardness.HrdUnit.oldValue = false;
                          objHardness.Hardness.HrdUnit.newValue = false;
                          IsChanged != true ? IsChanged = false : IsChanged = true;
                      }
                      else {
                          objHardness.Hardness.HrdUnit.oldValue = objProductOld.Param7_Unit;
                          objHardness.Hardness.HrdUnit.newValue = objProductNew.str_HrdUnit;
                          IsChanged = true;
                      }
                  }
              }
              */

            /**
             * For Individual Limits On Standard / Avg
            if (OldEmpty == true) {
                if (objProductNew.str_HrdGraphOn != "") {
                    objHardness.Hardness.ReportOn.oldValue = "NA";
                    objHardness.Hardness.ReportOn.newValue = objProductNew.str_HrdGraphOn;
                    IsChanged = true;
                }
                else {
                    objHardness.Hardness.ReportOn.oldValue = false;
                    objHardness.Hardness.ReportOn.newValue = false;
                    IsChanged = false;
                }
            }
            else {
                const strGraphOn = objProductOld.Param7_IsOnStd == 0 ? "Standard" : "Average";
                if (objProductOld.Param7_Nom == null && objProductNew.flt_HrdStd != null) { // new parameter added
                    objHardness.Hardness.ReportOn.oldValue = "NA";
                    objHardness.Hardness.ReportOn.newValue = objProductNew.str_HrdGraphOn;
                    IsChanged = true;
                }
                else if (objProductOld.Param7_Nom == null && objProductNew.flt_HrdStd == null) // no parameter added
                {
                    objHardness.Hardness.ReportOn.oldValue = false;
                    objHardness.Hardness.ReportOn.newValue = false;
                    IsChanged = false;
                }
                else {
                    if (strGraphOn == objProductNew.str_HrdGraphOn) {
                        objHardness.Hardness.ReportOn.oldValue = false;
                        objHardness.Hardness.ReportOn.newValue = false;
                        IsChanged != true ? IsChanged = false : IsChanged = true;
                    }
                    else {
                        objHardness.Hardness.ReportOn.oldValue = strGraphOn;
                        objHardness.Hardness.ReportOn.newValue = objProductNew.str_HrdGraphOn;
                        IsChanged = true;
                    }
                }
            }
             */

            if (IsChanged == true) {
                Object.assign(this.objResult, objHardness);
            }
            resolve(IsChanged);
        });
    }

    validateFriability(objProductOld, objProductNew) {
        return new Promise((resolve, reject) => {
            const objFriability = {
                Friability: {
                    FriNMT: { oldValue: "", newValue: "" },
                    'Lower Limit': { oldValue: "", newValue: "" },
                    'Upper Limit': { oldValue: "", newValue: "" },
                    FriSetCnt: { oldValue: "", newValue: "" },
                    FriSetRPM: { oldValue: "", newValue: "" },
                }
            };

            var IsChanged = false;
            var OldEmpty = objProductOld == undefined ? true : false;
            /**
             * For Individual Nom
            if (OldEmpty == true) {
                if (objProductNew.flt_FriNMT != "" && objProductNew.flt_FriNMT != undefined) {
                    objFriability.Friability.FriNMT.oldValue = "NA";
                    objFriability.Friability.FriNMT.newValue = objProductNew.flt_FriNMT;
                    IsChanged = true;
                }
                else {
                    objFriability.Friability.FriNMT.oldValue = false;
                    objFriability.Friability.FriNMT.newValue = false;
                    IsChanged = false;
                }
            }
            else {
                if (objProductOld.Param8_Nom === "" ||
                    objProductOld.Param8_Nom == this.NMTValue ||
                    objProductOld.Param8_Nom == undefined) {
                    objProductOld.Param8_Nom = null;
                }

                if (objProductNew.flt_FriNMT === "" ||
                    objProductNew.flt_FriNMT == this.NMTValue ||
                    objProductNew.flt_FriNMT == undefined) {
                    objProductNew.flt_FriNMT = null;
                }

                if ((objProductOld.Param8_Nom !== null) && (objProductNew.flt_FriNMT !== null)) {
                    if (parseFloat(objProductOld.Param8_Nom).toFixed(objProductOld.Param8_DP) == parseFloat(objProductNew.flt_FriNMT).toFixed(objProductNew.int_FriDp)) {
                        objFriability.Friability.FriNMT.oldValue = false;
                        objFriability.Friability.FriNMT.newValue = false;
                        IsChanged = false;
                    }
                    else {
                        objFriability.Friability.FriNMT.oldValue = parseFloat(objProductOld.Param8_Nom).toFixed(objProductOld.Param8_DP);
                        objFriability.Friability.FriNMT.newValue = objProductNew.flt_FriNMT;
                        IsChanged = true;
                    }

                } else {

                    if ((objProductOld.Param8_Nom === null) && (objProductNew.flt_FriNMT !== null)) {
                        objFriability.Friability.FriNMT.oldValue = "NA";
                        objFriability.Friability.FriNMT.newValue = objProductNew.flt_FriNMT;
                        IsChanged = true;

                    } else if ((objProductOld.Param8_Nom !== null) && (objProductNew.flt_FriNMT === null)) {
                        objFriability.Friability.FriNMT.oldValue = parseFloat(objProductOld.Param8_Nom).toFixed(objProductOld.Param8_DP);
                        objFriability.Friability.FriNMT.newValue = "NA";
                        IsChanged = true;
                    }
                }
            }            
             */

            /**
             * For Lower Limit
             */
            if (OldEmpty == true) {
                if (objProductNew.flt_FriT1Neg != "" && objProductNew.flt_FriT1Neg != undefined) {
                    objFriability.Friability['Lower Limit'].oldValue = "NA";
                    objFriability.Friability['Lower Limit'].newValue = objProductNew.flt_FriT1Neg;
                    IsChanged = true;
                }
                else {
                    objFriability.Friability['Lower Limit'].oldValue = false;
                    objFriability.Friability['Lower Limit'].newValue = false;
                    IsChanged = false;
                }
            }
            else {
                if (objProductOld.Param8_IniQty === "" ||
                    objProductOld.Param8_IniQty == this.strNullValue ||
                    objProductOld.Param8_IniQty == undefined) {
                    objProductOld.Param8_IniQty = null;
                }

                if (objProductNew.flt_FriT1Neg === "" ||
                    objProductNew.flt_FriT1Neg == this.strNullValue ||
                    objProductNew.flt_FriT1Neg == undefined) {
                    objProductNew.flt_FriT1Neg = null;
                }

                if ((objProductOld.Param8_IniQty !== null) && (objProductNew.flt_FriT1Neg !== null)) {
                    if (parseFloat(objProductOld.Param8_IniQty).toFixed(objProductOld.Param8_DP) == parseFloat(objProductNew.flt_FriT1Neg).toFixed(objProductNew.int_FriDp)) {
                        objFriability.Friability['Lower Limit'].oldValue = false;
                        objFriability.Friability['Lower Limit'].newValue = false;
                        IsChanged != true ? IsChanged = false : IsChanged = true;
                    }
                    else {
                        objFriability.Friability['Lower Limit'].oldValue = parseFloat(objProductOld.Param8_IniQty).toFixed(objProductOld.Param8_DP);
                        objFriability.Friability['Lower Limit'].newValue = objProductNew.flt_FriT1Neg;
                        IsChanged = true;
                    }

                } else {

                    if ((objProductOld.Param8_IniQty === null) && (objProductNew.flt_FriT1Neg !== null)) {
                        objFriability.Friability['Lower Limit'].oldValue = "NA";
                        objFriability.Friability['Lower Limit'].newValue = objProductNew.flt_FriT1Neg;
                        IsChanged = true;

                    } else if ((objProductOld.Param8_IniQty !== null) && (objProductNew.flt_FriT1Neg === null)) {
                        objFriability.Friability['Lower Limit'].oldValue = parseFloat(objProductOld.Param8_IniQty).toFixed(objProductOld.Param8_DP);
                        objFriability.Friability['Lower Limit'].newValue = "NA";
                        IsChanged = true;
                    }
                }
            }
            
            /**
             * For UpperLimit
             */
            if (OldEmpty == true) {
                if (objProductNew.flt_FriT1Pos != "" && objProductNew.flt_FriT1Pos != undefined) {
                    objFriability.Friability['Upper Limit'].oldValue = "NA";
                    objFriability.Friability['Upper Limit'].newValue = objProductNew.flt_FriT1Pos;
                    IsChanged = true;
                }
                else {
                    objFriability.Friability['Upper Limit'].oldValue = false;
                    objFriability.Friability['Upper Limit'].newValue = false;
                    IsChanged = false;
                }
            }
            else {
                if (objProductOld.Param8_RegQty === "" ||
                    objProductOld.Param8_RegQty == this.strNullValue ||
                    objProductOld.Param8_RegQty == undefined) {
                    objProductOld.Param8_RegQty = null;
                }

                if (objProductNew.flt_FriT1Pos === "" ||
                    objProductNew.flt_FriT1Pos == this.strNullValue ||
                    objProductNew.flt_FriT1Pos == undefined) {
                    objProductNew.flt_FriT1Pos = null;
                }

                if ((objProductOld.Param8_RegQty !== null) && (objProductNew.flt_FriT1Pos !== null)) {
                    if (parseFloat(objProductOld.Param8_RegQty).toFixed(objProductOld.Param8_DP) == parseFloat(objProductNew.flt_FriT1Pos).toFixed(objProductNew.int_FriDp)) {
                        objFriability.Friability['Upper Limit'].oldValue = false;
                        objFriability.Friability['Upper Limit'].newValue = false;
                        IsChanged != true ? IsChanged = false : IsChanged = true;
                    }
                    else {
                        objFriability.Friability['Upper Limit'].oldValue = parseFloat(objProductOld.Param8_RegQty).toFixed(objProductOld.Param8_DP);
                        objFriability.Friability['Upper Limit'].newValue = objProductNew.flt_FriT1Pos;
                        IsChanged = true;
                    }

                } else {

                    if ((objProductOld.Param8_RegQty === null) && (objProductNew.flt_FriT1Pos !== null)) {
                        objFriability.Friability['Upper Limit'].oldValue = "NA";
                        objFriability.Friability['Upper Limit'].newValue = objProductNew.flt_FriT1Pos;
                        IsChanged = true;

                    } else if ((objProductOld.Param8_RegQty !== null) && (objProductNew.flt_FriT1Pos === null)) {
                        objFriability.Friability['Upper Limit'].oldValue = parseFloat(objProductOld.Param8_RegQty).toFixed(objProductOld.Param8_DP);
                        objFriability.Friability['Upper Limit'].newValue = "NA";
                        IsChanged = true;
                    }
                }
            }

            /**
             * For Individual NegT1
             */
            if (OldEmpty == true) {
                if (objProductNew.int_FriSetCnt != "" && objProductNew.int_FriSetCnt != undefined) {
                    objFriability.Friability.FriSetCnt.oldValue = "NA";
                    objFriability.Friability.FriSetCnt.newValue = objProductNew.int_FriSetCnt;
                    IsChanged = true;
                }
                else {
                    objFriability.Friability.FriSetCnt.oldValue = false;
                    objFriability.Friability.FriSetCnt.newValue = false;
                    IsChanged = false;
                }
            }
            else {
                if (objProductOld.Param8_T1Neg === "" ||
                    objProductOld.Param8_T1Neg == this.strNullValue ||
                    objProductOld.Param8_T1Neg == undefined) {
                    objProductOld.Param8_T1Neg = null;
                }

                if (objProductNew.int_FriSetCnt === "" ||
                    objProductNew.int_FriSetCnt == this.strNullValue ||
                    objProductNew.int_FriSetCnt == undefined) {
                    objProductNew.int_FriSetCnt = null;
                }

                if ((objProductOld.Param8_T1Neg !== null) && (objProductNew.int_FriSetCnt !== null)) {
                    if (parseFloat(objProductOld.Param8_T1Neg).toFixed(objProductOld.Param8_DP) == parseFloat(objProductNew.int_FriSetCnt).toFixed(objProductNew.int_FriDp)) {
                        objFriability.Friability.FriSetCnt.oldValue = false;
                        objFriability.Friability.FriSetCnt.newValue = false;
                        IsChanged != true ? IsChanged = false : IsChanged = true;
                    }
                    else {
                        objFriability.Friability.FriSetCnt.oldValue = parseFloat(objProductOld.Param8_T1Neg).toFixed(objProductOld.Param8_DP);
                        objFriability.Friability.FriSetCnt.newValue = objProductNew.int_FriSetCnt;
                        IsChanged = true;
                    }

                } else {

                    if ((objProductOld.Param8_T1Neg === null) && (objProductNew.int_FriSetCnt !== null)) {
                        objFriability.Friability.FriSetCnt.oldValue = "NA";
                        objFriability.Friability.FriSetCnt.newValue = objProductNew.int_FriSetCnt;
                        IsChanged = true;

                    } else if ((objProductOld.Param8_T1Neg !== null) && (objProductNew.int_FriSetCnt === null)) {
                        objFriability.Friability.FriSetCnt.oldValue = parseFloat(objProductOld.Param8_T1Neg).toFixed(objProductOld.Param8_DP);
                        objFriability.Friability.FriSetCnt.newValue = "NA";
                        IsChanged = true;
                    }
                }
            }
            
            /**
             * For Individual PosT1
             */
            if (OldEmpty == true) {
                if (objProductNew.int_FriSetRPM != "" && objProductNew.int_FriSetRPM != undefined) {
                    objFriability.Friability.FriSetRPM.oldValue = "NA";
                    objFriability.Friability.FriSetRPM.newValue = objProductNew.int_FriSetRPM;
                    IsChanged = true;
                }
                else {
                    objFriability.Friability.FriSetRPM.oldValue = false;
                    objFriability.Friability.FriSetRPM.newValue = false;
                    IsChanged = false;
                }
            }
            else {
                if (objProductOld.Param8_T1Pos === "" ||
                    objProductOld.Param8_T1Pos == this.strNullValue ||
                    objProductOld.Param8_T1Pos == undefined) {
                    objProductOld.Param8_T1Pos = null;
                }

                if (objProductNew.int_FriSetRPM === "" ||
                    objProductNew.int_FriSetRPM == this.strNullValue ||
                    objProductNew.int_FriSetRPM == undefined) {
                    objProductNew.int_FriSetRPM = null;
                }

                if ((objProductOld.Param8_T1Pos !== null) && (objProductNew.int_FriSetRPM !== null)) {
                    if (parseFloat(objProductOld.Param8_T1Pos).toFixed(objProductOld.Param8_DP) == parseFloat(objProductNew.int_FriSetRPM).toFixed(objProductNew.int_FriDp)) {
                        objFriability.Friability.FriSetRPM.oldValue = false;
                        objFriability.Friability.FriSetRPM.newValue = false;
                        IsChanged != true ? IsChanged = false : IsChanged = true;
                    }
                    else {
                        objFriability.Friability.FriSetRPM.oldValue = parseFloat(objProductOld.Param8_T1Pos).toFixed(objProductOld.Param8_DP);
                        objFriability.Friability.FriSetRPM.newValue = objProductNew.int_FriSetRPM;
                        IsChanged = true;
                    }

                } else {

                    if ((objProductOld.Param8_T1Pos === null) && (objProductNew.int_FriSetRPM !== null)) {
                        objFriability.Friability.FriSetRPM.oldValue = "NA";
                        objFriability.Friability.FriSetRPM.newValue = objProductNew.int_FriSetRPM;
                        IsChanged = true;

                    } else if ((objProductOld.Param8_T1Pos !== null) && (objProductNew.int_FriSetRPM === null)) {
                        objFriability.Friability.FriSetRPM.oldValue = parseFloat(objProductOld.Param8_T1Pos).toFixed(objProductOld.Param8_DP);
                        objFriability.Friability.FriSetRPM.newValue = "NA";
                        IsChanged = true;
                    }
                }
            }            

            if (IsChanged == true) {
                Object.assign(this.objResult, objFriability);
            }
            resolve(IsChanged);
        });
    }

    validateIndLayer1(objProductOld, objProductNew) {
        return new Promise((resolve, reject) => {
            const objIndividualL1 = {
                IndividualL1: {
                    Nom: { oldValue: "", newValue: "" },
                    T1Neg: { oldValue: "", newValue: "" },
                    T1Pos: { oldValue: "", newValue: "" },
                    T2Neg: { oldValue: "", newValue: "" },
                    T2Pos: { oldValue: "", newValue: "" },
                    NMT: { oldValue: "", newValue: "" },
                    LimitOn: { oldValue: "", newValue: "" },
                    ReportOn: { oldValue: "", newValue: "" },
                    Nomenclature: { oldValue: "", newValue: "" }
                }
            };

            var IsChanged = false;
            var OldEmpty = objProductOld == undefined ? true : false;
            /**
             * For Individual Nom
             */
            if (OldEmpty == true) {
                if (objProductNew.flt_IndL1Std != "" && objProductNew.flt_IndL1Std != undefined) {
                    objIndividualL1.IndividualL1.Nom.oldValue = "NA";
                    objIndividualL1.IndividualL1.Nom.newValue = objProductNew.flt_IndL1Std;
                    IsChanged = true;
                }
                else {
                    objIndividualL1.IndividualL1.Nom.oldValue = false;
                    objIndividualL1.IndividualL1.Nom.newValue = false;
                    IsChanged = false;
                }
            }
            else {
                if (objProductOld.Param9_Nom === "" ||
                    objProductOld.Param9_Nom == this.strNullValue ||
                    objProductOld.Param9_Nom == undefined) {
                    objProductOld.Param9_Nom = null;
                }

                if (objProductNew.flt_IndL1Std === "" ||
                    objProductNew.flt_IndL1Std == this.strNullValue ||
                    objProductNew.flt_IndL1Std == undefined) {
                    objProductNew.flt_IndL1Std = null;
                }

                if ((objProductOld.Param9_Nom !== null) && (objProductNew.flt_IndL1Std !== null)) {
                    if (parseFloat(objProductOld.Param9_Nom).toFixed(objProductOld.Param9_DP) == parseFloat(objProductNew.flt_IndL1Std).toFixed(objProductNew.int_IndL1Dp)) {
                        objIndividualL1.IndividualL1.Nom.oldValue = false;
                        objIndividualL1.IndividualL1.Nom.newValue = false;
                        IsChanged = false;
                    }
                    else {
                        objIndividualL1.IndividualL1.Nom.oldValue = parseFloat(objProductOld.Param9_Nom).toFixed(objProductOld.Param9_DP);
                        objIndividualL1.IndividualL1.Nom.newValue = objProductNew.flt_IndL1Std;
                        IsChanged = true;
                    }

                } else {

                    if ((objProductOld.Param9_Nom === null) && (objProductNew.flt_IndL1Std !== null)) {
                        objIndividualL1.IndividualL1.Nom.oldValue = "NA";
                        objIndividualL1.IndividualL1.Nom.newValue = objProductNew.flt_IndL1Std;
                        IsChanged = true;

                    } else if ((objProductOld.Param9_Nom !== null) && (objProductNew.flt_IndL1Std === null)) {
                        objIndividualL1.IndividualL1.Nom.oldValue = parseFloat(objProductOld.Param9_Nom).toFixed(objProductOld.Param9_DP);
                        objIndividualL1.IndividualL1.Nom.newValue = "NA";
                        IsChanged = true;
                    }
                }
            }            

            /**
             * For Individual NegT1
             */
            if (OldEmpty == true) {
                if (objProductNew.flt_IndL1T1Neg != "" && objProductNew.flt_IndL1T1Neg != undefined) {
                    objIndividualL1.IndividualL1.T1Neg.oldValue = "NA";
                    objIndividualL1.IndividualL1.T1Neg.newValue = objProductNew.flt_IndL1T1Neg;
                    IsChanged = true;
                }
                else {
                    objIndividualL1.IndividualL1.T1Neg.oldValue = false;
                    objIndividualL1.IndividualL1.T1Neg.newValue = false;
                    IsChanged = false;
                }
            }
            else {
                if (objProductOld.Param9_T1Neg === "" ||
                    objProductOld.Param9_T1Neg == this.strNullValue ||
                    objProductOld.Param9_T1Neg == undefined) {
                    objProductOld.Param9_T1Neg = null;
                }

                if (objProductNew.flt_IndL1T1Neg === "" ||
                    objProductNew.flt_IndL1T1Neg == this.strNullValue ||
                    objProductNew.flt_IndL1T1Neg == undefined) {
                    objProductNew.flt_IndL1T1Neg = null;
                }

                if ((objProductOld.Param9_T1Neg !== null) && (objProductNew.flt_IndL1T1Neg !== null)) {
                    if (parseFloat(objProductOld.Param9_T1Neg).toFixed(objProductOld.Param9_DP) == parseFloat(objProductNew.flt_IndL1T1Neg).toFixed(objProductNew.int_IndL1Dp)) {
                        objIndividualL1.IndividualL1.T1Neg.oldValue = false;
                        objIndividualL1.IndividualL1.T1Neg.newValue = false;
                        IsChanged != true ? IsChanged = false : IsChanged = true;
                    }
                    else {
                        objIndividualL1.IndividualL1.T1Neg.oldValue = parseFloat(objProductOld.Param9_T1Neg).toFixed(objProductOld.Param9_DP);
                        objIndividualL1.IndividualL1.T1Neg.newValue = objProductNew.flt_IndL1T1Neg;
                        IsChanged = true;
                    }

                } else {

                    if ((objProductOld.Param9_T1Neg === null) && (objProductNew.flt_IndL1T1Neg !== null)) {
                        objIndividualL1.IndividualL1.T1Neg.oldValue = "NA";
                        objIndividualL1.IndividualL1.T1Neg.newValue = objProductNew.flt_IndL1T1Neg;
                        IsChanged = true;

                    } else if ((objProductOld.Param9_T1Neg !== null) && (objProductNew.flt_IndL1T1Neg === null)) {
                        objIndividualL1.IndividualL1.T1Neg.oldValue = parseFloat(objProductOld.Param9_T1Neg).toFixed(objProductOld.Param9_DP);
                        objIndividualL1.IndividualL1.T1Neg.newValue = "NA";
                        IsChanged = true;
                    }
                }
            }            

            /**
             * For Individual PosT1
             */
            if (OldEmpty == true) {
                if (objProductNew.flt_IndL1T1Pos != "" && objProductNew.flt_IndL1T1Pos != undefined) {
                    objIndividualL1.IndividualL1.T1Pos.oldValue = "NA";
                    objIndividualL1.IndividualL1.T1Pos.newValue = objProductNew.flt_IndL1T1Pos;
                    IsChanged = true;
                }
                else {
                    objIndividualL1.IndividualL1.T1Pos.oldValue = false;
                    objIndividualL1.IndividualL1.T1Pos.newValue = false;
                    IsChanged = false;
                }
            }
            else {
                if (objProductOld.Param9_T1Pos === "" ||
                    objProductOld.Param9_T1Pos == this.strNullValue ||
                    objProductOld.Param9_T1Pos == undefined) {
                    objProductOld.Param9_T1Pos = null;
                }

                if (objProductNew.flt_IndL1T1Pos === "" ||
                    objProductNew.flt_IndL1T1Pos == this.strNullValue ||
                    objProductNew.flt_IndL1T1Pos == undefined) {
                    objProductNew.flt_IndL1T1Pos = null;
                }

                if ((objProductOld.Param9_T1Pos !== null) && (objProductNew.flt_IndL1T1Pos !== null)) {
                    if (parseFloat(objProductOld.Param9_T1Pos).toFixed(objProductOld.Param9_DP) == parseFloat(objProductNew.flt_IndL1T1Pos).toFixed(objProductNew.int_IndL1Dp)) {
                        objIndividualL1.IndividualL1.T1Pos.oldValue = false;
                        objIndividualL1.IndividualL1.T1Pos.newValue = false;
                        IsChanged != true ? IsChanged = false : IsChanged = true;
                    }
                    else {
                        objIndividualL1.IndividualL1.T1Pos.oldValue = parseFloat(objProductOld.Param9_T1Pos).toFixed(objProductOld.Param9_DP);
                        objIndividualL1.IndividualL1.T1Pos.newValue = objProductNew.flt_IndL1T1Pos;
                        IsChanged = true;
                    }

                } else {

                    if ((objProductOld.Param9_T1Pos === null) && (objProductNew.flt_IndL1T1Pos !== null)) {
                        objIndividualL1.IndividualL1.T1Pos.oldValue = "NA";
                        objIndividualL1.IndividualL1.T1Pos.newValue = objProductNew.flt_IndL1T1Pos;
                        IsChanged = true;

                    } else if ((objProductOld.Param9_T1Pos !== null) && (objProductNew.flt_IndL1T1Pos === null)) {
                        objIndividualL1.IndividualL1.T1Pos.oldValue = parseFloat(objProductOld.Param9_T1Pos).toFixed(objProductOld.Param9_DP);
                        objIndividualL1.IndividualL1.T1Pos.newValue = "NA";
                        IsChanged = true;
                    }
                }
            }
            
            /**
            * For Individual NegT2
            */
            if (OldEmpty == true) {
                if (objProductNew.flt_IndL1T2Neg != "" && objProductNew.flt_IndL1T2Neg != undefined) {
                    objIndividualL1.IndividualL1.T2Neg.oldValue = "NA";
                    objIndividualL1.IndividualL1.T2Neg.newValue = objProductNew.flt_IndL1T2Neg;
                    IsChanged = true;
                }
                else {
                    objIndividualL1.IndividualL1.T2Neg.oldValue = false;
                    objIndividualL1.IndividualL1.T2Neg.newValue = false;
                    IsChanged = false;
                }
            }
            else {
                if (objProductOld.Param9_T2Neg === "" ||
                    objProductOld.Param9_T2Neg == this.strNullValue ||
                    objProductOld.Param9_T2Neg == undefined) {
                    objProductOld.Param9_T2Neg = null;
                }

                if (objProductNew.flt_IndL1T2Neg === "" ||
                    objProductNew.flt_IndL1T2Neg == this.strNullValue ||
                    objProductNew.flt_IndL1T2Neg == undefined) {
                    objProductNew.flt_IndL1T2Neg = null;
                }

                if ((objProductOld.Param9_T2Neg !== null) && (objProductNew.flt_IndL1T2Neg !== null)) {
                    if (parseFloat(objProductOld.Param9_T2Neg).toFixed(objProductOld.Param9_DP) == parseFloat(objProductNew.flt_IndL1T2Neg).toFixed(objProductNew.int_IndL1Dp)) {
                        objIndividualL1.IndividualL1.T2Neg.oldValue = false;
                        objIndividualL1.IndividualL1.T2Neg.newValue = false;
                        IsChanged != true ? IsChanged = false : IsChanged = true;
                    }
                    else {
                        objIndividualL1.IndividualL1.T2Neg.oldValue = parseFloat(objProductOld.Param9_T2Neg).toFixed(objProductOld.Param9_DP);
                        objIndividualL1.IndividualL1.T2Neg.newValue = objProductNew.flt_IndL1T2Neg;
                        IsChanged = true;
                    }

                } else {

                    if ((objProductOld.Param9_T2Neg === null) && (objProductNew.flt_IndL1T2Neg !== null)) {
                        objIndividualL1.IndividualL1.T2Neg.oldValue = "NA";
                        objIndividualL1.IndividualL1.T2Neg.newValue = objProductNew.flt_IndL1T2Neg;
                        IsChanged = true;

                    } else if ((objProductOld.Param9_T2Neg !== null) && (objProductNew.flt_IndL1T2Neg === null)) {
                        objIndividualL1.IndividualL1.T2Neg.oldValue = parseFloat(objProductOld.Param9_T2Neg).toFixed(objProductOld.Param9_DP);
                        objIndividualL1.IndividualL1.T2Neg.newValue = "NA";
                        IsChanged = true;
                    }
                }
            }
        
            /**
            * For Individual PosT2
            */
            if (OldEmpty == true) {
                if (objProductNew.flt_IndL1T2Pos != "" && objProductNew.flt_IndL1T2Pos != undefined) {
                    objIndividualL1.IndividualL1.T2Pos.oldValue = "NA";
                    objIndividualL1.IndividualL1.T2Pos.newValue = objProductNew.flt_IndL1T2Pos;
                    IsChanged = true;
                }
                else {
                    objIndividualL1.IndividualL1.T2Pos.oldValue = false;
                    objIndividualL1.IndividualL1.T2Pos.newValue = false;
                    IsChanged = false;
                }
            }
            else {
                if (objProductOld.Param9_T2Pos === "" ||
                    objProductOld.Param9_T2Pos == this.strNullValue ||
                    objProductOld.Param9_T2Pos == undefined) {
                    objProductOld.Param9_T2Pos = null;
                }

                if (objProductNew.flt_IndL1T2Pos === "" ||
                    objProductNew.flt_IndL1T2Pos == this.strNullValue ||
                    objProductNew.flt_IndL1T2Pos == undefined) {
                    objProductNew.flt_IndL1T2Pos = null;
                }

                if ((objProductOld.Param9_T2Pos !== null) && (objProductNew.flt_IndL1T2Pos !== null)) {
                    if (parseFloat(objProductOld.Param9_T2Pos).toFixed(objProductOld.Param9_DP) == parseFloat(objProductNew.flt_IndL1T2Pos).toFixed(objProductNew.int_IndL1Dp)) {
                        objIndividualL1.IndividualL1.T2Pos.oldValue = false;
                        objIndividualL1.IndividualL1.T2Pos.newValue = false;
                        IsChanged != true ? IsChanged = false : IsChanged = true;
                    }
                    else {
                        objIndividualL1.IndividualL1.T2Pos.oldValue = parseFloat(objProductOld.Param9_T2Pos).toFixed(objProductOld.Param9_DP);
                        objIndividualL1.IndividualL1.T2Pos.newValue = objProductNew.flt_IndL1T2Pos;
                        IsChanged = true;
                    }

                } else {

                    if ((objProductOld.Param9_T2Pos === null) && (objProductNew.flt_IndL1T2Pos !== null)) {
                        objIndividualL1.IndividualL1.T2Pos.oldValue = "NA";
                        objIndividualL1.IndividualL1.T2Pos.newValue = objProductNew.flt_IndL1T2Pos;
                        IsChanged = true;

                    } else if ((objProductOld.Param9_T2Pos !== null) && (objProductNew.flt_IndL1T2Pos === null)) {
                        objIndividualL1.IndividualL1.T2Pos.oldValue = parseFloat(objProductOld.Param9_T2Pos).toFixed(objProductOld.Param9_DP);
                        objIndividualL1.IndividualL1.T2Pos.newValue = "NA";
                        IsChanged = true;
                    }
                }
            }
           
            /**
            * For Individual NMT
            */
            if (OldEmpty == true) {
                if (objProductNew.int_IndL1NMTTabCount != "" && objProductNew.int_IndL1NMTTabCount != undefined) {
                    objIndividualL1.IndividualL1.NMT.oldValue = "NA";
                    objIndividualL1.IndividualL1.NMT.newValue = objProductNew.int_IndL1NMTTabCount;
                    IsChanged = true;
                }
                else {
                    objIndividualL1.IndividualL1.NMT.oldValue = false;
                    objIndividualL1.IndividualL1.NMT.newValue = false;
                    IsChanged = false;
                }
            }
            else {
                if (objProductOld.Param9_NMTTab == 0 ||
                    objProductOld.Param9_NMTTab == this.NMTValue ||
                    objProductOld.Param9_NMTTab == undefined) {
                    objProductOld.Param9_NMTTab = 0;
                }

                objProductNew.int_IndL1NMTTabCount = objProductNew.int_IndL1NMTTabCount === "" ? this.strNullValue : objProductNew.int_IndL1NMTTabCount;
                
                if (objProductNew.int_IndL1NMTTabCount == "0" ||
                    objProductNew.int_IndL1NMTTabCount == this.NMTValue ||
                    objProductNew.int_IndL1NMTTabCount == undefined) {
                    objProductNew.int_IndL1NMTTabCount = 0;
                }

                if (parseInt(objProductOld.Param9_NMTTab) == parseInt(objProductNew.int_IndL1NMTTabCount)) {
                    objIndividualL1.IndividualL1.NMT.oldValue = false;
                    objIndividualL1.IndividualL1.NMT.newValue = false;
                    IsChanged != true ? IsChanged = false : IsChanged = true;
                }
                else {
                    objIndividualL1.IndividualL1.NMT.oldValue = objProductOld.Param9_NMTTab;
                    objIndividualL1.IndividualL1.NMT.newValue = objProductNew.int_IndL1NMTTabCount;
                    IsChanged = true;
                }
            }
            
            /**
             * For Individual Limits On Actual / Percent
             */
            if (OldEmpty == true) {
                if (objProductNew.str_IndL1LimitOn != "" && objProductNew.flt_IndL1Std != "" && objProductNew.str_IndL1LimitOn != undefined && objProductNew.flt_IndL1Std != undefined) {
                    objIndividualL1.IndividualL1.LimitOn.oldValue = "NA";
                    objIndividualL1.IndividualL1.LimitOn.newValue = objProductNew.str_IndL1LimitOn;
                    IsChanged = true;
                }
                else {
                    objIndividualL1.IndividualL1.LimitOn.oldValue = false;
                    objIndividualL1.IndividualL1.LimitOn.newValue = false;
                    IsChanged = false;
                }
            }
            else {
                const strLimitOn = objProductOld.Param9_LimitOn == 0 ? "Actual" : "Percentage";
                if (objProductOld.Param9_Nom == null && objProductNew.flt_IndL1Std != null) { // new parameter added
                    objIndividualL1.IndividualL1.LimitOn.oldValue = "NA";
                    objIndividualL1.IndividualL1.LimitOn.newValue = objProductNew.str_IndL1LimitOn;
                    IsChanged = true;
                }
                else if (objProductOld.Param9_Nom == null && objProductNew.flt_IndL1Std == null) // no parameter added
                {
                    objIndividualL1.IndividualL1.LimitOn.oldValue = false;
                    objIndividualL1.IndividualL1.LimitOn.newValue = false;
                    IsChanged = false;
                }
                else // edit same parameter
                {
                    if (strLimitOn == objProductNew.str_IndL1LimitOn) {
                        objIndividualL1.IndividualL1.LimitOn.oldValue = false;
                        objIndividualL1.IndividualL1.LimitOn.newValue = false;
                        IsChanged != true ? IsChanged = false : IsChanged = true;
                    }
                    else {
                        objIndividualL1.IndividualL1.LimitOn.oldValue = strLimitOn;
                        objIndividualL1.IndividualL1.LimitOn.newValue = objProductNew.str_IndL1LimitOn;
                        IsChanged = true;
                    }
                }
            }

            /**
             * For Individual Limits On Standard / Avg
             */
            if (OldEmpty == true) {
                if (objProductNew.str_IndL1GraphOn != "" && objProductNew.flt_IndL1Std != "" && objProductNew.str_IndL1GraphOn != undefined && objProductNew.flt_IndL1Std != undefined) {
                    objIndividualL1.IndividualL1.ReportOn.oldValue = "NA";
                    objIndividualL1.IndividualL1.ReportOn.newValue = objProductNew.str_IndL1GraphOn;
                    IsChanged = true;
                }
                else {
                    objIndividualL1.IndividualL1.ReportOn.oldValue = false;
                    objIndividualL1.IndividualL1.ReportOn.newValue = false;
                    IsChanged = false;
                }
            }
            else {
                const strGraphOn = objProductOld.Param9_IsOnStd == 0 ? "Standard" : "Average";
                if (objProductOld.Param9_Nom == null && objProductNew.flt_IndL1Std != null) { // new parameter added
                    objIndividualL1.IndividualL1.ReportOn.oldValue = "NA";
                    objIndividualL1.IndividualL1.ReportOn.newValue = objProductNew.str_IndL1GraphOn;
                    IsChanged = true;
                }
                else if (objProductOld.Param9_Nom == null && objProductNew.flt_IndL1Std == null) // no parameter added
                {
                    objIndividualL1.IndividualL1.ReportOn.oldValue = false;
                    objIndividualL1.IndividualL1.ReportOn.newValue = false;
                    IsChanged = false;
                }
                else {
                    if (strGraphOn == objProductNew.str_IndL1GraphOn) {
                        objIndividualL1.IndividualL1.ReportOn.oldValue = false;
                        objIndividualL1.IndividualL1.ReportOn.newValue = false;
                        IsChanged != true ? IsChanged = false : IsChanged = true;
                    }
                    else {
                        objIndividualL1.IndividualL1.ReportOn.oldValue = strGraphOn;
                        objIndividualL1.IndividualL1.ReportOn.newValue = objProductNew.str_IndL1GraphOn;
                        IsChanged = true;
                    }
                }
            }

            /** Nominal Nomenclature */
            if (OldEmpty) {
                if (objProductNew.str_indL1_nomNomnclature != "" && objProductNew.flt_IndL1Std != "" && objProductNew.str_indL1_nomNomnclature != undefined && objProductNew.flt_IndL1Std != undefined) {
                    objIndividualL1.IndividualL1.Nomenclature.oldValue = "NA";
                    objIndividualL1.IndividualL1.Nomenclature.newValue = objProductNew.str_indL1_nomNomnclature;
                    IsChanged = true;
                }
                else {
                    objIndividualL1.IndividualL1.Nomenclature.oldValue = false;
                    objIndividualL1.IndividualL1.Nomenclature.newValue = false;
                    IsChanged = IsChanged != true ? false : true;
                }
            }
            else {

                if (objProductOld.Param9_Nom == null && objProductNew.flt_IndL1Std != null) { // new parameter added
                    objIndividualL1.IndividualL1.Nomenclature.oldValue = "NA";
                    objIndividualL1.IndividualL1.Nomenclature.newValue = objProductNew.str_indL1_nomNomnclature;
                    IsChanged = true;
                }
                else if (objProductOld.Param9_Nom == null && objProductNew.flt_IndL1Std == null) // no parameter added
                {
                    objIndividualL1.IndividualL1.Nomenclature.oldValue = false;
                    objIndividualL1.IndividualL1.Nomenclature.newValue = false;
                    IsChanged = false;
                }
                else {
                    if (objProductOld.Param9_Nomenclature == objProductNew.str_indL1_nomNomnclature) {
                        objIndividualL1.IndividualL1.Nomenclature.oldValue = false;
                        objIndividualL1.IndividualL1.Nomenclature.newValue = false;
                        IsChanged != true ? IsChanged = false : IsChanged = true;
                    }
                    else {
                        objIndividualL1.IndividualL1.Nomenclature.oldValue = objProductOld.Param9_Nomenclature;
                        objIndividualL1.IndividualL1.Nomenclature.newValue = objProductNew.str_indL1_nomNomnclature;
                        IsChanged = true;
                    }
                }
            }

            if (IsChanged == true) {
                Object.assign(this.objResult, objIndividualL1);
            }
            resolve(IsChanged);
        });
    }

    validateGrpLayer1(objProductOld, objProductNew) {
        return new Promise((resolve, reject) => {
            const objGroupL1 = {
                GroupL1: {
                    Nom: { oldValue: "", newValue: "" },
                    T1Neg: { oldValue: "", newValue: "" },
                    T1Pos: { oldValue: "", newValue: "" },
                    T2Neg: { oldValue: "", newValue: "" },
                    T2Pos: { oldValue: "", newValue: "" },
                    NMT: { oldValue: "", newValue: "" },
                    LimitOn: { oldValue: "", newValue: "" },
                    ReportOn: { oldValue: "", newValue: "" }
                }
            };

            var IsChanged = false;
            var OldEmpty = objProductOld == undefined ? true : false;
            /**
             * For Individual Nom
             */
            if (OldEmpty == true) {
                if (objProductNew.flt_GrpL1Std != "" && objProductNew.flt_GrpL1Std != undefined) {
                    objGroupL1.GroupL1.Nom.oldValue = "NA";
                    objGroupL1.GroupL1.Nom.newValue = objProductNew.flt_GrpL1Std;
                    IsChanged = true;
                }
                else {
                    objGroupL1.GroupL1.Nom.oldValue = false;
                    objGroupL1.GroupL1.Nom.newValue = false;
                    IsChanged = false;
                }
            }
            else {
                if (objProductOld.Param10_Nom === "" ||
                    objProductOld.Param10_Nom == this.strNullValue ||
                    objProductOld.Param10_Nom == undefined) {
                    objProductOld.Param10_Nom = null;
                }

                if (objProductNew.flt_GrpL1Std === "" ||
                    objProductNew.flt_GrpL1Std == this.strNullValue ||
                    objProductNew.flt_GrpL1Std == undefined) {
                    objProductNew.flt_GrpL1Std = null;
                }

                if ((objProductOld.Param10_Nom !== null) && (objProductNew.flt_GrpL1Std !== null)) {
                    if (parseFloat(objProductOld.Param10_Nom).toFixed(objProductOld.Param10_DP) == parseFloat(objProductNew.flt_GrpL1Std).toFixed(objProductNew.int_GrpL1Dp)) {
                        objGroupL1.GroupL1.Nom.oldValue = false;
                        objGroupL1.GroupL1.Nom.newValue = false;
                        IsChanged = false;
                    }
                    else {
                        objGroupL1.GroupL1.Nom.oldValue = parseFloat(objProductOld.Param10_Nom).toFixed(objProductOld.Param10_DP);
                        objGroupL1.GroupL1.Nom.newValue = objProductNew.flt_GrpL1Std;
                        IsChanged = true;
                    }

                } else {

                    if ((objProductOld.Param10_Nom === null) && (objProductNew.flt_GrpL1Std !== null)) {
                        objGroupL1.GroupL1.Nom.oldValue = "NA";
                        objGroupL1.GroupL1.Nom.newValue = objProductNew.flt_GrpL1Std;
                        IsChanged = true;

                    } else if ((objProductOld.Param10_Nom !== null) && (objProductNew.flt_GrpL1Std === null)) {
                        objGroupL1.GroupL1.Nom.oldValue = parseFloat(objProductOld.Param10_Nom).toFixed(objProductOld.Param10_DP);
                        objGroupL1.GroupL1.Nom.newValue = "NA";
                        IsChanged = true;
                    }
                }
            }

            /**
             * For Individual NegT1
             */
            if (OldEmpty == true) {
                if (objProductNew.flt_GrpL1T1Neg != "" && objProductNew.flt_GrpL1T1Neg != undefined) {
                    objGroupL1.GroupL1.T1Neg.oldValue = "NA";
                    objGroupL1.GroupL1.T1Neg.newValue = objProductNew.flt_GrpL1T1Neg;
                    IsChanged = true;
                }
                else {
                    objGroupL1.GroupL1.T1Neg.oldValue = false;
                    objGroupL1.GroupL1.T1Neg.newValue = false;
                    IsChanged = false;
                }
            }
            else {
                if (objProductOld.Param10_T1Neg === "" ||
                    objProductOld.Param10_T1Neg == this.strNullValue ||
                    objProductOld.Param10_T1Neg == undefined) {
                    objProductOld.Param10_T1Neg = null;
                }

                if (objProductNew.flt_GrpL1T1Neg === "" ||
                    objProductNew.flt_GrpL1T1Neg == this.strNullValue ||
                    objProductNew.flt_GrpL1T1Neg == undefined) {
                    objProductNew.flt_GrpL1T1Neg = null;
                }

                if ((objProductOld.Param10_T1Neg !== null) && (objProductNew.flt_GrpL1T1Neg !== null)) {
                    if (parseFloat(objProductOld.Param10_T1Neg).toFixed(objProductOld.Param10_DP) == parseFloat(objProductNew.flt_GrpL1T1Neg).toFixed(objProductNew.int_GrpL1Dp)) {
                        objGroupL1.GroupL1.T1Neg.oldValue = false;
                        objGroupL1.GroupL1.T1Neg.newValue = false;
                        IsChanged != true ? IsChanged = false : IsChanged = true;
                    }
                    else {
                        objGroupL1.GroupL1.T1Neg.oldValue = parseFloat(objProductOld.Param10_T1Neg).toFixed(objProductOld.Param10_DP);
                        objGroupL1.GroupL1.T1Neg.newValue = objProductNew.flt_GrpL1T1Neg;
                        IsChanged = true;
                    }

                } else {

                    if ((objProductOld.Param10_T1Neg === null) && (objProductNew.flt_GrpL1T1Neg !== null)) {
                        objGroupL1.GroupL1.T1Neg.oldValue = "NA";
                        objGroupL1.GroupL1.T1Neg.newValue = objProductNew.flt_GrpL1T1Neg;
                        IsChanged = true;

                    } else if ((objProductOld.Param10_T1Neg !== null) && (objProductNew.flt_GrpL1T1Neg === null)) {
                        objGroupL1.GroupL1.T1Neg.oldValue = parseFloat(objProductOld.Param10_T1Neg).toFixed(objProductOld.Param10_DP);
                        objGroupL1.GroupL1.T1Neg.newValue = "NA";
                        IsChanged = true;
                    }
                }
            }
            
            /**
             * For Individual PosT1
             */
            if (OldEmpty == true) {
                if (objProductNew.flt_GrpL1T1Pos != "" && objProductNew.flt_GrpL1T1Pos != undefined) {
                    objGroupL1.GroupL1.T1Pos.oldValue = "NA";
                    objGroupL1.GroupL1.T1Pos.newValue = objProductNew.flt_GrpL1T1Pos;
                    IsChanged = true;
                }
                else {
                    objGroupL1.GroupL1.T1Pos.oldValue = false;
                    objGroupL1.GroupL1.T1Pos.newValue = false;
                    IsChanged = false;
                }
            }
            else {
                if (objProductOld.Param10_T1Pos === "" ||
                    objProductOld.Param10_T1Pos == this.strNullValue ||
                    objProductOld.Param10_T1Pos == undefined) {
                    objProductOld.Param10_T1Pos = null;
                }

                if (objProductNew.flt_GrpL1T1Pos === "" ||
                    objProductNew.flt_GrpL1T1Pos == this.strNullValue ||
                    objProductNew.flt_GrpL1T1Pos == undefined) {
                    objProductNew.flt_GrpL1T1Pos = null;
                }

                if ((objProductOld.Param10_T1Pos !== null) && (objProductNew.flt_GrpL1T1Pos !== null)) {
                    if (parseFloat(objProductOld.Param10_T1Pos).toFixed(objProductOld.Param10_DP) == parseFloat(objProductNew.flt_GrpL1T1Pos).toFixed(objProductNew.int_GrpL1Dp)) {
                        objGroupL1.GroupL1.T1Pos.oldValue = false;
                        objGroupL1.GroupL1.T1Pos.newValue = false;
                        IsChanged != true ? IsChanged = false : IsChanged = true;
                    }
                    else {
                        objGroupL1.GroupL1.T1Pos.oldValue = parseFloat(objProductOld.Param10_T1Pos).toFixed(objProductOld.Param10_DP);
                        objGroupL1.GroupL1.T1Pos.newValue = objProductNew.flt_GrpL1T1Pos;
                        IsChanged = true;
                    }

                } else {

                    if ((objProductOld.Param10_T1Pos === null) && (objProductNew.flt_GrpL1T1Pos !== null)) {
                        objGroupL1.GroupL1.T1Pos.oldValue = "NA";
                        objGroupL1.GroupL1.T1Pos.newValue = objProductNew.flt_GrpL1T1Pos;
                        IsChanged = true;

                    } else if ((objProductOld.Param10_T1Pos !== null) && (objProductNew.flt_GrpL1T1Pos === null)) {
                        objGroupL1.GroupL1.T1Pos.oldValue = parseFloat(objProductOld.Param10_T1Pos).toFixed(objProductOld.Param10_DP);
                        objGroupL1.GroupL1.T1Pos.newValue = "NA";
                        IsChanged = true;
                    }
                }
            }
            
            /**
            * For Individual NegT2
            */
            if (OldEmpty == true) {
                if (objProductNew.flt_GrpL1T2Neg != "" && objProductNew.flt_GrpL1T2Neg != undefined) {
                    objGroupL1.GroupL1.T2Neg.oldValue = "NA";
                    objGroupL1.GroupL1.T2Neg.newValue = objProductNew.flt_GrpL1T2Neg;
                    IsChanged = true;
                }
                else {
                    objGroupL1.GroupL1.T2Neg.oldValue = false;
                    objGroupL1.GroupL1.T2Neg.newValue = false;
                    IsChanged = false;
                }
            }
            else {
                if (objProductOld.Param10_T2Neg === "" ||
                    objProductOld.Param10_T2Neg == this.strNullValue ||
                    objProductOld.Param10_T2Neg == undefined) {
                    objProductOld.Param10_T2Neg = null;
                }

                if (objProductNew.flt_GrpL1T2Neg === "" ||
                    objProductNew.flt_GrpL1T2Neg == this.strNullValue ||
                    objProductNew.flt_GrpL1T2Neg == undefined) {
                    objProductNew.flt_GrpL1T2Neg = null;
                }

                if ((objProductOld.Param10_T2Neg !== null) && (objProductNew.flt_GrpL1T2Neg !== null)) {
                    if (parseFloat(objProductOld.Param10_T2Neg).toFixed(objProductOld.Param10_DP) == parseFloat(objProductNew.flt_GrpL1T2Neg).toFixed(objProductNew.int_GrpL1Dp)) {
                        objGroupL1.GroupL1.T2Neg.oldValue = false;
                        objGroupL1.GroupL1.T2Neg.newValue = false;
                        IsChanged != true ? IsChanged = false : IsChanged = true;
                    }
                    else {
                        objGroupL1.GroupL1.T2Neg.oldValue = parseFloat(objProductOld.Param10_T2Neg).toFixed(objProductOld.Param10_DP);
                        objGroupL1.GroupL1.T2Neg.newValue = objProductNew.flt_GrpL1T2Neg;
                        IsChanged = true;
                    }

                } else {

                    if ((objProductOld.Param10_T2Neg === null) && (objProductNew.flt_GrpL1T2Neg !== null)) {
                        objGroupL1.GroupL1.T2Neg.oldValue = "NA";
                        objGroupL1.GroupL1.T2Neg.newValue = objProductNew.flt_GrpL1T2Neg;
                        IsChanged = true;

                    } else if ((objProductOld.Param10_T2Neg !== null) && (objProductNew.flt_GrpL1T2Neg === null)) {
                        objGroupL1.GroupL1.T2Neg.oldValue = parseFloat(objProductOld.Param10_T2Neg).toFixed(objProductOld.Param10_DP);
                        objGroupL1.GroupL1.T2Neg.newValue = "NA";
                        IsChanged = true;
                    }
                }
            }

            /**
            * For Individual PosT2
            */
            if (OldEmpty == true) {
                if (objProductNew.flt_GrpL1T2Pos != "" && objProductNew.flt_GrpL1T2Pos != undefined) {
                    objGroupL1.GroupL1.T2Pos.oldValue = "NA";
                    objGroupL1.GroupL1.T2Pos.newValue = objProductNew.flt_GrpL1T2Pos;
                    IsChanged = true;
                }
                else {
                    objGroupL1.GroupL1.T2Pos.oldValue = false;
                    objGroupL1.GroupL1.T2Pos.newValue = false;
                    IsChanged = false;
                }
            }
            else {
                if (objProductOld.Param10_T2Pos === "" ||
                    objProductOld.Param10_T2Pos == this.strNullValue ||
                    objProductOld.Param10_T2Pos == undefined) {
                    objProductOld.Param10_T2Pos = null;
                }

                if (objProductNew.flt_GrpL1T2Pos === "" ||
                    objProductNew.flt_GrpL1T2Pos == this.strNullValue ||
                    objProductNew.flt_GrpL1T2Pos == undefined) {
                    objProductNew.flt_GrpL1T2Pos = null;
                }

                if ((objProductOld.Param10_T2Pos !== null) && (objProductNew.flt_GrpL1T2Pos !== null)) {
                    if (parseFloat(objProductOld.Param10_T2Pos).toFixed(objProductOld.Param10_DP) == parseFloat(objProductNew.flt_GrpL1T2Pos).toFixed(objProductNew.int_GrpL1Dp)) {
                        objGroupL1.GroupL1.T2Pos.oldValue = false;
                        objGroupL1.GroupL1.T2Pos.newValue = false;
                        IsChanged != true ? IsChanged = false : IsChanged = true;
                    }
                    else {
                        objGroupL1.GroupL1.T2Pos.oldValue = parseFloat(objProductOld.Param10_T2Pos).toFixed(objProductOld.Param10_DP);
                        objGroupL1.GroupL1.T2Pos.newValue = objProductNew.flt_GrpL1T2Pos;
                        IsChanged = true;
                    }

                } else {

                    if ((objProductOld.Param10_T2Pos === null) && (objProductNew.flt_GrpL1T2Pos !== null)) {
                        objGroupL1.GroupL1.T2Pos.oldValue = "NA";
                        objGroupL1.GroupL1.T2Pos.newValue = objProductNew.flt_GrpL1T2Pos;
                        IsChanged = true;

                    } else if ((objProductOld.Param10_T2Pos !== null) && (objProductNew.flt_GrpL1T2Pos === null)) {
                        objGroupL1.GroupL1.T2Pos.oldValue = parseFloat(objProductOld.Param10_T2Pos).toFixed(objProductOld.Param10_DP);
                        objGroupL1.GroupL1.T2Pos.newValue = "NA";
                        IsChanged = true;
                    }
                }
            }
            
            /**
            * For Individual NMT
            */
            if (OldEmpty == true) {
                if (objProductNew.int_GrpL1NMTTabCount != "" && objProductNew.int_GrpL1NMTTabCount != undefined) {
                    objGroupL1.GroupL1.NMT.oldValue = "NA";
                    objGroupL1.GroupL1.NMT.newValue = objProductNew.int_GrpL1NMTTabCount;
                    IsChanged = true;
                }
                else {
                    objGroupL1.GroupL1.NMT.oldValue = false;
                    objGroupL1.GroupL1.NMT.newValue = false;
                    IsChanged = false;
                }
            }
            else {
                if (objProductOld.Param10_NMTTab == 0 ||
                    objProductOld.Param10_NMTTab == this.NMTValue ||
                    objProductOld.Param10_NMTTab == undefined) {
                    objProductOld.Param10_NMTTab = 0;
                }

                objProductNew.int_GrpL1NMTTabCount = objProductNew.int_GrpL1NMTTabCount === "" ? this.strNullValue : objProductNew.int_GrpL1NMTTabCount;
                
                if (objProductNew.int_GrpL1NMTTabCount == "0" ||
                    objProductNew.int_GrpL1NMTTabCount == this.NMTValue ||
                    objProductNew.int_GrpL1NMTTabCount == undefined) {
                    objProductNew.int_GrpL1NMTTabCount = 0;
                }

                if (parseInt(objProductOld.Param10_NMTTab) == parseInt(objProductNew.int_GrpL1NMTTabCount)) {
                    objGroupL1.GroupL1.NMT.oldValue = false;
                    objGroupL1.GroupL1.NMT.newValue = false;
                    IsChanged != true ? IsChanged = false : IsChanged = true;
                }
                else {
                    objGroupL1.GroupL1.NMT.oldValue = objProductOld.Param10_NMTTab;
                    objGroupL1.GroupL1.NMT.newValue = objProductNew.int_GrpL1NMTTabCount;
                    IsChanged = true;
                }
            }

            /**
             * For Individual Limits On Actual / Percent
             */
            if (OldEmpty == true) {
                if (objProductNew.str_GrpL1LimitOn != "" && objProductNew.flt_GrpL1Std != "" && objProductNew.str_GrpL1LimitOn != undefined && objProductNew.flt_GrpL1Std != undefined) {
                    objGroupL1.GroupL1.LimitOn.oldValue = "NA";
                    objGroupL1.GroupL1.LimitOn.newValue = objProductNew.str_GrpL1LimitOn;
                    IsChanged = true;
                }
                else {
                    objGroupL1.GroupL1.LimitOn.oldValue = false;
                    objGroupL1.GroupL1.LimitOn.newValue = false;
                    IsChanged = false;
                }
            }
            else {
                const strLimitOn = objProductOld.Param10_LimitOn == 0 ? "Actual" : "Percentage";
                if (objProductOld.Param10_Nom == null && objProductNew.flt_GrpL1Std != null) { // new parameter added
                    objGroupL1.GroupL1.LimitOn.oldValue = "NA";
                    objGroupL1.GroupL1.LimitOn.newValue = objProductNew.str_GrpL1LimitOn;
                    IsChanged = true;
                }
                else if (objProductOld.Param10_Nom == null && objProductNew.flt_GrpL1Std == null) // no parameter added
                {
                    objGroupL1.GroupL1.LimitOn.oldValue = false;
                    objGroupL1.GroupL1.LimitOn.newValue = false;
                    IsChanged = false;
                }
                else {
                    if (strLimitOn == objProductNew.str_GrpL1LimitOn) {
                        objGroupL1.GroupL1.LimitOn.oldValue = false;
                        objGroupL1.GroupL1.LimitOn.newValue = false;
                        IsChanged != true ? IsChanged = false : IsChanged = true;
                    }
                    else {
                        objGroupL1.GroupL1.LimitOn.oldValue = strLimitOn;
                        objGroupL1.GroupL1.LimitOn.newValue = objProductNew.str_GrpL1LimitOn;
                        IsChanged = true;
                    }
                }
            }

            /**
             * For Individual Limits On Standard / Avg
             */
            if (OldEmpty == true) {
                if (objProductNew.str_GrpL1GraphOn != "" && objProductNew.flt_GrpL1Std != "" && objProductNew.str_GrpL1GraphOn != undefined && objProductNew.flt_GrpL1Std != undefined) {
                    objGroupL1.GroupL1.ReportOn.oldValue = "NA";
                    objGroupL1.GroupL1.ReportOn.newValue = objProductNew.str_GrpL1GraphOn;
                    IsChanged = true;
                }
                else {
                    objGroupL1.GroupL1.ReportOn.oldValue = false;
                    objGroupL1.GroupL1.ReportOn.newValue = false;
                    IsChanged = false;
                }
            }
            else {
                const strGraphOn = objProductOld.Param10_IsOnStd == 0 ? "Standard" : "Average";
                if (objProductOld.Param10_Nom == null && objProductNew.flt_GrpL1Std != null) { // new parameter added
                    objGroupL1.GroupL1.ReportOn.oldValue = "NA";
                    objGroupL1.GroupL1.ReportOn.newValue = objProductNew.str_GrpL1GraphOn;
                    IsChanged = true;
                }
                else if (objProductOld.Param10_Nom == null && objProductNew.flt_GrpL1Std == null) // no parameter added
                {
                    objGroupL1.GroupL1.ReportOn.oldValue = false;
                    objGroupL1.GroupL1.ReportOn.newValue = false;
                    IsChanged = false;
                }
                else {
                    if (strGraphOn == objProductNew.str_GrpL1GraphOn) {
                        objGroupL1.GroupL1.ReportOn.oldValue = false;
                        objGroupL1.GroupL1.ReportOn.newValue = false;
                        IsChanged != true ? IsChanged = false : IsChanged = true;
                    }
                    else {
                        objGroupL1.GroupL1.ReportOn.oldValue = strGraphOn;
                        objGroupL1.GroupL1.ReportOn.newValue = objProductNew.str_GrpL1GraphOn;
                        IsChanged = true;
                    }
                }
            }

            if (IsChanged == true) {
                Object.assign(this.objResult, objGroupL1);
            }
            resolve(IsChanged);
        });
    }

    validateIndLayer2(objProductOld, objProductNew) {
        return new Promise((resolve, reject) => {
            const objIndividualL2 = {
                IndividualL2: {
                    Nom: { oldValue: "", newValue: "" },
                    T1Neg: { oldValue: "", newValue: "" },
                    T1Pos: { oldValue: "", newValue: "" },
                    T2Neg: { oldValue: "", newValue: "" },
                    T2Pos: { oldValue: "", newValue: "" },
                    NMT: { oldValue: "", newValue: "" },
                    LimitOn: { oldValue: "", newValue: "" },
                    ReportOn: { oldValue: "", newValue: "" },
                    Nomenclature: { oldValue: "", newValue: "" }
                }
            };

            var IsChanged = false;
            var OldEmpty = objProductOld == undefined ? true : false;
            /**
             * For Individual Nom
             */
            if (OldEmpty == true) {
                if (objProductNew.flt_IndL2Std != "" && objProductNew.flt_IndL2Std != undefined) {
                    objIndividualL2.IndividualL2.Nom.oldValue = "NA";
                    objIndividualL2.IndividualL2.Nom.newValue = objProductNew.flt_IndL2Std;
                    IsChanged = true;
                }
                else {
                    objIndividualL2.IndividualL2.Nom.oldValue = false;
                    objIndividualL2.IndividualL2.Nom.newValue = false;
                    IsChanged = false;
                }
            }
            else {
                if (objProductOld.Param11_Nom === "" ||
                    objProductOld.Param11_Nom == this.strNullValue ||
                    objProductOld.Param11_Nom == undefined) {
                    objProductOld.Param11_Nom = null;
                }

                if (objProductNew.flt_IndL2Std === "" ||
                    objProductNew.flt_IndL2Std == this.strNullValue ||
                    objProductNew.flt_IndL2Std == undefined) {
                    objProductNew.flt_IndL2Std = null;
                }

                if ((objProductOld.Param11_Nom !== null) && (objProductNew.flt_IndL2Std !== null)) {
                    if (parseFloat(objProductOld.Param11_Nom).toFixed(objProductOld.Param11_DP) == parseFloat(objProductNew.flt_IndL2Std).toFixed(objProductNew.int_IndL2Dp)) {
                        objIndividualL2.IndividualL2.Nom.oldValue = false;
                        objIndividualL2.IndividualL2.Nom.newValue = false;
                        IsChanged = false;
                    }
                    else {
                        objIndividualL2.IndividualL2.Nom.oldValue = parseFloat(objProductOld.Param11_Nom).toFixed(objProductOld.Param11_DP);
                        objIndividualL2.IndividualL2.Nom.newValue = objProductNew.flt_IndL2Std;
                        IsChanged = true;
                    }

                } else {

                    if ((objProductOld.Param11_Nom === null) && (objProductNew.flt_IndL2Std !== null)) {
                        objIndividualL2.IndividualL2.Nom.oldValue = "NA";
                        objIndividualL2.IndividualL2.Nom.newValue = objProductNew.flt_IndL2Std;
                        IsChanged = true;

                    } else if ((objProductOld.Param11_Nom !== null) && (objProductNew.flt_IndL2Std === null)) {
                        objIndividualL2.IndividualL2.Nom.oldValue = parseFloat(objProductOld.Param11_Nom).toFixed(objProductOld.Param11_DP);
                        objIndividualL2.IndividualL2.Nom.newValue = "NA";
                        IsChanged = true;
                    }
                }
            }

            /**
             * For Individual NegT1
             */
            if (OldEmpty == true) {
                if (objProductNew.flt_IndL2T1Neg != "" && objProductNew.flt_IndL2T1Neg != undefined) {
                    objIndividualL2.IndividualL2.T1Neg.oldValue = "NA";
                    objIndividualL2.IndividualL2.T1Neg.newValue = objProductNew.flt_IndL2T1Neg;
                    IsChanged = true;
                }
                else {
                    objIndividualL2.IndividualL2.T1Neg.oldValue = false;
                    objIndividualL2.IndividualL2.T1Neg.newValue = false;
                    IsChanged = false;
                }
            }
            else {
                if (objProductOld.Param11_T1Neg === "" ||
                    objProductOld.Param11_T1Neg == this.strNullValue ||
                    objProductOld.Param11_T1Neg == undefined) {
                    objProductOld.Param11_T1Neg = null;
                }

                if (objProductNew.flt_IndL2T1Neg === "" ||
                    objProductNew.flt_IndL2T1Neg == this.strNullValue ||
                    objProductNew.flt_IndL2T1Neg == undefined) {
                    objProductNew.flt_IndL2T1Neg = null;
                }

                if ((objProductOld.Param11_T1Neg !== null) && (objProductNew.flt_IndL2T1Neg !== null)) {
                    if (parseFloat(objProductOld.Param11_T1Neg).toFixed(objProductOld.Param11_DP) == parseFloat(objProductNew.flt_IndL2T1Neg).toFixed(objProductNew.int_IndL2Dp)) {
                        objIndividualL2.IndividualL2.T1Neg.oldValue = false;
                        objIndividualL2.IndividualL2.T1Neg.newValue = false;
                        IsChanged != true ? IsChanged = false : IsChanged = true;
                    }
                    else {
                        objIndividualL2.IndividualL2.T1Neg.oldValue = parseFloat(objProductOld.Param11_T1Neg).toFixed(objProductOld.Param11_DP);
                        objIndividualL2.IndividualL2.T1Neg.newValue = objProductNew.flt_IndL2T1Neg;
                        IsChanged = true;
                    }

                } else {

                    if ((objProductOld.Param11_T1Neg === null) && (objProductNew.flt_IndL2T1Neg !== null)) {
                        objIndividualL2.IndividualL2.T1Neg.oldValue = "NA";
                        objIndividualL2.IndividualL2.T1Neg.newValue = objProductNew.flt_IndL2T1Neg;
                        IsChanged = true;

                    } else if ((objProductOld.Param11_T1Neg !== null) && (objProductNew.flt_IndL2T1Neg === null)) {
                        objIndividualL2.IndividualL2.T1Neg.oldValue = parseFloat(objProductOld.Param11_T1Neg).toFixed(objProductOld.Param11_DP);
                        objIndividualL2.IndividualL2.T1Neg.newValue = "NA";
                        IsChanged = true;
                    }
                }
            }

            /**
             * For Individual PosT1
             */
            if (OldEmpty == true) {
                if (objProductNew.flt_IndL2T1Pos != "" && objProductNew.flt_IndL2T1Pos != undefined) {
                    objIndividualL2.IndividualL2.T1Pos.oldValue = "NA";
                    objIndividualL2.IndividualL2.T1Pos.newValue = objProductNew.flt_IndL2T1Pos;
                    IsChanged = true;
                }
                else {
                    objIndividualL2.IndividualL2.T1Pos.oldValue = false;
                    objIndividualL2.IndividualL2.T1Pos.newValue = false;
                    IsChanged = false;
                }
            }
            else {
                if (objProductOld.Param11_T1Pos === "" ||
                    objProductOld.Param11_T1Pos == this.strNullValue ||
                    objProductOld.Param11_T1Pos == undefined) {
                    objProductOld.Param11_T1Pos = null;
                }

                if (objProductNew.flt_IndL2T1Pos === "" ||
                    objProductNew.flt_IndL2T1Pos == this.strNullValue ||
                    objProductNew.flt_IndL2T1Pos == undefined) {
                    objProductNew.flt_IndL2T1Pos = null;
                }

                if ((objProductOld.Param11_T1Pos !== null) && (objProductNew.flt_IndL2T1Pos !== null)) {
                    if (parseFloat(objProductOld.Param11_T1Pos).toFixed(objProductOld.Param11_DP) == parseFloat(objProductNew.flt_IndL2T1Pos).toFixed(objProductNew.int_IndL2Dp)) {
                        objIndividualL2.IndividualL2.T1Pos.oldValue = false;
                        objIndividualL2.IndividualL2.T1Pos.newValue = false;
                        IsChanged != true ? IsChanged = false : IsChanged = true;
                    }
                    else {
                        objIndividualL2.IndividualL2.T1Pos.oldValue = parseFloat(objProductOld.Param11_T1Pos).toFixed(objProductOld.Param11_DP);
                        objIndividualL2.IndividualL2.T1Pos.newValue = objProductNew.flt_IndL2T1Pos;
                        IsChanged = true;
                    }

                } else {

                    if ((objProductOld.Param11_T1Pos === null) && (objProductNew.flt_IndL2T1Pos !== null)) {
                        objIndividualL2.IndividualL2.T1Pos.oldValue = "NA";
                        objIndividualL2.IndividualL2.T1Pos.newValue = objProductNew.flt_IndL2T1Pos;
                        IsChanged = true;

                    } else if ((objProductOld.Param11_T1Pos !== null) && (objProductNew.flt_IndL2T1Pos === null)) {
                        objIndividualL2.IndividualL2.T1Pos.oldValue = parseFloat(objProductOld.Param11_T1Pos).toFixed(objProductOld.Param11_DP);
                        objIndividualL2.IndividualL2.T1Pos.newValue = "NA";
                        IsChanged = true;
                    }
                }
            }
            
            /**
            * For Individual NegT2
            */
            if (OldEmpty == true) {
                if (objProductNew.flt_IndL2T2Neg != "" && objProductNew.flt_IndL2T2Neg != undefined) {
                    objIndividualL2.IndividualL2.T2Neg.oldValue = "NA";
                    objIndividualL2.IndividualL2.T2Neg.newValue = objProductNew.flt_IndL2T2Neg;
                    IsChanged = true;
                }
                else {
                    objIndividualL2.IndividualL2.T2Neg.oldValue = false;
                    objIndividualL2.IndividualL2.T2Neg.newValue = false;
                    IsChanged = false;
                }
            }
            else {
                if (objProductOld.Param11_T2Neg === "" ||
                    objProductOld.Param11_T2Neg == this.strNullValue ||
                    objProductOld.Param11_T2Neg == undefined) {
                    objProductOld.Param11_T2Neg = null;
                }

                if (objProductNew.flt_IndL2T2Neg === "" ||
                    objProductNew.flt_IndL2T2Neg == this.strNullValue ||
                    objProductNew.flt_IndL2T2Neg == undefined) {
                    objProductNew.flt_IndL2T2Neg = null;
                }

                if ((objProductOld.Param11_T2Neg !== null) && (objProductNew.flt_IndL2T2Neg !== null)) {
                    if (parseFloat(objProductOld.Param11_T2Neg).toFixed(objProductOld.Param11_DP) == parseFloat(objProductNew.flt_IndL2T2Neg).toFixed(objProductNew.int_IndL2Dp)) {
                        objIndividualL2.IndividualL2.T2Neg.oldValue = false;
                        objIndividualL2.IndividualL2.T2Neg.newValue = false;
                        IsChanged != true ? IsChanged = false : IsChanged = true;
                    }
                    else {
                        objIndividualL2.IndividualL2.T2Neg.oldValue = parseFloat(objProductOld.Param11_T2Neg).toFixed(objProductOld.Param11_DP);
                        objIndividualL2.IndividualL2.T2Neg.newValue = objProductNew.flt_IndL2T2Neg;
                        IsChanged = true;
                    }

                } else {

                    if ((objProductOld.Param11_T2Neg === null) && (objProductNew.flt_IndL2T2Neg !== null)) {
                        objIndividualL2.IndividualL2.T2Neg.oldValue = "NA";
                        objIndividualL2.IndividualL2.T2Neg.newValue = objProductNew.flt_IndL2T2Neg;
                        IsChanged = true;

                    } else if ((objProductOld.Param11_T2Neg !== null) && (objProductNew.flt_IndL2T2Neg === null)) {
                        objIndividualL2.IndividualL2.T2Neg.oldValue = parseFloat(objProductOld.Param11_T2Neg).toFixed(objProductOld.Param11_DP);
                        objIndividualL2.IndividualL2.T2Neg.newValue = "NA";
                        IsChanged = true;
                    }
                }
            }
            
            /**
            * For Individual PosT2
            */
            if (OldEmpty == true) {
                if (objProductNew.flt_IndL2T2Pos != "" && objProductNew.flt_IndL2T2Pos != undefined) {
                    objIndividualL2.IndividualL2.T2Pos.oldValue = "NA";
                    objIndividualL2.IndividualL2.T2Pos.newValue = objProductNew.flt_IndL2T2Pos;
                    IsChanged = true;
                }
                else {
                    objIndividualL2.IndividualL2.T2Pos.oldValue = false;
                    objIndividualL2.IndividualL2.T2Pos.newValue = false;
                    IsChanged = false;
                }
            }
            else {
                if (objProductOld.Param11_T2Pos === "" ||
                    objProductOld.Param11_T2Pos == this.strNullValue ||
                    objProductOld.Param11_T2Pos == undefined) {
                    objProductOld.Param11_T2Pos = null;
                }

                if (objProductNew.flt_IndL2T2Pos === "" ||
                    objProductNew.flt_IndL2T2Pos == this.strNullValue ||
                    objProductNew.flt_IndL2T2Pos == undefined) {
                    objProductNew.flt_IndL2T2Pos = null;
                }

                if ((objProductOld.Param11_T2Pos !== null) && (objProductNew.flt_IndL2T2Pos !== null)) {
                    if (parseFloat(objProductOld.Param11_T2Pos).toFixed(objProductOld.Param11_DP) == parseFloat(objProductNew.flt_IndL2T2Pos).toFixed(objProductNew.int_IndL2Dp)) {
                        objIndividualL2.IndividualL2.T2Pos.oldValue = false;
                        objIndividualL2.IndividualL2.T2Pos.newValue = false;
                        IsChanged != true ? IsChanged = false : IsChanged = true;
                    }
                    else {
                        objIndividualL2.IndividualL2.T2Pos.oldValue = parseFloat(objProductOld.Param11_T2Pos).toFixed(objProductOld.Param11_DP);
                        objIndividualL2.IndividualL2.T2Pos.newValue = objProductNew.flt_IndL2T2Pos;
                        IsChanged = true;
                    }

                } else {

                    if ((objProductOld.Param11_T2Pos === null) && (objProductNew.flt_IndL2T2Pos !== null)) {
                        objIndividualL2.IndividualL2.T2Pos.oldValue = "NA";
                        objIndividualL2.IndividualL2.T2Pos.newValue = objProductNew.flt_IndL2T2Pos;
                        IsChanged = true;

                    } else if ((objProductOld.Param11_T2Pos !== null) && (objProductNew.flt_IndL2T2Pos === null)) {
                        objIndividualL2.IndividualL2.T2Pos.oldValue = parseFloat(objProductOld.Param11_T2Pos).toFixed(objProductOld.Param11_DP);
                        objIndividualL2.IndividualL2.T2Pos.newValue = "NA";
                        IsChanged = true;
                    }
                }
            }
            
            /**
            * For Individual NMT
            */
            if (OldEmpty == true) {
                if (objProductNew.int_IndL2NMTTabCount != "" && objProductNew.int_IndL2NMTTabCount != undefined) {
                    objIndividualL2.IndividualL2.NMT.oldValue = "NA";
                    objIndividualL2.IndividualL2.NMT.newValue = objProductNew.int_IndL2NMTTabCount;
                    IsChanged = true;
                }
                else {
                    objIndividualL2.IndividualL2.NMT.oldValue = false;
                    objIndividualL2.IndividualL2.NMT.newValue = false;
                    IsChanged = false;
                }
            }
            else {
                if (objProductOld.Param11_NMTTab == 0 ||
                    objProductOld.Param11_NMTTab == this.NMTValue ||
                    objProductOld.Param11_NMTTab == undefined) {
                    objProductOld.Param11_NMTTab = 0;
                }

                objProductNew.int_IndL2NMTTabCount = objProductNew.int_IndL2NMTTabCount === "" ? this.strNullValue : objProductNew.int_IndL2NMTTabCount;

                if (objProductNew.int_IndL2NMTTabCount == "0" ||
                    objProductNew.int_IndL2NMTTabCount == this.NMTValue ||
                    objProductNew.int_IndL2NMTTabCount == undefined) {
                    objProductNew.int_IndL2NMTTabCount = 0;
                }

                if (parseInt(objProductOld.Param11_NMTTab) == parseInt(objProductNew.int_IndL2NMTTabCount)) {
                    objIndividualL2.IndividualL2.NMT.oldValue = false;
                    objIndividualL2.IndividualL2.NMT.newValue = false;
                    IsChanged != true ? IsChanged = false : IsChanged = true;
                }
                else {
                    objIndividualL2.IndividualL2.NMT.oldValue = objProductOld.Param11_NMTTab;
                    objIndividualL2.IndividualL2.NMT.newValue = objProductNew.int_IndL2NMTTabCount;
                    IsChanged = true;
                }
            }

            /**
             * For Individual Limits On Actual / Percent
             */
            if (OldEmpty == true) {
                if (objProductNew.str_IndL2LimitOn != "" && objProductNew.flt_IndL2Std != "" && objProductNew.flt_IndL2Std != undefined && objProductNew.str_IndL2LimitOn != undefined) {
                    objIndividualL2.IndividualL2.LimitOn.oldValue = "NA";
                    objIndividualL2.IndividualL2.LimitOn.newValue = objProductNew.str_IndL2LimitOn;
                    IsChanged = true;
                }
                else {
                    objIndividualL2.IndividualL2.LimitOn.oldValue = false;
                    objIndividualL2.IndividualL2.LimitOn.newValue = false;
                    IsChanged = false;
                }
            }
            else {
                const strLimitOn = objProductOld.Param11_LimitOn == 0 ? "Actual" : "Percentage";
                if (objProductOld.Param11_Nom == null && objProductNew.flt_IndL2Std != null) { // new parameter added
                    objIndividualL2.IndividualL2.LimitOn.oldValue = "NA";
                    objIndividualL2.IndividualL2.LimitOn.newValue = objProductNew.str_IndL2LimitOn;
                    IsChanged = true;
                }
                else if (objProductOld.Param11_Nom == null && objProductNew.flt_IndL2Std == null) // no parameter added
                {
                    objIndividualL2.IndividualL2.LimitOn.oldValue = false;
                    objIndividualL2.IndividualL2.LimitOn.newValue = false;
                    IsChanged = false;
                }
                else {
                    if (strLimitOn == objProductNew.str_IndL2LimitOn) {
                        objIndividualL2.IndividualL2.LimitOn.oldValue = false;
                        objIndividualL2.IndividualL2.LimitOn.newValue = false;
                        IsChanged != true ? IsChanged = false : IsChanged = true;
                    }
                    else {
                        objIndividualL2.IndividualL2.LimitOn.oldValue = strLimitOn;
                        objIndividualL2.IndividualL2.LimitOn.newValue = objProductNew.str_IndL2LimitOn;
                        IsChanged = true;
                    }
                }
            }

            /**
             * For Individual Limits On Standard / Avg
             */
            if (OldEmpty == true) {
                if (objProductNew.str_IndL2GraphOn != "" && objProductNew.flt_IndL2Std != "" && objProductNew.str_IndL2GraphOn != undefined && objProductNew.flt_IndL2Std != undefined) {
                    objIndividualL2.IndividualL2.ReportOn.oldValue = "NA";
                    objIndividualL2.IndividualL2.ReportOn.newValue = objProductNew.str_IndL2GraphOn;
                    IsChanged = true;
                }
                else {
                    objIndividualL2.IndividualL2.ReportOn.oldValue = false;
                    objIndividualL2.IndividualL2.ReportOn.newValue = false;
                    IsChanged = false;
                }
            }
            else {
                const strGraphOn = objProductOld.Param11_IsOnStd == 0 ? "Standard" : "Average";
                if (objProductOld.Param11_Nom == null && objProductNew.flt_IndL2Std != null) { // new parameter added
                    objIndividualL2.IndividualL2.ReportOn.oldValue = "NA";
                    objIndividualL2.IndividualL2.ReportOn.newValue = objProductNew.str_IndL2GraphOn;
                    IsChanged = true;
                }
                else if (objProductOld.Param11_Nom == null && objProductNew.flt_IndL2Std == null) // no parameter added
                {
                    objIndividualL2.IndividualL2.ReportOn.oldValue = false;
                    objIndividualL2.IndividualL2.ReportOn.newValue = false;
                    IsChanged = false;
                }
                else {
                    if (strGraphOn == objProductNew.str_IndL2GraphOn) {
                        objIndividualL2.IndividualL2.ReportOn.oldValue = false;
                        objIndividualL2.IndividualL2.ReportOn.newValue = false;
                        IsChanged != true ? IsChanged = false : IsChanged = true;
                    }
                    else {
                        objIndividualL2.IndividualL2.ReportOn.oldValue = strGraphOn;
                        objIndividualL2.IndividualL2.ReportOn.newValue = objProductNew.str_IndL2GraphOn;
                        IsChanged = true;
                    }
                }
            }

            /** Nominal Nomenclature */
            if (OldEmpty) {
                if (objProductNew.str_indL2_nomNomnclature != "" && objProductNew.flt_IndL2Std != "" && objProductNew.str_indL2_nomNomnclature != undefined && objProductNew.flt_IndL2Std != undefined) {
                    objIndividualL2.IndividualL2.Nomenclature.oldValue = "NA";
                    objIndividualL2.IndividualL2.Nomenclature.newValue = objProductNew.str_indL2_nomNomnclature;
                    IsChanged = true;
                }
                else {
                    objIndividualL2.IndividualL2.Nomenclature.oldValue = false;
                    objIndividualL2.IndividualL2.Nomenclature.newValue = false;
                    IsChanged = IsChanged != true ? false : true;
                }
            }
            else {

                if (objProductOld.Param11_Nom == null && objProductNew.flt_IndL2Std != null) { // new parameter added
                    objIndividualL2.IndividualL2.Nomenclature.oldValue = "NA";
                    objIndividualL2.IndividualL2.Nomenclature.newValue = objProductNew.str_indL2_nomNomnclature;
                    IsChanged = true;
                }
                else if (objProductOld.Param11_Nom == null && objProductNew.flt_IndL2Std == null) // no parameter added
                {
                    objIndividualL2.IndividualL2.Nomenclature.oldValue = false;
                    objIndividualL2.IndividualL2.Nomenclature.newValue = false;
                    IsChanged = false;
                }
                else {
                    if (objProductOld.Param11_Nomenclature == objProductNew.str_indL2_nomNomnclature) {
                        objIndividualL2.IndividualL2.Nomenclature.oldValue = false;
                        objIndividualL2.IndividualL2.Nomenclature.newValue = false;
                        IsChanged != true ? IsChanged = false : IsChanged = true;
                    }
                    else {
                        objIndividualL2.IndividualL2.Nomenclature.oldValue = objProductOld.Param11_Nomenclature;
                        objIndividualL2.IndividualL2.Nomenclature.newValue = objProductNew.str_indL2_nomNomnclature;
                        IsChanged = true;
                    }
                }
            }

            if (IsChanged == true) {
                Object.assign(this.objResult, objIndividualL2);
            }
            resolve(IsChanged);
        });
    }

    validateGrpLayer2(objProductOld, objProductNew) {
        return new Promise((resolve, reject) => {
            const objGroupL2 = {
                GroupL2: {
                    Nom: { oldValue: "", newValue: "" },
                    T1Neg: { oldValue: "", newValue: "" },
                    T1Pos: { oldValue: "", newValue: "" },
                    T2Neg: { oldValue: "", newValue: "" },
                    T2Pos: { oldValue: "", newValue: "" },
                    NMT: { oldValue: "", newValue: "" },
                    LimitOn: { oldValue: "", newValue: "" },
                    ReportOn: { oldValue: "", newValue: "" }
                }
            };

            var IsChanged = false;
            var OldEmpty = objProductOld == undefined ? true : false;
            /**
             * For Individual Nom
             */
            if (OldEmpty == true) {
                if (objProductNew.flt_GrpL2Std != "" && objProductNew.flt_GrpL2Std != undefined) {
                    objGroupL2.GroupL2.Nom.oldValue = "NA";
                    objGroupL2.GroupL2.Nom.newValue = objProductNew.flt_GrpL2Std;
                    IsChanged = true;
                }
                else {
                    objGroupL2.GroupL2.Nom.oldValue = false;
                    objGroupL2.GroupL2.Nom.newValue = false;
                    IsChanged = false;
                }
            }
            else {
                if (objProductOld.Param12_Nom === "" ||
                    objProductOld.Param12_Nom == this.strNullValue ||
                    objProductOld.Param12_Nom == undefined) {
                    objProductOld.Param12_Nom = null;
                }

                if (objProductNew.flt_GrpL2Std === "" ||
                    objProductNew.flt_GrpL2Std == this.strNullValue ||
                    objProductNew.flt_GrpL2Std == undefined) {
                    objProductNew.flt_GrpL2Std = null;
                }

                if ((objProductOld.Param12_Nom !== null) && (objProductNew.flt_GrpL2Std !== null)) {
                    if (parseFloat(objProductOld.Param12_Nom).toFixed(objProductOld.Param12_DP) == parseFloat(objProductNew.flt_GrpL2Std).toFixed(objProductNew.int_GrpL2Dp)) {
                        objGroupL2.GroupL2.Nom.oldValue = false;
                        objGroupL2.GroupL2.Nom.newValue = false;
                        IsChanged = false;
                    }
                    else {
                        objGroupL2.GroupL2.Nom.oldValue = parseFloat(objProductOld.Param12_Nom).toFixed(objProductOld.Param12_DP);
                        objGroupL2.GroupL2.Nom.newValue = objProductNew.flt_GrpL2Std;
                        IsChanged = true;
                    }

                } else {

                    if ((objProductOld.Param12_Nom === null) && (objProductNew.flt_GrpL2Std !== null)) {
                        objGroupL2.GroupL2.Nom.oldValue = "NA";
                        objGroupL2.GroupL2.Nom.newValue = objProductNew.flt_GrpL2Std;
                        IsChanged = true;

                    } else if ((objProductOld.Param12_Nom !== null) && (objProductNew.flt_GrpL2Std === null)) {
                        objGroupL2.GroupL2.Nom.oldValue = parseFloat(objProductOld.Param12_Nom).toFixed(objProductOld.Param12_DP);
                        objGroupL2.GroupL2.Nom.newValue = "NA";
                        IsChanged = true;
                    }
                }
            }
            
            /**
             * For Individual NegT1
             */
            if (OldEmpty == true) {
                if (objProductNew.flt_GrpL2T1Neg != "" && objProductNew.flt_GrpL2T1Neg != undefined) {
                    objGroupL2.GroupL2.T1Neg.oldValue = "NA";
                    objGroupL2.GroupL2.T1Neg.newValue = objProductNew.flt_GrpL2T1Neg;
                    IsChanged = true;
                }
                else {
                    objGroupL2.GroupL2.T1Neg.oldValue = false;
                    objGroupL2.GroupL2.T1Neg.newValue = false;
                    IsChanged = false;
                }
            }
            else {
                if (objProductOld.Param12_T1Neg === "" ||
                    objProductOld.Param12_T1Neg == this.strNullValue ||
                    objProductOld.Param12_T1Neg == undefined) {
                    objProductOld.Param12_T1Neg = null;
                }

                if (objProductNew.flt_GrpL2T1Neg === "" ||
                    objProductNew.flt_GrpL2T1Neg == this.strNullValue ||
                    objProductNew.flt_GrpL2T1Neg == undefined) {
                    objProductNew.flt_GrpL2T1Neg = null;
                }

                if ((objProductOld.Param12_T1Neg !== null) && (objProductNew.flt_GrpL2T1Neg !== null)) {
                    if (parseFloat(objProductOld.Param12_T1Neg).toFixed(objProductOld.Param12_DP) == parseFloat(objProductNew.flt_GrpL2T1Neg).toFixed(objProductNew.int_GrpL2Dp)) {
                        objGroupL2.GroupL2.T1Neg.oldValue = false;
                        objGroupL2.GroupL2.T1Neg.newValue = false;
                        IsChanged != true ? IsChanged = false : IsChanged = true;
                    }
                    else {
                        objGroupL2.GroupL2.T1Neg.oldValue = parseFloat(objProductOld.Param12_T1Neg).toFixed(objProductOld.Param12_DP);
                        objGroupL2.GroupL2.T1Neg.newValue = objProductNew.flt_GrpL2T1Neg;
                        IsChanged = true;
                    }

                } else {

                    if ((objProductOld.Param12_T1Neg === null) && (objProductNew.flt_GrpL2T1Neg !== null)) {
                        objGroupL2.GroupL2.T1Neg.oldValue = "NA";
                        objGroupL2.GroupL2.T1Neg.newValue = objProductNew.flt_GrpL2T1Neg;
                        IsChanged = true;

                    } else if ((objProductOld.Param12_T1Neg !== null) && (objProductNew.flt_GrpL2T1Neg === null)) {
                        objGroupL2.GroupL2.T1Neg.oldValue = parseFloat(objProductOld.Param12_T1Neg).toFixed(objProductOld.Param12_DP);
                        objGroupL2.GroupL2.T1Neg.newValue = "NA";
                        IsChanged = true;
                    }
                }
            }
            
            /**
             * For Individual PosT1
             */
            if (OldEmpty == true) {
                if (objProductNew.flt_GrpL2T1Pos != "" && objProductNew.flt_GrpL2T1Pos != undefined) {
                    objGroupL2.GroupL2.T1Pos.oldValue = "NA";
                    objGroupL2.GroupL2.T1Pos.newValue = objProductNew.flt_GrpL2T1Pos;
                    IsChanged = true;
                }
                else {
                    objGroupL2.GroupL2.T1Pos.oldValue = false;
                    objGroupL2.GroupL2.T1Pos.newValue = false;
                    IsChanged = false;
                }
            }
            else {
                if (objProductOld.Param12_T1Pos === "" ||
                    objProductOld.Param12_T1Pos == this.strNullValue ||
                    objProductOld.Param12_T1Pos == undefined) {
                    objProductOld.Param12_T1Pos = null;
                }

                if (objProductNew.flt_GrpL2T1Pos === "" ||
                    objProductNew.flt_GrpL2T1Pos == this.strNullValue ||
                    objProductNew.flt_GrpL2T1Pos == undefined) {
                    objProductNew.flt_GrpL2T1Pos = null;
                }

                if ((objProductOld.Param12_T1Pos !== null) && (objProductNew.flt_GrpL2T1Pos !== null)) {
                    if (parseFloat(objProductOld.Param12_T1Pos).toFixed(objProductOld.Param12_DP) == parseFloat(objProductNew.flt_GrpL2T1Pos).toFixed(objProductNew.int_GrpL2Dp)) {
                        objGroupL2.GroupL2.T1Pos.oldValue = false;
                        objGroupL2.GroupL2.T1Pos.newValue = false;
                        IsChanged != true ? IsChanged = false : IsChanged = true;
                    }
                    else {
                        objGroupL2.GroupL2.T1Pos.oldValue = parseFloat(objProductOld.Param12_T1Pos).toFixed(objProductOld.Param12_DP);
                        objGroupL2.GroupL2.T1Pos.newValue = objProductNew.flt_GrpL2T1Pos;
                        IsChanged = true;
                    }

                } else {

                    if ((objProductOld.Param12_T1Pos === null) && (objProductNew.flt_GrpL2T1Pos !== null)) {
                        objGroupL2.GroupL2.T1Pos.oldValue = "NA";
                        objGroupL2.GroupL2.T1Pos.newValue = objProductNew.flt_GrpL2T1Pos;
                        IsChanged = true;

                    } else if ((objProductOld.Param12_T1Pos !== null) && (objProductNew.flt_GrpL2T1Pos === null)) {
                        objGroupL2.GroupL2.T1Pos.oldValue = parseFloat(objProductOld.Param12_T1Pos).toFixed(objProductOld.Param12_DP);
                        objGroupL2.GroupL2.T1Pos.newValue = "NA";
                        IsChanged = true;
                    }
                }
            }
            
            /**
            * For Individual NegT2
            */
            if (OldEmpty == true) {
                if (objProductNew.flt_GrpL2T2Neg != "" && objProductNew.flt_GrpL2T2Neg != undefined) {
                    objGroupL2.GroupL2.T2Neg.oldValue = "NA";
                    objGroupL2.GroupL2.T2Neg.newValue = objProductNew.flt_GrpL2T2Neg;
                    IsChanged = true;
                }
                else {
                    objGroupL2.GroupL2.T2Neg.oldValue = false;
                    objGroupL2.GroupL2.T2Neg.newValue = false;
                    IsChanged = false;
                }
            }
            else {
                if (objProductOld.Param12_T2Neg === "" ||
                    objProductOld.Param12_T2Neg == this.strNullValue ||
                    objProductOld.Param12_T2Neg == undefined) {
                    objProductOld.Param12_T2Neg = null;
                }

                if (objProductNew.flt_GrpL2T2Neg === "" ||
                    objProductNew.flt_GrpL2T2Neg == this.strNullValue ||
                    objProductNew.flt_GrpL2T2Neg == undefined) {
                    objProductNew.flt_GrpL2T2Neg = null;
                }

                if ((objProductOld.Param12_T2Neg !== null) && (objProductNew.flt_GrpL2T2Neg !== null)) {
                    if (parseFloat(objProductOld.Param12_T2Neg).toFixed(objProductOld.Param12_DP) == parseFloat(objProductNew.flt_GrpL2T2Neg).toFixed(objProductNew.int_GrpL2Dp)) {
                        objGroupL2.GroupL2.T2Neg.oldValue = false;
                        objGroupL2.GroupL2.T2Neg.newValue = false;
                        IsChanged != true ? IsChanged = false : IsChanged = true;
                    }
                    else {
                        objGroupL2.GroupL2.T2Neg.oldValue = parseFloat(objProductOld.Param12_T2Neg).toFixed(objProductOld.Param12_DP);
                        objGroupL2.GroupL2.T2Neg.newValue = objProductNew.flt_GrpL2T2Neg;
                        IsChanged = true;
                    }

                } else {

                    if ((objProductOld.Param12_T2Neg === null) && (objProductNew.flt_GrpL2T2Neg !== null)) {
                        objGroupL2.GroupL2.T2Neg.oldValue = "NA";
                        objGroupL2.GroupL2.T2Neg.newValue = objProductNew.flt_GrpL2T2Neg;
                        IsChanged = true;

                    } else if ((objProductOld.Param12_T2Neg !== null) && (objProductNew.flt_GrpL2T2Neg === null)) {
                        objGroupL2.GroupL2.T2Neg.oldValue = parseFloat(objProductOld.Param12_T2Neg).toFixed(objProductOld.Param12_DP);
                        objGroupL2.GroupL2.T2Neg.newValue = "NA";
                        IsChanged = true;
                    }
                }
            }
            
            /**
            * For Individual PosT2
            */
            if (OldEmpty == true) {
                if (objProductNew.flt_GrpL2T2Pos != "" && objProductNew.flt_GrpL2T2Pos != undefined) {
                    objGroupL2.GroupL2.T2Pos.oldValue = "NA";
                    objGroupL2.GroupL2.T2Pos.newValue = objProductNew.flt_GrpL2T2Pos;
                    IsChanged = true;
                }
                else {
                    objGroupL2.GroupL2.T2Pos.oldValue = false;
                    objGroupL2.GroupL2.T2Pos.newValue = false;
                    IsChanged = false;
                }
            }
            else {
                if (objProductOld.Param12_T2Pos === "" ||
                    objProductOld.Param12_T2Pos == this.strNullValue ||
                    objProductOld.Param12_T2Pos == undefined) {
                    objProductOld.Param12_T2Pos = null;
                }

                if (objProductNew.flt_GrpL2T2Pos === "" ||
                    objProductNew.flt_GrpL2T2Pos == this.strNullValue ||
                    objProductNew.flt_GrpL2T2Pos == undefined) {
                    objProductNew.flt_GrpL2T2Pos = null;
                }

                if ((objProductOld.Param12_T2Pos !== null) && (objProductNew.flt_GrpL2T2Pos !== null)) {
                    if (parseFloat(objProductOld.Param12_T2Pos).toFixed(objProductOld.Param12_DP) == parseFloat(objProductNew.flt_GrpL2T2Pos).toFixed(objProductNew.int_GrpL2Dp)) {
                        objGroupL2.GroupL2.T2Pos.oldValue = false;
                        objGroupL2.GroupL2.T2Pos.newValue = false;
                        IsChanged != true ? IsChanged = false : IsChanged = true;
                    }
                    else {
                        objGroupL2.GroupL2.T2Pos.oldValue = parseFloat(objProductOld.Param12_T2Pos).toFixed(objProductOld.Param12_DP);
                        objGroupL2.GroupL2.T2Pos.newValue = objProductNew.flt_GrpL2T2Pos;
                        IsChanged = true;
                    }

                } else {

                    if ((objProductOld.Param12_T2Pos === null) && (objProductNew.flt_GrpL2T2Pos !== null)) {
                        objGroupL2.GroupL2.T2Pos.oldValue = "NA";
                        objGroupL2.GroupL2.T2Pos.newValue = objProductNew.flt_GrpL2T2Pos;
                        IsChanged = true;

                    } else if ((objProductOld.Param12_T2Pos !== null) && (objProductNew.flt_GrpL2T2Pos === null)) {
                        objGroupL2.GroupL2.T2Pos.oldValue = parseFloat(objProductOld.Param12_T2Pos).toFixed(objProductOld.Param12_DP);
                        objGroupL2.GroupL2.T2Pos.newValue = "NA";
                        IsChanged = true;
                    }
                }
            }
            
            /**
            * For Individual NMT
            */
            if (OldEmpty == true) {
                if (objProductNew.int_GrpL2NMTTabCount != "" && objProductNew.int_GrpL2NMTTabCount != undefined) {
                    objGroupL2.GroupL2.NMT.oldValue = "NA";
                    objGroupL2.GroupL2.NMT.newValue = objProductNew.int_GrpL2NMTTabCount;
                    IsChanged = true;
                }
                else {
                    objGroupL2.GroupL2.NMT.oldValue = false;
                    objGroupL2.GroupL2.NMT.newValue = false;
                    IsChanged = false;
                }
            }
            else {
                if (objProductOld.Param12_NMTTab == 0 ||
                    objProductOld.Param12_NMTTab == this.NMTValue ||
                    objProductOld.Param12_NMTTab == undefined) {
                    objProductOld.Param12_NMTTab = 0;
                }

                objProductNew.int_GrpL2NMTTabCount = objProductNew.int_GrpL2NMTTabCount === "" ? this.strNullValue : objProductNew.int_GrpL2NMTTabCount;
                
                if (objProductNew.int_GrpL2NMTTabCount == "0" ||
                    objProductNew.int_GrpL2NMTTabCount == this.NMTValue ||
                    objProductNew.int_GrpL2NMTTabCount == undefined) {
                    objProductNew.int_GrpL2NMTTabCount = 0;
                }

                if (parseInt(objProductOld.Param12_NMTTab) == parseInt(objProductNew.int_GrpL2NMTTabCount)) {
                    objGroupL2.GroupL2.NMT.oldValue = false;
                    objGroupL2.GroupL2.NMT.newValue = false;
                    IsChanged != true ? IsChanged = false : IsChanged = true;
                }
                else {
                    objGroupL2.GroupL2.NMT.oldValue = objProductOld.Param12_NMTTab;
                    objGroupL2.GroupL2.NMT.newValue = objProductNew.int_GrpL2NMTTabCount;
                    IsChanged = true;
                }
            }
            
            /**
             * For Individual Limits On Actual / Percent
             */
            if (OldEmpty == true) {
                if (objProductNew.str_GrpL2LimitOn != "" && objProductNew.flt_GrpL2Std != "" && objProductNew.str_GrpL2LimitOn != undefined && objProductNew.flt_GrpL2Std != undefined) {
                    objGroupL2.GroupL2.LimitOn.oldValue = "NA";
                    objGroupL2.GroupL2.LimitOn.newValue = objProductNew.str_GrpL2LimitOn;
                    IsChanged = true;
                }
                else {
                    objGroupL2.GroupL2.LimitOn.oldValue = false;
                    objGroupL2.GroupL2.LimitOn.newValue = false;
                    IsChanged = false;
                }
            }
            else {
                const strLimitOn = objProductOld.Param12_LimitOn == 0 ? "Actual" : "Percentage";
                if (objProductOld.Param12_Nom == null && objProductNew.flt_GrpL2Std != null) { // new parameter added
                    objGroupL2.GroupL2.LimitOn.oldValue = "NA";
                    objGroupL2.GroupL2.LimitOn.newValue = objProductNew.str_GrpL2LimitOn;
                    IsChanged = true;
                }
                else if (objProductOld.Param12_Nom == null && objProductNew.flt_GrpL2Std == null) // no parameter added
                {
                    objGroupL2.GroupL2.LimitOn.oldValue = false;
                    objGroupL2.GroupL2.LimitOn.newValue = false;
                    IsChanged = false;
                }
                else {
                    if (strLimitOn == objProductNew.str_GrpL2LimitOn) {
                        objGroupL2.GroupL2.LimitOn.oldValue = false;
                        objGroupL2.GroupL2.LimitOn.newValue = false;
                        IsChanged != true ? IsChanged = false : IsChanged = true;
                    }
                    else {
                        objGroupL2.GroupL2.LimitOn.oldValue = strLimitOn;
                        objGroupL2.GroupL2.LimitOn.newValue = objProductNew.str_GrpL2LimitOn;
                        IsChanged = true;
                    }
                }
            }

            /**
             * For Individual Limits On Standard / Avg
             */
            if (OldEmpty == true) {
                if (objProductNew.str_GrpL2GraphOn != "" && objProductNew.flt_GrpL2Std != "" && objProductNew.str_GrpL2GraphOn != undefined && objProductNew.flt_GrpL2Std != undefined) {
                    objGroupL2.GroupL2.ReportOn.oldValue = "NA";
                    objGroupL2.GroupL2.ReportOn.newValue = objProductNew.str_GrpL2GraphOn;
                    IsChanged = true;
                }
                else {
                    objGroupL2.GroupL2.ReportOn.oldValue = false;
                    objGroupL2.GroupL2.ReportOn.newValue = false;
                    IsChanged = false;
                }
            }
            else {
                const strGraphOn = objProductOld.Param12_IsOnStd == 0 ? "Standard" : "Average";
                if (objProductOld.Param12_Nom == null && objProductNew.flt_GrpL2Std != null) { // new parameter added
                    objGroupL2.GroupL2.ReportOn.oldValue = "NA";
                    objGroupL2.GroupL2.ReportOn.newValue = objProductNew.str_GrpL2GraphOn;
                    IsChanged = true;
                }
                else if (objProductOld.Param12_Nom == null && objProductNew.flt_GrpL2Std == null) // no parameter added
                {
                    objGroupL2.GroupL2.ReportOn.oldValue = false;
                    objGroupL2.GroupL2.ReportOn.newValue = false;
                    IsChanged = false;
                }
                else {
                    if (strGraphOn == objProductNew.str_GrpL2GraphOn) {
                        objGroupL2.GroupL2.ReportOn.oldValue = false;
                        objGroupL2.GroupL2.ReportOn.newValue = false;
                        IsChanged != true ? IsChanged = false : IsChanged = true;
                    }
                    else {
                        objGroupL2.GroupL2.ReportOn.oldValue = strGraphOn;
                        objGroupL2.GroupL2.ReportOn.newValue = objProductNew.str_GrpL2GraphOn;
                        IsChanged = true;
                    }
                }
            }

            if (IsChanged == true) {
                Object.assign(this.objResult, objGroupL2);
            }
            resolve(IsChanged);
        });
    }

    validateDT(objProductOld, objProductNew) {
        return new Promise((resolve, reject) => {
            const objDT = {
                DT: {
                    DTTime: { oldValue: "", newValue: "" },
                    DTMinTemp: { oldValue: "", newValue: "" },
                    DTMaxTemp: { oldValue: "", newValue: "" }
                }
            };

            var IsChanged = false;
            var OldEmpty = objProductOld == undefined ? true : false;
            /**
             * For Individual Nom
             */
            if (OldEmpty == true) {
                if (objProductNew.int_DTMMTime != "" && objProductNew.int_DTMMTime != undefined) {
                    objDT.DT.DTTime.oldValue = "NA";
                    objDT.DT.DTTime.newValue = objProductNew.int_DTHHTime + ":" + objProductNew.int_DTMMTime + ":" + objProductNew.int_DTSSTime;
                    IsChanged = true;
                }
                else {
                    objDT.DT.DTTime.oldValue = false;
                    objDT.DT.DTTime.newValue = false;
                    IsChanged = false;
                }
            }
            else {
                if (objProductOld.Param13_Nom === "" ||
                    objProductOld.Param13_Nom == this.strNullValue ||
                    objProductOld.Param13_Nom == undefined) {
                    objProductOld.Param13_Nom = null;
                }

                if (objProductNew.int_DTHHTime === "" ||
                    objProductNew.int_DTHHTime == this.strNullValue ||
                    objProductNew.int_DTHHTime == undefined) {
                    objProductNew.int_DTHHTime = null;
                }

                if (objProductNew.int_DTMMTime === "" ||
                    objProductNew.int_DTMMTime == this.strNullValue ||
                    objProductNew.int_DTMMTime == undefined) {
                    objProductNew.int_DTMMTime = null;
                }

                if (objProductNew.int_DTSSTime === "" ||
                    objProductNew.int_DTSSTime == this.strNullValue ||
                    objProductNew.int_DTSSTime == undefined) {
                    objProductNew.int_DTSSTime = null;
                }

                if ((objProductOld.Param13_Nom === null) && (objProductNew.int_DTHHTime === null) && 
                    (objProductNew.int_DTMMTime === null) && (objProductNew.int_DTSSTime === null)) {
                        objDT.DT.DTTime.oldValue = false;
                        objDT.DT.DTTime.newValue = false;
                        IsChanged = false;
                }
                else if (objProductOld.Param13_Nom == (objProductNew.int_DTHHTime + ":" + objProductNew.int_DTMMTime + ":" + objProductNew.int_DTSSTime)) {
                    objDT.DT.DTTime.oldValue = false;
                    objDT.DT.DTTime.newValue = false;
                    IsChanged = false;
                }
                else {
                    objDT.DT.DTTime.oldValue = objProductOld.Param13_Nom;
                    objDT.DT.DTTime.newValue = objProductNew.int_DTHHTime + ":" + objProductNew.int_DTMMTime + ":" + objProductNew.int_DTSSTime;
                    IsChanged = true;
                }
            }

            /**
             * For Individual Nom
             */
            if (OldEmpty == true) {
                if ((objProductNew.flt_DTMinTemp != "") && (objProductNew.flt_DTMinTemp != 99999) && objProductNew.flt_DTMinTemp != undefined) {
                    objDT.DT.DTMinTemp.oldValue = "NA";
                    objDT.DT.DTMinTemp.newValue = objProductNew.flt_DTMinTemp;
                    IsChanged = true;
                }
                else {
                    objDT.DT.DTMinTemp.oldValue = false;
                    objDT.DT.DTMinTemp.newValue = false;
                    IsChanged = false;
                }
            }
            else {
                if (objProductOld.Param13_T1Neg === "" ||
                    objProductOld.Param13_T1Neg == this.strNullValue ||
                    objProductOld.Param13_T1Neg == undefined) {
                    objProductOld.Param13_T1Neg = null;
                }

                if (objProductNew.flt_DTMinTemp === "" ||
                    objProductNew.flt_DTMinTemp == this.strNullValue ||
                    objProductNew.flt_DTMinTemp == undefined) {
                    objProductNew.flt_DTMinTemp = null;
                }

                if ((objProductOld.Param13_T1Neg !== null) && (objProductNew.flt_DTMinTemp !== null)) {
                    if (parseFloat(objProductOld.Param13_T1Neg).toFixed(objProductOld.Param13_DP) == parseFloat(objProductNew.flt_DTMinTemp).toFixed(objProductNew.int_DTDp)) {
                        objDT.DT.DTMinTemp.oldValue = false;
                        objDT.DT.DTMinTemp.newValue = false;
                        IsChanged != true ? IsChanged = false : IsChanged = true;

                    } else {
                        objDT.DT.DTMinTemp.oldValue = parseFloat(objProductOld.Param13_T1Neg).toFixed(objProductOld.Param13_DP);
                        objDT.DT.DTMinTemp.newValue = objProductNew.flt_DTMinTemp;
                        IsChanged = true;
                    }

                } else if((objProductOld.Param13_T1Neg == null) && (objProductNew.flt_DTMinTemp == '99999')) {
                    objDT.DT.DTMinTemp.oldValue = false;
                    objDT.DT.DTMinTemp.newValue = false;
                    IsChanged != true ? IsChanged = false : IsChanged = true;

                } else {

                    if ((objProductOld.Param13_T1Neg === null) && (objProductNew.flt_DTMinTemp !== null)) {
                        objDT.DT.DTMinTemp.oldValue = "NA";
                        objDT.DT.DTMinTemp.newValue = objProductNew.flt_DTMinTemp;
                        IsChanged = true;

                    } else if ((objProductOld.Param13_T1Neg !== null) && (objProductNew.flt_DTMinTemp === null)) {
                        objDT.DT.DTMinTemp.oldValue = parseFloat(objProductOld.Param13_T1Neg).toFixed(objProductOld.Param13_DP);
                        objDT.DT.DTMinTemp.newValue = "NA";
                        IsChanged = true;
                    }
                }
            }

            /**
             * For Individual Nom
             */
            if (OldEmpty == true) {
                if ((objProductNew.flt_DTMaxTemp != "") && (objProductNew.flt_DTMaxTemp != 99999) && objProductNew.flt_DTMaxTemp != undefined) {
                    objDT.DT.DTMaxTemp.oldValue = "NA";
                    objDT.DT.DTMaxTemp.newValue = objProductNew.flt_DTMaxTemp;
                    IsChanged = true;
                }
                else {
                    objDT.DT.DTMaxTemp.oldValue = false;
                    objDT.DT.DTMaxTemp.newValue = false;
                    IsChanged = false;
                }
            }
            else {
                if (objProductOld.Param13_T1Pos === "" ||
                    objProductOld.Param13_T1Pos == this.strNullValue ||
                    objProductOld.Param13_T1Pos == undefined) {
                    objProductOld.Param13_T1Pos = null;
                }

                if (objProductNew.flt_DTMaxTemp === "" ||
                    objProductNew.flt_DTMaxTemp == this.strNullValue ||
                    objProductNew.flt_DTMaxTemp == undefined) {
                    objProductNew.flt_DTMaxTemp = null;
                }

                if ((objProductOld.Param13_T1Pos !== null) && (objProductNew.flt_DTMaxTemp !== null)) {
                    if (parseFloat(objProductOld.Param13_T1Pos).toFixed(objProductOld.Param13_DP) == parseFloat(objProductNew.flt_DTMaxTemp).toFixed(objProductNew.int_DTDp)) {
                        objDT.DT.DTMaxTemp.oldValue = false;
                        objDT.DT.DTMaxTemp.newValue = false;
                        IsChanged != true ? IsChanged = false : IsChanged = true;

                    } else {
                        objDT.DT.DTMaxTemp.oldValue = parseFloat(objProductOld.Param13_T1Pos).toFixed(objProductOld.Param13_DP);
                        objDT.DT.DTMaxTemp.newValue = objProductNew.flt_DTMaxTemp;
                        IsChanged = true;
                    }

                } else if((objProductOld.Param13_T1Pos == null) && (objProductNew.flt_DTMaxTemp == '99999')){
                    objDT.DT.DTMaxTemp.oldValue = false;
                    objDT.DT.DTMaxTemp.newValue = false;
                    IsChanged != true ? IsChanged = false : IsChanged = true;

                } else {

                    if ((objProductOld.Param13_T1Pos === null) && (objProductNew.flt_DTMaxTemp !== null)) {
                        objDT.DT.DTMaxTemp.oldValue = "NA";
                        objDT.DT.DTMaxTemp.newValue = objProductNew.flt_DTMaxTemp;
                        IsChanged = true;

                    } else if ((objProductOld.Param13_T1Pos !== null) && (objProductNew.flt_DTMaxTemp === null)) {
                        objDT.DT.DTMaxTemp.oldValue = parseFloat(objProductOld.Param13_T1Pos).toFixed(objProductOld.Param13_DP);
                        objDT.DT.DTMaxTemp.newValue = "NA";
                        IsChanged = true;
                    }
                }
            }
            
            if (IsChanged == true) {
                Object.assign(this.objResult, objDT);
            }
            resolve(IsChanged);
        });
    }

    validateTD(objProductOld, objProductNew) {
        return new Promise((resolve, reject) => {
            const objTD = {
                TD: {
                    TDMin: { oldValue: "", newValue: "" },
                    TDMax: { oldValue: "", newValue: "" }
                }
            };

            var IsChanged = false;
            var OldEmpty = objProductOld == undefined ? true : false;
            /**
             * For Individual Nom
             */
            if (OldEmpty == true) {
                if (objProductNew.flt_TDT1 != "" && objProductNew.flt_TDT1 != undefined) {
                    objTD.TD.TDMin.oldValue = "NA";
                    objTD.TD.TDMin.newValue = objProductNew.flt_TDT1;
                    IsChanged = true;
                }
                else {
                    objTD.TD.TDMin.oldValue = false;
                    objTD.TD.TDMin.newValue = false;
                    IsChanged = false;
                }
            }
            else {
                if (objProductOld.Param15_T1Neg === "" ||
                    objProductOld.Param15_T1Neg == this.strNullValue ||
                    objProductOld.Param15_T1Neg == undefined) {
                    objProductOld.Param15_T1Neg = null;
                }

                if (objProductNew.flt_TDT1 === "" ||
                    objProductNew.flt_TDT1 == this.strNullValue ||
                    objProductNew.flt_TDT1 == undefined) {
                    objProductNew.flt_TDT1 = null;
                }

                if ((objProductOld.Param15_T1Neg !== null) && (objProductNew.flt_TDT1 !== null)) {
                    if (parseFloat(objProductOld.Param15_T1Neg).toFixed(objProductOld.Param15_DP) == parseFloat(objProductNew.flt_TDT1).toFixed(objProductNew.int_TDDp)) {
                        objTD.TD.TDMin.oldValue = false;
                        objTD.TD.TDMin.newValue = false;
                        IsChanged = false;
                    }
                    else {
                        objTD.TD.TDMin.oldValue = parseFloat(objProductOld.Param15_T1Neg).toFixed(objProductOld.Param15_DP);
                        objTD.TD.TDMin.newValue = objProductNew.flt_TDT1;
                        IsChanged = true;
                    }

                } else {

                    if ((objProductOld.Param15_T1Neg === null) && (objProductNew.flt_TDT1 !== null)) {
                        objTD.TD.TDMin.oldValue = "NA";
                        objTD.TD.TDMin.newValue = objProductNew.flt_TDT1;
                        IsChanged = true;

                    } else if ((objProductOld.Param15_T1Neg !== null) && (objProductNew.flt_TDT1 === null)) {
                        objTD.TD.TDMin.oldValue = parseFloat(objProductOld.Param15_T1Neg).toFixed(objProductOld.Param15_DP);
                        objTD.TD.TDMin.newValue = "NA";
                        IsChanged = true;
                    }
                }
            }

            /**
            * For Individual Nom
            */
            if (OldEmpty == true) {
                if (objProductNew.flt_TDT2 != "" && objProductNew.flt_TDT2 != undefined) {
                    objTD.TD.TDMax.oldValue = "NA";
                    objTD.TD.TDMax.newValue = objProductNew.flt_TDT2;
                    IsChanged = true;
                }
                else {
                    objTD.TD.TDMax.oldValue = false;
                    objTD.TD.TDMax.newValue = false;
                    IsChanged = false;
                }
            }
            else {
                if (objProductOld.Param15_T1Pos === "" ||
                    objProductOld.Param15_T1Pos == this.strNullValue ||
                    objProductOld.Param15_T1Pos == undefined) {
                    objProductOld.Param15_T1Pos = null;
                }

                if (objProductNew.flt_TDT2 === "" ||
                    objProductNew.flt_TDT2 == this.strNullValue ||
                    objProductNew.flt_TDT2 == undefined) {
                    objProductNew.flt_TDT2 = null;
                }

                if ((objProductOld.Param15_T1Pos !== null) && (objProductNew.flt_TDT2 !== null)) {
                    if (parseFloat(objProductOld.Param15_T1Pos).toFixed(objProductOld.Param15_DP) == parseFloat(objProductNew.flt_TDT2).toFixed(objProductNew.int_TDDp)) {
                        objTD.TD.TDMax.oldValue = false;
                        objTD.TD.TDMax.newValue = false;
                        IsChanged != true ? IsChanged = false : IsChanged = true;
                    }
                    else {
                        objTD.TD.TDMax.oldValue = parseFloat(objProductOld.Param15_T1Pos).toFixed(objProductOld.Param15_DP);
                        objTD.TD.TDMax.newValue = objProductNew.flt_TDT2;
                        IsChanged = true;
                    }

                } else {

                    if ((objProductOld.Param15_T1Pos === null) && (objProductNew.flt_TDT2 !== null)) {
                        objTD.TD.TDMax.oldValue = "NA";
                        objTD.TD.TDMax.newValue = objProductNew.flt_TDT2;
                        IsChanged = true;

                    } else if ((objProductOld.Param15_T1Pos !== null) && (objProductNew.flt_TDT2 === null)) {
                        objTD.TD.TDMax.oldValue = parseFloat(objProductOld.Param15_T1Pos).toFixed(objProductOld.Param15_DP);
                        objTD.TD.TDMax.newValue = "NA";
                        IsChanged = true;
                    }
                }
            }
            
            if (IsChanged == true) {
                Object.assign(this.objResult, objTD);
            }
            resolve(IsChanged);
        });
    }

    validateLOD(objProductOld, objProductNew) {
        return new Promise((resolve, reject) => {
            const objLOD = {
                LOD: {
                    'Lower Limit': { oldValue: "", newValue: "" },
                    'Upper Limit': { oldValue: "", newValue: "" },
                    // MIN: { oldValue: "", newValue: "" },
                    // MAX: { oldValue: "", newValue: "" }
                }
            };

            var IsChanged = false;
            var OldEmpty = objProductOld == undefined ? true : false;
            /**
             * For Individual Nom
             */
            if (OldEmpty == true) {
                if (objProductNew.flt_MAT1 != "" && objProductNew.flt_MAT1 != undefined) {
                    objLOD.LOD['Lower Limit'].oldValue = "NA";
                    objLOD.LOD['Lower Limit'].newValue = objProductNew.flt_MAT1;
                    IsChanged = true;
                }
                else {
                    objLOD.LOD['Lower Limit'].oldValue = false;
                    objLOD.LOD['Lower Limit'].newValue = false;
                    IsChanged = false;
                }
            }
            else {
                if (objProductOld.Param16_T1Neg === "" ||
                    objProductOld.Param16_T1Neg == this.strNullValue ||
                    objProductOld.Param16_T1Neg == undefined) {
                    objProductOld.Param16_T1Neg = null;
                }

                if (objProductNew.flt_MAT1 === "" ||
                    objProductNew.flt_MAT1 == this.strNullValue ||
                    objProductNew.flt_MAT1 == undefined) {
                    objProductNew.flt_MAT1 = null;
                }

                if ((objProductOld.Param16_T1Neg !== null) && (objProductNew.flt_MAT1 !== null)) {
                    if (parseFloat(objProductOld.Param16_T1Neg).toFixed(objProductOld.Param16_DP) == parseFloat(objProductNew.flt_MAT1).toFixed(objProductNew.int_MADp)) {
                        objLOD.LOD['Lower Limit'].oldValue = false;
                        objLOD.LOD['Lower Limit'].newValue = false;
                        IsChanged = false;
                    }
                    else {
                        objLOD.LOD['Lower Limit'].oldValue = parseFloat(objProductOld.Param16_T1Neg).toFixed(objProductOld.Param16_DP);
                        objLOD.LOD['Lower Limit'].newValue = objProductNew.flt_MAT1;
                        IsChanged = true;
                    }

                } else {

                    if ((objProductOld.Param16_T1Neg === null) && (objProductNew.flt_MAT1 !== null)) {
                        objLOD.LOD['Lower Limit'].oldValue = "NA";
                        objLOD.LOD['Lower Limit'].newValue = objProductNew.flt_MAT1;
                        IsChanged = true;

                    } else if ((objProductOld.Param16_T1Neg !== null) && (objProductNew.flt_MAT1 === null)) {
                        objLOD.LOD['Lower Limit'].oldValue = parseFloat(objProductOld.Param16_T1Neg).toFixed(objProductOld.Param16_DP);
                        objLOD.LOD['Lower Limit'].newValue = "NA";
                        IsChanged = true;
                    }
                }
            }

            if (OldEmpty == true) {
                if (objProductNew.flt_MAT2 != "" && objProductNew.flt_MAT2 != undefined) {
                    objLOD.LOD['Upper Limit'].oldValue = "NA";
                    objLOD.LOD['Upper Limit'].newValue = objProductNew.flt_MAT2;
                    IsChanged = true;
                }
                else {
                    objLOD.LOD['Upper Limit'].oldValue = false;
                    objLOD.LOD['Upper Limit'].newValue = false;
                    IsChanged = false;
                }
            }
            else {
                if (objProductOld.Param16_T1Pos === "" ||
                    objProductOld.Param16_T1Pos == this.strNullValue ||
                    objProductOld.Param16_T1Pos == undefined) {
                    objProductOld.Param16_T1Pos = null;
                }

                if (objProductNew.flt_MAT2 === "" ||
                    objProductNew.flt_MAT2 == this.strNullValue ||
                    objProductNew.flt_MAT2 == undefined) {
                    objProductNew.flt_MAT2 = null;
                }

                if ((objProductOld.Param16_T1Pos !== null) && (objProductNew.flt_MAT2 !== null)) {
                    if (parseFloat(objProductOld.Param16_T1Pos).toFixed(objProductOld.Param16_DP) == parseFloat(objProductNew.flt_MAT2).toFixed(objProductNew.int_MADp)) {
                        objLOD.LOD['Upper Limit'].oldValue = false;
                        objLOD.LOD['Upper Limit'].newValue = false;
                        IsChanged != true ? IsChanged = false : IsChanged = true;
                    }
                    else {
                        objLOD.LOD['Upper Limit'].oldValue = parseFloat(objProductOld.Param16_T1Pos).toFixed(objProductOld.Param16_DP);
                        objLOD.LOD['Upper Limit'].newValue = objProductNew.flt_MAT2;
                        IsChanged = true;
                    }

                } else {

                    if ((objProductOld.Param16_T1Pos === null) && (objProductNew.flt_MAT2 !== null)) {
                        objLOD.LOD['Upper Limit'].oldValue = "NA";
                        objLOD.LOD['Upper Limit'].newValue = objProductNew.flt_MAT2;
                        IsChanged = true;

                    } else if ((objProductOld.Param16_T1Pos !== null) && (objProductNew.flt_MAT2 === null)) {
                        objLOD.LOD['Upper Limit'].oldValue = parseFloat(objProductOld.Param16_T1Pos).toFixed(objProductOld.Param16_DP);
                        objLOD.LOD['Upper Limit'].newValue = "NA";
                        IsChanged = true;
                    }
                }
            }

            if (IsChanged == true) {
                Object.assign(this.objResult, objLOD);
            }
            resolve(IsChanged);
        });
    }

    validatePerFine(objProductOld, objProductNew) {
        return new Promise((resolve, reject) => {
            const objPerFine = {
                PerFine: {
                    T1: { oldValue: "", newValue: "" },
                    T2: { oldValue: "", newValue: "" }
                }
            };

            var IsChanged = false;
            var OldEmpty = objProductOld == undefined ? true : false;
            /**
             * For Individual Nom
             */
            if (OldEmpty == true) {
                if (objProductNew.flt_SST1 != "" && objProductNew.flt_SST1 != undefined) {
                    objPerFine.PerFine.T1.oldValue = "NA";
                    objPerFine.PerFine.T1.newValue = objProductNew.flt_SST1;
                    IsChanged = true;
                }
                else {
                    objPerFine.PerFine.T1.oldValue = false;
                    objPerFine.PerFine.T1.newValue = false;
                    IsChanged = false;
                }
            }
            else {
                if (objProductOld.Param17_T1Neg === "" ||
                    objProductOld.Param17_T1Neg == this.strNullValue ||
                    objProductOld.Param17_T1Neg == undefined) {
                    objProductOld.Param17_T1Neg = null;
                }

                if (objProductNew.flt_SST1 === "" ||
                    objProductNew.flt_SST1 == this.strNullValue ||
                    objProductNew.flt_SST1 == undefined) {
                    objProductNew.flt_SST1 = null;
                }

                if ((objProductOld.Param17_T1Neg !== null) && (objProductNew.flt_SST1 !== null)) {
                    if (parseFloat(objProductOld.Param17_T1Neg).toFixed(objProductOld.Param17_DP) == parseFloat(objProductNew.flt_SST1).toFixed(objProductNew.int_SSDp)) {
                        objPerFine.PerFine.T1.oldValue = false;
                        objPerFine.PerFine.T1.newValue = false;
                        IsChanged = false;
                    }
                    else {
                        objPerFine.PerFine.T1.oldValue = parseFloat(objProductOld.Param17_T1Neg).toFixed(objProductOld.Param17_DP);
                        objPerFine.PerFine.T1.newValue = objProductNew.flt_SST1;
                        IsChanged = true;
                    }

                } else {

                    if ((objProductOld.Param17_T1Neg === null) && (objProductNew.flt_SST1 !== null)) {
                        objPerFine.PerFine.T1.oldValue = "NA";
                        objPerFine.PerFine.T1.newValue = objProductNew.flt_SST1;
                        IsChanged = true;

                    } else if ((objProductOld.Param17_T1Neg !== null) && (objProductNew.flt_SST1 === null)) {
                        objPerFine.PerFine.T1.oldValue = parseFloat(objProductOld.Param17_T1Neg).toFixed(objProductOld.Param17_DP);
                        objPerFine.PerFine.T1.newValue = "NA";
                        IsChanged = true;
                    }
                }
            }
            
            if (OldEmpty == true) {
                if (objProductNew.flt_SST2 != "" && objProductNew.flt_SST2 != undefined) {
                    objPerFine.PerFine.T2.oldValue = "NA";
                    objPerFine.PerFine.T2.newValue = objProductNew.flt_SST2;
                    IsChanged = true;
                }
                else {
                    objPerFine.PerFine.T2.oldValue = false;
                    objPerFine.PerFine.T2.newValue = false;
                    IsChanged = false;
                }
            }
            else {
                if (objProductOld.Param17_T1Pos === "" ||
                    objProductOld.Param17_T1Pos == this.strNullValue ||
                    objProductOld.Param17_T1Pos == undefined) {
                    objProductOld.Param17_T1Pos = null;
                }

                if (objProductNew.flt_SST2 === "" ||
                    objProductNew.flt_SST2 == this.strNullValue ||
                    objProductNew.flt_SST2 == undefined) {
                    objProductNew.flt_SST2 = null;
                }

                if ((objProductOld.Param17_T1Pos !== null) && (objProductNew.flt_SST2 !== null)) {
                    if (parseFloat(objProductOld.Param17_T1Pos).toFixed(objProductOld.Param17_DP) == parseFloat(objProductNew.flt_SST2).toFixed(objProductNew.int_SSDp)) {
                        objPerFine.PerFine.T2.oldValue = false;
                        objPerFine.PerFine.T2.newValue = false;
                        IsChanged != true ? IsChanged = false : IsChanged = true;
                    }
                    else {
                        objPerFine.PerFine.T2.oldValue = parseFloat(objProductOld.Param17_T1Pos).toFixed(objProductOld.Param17_DP);
                        objPerFine.PerFine.T2.newValue = objProductNew.flt_SST2;
                        IsChanged = true;
                    }
                    
                } else {

                    if ((objProductOld.Param17_T1Pos === null) && (objProductNew.flt_SST2 !== null)) {
                        objPerFine.PerFine.T2.oldValue = "NA";
                        objPerFine.PerFine.T2.newValue = objProductNew.flt_SST2;
                        IsChanged = true;

                    } else if ((objProductOld.Param17_T1Pos !== null) && (objProductNew.flt_SST2 === null)) {
                        objPerFine.PerFine.T2.oldValue = parseFloat(objProductOld.Param17_T1Pos).toFixed(objProductOld.Param17_DP);
                        objPerFine.PerFine.T2.newValue = "NA";
                        IsChanged = true;
                    }
                }
            }

            if (IsChanged == true) {
                Object.assign(this.objResult, objPerFine);
            }
            resolve(IsChanged);
        });
    }

    validateYield(objProductOld, objProductNew) {
        return new Promise((resolve, reject) => {
            const objYield = {
                Yield: {
                    TheroticalYield: { oldValue: "", newValue: "" },
                    YieldNLT: { oldValue: "", newValue: "" },
                    TotalLossNMT: { oldValue: "", newValue: "" },
                }
            };

            var IsChanged = false;
            var OldEmpty = objProductOld == undefined ? true : false;
            /**
             * For Individual Nom
             */
            if (OldEmpty == true) {
                if (objProductNew.TheroticalYield != "" && objProductNew.TheroticalYield != undefined) {
                    objYield.Yield.TheroticalYield.oldValue = "NA";
                    objYield.Yield.TheroticalYield.newValue = objProductNew.TheroticalYield;
                    IsChanged = true;
                }
                else {
                    objYield.Yield.TheroticalYield.oldValue = false;
                    objYield.Yield.TheroticalYield.newValue = false;
                    IsChanged = false;
                }
            }
            else {
                if (objProductOld.TheroticalYield === "" ||
                    objProductOld.TheroticalYield == this.strNullValue ||
                    objProductOld.TheroticalYield == undefined) {
                    objProductOld.TheroticalYield = null;
                }

                if (objProductNew.TheroticalYield === "" ||
                    objProductNew.TheroticalYield == this.strNullValue) {
                    objProductNew.TheroticalYield = null;
                }

                if (parseFloat(objProductOld.TheroticalYield).toFixed(objProductOld.Yield_DP) ==
                    parseFloat(objProductNew.TheroticalYield).toFixed(objProductOld.Yield_DP)) {
                    objYield.Yield.TheroticalYield.oldValue = false;
                    objYield.Yield.TheroticalYield.newValue = false;
                    IsChanged = false;
                }
                else {
                    objYield.Yield.TheroticalYield.oldValue = parseFloat(objProductOld.TheroticalYield).toFixed(objProductOld.Yield_DP);
                    objYield.Yield.TheroticalYield.newValue = objProductNew.TheroticalYield;
                    IsChanged = true;
                }
            }

            if (OldEmpty) {
                if (objProductNew.YieldNLT != "" && objProductNew.YieldNLT != undefined) {
                    objYield.Yield.YieldNLT.oldValue = "NA";
                    objYield.Yield.YieldNLT.newValue = objProductNew.YieldNLT;
                    IsChanged = true;
                }
                else {
                    objYield.Yield.YieldNLT.oldValue = false;
                    objYield.Yield.YieldNLT.newValue = false;
                    IsChanged = IsChanged != true ? false : true;
                }
            }
            else {
                if (objProductOld.YieldNLT === "" ||
                    objProductOld.YieldNLT == this.strNullValue ||
                    objProductOld.YieldNLT == undefined) {
                    objProductOld.YieldNLT = null;
                }

                if (objProductNew.YieldNLT === "" ||
                    objProductNew.YieldNLT == this.strNullValue ||
                    objProductNew.YieldNLT == undefined) {
                    objProductNew.YieldNLT = null;
                }

                if (parseFloat(objProductOld.YieldNLT) ==
                    parseFloat(objProductNew.YieldNLT)) {
                    objYield.Yield.YieldNLT.oldValue = false;
                    objYield.Yield.YieldNLT.T1Neg.newValue = false;
                    IsChanged != true ? IsChanged = false : IsChanged = true;
                }
                else {
                    if (parseFloat(objProductOld.YieldNLT) === "NaN") {
                        objYield.Yield.YieldNLT.oldValue = "NaN";
                    }
                    else {
                        objYield.Yield.YieldNLT.oldValue = parseFloat(objProductOld.YieldNLT);
                    }
                    objYield.Yield.YieldNLT.newValue = objProductNew.YieldNLT;
                    IsChanged = true;
                }
            }

            if (OldEmpty) {
                if (objProductNew.TotalLossNMT != "" && objProductNew.TotalLossNMT != undefined) {
                    objYield.Yield.TotalLossNMT.oldValue = "NA";
                    objYield.Yield.TotalLossNMT.newValue = objProductNew.TotalLossNMT;
                    IsChanged = true;
                }
                else {
                    objYield.Yield.TotalLossNMT.oldValue = false;
                    objYield.Yield.TotalLossNMT.newValue = false;
                    IsChanged = IsChanged != true ? false : true;
                }
            }
            else {
                if (objProductOld.TotalLossNMT === "" ||
                    objProductOld.TotalLossNMT == this.strNullValue ||
                    objProductOld.TotalLossNMT == undefined) {
                    objProductOld.TotalLossNMT = null;
                }

                if (objProductNew.TotalLossNMT === "" ||
                    objProductNew.TotalLossNMT == this.strNullValue ||
                    objProductNew.TotalLossNMT == undefined) {
                    objProductNew.TotalLossNMT = null;
                }

                if (parseFloat(objProductOld.TotalLossNMT) ==
                    parseFloat(objProductNew.TotalLossNMT)) {
                    objYield.Yield.TotalLossNMT.oldValue = false;
                    objYield.Yield.TotalLossNMT.T1Neg.newValue = false;
                    IsChanged != true ? IsChanged = false : IsChanged = true;
                }
                else {
                    if (parseFloat(objProductOld.TotalLossNMT) === "NaN") {
                        objYield.Yield.TotalLossNMT.oldValue = "NaN";
                    }
                    else {
                        objYield.Yield.TotalLossNMT.oldValue = parseFloat(objProductOld.TotalLossNMT);
                    }
                    objYield.Yield.TotalLossNMT.newValue = objProductNew.TotalLossNMT;
                    IsChanged = true;
                }
            }

            if (IsChanged == true) {
                Object.assign(this.objResult, objYield);
            }
            resolve(IsChanged);
        });
    }

    async validateCompressedParams(objProductOld, objProductNew, strProjectName) {
        var Ind = await this.validateIndividual(objProductOld, objProductNew);
        var Grp = await this.validateGroup(objProductOld, objProductNew);
        var Thick = await this.validateThickness(objProductOld, objProductNew);
        var Brd = await this.validateBreadth(objProductOld, objProductNew);
        var Len = await this.validateLength(objProductOld, objProductNew,1);
        var Dia = await this.validateDiameter(objProductOld, objProductNew);
        var Hard = await this.validateHardness(objProductOld, objProductNew);
        var Fri = await this.validateFriability(objProductOld, objProductNew);
        var DT = await this.validateDT(objProductOld, objProductNew);
        var TD = await this.validateTD(objProductOld, objProductNew);
        var PerFine = await this.validatePerFine(objProductOld, objProductNew);
        var LOD = await this.validateLOD(objProductOld, objProductNew);
        var Ind1 = await this.validateIndLayer1(objProductOld, objProductNew);
        var Grp1 = await this.validateGrpLayer1(objProductOld, objProductNew);
        var DT_Lay_1 = await this.validateDT_Lay_1(objProductOld, objProductNew);
        var Ind2 = await this.validateIndLayer2(objProductOld, objProductNew);
        var Grp2 = await this.validateGrpLayer2(objProductOld, objProductNew);
        var DT_Lay_2 = await this.validateDT_Lay_2(objProductOld, objProductNew);


        if (Ind != true && Grp != true && Thick != true && Brd != true &&
            Len != true && Dia != true && Hard != true && Fri != true &&
            Ind1 != true && Grp1 != true && Ind2 != true && Grp2 != true &&
            DT != true && TD != true && LOD != true && PerFine != true &&
            DT_Lay_1 != true && DT_Lay_2 != true)
        {
            return "No Change";
        }
        else {
            var strChanged = "";
            var strNewValue = "";

            //"Individual : Nominal : value,Group : Nominal : value"
            IterateObject(this.objResult, function (value, key1) {
                //console.log(key1);
                strChanged = strChanged + "|";
                strNewValue = strNewValue + "|";

                var obj = value;
                IterateObject(obj, (value, key) => {
                    if ((value.oldValue !== false) && ((value.oldValue !== "") && (value.newValue !== ""))) {
                        strChanged = strChanged + key1 + "-";
                        strChanged = strChanged + key + ":";
                        // if Old Value is NaN then prev that product is not having that parameters hence make it NA
                        strChanged = strChanged + ((value.oldValue == null || value.oldValue == "NaN") ? "NA" : value.oldValue) + ", ";
                        if (strChanged.includes("null:null:null")) {
                            strChanged = strChanged.replace(/null/g, "NA");
                        }

                        strNewValue = strNewValue + key1 + "-";
                        strNewValue = strNewValue + key + ":";
                        strNewValue = strNewValue + ((value.newValue == null || value.newValue == "NaN") ? "NA" : value.newValue) + ", ";
                        if (strNewValue.includes("null:null:null")) {
                            strNewValue = strNewValue.replace(/null/g, "NA");
                        }
                    }

                });
            });

            return { oldData: strChanged.slice(1), newData: strNewValue.slice(1) };
        }
    }

    validateDT_Lay_1(objProductOld, objProductNew) {
        return new Promise((resolve, reject) => {
            const objDT_Lay_1 = {
                DT_Lay_1: {
                    DTTime: { oldValue: "", newValue: "" },
                    DTMinTemp: { oldValue: "", newValue: "" },
                    DTMaxTemp: { oldValue: "", newValue: "" }
                }
            };

            var IsChanged = false;
            var OldEmpty = objProductOld == undefined ? true : false;
            /**
             * For Individual Nom
             */
            if (OldEmpty == true) {
                if (objProductNew.int_DTMMTime_Lay_1 != "" && objProductNew.int_DTMMTime_Lay_1 != undefined) {
                    objDT_Lay_1.DT_Lay_1.DTTime.oldValue = "NA";
                    objDT_Lay_1.DT_Lay_1.DTTime.newValue = objProductNew.int_DTHHTime_Lay_1 + ":" + objProductNew.int_DTMMTime_Lay_1 + ":" + objProductNew.int_DTSSTime_Lay_1;
                    IsChanged = true;
                }
                else {
                    objDT_Lay_1.DT_Lay_1.DTTime.oldValue = false;
                    objDT_Lay_1.DT_Lay_1.DTTime.newValue = false;
                    IsChanged = false;
                }
            }
            else {
                if (objProductOld.Param19_Nom === "" ||
                    objProductOld.Param19_Nom == this.strNullValue ||
                    objProductOld.Param19_Nom == undefined) {
                    objProductOld.Param19_Nom = null;
                }

                if (objProductNew.int_DTHHTime_Lay_1 === "" ||
                    objProductNew.int_DTHHTime_Lay_1 == this.strNullValue ||
                    objProductNew.int_DTHHTime_Lay_1 == undefined) {
                    objProductNew.int_DTHHTime_Lay_1 = null;
                }

                if (objProductNew.int_DTMMTime_Lay_1 === "" ||
                    objProductNew.int_DTMMTime_Lay_1 == this.strNullValue ||
                    objProductNew.int_DTMMTime_Lay_1 == undefined) {
                    objProductNew.int_DTMMTime_Lay_1 = null;
                }

                if (objProductNew.int_DTSSTime_Lay_1 === "" ||
                    objProductNew.int_DTSSTime_Lay_1 == this.strNullValue ||
                    objProductNew.int_DTSSTime_Lay_1 == undefined) {
                    objProductNew.int_DTSSTime_Lay_1 = null;
                }

                if ((objProductOld.Param19_Nom === null) && (objProductNew.int_DTHHTime_Lay_1 === null) && 
                    (objProductNew.int_DTMMTime_Lay_1 === null) && (objProductNew.int_DTSSTime_Lay_1 === null)) {
                        objDT_Lay_1.DT_Lay_1.DTTime.oldValue = false;
                        objDT_Lay_1.DT_Lay_1.DTTime.newValue = false;
                        IsChanged = false;
                }
                else if (objProductOld.Param19_Nom == (objProductNew.int_DTHHTime_Lay_1 + ":" + objProductNew.int_DTMMTime_Lay_1 + ":" + objProductNew.int_DTSSTime_Lay_1)) {
                    objDT_Lay_1.DT_Lay_1.DTTime.oldValue = false;
                    objDT_Lay_1.DT_Lay_1.DTTime.newValue = false;
                    IsChanged = false;
                }
                else {
                    objDT_Lay_1.DT_Lay_1.DTTime.oldValue = objProductOld.Param19_Nom;
                    objDT_Lay_1.DT_Lay_1.DTTime.newValue = objProductNew.int_DTHHTime_Lay_1 + ":" + objProductNew.int_DTMMTime_Lay_1 + ":" + objProductNew.int_DTSSTime_Lay_1;
                    IsChanged = true;
                }
            }

            /**
             * For Individual Nom
             */
            if (OldEmpty == true) {
                if ((objProductNew.flt_DTMinTemp_Lay_1 != "") && (objProductNew.flt_DTMinTemp_Lay_1 != 99999) && objProductNew.flt_DTMinTemp_Lay_1 != undefined) {
                    objDT_Lay_1.DT_Lay_1.DTMinTemp.oldValue = "NA";
                    objDT_Lay_1.DT_Lay_1.DTMinTemp.newValue = objProductNew.flt_DTMinTemp_Lay_1;
                    IsChanged = true;
                }
                else {
                    objDT_Lay_1.DT_Lay_1.DTMinTemp.oldValue = false;
                    objDT_Lay_1.DT_Lay_1.DTMinTemp.newValue = false;
                    IsChanged = false;
                }
            }
            else {
                if (objProductOld.Param19_T1Neg === "" ||
                    objProductOld.Param19_T1Neg == this.strNullValue ||
                    objProductOld.Param19_T1Neg == undefined) {
                    objProductOld.Param19_T1Neg = null;
                }

                if (objProductNew.flt_DTMinTemp_Lay_1 === "" ||
                    objProductNew.flt_DTMinTemp_Lay_1 == this.strNullValue ||
                    objProductNew.flt_DTMinTemp_Lay_1 == undefined) {
                    objProductNew.flt_DTMinTemp_Lay_1 = null;
                }

                if ((objProductOld.Param19_T1Neg !== null) && (objProductNew.flt_DTMinTemp_Lay_1 !== null)) {
                    if (parseFloat(objProductOld.Param19_T1Neg).toFixed(objProductOld.Param19_DP) == parseFloat(objProductNew.flt_DTMinTemp_Lay_1).toFixed(objProductNew.int_DTDp_Lay_1)) {
                        objDT_Lay_1.DT_Lay_1.DTMinTemp.oldValue = false;
                        objDT_Lay_1.DT_Lay_1.DTMinTemp.newValue = false;
                        IsChanged != true ? IsChanged = false : IsChanged = true;

                    } else {
                        objDT_Lay_1.DT_Lay_1.DTMinTemp.oldValue = parseFloat(objProductOld.Param19_T1Neg).toFixed(objProductOld.Param19_DP);
                        objDT_Lay_1.DT_Lay_1.DTMinTemp.newValue = objProductNew.flt_DTMinTemp_Lay_1;
                        IsChanged = true;
                    }

                } else if((objProductOld.Param19_T1Neg == null) && (objProductNew.flt_DTMinTemp_Lay_1 == '99999')){
                    objDT_Lay_1.DT_Lay_1.DTMinTemp.oldValue = false;
                    objDT_Lay_1.DT_Lay_1.DTMinTemp.newValue = false;
                    IsChanged != true ? IsChanged = false : IsChanged = true;

                } else {

                    if ((objProductOld.Param19_T1Neg === null) && (objProductNew.flt_DTMinTemp_Lay_1 !== null)) {
                        objDT_Lay_1.DT_Lay_1.DTMinTemp.oldValue = "NA";
                        objDT_Lay_1.DT_Lay_1.DTMinTemp.newValue = objProductNew.flt_DTMinTemp_Lay_1;
                        IsChanged = true;

                    } else if ((objProductOld.Param19_T1Neg !== null) && (objProductNew.flt_DTMinTemp_Lay_1 === null)) {
                        objDT_Lay_1.DT_Lay_1.DTMinTemp.oldValue = parseFloat(objProductOld.Param19_T1Neg).toFixed(objProductOld.Param19_DP);
                        objDT_Lay_1.DT_Lay_1.DTMinTemp.newValue = "NA";
                        IsChanged = true;
                    }
                }
            }

            /**
             * For Individual Nom
             */
            if (OldEmpty == true) {
                if ((objProductNew.flt_DTMaxTemp_Lay_1 != "") && (objProductNew.flt_DTMaxTemp_Lay_1 != 99999) && objProductNew.flt_DTMaxTemp_Lay_1 != undefined) {
                    objDT_Lay_1.DT_Lay_1.DTMaxTemp.oldValue = "NA";
                    objDT_Lay_1.DT_Lay_1.DTMaxTemp.newValue = objProductNew.flt_DTMaxTemp_Lay_1;
                    IsChanged = true;
                }
                else {
                    objDT_Lay_1.DT_Lay_1.DTMaxTemp.oldValue = false;
                    objDT_Lay_1.DT_Lay_1.DTMaxTemp.newValue = false;
                    IsChanged = false;
                }
            }
            else {
                if (objProductOld.Param19_T1Pos === "" ||
                    objProductOld.Param19_T1Pos == this.strNullValue ||
                    objProductOld.Param19_T1Pos == undefined) {
                    objProductOld.Param19_T1Pos = null;
                }

                if (objProductNew.flt_DTMaxTemp_Lay_1 === "" ||
                    objProductNew.flt_DTMaxTemp_Lay_1 == this.strNullValue ||
                    objProductNew.flt_DTMaxTemp_Lay_1 == undefined) {
                    objProductNew.flt_DTMaxTemp_Lay_1 = null;
                }

                if ((objProductOld.Param19_T1Pos !== null) && (objProductNew.flt_DTMaxTemp_Lay_1 !== null)) {
                    if (parseFloat(objProductOld.Param19_T1Pos).toFixed(objProductOld.Param19_DP) == parseFloat(objProductNew.flt_DTMaxTemp_Lay_1).toFixed(objProductNew.int_DTDp_Lay_1)) {
                        objDT_Lay_1.DT_Lay_1.DTMaxTemp.oldValue = false;
                        objDT_Lay_1.DT_Lay_1.DTMaxTemp.newValue = false;
                        IsChanged != true ? IsChanged = false : IsChanged = true;

                    } else {
                        objDT_Lay_1.DT_Lay_1.DTMaxTemp.oldValue = parseFloat(objProductOld.Param19_T1Pos).toFixed(objProductOld.Param19_DP);
                        objDT_Lay_1.DT_Lay_1.DTMaxTemp.newValue = objProductNew.flt_DTMaxTemp_Lay_1;
                        IsChanged = true;                        
                    }

                } else if((objProductOld.Param19_T1Pos == null) && (objProductNew.flt_DTMaxTemp_Lay_1 == '99999')){
                    objDT_Lay_1.DT_Lay_1.DTMaxTemp.oldValue = false;
                    objDT_Lay_1.DT_Lay_1.DTMaxTemp.newValue = false;
                    IsChanged != true ? IsChanged = false : IsChanged = true;

                } else {

                    if ((objProductOld.Param19_T1Pos === null) && (objProductNew.flt_DTMaxTemp_Lay_1 !== null)) {
                        objDT_Lay_1.DT_Lay_1.DTMaxTemp.oldValue = "NA";
                        objDT_Lay_1.DT_Lay_1.DTMaxTemp.newValue = objProductNew.flt_DTMaxTemp_Lay_1;
                        IsChanged = true;

                    } else if ((objProductOld.Param19_T1Pos !== null) && (objProductNew.flt_DTMaxTemp_Lay_1 === null)) {
                        objDT_Lay_1.DT_Lay_1.DTMaxTemp.oldValue = parseFloat(objProductOld.Param19_T1Pos).toFixed(objProductOld.Param19_DP);
                        objDT_Lay_1.DT_Lay_1.DTMaxTemp.newValue = "NA";
                        IsChanged = true;
                    }
                }
            }
    
            if (IsChanged == true) {
                Object.assign(this.objResult, objDT_Lay_1);
            }
            resolve(IsChanged);
        });
    }

    validateDT_Lay_2(objProductOld, objProductNew) {
        return new Promise((resolve, reject) => {
            const objDT_Lay_2 = {
                DT_Lay_2: {
                    DTTime: { oldValue: "", newValue: "" },
                    DTMinTemp: { oldValue: "", newValue: "" },
                    DTMaxTemp: { oldValue: "", newValue: "" }
                }
            };

            var IsChanged = false;
            var OldEmpty = objProductOld == undefined ? true : false;
            /**
             * For Individual Nom
             */
            if (OldEmpty == true) {
                if (objProductNew.int_DTMMTime_Lay_2 != "" && objProductNew.int_DTMMTime_Lay_2 != undefined) {
                    objDT_Lay_2.DT_Lay_2.DTTime.oldValue = "NA";
                    objDT_Lay_2.DT_Lay_2.DTTime.newValue = objProductNew.int_DTHHTime_Lay_2 + ":" + objProductNew.int_DTMMTime_Lay_2 + ":" + objProductNew.int_DTSSTime_Lay_2;
                    IsChanged = true;
                }
                else {
                    objDT_Lay_2.DT_Lay_2.DTTime.oldValue = false;
                    objDT_Lay_2.DT_Lay_2.DTTime.newValue = false;
                    IsChanged = false;
                }
            }
            else {
                if (objProductOld.Param20_Nom === "" ||
                    objProductOld.Param20_Nom == this.strNullValue ||
                    objProductOld.Param20_Nom == undefined) {
                    objProductOld.Param20_Nom = null;
                }
    
                if (objProductNew.int_DTHHTime_Lay_2 === "" ||
                    objProductNew.int_DTHHTime_Lay_2 == this.strNullValue ||
                    objProductNew.int_DTHHTime_Lay_2 == undefined) {
                    objProductNew.int_DTHHTime_Lay_2 = null;
                }
    
                if (objProductNew.int_DTMMTime_Lay_2 === "" ||
                    objProductNew.int_DTMMTime_Lay_2 == this.strNullValue ||
                    objProductNew.int_DTMMTime_Lay_2 == undefined) {
                    objProductNew.int_DTMMTime_Lay_2 = null;
                }
    
                if (objProductNew.int_DTSSTime_Lay_2 === "" ||
                    objProductNew.int_DTSSTime_Lay_2 == this.strNullValue ||
                    objProductNew.int_DTSSTime_Lay_2 == undefined) {
                    objProductNew.int_DTSSTime_Lay_2 = null;
                }

                if ((objProductOld.Param20_Nom === null) && (objProductNew.int_DTHHTime_Lay_2 === null) && 
                    (objProductNew.int_DTMMTime_Lay_2 === null) && (objProductNew.int_DTSSTime_Lay_2 === null)) {
                        objDT_Lay_2.DT_Lay_2.DTTime.oldValue = false;
                        objDT_Lay_2.DT_Lay_2.DTTime.newValue = false;
                        IsChanged = false;
                }
                else if (objProductOld.Param20_Nom == (objProductNew.int_DTHHTime_Lay_2 + ":" + objProductNew.int_DTMMTime_Lay_2 + ":" + objProductNew.int_DTSSTime_Lay_2)) {
                    objDT_Lay_2.DT_Lay_2.DTTime.oldValue = false;
                    objDT_Lay_2.DT_Lay_2.DTTime.newValue = false;
                    IsChanged = false;
                }
                else {
                    objDT_Lay_2.DT_Lay_2.DTTime.oldValue = objProductOld.Param20_Nom;
                    objDT_Lay_2.DT_Lay_2.DTTime.newValue = objProductNew.int_DTHHTime_Lay_2 + ":" + objProductNew.int_DTMMTime_Lay_2 + ":" + objProductNew.int_DTSSTime_Lay_2;
                    IsChanged = true;
                }
            }
    
            /**
             * For Individual Nom
             */
            if (OldEmpty == true) {
                if ((objProductNew.flt_DTMinTemp_Lay_2 != "") && (objProductNew.flt_DTMinTemp_Lay_2 != 99999) && objProductNew.flt_DTMinTemp_Lay_2 != undefined) {
                    objDT_Lay_2.DT_Lay_2.DTMinTemp.oldValue = "NA";
                    objDT_Lay_2.DT_Lay_2.DTMinTemp.newValue = objProductNew.flt_DTMinTemp_Lay_2;
                    IsChanged = true;
                }
                else {
                    objDT_Lay_2.DT_Lay_2.DTMinTemp.oldValue = false;
                    objDT_Lay_2.DT_Lay_2.DTMinTemp.newValue = false;
                    IsChanged = false;
                }
            }
            else {
                if (objProductOld.Param20_T1Neg === "" ||
                    objProductOld.Param20_T1Neg == this.strNullValue ||
                    objProductOld.Param20_T1Neg == undefined) {
                    objProductOld.Param20_T1Neg = null;
                }
    
                if (objProductNew.flt_DTMinTemp_Lay_2 === "" ||
                    objProductNew.flt_DTMinTemp_Lay_2 == this.strNullValue ||
                    objProductNew.flt_DTMinTemp_Lay_2 == undefined) {
                    objProductNew.flt_DTMinTemp_Lay_2 = null;
                }

                if ((objProductOld.Param20_T1Neg !== null) && (objProductNew.flt_DTMinTemp_Lay_2 !== null)) {
                    if (parseFloat(objProductOld.Param20_T1Neg).toFixed(objProductOld.Param20_DP) == parseFloat(objProductNew.flt_DTMinTemp_Lay_2).toFixed(objProductNew.int_DTDp_Lay_2)) {
                        objDT_Lay_2.DT_Lay_2.DTMinTemp.oldValue = false;
                        objDT_Lay_2.DT_Lay_2.DTMinTemp.newValue = false;
                        IsChanged != true ? IsChanged = false : IsChanged = true;

                    } else {
                        objDT_Lay_2.DT_Lay_2.DTMinTemp.oldValue = parseFloat(objProductOld.Param20_T1Neg).toFixed(objProductOld.Param20_DP);
                        objDT_Lay_2.DT_Lay_2.DTMinTemp.newValue = objProductNew.flt_DTMinTemp_Lay_2;
                        IsChanged = true;                        
                    }

                } else if((objProductOld.Param20_T1Neg == null) && (objProductNew.flt_DTMinTemp_Lay_2 == '99999')){
                    objDT_Lay_2.DT_Lay_2.DTMinTemp.oldValue = false;
                    objDT_Lay_2.DT_Lay_2.DTMinTemp.newValue = false;
                    IsChanged != true ? IsChanged = false : IsChanged = true;

                } else {

                    if ((objProductOld.Param20_T1Neg === null) && (objProductNew.flt_DTMinTemp_Lay_2 !== null)) {
                        objDT_Lay_2.DT_Lay_2.DTMinTemp.oldValue = "NA";
                        objDT_Lay_2.DT_Lay_2.DTMinTemp.newValue = objProductNew.flt_DTMinTemp_Lay_2;
                        IsChanged = true;

                    } else if ((objProductOld.Param20_T1Neg !== null) && (objProductNew.flt_DTMinTemp_Lay_2 === null)) {
                        objDT_Lay_2.DT_Lay_2.DTMinTemp.oldValue = parseFloat(objProductOld.Param20_T1Neg).toFixed(objProductOld.Param20_DP);
                        objDT_Lay_2.DT_Lay_2.DTMinTemp.newValue = "NA";
                        IsChanged = true;
                    }
                }
            }
    
            /**
             * For Individual Nom
             */
            if (OldEmpty == true) {
                if ((objProductNew.flt_DTMaxTemp_Lay_2 != "") && (objProductNew.flt_DTMaxTemp_Lay_2 != 99999) && objProductNew.flt_DTMaxTemp_Lay_2 != undefined) {
                    objDT_Lay_2.DT_Lay_2.DTMaxTemp.oldValue = "NA";
                    objDT_Lay_2.DT_Lay_2.DTMaxTemp.newValue = objProductNew.flt_DTMaxTemp_Lay_2;
                    IsChanged = true;
                }
                else {
                    objDT_Lay_2.DT_Lay_2.DTMaxTemp.oldValue = false;
                    objDT_Lay_2.DT_Lay_2.DTMaxTemp.newValue = false;
                    IsChanged = false;
                }
            }
            else {
                if (objProductOld.Param20_T1Pos === "" ||
                    objProductOld.Param20_T1Pos == this.strNullValue ||
                    objProductOld.Param20_T1Pos == undefined) {
                    objProductOld.Param20_T1Pos = null;
                }
    
                if (objProductNew.flt_DTMaxTemp_Lay_2 === "" ||
                    objProductNew.flt_DTMaxTemp_Lay_2 == this.strNullValue ||
                    objProductNew.flt_DTMaxTemp_Lay_2 == undefined) {
                    objProductNew.flt_DTMaxTemp_Lay_2 = null;
                }

                if ((objProductOld.Param20_T1Pos !== null) && (objProductNew.flt_DTMaxTemp_Lay_2 !== null)) {
                    if (parseFloat(objProductOld.Param20_T1Pos).toFixed(objProductOld.Param20_DP) == parseFloat(objProductNew.flt_DTMaxTemp_Lay_2).toFixed(objProductNew.int_DTDp_Lay_2)) {
                        objDT_Lay_2.DT_Lay_2.DTMaxTemp.oldValue = false;
                        objDT_Lay_2.DT_Lay_2.DTMaxTemp.newValue = false;
                        IsChanged != true ? IsChanged = false : IsChanged = true;

                    } else {
                        objDT_Lay_2.DT_Lay_2.DTMaxTemp.oldValue = parseFloat(objProductOld.Param20_T1Pos).toFixed(objProductOld.Param20_DP);
                        objDT_Lay_2.DT_Lay_2.DTMaxTemp.newValue = objProductNew.flt_DTMaxTemp_Lay_2;
                        IsChanged = true;
                    }

                } else if((objProductOld.Param20_T1Pos == null) && (objProductNew.flt_DTMaxTemp_Lay_2 == '99999')){
                    objDT_Lay_2.DT_Lay_2.DTMaxTemp.oldValue = false;
                    objDT_Lay_2.DT_Lay_2.DTMaxTemp.newValue = false;
                    IsChanged != true ? IsChanged = false : IsChanged = true;

                } else {

                    if ((objProductOld.Param20_T1Pos === null) && (objProductNew.flt_DTMaxTemp_Lay_2 !== null)) {
                        objDT_Lay_2.DT_Lay_2.DTMaxTemp.oldValue = "NA";
                        objDT_Lay_2.DT_Lay_2.DTMaxTemp.newValue = objProductNew.flt_DTMaxTemp_Lay_2;
                        IsChanged = true;

                    } else if ((objProductOld.Param20_T1Pos !== null) && (objProductNew.flt_DTMaxTemp_Lay_2 === null)) {
                        objDT_Lay_2.DT_Lay_2.DTMaxTemp.oldValue = parseFloat(objProductOld.Param20_T1Pos).toFixed(objProductOld.Param20_DP);
                        objDT_Lay_2.DT_Lay_2.DTMaxTemp.newValue = "NA";
                        IsChanged = true;
                    }
                }
            }
    
            if (IsChanged == true) {
                Object.assign(this.objResult, objDT_Lay_2);
            }
            resolve(IsChanged);
        });
    }

}

module.exports = ValidateProductCompressed;