var IterateObject = require("iterate-object");
const date = require('date-and-time');
const Database = require('../database/clsQueryProcess');
const database = new Database();

class Yield {
    /**
     * This function will send the Product Details of the Given Area
     * @param {} obj : {area: Name of Area}
     */
    async getProductDetail(obj) {
        try {

            var objProductDetail = {
                str_tableName: '',
                data: 'distinct BFGCode,ProductName,PVersion,Version',
                condition: [
                    { str_colName: 'CubicleType', value: obj.area, comp: 'eq' },
                    { str_colName: 'BatchComplete', value: 1, comp: 'eq' },
                ]
            }

            if (obj.area == "Compression" || obj.area == "Coating") {
                objProductDetail.str_tableName = "tbl_tab_master1";
            }
            else {
                objProductDetail.str_tableName = "tbl_cap_master1";
            }

            var resObjProductDetail = await database.select(objProductDetail);

            return resObjProductDetail[0];

        } catch (err) {
            throw new Error(err);
        }
    }

    async getBatchOfProduct(objProduct) {
        try {
            var objSelectBatch = {
                str_tableName: '',
                data: 'distinct BatchNo',
                condition: [
                    { str_colName: 'BFGCode', value: objProduct.BFGCode, comp: 'eq' },
                    { str_colName: 'ProductName', value: objProduct.ProductName, comp: 'eq' },
                    { str_colName: 'PVersion', value: objProduct.PVersion, comp: 'eq' },
                    { str_colName: 'Version', value: objProduct.Version, comp: 'eq' },
                    { str_colName: 'CubicleType', value: objProduct.Area, comp: 'eq' },
                    { str_colName: 'BatchComplete', value: 1, comp: 'eq' }
                ]
            }

            if (objProduct.Area == "Compression" || objProduct.Area == "Coating") {
                objSelectBatch.str_tableName = "tbl_tab_master1";
            }
            else {
                objSelectBatch.str_tableName = "tbl_cap_master1";
            }

            var resObjSelectBatch = await database.select(objSelectBatch);

            return resObjSelectBatch[0];
        } catch (error) {
            throw new Error(err);
        }
    }

    async getYieldDataSP(objProductNBatch) {
        try {
            var objYieldData = {
                str_SPName: 'reportCalculationForYield',
                str_InParameter:
                    "'" + objProductNBatch.BFGCode + "','"
                    + objProductNBatch.ProductName + "','"
                    + objProductNBatch.PVersion + "','"
                    + objProductNBatch.Version + "','"
                    + objProductNBatch.Area + "','"
                    + objProductNBatch.BatchNo + "'"

                ,
                str_OutParameter:
                    "@standardWeight,@averageWeightIndividual,@averageWeightGroup," +
                    "@theoraticalYield,@batch_NLT,@batch_NMT," +
                    "@YC_NLT,@YC_NMT,@averageWeightNet,@averageWeightNetComp,@averageWeightIndividualComp",
            }

            var resObjYieldData = await database.selectSp(objYieldData);
            return resObjYieldData[0][1];

        } catch (error) {
            return error;
        }
    }

    async getYieldData(objProdNBatch) {

        var resYield = await this.getYieldDataSP(objProdNBatch);

        var returnObj = {
            StandardWT: resYield[0]['@standardWeight'] == null ? 0 : resYield[0]['@standardWeight'],
            AvgVal: resYield[0]['@averageWeightIndividual'] == null ? 0 : resYield[0]['@averageWeightIndividual'],
            AvgValComp: resYield[0]['@averageWeightIndividualComp'] == null ? 0 : resYield[0]['@averageWeightIndividualComp'], // for coating 
            AvgNetBin: resYield[0]['@averageWeightNet'] == null ? 0 : resYield[0]['@averageWeightNet'],//resNetWeight.NetAvg
            AvgNetBinComp: resYield[0]['@averageWeightNetComp'] == null ? 0 : resYield[0]['@averageWeightNetComp'],//resNetWeight.NetAvg
            AvgGroup: resYield[0]['@averageWeightGroup'] == null ? 0 : resYield[0]['@averageWeightGroup'],
            Batch_NLT: resYield[0]['@batch_NLT'] == null ? 0 : resYield[0]['@batch_NLT'],
            Batch_NMT: resYield[0]['@batch_NMT'] == null ? 0 : resYield[0]['@batch_NMT'],
            theoraticalYield: resYield[0]['@theoraticalYield'] == null ? 0 : resYield[0]['@theoraticalYield'],
            YC_NLT: resYield[0]['@YC_NLT'] == null ? 0 : resYield[0]['@YC_NLT'],
            YC_NMT: resYield[0]['@YC_NMT'] == null ? 0 : resYield[0]['@YC_NMT']
        };

        /**done on 08/07/2020 get data from master table */

        const obj_getDataFromYieldMaster = {
            str_tableName: "tbl_yield_report_master",
            data: "*",
            condition: [
                { str_colName: "BFGCode", value: objProdNBatch.BFGCode },
                { str_colName: "ProductName", value: objProdNBatch.ProductName },
                { str_colName: "PVersion", value: objProdNBatch.PVersion },
                { str_colName: "Version", value: objProdNBatch.Version },
                { str_colName: "CubicleType", value: objProdNBatch.Area },
                { str_colName: "BatchNo", value: objProdNBatch.BatchNo }
            ]
        }

        let resultMaster = await database.select(obj_getDataFromYieldMaster);

        //returnObj;
        return { result: returnObj, data: resultMaster[0] };
    }

    async saveYieldData(objSaveData) {
        try {
            var now = new Date();
            var objSaveMasterData = {
                str_tableName: 'tbl_yield_report_master',
                data: [
                    { str_colName: 'BFGCode', value: objSaveData.BFGCode },
                    { str_colName: 'ProductName', value: objSaveData.ProductName },
                    { str_colName: 'PVersion', value: objSaveData.PVersion },
                    { str_colName: 'Version', value: objSaveData.Version },
                    { str_colName: 'CubicleType', value: objSaveData.cubicalType },
                    { str_colName: 'selectedYield', value: objSaveData.selectedYield },
                    { str_colName: 'BatchNo', value: objSaveData.batch },
                    { str_colName: 'UserId', value: objSaveData.UserId },
                    { str_colName: 'UserName', value: objSaveData.UserName },
                    { str_colName: 'DecimalPoint', value: objSaveData.DecimalPoint },
                    { str_colName: 'PrintNo', value: 0 },
                    { str_colName: 'DoneBy_Date', value: date.format(now, 'YYYY-MM-DD') },
                    { str_colName: 'DoneBy_Time', value: date.format(now, 'HH:mm:ss') }
                ]
            }

            var objMaster = await database.save(objSaveMasterData, true);

            var objSaveDetailData = {
                str_tableName: 'tbl_yield_report_detail',
                data: [
                    { str_colName: 'RepSerNo', value: objSaveData.RepSerNo },
                    { str_colName: 'TheoreticalYield_KG_1', value: await this.insertDefault(objSaveData.TheoreticalYield_KG_1) },
                    { str_colName: 'TheoreticalYield_GM_1', value: await this.insertDefault(objSaveData.TheoreticalYield_GM_1) },
                    { str_colName: 'TheoreticalYield_NOS_1', value: await this.insertDefault(objSaveData.TheoreticalYield_NOS_1) },
                    { str_colName: 'TheoreticalYield_P_1', value: await this.insertDefault(objSaveData.TheoreticalYield_P_1) },

                    { str_colName: 'AverageWeight_KG_2', value: await this.insertDefault(objSaveData.AverageWeight_KG_2) },
                    { str_colName: 'AverageWeight_GM_2', value: await this.insertDefault(objSaveData.AverageWeight_GM_2) },
                    { str_colName: 'AverageWeight_NOS_2', value: await this.insertDefault(objSaveData.AverageWeight_NOS_2) },
                    { str_colName: 'AverageWeight_P_2', value: await this.insertDefault(objSaveData.AverageWeight_P_2) },

                    { str_colName: 'ActualWeightFirstLayer_KG_19', value: await this.insertDefault(objSaveData.ActualWeightFirstLayer_KG_19) },
                    { str_colName: 'ActualWeightFirstLayer_GM_19', value: await this.insertDefault(objSaveData.ActualWeightFirstLayer_GM_19) },
                    { str_colName: 'ActualWeightFirstLayer_NOS_19', value: await this.insertDefault(objSaveData.ActualWeightFirstLayer_NOS_19) },
                    { str_colName: 'ActualWeightFirstLayer_P_19', value: await this.insertDefault(objSaveData.ActualWeightFirstLayer_P_19) },

                    { str_colName: 'ActualWeightSecondLayer_KG_20', value: await this.insertDefault(objSaveData.ActualWeightSecondLayer_KG_20) },
                    { str_colName: 'ActualWeightSecondLayer_GM_20', value: await this.insertDefault(objSaveData.ActualWeightSecondLayer_GM_20) },
                    { str_colName: 'ActualWeightSecondLayer_NOS_20', value: await this.insertDefault(objSaveData.ActualWeightSecondLayer_NOS_20) },
                    { str_colName: 'ActualWeightSecondLayer_P_20', value: await this.insertDefault(objSaveData.ActualWeightSecondLayer_P_20) },

                    { str_colName: 'YieldOfLubricatedGranules_KG_3', value: await this.insertDefault(objSaveData.YieldOfLubricatedGranules_KG_3) },
                    { str_colName: 'YieldOfLubricatedGranules_GM_3', value: await this.insertDefault(objSaveData.YieldOfLubricatedGranules_GM_3) },
                    { str_colName: 'YieldOfLubricatedGranules_NOS_3', value: await this.insertDefault(objSaveData.YieldOfLubricatedGranules_NOS_3) },
                    { str_colName: 'YieldOfLubricatedGranules_P_3', value: await this.insertDefault(objSaveData.YieldOfLubricatedGranules_P_3) },

                    { str_colName: 'YieldOfCompressed_KG_4', value: await this.insertDefault(objSaveData.YieldOfCompressed_KG_4) },
                    { str_colName: 'YieldOfCompressed_GM_4', value: await this.insertDefault(objSaveData.YieldOfCompressed_GM_4) },
                    { str_colName: 'YieldOfCompressed_NOS_4', value: await this.insertDefault(objSaveData.YieldOfCompressed_NOS_4) },
                    { str_colName: 'YieldOfCompressed_P_4', value: await this.insertDefault(objSaveData.YieldOfCompressed_P_4) },

                    { str_colName: 'YieldOfCompressedNLT', value: objSaveData.YieldOfCompressedNLT },
                    { str_colName: 'YieldOfCoated_KG_5', value: await this.insertDefault(objSaveData.YieldOfCoated_KG_5) },
                    { str_colName: 'YieldOfCoated_GM_5', value: await this.insertDefault(objSaveData.YieldOfCoated_GM_5) },
                    { str_colName: 'YieldOfCoated_NOS_5', value: await this.insertDefault(objSaveData.YieldOfCoated_NOS_5) },

                    { str_colName: 'YieldOfCoated_P_5', value: await this.insertDefault(objSaveData.YieldOfCoated_P_5) },
                    { str_colName: 'YieldOfCoatedNLT', value: objSaveData.YieldOfCoatedNLT },
                    { str_colName: 'YieldOfCapsule_KG_6', value: await this.insertDefault(objSaveData.YieldOfCapsule_KG_6) },
                    { str_colName: 'YieldOfCapsule_GM_6', value: await this.insertDefault(objSaveData.YieldOfCapsule_GM_6) },

                    { str_colName: 'YieldOfCapsule_NOS_6', value: await this.insertDefault(objSaveData.YieldOfCapsule_NOS_6) },
                    { str_colName: 'YieldOfCapsule_P_6', value: await this.insertDefault(objSaveData.YieldOfCapsule_P_6) },
                    { str_colName: 'YieldOfCapsuleNLT', value: objSaveData.YieldOfCapsuleNLT },
                    { str_colName: 'SampleQuantityInProcess_KG_7', value: await this.insertDefault(objSaveData.SampleQuantityInProcess_KG_7) },

                    { str_colName: 'SampleQuantityInProcess_GM_7', value: await this.insertDefault(objSaveData.SampleQuantityInProcess_GM_7) },
                    { str_colName: 'SampleQuantityInProcess_NOS_7', value: await this.insertDefault(objSaveData.SampleQuantityInProcess_NOS_7) },
                    { str_colName: 'SampleQuantityInProcess_P_7', value: await Number(objSaveData.SampleQuantityInProcess_P_7).toFixed(2) },
                    { str_colName: 'SampleQuantityQualityControl_KG_8', value: await this.insertDefault(objSaveData.SampleQuantityQualityControl_KG_8) },

                    { str_colName: 'SampleQuantityQualityControl_GM_8', value: await this.insertDefault(objSaveData.SampleQuantityQualityControl_GM_8) },
                    { str_colName: 'SampleQuantityQualityControl_NOS_8', value: await this.insertDefault(objSaveData.SampleQuantityQualityControl_NOS_8) },
                    { str_colName: 'SampleQuantityQualityControl_P_8', value: await Number(objSaveData.SampleQuantityQualityControl_P_8).toFixed(2) },
                    { str_colName: 'ValidationSamples_KG_9', value: await this.insertDefault(objSaveData.ValidationSamples_KG_9) },

                    { str_colName: 'ValidationSamples_GM_9', value: await this.insertDefault(objSaveData.ValidationSamples_GM_9) },
                    { str_colName: 'ValidationSamples_NOS_9', value: await this.insertDefault(objSaveData.ValidationSamples_NOS_9) },
                    { str_colName: 'ValidationSamples_P_9', value: await Number(objSaveData.ValidationSamples_P_9).toFixed(2) },
                    { str_colName: 'YieldIncudingSample_KG_15', value: await this.insertDefault(objSaveData.YieldIncudingSample_KG_15) },

                    { str_colName: 'YieldIncudingSample_GM_15', value: await this.insertDefault(objSaveData.YieldIncudingSample_GM_15) },
                    { str_colName: 'YieldIncudingSample_NOS_15', value: await this.insertDefault(objSaveData.YieldIncudingSample_NOS_15) },
                    { str_colName: 'YieldIncudingSample_P_15', value: await this.insertDefault(objSaveData.YieldIncudingSample_P_15) },
                    { str_colName: 'Rejects_KG_10', value: await this.insertDefault(objSaveData.Rejects_KG_10) },

                    { str_colName: 'Rejects_GM_10', value: await this.insertDefault(objSaveData.Rejects_GM_10) },
                    { str_colName: 'Rejects_NOS_10', value: await this.insertDefault(objSaveData.Rejects_NOS_10) },
                    { str_colName: 'Rejects_P_10', value: await this.insertDefault(objSaveData.Rejects_P_10) },
                    { str_colName: 'ResidualRejects_KG_11', value: await this.insertDefault(objSaveData.ResidualRejects_KG_11) },

                    { str_colName: 'ResidualRejects_GM_11', value: await this.insertDefault(objSaveData.ResidualRejects_GM_11) },
                    { str_colName: 'ResidualRejects_NOS_11', value: await this.insertDefault(objSaveData.ResidualRejects_NOS_11) },
                    { str_colName: 'ResidualRejects_P_11', value: await this.insertDefault(objSaveData.ResidualRejects_P_11) },
                    { str_colName: 'TotalAccounted_KG_12', value: await this.insertDefault(objSaveData.TotalAccounted_KG_12) },

                    { str_colName: 'TotalAccounted_GM_12', value: await this.insertDefault(objSaveData.TotalAccounted_GM_12) },
                    { str_colName: 'TotalAccounted_NOS_12', value: await this.insertDefault(objSaveData.TotalAccounted_NOS_12) },
                    { str_colName: 'TotalAccounted_P_12', value: await this.insertDefault(objSaveData.TotalAccounted_P_12) },
                    { str_colName: 'UnaccountedLoss_KG_13', value: await this.insertDefault(objSaveData.UnaccountedLoss_KG_13) },

                    { str_colName: 'UnaccountedLoss_GM_13', value: await this.insertDefault(objSaveData.UnaccountedLoss_GM_13) },
                    { str_colName: 'UnaccountedLoss_NOS_13', value: await this.insertDefault(objSaveData.UnaccountedLoss_NOS_13) },
                    { str_colName: 'UnaccountedLoss_P_13', value: await this.insertDefault(objSaveData.UnaccountedLoss_P_13) },
                    { str_colName: 'TotalLoss_KG_14', value: await this.insertDefault(objSaveData.TotalLoss_KG_14) },

                    { str_colName: 'TotalLoss_GM_14', value: await this.insertDefault(objSaveData.TotalLoss_GM_14) },
                    { str_colName: 'TotalLoss_NOS_14', value: await this.insertDefault(objSaveData.TotalLoss_NOS_14) },
                    { str_colName: 'TotalLoss_P_14', value: await this.insertDefault(objSaveData.TotalLoss_P_14) },
                    { str_colName: 'TotalLossNMT', value: objSaveData.TotalLossNMT },

                    { str_colName: 'SampleQuantityInProcess_KG_16', value: await this.insertDefault(objSaveData.SampleQuantityInProcess_KG_16) },
                    { str_colName: 'SampleQuantityInProcess_GM_16', value: await this.insertDefault(objSaveData.SampleQuantityInProcess_GM_16) },
                    { str_colName: 'SampleQuantityInProcess_NOS_16', value: await this.insertDefault(objSaveData.SampleQuantityInProcess_NOS_16) },
                    { str_colName: 'SampleQuantityInProcess_P_16', value: await this.insertDefault(objSaveData.SampleQuantityInProcess_P_16) },

                    { str_colName: 'SampleQuantityQualityControl_KG_17', value: await this.insertDefault(objSaveData.SampleQuantityQualityControl_KG_17) },
                    { str_colName: 'SampleQuantityQualityControl_GM_17', value: await this.insertDefault(objSaveData.SampleQuantityQualityControl_GM_17) },
                    { str_colName: 'SampleQuantityQualityControl_NOS_17', value: await this.insertDefault(objSaveData.SampleQuantityQualityControl_NOS_17) },
                    { str_colName: 'SampleQuantityQualityControl_P_17', value: await this.insertDefault(objSaveData.SampleQuantityQualityControl_P_17) },

                    { str_colName: 'ValidationSamples_KG_18', value: await this.insertDefault(objSaveData.ValidationSamples_KG_18) },
                    { str_colName: 'ValidationSamples_GM_18', value: await this.insertDefault(objSaveData.ValidationSamples_GM_18) },
                    { str_colName: 'ValidationSamples_NOS_18', value: await this.insertDefault(objSaveData.ValidationSamples_NOS_18) },
                    { str_colName: 'ValidationSamples_P_18', value: await this.insertDefault(objSaveData.ValidationSamples_P_18) },
                ]
            }

            var objDetail = await database.save(objSaveDetailData, true);

            var objectTransaction = {
                Query1: objMaster.Qry,
                Value1: objMaster.values,
                Query2: objDetail.Qry,
                Value2: objDetail.values
            }

            var dbRes = await database.saveSP(objectTransaction);

            return { result: "Success" };
        } catch (error) {
            return error;
        }
    }
    async insertDefault(val){
        try{
            var num = Number(val);
            var str_num = '-';
            if(isNaN(val)===false) 
            {
                if(num === 0){
                    return str_num; // Pure Number
                }else{
                    return val; // Number but with special char like +,-
                }
            }
            else
            {
                if(val === "NA"){
                    return str_num; // for NA
                }else{
                    return val; // Number but with special char like +,-
                }
            }
        }catch(error){
            return '-';
        }
    }
    async getProductsFromMaster(objArea) {
        try {

            var objProduct = {
                str_tableName: "tbl_yield_report_master",
                //data: 'distinct BFGCode,ProductName,PVersion,Version,BatchNo,PrintNo,selectedYield,RepSerNo',
                data: 'distinct BFGCode,ProductName,PVersion,Version',
                condition: [
                    { str_colName: 'CubicleType', value: objArea.area }
                ]
            }

            var resProduct = await database.select(objProduct);

            return resProduct[0];

        } catch (error) {
            return error;
        }
    }

    async getBatchesFromMaster(objProduct) {
        try {
            var objSelectBatch = {
                str_tableName: 'tbl_yield_report_master',
                data: 'distinct BatchNo,PrintNo,selectedYield,RepSerNo',
                condition: [
                    { str_colName: 'BFGCode', value: objProduct.BFGCode, comp: 'eq' },
                    { str_colName: 'ProductName', value: objProduct.ProductName, comp: 'eq' },
                    { str_colName: 'PVersion', value: objProduct.PVersion, comp: 'eq' },
                    { str_colName: 'Version', value: objProduct.Version, comp: 'eq' }
                ]
            }
            var resObjSelectBatch = await database.select(objSelectBatch);
            return resObjSelectBatch[0];
        } catch (error) {
            throw new Error(error);
        }
    }

   
    async checkYieldReportIsVerified(objReport) 
    {
        const obj_getVerfication = {
            str_tableName: "tbl_yield_report_master",
            data: "*",
            condition:[
                {str_colName:"RepSerNo", value: objReport.body.RepSerNo}
            ]
        }

        let res = await database.select(obj_getVerfication);
        return res[0][0];

    }

    async verifyReportYield(req)
    {
        try {
            var now = new Date();

            const obj_update = {
                str_tableName: "tbl_yield_report_master",
                data: [
                    {str_colName:"CheckedByID", value: req.body.CheckedByID},
                    {str_colName:"CheckedByName", value: req.body.CheckedByName},
                    { str_colName: 'CheckedByDate', value: date.format(now, 'YYYY-MM-DD') },
                    { str_colName: 'CheckedByTime', value: date.format(now, 'HH:mm:ss') },
                ],
                condition: [
                    {str_colName:"RepSerNo", value: req.body.RepSerNo}
                ]
            }

            let res = await database.update(obj_update);
            return res;

        } catch (error) {
            return error;
        }
    }

}
module.exports = Yield;