const express = require('express');
const router = express.Router();
const balance = require('../controller/balanceController');

router.get('/getBalance', balance.getBalance);
router.get('/getBalanceDetails', balance.getBalanceDetails);
router.post('/addBalance', balance.storeBalance);
router.put('/updateBalanceLock', balance.updateBalanceLock);
router.put('/updateBalance', balance.updateBalance);
router.post('/updateActiveDeactive', balance.updateActiveDeactive);
router.post('/releaseRejectBalance', balance.releaseRejectBalance);
router.post('/checkInCubicle', balance.checkInCubicle);
router.get('/getBalList_DisallowToEditBalIfRoutineCalbPending', balance.getBalList_DisallowToEditBalIfRoutineCalbPending);

/***** Balance with no calibration are below ***********/
 router.post('/addBalanceNoCalib', balance.addBalanceNoCalib);
 router.post('/updateBalanceNoCalib', balance.updateBalanceNoCalib);

module.exports = router;