const express = require('express')
const router = express.Router();
const BatchController = require('../controller/batchController');

//Separate Batch Summary
router.get('/getAreaFromCubicleType', BatchController.getAreaFromCubicleType);
router.post('/generateAllPdf', BatchController.generateAllPdf); 
router.post('/getCubiclenamebatchsummary', BatchController.getCubiclenamebatchsummary);

//Separate Batch Summary
router.post('/getProduct', BatchController.getProduct);
router.post('/getBatches', BatchController.getBatches);
router.post('/getPrintNo', BatchController.getPrintNo);
router.post('/storeBatchTempData', BatchController.storeBatchTempData);
router.post('/getMPR',BatchController.getMPR);

//Combine batch summary 
router.post('/getProductAll', BatchController.getProductAll);
router.post('/getBatchesAll', BatchController.getBatchesAll);
router.post('/getPrintNoAll', BatchController.getPrintNoAll);
router.post('/storeBatchTempDataAll', BatchController.storeBatchTempDataAll);
router.post('/printcountupSummaryAll', BatchController.increasePrintCountSummaryAll); 

//Product Summary
router.post('/ProductSummary_getProductParameterWise', BatchController.ProductSummary_getProductParameterWise);
router.post('/ProductSummary_getPrintNo', BatchController.ProductSummary_getPrintNo);
router.post('/storeProductTempData', BatchController.storeProductTempData);
router.post('/printcountupProductSummary', BatchController.printcountupProductSummary); 

module.exports = router;