const express = require('express')
const router = express.Router();
const deptController = require('../controller/deptController');

router.get('/getDepartments', deptController.getDepartments)
router.get('/getDepartmentsForAuditTrail', deptController.getDepartmentsForAuditTrail)
router.post('/pdf', deptController.jasperdemo)
router.post('/addDepartment', deptController.storeDepartment)
router.put('/editDepartment', deptController.updateDepartment)
router.put('/updateDeptLockStatus', deptController.updateDeptLockStatus)
router.post('/assignedToCubicleManageUSer',deptController.assignedToCubicleManageUSer)
router.get('/getDepartmentsAudit', deptController.getDepartmentsAudit)

module.exports = router;