const express = require('express');
const router = express.Router();
const tabletCapsuleController = require('../controller/tabletCapsuleController');

router.post('/printReasonReport', tabletCapsuleController.printReasonReport);
router.post('/checkReportIsVerified', tabletCapsuleController.checkReportIsVerified);
router.post('/verifyreport', tabletCapsuleController.verifyReport);
router.post('/verifyExceptionReport', tabletCapsuleController.verifyExceptionReport);
router.post('/printcountup', tabletCapsuleController.increasePrintCount);

/* Start For Seprate Reports Only */
router.post('/getWeighmentReportDetails', tabletCapsuleController.getWeighmentReportDetails);
router.post('/viewSeparateReport',tabletCapsuleController.viewSeparateReport);
router.post('/getWeighmentReportDetails_StartUp', tabletCapsuleController.getWeighmentReportDetails_StartUp);
router.post('/viewSeparateReport_Startup', tabletCapsuleController.viewSeparateReport_Startup);
/* End For Seprate Reports Only */

/* Start For Consolidated Reports Only */
router.post('/getWeighmentReportDetails_Consolidated', tabletCapsuleController.getWeighmentReportDetails_Consolidated);
router.post('/viewConsolidateReport',tabletCapsuleController.viewConsolidateReport);
/* End For Consolidated Reports Only */

/* Exception API */
router.post('/viewExceptionRpt',tabletCapsuleController.viewExceptionRpt);


module.exports = router;