<!-- Note: This file is automatically generated from source code comments. Changes made in this file will be overridden. -->

# Function compareText

Compare two strings lexically. Comparison is case sensitive.
Returns 1 when x > y, -1 when x < y, and 0 when x == y.

For matrices, the function is evaluated element wise.


## Syntax

```js
math.compareText(x, y)
```

### Parameters

Parameter | Type | Description
--------- | ---- | -----------
`x` | string &#124; Array &#124; DenseMatrix | First string to compare
`y` | string &#124; Array &#124; DenseMatrix | Second string to compare

### Returns

Type | Description
---- | -----------
number &#124; Array &#124; DenseMatrix | Returns the result of the comparison: 1 when x > y, -1 when x < y, and 0 when x == y.


## Examples

```js
math.compareText('B', 'A')     // returns 1
math.compareText('2', '10')    // returns 1
math.compare('2', '10')        // returns -1
math.compareNatural('2', '10') // returns -1

math.compareText('B', ['A', 'B', 'C']) // returns [1, 0, -1]
```


## See also

[equal](equal.md),
[equalText](equalText.md),
[compare](compare.md),
[compareNatural](compareNatural.md)
