// `AbortSignal`,`AbortController` are defined here to prevent a dependency on the `dom` library which disagrees with node runtime.
// The definition for `AbortSignal` is taken from @types/node-fetch (https://github.com/DefinitelyTyped/DefinitelyTyped) for
// maximal compatibility with node-fetch.
// Original node-fetch definitions are under MIT License.

export class AbortSignal {
    aborted: boolean;

    addEventListener: (type: "abort", listener: ((this: AbortSignal, event: any) => any), options?: boolean | {
        capture?: boolean,
        once?: boolean,
        passive?: boolean
    }) => void;

    removeEventListener: (type: "abort", listener: ((this: AbortSignal, event: any) => any), options?: boolean | {
        capture?: boolean
    }) => void;

    dispatchEvent: (event: any) => boolean;

    onabort: null | ((this: AbortSignal, event: any) => void);
}

export default class AbortController {
	signal:AbortSignal;
	abort() :void;
}

