/*
 * Decompiled with CFR 0.152.
 */
package oracle.toplink.essentials.internal.ejb.cmp3.xml.sequencing;

import java.util.HashMap;
import java.util.Iterator;
import oracle.toplink.essentials.descriptors.ClassDescriptor;
import oracle.toplink.essentials.exceptions.ValidationException;
import oracle.toplink.essentials.internal.ejb.cmp3.metadata.MetadataHelper;
import oracle.toplink.essentials.internal.ejb.cmp3.xml.TableInfo;
import oracle.toplink.essentials.internal.ejb.cmp3.xml.sequencing.Id;
import oracle.toplink.essentials.internal.ejb.cmp3.xml.sequencing.SequenceGenerator;
import oracle.toplink.essentials.internal.ejb.cmp3.xml.sequencing.TableGenerator;
import oracle.toplink.essentials.internal.helper.DatabaseField;
import oracle.toplink.essentials.internal.helper.DatabaseTable;
import oracle.toplink.essentials.sequencing.NativeSequence;
import oracle.toplink.essentials.sequencing.QuerySequence;
import oracle.toplink.essentials.sequencing.Sequence;
import oracle.toplink.essentials.sequencing.TableSequence;
import oracle.toplink.essentials.sessions.DatasourceLogin;

public class SequencingProcessor {
    public static final String AUTO = "AUTO";
    public static final String IDENTITY = "IDENTITY";
    public static final String NONE = "NONE";
    public static final String TABLE = "TABLE";
    public static final String SEQUENCE = "SEQUENCE";
    public static final String DEFAULT_AUTO_GENERATOR = "SEQ_GEN";
    public static final String DEFAULT_TABLE_GENERATOR = "SEQ_GEN_TABLE";
    public static final String DEFAULT_SEQUENCE_GENERATOR = "SEQ_GEN_SEQUENCE";
    private HashMap sequenceGenerators;
    private HashMap tableGenerators = new HashMap();
    private HashMap ids;

    public SequencingProcessor() {
        this.sequenceGenerators = new HashMap();
        this.ids = new HashMap();
    }

    public void preProcessTableGenerator(TableGenerator tableGenerator) {
        if (tableGenerator == null) {
            return;
        }
        String generatorName = tableGenerator.name();
        if (generatorName.equals(DEFAULT_SEQUENCE_GENERATOR)) {
            throw ValidationException.reservedName("objectUsingReservedName", DEFAULT_SEQUENCE_GENERATOR, "correctType");
        }
        TableGenerator otherTableGenerator = (TableGenerator)this.tableGenerators.get(generatorName);
        if (otherTableGenerator != null && otherTableGenerator.equals(tableGenerator)) {
            return;
        }
        Iterator tableGeneratorIt = this.tableGenerators.values().iterator();
        while (tableGeneratorIt.hasNext()) {
            this.checkForConflict((TableGenerator)tableGeneratorIt.next(), tableGenerator);
        }
        Iterator sequenceGeneratorIt = this.sequenceGenerators.values().iterator();
        while (sequenceGeneratorIt.hasNext()) {
            this.checkForConflict((SequenceGenerator)sequenceGeneratorIt.next(), tableGenerator);
        }
        this.tableGenerators.put(generatorName, tableGenerator);
    }

    public void preProcessSequenceGenerator(SequenceGenerator sequenceGenerator) {
        if (sequenceGenerator == null) {
            return;
        }
        String generatorName = sequenceGenerator.name();
        if (generatorName.equals(DEFAULT_TABLE_GENERATOR)) {
            throw ValidationException.reservedName("objectUsingReservedName", DEFAULT_TABLE_GENERATOR, "correctType");
        }
        SequenceGenerator otherSequenceGenerator = (SequenceGenerator)this.sequenceGenerators.get(generatorName);
        if (otherSequenceGenerator != null && otherSequenceGenerator.equals(sequenceGenerator)) {
            return;
        }
        Iterator sequenceGeneratorIt = this.sequenceGenerators.values().iterator();
        while (sequenceGeneratorIt.hasNext()) {
            this.checkForConflict((SequenceGenerator)sequenceGeneratorIt.next(), sequenceGenerator);
        }
        Iterator tableGeneratorIt = this.tableGenerators.values().iterator();
        while (tableGeneratorIt.hasNext()) {
            this.checkForConflict((TableGenerator)tableGeneratorIt.next(), sequenceGenerator);
        }
        this.sequenceGenerators.put(generatorName, sequenceGenerator);
    }

    public void preProcessId(Id id, DatabaseField field, ClassDescriptor descriptor) {
        if (id == null) {
            return;
        }
        String generatorType = id.strategy();
        String generatorName = id.generator();
        if (generatorType.equals(AUTO)) {
            if (generatorName.equals("")) {
                return;
            }
            throw ValidationException.idAnnotationCannotSpecifyGenerator("annotation", generatorType.toString());
        }
        Id otherId = (Id)this.ids.get(descriptor);
        if (otherId != null) {
            this.throwConflictException(id, otherId);
        }
        if (generatorType.equals(AUTO) && !generatorName.equals("")) {
            throw ValidationException.idAnnotationCannotSpecifyGenerator("annotation", generatorType.toString());
        }
        descriptor.setSequenceNumberField(field);
        Iterator idIt = this.ids.values().iterator();
        while (idIt.hasNext()) {
            this.checkForConflict((Id)idIt.next(), id);
        }
        this.ids.put(descriptor, id);
    }

    public void process(DatasourceLogin login) {
        String seqName;
        if (this.ids.isEmpty()) {
            return;
        }
        for (Id id : this.ids.values()) {
            TableGenerator tableGenerator;
            String type = id.strategy();
            String generatorName = id.generator();
            if (type.equals(TABLE)) {
                SequenceGenerator sequenceGenerator = (SequenceGenerator)this.sequenceGenerators.get(generatorName);
                if (sequenceGenerator == null) continue;
                this.throwConflictException(id, sequenceGenerator);
                continue;
            }
            if (!type.equals(SEQUENCE) && !type.equals(IDENTITY) || (tableGenerator = (TableGenerator)this.tableGenerators.get(generatorName)) == null) continue;
            this.throwConflictException(id, tableGenerator);
        }
        QuerySequence defaultAutoSequence = null;
        NativeSequence defaultNativeSequence = new NativeSequence(DEFAULT_SEQUENCE_GENERATOR);
        TableSequence defaultTableSequence = new TableSequence(DEFAULT_TABLE_GENERATOR);
        HashMap<String, QuerySequence> sequences = new HashMap<String, QuerySequence>();
        for (SequenceGenerator sequenceGenerator : this.sequenceGenerators.values()) {
            String sequenceGeneratorName = sequenceGenerator.name();
            seqName = sequenceGenerator.sequenceName().equals("") ? sequenceGeneratorName : sequenceGenerator.sequenceName();
            NativeSequence sequence = new NativeSequence(seqName, sequenceGenerator.allocationSize());
            sequences.put(sequenceGeneratorName, sequence);
            if (sequenceGeneratorName.equals(DEFAULT_AUTO_GENERATOR)) {
                defaultAutoSequence = sequence;
                continue;
            }
            if (!sequenceGeneratorName.equals(DEFAULT_SEQUENCE_GENERATOR)) continue;
            defaultNativeSequence = sequence;
        }
        for (TableGenerator tableGenerator : this.tableGenerators.values()) {
            String tableGeneratorName = tableGenerator.name();
            seqName = tableGenerator.pkColumnValue().equals("") ? tableGeneratorName : tableGenerator.pkColumnValue();
            TableSequence sequence = new TableSequence(seqName, tableGenerator.allocationSize());
            sequences.put(tableGeneratorName, sequence);
            TableInfo table = tableGenerator.table();
            if (table.specified()) {
                sequence.setTable(new DatabaseTable(MetadataHelper.getFullyQualifiedTableName(table.getTableName(), sequence.getTableName(), table.getCatalog(), table.getSchema())));
            }
            if (!tableGenerator.pkColumnName().equals("")) {
                sequence.setNameFieldName(tableGenerator.pkColumnName());
            }
            if (!tableGenerator.valueColumnName().equals("")) {
                sequence.setCounterFieldName(tableGenerator.valueColumnName());
            }
            if (tableGeneratorName.equals(DEFAULT_AUTO_GENERATOR)) {
                defaultAutoSequence = sequence;
                continue;
            }
            if (!tableGeneratorName.equals(DEFAULT_TABLE_GENERATOR)) continue;
            defaultTableSequence = sequence;
        }
        for (ClassDescriptor descriptor : this.ids.keySet()) {
            Id id = (Id)this.ids.get(descriptor);
            String generatorName = id.generator();
            Sequence sequence = null;
            if (!generatorName.equals("")) {
                sequence = (Sequence)sequences.get(generatorName);
            }
            if (sequence == null) {
                if (id.strategy().equals(TABLE)) {
                    if (generatorName.equals("")) {
                        sequence = defaultTableSequence;
                    } else {
                        sequence = (Sequence)defaultTableSequence.clone();
                        sequence.setName(generatorName);
                    }
                } else if (id.strategy().equals(SEQUENCE) || id.strategy().equals(IDENTITY)) {
                    if (generatorName.equals("")) {
                        sequence = defaultNativeSequence;
                    } else {
                        sequence = (Sequence)defaultNativeSequence.clone();
                        sequence.setName(generatorName);
                    }
                }
            }
            if (sequence != null) {
                descriptor.setSequenceNumberName(sequence.getName());
                login.addSequence(sequence);
                continue;
            }
            if (id.strategy().equals(AUTO)) {
                if (defaultAutoSequence != null) {
                    descriptor.setSequenceNumberName(defaultAutoSequence.getName());
                    login.setDefaultSequence(defaultAutoSequence);
                    continue;
                }
                descriptor.setSequenceNumberName(DEFAULT_AUTO_GENERATOR);
                continue;
            }
            assert (false);
        }
    }

    void checkForConflict(TableGenerator obj1, TableGenerator obj2) {
        boolean sequenceConflict;
        boolean nameConflict = obj1.name().equals(obj2.name());
        boolean tableConflict = obj1.table().equals(obj2.table()) && (!obj1.pkColumnName().equals(obj2.pkColumnName()) || !obj1.valueColumnName().equals(obj2.valueColumnName()));
        boolean bl = sequenceConflict = obj1.pkColumnValue().equals(obj2.pkColumnValue()) && (obj1.initialValue() != obj2.initialValue() || obj1.allocationSize() != obj2.allocationSize());
        if (nameConflict || sequenceConflict || tableConflict) {
            this.throwConflictException(obj1, obj2);
        }
    }

    void checkForConflict(SequenceGenerator obj1, SequenceGenerator obj2) {
        boolean sequenceConflict;
        boolean nameConflict = obj1.name().equals(obj2.name());
        boolean bl = sequenceConflict = obj1.sequenceName().equals(obj2.sequenceName()) && obj1.allocationSize() != obj2.allocationSize();
        if (nameConflict || sequenceConflict) {
            this.throwConflictException(obj1, obj2);
        }
    }

    void checkForConflict(SequenceGenerator obj1, TableGenerator obj2) {
        this.checkForConflict(obj2, obj1);
    }

    void checkForConflict(TableGenerator obj1, SequenceGenerator obj2) {
        boolean nameConflict = obj1.name().equals(obj2.name());
        boolean sequenceConflict = obj1.pkColumnValue().equals(obj2.sequenceName());
        if (nameConflict || sequenceConflict) {
            this.throwConflictException(obj1, obj2);
        }
    }

    void checkForConflict(Id obj1, Id obj2) {
        String type2;
        if (!obj1.generator().equals(obj2.generator())) {
            return;
        }
        if (obj1.generator().equals("")) {
            return;
        }
        String type1 = obj1.strategy();
        if (type1.equals(type2 = obj2.strategy())) {
            return;
        }
        if (type1.equals(IDENTITY) && type2.equals(SEQUENCE) || type2.equals(IDENTITY) && type1.equals(SEQUENCE)) {
            return;
        }
        this.throwConflictException(obj1, obj2);
    }

    void throwConflictException(Object obj1, Object obj2) {
        throw ValidationException.annotationsConflict(obj1.toString(), obj2.toString());
    }
}

