/*
 * Decompiled with CFR 0.152.
 */
package oracle.toplink.essentials.internal.queryframework;

import java.lang.reflect.Constructor;
import java.util.Comparator;
import oracle.toplink.essentials.exceptions.QueryException;
import oracle.toplink.essentials.internal.queryframework.CollectionContainerPolicy;
import oracle.toplink.essentials.internal.security.PrivilegedAccessController;

public class SortedCollectionContainerPolicy
extends CollectionContainerPolicy {
    protected Comparator m_comparator = null;

    public SortedCollectionContainerPolicy() {
    }

    public SortedCollectionContainerPolicy(Class containerClass) {
        super(containerClass);
    }

    public void setComparator(Comparator comparator) {
        this.m_comparator = comparator;
    }

    public Comparator getComparator() {
        return this.m_comparator;
    }

    public Object containerInstance() {
        try {
            if (this.m_comparator != null) {
                Object[] arguments = new Object[]{this.m_comparator};
                Class[] constructClass = new Class[]{Comparator.class};
                Constructor constructor = PrivilegedAccessController.getConstructorFor(this.getContainerClass(), constructClass, false);
                return PrivilegedAccessController.invokeConstructor(constructor, arguments);
            }
            return PrivilegedAccessController.newInstanceFromClass(this.getContainerClass());
        }
        catch (Exception ex) {
            throw QueryException.couldNotInstantiateContainerClass(this.getContainerClass(), ex);
        }
    }
}

