/*
 * Decompiled with CFR 0.152.
 */
package LineChartCustomizer;

import java.awt.Font;
import java.awt.Shape;
import java.awt.geom.Ellipse2D;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import net.sf.jasperreports.engine.JRAbstractChartCustomizer;
import net.sf.jasperreports.engine.JRChart;
import net.sf.jasperreports.engine.fill.JRBaseFiller;
import net.sf.jasperreports.engine.fill.JRFillChart;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.axis.DateAxis;
import org.jfree.chart.axis.ValueAxis;
import org.jfree.chart.labels.CategoryItemLabelGenerator;
import org.jfree.chart.labels.ItemLabelAnchor;
import org.jfree.chart.labels.ItemLabelPosition;
import org.jfree.chart.labels.StandardCategoryItemLabelGenerator;
import org.jfree.chart.plot.CategoryPlot;
import org.jfree.chart.renderer.category.AbstractCategoryItemRenderer;
import org.jfree.ui.TextAnchor;
import org.jfree.util.ShapeUtilities;

public class LineChartCustomizer
extends JRAbstractChartCustomizer {
    private JRFillChart fillChart;

    public void init(JRBaseFiller chartFiller, JRFillChart chart) {
        super.init(chartFiller, chart);
        this.fillChart = chart;
    }

    public void customize(JFreeChart chart, JRChart jasperChart) {
        AbstractCategoryItemRenderer renderer = (AbstractCategoryItemRenderer)chart.getCategoryPlot().getRenderer();
        Shape upTriangle = ShapeUtilities.createUpTriangle((float)1.0f);
        Shape downTriangle = ShapeUtilities.createDownTriangle((float)1.0f);
        Shape dgnCrossTriangle = ShapeUtilities.createDiagonalCross((float)0.5f, (float)0.5f);
        Ellipse2D.Double circle = new Ellipse2D.Double(-1.5, -1.5, 3.0, 3.0);
        renderer.setSeriesShape(0, (Shape)circle);
        renderer.setSeriesShape(1, dgnCrossTriangle);
        renderer.setBasePositiveItemLabelPosition(new ItemLabelPosition(ItemLabelAnchor.CENTER, TextAnchor.CENTER));
        renderer.setBaseNegativeItemLabelPosition(new ItemLabelPosition(ItemLabelAnchor.CENTER, TextAnchor.TOP_LEFT));
        CategoryPlot plot = (CategoryPlot)chart.getPlot();
        DateAxis rangeAxis = new DateAxis("Disintegration Time");
        rangeAxis.setInverted(true);
        plot.setRangeAxis((ValueAxis)rangeAxis);
        Font fuenteEjes = new Font("Calibri", 0, 8);
        rangeAxis.setLabelFont(fuenteEjes);
        renderer.setBaseItemLabelGenerator((CategoryItemLabelGenerator)new StandardCategoryItemLabelGenerator("{2}", (DateFormat)new SimpleDateFormat("mm:ss")));
        ItemLabelPosition position = new ItemLabelPosition(ItemLabelAnchor.OUTSIDE12, TextAnchor.TOP_CENTER);
        renderer.setBasePositiveItemLabelPosition(position);
    }
}

